// RUN: llvm-mc -arch=amdgcn -mcpu=gfx940 -show-encoding %s | FileCheck -check-prefix=GFX940 %s

scratch_load_dword a2, v4, s6
// GFX940: scratch_load_dword a2, v4, s6           ; encoding: [0x00,0x60,0x50,0xdc,0x04,0x00,0x86,0x02]

scratch_load_dword a2, v4, s6 offset:16
// GFX940: scratch_load_dword a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x50,0xdc,0x04,0x00,0x86,0x02]

scratch_load_dword a2, v4, off
// GFX940: scratch_load_dword a2, v4, off          ; encoding: [0x00,0x60,0x50,0xdc,0x04,0x00,0xff,0x02]

scratch_load_dword a2, v4, off offset:16
// GFX940: scratch_load_dword a2, v4, off offset:16 ; encoding: [0x10,0x60,0x50,0xdc,0x04,0x00,0xff,0x02]

scratch_load_dword a2, off, s6
// GFX940: scratch_load_dword a2, off, s6          ; encoding: [0x00,0x40,0x50,0xdc,0x00,0x00,0x86,0x02]

scratch_load_dword a2, off, s6 offset:16
// GFX940: scratch_load_dword a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x50,0xdc,0x00,0x00,0x86,0x02]

scratch_load_dword a2, off, off
// GFX940: scratch_load_dword a2, off, off         ; encoding: [0x00,0x40,0x50,0xdc,0x00,0x00,0xff,0x02]

scratch_load_dword a2, off, off offset:16
// GFX940: scratch_load_dword a2, off, off offset:16 ; encoding: [0x10,0x40,0x50,0xdc,0x00,0x00,0xff,0x02]

scratch_load_dword v2, v4, s6
// GFX940: scratch_load_dword v2, v4, s6           ; encoding: [0x00,0x60,0x50,0xdc,0x04,0x00,0x06,0x02]

scratch_load_dword v2, v4, s6 offset:16
// GFX940: scratch_load_dword v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x50,0xdc,0x04,0x00,0x06,0x02]

scratch_load_dword v2, v4, off
// GFX940: scratch_load_dword v2, v4, off          ; encoding: [0x00,0x60,0x50,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_dword v2, v4, off offset:16
// GFX940: scratch_load_dword v2, v4, off offset:16 ; encoding: [0x10,0x60,0x50,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_dword v2, off, s6
// GFX940: scratch_load_dword v2, off, s6          ; encoding: [0x00,0x40,0x50,0xdc,0x00,0x00,0x06,0x02]

scratch_load_dword v2, off, s6 offset:16
// GFX940: scratch_load_dword v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x50,0xdc,0x00,0x00,0x06,0x02]

scratch_load_dword v2, off, off
// GFX940: scratch_load_dword v2, off, off         ; encoding: [0x00,0x40,0x50,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_dword v2, off, off offset:16
// GFX940: scratch_load_dword v2, off, off offset:16 ; encoding: [0x10,0x40,0x50,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_dwordx2 a[2:3], v4, s6
// GFX940: scratch_load_dwordx2 a[2:3], v4, s6     ; encoding: [0x00,0x60,0x54,0xdc,0x04,0x00,0x86,0x02]

scratch_load_dwordx2 a[2:3], v4, s6 offset:16
// GFX940: scratch_load_dwordx2 a[2:3], v4, s6 offset:16 ; encoding: [0x10,0x60,0x54,0xdc,0x04,0x00,0x86,0x02]

scratch_load_dwordx2 a[2:3], v4, off
// GFX940: scratch_load_dwordx2 a[2:3], v4, off    ; encoding: [0x00,0x60,0x54,0xdc,0x04,0x00,0xff,0x02]

scratch_load_dwordx2 a[2:3], v4, off offset:16
// GFX940: scratch_load_dwordx2 a[2:3], v4, off offset:16 ; encoding: [0x10,0x60,0x54,0xdc,0x04,0x00,0xff,0x02]

scratch_load_dwordx2 a[2:3], off, s6
// GFX940: scratch_load_dwordx2 a[2:3], off, s6    ; encoding: [0x00,0x40,0x54,0xdc,0x00,0x00,0x86,0x02]

scratch_load_dwordx2 a[2:3], off, s6 offset:16
// GFX940: scratch_load_dwordx2 a[2:3], off, s6 offset:16 ; encoding: [0x10,0x40,0x54,0xdc,0x00,0x00,0x86,0x02]

scratch_load_dwordx2 a[2:3], off, off
// GFX940: scratch_load_dwordx2 a[2:3], off, off   ; encoding: [0x00,0x40,0x54,0xdc,0x00,0x00,0xff,0x02]

scratch_load_dwordx2 a[2:3], off, off offset:16
// GFX940: scratch_load_dwordx2 a[2:3], off, off offset:16 ; encoding: [0x10,0x40,0x54,0xdc,0x00,0x00,0xff,0x02]

scratch_load_dwordx2 v[2:3], v4, s6
// GFX940: scratch_load_dwordx2 v[2:3], v4, s6     ; encoding: [0x00,0x60,0x54,0xdc,0x04,0x00,0x06,0x02]

scratch_load_dwordx2 v[2:3], v4, s6 offset:16
// GFX940: scratch_load_dwordx2 v[2:3], v4, s6 offset:16 ; encoding: [0x10,0x60,0x54,0xdc,0x04,0x00,0x06,0x02]

scratch_load_dwordx2 v[2:3], v4, off
// GFX940: scratch_load_dwordx2 v[2:3], v4, off    ; encoding: [0x00,0x60,0x54,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_dwordx2 v[2:3], v4, off offset:16
// GFX940: scratch_load_dwordx2 v[2:3], v4, off offset:16 ; encoding: [0x10,0x60,0x54,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_dwordx2 v[2:3], off, s6
// GFX940: scratch_load_dwordx2 v[2:3], off, s6    ; encoding: [0x00,0x40,0x54,0xdc,0x00,0x00,0x06,0x02]

scratch_load_dwordx2 v[2:3], off, s6 offset:16
// GFX940: scratch_load_dwordx2 v[2:3], off, s6 offset:16 ; encoding: [0x10,0x40,0x54,0xdc,0x00,0x00,0x06,0x02]

scratch_load_dwordx2 v[2:3], off, off
// GFX940: scratch_load_dwordx2 v[2:3], off, off   ; encoding: [0x00,0x40,0x54,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_dwordx2 v[2:3], off, off offset:16
// GFX940: scratch_load_dwordx2 v[2:3], off, off offset:16 ; encoding: [0x10,0x40,0x54,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_dwordx3 a[2:4], v4, s6
// GFX940: scratch_load_dwordx3 a[2:4], v4, s6     ; encoding: [0x00,0x60,0x58,0xdc,0x04,0x00,0x86,0x02]

scratch_load_dwordx3 a[2:4], v4, s6 offset:16
// GFX940: scratch_load_dwordx3 a[2:4], v4, s6 offset:16 ; encoding: [0x10,0x60,0x58,0xdc,0x04,0x00,0x86,0x02]

scratch_load_dwordx3 a[2:4], v4, off
// GFX940: scratch_load_dwordx3 a[2:4], v4, off    ; encoding: [0x00,0x60,0x58,0xdc,0x04,0x00,0xff,0x02]

scratch_load_dwordx3 a[2:4], v4, off offset:16
// GFX940: scratch_load_dwordx3 a[2:4], v4, off offset:16 ; encoding: [0x10,0x60,0x58,0xdc,0x04,0x00,0xff,0x02]

scratch_load_dwordx3 a[2:4], off, s6
// GFX940: scratch_load_dwordx3 a[2:4], off, s6    ; encoding: [0x00,0x40,0x58,0xdc,0x00,0x00,0x86,0x02]

scratch_load_dwordx3 a[2:4], off, s6 offset:16
// GFX940: scratch_load_dwordx3 a[2:4], off, s6 offset:16 ; encoding: [0x10,0x40,0x58,0xdc,0x00,0x00,0x86,0x02]

scratch_load_dwordx3 a[2:4], off, off
// GFX940: scratch_load_dwordx3 a[2:4], off, off   ; encoding: [0x00,0x40,0x58,0xdc,0x00,0x00,0xff,0x02]

scratch_load_dwordx3 a[2:4], off, off offset:16
// GFX940: scratch_load_dwordx3 a[2:4], off, off offset:16 ; encoding: [0x10,0x40,0x58,0xdc,0x00,0x00,0xff,0x02]

scratch_load_dwordx3 v[2:4], v4, s6
// GFX940: scratch_load_dwordx3 v[2:4], v4, s6     ; encoding: [0x00,0x60,0x58,0xdc,0x04,0x00,0x06,0x02]

scratch_load_dwordx3 v[2:4], v4, s6 offset:16
// GFX940: scratch_load_dwordx3 v[2:4], v4, s6 offset:16 ; encoding: [0x10,0x60,0x58,0xdc,0x04,0x00,0x06,0x02]

scratch_load_dwordx3 v[2:4], v4, off
// GFX940: scratch_load_dwordx3 v[2:4], v4, off    ; encoding: [0x00,0x60,0x58,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_dwordx3 v[2:4], v4, off offset:16
// GFX940: scratch_load_dwordx3 v[2:4], v4, off offset:16 ; encoding: [0x10,0x60,0x58,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_dwordx3 v[2:4], off, s6
// GFX940: scratch_load_dwordx3 v[2:4], off, s6    ; encoding: [0x00,0x40,0x58,0xdc,0x00,0x00,0x06,0x02]

scratch_load_dwordx3 v[2:4], off, s6 offset:16
// GFX940: scratch_load_dwordx3 v[2:4], off, s6 offset:16 ; encoding: [0x10,0x40,0x58,0xdc,0x00,0x00,0x06,0x02]

scratch_load_dwordx3 v[2:4], off, off
// GFX940: scratch_load_dwordx3 v[2:4], off, off   ; encoding: [0x00,0x40,0x58,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_dwordx3 v[2:4], off, off offset:16
// GFX940: scratch_load_dwordx3 v[2:4], off, off offset:16 ; encoding: [0x10,0x40,0x58,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_dwordx4 a[2:5], v4, s6
// GFX940: scratch_load_dwordx4 a[2:5], v4, s6     ; encoding: [0x00,0x60,0x5c,0xdc,0x04,0x00,0x86,0x02]

scratch_load_dwordx4 a[2:5], v4, s6 offset:16
// GFX940: scratch_load_dwordx4 a[2:5], v4, s6 offset:16 ; encoding: [0x10,0x60,0x5c,0xdc,0x04,0x00,0x86,0x02]

scratch_load_dwordx4 a[2:5], v4, off
// GFX940: scratch_load_dwordx4 a[2:5], v4, off    ; encoding: [0x00,0x60,0x5c,0xdc,0x04,0x00,0xff,0x02]

scratch_load_dwordx4 a[2:5], v4, off offset:16
// GFX940: scratch_load_dwordx4 a[2:5], v4, off offset:16 ; encoding: [0x10,0x60,0x5c,0xdc,0x04,0x00,0xff,0x02]

scratch_load_dwordx4 a[2:5], off, s6
// GFX940: scratch_load_dwordx4 a[2:5], off, s6    ; encoding: [0x00,0x40,0x5c,0xdc,0x00,0x00,0x86,0x02]

scratch_load_dwordx4 a[2:5], off, s6 offset:16
// GFX940: scratch_load_dwordx4 a[2:5], off, s6 offset:16 ; encoding: [0x10,0x40,0x5c,0xdc,0x00,0x00,0x86,0x02]

scratch_load_dwordx4 a[2:5], off, off
// GFX940: scratch_load_dwordx4 a[2:5], off, off   ; encoding: [0x00,0x40,0x5c,0xdc,0x00,0x00,0xff,0x02]

scratch_load_dwordx4 a[2:5], off, off offset:16
// GFX940: scratch_load_dwordx4 a[2:5], off, off offset:16 ; encoding: [0x10,0x40,0x5c,0xdc,0x00,0x00,0xff,0x02]

scratch_load_dwordx4 v[2:5], v4, s6
// GFX940: scratch_load_dwordx4 v[2:5], v4, s6     ; encoding: [0x00,0x60,0x5c,0xdc,0x04,0x00,0x06,0x02]

scratch_load_dwordx4 v[2:5], v4, s6 offset:16
// GFX940: scratch_load_dwordx4 v[2:5], v4, s6 offset:16 ; encoding: [0x10,0x60,0x5c,0xdc,0x04,0x00,0x06,0x02]

scratch_load_dwordx4 v[2:5], v4, off
// GFX940: scratch_load_dwordx4 v[2:5], v4, off    ; encoding: [0x00,0x60,0x5c,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_dwordx4 v[2:5], v4, off offset:16
// GFX940: scratch_load_dwordx4 v[2:5], v4, off offset:16 ; encoding: [0x10,0x60,0x5c,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_dwordx4 v[2:5], off, s6
// GFX940: scratch_load_dwordx4 v[2:5], off, s6    ; encoding: [0x00,0x40,0x5c,0xdc,0x00,0x00,0x06,0x02]

scratch_load_dwordx4 v[2:5], off, s6 offset:16
// GFX940: scratch_load_dwordx4 v[2:5], off, s6 offset:16 ; encoding: [0x10,0x40,0x5c,0xdc,0x00,0x00,0x06,0x02]

scratch_load_dwordx4 v[2:5], off, off
// GFX940: scratch_load_dwordx4 v[2:5], off, off   ; encoding: [0x00,0x40,0x5c,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_dwordx4 v[2:5], off, off offset:16
// GFX940: scratch_load_dwordx4 v[2:5], off, off offset:16 ; encoding: [0x10,0x40,0x5c,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_sbyte a2, v4, s6
// GFX940: scratch_load_sbyte a2, v4, s6           ; encoding: [0x00,0x60,0x44,0xdc,0x04,0x00,0x86,0x02]

scratch_load_sbyte a2, v4, s6 offset:16
// GFX940: scratch_load_sbyte a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x44,0xdc,0x04,0x00,0x86,0x02]

scratch_load_sbyte a2, v4, off
// GFX940: scratch_load_sbyte a2, v4, off          ; encoding: [0x00,0x60,0x44,0xdc,0x04,0x00,0xff,0x02]

scratch_load_sbyte a2, v4, off offset:16
// GFX940: scratch_load_sbyte a2, v4, off offset:16 ; encoding: [0x10,0x60,0x44,0xdc,0x04,0x00,0xff,0x02]

scratch_load_sbyte a2, off, s6
// GFX940: scratch_load_sbyte a2, off, s6          ; encoding: [0x00,0x40,0x44,0xdc,0x00,0x00,0x86,0x02]

scratch_load_sbyte a2, off, s6 offset:16
// GFX940: scratch_load_sbyte a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x44,0xdc,0x00,0x00,0x86,0x02]

scratch_load_sbyte a2, off, off
// GFX940: scratch_load_sbyte a2, off, off         ; encoding: [0x00,0x40,0x44,0xdc,0x00,0x00,0xff,0x02]

scratch_load_sbyte a2, off, off offset:16
// GFX940: scratch_load_sbyte a2, off, off offset:16 ; encoding: [0x10,0x40,0x44,0xdc,0x00,0x00,0xff,0x02]

scratch_load_sbyte v2, v4, s6
// GFX940: scratch_load_sbyte v2, v4, s6           ; encoding: [0x00,0x60,0x44,0xdc,0x04,0x00,0x06,0x02]

scratch_load_sbyte v2, v4, s6 offset:16
// GFX940: scratch_load_sbyte v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x44,0xdc,0x04,0x00,0x06,0x02]

scratch_load_sbyte v2, v4, off
// GFX940: scratch_load_sbyte v2, v4, off          ; encoding: [0x00,0x60,0x44,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_sbyte v2, v4, off offset:16
// GFX940: scratch_load_sbyte v2, v4, off offset:16 ; encoding: [0x10,0x60,0x44,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_sbyte v2, off, s6
// GFX940: scratch_load_sbyte v2, off, s6          ; encoding: [0x00,0x40,0x44,0xdc,0x00,0x00,0x06,0x02]

scratch_load_sbyte v2, off, s6 offset:16
// GFX940: scratch_load_sbyte v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x44,0xdc,0x00,0x00,0x06,0x02]

scratch_load_sbyte v2, off, off
// GFX940: scratch_load_sbyte v2, off, off         ; encoding: [0x00,0x40,0x44,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_sbyte v2, off, off offset:16
// GFX940: scratch_load_sbyte v2, off, off offset:16 ; encoding: [0x10,0x40,0x44,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_sbyte_d16 a2, v4, s6
// GFX940: scratch_load_sbyte_d16 a2, v4, s6       ; encoding: [0x00,0x60,0x88,0xdc,0x04,0x00,0x86,0x02]

scratch_load_sbyte_d16 a2, v4, s6 offset:16
// GFX940: scratch_load_sbyte_d16 a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x88,0xdc,0x04,0x00,0x86,0x02]

scratch_load_sbyte_d16 a2, v4, off
// GFX940: scratch_load_sbyte_d16 a2, v4, off      ; encoding: [0x00,0x60,0x88,0xdc,0x04,0x00,0xff,0x02]

scratch_load_sbyte_d16 a2, v4, off offset:16
// GFX940: scratch_load_sbyte_d16 a2, v4, off offset:16 ; encoding: [0x10,0x60,0x88,0xdc,0x04,0x00,0xff,0x02]

scratch_load_sbyte_d16 a2, off, s6
// GFX940: scratch_load_sbyte_d16 a2, off, s6      ; encoding: [0x00,0x40,0x88,0xdc,0x00,0x00,0x86,0x02]

scratch_load_sbyte_d16 a2, off, s6 offset:16
// GFX940: scratch_load_sbyte_d16 a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x88,0xdc,0x00,0x00,0x86,0x02]

scratch_load_sbyte_d16 a2, off, off
// GFX940: scratch_load_sbyte_d16 a2, off, off     ; encoding: [0x00,0x40,0x88,0xdc,0x00,0x00,0xff,0x02]

scratch_load_sbyte_d16 a2, off, off offset:16
// GFX940: scratch_load_sbyte_d16 a2, off, off offset:16 ; encoding: [0x10,0x40,0x88,0xdc,0x00,0x00,0xff,0x02]

scratch_load_sbyte_d16 v2, v4, s6
// GFX940: scratch_load_sbyte_d16 v2, v4, s6       ; encoding: [0x00,0x60,0x88,0xdc,0x04,0x00,0x06,0x02]

scratch_load_sbyte_d16 v2, v4, s6 offset:16
// GFX940: scratch_load_sbyte_d16 v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x88,0xdc,0x04,0x00,0x06,0x02]

scratch_load_sbyte_d16 v2, v4, off
// GFX940: scratch_load_sbyte_d16 v2, v4, off      ; encoding: [0x00,0x60,0x88,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_sbyte_d16 v2, v4, off offset:16
// GFX940: scratch_load_sbyte_d16 v2, v4, off offset:16 ; encoding: [0x10,0x60,0x88,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_sbyte_d16 v2, off, s6
// GFX940: scratch_load_sbyte_d16 v2, off, s6      ; encoding: [0x00,0x40,0x88,0xdc,0x00,0x00,0x06,0x02]

scratch_load_sbyte_d16 v2, off, s6 offset:16
// GFX940: scratch_load_sbyte_d16 v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x88,0xdc,0x00,0x00,0x06,0x02]

scratch_load_sbyte_d16 v2, off, off
// GFX940: scratch_load_sbyte_d16 v2, off, off     ; encoding: [0x00,0x40,0x88,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_sbyte_d16 v2, off, off offset:16
// GFX940: scratch_load_sbyte_d16 v2, off, off offset:16 ; encoding: [0x10,0x40,0x88,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_sbyte_d16_hi a2, v4, s6
// GFX940: scratch_load_sbyte_d16_hi a2, v4, s6    ; encoding: [0x00,0x60,0x8c,0xdc,0x04,0x00,0x86,0x02]

scratch_load_sbyte_d16_hi a2, v4, s6 offset:16
// GFX940: scratch_load_sbyte_d16_hi a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x8c,0xdc,0x04,0x00,0x86,0x02]

scratch_load_sbyte_d16_hi a2, v4, off
// GFX940: scratch_load_sbyte_d16_hi a2, v4, off   ; encoding: [0x00,0x60,0x8c,0xdc,0x04,0x00,0xff,0x02]

scratch_load_sbyte_d16_hi a2, v4, off offset:16
// GFX940: scratch_load_sbyte_d16_hi a2, v4, off offset:16 ; encoding: [0x10,0x60,0x8c,0xdc,0x04,0x00,0xff,0x02]

scratch_load_sbyte_d16_hi a2, off, s6
// GFX940: scratch_load_sbyte_d16_hi a2, off, s6   ; encoding: [0x00,0x40,0x8c,0xdc,0x00,0x00,0x86,0x02]

scratch_load_sbyte_d16_hi a2, off, s6 offset:16
// GFX940: scratch_load_sbyte_d16_hi a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x8c,0xdc,0x00,0x00,0x86,0x02]

scratch_load_sbyte_d16_hi a2, off, off
// GFX940: scratch_load_sbyte_d16_hi a2, off, off  ; encoding: [0x00,0x40,0x8c,0xdc,0x00,0x00,0xff,0x02]

scratch_load_sbyte_d16_hi a2, off, off offset:16
// GFX940: scratch_load_sbyte_d16_hi a2, off, off offset:16 ; encoding: [0x10,0x40,0x8c,0xdc,0x00,0x00,0xff,0x02]

scratch_load_sbyte_d16_hi v2, v4, s6
// GFX940: scratch_load_sbyte_d16_hi v2, v4, s6    ; encoding: [0x00,0x60,0x8c,0xdc,0x04,0x00,0x06,0x02]

scratch_load_sbyte_d16_hi v2, v4, s6 offset:16
// GFX940: scratch_load_sbyte_d16_hi v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x8c,0xdc,0x04,0x00,0x06,0x02]

scratch_load_sbyte_d16_hi v2, v4, off
// GFX940: scratch_load_sbyte_d16_hi v2, v4, off   ; encoding: [0x00,0x60,0x8c,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_sbyte_d16_hi v2, v4, off offset:16
// GFX940: scratch_load_sbyte_d16_hi v2, v4, off offset:16 ; encoding: [0x10,0x60,0x8c,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_sbyte_d16_hi v2, off, s6
// GFX940: scratch_load_sbyte_d16_hi v2, off, s6   ; encoding: [0x00,0x40,0x8c,0xdc,0x00,0x00,0x06,0x02]

scratch_load_sbyte_d16_hi v2, off, s6 offset:16
// GFX940: scratch_load_sbyte_d16_hi v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x8c,0xdc,0x00,0x00,0x06,0x02]

scratch_load_sbyte_d16_hi v2, off, off
// GFX940: scratch_load_sbyte_d16_hi v2, off, off  ; encoding: [0x00,0x40,0x8c,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_sbyte_d16_hi v2, off, off offset:16
// GFX940: scratch_load_sbyte_d16_hi v2, off, off offset:16 ; encoding: [0x10,0x40,0x8c,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_short_d16 a2, v4, s6
// GFX940: scratch_load_short_d16 a2, v4, s6       ; encoding: [0x00,0x60,0x90,0xdc,0x04,0x00,0x86,0x02]

scratch_load_short_d16 a2, v4, s6 offset:16
// GFX940: scratch_load_short_d16 a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x90,0xdc,0x04,0x00,0x86,0x02]

scratch_load_short_d16 a2, v4, off
// GFX940: scratch_load_short_d16 a2, v4, off      ; encoding: [0x00,0x60,0x90,0xdc,0x04,0x00,0xff,0x02]

scratch_load_short_d16 a2, v4, off offset:16
// GFX940: scratch_load_short_d16 a2, v4, off offset:16 ; encoding: [0x10,0x60,0x90,0xdc,0x04,0x00,0xff,0x02]

scratch_load_short_d16 a2, off, s6
// GFX940: scratch_load_short_d16 a2, off, s6      ; encoding: [0x00,0x40,0x90,0xdc,0x00,0x00,0x86,0x02]

scratch_load_short_d16 a2, off, s6 offset:16
// GFX940: scratch_load_short_d16 a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x90,0xdc,0x00,0x00,0x86,0x02]

scratch_load_short_d16 a2, off, off
// GFX940: scratch_load_short_d16 a2, off, off     ; encoding: [0x00,0x40,0x90,0xdc,0x00,0x00,0xff,0x02]

scratch_load_short_d16 a2, off, off offset:16
// GFX940: scratch_load_short_d16 a2, off, off offset:16 ; encoding: [0x10,0x40,0x90,0xdc,0x00,0x00,0xff,0x02]

scratch_load_short_d16 v2, v4, s6
// GFX940: scratch_load_short_d16 v2, v4, s6       ; encoding: [0x00,0x60,0x90,0xdc,0x04,0x00,0x06,0x02]

scratch_load_short_d16 v2, v4, s6 offset:16
// GFX940: scratch_load_short_d16 v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x90,0xdc,0x04,0x00,0x06,0x02]

scratch_load_short_d16 v2, v4, off
// GFX940: scratch_load_short_d16 v2, v4, off      ; encoding: [0x00,0x60,0x90,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_short_d16 v2, v4, off offset:16
// GFX940: scratch_load_short_d16 v2, v4, off offset:16 ; encoding: [0x10,0x60,0x90,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_short_d16 v2, off, s6
// GFX940: scratch_load_short_d16 v2, off, s6      ; encoding: [0x00,0x40,0x90,0xdc,0x00,0x00,0x06,0x02]

scratch_load_short_d16 v2, off, s6 offset:16
// GFX940: scratch_load_short_d16 v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x90,0xdc,0x00,0x00,0x06,0x02]

scratch_load_short_d16 v2, off, off
// GFX940: scratch_load_short_d16 v2, off, off     ; encoding: [0x00,0x40,0x90,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_short_d16 v2, off, off offset:16
// GFX940: scratch_load_short_d16 v2, off, off offset:16 ; encoding: [0x10,0x40,0x90,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_short_d16_hi a2, v4, s6
// GFX940: scratch_load_short_d16_hi a2, v4, s6    ; encoding: [0x00,0x60,0x94,0xdc,0x04,0x00,0x86,0x02]

scratch_load_short_d16_hi a2, v4, s6 offset:16
// GFX940: scratch_load_short_d16_hi a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x94,0xdc,0x04,0x00,0x86,0x02]

scratch_load_short_d16_hi a2, v4, off
// GFX940: scratch_load_short_d16_hi a2, v4, off   ; encoding: [0x00,0x60,0x94,0xdc,0x04,0x00,0xff,0x02]

scratch_load_short_d16_hi a2, v4, off offset:16
// GFX940: scratch_load_short_d16_hi a2, v4, off offset:16 ; encoding: [0x10,0x60,0x94,0xdc,0x04,0x00,0xff,0x02]

scratch_load_short_d16_hi a2, off, s6
// GFX940: scratch_load_short_d16_hi a2, off, s6   ; encoding: [0x00,0x40,0x94,0xdc,0x00,0x00,0x86,0x02]

scratch_load_short_d16_hi a2, off, s6 offset:16
// GFX940: scratch_load_short_d16_hi a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x94,0xdc,0x00,0x00,0x86,0x02]

scratch_load_short_d16_hi a2, off, off
// GFX940: scratch_load_short_d16_hi a2, off, off  ; encoding: [0x00,0x40,0x94,0xdc,0x00,0x00,0xff,0x02]

scratch_load_short_d16_hi a2, off, off offset:16
// GFX940: scratch_load_short_d16_hi a2, off, off offset:16 ; encoding: [0x10,0x40,0x94,0xdc,0x00,0x00,0xff,0x02]

scratch_load_short_d16_hi v2, v4, s6
// GFX940: scratch_load_short_d16_hi v2, v4, s6    ; encoding: [0x00,0x60,0x94,0xdc,0x04,0x00,0x06,0x02]

scratch_load_short_d16_hi v2, v4, s6 offset:16
// GFX940: scratch_load_short_d16_hi v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x94,0xdc,0x04,0x00,0x06,0x02]

scratch_load_short_d16_hi v2, v4, off
// GFX940: scratch_load_short_d16_hi v2, v4, off   ; encoding: [0x00,0x60,0x94,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_short_d16_hi v2, v4, off offset:16
// GFX940: scratch_load_short_d16_hi v2, v4, off offset:16 ; encoding: [0x10,0x60,0x94,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_short_d16_hi v2, off, s6
// GFX940: scratch_load_short_d16_hi v2, off, s6   ; encoding: [0x00,0x40,0x94,0xdc,0x00,0x00,0x06,0x02]

scratch_load_short_d16_hi v2, off, s6 offset:16
// GFX940: scratch_load_short_d16_hi v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x94,0xdc,0x00,0x00,0x06,0x02]

scratch_load_short_d16_hi v2, off, off
// GFX940: scratch_load_short_d16_hi v2, off, off  ; encoding: [0x00,0x40,0x94,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_short_d16_hi v2, off, off offset:16
// GFX940: scratch_load_short_d16_hi v2, off, off offset:16 ; encoding: [0x10,0x40,0x94,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_sshort a2, v4, s6
// GFX940: scratch_load_sshort a2, v4, s6          ; encoding: [0x00,0x60,0x4c,0xdc,0x04,0x00,0x86,0x02]

scratch_load_sshort a2, v4, s6 offset:16
// GFX940: scratch_load_sshort a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x4c,0xdc,0x04,0x00,0x86,0x02]

scratch_load_sshort a2, v4, off
// GFX940: scratch_load_sshort a2, v4, off         ; encoding: [0x00,0x60,0x4c,0xdc,0x04,0x00,0xff,0x02]

scratch_load_sshort a2, v4, off offset:16
// GFX940: scratch_load_sshort a2, v4, off offset:16 ; encoding: [0x10,0x60,0x4c,0xdc,0x04,0x00,0xff,0x02]

scratch_load_sshort a2, off, s6
// GFX940: scratch_load_sshort a2, off, s6         ; encoding: [0x00,0x40,0x4c,0xdc,0x00,0x00,0x86,0x02]

scratch_load_sshort a2, off, s6 offset:16
// GFX940: scratch_load_sshort a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x4c,0xdc,0x00,0x00,0x86,0x02]

scratch_load_sshort a2, off, off
// GFX940: scratch_load_sshort a2, off, off        ; encoding: [0x00,0x40,0x4c,0xdc,0x00,0x00,0xff,0x02]

scratch_load_sshort a2, off, off offset:16
// GFX940: scratch_load_sshort a2, off, off offset:16 ; encoding: [0x10,0x40,0x4c,0xdc,0x00,0x00,0xff,0x02]

scratch_load_sshort v2, v4, s6
// GFX940: scratch_load_sshort v2, v4, s6          ; encoding: [0x00,0x60,0x4c,0xdc,0x04,0x00,0x06,0x02]

scratch_load_sshort v2, v4, s6 offset:16
// GFX940: scratch_load_sshort v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x4c,0xdc,0x04,0x00,0x06,0x02]

scratch_load_sshort v2, v4, off
// GFX940: scratch_load_sshort v2, v4, off         ; encoding: [0x00,0x60,0x4c,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_sshort v2, v4, off offset:16
// GFX940: scratch_load_sshort v2, v4, off offset:16 ; encoding: [0x10,0x60,0x4c,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_sshort v2, off, s6
// GFX940: scratch_load_sshort v2, off, s6         ; encoding: [0x00,0x40,0x4c,0xdc,0x00,0x00,0x06,0x02]

scratch_load_sshort v2, off, s6 offset:16
// GFX940: scratch_load_sshort v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x4c,0xdc,0x00,0x00,0x06,0x02]

scratch_load_sshort v2, off, off
// GFX940: scratch_load_sshort v2, off, off        ; encoding: [0x00,0x40,0x4c,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_sshort v2, off, off offset:16
// GFX940: scratch_load_sshort v2, off, off offset:16 ; encoding: [0x10,0x40,0x4c,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_ubyte a2, v4, s6
// GFX940: scratch_load_ubyte a2, v4, s6           ; encoding: [0x00,0x60,0x40,0xdc,0x04,0x00,0x86,0x02]

scratch_load_ubyte a2, v4, s6 offset:16
// GFX940: scratch_load_ubyte a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x40,0xdc,0x04,0x00,0x86,0x02]

scratch_load_ubyte a2, v4, off
// GFX940: scratch_load_ubyte a2, v4, off          ; encoding: [0x00,0x60,0x40,0xdc,0x04,0x00,0xff,0x02]

scratch_load_ubyte a2, v4, off offset:16
// GFX940: scratch_load_ubyte a2, v4, off offset:16 ; encoding: [0x10,0x60,0x40,0xdc,0x04,0x00,0xff,0x02]

scratch_load_ubyte a2, off, s6
// GFX940: scratch_load_ubyte a2, off, s6          ; encoding: [0x00,0x40,0x40,0xdc,0x00,0x00,0x86,0x02]

scratch_load_ubyte a2, off, s6 offset:16
// GFX940: scratch_load_ubyte a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x40,0xdc,0x00,0x00,0x86,0x02]

scratch_load_ubyte a2, off, off
// GFX940: scratch_load_ubyte a2, off, off         ; encoding: [0x00,0x40,0x40,0xdc,0x00,0x00,0xff,0x02]

scratch_load_ubyte a2, off, off offset:16
// GFX940: scratch_load_ubyte a2, off, off offset:16 ; encoding: [0x10,0x40,0x40,0xdc,0x00,0x00,0xff,0x02]

scratch_load_ubyte v2, v4, s6
// GFX940: scratch_load_ubyte v2, v4, s6           ; encoding: [0x00,0x60,0x40,0xdc,0x04,0x00,0x06,0x02]

scratch_load_ubyte v2, v4, s6 offset:16
// GFX940: scratch_load_ubyte v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x40,0xdc,0x04,0x00,0x06,0x02]

scratch_load_ubyte v2, v4, off
// GFX940: scratch_load_ubyte v2, v4, off          ; encoding: [0x00,0x60,0x40,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_ubyte v2, v4, off offset:16
// GFX940: scratch_load_ubyte v2, v4, off offset:16 ; encoding: [0x10,0x60,0x40,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_ubyte v2, off, s6
// GFX940: scratch_load_ubyte v2, off, s6          ; encoding: [0x00,0x40,0x40,0xdc,0x00,0x00,0x06,0x02]

scratch_load_ubyte v2, off, s6 offset:16
// GFX940: scratch_load_ubyte v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x40,0xdc,0x00,0x00,0x06,0x02]

scratch_load_ubyte v2, off, off
// GFX940: scratch_load_ubyte v2, off, off         ; encoding: [0x00,0x40,0x40,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_ubyte v2, off, off offset:16
// GFX940: scratch_load_ubyte v2, off, off offset:16 ; encoding: [0x10,0x40,0x40,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_ubyte_d16 a2, v4, s6
// GFX940: scratch_load_ubyte_d16 a2, v4, s6       ; encoding: [0x00,0x60,0x80,0xdc,0x04,0x00,0x86,0x02]

scratch_load_ubyte_d16 a2, v4, s6 offset:16
// GFX940: scratch_load_ubyte_d16 a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x80,0xdc,0x04,0x00,0x86,0x02]

scratch_load_ubyte_d16 a2, v4, off
// GFX940: scratch_load_ubyte_d16 a2, v4, off      ; encoding: [0x00,0x60,0x80,0xdc,0x04,0x00,0xff,0x02]

scratch_load_ubyte_d16 a2, v4, off offset:16
// GFX940: scratch_load_ubyte_d16 a2, v4, off offset:16 ; encoding: [0x10,0x60,0x80,0xdc,0x04,0x00,0xff,0x02]

scratch_load_ubyte_d16 a2, off, s6
// GFX940: scratch_load_ubyte_d16 a2, off, s6      ; encoding: [0x00,0x40,0x80,0xdc,0x00,0x00,0x86,0x02]

scratch_load_ubyte_d16 a2, off, s6 offset:16
// GFX940: scratch_load_ubyte_d16 a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x80,0xdc,0x00,0x00,0x86,0x02]

scratch_load_ubyte_d16 a2, off, off
// GFX940: scratch_load_ubyte_d16 a2, off, off     ; encoding: [0x00,0x40,0x80,0xdc,0x00,0x00,0xff,0x02]

scratch_load_ubyte_d16 a2, off, off offset:16
// GFX940: scratch_load_ubyte_d16 a2, off, off offset:16 ; encoding: [0x10,0x40,0x80,0xdc,0x00,0x00,0xff,0x02]

scratch_load_ubyte_d16 v2, v4, s6
// GFX940: scratch_load_ubyte_d16 v2, v4, s6       ; encoding: [0x00,0x60,0x80,0xdc,0x04,0x00,0x06,0x02]

scratch_load_ubyte_d16 v2, v4, s6 offset:16
// GFX940: scratch_load_ubyte_d16 v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x80,0xdc,0x04,0x00,0x06,0x02]

scratch_load_ubyte_d16 v2, v4, off
// GFX940: scratch_load_ubyte_d16 v2, v4, off      ; encoding: [0x00,0x60,0x80,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_ubyte_d16 v2, v4, off offset:16
// GFX940: scratch_load_ubyte_d16 v2, v4, off offset:16 ; encoding: [0x10,0x60,0x80,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_ubyte_d16 v2, off, s6
// GFX940: scratch_load_ubyte_d16 v2, off, s6      ; encoding: [0x00,0x40,0x80,0xdc,0x00,0x00,0x06,0x02]

scratch_load_ubyte_d16 v2, off, s6 offset:16
// GFX940: scratch_load_ubyte_d16 v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x80,0xdc,0x00,0x00,0x06,0x02]

scratch_load_ubyte_d16 v2, off, off
// GFX940: scratch_load_ubyte_d16 v2, off, off     ; encoding: [0x00,0x40,0x80,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_ubyte_d16 v2, off, off offset:16
// GFX940: scratch_load_ubyte_d16 v2, off, off offset:16 ; encoding: [0x10,0x40,0x80,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_ubyte_d16_hi a2, v4, s6
// GFX940: scratch_load_ubyte_d16_hi a2, v4, s6    ; encoding: [0x00,0x60,0x84,0xdc,0x04,0x00,0x86,0x02]

scratch_load_ubyte_d16_hi a2, v4, s6 offset:16
// GFX940: scratch_load_ubyte_d16_hi a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x84,0xdc,0x04,0x00,0x86,0x02]

scratch_load_ubyte_d16_hi a2, v4, off
// GFX940: scratch_load_ubyte_d16_hi a2, v4, off   ; encoding: [0x00,0x60,0x84,0xdc,0x04,0x00,0xff,0x02]

scratch_load_ubyte_d16_hi a2, v4, off offset:16
// GFX940: scratch_load_ubyte_d16_hi a2, v4, off offset:16 ; encoding: [0x10,0x60,0x84,0xdc,0x04,0x00,0xff,0x02]

scratch_load_ubyte_d16_hi a2, off, s6
// GFX940: scratch_load_ubyte_d16_hi a2, off, s6   ; encoding: [0x00,0x40,0x84,0xdc,0x00,0x00,0x86,0x02]

scratch_load_ubyte_d16_hi a2, off, s6 offset:16
// GFX940: scratch_load_ubyte_d16_hi a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x84,0xdc,0x00,0x00,0x86,0x02]

scratch_load_ubyte_d16_hi a2, off, off
// GFX940: scratch_load_ubyte_d16_hi a2, off, off  ; encoding: [0x00,0x40,0x84,0xdc,0x00,0x00,0xff,0x02]

scratch_load_ubyte_d16_hi a2, off, off offset:16
// GFX940: scratch_load_ubyte_d16_hi a2, off, off offset:16 ; encoding: [0x10,0x40,0x84,0xdc,0x00,0x00,0xff,0x02]

scratch_load_ubyte_d16_hi v2, v4, s6
// GFX940: scratch_load_ubyte_d16_hi v2, v4, s6    ; encoding: [0x00,0x60,0x84,0xdc,0x04,0x00,0x06,0x02]

scratch_load_ubyte_d16_hi v2, v4, s6 offset:16
// GFX940: scratch_load_ubyte_d16_hi v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x84,0xdc,0x04,0x00,0x06,0x02]

scratch_load_ubyte_d16_hi v2, v4, off
// GFX940: scratch_load_ubyte_d16_hi v2, v4, off   ; encoding: [0x00,0x60,0x84,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_ubyte_d16_hi v2, v4, off offset:16
// GFX940: scratch_load_ubyte_d16_hi v2, v4, off offset:16 ; encoding: [0x10,0x60,0x84,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_ubyte_d16_hi v2, off, s6
// GFX940: scratch_load_ubyte_d16_hi v2, off, s6   ; encoding: [0x00,0x40,0x84,0xdc,0x00,0x00,0x06,0x02]

scratch_load_ubyte_d16_hi v2, off, s6 offset:16
// GFX940: scratch_load_ubyte_d16_hi v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x84,0xdc,0x00,0x00,0x06,0x02]

scratch_load_ubyte_d16_hi v2, off, off
// GFX940: scratch_load_ubyte_d16_hi v2, off, off  ; encoding: [0x00,0x40,0x84,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_ubyte_d16_hi v2, off, off offset:16
// GFX940: scratch_load_ubyte_d16_hi v2, off, off offset:16 ; encoding: [0x10,0x40,0x84,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_ushort a2, v4, s6
// GFX940: scratch_load_ushort a2, v4, s6          ; encoding: [0x00,0x60,0x48,0xdc,0x04,0x00,0x86,0x02]

scratch_load_ushort a2, v4, s6 offset:16
// GFX940: scratch_load_ushort a2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x48,0xdc,0x04,0x00,0x86,0x02]

scratch_load_ushort a2, v4, off
// GFX940: scratch_load_ushort a2, v4, off         ; encoding: [0x00,0x60,0x48,0xdc,0x04,0x00,0xff,0x02]

scratch_load_ushort a2, v4, off offset:16
// GFX940: scratch_load_ushort a2, v4, off offset:16 ; encoding: [0x10,0x60,0x48,0xdc,0x04,0x00,0xff,0x02]

scratch_load_ushort a2, off, s6
// GFX940: scratch_load_ushort a2, off, s6         ; encoding: [0x00,0x40,0x48,0xdc,0x00,0x00,0x86,0x02]

scratch_load_ushort a2, off, s6 offset:16
// GFX940: scratch_load_ushort a2, off, s6 offset:16 ; encoding: [0x10,0x40,0x48,0xdc,0x00,0x00,0x86,0x02]

scratch_load_ushort a2, off, off
// GFX940: scratch_load_ushort a2, off, off        ; encoding: [0x00,0x40,0x48,0xdc,0x00,0x00,0xff,0x02]

scratch_load_ushort a2, off, off offset:16
// GFX940: scratch_load_ushort a2, off, off offset:16 ; encoding: [0x10,0x40,0x48,0xdc,0x00,0x00,0xff,0x02]

scratch_load_ushort v2, v4, s6
// GFX940: scratch_load_ushort v2, v4, s6          ; encoding: [0x00,0x60,0x48,0xdc,0x04,0x00,0x06,0x02]

scratch_load_ushort v2, v4, s6 offset:16
// GFX940: scratch_load_ushort v2, v4, s6 offset:16 ; encoding: [0x10,0x60,0x48,0xdc,0x04,0x00,0x06,0x02]

scratch_load_ushort v2, v4, off
// GFX940: scratch_load_ushort v2, v4, off         ; encoding: [0x00,0x60,0x48,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_ushort v2, v4, off offset:16
// GFX940: scratch_load_ushort v2, v4, off offset:16 ; encoding: [0x10,0x60,0x48,0xdc,0x04,0x00,0x7f,0x02]

scratch_load_ushort v2, off, s6
// GFX940: scratch_load_ushort v2, off, s6         ; encoding: [0x00,0x40,0x48,0xdc,0x00,0x00,0x06,0x02]

scratch_load_ushort v2, off, s6 offset:16
// GFX940: scratch_load_ushort v2, off, s6 offset:16 ; encoding: [0x10,0x40,0x48,0xdc,0x00,0x00,0x06,0x02]

scratch_load_ushort v2, off, off
// GFX940: scratch_load_ushort v2, off, off        ; encoding: [0x00,0x40,0x48,0xdc,0x00,0x00,0x7f,0x02]

scratch_load_ushort v2, off, off offset:16
// GFX940: scratch_load_ushort v2, off, off offset:16 ; encoding: [0x10,0x40,0x48,0xdc,0x00,0x00,0x7f,0x02]

scratch_store_byte v4, a2, s6
// GFX940: scratch_store_byte v4, a2, s6           ; encoding: [0x00,0x60,0x60,0xdc,0x04,0x02,0x86,0x00]

scratch_store_byte v4, a2, s6 offset:16
// GFX940: scratch_store_byte v4, a2, s6 offset:16 ; encoding: [0x10,0x60,0x60,0xdc,0x04,0x02,0x86,0x00]

scratch_store_byte v4, a2, off
// GFX940: scratch_store_byte v4, a2, off          ; encoding: [0x00,0x60,0x60,0xdc,0x04,0x02,0xff,0x00]

scratch_store_byte v4, a2, off offset:16
// GFX940: scratch_store_byte v4, a2, off offset:16 ; encoding: [0x10,0x60,0x60,0xdc,0x04,0x02,0xff,0x00]

scratch_store_byte off, a2, s6
// GFX940: scratch_store_byte off, a2, s6          ; encoding: [0x00,0x40,0x60,0xdc,0x00,0x02,0x86,0x00]

scratch_store_byte off, a2, s6 offset:16
// GFX940: scratch_store_byte off, a2, s6 offset:16 ; encoding: [0x10,0x40,0x60,0xdc,0x00,0x02,0x86,0x00]

scratch_store_byte off, a2, off
// GFX940: scratch_store_byte off, a2, off         ; encoding: [0x00,0x40,0x60,0xdc,0x00,0x02,0xff,0x00]

scratch_store_byte off, a2, off offset:16
// GFX940: scratch_store_byte off, a2, off offset:16 ; encoding: [0x10,0x40,0x60,0xdc,0x00,0x02,0xff,0x00]

scratch_store_byte v4, v2, s6
// GFX940: scratch_store_byte v4, v2, s6           ; encoding: [0x00,0x60,0x60,0xdc,0x04,0x02,0x06,0x00]

scratch_store_byte v4, v2, s6 offset:16
// GFX940: scratch_store_byte v4, v2, s6 offset:16 ; encoding: [0x10,0x60,0x60,0xdc,0x04,0x02,0x06,0x00]

scratch_store_byte v4, v2, off
// GFX940: scratch_store_byte v4, v2, off          ; encoding: [0x00,0x60,0x60,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_byte v4, v2, off offset:16
// GFX940: scratch_store_byte v4, v2, off offset:16 ; encoding: [0x10,0x60,0x60,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_byte off, v2, s6
// GFX940: scratch_store_byte off, v2, s6          ; encoding: [0x00,0x40,0x60,0xdc,0x00,0x02,0x06,0x00]

scratch_store_byte off, v2, s6 offset:16
// GFX940: scratch_store_byte off, v2, s6 offset:16 ; encoding: [0x10,0x40,0x60,0xdc,0x00,0x02,0x06,0x00]

scratch_store_byte off, v2, off
// GFX940: scratch_store_byte off, v2, off         ; encoding: [0x00,0x40,0x60,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_byte off, v2, off offset:16
// GFX940: scratch_store_byte off, v2, off offset:16 ; encoding: [0x10,0x40,0x60,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_byte_d16_hi v4, a2, s6
// GFX940: scratch_store_byte_d16_hi v4, a2, s6    ; encoding: [0x00,0x60,0x64,0xdc,0x04,0x02,0x86,0x00]

scratch_store_byte_d16_hi v4, a2, s6 offset:16
// GFX940: scratch_store_byte_d16_hi v4, a2, s6 offset:16 ; encoding: [0x10,0x60,0x64,0xdc,0x04,0x02,0x86,0x00]

scratch_store_byte_d16_hi v4, a2, off
// GFX940: scratch_store_byte_d16_hi v4, a2, off   ; encoding: [0x00,0x60,0x64,0xdc,0x04,0x02,0xff,0x00]

scratch_store_byte_d16_hi v4, a2, off offset:16
// GFX940: scratch_store_byte_d16_hi v4, a2, off offset:16 ; encoding: [0x10,0x60,0x64,0xdc,0x04,0x02,0xff,0x00]

scratch_store_byte_d16_hi off, a2, s6
// GFX940: scratch_store_byte_d16_hi off, a2, s6   ; encoding: [0x00,0x40,0x64,0xdc,0x00,0x02,0x86,0x00]

scratch_store_byte_d16_hi off, a2, s6 offset:16
// GFX940: scratch_store_byte_d16_hi off, a2, s6 offset:16 ; encoding: [0x10,0x40,0x64,0xdc,0x00,0x02,0x86,0x00]

scratch_store_byte_d16_hi off, a2, off
// GFX940: scratch_store_byte_d16_hi off, a2, off  ; encoding: [0x00,0x40,0x64,0xdc,0x00,0x02,0xff,0x00]

scratch_store_byte_d16_hi off, a2, off offset:16
// GFX940: scratch_store_byte_d16_hi off, a2, off offset:16 ; encoding: [0x10,0x40,0x64,0xdc,0x00,0x02,0xff,0x00]

scratch_store_byte_d16_hi v4, v2, s6
// GFX940: scratch_store_byte_d16_hi v4, v2, s6    ; encoding: [0x00,0x60,0x64,0xdc,0x04,0x02,0x06,0x00]

scratch_store_byte_d16_hi v4, v2, s6 offset:16
// GFX940: scratch_store_byte_d16_hi v4, v2, s6 offset:16 ; encoding: [0x10,0x60,0x64,0xdc,0x04,0x02,0x06,0x00]

scratch_store_byte_d16_hi v4, v2, off
// GFX940: scratch_store_byte_d16_hi v4, v2, off   ; encoding: [0x00,0x60,0x64,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_byte_d16_hi v4, v2, off offset:16
// GFX940: scratch_store_byte_d16_hi v4, v2, off offset:16 ; encoding: [0x10,0x60,0x64,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_byte_d16_hi off, v2, s6
// GFX940: scratch_store_byte_d16_hi off, v2, s6   ; encoding: [0x00,0x40,0x64,0xdc,0x00,0x02,0x06,0x00]

scratch_store_byte_d16_hi off, v2, s6 offset:16
// GFX940: scratch_store_byte_d16_hi off, v2, s6 offset:16 ; encoding: [0x10,0x40,0x64,0xdc,0x00,0x02,0x06,0x00]

scratch_store_byte_d16_hi off, v2, off
// GFX940: scratch_store_byte_d16_hi off, v2, off  ; encoding: [0x00,0x40,0x64,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_byte_d16_hi off, v2, off offset:16
// GFX940: scratch_store_byte_d16_hi off, v2, off offset:16 ; encoding: [0x10,0x40,0x64,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dword v4, a2, s6
// GFX940: scratch_store_dword v4, a2, s6          ; encoding: [0x00,0x60,0x70,0xdc,0x04,0x02,0x86,0x00]

scratch_store_dword v4, a2, s6 offset:16
// GFX940: scratch_store_dword v4, a2, s6 offset:16 ; encoding: [0x10,0x60,0x70,0xdc,0x04,0x02,0x86,0x00]

scratch_store_dword v4, a2, off
// GFX940: scratch_store_dword v4, a2, off         ; encoding: [0x00,0x60,0x70,0xdc,0x04,0x02,0xff,0x00]

scratch_store_dword v4, a2, off offset:16
// GFX940: scratch_store_dword v4, a2, off offset:16 ; encoding: [0x10,0x60,0x70,0xdc,0x04,0x02,0xff,0x00]

scratch_store_dword off, a2, s6
// GFX940: scratch_store_dword off, a2, s6         ; encoding: [0x00,0x40,0x70,0xdc,0x00,0x02,0x86,0x00]

scratch_store_dword off, a2, s6 offset:16
// GFX940: scratch_store_dword off, a2, s6 offset:16 ; encoding: [0x10,0x40,0x70,0xdc,0x00,0x02,0x86,0x00]

scratch_store_dword off, a2, off
// GFX940: scratch_store_dword off, a2, off        ; encoding: [0x00,0x40,0x70,0xdc,0x00,0x02,0xff,0x00]

scratch_store_dword off, a2, off offset:16
// GFX940: scratch_store_dword off, a2, off offset:16 ; encoding: [0x10,0x40,0x70,0xdc,0x00,0x02,0xff,0x00]

scratch_store_dword v4, v2, s6
// GFX940: scratch_store_dword v4, v2, s6          ; encoding: [0x00,0x60,0x70,0xdc,0x04,0x02,0x06,0x00]

scratch_store_dword v4, v2, s6 offset:16
// GFX940: scratch_store_dword v4, v2, s6 offset:16 ; encoding: [0x10,0x60,0x70,0xdc,0x04,0x02,0x06,0x00]

scratch_store_dword v4, v2, off
// GFX940: scratch_store_dword v4, v2, off         ; encoding: [0x00,0x60,0x70,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_dword v4, v2, off offset:16
// GFX940: scratch_store_dword v4, v2, off offset:16 ; encoding: [0x10,0x60,0x70,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_dword off, v2, s6
// GFX940: scratch_store_dword off, v2, s6         ; encoding: [0x00,0x40,0x70,0xdc,0x00,0x02,0x06,0x00]

scratch_store_dword off, v2, s6 offset:16
// GFX940: scratch_store_dword off, v2, s6 offset:16 ; encoding: [0x10,0x40,0x70,0xdc,0x00,0x02,0x06,0x00]

scratch_store_dword off, v2, off
// GFX940: scratch_store_dword off, v2, off        ; encoding: [0x00,0x40,0x70,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dword off, v2, off offset:16
// GFX940: scratch_store_dword off, v2, off offset:16 ; encoding: [0x10,0x40,0x70,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dwordx2 v4, a[2:3], s6
// GFX940: scratch_store_dwordx2 v4, a[2:3], s6    ; encoding: [0x00,0x60,0x74,0xdc,0x04,0x02,0x86,0x00]

scratch_store_dwordx2 v4, a[2:3], s6 offset:16
// GFX940: scratch_store_dwordx2 v4, a[2:3], s6 offset:16 ; encoding: [0x10,0x60,0x74,0xdc,0x04,0x02,0x86,0x00]

scratch_store_dwordx2 v4, a[2:3], off
// GFX940: scratch_store_dwordx2 v4, a[2:3], off   ; encoding: [0x00,0x60,0x74,0xdc,0x04,0x02,0xff,0x00]

scratch_store_dwordx2 v4, a[2:3], off offset:16
// GFX940: scratch_store_dwordx2 v4, a[2:3], off offset:16 ; encoding: [0x10,0x60,0x74,0xdc,0x04,0x02,0xff,0x00]

scratch_store_dwordx2 off, a[2:3], s6
// GFX940: scratch_store_dwordx2 off, a[2:3], s6   ; encoding: [0x00,0x40,0x74,0xdc,0x00,0x02,0x86,0x00]

scratch_store_dwordx2 off, a[2:3], s6 offset:16
// GFX940: scratch_store_dwordx2 off, a[2:3], s6 offset:16 ; encoding: [0x10,0x40,0x74,0xdc,0x00,0x02,0x86,0x00]

scratch_store_dwordx2 off, a[2:3], off
// GFX940: scratch_store_dwordx2 off, a[2:3], off  ; encoding: [0x00,0x40,0x74,0xdc,0x00,0x02,0xff,0x00]

scratch_store_dwordx2 off, a[2:3], off offset:16
// GFX940: scratch_store_dwordx2 off, a[2:3], off offset:16 ; encoding: [0x10,0x40,0x74,0xdc,0x00,0x02,0xff,0x00]

scratch_store_dwordx2 v4, v[2:3], s6
// GFX940: scratch_store_dwordx2 v4, v[2:3], s6    ; encoding: [0x00,0x60,0x74,0xdc,0x04,0x02,0x06,0x00]

scratch_store_dwordx2 v4, v[2:3], s6 offset:16
// GFX940: scratch_store_dwordx2 v4, v[2:3], s6 offset:16 ; encoding: [0x10,0x60,0x74,0xdc,0x04,0x02,0x06,0x00]

scratch_store_dwordx2 v4, v[2:3], off
// GFX940: scratch_store_dwordx2 v4, v[2:3], off   ; encoding: [0x00,0x60,0x74,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_dwordx2 v4, v[2:3], off offset:16
// GFX940: scratch_store_dwordx2 v4, v[2:3], off offset:16 ; encoding: [0x10,0x60,0x74,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_dwordx2 off, v[2:3], s6
// GFX940: scratch_store_dwordx2 off, v[2:3], s6   ; encoding: [0x00,0x40,0x74,0xdc,0x00,0x02,0x06,0x00]

scratch_store_dwordx2 off, v[2:3], s6 offset:16
// GFX940: scratch_store_dwordx2 off, v[2:3], s6 offset:16 ; encoding: [0x10,0x40,0x74,0xdc,0x00,0x02,0x06,0x00]

scratch_store_dwordx2 off, v[2:3], off
// GFX940: scratch_store_dwordx2 off, v[2:3], off  ; encoding: [0x00,0x40,0x74,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dwordx2 off, v[2:3], off offset:16
// GFX940: scratch_store_dwordx2 off, v[2:3], off offset:16 ; encoding: [0x10,0x40,0x74,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dwordx3 v4, a[2:4], s6
// GFX940: scratch_store_dwordx3 v4, a[2:4], s6    ; encoding: [0x00,0x60,0x78,0xdc,0x04,0x02,0x86,0x00]

scratch_store_dwordx3 v4, a[2:4], s6 offset:16
// GFX940: scratch_store_dwordx3 v4, a[2:4], s6 offset:16 ; encoding: [0x10,0x60,0x78,0xdc,0x04,0x02,0x86,0x00]

scratch_store_dwordx3 v4, a[2:4], off
// GFX940: scratch_store_dwordx3 v4, a[2:4], off   ; encoding: [0x00,0x60,0x78,0xdc,0x04,0x02,0xff,0x00]

scratch_store_dwordx3 v4, a[2:4], off offset:16
// GFX940: scratch_store_dwordx3 v4, a[2:4], off offset:16 ; encoding: [0x10,0x60,0x78,0xdc,0x04,0x02,0xff,0x00]

scratch_store_dwordx3 off, a[2:4], s6
// GFX940: scratch_store_dwordx3 off, a[2:4], s6   ; encoding: [0x00,0x40,0x78,0xdc,0x00,0x02,0x86,0x00]

scratch_store_dwordx3 off, a[2:4], s6 offset:16
// GFX940: scratch_store_dwordx3 off, a[2:4], s6 offset:16 ; encoding: [0x10,0x40,0x78,0xdc,0x00,0x02,0x86,0x00]

scratch_store_dwordx3 off, a[2:4], off
// GFX940: scratch_store_dwordx3 off, a[2:4], off  ; encoding: [0x00,0x40,0x78,0xdc,0x00,0x02,0xff,0x00]

scratch_store_dwordx3 off, a[2:4], off offset:16
// GFX940: scratch_store_dwordx3 off, a[2:4], off offset:16 ; encoding: [0x10,0x40,0x78,0xdc,0x00,0x02,0xff,0x00]

scratch_store_dwordx3 v4, v[2:4], s6
// GFX940: scratch_store_dwordx3 v4, v[2:4], s6    ; encoding: [0x00,0x60,0x78,0xdc,0x04,0x02,0x06,0x00]

scratch_store_dwordx3 v4, v[2:4], s6 offset:16
// GFX940: scratch_store_dwordx3 v4, v[2:4], s6 offset:16 ; encoding: [0x10,0x60,0x78,0xdc,0x04,0x02,0x06,0x00]

scratch_store_dwordx3 v4, v[2:4], off
// GFX940: scratch_store_dwordx3 v4, v[2:4], off   ; encoding: [0x00,0x60,0x78,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_dwordx3 v4, v[2:4], off offset:16
// GFX940: scratch_store_dwordx3 v4, v[2:4], off offset:16 ; encoding: [0x10,0x60,0x78,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_dwordx3 off, v[2:4], s6
// GFX940: scratch_store_dwordx3 off, v[2:4], s6   ; encoding: [0x00,0x40,0x78,0xdc,0x00,0x02,0x06,0x00]

scratch_store_dwordx3 off, v[2:4], s6 offset:16
// GFX940: scratch_store_dwordx3 off, v[2:4], s6 offset:16 ; encoding: [0x10,0x40,0x78,0xdc,0x00,0x02,0x06,0x00]

scratch_store_dwordx3 off, v[2:4], off
// GFX940: scratch_store_dwordx3 off, v[2:4], off  ; encoding: [0x00,0x40,0x78,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dwordx3 off, v[2:4], off offset:16
// GFX940: scratch_store_dwordx3 off, v[2:4], off offset:16 ; encoding: [0x10,0x40,0x78,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dwordx4 v4, a[2:5], s6
// GFX940: scratch_store_dwordx4 v4, a[2:5], s6    ; encoding: [0x00,0x60,0x7c,0xdc,0x04,0x02,0x86,0x00]

scratch_store_dwordx4 v4, a[2:5], s6 offset:16
// GFX940: scratch_store_dwordx4 v4, a[2:5], s6 offset:16 ; encoding: [0x10,0x60,0x7c,0xdc,0x04,0x02,0x86,0x00]

scratch_store_dwordx4 v4, a[2:5], off
// GFX940: scratch_store_dwordx4 v4, a[2:5], off   ; encoding: [0x00,0x60,0x7c,0xdc,0x04,0x02,0xff,0x00]

scratch_store_dwordx4 v4, a[2:5], off offset:16
// GFX940: scratch_store_dwordx4 v4, a[2:5], off offset:16 ; encoding: [0x10,0x60,0x7c,0xdc,0x04,0x02,0xff,0x00]

scratch_store_dwordx4 off, a[2:5], s6
// GFX940: scratch_store_dwordx4 off, a[2:5], s6   ; encoding: [0x00,0x40,0x7c,0xdc,0x00,0x02,0x86,0x00]

scratch_store_dwordx4 off, a[2:5], s6 offset:16
// GFX940: scratch_store_dwordx4 off, a[2:5], s6 offset:16 ; encoding: [0x10,0x40,0x7c,0xdc,0x00,0x02,0x86,0x00]

scratch_store_dwordx4 off, a[2:5], off
// GFX940: scratch_store_dwordx4 off, a[2:5], off  ; encoding: [0x00,0x40,0x7c,0xdc,0x00,0x02,0xff,0x00]

scratch_store_dwordx4 off, a[2:5], off offset:16
// GFX940: scratch_store_dwordx4 off, a[2:5], off offset:16 ; encoding: [0x10,0x40,0x7c,0xdc,0x00,0x02,0xff,0x00]

scratch_store_dwordx4 v4, v[2:5], s6
// GFX940: scratch_store_dwordx4 v4, v[2:5], s6    ; encoding: [0x00,0x60,0x7c,0xdc,0x04,0x02,0x06,0x00]

scratch_store_dwordx4 v4, v[2:5], s6 offset:16
// GFX940: scratch_store_dwordx4 v4, v[2:5], s6 offset:16 ; encoding: [0x10,0x60,0x7c,0xdc,0x04,0x02,0x06,0x00]

scratch_store_dwordx4 v4, v[2:5], off
// GFX940: scratch_store_dwordx4 v4, v[2:5], off   ; encoding: [0x00,0x60,0x7c,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_dwordx4 v4, v[2:5], off offset:16
// GFX940: scratch_store_dwordx4 v4, v[2:5], off offset:16 ; encoding: [0x10,0x60,0x7c,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_dwordx4 off, v[2:5], s6
// GFX940: scratch_store_dwordx4 off, v[2:5], s6   ; encoding: [0x00,0x40,0x7c,0xdc,0x00,0x02,0x06,0x00]

scratch_store_dwordx4 off, v[2:5], s6 offset:16
// GFX940: scratch_store_dwordx4 off, v[2:5], s6 offset:16 ; encoding: [0x10,0x40,0x7c,0xdc,0x00,0x02,0x06,0x00]

scratch_store_dwordx4 off, v[2:5], off
// GFX940: scratch_store_dwordx4 off, v[2:5], off  ; encoding: [0x00,0x40,0x7c,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dwordx4 off, v[2:5], off offset:16
// GFX940: scratch_store_dwordx4 off, v[2:5], off offset:16 ; encoding: [0x10,0x40,0x7c,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_short v4, a2, s6
// GFX940: scratch_store_short v4, a2, s6          ; encoding: [0x00,0x60,0x68,0xdc,0x04,0x02,0x86,0x00]

scratch_store_short v4, a2, s6 offset:16
// GFX940: scratch_store_short v4, a2, s6 offset:16 ; encoding: [0x10,0x60,0x68,0xdc,0x04,0x02,0x86,0x00]

scratch_store_short v4, a2, off
// GFX940: scratch_store_short v4, a2, off         ; encoding: [0x00,0x60,0x68,0xdc,0x04,0x02,0xff,0x00]

scratch_store_short v4, a2, off offset:16
// GFX940: scratch_store_short v4, a2, off offset:16 ; encoding: [0x10,0x60,0x68,0xdc,0x04,0x02,0xff,0x00]

scratch_store_short off, a2, s6
// GFX940: scratch_store_short off, a2, s6         ; encoding: [0x00,0x40,0x68,0xdc,0x00,0x02,0x86,0x00]

scratch_store_short off, a2, s6 offset:16
// GFX940: scratch_store_short off, a2, s6 offset:16 ; encoding: [0x10,0x40,0x68,0xdc,0x00,0x02,0x86,0x00]

scratch_store_short off, a2, off
// GFX940: scratch_store_short off, a2, off        ; encoding: [0x00,0x40,0x68,0xdc,0x00,0x02,0xff,0x00]

scratch_store_short off, a2, off offset:16
// GFX940: scratch_store_short off, a2, off offset:16 ; encoding: [0x10,0x40,0x68,0xdc,0x00,0x02,0xff,0x00]

scratch_store_short v4, v2, s6
// GFX940: scratch_store_short v4, v2, s6          ; encoding: [0x00,0x60,0x68,0xdc,0x04,0x02,0x06,0x00]

scratch_store_short v4, v2, s6 offset:16
// GFX940: scratch_store_short v4, v2, s6 offset:16 ; encoding: [0x10,0x60,0x68,0xdc,0x04,0x02,0x06,0x00]

scratch_store_short v4, v2, off
// GFX940: scratch_store_short v4, v2, off         ; encoding: [0x00,0x60,0x68,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_short v4, v2, off offset:16
// GFX940: scratch_store_short v4, v2, off offset:16 ; encoding: [0x10,0x60,0x68,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_short off, v2, s6
// GFX940: scratch_store_short off, v2, s6         ; encoding: [0x00,0x40,0x68,0xdc,0x00,0x02,0x06,0x00]

scratch_store_short off, v2, s6 offset:16
// GFX940: scratch_store_short off, v2, s6 offset:16 ; encoding: [0x10,0x40,0x68,0xdc,0x00,0x02,0x06,0x00]

scratch_store_short off, v2, off
// GFX940: scratch_store_short off, v2, off        ; encoding: [0x00,0x40,0x68,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_short off, v2, off offset:16
// GFX940: scratch_store_short off, v2, off offset:16 ; encoding: [0x10,0x40,0x68,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_short_d16_hi v4, a2, s6
// GFX940: scratch_store_short_d16_hi v4, a2, s6   ; encoding: [0x00,0x60,0x6c,0xdc,0x04,0x02,0x86,0x00]

scratch_store_short_d16_hi v4, a2, s6 offset:16
// GFX940: scratch_store_short_d16_hi v4, a2, s6 offset:16 ; encoding: [0x10,0x60,0x6c,0xdc,0x04,0x02,0x86,0x00]

scratch_store_short_d16_hi v4, a2, off
// GFX940: scratch_store_short_d16_hi v4, a2, off  ; encoding: [0x00,0x60,0x6c,0xdc,0x04,0x02,0xff,0x00]

scratch_store_short_d16_hi v4, a2, off offset:16
// GFX940: scratch_store_short_d16_hi v4, a2, off offset:16 ; encoding: [0x10,0x60,0x6c,0xdc,0x04,0x02,0xff,0x00]

scratch_store_short_d16_hi off, a2, s6
// GFX940: scratch_store_short_d16_hi off, a2, s6  ; encoding: [0x00,0x40,0x6c,0xdc,0x00,0x02,0x86,0x00]

scratch_store_short_d16_hi off, a2, s6 offset:16
// GFX940: scratch_store_short_d16_hi off, a2, s6 offset:16 ; encoding: [0x10,0x40,0x6c,0xdc,0x00,0x02,0x86,0x00]

scratch_store_short_d16_hi off, a2, off
// GFX940: scratch_store_short_d16_hi off, a2, off ; encoding: [0x00,0x40,0x6c,0xdc,0x00,0x02,0xff,0x00]

scratch_store_short_d16_hi off, a2, off offset:16
// GFX940: scratch_store_short_d16_hi off, a2, off offset:16 ; encoding: [0x10,0x40,0x6c,0xdc,0x00,0x02,0xff,0x00]

scratch_store_short_d16_hi v4, v2, s6
// GFX940: scratch_store_short_d16_hi v4, v2, s6   ; encoding: [0x00,0x60,0x6c,0xdc,0x04,0x02,0x06,0x00]

scratch_store_short_d16_hi v4, v2, s6 offset:16
// GFX940: scratch_store_short_d16_hi v4, v2, s6 offset:16 ; encoding: [0x10,0x60,0x6c,0xdc,0x04,0x02,0x06,0x00]

scratch_store_short_d16_hi v4, v2, off
// GFX940: scratch_store_short_d16_hi v4, v2, off  ; encoding: [0x00,0x60,0x6c,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_short_d16_hi v4, v2, off offset:16
// GFX940: scratch_store_short_d16_hi v4, v2, off offset:16 ; encoding: [0x10,0x60,0x6c,0xdc,0x04,0x02,0x7f,0x00]

scratch_store_short_d16_hi off, v2, s6
// GFX940: scratch_store_short_d16_hi off, v2, s6  ; encoding: [0x00,0x40,0x6c,0xdc,0x00,0x02,0x06,0x00]

scratch_store_short_d16_hi off, v2, s6 offset:16
// GFX940: scratch_store_short_d16_hi off, v2, s6 offset:16 ; encoding: [0x10,0x40,0x6c,0xdc,0x00,0x02,0x06,0x00]

scratch_store_short_d16_hi off, v2, off
// GFX940: scratch_store_short_d16_hi off, v2, off ; encoding: [0x00,0x40,0x6c,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_short_d16_hi off, v2, off offset:16
// GFX940: scratch_store_short_d16_hi off, v2, off offset:16 ; encoding: [0x10,0x40,0x6c,0xdc,0x00,0x02,0x7f,0x00]
