; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s

define <vscale x 1 x i32> @fshr(<vscale x 1 x i32> %a, <vscale x 1 x i32> %b, <vscale x 1 x i32> %c) {
; CHECK-LABEL: fshr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 31
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vx v11, v10, a0
; CHECK-NEXT:    vsrl.vv v9, v9, v11
; CHECK-NEXT:    vnot.v v10, v10
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vsll.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i32> @llvm.fshr.v4i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> %b, <vscale x 1 x i32> %c)
  ret <vscale x 1 x i32> %res
}

define <vscale x 1 x i32> @fshl(<vscale x 1 x i32> %a, <vscale x 1 x i32> %b, <vscale x 1 x i32> %c) {
; CHECK-LABEL: fshl:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 31
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vx v11, v10, a0
; CHECK-NEXT:    vsll.vv v8, v8, v11
; CHECK-NEXT:    vnot.v v10, v10
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vsrl.vi v9, v9, 1
; CHECK-NEXT:    vsrl.vv v9, v9, v10
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    ret
  %res = call <vscale x 1 x i32> @llvm.fshl.v4i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> %b, <vscale x 1 x i32> %c)
  ret <vscale x 1 x i32> %res
}

declare <vscale x 1 x i32> @llvm.fshr.v4i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> %b, <vscale x 1 x i32> %c)
declare <vscale x 1 x i32> @llvm.fshl.v4i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> %b, <vscale x 1 x i32> %c)
