// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1100 -show-encoding %s | FileCheck --check-prefix=GFX11 %s

ds_write_b32 v0, v1
// GFX11: encoding: [0x00,0x00,0x34,0xd8,0x00,0x01,0x00,0x00]

ds_write2_b32 v0, v1, v2
// GFX11: encoding: [0x00,0x00,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v0, v1, v2
// GFX11: encoding: [0x00,0x00,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write_b8 v0, v1
// GFX11: encoding: [0x00,0x00,0x78,0xd8,0x00,0x01,0x00,0x00]

ds_write_b16 v0, v1
// GFX11: encoding: [0x00,0x00,0x7c,0xd8,0x00,0x01,0x00,0x00]

ds_wrxchg_rtn_b32 v0, v1, v2
// GFX11: encoding: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x00]

ds_wrxchg2_rtn_b32 v[254:255], v1, v2, v3 offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0x03,0xfe]

ds_wrxchg2st64_rtn_b32 v[254:255], v1, v2, v3 offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0x03,0xfe]

ds_read_b32 v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0xd8,0xd8,0x01,0x00,0x00,0xff]

ds_read2_b32 v[254:255], v1 offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0xdc,0xd8,0x01,0x00,0x00,0xfe]

ds_read2st64_b32 v[254:255], v1 offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0xe0,0xd8,0x01,0x00,0x00,0xfe]

ds_read_i8 v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0xe4,0xd8,0x01,0x00,0x00,0xff]

ds_read_u8 v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0xe8,0xd8,0x01,0x00,0x00,0xff]

ds_read_i16 v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0xec,0xd8,0x01,0x00,0x00,0xff]

ds_read_u16 v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0xf0,0xd8,0x01,0x00,0x00,0xff]

ds_write_b64 v1, v[254:255] offset:65535
// GFX11: encoding: [0xff,0xff,0x34,0xd9,0x01,0xfe,0x00,0x00]

ds_write2_b64 v1, v[254:255], v[3:4] offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0x38,0xd9,0x01,0xfe,0x03,0x00]

ds_write2st64_b64 v1, v[254:255], v[3:4] offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0x3c,0xd9,0x01,0xfe,0x03,0x00]

ds_wrxchg_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// GFX11: encoding: [0xff,0xff,0xb4,0xd9,0x01,0x02,0x00,0xfe]

ds_wrxchg2_rtn_b64 v[252:255], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0x03,0xfc]

ds_wrxchg2st64_rtn_b64 v[252:255], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0x03,0xfc]

ds_read_b64 v[254:255], v1 offset:65535
// GFX11: encoding: [0xff,0xff,0xd8,0xd9,0x01,0x00,0x00,0xfe]

ds_read2_b64 v[252:255], v1 offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0xdc,0xd9,0x01,0x00,0x00,0xfc]

ds_read2st64_b64 v[252:255], v1 offset0:127 offset1:255
// GFX11: encoding: [0x7f,0xff,0xe0,0xd9,0x01,0x00,0x00,0xfc]

ds_write_b8_d16_hi v1, v2
// GFX11: encoding: [0x00,0x00,0x80,0xda,0x01,0x02,0x00,0x00]

ds_write_b16_d16_hi v1, v2
// GFX11: encoding: [0x00,0x00,0x84,0xda,0x01,0x02,0x00,0x00]

ds_read_u8_d16 v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0x88,0xda,0x01,0x00,0x00,0xff]

ds_read_u8_d16_hi v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0x8c,0xda,0x01,0x00,0x00,0xff]

ds_read_i8_d16 v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0x90,0xda,0x01,0x00,0x00,0xff]

ds_read_i8_d16_hi v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0x94,0xda,0x01,0x00,0x00,0xff]

ds_read_u16_d16 v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0x98,0xda,0x01,0x00,0x00,0xff]

ds_read_u16_d16_hi v255, v1 offset:65535
// GFX11: encoding: [0xff,0xff,0x9c,0xda,0x01,0x00,0x00,0xff]

ds_write_addtid_b32 v255 offset:65535
// GFX11: encoding: [0xff,0xff,0xc0,0xda,0x00,0xff,0x00,0x00]

ds_read_addtid_b32 v255 offset:65535
// GFX11: encoding: [0xff,0xff,0xc4,0xda,0x00,0x00,0x00,0xff]

ds_write_b96 v1, v[253:255] offset:65535
// GFX11: encoding: [0xff,0xff,0x78,0xdb,0x01,0xfd,0x00,0x00]

ds_write_b128 v1, v[252:255] offset:65535
// GFX11: encoding: [0xff,0xff,0x7c,0xdb,0x01,0xfc,0x00,0x00]

ds_read_b96 v[253:255], v1 offset:65535
// GFX11: encoding: [0xff,0xff,0xf8,0xdb,0x01,0x00,0x00,0xfd]

ds_read_b128 v[252:255], v1 offset:65535
// GFX11: encoding: [0xff,0xff,0xfc,0xdb,0x01,0x00,0x00,0xfc]

ds_add_gs_reg_rtn v[5:6], v255 offset:127 gds
// GFX11: encoding: [0x7f,0x00,0xea,0xd9,0x00,0xff,0x00,0x05]

ds_add_gs_reg_rtn v[5:6], v255 gds
// GFX11: encoding: [0x00,0x00,0xea,0xd9,0x00,0xff,0x00,0x05]

ds_sub_gs_reg_rtn v[5:6], v255 offset:127 gds
// GFX11: encoding: [0x7f,0x00,0xee,0xd9,0x00,0xff,0x00,0x05]

ds_sub_gs_reg_rtn v[5:6], v255 gds
// GFX11: encoding: [0x00,0x00,0xee,0xd9,0x00,0xff,0x00,0x05]

ds_swizzle_b32 v8, v2
// GFX11: encoding: [0x00,0x00,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:0
// GFX11: encoding: [0x00,0x00,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:0xFFFF
// GFX11: encoding: [0xff,0xff,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(QUAD_PERM, 0, 1, 2, 3)
// GFX11: encoding: [0xe4,0x80,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(SWAP,16)
// GFX11: encoding: [0x1f,0x40,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(REVERSE,8)
// GFX11: encoding: [0x1f,0x1c,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(BROADCAST,4,1)
// GFX11: encoding: [0x3c,0x00,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(BROADCAST,8,7)
// GFX11: encoding: [0xf8,0x00,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(BITMASK_PERM, "01pip")
// GFX11: encoding: [0x07,0x09,0xd4,0xd8,0x02,0x00,0x00,0x08]
