; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv32 -mattr=+f -target-abi=ilp32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32IF %s
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zbt -target-abi=ilp32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32IBT %s
; RUN: llc -mtriple=riscv32 -mattr=+f,+experimental-zbt -target-abi=ilp32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32IFBT %s
; RUN: llc -mtriple=riscv64 -target-abi=lp64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s
; RUN: llc -mtriple=riscv64 -mattr=+f,+d -target-abi=lp64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64IFD %s
; RUN: llc -mtriple=riscv64 -mattr=+experimental-zbt -target-abi=lp64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64IBT %s
; RUN: llc -mtriple=riscv64 -mattr=+f,+d,+experimental-zbt -target-abi=lp64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64IFDBT %s

;; This tests how good we are at materialising constants using `select`. The aim
;; is that we do so without a branch if possible (at the moment our lowering of
;; select always introduces a branch).
;;
;; Currently the hook `convertSelectOfConstantsToMath` only is useful when the
;; constants are either 1 away from each other, or one is a power of two and
;; the other is zero.

define signext i32 @select_const_int_easy(i1 zeroext %a) nounwind {
; RV32I-LABEL: select_const_int_easy:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_const_int_easy:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_const_int_easy:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_const_int_easy:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_const_int_easy:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_const_int_easy:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_const_int_easy:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_const_int_easy:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    ret
  %1 = select i1 %a, i32 1, i32 0
  ret i32 %1
}

define signext i32 @select_const_int_one_away(i1 zeroext %a) nounwind {
; RV32I-LABEL: select_const_int_one_away:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 4
; RV32I-NEXT:    sub a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_const_int_one_away:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    li a1, 4
; RV32IF-NEXT:    sub a0, a1, a0
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_const_int_one_away:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    li a1, 4
; RV32IBT-NEXT:    sub a0, a1, a0
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_const_int_one_away:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    li a1, 4
; RV32IFBT-NEXT:    sub a0, a1, a0
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_const_int_one_away:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 4
; RV64I-NEXT:    sub a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_const_int_one_away:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    li a1, 4
; RV64IFD-NEXT:    sub a0, a1, a0
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_const_int_one_away:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    li a1, 4
; RV64IBT-NEXT:    sub a0, a1, a0
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_const_int_one_away:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    li a1, 4
; RV64IFDBT-NEXT:    sub a0, a1, a0
; RV64IFDBT-NEXT:    ret
  %1 = select i1 %a, i32 3, i32 4
  ret i32 %1
}

define signext i32 @select_const_int_pow2_zero(i1 zeroext %a) nounwind {
; RV32I-LABEL: select_const_int_pow2_zero:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_const_int_pow2_zero:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    slli a0, a0, 2
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_const_int_pow2_zero:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    slli a0, a0, 2
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_const_int_pow2_zero:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    slli a0, a0, 2
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_const_int_pow2_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 2
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_const_int_pow2_zero:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    slli a0, a0, 2
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_const_int_pow2_zero:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    slli a0, a0, 2
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_const_int_pow2_zero:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    slli a0, a0, 2
; RV64IFDBT-NEXT:    ret
  %1 = select i1 %a, i32 4, i32 0
  ret i32 %1
}

define signext i32 @select_const_int_harder(i1 zeroext %a) nounwind {
; RV32I-LABEL: select_const_int_harder:
; RV32I:       # %bb.0:
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    li a0, 6
; RV32I-NEXT:    bnez a1, .LBB3_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a0, 38
; RV32I-NEXT:  .LBB3_2:
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_const_int_harder:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    mv a1, a0
; RV32IF-NEXT:    li a0, 6
; RV32IF-NEXT:    bnez a1, .LBB3_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    li a0, 38
; RV32IF-NEXT:  .LBB3_2:
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_const_int_harder:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    li a1, 38
; RV32IBT-NEXT:    li a2, 6
; RV32IBT-NEXT:    cmov a0, a0, a2, a1
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_const_int_harder:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    li a1, 38
; RV32IFBT-NEXT:    li a2, 6
; RV32IFBT-NEXT:    cmov a0, a0, a2, a1
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_const_int_harder:
; RV64I:       # %bb.0:
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    li a0, 6
; RV64I-NEXT:    bnez a1, .LBB3_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    li a0, 38
; RV64I-NEXT:  .LBB3_2:
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_const_int_harder:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    mv a1, a0
; RV64IFD-NEXT:    li a0, 6
; RV64IFD-NEXT:    bnez a1, .LBB3_2
; RV64IFD-NEXT:  # %bb.1:
; RV64IFD-NEXT:    li a0, 38
; RV64IFD-NEXT:  .LBB3_2:
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_const_int_harder:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    li a1, 38
; RV64IBT-NEXT:    li a2, 6
; RV64IBT-NEXT:    cmov a0, a0, a2, a1
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_const_int_harder:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    li a1, 38
; RV64IFDBT-NEXT:    li a2, 6
; RV64IFDBT-NEXT:    cmov a0, a0, a2, a1
; RV64IFDBT-NEXT:    ret
  %1 = select i1 %a, i32 6, i32 38
  ret i32 %1
}

define float @select_const_fp(i1 zeroext %a) nounwind {
; RV32I-LABEL: select_const_fp:
; RV32I:       # %bb.0:
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    lui a0, 263168
; RV32I-NEXT:    bnez a1, .LBB4_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    lui a0, 264192
; RV32I-NEXT:  .LBB4_2:
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_const_fp:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    bnez a0, .LBB4_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    lui a0, %hi(.LCPI4_0)
; RV32IF-NEXT:    flw ft0, %lo(.LCPI4_0)(a0)
; RV32IF-NEXT:    fmv.x.w a0, ft0
; RV32IF-NEXT:    ret
; RV32IF-NEXT:  .LBB4_2:
; RV32IF-NEXT:    lui a0, %hi(.LCPI4_1)
; RV32IF-NEXT:    flw ft0, %lo(.LCPI4_1)(a0)
; RV32IF-NEXT:    fmv.x.w a0, ft0
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_const_fp:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    lui a1, 264192
; RV32IBT-NEXT:    lui a2, 263168
; RV32IBT-NEXT:    cmov a0, a0, a2, a1
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_const_fp:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    bnez a0, .LBB4_2
; RV32IFBT-NEXT:  # %bb.1:
; RV32IFBT-NEXT:    lui a0, %hi(.LCPI4_0)
; RV32IFBT-NEXT:    flw ft0, %lo(.LCPI4_0)(a0)
; RV32IFBT-NEXT:    fmv.x.w a0, ft0
; RV32IFBT-NEXT:    ret
; RV32IFBT-NEXT:  .LBB4_2:
; RV32IFBT-NEXT:    lui a0, %hi(.LCPI4_1)
; RV32IFBT-NEXT:    flw ft0, %lo(.LCPI4_1)(a0)
; RV32IFBT-NEXT:    fmv.x.w a0, ft0
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_const_fp:
; RV64I:       # %bb.0:
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    lui a0, 263168
; RV64I-NEXT:    bnez a1, .LBB4_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    lui a0, 264192
; RV64I-NEXT:  .LBB4_2:
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_const_fp:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    bnez a0, .LBB4_2
; RV64IFD-NEXT:  # %bb.1:
; RV64IFD-NEXT:    lui a0, %hi(.LCPI4_0)
; RV64IFD-NEXT:    flw ft0, %lo(.LCPI4_0)(a0)
; RV64IFD-NEXT:    fmv.x.w a0, ft0
; RV64IFD-NEXT:    ret
; RV64IFD-NEXT:  .LBB4_2:
; RV64IFD-NEXT:    lui a0, %hi(.LCPI4_1)
; RV64IFD-NEXT:    flw ft0, %lo(.LCPI4_1)(a0)
; RV64IFD-NEXT:    fmv.x.w a0, ft0
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_const_fp:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    lui a1, 264192
; RV64IBT-NEXT:    lui a2, 263168
; RV64IBT-NEXT:    cmov a0, a0, a2, a1
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_const_fp:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    bnez a0, .LBB4_2
; RV64IFDBT-NEXT:  # %bb.1:
; RV64IFDBT-NEXT:    lui a0, %hi(.LCPI4_0)
; RV64IFDBT-NEXT:    flw ft0, %lo(.LCPI4_0)(a0)
; RV64IFDBT-NEXT:    fmv.x.w a0, ft0
; RV64IFDBT-NEXT:    ret
; RV64IFDBT-NEXT:  .LBB4_2:
; RV64IFDBT-NEXT:    lui a0, %hi(.LCPI4_1)
; RV64IFDBT-NEXT:    flw ft0, %lo(.LCPI4_1)(a0)
; RV64IFDBT-NEXT:    fmv.x.w a0, ft0
; RV64IFDBT-NEXT:    ret
  %1 = select i1 %a, float 3.0, float 4.0
  ret float %1
}

define signext i32 @select_eq_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_eq_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_eq_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    xor a0, a0, a1
; RV32IF-NEXT:    seqz a0, a0
; RV32IF-NEXT:    neg a0, a0
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_eq_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    xor a0, a0, a1
; RV32IBT-NEXT:    seqz a0, a0
; RV32IBT-NEXT:    neg a0, a0
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_eq_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    xor a0, a0, a1
; RV32IFBT-NEXT:    seqz a0, a0
; RV32IFBT-NEXT:    neg a0, a0
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_eq_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    neg a0, a0
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_eq_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    xor a0, a0, a1
; RV64IFD-NEXT:    seqz a0, a0
; RV64IFD-NEXT:    neg a0, a0
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_eq_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    xor a0, a0, a1
; RV64IBT-NEXT:    seqz a0, a0
; RV64IBT-NEXT:    neg a0, a0
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_eq_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    xor a0, a0, a1
; RV64IFDBT-NEXT:    seqz a0, a0
; RV64IFDBT-NEXT:    neg a0, a0
; RV64IFDBT-NEXT:    ret
  %1 = icmp eq i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_ne_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_ne_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_ne_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    xor a0, a0, a1
; RV32IF-NEXT:    snez a0, a0
; RV32IF-NEXT:    neg a0, a0
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_ne_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    xor a0, a0, a1
; RV32IBT-NEXT:    snez a0, a0
; RV32IBT-NEXT:    neg a0, a0
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_ne_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    xor a0, a0, a1
; RV32IFBT-NEXT:    snez a0, a0
; RV32IFBT-NEXT:    neg a0, a0
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_ne_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    neg a0, a0
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_ne_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    xor a0, a0, a1
; RV64IFD-NEXT:    snez a0, a0
; RV64IFD-NEXT:    neg a0, a0
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_ne_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    xor a0, a0, a1
; RV64IBT-NEXT:    snez a0, a0
; RV64IBT-NEXT:    neg a0, a0
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_ne_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    xor a0, a0, a1
; RV64IFDBT-NEXT:    snez a0, a0
; RV64IFDBT-NEXT:    neg a0, a0
; RV64IFDBT-NEXT:    ret
  %1 = icmp ne i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_sgt_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_sgt_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a1, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_sgt_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    slt a0, a1, a0
; RV32IF-NEXT:    neg a0, a0
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_sgt_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    slt a0, a1, a0
; RV32IBT-NEXT:    neg a0, a0
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_sgt_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    slt a0, a1, a0
; RV32IFBT-NEXT:    neg a0, a0
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_sgt_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    neg a0, a0
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_sgt_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    slt a0, a1, a0
; RV64IFD-NEXT:    neg a0, a0
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_sgt_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    slt a0, a1, a0
; RV64IBT-NEXT:    neg a0, a0
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_sgt_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    slt a0, a1, a0
; RV64IFDBT-NEXT:    neg a0, a0
; RV64IFDBT-NEXT:    ret
  %1 = icmp sgt i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_slt_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_slt_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a0, a1
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_slt_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    slt a0, a0, a1
; RV32IF-NEXT:    neg a0, a0
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_slt_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    slt a0, a0, a1
; RV32IBT-NEXT:    neg a0, a0
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_slt_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    slt a0, a0, a1
; RV32IFBT-NEXT:    neg a0, a0
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_slt_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    neg a0, a0
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_slt_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    slt a0, a0, a1
; RV64IFD-NEXT:    neg a0, a0
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_slt_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    slt a0, a0, a1
; RV64IBT-NEXT:    neg a0, a0
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_slt_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    slt a0, a0, a1
; RV64IFDBT-NEXT:    neg a0, a0
; RV64IFDBT-NEXT:    ret
  %1 = icmp slt i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_sge_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_sge_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a0, a1
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_sge_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    slt a0, a0, a1
; RV32IF-NEXT:    addi a0, a0, -1
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_sge_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    slt a0, a0, a1
; RV32IBT-NEXT:    addi a0, a0, -1
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_sge_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    slt a0, a0, a1
; RV32IFBT-NEXT:    addi a0, a0, -1
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_sge_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_sge_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    slt a0, a0, a1
; RV64IFD-NEXT:    addi a0, a0, -1
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_sge_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    slt a0, a0, a1
; RV64IBT-NEXT:    addi a0, a0, -1
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_sge_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    slt a0, a0, a1
; RV64IFDBT-NEXT:    addi a0, a0, -1
; RV64IFDBT-NEXT:    ret
  %1 = icmp sge i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_sle_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_sle_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a1, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_sle_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    slt a0, a1, a0
; RV32IF-NEXT:    addi a0, a0, -1
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_sle_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    slt a0, a1, a0
; RV32IBT-NEXT:    addi a0, a0, -1
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_sle_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    slt a0, a1, a0
; RV32IFBT-NEXT:    addi a0, a0, -1
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_sle_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_sle_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    slt a0, a1, a0
; RV64IFD-NEXT:    addi a0, a0, -1
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_sle_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    slt a0, a1, a0
; RV64IBT-NEXT:    addi a0, a0, -1
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_sle_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    slt a0, a1, a0
; RV64IFDBT-NEXT:    addi a0, a0, -1
; RV64IFDBT-NEXT:    ret
  %1 = icmp sle i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_ugt_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_ugt_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_ugt_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    sltu a0, a1, a0
; RV32IF-NEXT:    neg a0, a0
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_ugt_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    sltu a0, a1, a0
; RV32IBT-NEXT:    neg a0, a0
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_ugt_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    sltu a0, a1, a0
; RV32IFBT-NEXT:    neg a0, a0
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_ugt_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    neg a0, a0
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_ugt_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    sltu a0, a1, a0
; RV64IFD-NEXT:    neg a0, a0
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_ugt_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    sltu a0, a1, a0
; RV64IBT-NEXT:    neg a0, a0
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_ugt_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    sltu a0, a1, a0
; RV64IFDBT-NEXT:    neg a0, a0
; RV64IFDBT-NEXT:    ret
  %1 = icmp ugt i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_ult_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_ult_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_ult_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    sltu a0, a0, a1
; RV32IF-NEXT:    neg a0, a0
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_ult_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    sltu a0, a0, a1
; RV32IBT-NEXT:    neg a0, a0
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_ult_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    sltu a0, a0, a1
; RV32IFBT-NEXT:    neg a0, a0
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_ult_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    neg a0, a0
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_ult_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    sltu a0, a0, a1
; RV64IFD-NEXT:    neg a0, a0
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_ult_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    sltu a0, a0, a1
; RV64IBT-NEXT:    neg a0, a0
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_ult_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    sltu a0, a0, a1
; RV64IFDBT-NEXT:    neg a0, a0
; RV64IFDBT-NEXT:    ret
  %1 = icmp ult i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_uge_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_uge_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_uge_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    sltu a0, a0, a1
; RV32IF-NEXT:    addi a0, a0, -1
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_uge_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    sltu a0, a0, a1
; RV32IBT-NEXT:    addi a0, a0, -1
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_uge_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    sltu a0, a0, a1
; RV32IFBT-NEXT:    addi a0, a0, -1
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_uge_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_uge_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    sltu a0, a0, a1
; RV64IFD-NEXT:    addi a0, a0, -1
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_uge_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    sltu a0, a0, a1
; RV64IBT-NEXT:    addi a0, a0, -1
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_uge_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    sltu a0, a0, a1
; RV64IFDBT-NEXT:    addi a0, a0, -1
; RV64IFDBT-NEXT:    ret
  %1 = icmp uge i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_ule_zero_negone(i32 signext %a, i32 signext %b) nounwind {
; RV32I-LABEL: select_ule_zero_negone:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    ret
;
; RV32IF-LABEL: select_ule_zero_negone:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    sltu a0, a1, a0
; RV32IF-NEXT:    addi a0, a0, -1
; RV32IF-NEXT:    ret
;
; RV32IBT-LABEL: select_ule_zero_negone:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    sltu a0, a1, a0
; RV32IBT-NEXT:    addi a0, a0, -1
; RV32IBT-NEXT:    ret
;
; RV32IFBT-LABEL: select_ule_zero_negone:
; RV32IFBT:       # %bb.0:
; RV32IFBT-NEXT:    sltu a0, a1, a0
; RV32IFBT-NEXT:    addi a0, a0, -1
; RV32IFBT-NEXT:    ret
;
; RV64I-LABEL: select_ule_zero_negone:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64IFD-LABEL: select_ule_zero_negone:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    sltu a0, a1, a0
; RV64IFD-NEXT:    addi a0, a0, -1
; RV64IFD-NEXT:    ret
;
; RV64IBT-LABEL: select_ule_zero_negone:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    sltu a0, a1, a0
; RV64IBT-NEXT:    addi a0, a0, -1
; RV64IBT-NEXT:    ret
;
; RV64IFDBT-LABEL: select_ule_zero_negone:
; RV64IFDBT:       # %bb.0:
; RV64IFDBT-NEXT:    sltu a0, a1, a0
; RV64IFDBT-NEXT:    addi a0, a0, -1
; RV64IFDBT-NEXT:    ret
  %1 = icmp ule i32 %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}
