; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-ibm-aix-xcoff -vec-extabi -mcpu=pwr9 < %s | FileCheck %s -check-prefix=CHECK-64
; RUN: llc -verify-machineinstrs -mtriple=powerpc-ibm-aix-xcoff -vec-extabi -mcpu=pwr9 < %s | FileCheck %s -check-prefix=CHECK-32

define zeroext i8 @test_add1(<16 x i8> %a, i32 signext %index, i8 zeroext %c) {
; CHECK-64-LABEL: test_add1:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vextublx 3, 3, 2
; CHECK-64-NEXT:    add 3, 3, 4
; CHECK-64-NEXT:    clrldi 3, 3, 56
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test_add1:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 5, 1, -16
; CHECK-32-NEXT:    clrlwi 3, 3, 28
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lbzx 3, 5, 3
; CHECK-32-NEXT:    add 3, 3, 4
; CHECK-32-NEXT:    clrlwi 3, 3, 24
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 %index
  %conv = zext i8 %vecext to i32
  %conv1 = zext i8 %c to i32
  %add = add nuw nsw i32 %conv, %conv1
  %conv2 = trunc i32 %add to i8
  ret i8 %conv2
}

define signext i8 @test_add2(<16 x i8> %a, i32 signext %index, i8 signext %c) {
; CHECK-64-LABEL: test_add2:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vextublx 3, 3, 2
; CHECK-64-NEXT:    add 3, 3, 4
; CHECK-64-NEXT:    extsb 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test_add2:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 5, 1, -16
; CHECK-32-NEXT:    clrlwi 3, 3, 28
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lbzx 3, 5, 3
; CHECK-32-NEXT:    add 3, 3, 4
; CHECK-32-NEXT:    extsb 3, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 %index
  %conv3 = zext i8 %vecext to i32
  %conv14 = zext i8 %c to i32
  %add = add nuw nsw i32 %conv3, %conv14
  %conv2 = trunc i32 %add to i8
  ret i8 %conv2
}

define zeroext i16 @test_add3(<8 x i16> %a, i32 signext %index, i16 zeroext %c) {
; CHECK-64-LABEL: test_add3:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-64-NEXT:    vextuhlx 3, 3, 2
; CHECK-64-NEXT:    add 3, 3, 4
; CHECK-64-NEXT:    clrldi 3, 3, 48
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test_add3:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 5, 1, -16
; CHECK-32-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lhzx 3, 5, 3
; CHECK-32-NEXT:    add 3, 3, 4
; CHECK-32-NEXT:    clrlwi 3, 3, 16
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 %index
  %conv = zext i16 %vecext to i32
  %conv1 = zext i16 %c to i32
  %add = add nuw nsw i32 %conv, %conv1
  %conv2 = trunc i32 %add to i16
  ret i16 %conv2
}

define signext i16 @test_add4(<8 x i16> %a, i32 signext %index, i16 signext %c) {
; CHECK-64-LABEL: test_add4:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-64-NEXT:    vextuhlx 3, 3, 2
; CHECK-64-NEXT:    add 3, 3, 4
; CHECK-64-NEXT:    extsh 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test_add4:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 5, 1, -16
; CHECK-32-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lhzx 3, 5, 3
; CHECK-32-NEXT:    add 3, 3, 4
; CHECK-32-NEXT:    extsh 3, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 %index
  %conv5 = zext i16 %vecext to i32
  %conv16 = zext i16 %c to i32
  %add = add nuw nsw i32 %conv5, %conv16
  %conv2 = trunc i32 %add to i16
  ret i16 %conv2
}

define zeroext i32 @test_add5(<4 x i32> %a, i32 signext %index, i32 zeroext %c) {
; CHECK-64-LABEL: test_add5:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-64-NEXT:    vextuwlx 3, 3, 2
; CHECK-64-NEXT:    add 3, 3, 4
; CHECK-64-NEXT:    clrldi 3, 3, 32
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test_add5:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 5, 1, -16
; CHECK-32-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwzx 3, 5, 3
; CHECK-32-NEXT:    add 3, 3, 4
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 %index
  %add = add i32 %vecext, %c
  ret i32 %add
}

define signext i32 @test_add6(<4 x i32> %a, i32 signext %index, i32 signext %c) {
; CHECK-64-LABEL: test_add6:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-64-NEXT:    vextuwlx 3, 3, 2
; CHECK-64-NEXT:    add 3, 3, 4
; CHECK-64-NEXT:    extsw 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test_add6:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 5, 1, -16
; CHECK-32-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwzx 3, 5, 3
; CHECK-32-NEXT:    add 3, 3, 4
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 %index
  %add = add nsw i32 %vecext, %c
  ret i32 %add
}

; When extracting word element 2 on LE, it's better to use mfvsrwz rather than vextuwrx
define zeroext i32 @test7(<4 x i32> %a) {
; CHECK-64-LABEL: test7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    li 3, 8
; CHECK-64-NEXT:    vextuwlx 3, 3, 2
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwz 3, -8(1)
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 2
  ret i32 %vecext
}

define zeroext i32 @testadd_7(<4 x i32> %a, i32 zeroext %c) {
; CHECK-64-LABEL: testadd_7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    li 4, 8
; CHECK-64-NEXT:    vextuwlx 4, 4, 2
; CHECK-64-NEXT:    add 3, 4, 3
; CHECK-64-NEXT:    clrldi 3, 3, 32
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: testadd_7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwz 4, -8(1)
; CHECK-32-NEXT:    add 3, 4, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 2
  %add = add i32 %vecext, %c
  ret i32 %add
}

define signext i32 @test8(<4 x i32> %a) {
; CHECK-64-LABEL: test8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    li 3, 8
; CHECK-64-NEXT:    vextuwlx 3, 3, 2
; CHECK-64-NEXT:    extsw 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwz 3, -8(1)
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 2
  ret i32 %vecext
}

define signext i32 @testadd_8(<4 x i32> %a, i32 signext %c) {
; CHECK-64-LABEL: testadd_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    li 4, 8
; CHECK-64-NEXT:    vextuwlx 4, 4, 2
; CHECK-64-NEXT:    add 3, 4, 3
; CHECK-64-NEXT:    extsw 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: testadd_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwz 4, -8(1)
; CHECK-32-NEXT:    add 3, 4, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 2
  %add = add nsw i32 %vecext, %c
  ret i32 %add
}

; When extracting word element 1 on BE, it's better to use mfvsrwz rather than vextuwlx
define signext i32 @test9(<4 x i32> %a) {
; CHECK-64-LABEL: test9:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    mfvsrwz 3, 34
; CHECK-64-NEXT:    extsw 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test9:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwz 3, -12(1)
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 1
  ret i32 %vecext
}

define signext i32 @testadd_9(<4 x i32> %a, i32 signext %c) {
; CHECK-64-LABEL: testadd_9:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    mfvsrwz 4, 34
; CHECK-64-NEXT:    add 3, 4, 3
; CHECK-64-NEXT:    extsw 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: testadd_9:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwz 4, -12(1)
; CHECK-32-NEXT:    add 3, 4, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 1
  %add = add nsw i32 %vecext, %c
  ret i32 %add
}
