// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py

// RUN: %clang_cc1 -triple x86_64 -S -emit-llvm -o - %s | opt -S -verify | FileCheck %s
//
// Verifies that clang detects memcmp inline version and uses it instead of the builtin.

typedef unsigned long size_t;

// Clang requires these attributes for a function to be redefined.
#define AVAILABLE_EXTERNALLY extern inline __attribute__((always_inline)) __attribute__((gnu_inline))

const void *con_unify_unimap_p1;

AVAILABLE_EXTERNALLY
int memcmp(const void *p, const void *q, unsigned long size) {
  return __builtin_memcmp(p, q, size);
}

// CHECK-LABEL: @con_unify_unimap_q1(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[P_ADDR_I:%.*]] = alloca i8*, align 8
// CHECK-NEXT:    [[Q_ADDR_I:%.*]] = alloca i8*, align 8
// CHECK-NEXT:    [[SIZE_ADDR_I:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load i8*, i8** @con_unify_unimap_p1, align 8
// CHECK-NEXT:    store i8* [[TMP0]], i8** [[P_ADDR_I]], align 8
// CHECK-NEXT:    store i8* bitcast (i32 ()* @con_unify_unimap_q1 to i8*), i8** [[Q_ADDR_I]], align 8
// CHECK-NEXT:    store i64 4, i64* [[SIZE_ADDR_I]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[P_ADDR_I]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load i8*, i8** [[Q_ADDR_I]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load i64, i64* [[SIZE_ADDR_I]], align 8
// CHECK-NEXT:    [[CALL_I:%.*]] = call i32 @memcmp(i8* noundef [[TMP1]], i8* noundef [[TMP2]], i64 noundef [[TMP3]]) #[[ATTR3:[0-9]+]]
// CHECK-NEXT:    ret i32 [[CALL_I]]
//
int con_unify_unimap_q1(void) {
  return memcmp(con_unify_unimap_p1, con_unify_unimap_q1, sizeof(int));
}
