; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -show-mc-encoding | FileCheck %s

target triple = "x86_64-unknown-unknown"

@g64 = external global i64, align 8
@g32 = external global i32, align 4
@g16 = external global i16, align 2
@g8 = external global i8, align 1

declare void @a()
declare void @b()

define void @add64_imm32_br() nounwind {
; CHECK-LABEL: add64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $16777214, {{.*}}(%rip) # encoding: [0x48,0x81,0x05,A,A,A,A,0xfe,0xff,0xff,0x00]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0xFFFFFE
; CHECK-NEXT:    js .LBB0_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB0_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB0_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Add 0x00FFFFFE, a positive immediate requiring 24-bits.
  %add = add i64 %load1, 16777214
  store i64 %add, i64* @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_sext_imm32_br() nounwind {
; CHECK-LABEL: add64_sext_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $-2147483648, {{.*}}(%rip) # encoding: [0x48,0x81,0x05,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    js .LBB1_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB1_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB1_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Add -0x80000000, which requires sign-extended 32 bits.
  %add = add i64 %load1, -2147483648
  store i64 %add, i64* @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_imm32_via_sub_br() nounwind {
; CHECK-LABEL: add64_imm32_via_sub_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq $-2147483648, {{.*}}(%rip) # encoding: [0x48,0x81,0x2d,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    js .LBB2_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB2_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB2_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Add 0x80000000, which cannot fit in a sign extended 32-bit immediate. This
  ; get's folded because we can instead subtract -0x80000000.
  %add = add i64 %load1, 2147483648
  store i64 %add, i64* @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_no_imm32_via_sub_due_to_cf_br() nounwind {
; CHECK-LABEL: add64_no_imm32_via_sub_due_to_cf_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $2147483648, %eax # encoding: [0xb8,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    addq %rax, {{.*}}(%rip) # encoding: [0x48,0x01,0x05,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jae .LBB3_2 # encoding: [0x73,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB3_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB3_2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Add 0x80000000, which cannot fit in a sign extended 32-bit immediate, but
  ; could in theory be folded into an immediate operand of a sub. However, we
  ; use the CF flag here and so shouldn't make that transformation.
  %add = add i64 %load1, 2147483648
  store i64 %add, i64* @g64
  %cond = icmp ult i64 %add, 2147483648
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_too_large_imm32_br() nounwind {
; CHECK-LABEL: add64_too_large_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $2147483649, %eax # encoding: [0xb8,0x01,0x00,0x00,0x80]
; CHECK-NEXT:    # imm = 0x80000001
; CHECK-NEXT:    addq %rax, {{.*}}(%rip) # encoding: [0x48,0x01,0x05,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB4_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB4_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB4_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Add 0x80000001, which cannot fit in a sign extended 32-bit immediate. This
  ; should not get folded into an immediate.
  %add = add i64 %load1, 2147483649
  store i64 %add, i64* @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_imm8_via_sub_br() nounwind {
; CHECK-LABEL: add64_imm8_via_sub_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq $-128, {{.*}}(%rip) # encoding: [0x48,0x83,0x2d,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB5_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB5_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB5_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Add 0x80 which can't quite fit into an imm8 because it would be sign
  ; extended, but which can fit if we convert to a sub and negate the value.
  %add = add i64 %load1, 128
  store i64 %add, i64* @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_imm8_br() nounwind {
; CHECK-LABEL: add64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $42, {{.*}}(%rip) # encoding: [0x48,0x83,0x05,A,A,A,A,0x2a]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB6_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB6_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB6_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %add = add i64 %load1, 42
  store i64 %add, i64* @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_imm8_neg_br() nounwind {
; CHECK-LABEL: add64_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $-42, {{.*}}(%rip) # encoding: [0x48,0x83,0x05,A,A,A,A,0xd6]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB7_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB7_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB7_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %add = add i64 %load1, -42
  store i64 %add, i64* @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add32_imm_br() nounwind {
; CHECK-LABEL: add32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-2147483648, {{.*}}(%rip) # encoding: [0x81,0x05,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    js .LBB8_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB8_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB8_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  ; Add 0x80000000, a positive number requiring 32 bits of immediate.
  %add = add i32 %load1, 2147483648
  store i32 %add, i32* @g32
  %cond = icmp slt i32 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add32_imm8_br() nounwind {
; CHECK-LABEL: add32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $42, {{.*}}(%rip) # encoding: [0x83,0x05,A,A,A,A,0x2a]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB9_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB9_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB9_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %add = add i32 %load1, 42
  store i32 %add, i32* @g32
  %cond = icmp slt i32 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add32_imm8_neg_br() nounwind {
; CHECK-LABEL: add32_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-42, {{.*}}(%rip) # encoding: [0x83,0x05,A,A,A,A,0xd6]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB10_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB10_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB10_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %add = add i32 %load1, -42
  store i32 %add, i32* @g32
  %cond = icmp slt i32 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add16_imm_br() nounwind {
; CHECK-LABEL: add16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $-32768, {{.*}}(%rip) # encoding: [0x66,0x81,0x05,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    js .LBB11_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB11_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB11_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  ; Add 0x8000, a positive number requiring 16 bits of immediate.
  %add = add i16 %load1, 32768
  store i16 %add, i16* @g16
  %cond = icmp slt i16 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add16_imm8_br() nounwind {
; CHECK-LABEL: add16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $42, {{.*}}(%rip) # encoding: [0x66,0x83,0x05,A,A,A,A,0x2a]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB12_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB12_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB12_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %add = add i16 %load1, 42
  store i16 %add, i16* @g16
  %cond = icmp slt i16 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add16_imm8_neg_br() nounwind {
; CHECK-LABEL: add16_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $-42, {{.*}}(%rip) # encoding: [0x66,0x83,0x05,A,A,A,A,0xd6]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB13_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB13_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB13_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %add = add i16 %load1, -42
  store i16 %add, i16* @g16
  %cond = icmp slt i16 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add8_imm_br() nounwind {
; CHECK-LABEL: add8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $-2, {{.*}}(%rip) # encoding: [0x80,0x05,A,A,A,A,0xfe]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB14_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB14_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB14_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %add = add i8 %load1, -2
  store i8 %add, i8* @g8
  %cond = icmp slt i8 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: add64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq %rdi, {{.*}}(%rip) # encoding: [0x48,0x01,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB15_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB15_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB15_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %add = add i64 %load1, %arg
  store i64 %add, i64* @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: add32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl %edi, {{.*}}(%rip) # encoding: [0x01,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB16_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB16_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB16_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %add = add i32 %load1, %arg
  store i32 %add, i32* @g32
  %cond = icmp slt i32 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: add16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw %di, {{.*}}(%rip) # encoding: [0x66,0x01,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB17_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB17_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB17_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %add = add i16 %load1, %arg
  store i16 %add, i16* @g16
  %cond = icmp slt i16 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: add8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb %dil, {{.*}}(%rip) # encoding: [0x40,0x00,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB18_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB18_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB18_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %add = add i8 %load1, %arg
  store i8 %add, i8* @g8
  %cond = icmp slt i8 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub64_imm32_br() nounwind {
; CHECK-LABEL: sub64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq $-2147483648, {{.*}}(%rip) # encoding: [0x48,0x81,0x2d,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    js .LBB19_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB19_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB19_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Subtract -0x80000000, which can't be negated into a sign-extended 32-bit
  ; immediate, so that we have to select sub here.
  %sub = sub i64 %load1, -2147483648
  store i64 %sub, i64* @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub64_too_large_imm32_br() nounwind {
; CHECK-LABEL: sub64_too_large_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movabsq $-4294967295, %rax # encoding: [0x48,0xb8,0x01,0x00,0x00,0x00,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    # imm = 0xFFFFFFFF00000001
; CHECK-NEXT:    addq %rax, {{.*}}(%rip) # encoding: [0x48,0x01,0x05,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB20_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB20_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB20_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Subtract 0xFFFFFFFF, which cannot fit in a sign extended 32-bit immediate,
  ; even if negated and sign extended as an add.
  %sub = sub i64 %load1, 4294967295
  store i64 %sub, i64* @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub64_imm8_br() nounwind {
; CHECK-LABEL: sub64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq $-128, {{.*}}(%rip) # encoding: [0x48,0x83,0x2d,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB21_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB21_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB21_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Subtract -0x80, which can be done with an 8-bit immediate but only as
  ; a subtract where that immediate can be negative.
  %sub = sub i64 %load1, -128
  store i64 %sub, i64* @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub32_imm_br() nounwind {
; CHECK-LABEL: sub32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-2147483648, {{.*}}(%rip) # encoding: [0x81,0x05,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    js .LBB22_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB22_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB22_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  ; Subtract -0x80000000, which requires 32 bits of immediate but still gets
  ; lowered as an add.
  %sub = sub i32 %load1, -2147483648
  store i32 %sub, i32* @g32
  %cond = icmp slt i32 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub32_imm8_br() nounwind {
; CHECK-LABEL: sub32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl $-128, {{.*}}(%rip) # encoding: [0x83,0x2d,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB23_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB23_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB23_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  ; Subtract -0x80, which can be done with an 8-bit immediate but only as
  ; a subtract where that immediate can be negative.
  %sub = sub i32 %load1, -128
  store i32 %sub, i32* @g32
  %cond = icmp slt i32 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub16_imm_br() nounwind {
; CHECK-LABEL: sub16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $-32768, {{.*}}(%rip) # encoding: [0x66,0x81,0x05,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    js .LBB24_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB24_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB24_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  ; Subtract -0x8000, which requires a 16 bits of immediate but still gets
  ; lowered as an add.
  %sub = sub i16 %load1, -32768
  store i16 %sub, i16* @g16
  %cond = icmp slt i16 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub16_imm8_br() nounwind {
; CHECK-LABEL: sub16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subw $-128, {{.*}}(%rip) # encoding: [0x66,0x83,0x2d,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB25_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB25_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB25_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  ; Subtract -0x80, which can be done with an 8-bit immediate but only as
  ; a subtract where that immediate can be negative.
  %sub = sub i16 %load1, -128
  store i16 %sub, i16* @g16
  %cond = icmp slt i16 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub8_imm_br() nounwind {
; CHECK-LABEL: sub8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $-128, {{.*}}(%rip) # encoding: [0x80,0x05,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB26_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB26_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB26_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  ; Subtract -0x80, which requires an 8-bit immediate but still gets lowered as
  ; an add.
  %sub = sub i8 %load1, -128
  store i8 %sub, i8* @g8
  %cond = icmp slt i8 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: sub64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq %rdi, {{.*}}(%rip) # encoding: [0x48,0x29,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB27_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB27_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB27_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %sub = sub i64 %load1, %arg
  store i64 %sub, i64* @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: sub32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl %edi, {{.*}}(%rip) # encoding: [0x29,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB28_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB28_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB28_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %sub = sub i32 %load1, %arg
  store i32 %sub, i32* @g32
  %cond = icmp slt i32 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: sub16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subw %di, {{.*}}(%rip) # encoding: [0x66,0x29,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB29_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB29_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB29_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %sub = sub i16 %load1, %arg
  store i16 %sub, i16* @g16
  %cond = icmp slt i16 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: sub8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subb %dil, {{.*}}(%rip) # encoding: [0x40,0x28,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB30_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB30_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB30_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %sub = sub i8 %load1, %arg
  store i8 %sub, i8* @g8
  %cond = icmp slt i8 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_imm32_br() nounwind {
; CHECK-LABEL: and64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $16777215, {{.*}}(%rip) # encoding: [0x48,0x81,0x25,A,A,A,A,0xff,0xff,0xff,0x00]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0xFFFFFF
; CHECK-NEXT:    je .LBB31_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB31_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB31_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; And 0x00FFFFFF, a positive immediate requiring 24-bits.
  %and = and i64 %load1, 16777215
  store i64 %and, i64* @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_sext_imm32_br() nounwind {
; CHECK-LABEL: and64_sext_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $-2147483648, {{.*}}(%rip) # encoding: [0x48,0x81,0x25,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    je .LBB32_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB32_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB32_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; And -0x80000000, which requires sign-extended 32 bits.
  %and = and i64 %load1, -2147483648
  store i64 %and, i64* @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_imm8_br() nounwind {
; CHECK-LABEL: and64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $15, {{.*}}(%rip) # encoding: [0x48,0x83,0x25,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB33_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB33_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB33_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %and = and i64 %load1, 15
  store i64 %and, i64* @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_imm8_neg_br() nounwind {
; CHECK-LABEL: and64_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $-4, {{.*}}(%rip) # encoding: [0x48,0x83,0x25,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB34_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB34_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB34_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %and = and i64 %load1, -4
  store i64 %and, i64* @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and32_imm_br() nounwind {
; CHECK-LABEL: and32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $-2147483648, {{.*}}(%rip) # encoding: [0x81,0x25,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jne .LBB35_2 # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB35_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB35_2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  ; And 0x80000000, a positive number requiring 32 bits of immediate.
  %and = and i32 %load1, 2147483648
  store i32 %and, i32* @g32
  %cond = icmp eq i32 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and32_imm8_br() nounwind {
; CHECK-LABEL: and32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $15, {{.*}}(%rip) # encoding: [0x83,0x25,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB36_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB36_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB36_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %and = and i32 %load1, 15
  store i32 %and, i32* @g32
  %cond = icmp eq i32 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and32_imm8_neg_br() nounwind {
; CHECK-LABEL: and32_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $-4, {{.*}}(%rip) # encoding: [0x83,0x25,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB37_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB37_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB37_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %and = and i32 %load1, -4
  store i32 %and, i32* @g32
  %cond = icmp eq i32 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and16_imm_br() nounwind {
; CHECK-LABEL: and16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $-32768, {{.*}}(%rip) # encoding: [0x66,0x81,0x25,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    jne .LBB38_2 # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB38_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB38_2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %and = and i16 %load1, 32768
  store i16 %and, i16* @g16
  %cond = icmp eq i16 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and16_imm8_br() nounwind {
; CHECK-LABEL: and16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $15, {{.*}}(%rip) # encoding: [0x66,0x83,0x25,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB39_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB39_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB39_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %and = and i16 %load1, 15
  store i16 %and, i16* @g16
  %cond = icmp eq i16 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and16_imm8_neg_br() nounwind {
; CHECK-LABEL: and16_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $-4, {{.*}}(%rip) # encoding: [0x66,0x83,0x25,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB40_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB40_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB40_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %and = and i16 %load1, -4
  store i16 %and, i16* @g16
  %cond = icmp eq i16 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and8_imm_br() nounwind {
; CHECK-LABEL: and8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb $-4, {{.*}}(%rip) # encoding: [0x80,0x25,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB41_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB41_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB41_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %and = and i8 %load1, -4
  store i8 %and, i8* @g8
  %cond = icmp eq i8 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: and64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq %rdi, {{.*}}(%rip) # encoding: [0x48,0x21,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB42_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB42_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB42_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %and = and i64 %load1, %arg
  store i64 %and, i64* @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: and32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl %edi, {{.*}}(%rip) # encoding: [0x21,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB43_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB43_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB43_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %and = and i32 %load1, %arg
  store i32 %and, i32* @g32
  %cond = icmp eq i32 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: and16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw %di, {{.*}}(%rip) # encoding: [0x66,0x21,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB44_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB44_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB44_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %and = and i16 %load1, %arg
  store i16 %and, i16* @g16
  %cond = icmp eq i16 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: and8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb %dil, {{.*}}(%rip) # encoding: [0x40,0x20,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB45_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB45_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB45_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %and = and i8 %load1, %arg
  store i8 %and, i8* @g8
  %cond = icmp eq i8 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_imm32_br() nounwind {
; CHECK-LABEL: or64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq $16777215, {{.*}}(%rip) # encoding: [0x48,0x81,0x0d,A,A,A,A,0xff,0xff,0xff,0x00]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0xFFFFFF
; CHECK-NEXT:    je .LBB46_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB46_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB46_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Or 0x00FFFFFF, a positive immediate requiring 24-bits.
  %or = or i64 %load1, 16777215
  store i64 %or, i64* @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_sext_imm32_br() nounwind {
; CHECK-LABEL: or64_sext_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq $-2147483648, {{.*}}(%rip) # encoding: [0x48,0x81,0x0d,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    je .LBB47_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB47_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB47_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Or -0x80000000, which requires sign-extended 32 bits.
  %or = or i64 %load1, -2147483648
  store i64 %or, i64* @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_imm8_br() nounwind {
; CHECK-LABEL: or64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq $15, {{.*}}(%rip) # encoding: [0x48,0x83,0x0d,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB48_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB48_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB48_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %or = or i64 %load1, 15
  store i64 %or, i64* @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_imm8_neg_br() nounwind {
; CHECK-LABEL: or64_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq $-4, {{.*}}(%rip) # encoding: [0x48,0x83,0x0d,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB49_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB49_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB49_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %or = or i64 %load1, -4
  store i64 %or, i64* @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or32_imm_br() nounwind {
; CHECK-LABEL: or32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orl $-2147483648, {{.*}}(%rip) # encoding: [0x81,0x0d,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    je .LBB50_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB50_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB50_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  ; Or 0x80000000, a positive number requiring 32 bits of immediate.
  %or = or i32 %load1, 2147483648
  store i32 %or, i32* @g32
  %cond = icmp eq i32 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or32_imm8_br() nounwind {
; CHECK-LABEL: or32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orl $15, {{.*}}(%rip) # encoding: [0x83,0x0d,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB51_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB51_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB51_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %or = or i32 %load1, 15
  store i32 %or, i32* @g32
  %cond = icmp eq i32 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or32_imm8_neg_br() nounwind {
; CHECK-LABEL: or32_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orl $-4, {{.*}}(%rip) # encoding: [0x83,0x0d,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB52_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB52_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB52_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %or = or i32 %load1, -4
  store i32 %or, i32* @g32
  %cond = icmp eq i32 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or16_imm_br() nounwind {
; CHECK-LABEL: or16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orw $-32768, {{.*}}(%rip) # encoding: [0x66,0x81,0x0d,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    je .LBB53_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB53_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB53_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %or = or i16 %load1, 32768
  store i16 %or, i16* @g16
  %cond = icmp eq i16 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or16_imm8_br() nounwind {
; CHECK-LABEL: or16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orw $15, {{.*}}(%rip) # encoding: [0x66,0x83,0x0d,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB54_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB54_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB54_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %or = or i16 %load1, 15
  store i16 %or, i16* @g16
  %cond = icmp eq i16 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or16_imm8_neg_br() nounwind {
; CHECK-LABEL: or16_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orw $-4, {{.*}}(%rip) # encoding: [0x66,0x83,0x0d,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB55_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB55_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB55_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %or = or i16 %load1, -4
  store i16 %or, i16* @g16
  %cond = icmp eq i16 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or8_imm_br() nounwind {
; CHECK-LABEL: or8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orb $-4, {{.*}}(%rip) # encoding: [0x80,0x0d,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB56_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB56_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB56_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %or = or i8 %load1, -4
  store i8 %or, i8* @g8
  %cond = icmp eq i8 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: or64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq %rdi, {{.*}}(%rip) # encoding: [0x48,0x09,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB57_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB57_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB57_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %or = or i64 %load1, %arg
  store i64 %or, i64* @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: or32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orl %edi, {{.*}}(%rip) # encoding: [0x09,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB58_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB58_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB58_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %or = or i32 %load1, %arg
  store i32 %or, i32* @g32
  %cond = icmp eq i32 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: or16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orw %di, {{.*}}(%rip) # encoding: [0x66,0x09,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB59_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB59_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB59_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %or = or i16 %load1, %arg
  store i16 %or, i16* @g16
  %cond = icmp eq i16 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: or8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orb %dil, {{.*}}(%rip) # encoding: [0x40,0x08,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB60_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB60_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB60_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %or = or i8 %load1, %arg
  store i8 %or, i8* @g8
  %cond = icmp eq i8 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_imm32_br() nounwind {
; CHECK-LABEL: xor64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $16777215, {{.*}}(%rip) # encoding: [0x48,0x81,0x35,A,A,A,A,0xff,0xff,0xff,0x00]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0xFFFFFF
; CHECK-NEXT:    je .LBB61_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB61_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB61_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Xor 0x00FFFFFF, a positive immediate requiring 24-bits.
  %xor = xor i64 %load1, 16777215
  store i64 %xor, i64* @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_sext_imm32_br() nounwind {
; CHECK-LABEL: xor64_sext_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $-2147483648, {{.*}}(%rip) # encoding: [0x48,0x81,0x35,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    je .LBB62_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB62_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB62_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  ; Xor -0x80000000, which requires sign-extended 32 bits.
  %xor = xor i64 %load1, -2147483648
  store i64 %xor, i64* @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_imm8_br() nounwind {
; CHECK-LABEL: xor64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $15, {{.*}}(%rip) # encoding: [0x48,0x83,0x35,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB63_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB63_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB63_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %xor = xor i64 %load1, 15
  store i64 %xor, i64* @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_imm8_neg_br() nounwind {
; CHECK-LABEL: xor64_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $-4, {{.*}}(%rip) # encoding: [0x48,0x83,0x35,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB64_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB64_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB64_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %xor = xor i64 %load1, -4
  store i64 %xor, i64* @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor32_imm_br() nounwind {
; CHECK-LABEL: xor32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $-2147483648, {{.*}}(%rip) # encoding: [0x81,0x35,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    je .LBB65_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB65_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB65_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  ; Xor 0x80000000, a positive number requiring 32 bits of immediate.
  %xor = xor i32 %load1, 2147483648
  store i32 %xor, i32* @g32
  %cond = icmp eq i32 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor32_imm8_br() nounwind {
; CHECK-LABEL: xor32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $15, {{.*}}(%rip) # encoding: [0x83,0x35,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB66_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB66_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB66_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %xor = xor i32 %load1, 15
  store i32 %xor, i32* @g32
  %cond = icmp eq i32 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor32_imm8_neg_br() nounwind {
; CHECK-LABEL: xor32_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $-4, {{.*}}(%rip) # encoding: [0x83,0x35,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB67_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB67_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB67_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %xor = xor i32 %load1, -4
  store i32 %xor, i32* @g32
  %cond = icmp eq i32 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor16_imm_br() nounwind {
; CHECK-LABEL: xor16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $-32768, {{.*}}(%rip) # encoding: [0x66,0x81,0x35,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    je .LBB68_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB68_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB68_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %xor = xor i16 %load1, 32768
  store i16 %xor, i16* @g16
  %cond = icmp eq i16 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor16_imm8_br() nounwind {
; CHECK-LABEL: xor16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $15, {{.*}}(%rip) # encoding: [0x66,0x83,0x35,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB69_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB69_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB69_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %xor = xor i16 %load1, 15
  store i16 %xor, i16* @g16
  %cond = icmp eq i16 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor16_imm8_neg_br() nounwind {
; CHECK-LABEL: xor16_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $-4, {{.*}}(%rip) # encoding: [0x66,0x83,0x35,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB70_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB70_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB70_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %xor = xor i16 %load1, -4
  store i16 %xor, i16* @g16
  %cond = icmp eq i16 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor8_imm_br() nounwind {
; CHECK-LABEL: xor8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorb $-4, {{.*}}(%rip) # encoding: [0x80,0x35,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB71_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB71_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB71_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %xor = xor i8 %load1, -4
  store i8 %xor, i8* @g8
  %cond = icmp eq i8 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: xor64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq %rdi, {{.*}}(%rip) # encoding: [0x48,0x31,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB72_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB72_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB72_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %xor = xor i64 %load1, %arg
  store i64 %xor, i64* @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: xor32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %edi, {{.*}}(%rip) # encoding: [0x31,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB73_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB73_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB73_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %xor = xor i32 %load1, %arg
  store i32 %xor, i32* @g32
  %cond = icmp eq i32 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: xor16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw %di, {{.*}}(%rip) # encoding: [0x66,0x31,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB74_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB74_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB74_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %xor = xor i16 %load1, %arg
  store i16 %xor, i16* @g16
  %cond = icmp eq i16 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: xor8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorb %dil, {{.*}}(%rip) # encoding: [0x40,0x30,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    je .LBB75_1 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB75_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB75_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %xor = xor i8 %load1, %arg
  store i8 %xor, i8* @g8
  %cond = icmp eq i8 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @neg64_br() nounwind {
; CHECK-LABEL: neg64_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    negq {{.*}}(%rip) # encoding: [0x48,0xf7,0x1d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB76_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB76_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB76_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, i64* @g64
  %sub = sub i64 0, %load1
  store i64 %sub, i64* @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @neg32_br() nounwind {
; CHECK-LABEL: neg32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    negl {{.*}}(%rip) # encoding: [0xf7,0x1d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB77_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB77_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB77_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, i32* @g32
  %sub = sub i32 0, %load1
  store i32 %sub, i32* @g32
  %cond = icmp slt i32 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @neg16_br() nounwind {
; CHECK-LABEL: neg16_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    negw {{.*}}(%rip) # encoding: [0x66,0xf7,0x1d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB78_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB78_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB78_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, i16* @g16
  %sub = sub i16 0, %load1
  store i16 %sub, i16* @g16
  %cond = icmp slt i16 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @neg8_br() nounwind {
; CHECK-LABEL: neg8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    negb {{.*}}(%rip) # encoding: [0xf6,0x1d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    js .LBB79_1 # encoding: [0x78,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB79_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %b
; CHECK-NEXT:    jmp b # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB79_1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, i8* @g8
  %sub = sub i8 0, %load1
  store i8 %sub, i8* @g8
  %cond = icmp slt i8 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}
