; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s | FileCheck %s

target datalayout = "e-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64"
target triple = "thumbv6m-arm-none-eabi"

; From https://reviews.llvm.org/D62266
; This used to cause an endless loop in DAGCombine,
; since we were hoisting two binops with constants, one constant being opaque,
; which is why they weren't getting constant folded.

@a = dso_local local_unnamed_addr global i32 0, align 4
@b = dso_local local_unnamed_addr global i32 0, align 4

; Function Attrs: minsize nounwind optsize
define dso_local i32 @c() local_unnamed_addr #0 {
; CHECK-LABEL: c:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    ldr r0, .LCPI0_0
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    ldr r4, .LCPI0_1
; CHECK-NEXT:    subs r0, r4, r0
; CHECK-NEXT:    adds r0, r0, #1
; CHECK-NEXT:    bl d
; CHECK-NEXT:    ldr r0, .LCPI0_2
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    cmp r0, r4
; CHECK-NEXT:    ble .LBB0_2
; CHECK-NEXT:  @ %bb.1: @ %if.then
; CHECK-NEXT:    bl e
; CHECK-NEXT:  .LBB0_2: @ %if.end
; CHECK-NEXT:    pop {r4, pc}
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.3:
; CHECK-NEXT:  .LCPI0_0:
; CHECK-NEXT:    .long a
; CHECK-NEXT:  .LCPI0_1:
; CHECK-NEXT:    .long 1999 @ 0x7cf
; CHECK-NEXT:  .LCPI0_2:
; CHECK-NEXT:    .long b
entry:
  %0 = load i32, i32* @a, align 4
  %sub = sub nsw i32 2000, %0
  %call = tail call i32 bitcast (i32 (...)* @d to i32 (i32)*)(i32 %sub) #2
  %1 = load i32, i32* @b, align 4
  %cmp = icmp sgt i32 %1, 1999
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %call1 = tail call i32 bitcast (i32 (...)* @e to i32 ()*)() #2
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  ret i32 undef
}

declare dso_local i32 @d(...) local_unnamed_addr #1
declare dso_local i32 @e(...) local_unnamed_addr #1
