; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-unknown-linux-gnu < %s 2>&1 | FileCheck %s
; RUN: llc -mtriple=aarch64-unknown-linux-gnu -global-isel -global-isel-abort=1 < %s 2>&1 | FileCheck %s --check-prefix=GISEL

%struct.T = type { i32, i32 }

define i32 @freeze_int() {
; CHECK-LABEL: freeze_int:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul w0, w8, w8
; CHECK-NEXT:    ret
;
; GISEL-LABEL: freeze_int:
; GISEL:       // %bb.0:
; GISEL-NEXT:    mul w0, w8, w8
; GISEL-NEXT:    ret
  %y1 = freeze i32 undef
  %t1 = mul i32 %y1, %y1
  ret i32 %t1
}

define i5 @freeze_int2() {
; CHECK-LABEL: freeze_int2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul w0, w8, w8
; CHECK-NEXT:    ret
;
; GISEL-LABEL: freeze_int2:
; GISEL:       // %bb.0:
; GISEL-NEXT:    mul w0, w8, w8
; GISEL-NEXT:    ret
  %y1 = freeze i5 undef
  %t1 = mul i5 %y1, %y1
  ret i5 %t1
}

define float @freeze_float() {
; CHECK-LABEL: freeze_float:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd s0, s0, s0
; CHECK-NEXT:    ret
;
; GISEL-LABEL: freeze_float:
; GISEL:       // %bb.0:
; GISEL-NEXT:    fadd s0, s0, s0
; GISEL-NEXT:    ret
  %y1 = freeze float undef
  %t1 = fadd float %y1, %y1
  ret float %t1
}

define <2 x i32> @freeze_ivec() {
; CHECK-LABEL: freeze_ivec:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.2s, v0.2s, v0.2s
; CHECK-NEXT:    ret
;
; GISEL-LABEL: freeze_ivec:
; GISEL:       // %bb.0:
; GISEL-NEXT:    add v0.2s, v0.2s, v0.2s
; GISEL-NEXT:    ret
  %y1 = freeze <2 x i32> undef
  %t1 = add <2 x i32> %y1, %y1
  ret <2 x i32> %t1
}

define i8* @freeze_ptr() {
; CHECK-LABEL: freeze_ptr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x0, x8, #4 // =4
; CHECK-NEXT:    ret
;
; GISEL-LABEL: freeze_ptr:
; GISEL:       // %bb.0:
; GISEL-NEXT:    add x0, x8, #4 // =4
; GISEL-NEXT:    ret
  %y1 = freeze i8* undef
  %t1 = getelementptr i8, i8* %y1, i64 4
  ret i8* %t1
}

define i32 @freeze_struct() {
; CHECK-LABEL: freeze_struct:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w0, w8, w8
; CHECK-NEXT:    ret
;
; GISEL-LABEL: freeze_struct:
; GISEL:       // %bb.0:
; GISEL-NEXT:    add w0, w8, w8
; GISEL-NEXT:    ret
  %y1 = freeze %struct.T undef
  %v1 = extractvalue %struct.T %y1, 0
  %v2 = extractvalue %struct.T %y1, 1
  %t1 = add i32 %v1, %v2
  ret i32 %t1
}

define i32 @freeze_anonstruct() {
; CHECK-LABEL: freeze_anonstruct:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w0, w8, w8
; CHECK-NEXT:    ret
;
; GISEL-LABEL: freeze_anonstruct:
; GISEL:       // %bb.0:
; GISEL-NEXT:    add w0, w8, w8
; GISEL-NEXT:    ret
  %y1 = freeze {i32, i32} undef
  %v1 = extractvalue {i32, i32} %y1, 0
  %v2 = extractvalue {i32, i32} %y1, 1
  %t1 = add i32 %v1, %v2
  ret i32 %t1
}

define i32 @freeze_anonstruct2() {
; CHECK-LABEL: freeze_anonstruct2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w0, w8, w8, uxth
; CHECK-NEXT:    ret
;
; GISEL-LABEL: freeze_anonstruct2:
; GISEL:       // %bb.0:
; GISEL-NEXT:    add w0, w8, w8, uxth
; GISEL-NEXT:    ret
  %y1 = freeze {i32, i16} undef
  %v1 = extractvalue {i32, i16} %y1, 0
  %v2 = extractvalue {i32, i16} %y1, 1
  %z2 = zext i16 %v2 to i32
  %t1 = add i32 %v1, %z2
  ret i32 %t1
}

define i64 @freeze_array() {
; CHECK-LABEL: freeze_array:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x0, x8, x8
; CHECK-NEXT:    ret
;
; GISEL-LABEL: freeze_array:
; GISEL:       // %bb.0:
; GISEL-NEXT:    add x0, x8, x8
; GISEL-NEXT:    ret
  %y1 = freeze [2 x i64] undef
  %v1 = extractvalue [2 x i64] %y1, 0
  %v2 = extractvalue [2 x i64] %y1, 1
  %t1 = add i64 %v1, %v2
  ret i64 %t1
}
