// REQUIRES: x86
// RUN: llvm-mc -filetype=obj -triple=x86_64-pc-linux %s -o %t.o
// RUN: ld.lld %t.o -shared -o %t.so
// RUN: llvm-readelf -S %t.so | FileCheck %s -check-prefix=SECTION
// RUN: llvm-objdump -d %t.so | FileCheck %s

// SECTION: .dynamic DYNAMIC 0000000000002290
// SECTION: .got.plt PROGBITS 0000000000003300 000300 000018

// The assembly is generated by
// gcc -O2 -S -mcmodel=medium -fPIC a.c
// This computes the pc-relative address (runtime address) of _DYNAMIC.
//
// extern long _DYNAMIC[] __attribute__((visibility("hidden")));
// long* dynamic() { return _DYNAMIC; }

// 0x3300 (.got.plt) - 0x127b = 8325
// 0x2290 (_DYNAMIC) - 0x3300 (.got.plt) = -4208
// CHECK:      1274: {{.*}} leaq 8325(%rip), %rdx
// CHECK-NEXT: 127b: {{.*}} movabsq $-4208, %rax
.global dynamic
dynamic:
  leaq _GLOBAL_OFFSET_TABLE_(%rip), %rdx
  movabsq $_DYNAMIC@GOTOFF, %rax
  addq %rdx, %rax
  ret
