/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __SOC_MEDIATEK_MT8188_MMSYS_H
#define __SOC_MEDIATEK_MT8188_MMSYS_H

#define MT8188_VDO0_OVL_MOUT_EN				0xf14
#define MT8188_MOUT_DISP_OVL0_TO_DISP_RDMA0		BIT(0)
#define MT8188_MOUT_DISP_OVL0_TO_DISP_WDMA0		BIT(1)
#define MT8188_MOUT_DISP_OVL0_TO_DISP_OVL1		BIT(2)
#define MT8188_MOUT_DISP_OVL1_TO_DISP_RDMA1		BIT(4)
#define MT8188_MOUT_DISP_OVL1_TO_DISP_WDMA1		BIT(5)
#define MT8188_MOUT_DISP_OVL1_TO_DISP_OVL0		BIT(6)

#define MT8188_VDO0_SEL_IN				0xf34
#define MT8188_VDO0_SEL_OUT				0xf38

#define MT8188_VDO0_DISP_RDMA_SEL			0xf40
#define MT8188_SOUT_DISP_RDMA0_TO_MASK			GENMASK(2, 0)
#define MT8188_SOUT_DISP_RDMA0_TO_DISP_COLOR0		(0 << 0)
#define MT8188_SOUT_DISP_RDMA0_TO_DISP_DSI0		(1 << 0)
#define MT8188_SOUT_DISP_RDMA0_TO_DISP_DP_INTF0		(5 << 0)
#define MT8188_SEL_IN_DISP_RDMA0_FROM_MASK		GENMASK(8, 8)
#define MT8188_SEL_IN_DISP_RDMA0_FROM_DISP_OVL0		(0 << 8)
#define MT8188_SEL_IN_DISP_RDMA0_FROM_DISP_RSZ0		(1 << 8)


#define MT8188_VDO0_DSI0_SEL_IN				0xf44
#define MT8188_SEL_IN_DSI0_FROM_MASK			BIT(0)
#define MT8188_SEL_IN_DSI0_FROM_DSC_WRAP0_OUT		(0 << 0)
#define MT8188_SEL_IN_DSI0_FROM_DISP_DITHER0		(1 << 0)

#define MT8188_VDO0_DP_INTF0_SEL_IN			0xf4C
#define MT8188_SEL_IN_DP_INTF0_FROM_MASK		GENMASK(2, 0)
#define MT8188_SEL_IN_DP_INTF0_FROM_DSC_WRAP0C1_OUT	(0 << 0)
#define MT8188_SEL_IN_DP_INTF0_FROM_VPP_MERGE		(1 << 0)
#define MT8188_SEL_IN_DP_INTF0_FROM_DISP_DITHER0	(3 << 0)

#define MT8188_VDO0_DISP_DITHER0_SEL_OUT		0xf58
#define MT8188_SOUT_DISP_DITHER0_TO_MASK		GENMASK(2, 0)
#define MT8188_SOUT_DISP_DITHER0_TO_DSC_WRAP0_IN	(0 << 0)
#define MT8188_SOUT_DISP_DITHER0_TO_DSI0		(1 << 0)
#define MT8188_SOUT_DISP_DITHER0_TO_VPP_MERGE0		(6 << 0)
#define MT8188_SOUT_DISP_DITHER0_TO_DP_INTF0		(7 << 0)

#define MT8188_VDO0_VPP_MERGE_SEL			0xf60
#define MT8188_SEL_IN_VPP_MERGE_FROM_MASK		GENMASK(1, 0)
#define MT8188_SEL_IN_VPP_MERGE_FROM_DSC_WRAP0_OUT	(0 << 0)
#define MT8188_SEL_IN_VPP_MERGE_FROM_DITHER0_OUT	(3 << 0)

#define MT8188_SOUT_VPP_MERGE_TO_MASK			GENMASK(6, 4)
#define MT8188_SOUT_VPP_MERGE_TO_DSI1			(0 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DP_INTF0		(1 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_SINA_VIRTUAL0		(2 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DISP_WDMA1		(3 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DSC_WRAP0_IN		(4 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DISP_WDMA0		(5 << 4)
#define MT8188_SOUT_VPP_MERGE_TO_DSC_WRAP1_IN_MASK	GENMASK(11, 11)
#define MT8188_SOUT_VPP_MERGE_TO_DSC_WRAP1_IN		(0 << 11)

#define MT8188_VDO0_DSC_WARP_SEL			0xf64
#define MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_MASK		GENMASK(0, 0)
#define MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_DISP_DITHER0	(0 << 0)
#define MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_VPP_MERGE	(1 << 0)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_MASK		GENMASK(19, 16)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_DSI0		BIT(16)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_SINB_VIRTUAL0	BIT(17)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_VPP_MERGE		BIT(18)
#define MT8188_SOUT_DSC_WRAP0_OUT_TO_DISP_WDMA0		BIT(19)

static const struct mtk_mmsys_routes mmsys_mt8188_routing_table[] = {
	{
		DDP_COMPONENT_OVL0, DDP_COMPONENT_RDMA0,
		MT8188_VDO0_OVL_MOUT_EN, MT8188_MOUT_DISP_OVL0_TO_DISP_RDMA0,
		MT8188_MOUT_DISP_OVL0_TO_DISP_RDMA0
	}, {
		DDP_COMPONENT_OVL0, DDP_COMPONENT_WDMA0,
		MT8188_VDO0_OVL_MOUT_EN, MT8188_MOUT_DISP_OVL0_TO_DISP_WDMA0,
		MT8188_MOUT_DISP_OVL0_TO_DISP_WDMA0
	}, {
		DDP_COMPONENT_OVL0, DDP_COMPONENT_RDMA0,
		MT8188_VDO0_DISP_RDMA_SEL, MT8188_SEL_IN_DISP_RDMA0_FROM_MASK,
		MT8188_SEL_IN_DISP_RDMA0_FROM_DISP_OVL0
	}, {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DSI0,
		MT8188_VDO0_DSI0_SEL_IN, MT8188_SEL_IN_DSI0_FROM_MASK,
		MT8188_SEL_IN_DSI0_FROM_DISP_DITHER0
	}, {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_MERGE0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SEL_IN_VPP_MERGE_FROM_MASK,
		MT8188_SEL_IN_VPP_MERGE_FROM_DITHER0_OUT
	}, {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DSC0,
		MT8188_VDO0_DSC_WARP_SEL,
		MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_MASK,
		MT8188_SEL_IN_DSC_WRAP0C0_IN_FROM_DISP_DITHER0
	}, {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DP_INTF0,
		MT8188_VDO0_DP_INTF0_SEL_IN, MT8188_SEL_IN_DP_INTF0_FROM_MASK,
		MT8188_SEL_IN_DP_INTF0_FROM_DISP_DITHER0
	}, {
		DDP_COMPONENT_DSC0, DDP_COMPONENT_MERGE0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SEL_IN_VPP_MERGE_FROM_MASK,
		MT8188_SEL_IN_VPP_MERGE_FROM_DSC_WRAP0_OUT
	}, {
		DDP_COMPONENT_DSC0, DDP_COMPONENT_DSI0,
		MT8188_VDO0_DSI0_SEL_IN, MT8188_SEL_IN_DSI0_FROM_MASK,
		MT8188_SEL_IN_DSI0_FROM_DSC_WRAP0_OUT
	}, {
		DDP_COMPONENT_RDMA0, DDP_COMPONENT_COLOR0,
		MT8188_VDO0_DISP_RDMA_SEL, MT8188_SOUT_DISP_RDMA0_TO_MASK,
		MT8188_SOUT_DISP_RDMA0_TO_DISP_COLOR0
	},  {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DSI0,
		MT8188_VDO0_DISP_DITHER0_SEL_OUT,
		MT8188_SOUT_DISP_DITHER0_TO_MASK,
		MT8188_SOUT_DISP_DITHER0_TO_DSI0
	},  {
		DDP_COMPONENT_DITHER0, DDP_COMPONENT_DP_INTF0,
		MT8188_VDO0_DISP_DITHER0_SEL_OUT,
		MT8188_SOUT_DISP_DITHER0_TO_MASK,
		MT8188_SOUT_DISP_DITHER0_TO_DP_INTF0
	}, {
		DDP_COMPONENT_MERGE0, DDP_COMPONENT_DP_INTF0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SOUT_VPP_MERGE_TO_MASK,
		MT8188_SOUT_VPP_MERGE_TO_DP_INTF0
	}, {
		DDP_COMPONENT_MERGE0, DDP_COMPONENT_DPI0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SOUT_VPP_MERGE_TO_MASK,
		MT8188_SOUT_VPP_MERGE_TO_SINA_VIRTUAL0
	}, {
		DDP_COMPONENT_MERGE0, DDP_COMPONENT_WDMA0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SOUT_VPP_MERGE_TO_MASK,
		MT8188_SOUT_VPP_MERGE_TO_DISP_WDMA0
	}, {
		DDP_COMPONENT_MERGE0, DDP_COMPONENT_DSC0,
		MT8188_VDO0_VPP_MERGE_SEL, MT8188_SOUT_VPP_MERGE_TO_MASK,
		MT8188_SOUT_VPP_MERGE_TO_DSC_WRAP0_IN
	}, {
		DDP_COMPONENT_DSC0, DDP_COMPONENT_DSI0,
		MT8188_VDO0_DSC_WARP_SEL, MT8188_SOUT_DSC_WRAP0_OUT_TO_MASK,
		MT8188_SOUT_DSC_WRAP0_OUT_TO_DSI0
	}, {
		DDP_COMPONENT_DSC0, DDP_COMPONENT_MERGE0,
		MT8188_VDO0_DSC_WARP_SEL, MT8188_SOUT_DSC_WRAP0_OUT_TO_MASK,
		MT8188_SOUT_DSC_WRAP0_OUT_TO_VPP_MERGE
	},
};

#endif /* __SOC_MEDIATEK_MT8188_MMSYS_H */
