// SPDX-License-Identifier: GPL-2.0-or-later
/*
 * Copyright (C) 2023-2024, Advanced Micro Devices, Inc.
 */

#ifndef __QDMA_REGS_DEF_H
#define __QDMA_REGS_DEF_H

#include "qdma.h"

const struct qdma_reg qdma_regos_default[QDMA_REGO_MAX] = {
	[QDMA_REGO_CTXT_DATA] = QDMA_REGO(0x804, 8),
	[QDMA_REGO_CTXT_CMD] = QDMA_REGO(0x844, 1),
	[QDMA_REGO_CTXT_MASK] = QDMA_REGO(0x824, 8),
	[QDMA_REGO_MM_H2C_CTRL] = QDMA_REGO(0x1004, 1),
	[QDMA_REGO_MM_C2H_CTRL] = QDMA_REGO(0x1204, 1),
	[QDMA_REGO_QUEUE_COUNT] = QDMA_REGO(0x120, 1),
	[QDMA_REGO_RING_SIZE] = QDMA_REGO(0x204, 1),
	[QDMA_REGO_H2C_PIDX] = QDMA_REGO(0x18004, 1),
	[QDMA_REGO_C2H_PIDX] = QDMA_REGO(0x18008, 1),
	[QDMA_REGO_INTR_CIDX] = QDMA_REGO(0x18000, 1),
	[QDMA_REGO_FUNC_ID] = QDMA_REGO(0x12c, 1),
	[QDMA_REGO_ERR_INT] = QDMA_REGO(0xb04, 1),
	[QDMA_REGO_ERR_STAT] = QDMA_REGO(0x248, 1),
};

const struct qdma_reg_field qdma_regfs_default[QDMA_REGF_MAX] = {
	/* QDMA_REGO_CTXT_DATA fields */
	[QDMA_REGF_IRQ_ENABLE] = QDMA_REGF(53, 53),
	[QDMA_REGF_WBK_ENABLE] = QDMA_REGF(52, 52),
	[QDMA_REGF_WBI_CHECK] = QDMA_REGF(34, 34),
	[QDMA_REGF_IRQ_ARM] = QDMA_REGF(16, 16),
	[QDMA_REGF_IRQ_VEC] = QDMA_REGF(138, 128),
	[QDMA_REGF_IRQ_AGG] = QDMA_REGF(139, 139),
	[QDMA_REGF_WBI_INTVL_ENABLE] = QDMA_REGF(35, 35),
	[QDMA_REGF_MRKR_DISABLE] = QDMA_REGF(62, 62),
	[QDMA_REGF_QUEUE_ENABLE] = QDMA_REGF(32, 32),
	[QDMA_REGF_QUEUE_MODE] = QDMA_REGF(63, 63),
	[QDMA_REGF_DESC_BASE] = QDMA_REGF(127, 64),
	[QDMA_REGF_DESC_SIZE] = QDMA_REGF(49, 48),
	[QDMA_REGF_RING_ID] = QDMA_REGF(47, 44),
	[QDMA_REGF_QUEUE_BASE] = QDMA_REGF(11, 0),
	[QDMA_REGF_QUEUE_MAX] = QDMA_REGF(44, 32),
	[QDMA_REGF_FUNCTION_ID] = QDMA_REGF(24, 17),
	[QDMA_REGF_INTR_AGG_BASE] = QDMA_REGF(66, 15),
	[QDMA_REGF_INTR_VECTOR] = QDMA_REGF(11, 1),
	[QDMA_REGF_INTR_SIZE] = QDMA_REGF(69, 67),
	[QDMA_REGF_INTR_VALID] = QDMA_REGF(0, 0),
	[QDMA_REGF_INTR_COLOR] = QDMA_REGF(14, 14),
	[QDMA_REGF_INTR_FUNCTION_ID] = QDMA_REGF(125, 114),
	/* QDMA_REGO_CTXT_CMD fields */
	[QDMA_REGF_CMD_INDX] = QDMA_REGF(19, 7),
	[QDMA_REGF_CMD_CMD] = QDMA_REGF(6, 5),
	[QDMA_REGF_CMD_TYPE] = QDMA_REGF(4, 1),
	[QDMA_REGF_CMD_BUSY] = QDMA_REGF(0, 0),
	/* QDMA_REGO_QUEUE_COUNT fields */
	[QDMA_REGF_QUEUE_COUNT] = QDMA_REGF(11, 0),
	/* QDMA_REGO_ERR_INT fields */
	[QDMA_REGF_ERR_INT_FUNC] = QDMA_REGF(11, 0),
	[QDMA_REGF_ERR_INT_VEC] = QDMA_REGF(22, 12),
	[QDMA_REGF_ERR_INT_ARM] = QDMA_REGF(24, 24),
};

#endif	/* __QDMA_REGS_DEF_H */
