/** BEGIN COPYRIGHT BLOCK
 * Copyright (C) 2001 Sun Microsystems, Inc.  Used by permission.
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation version
 * 2.1 of the License.
 *                                                                                 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *                                                                                 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * END COPYRIGHT BLOCK **/
import java.io.IOException;
import java.net.URL;
import java.io.InputStreamReader;
import java.io.InputStream;

import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.comm.HttpChannel;

public class GetExample implements CommClient, Runnable
{
   public boolean finished = false;

   public static String url = "http://home.netscape.com/";

   public static void main(String args[]) throws IOException
   {
      Thread t = new Thread(new GetExample());

      t.start();
   }

   public GetExample() { }

   public void run()
   {
      HttpManager h = new HttpManager();
      
      h.trace();

      try
      {
	 h.get(new URL(url), this, null);
	 await();
	 System.exit(0);
      }
      catch (Exception e)
      {
         System.err.println(e);
      }
   }

   public synchronized void await()
   {
      while (!finished)
      {
	 try { wait(); }
	 catch (Exception e) { }
      }
   }

   public synchronized void finish()
   {
      finished = true;
      notifyAll();
   }

   public void replyHandler(InputStream response, CommRecord cr)
   {
      System.out.println("responseHandler:\n" + cr + '\n');

      int c;

      InputStreamReader isr = new InputStreamReader(response);

      try
      {
         while ((c = isr.read()) != -1)
	    System.out.write((char)c);
      }
      catch (Exception e) { }

      finish();
   }

   public void errorHandler(Exception exception, CommRecord cr)
   {
      System.err.println("errorHandler: " + exception);
      finish();
   }

   public String username(Object realm, CommRecord cr)
   {
      return "";
   }
   
   public String password(Object realm, CommRecord cr)
   {
      return "";
   }
}
