/* keymanager.h  -  The Key Manager
 * Copyright (C) 2009 g10 Code GmbH.
 *
 * This file is part of GPA
 *
 * GPA is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPA is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KEYMANAGER_H
#define KEYMANAGER_H

/* Declare the Object. */
typedef struct _GpaKeyManager GpaKeyManager;
typedef struct _GpaKeyManagerClass GpaKeyManagerClass;

GType gpa_key_manager_get_type (void) G_GNUC_CONST;

#define GPA_KEY_MANAGER_TYPE	  (gpa_key_manager_get_type ())

#define GPA_KEY_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPA_KEY_MANAGER_TYPE, GpaKeyManager))

#define GPA_KEY_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass),  \
                            GPA_KEY_MANAGER_TYPE, GpaKeyManagerClass))

#define GPA_IS_KEY_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPA_KEY_MANAGER_TYPE))

#define GPA_IS_KEY_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), GPA_KEY_MANAGER_TYPE))

#define GPA_KEY_MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),    \
                              GPA_KEY_MANAGER_TYPE, GpaKeyManagerClass))


/* The public API.  */

GtkWidget *gpa_key_manager_get_instance (gboolean *r_created);

gboolean gpa_key_manager_is_open (void);

gboolean key_manager_maybe_firsttime (void);


#endif /*KEYMANAGER_H*/
