package labservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AddRemove enumerates the values for add remove.
type AddRemove string

const (
	// Add Indicates that a user is adding a favorite lab
	Add AddRemove = "Add"
	// Remove Indicates that a user is removing a favorite lab
	Remove AddRemove = "Remove"
)

// PossibleAddRemoveValues returns an array of possible values for the AddRemove const type.
func PossibleAddRemoveValues() []AddRemove {
	return []AddRemove{Add, Remove}
}

// ConfigurationState enumerates the values for configuration state.
type ConfigurationState string

const (
	// Completed User is finished modifying the template.
	Completed ConfigurationState = "Completed"
	// NotApplicable User either hasn't started configuring their template
	// or they haven't started the configuration process.
	NotApplicable ConfigurationState = "NotApplicable"
)

// PossibleConfigurationStateValues returns an array of possible values for the ConfigurationState const type.
func PossibleConfigurationStateValues() []ConfigurationState {
	return []ConfigurationState{Completed, NotApplicable}
}

// LabUserAccessMode enumerates the values for lab user access mode.
type LabUserAccessMode string

const (
	// Open Any user can register with the lab and access its VMs.
	Open LabUserAccessMode = "Open"
	// Restricted Only users registered with the lab can access VMs.
	Restricted LabUserAccessMode = "Restricted"
)

// PossibleLabUserAccessModeValues returns an array of possible values for the LabUserAccessMode const type.
func PossibleLabUserAccessModeValues() []LabUserAccessMode {
	return []LabUserAccessMode{Open, Restricted}
}

// ManagedLabVMSize enumerates the values for managed lab vm size.
type ManagedLabVMSize string

const (
	// Basic The base VM size
	Basic ManagedLabVMSize = "Basic"
	// Performance The most performant VM size
	Performance ManagedLabVMSize = "Performance"
	// Standard The standard or default VM size
	Standard ManagedLabVMSize = "Standard"
)

// PossibleManagedLabVMSizeValues returns an array of possible values for the ManagedLabVMSize const type.
func PossibleManagedLabVMSizeValues() []ManagedLabVMSize {
	return []ManagedLabVMSize{Basic, Performance, Standard}
}

// PublishingState enumerates the values for publishing state.
type PublishingState string

const (
	// Draft Initial state of an environment setting.
	Draft PublishingState = "Draft"
	// Published All resources are currently provisioned.
	Published PublishingState = "Published"
	// PublishFailed Failed to provision all the necessary resources.
	PublishFailed PublishingState = "PublishFailed"
	// Publishing Currently provisioning resources.
	Publishing PublishingState = "Publishing"
	// Scaling Currently provisioning resources without recreating VM image.
	Scaling PublishingState = "Scaling"
)

// PossiblePublishingStateValues returns an array of possible values for the PublishingState const type.
func PossiblePublishingStateValues() []PublishingState {
	return []PublishingState{Draft, Published, PublishFailed, Publishing, Scaling}
}
