// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package vmware

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/vmware/mgmt/2019-08-09-preview/vmware"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ClusterProvisioningState = original.ClusterProvisioningState

const (
	Cancelled ClusterProvisioningState = original.Cancelled
	Failed    ClusterProvisioningState = original.Failed
	Succeeded ClusterProvisioningState = original.Succeeded
	Updating  ClusterProvisioningState = original.Updating
)

type InternetEnum = original.InternetEnum

const (
	Disabled InternetEnum = original.Disabled
	Enabled  InternetEnum = original.Enabled
)

type PrivateCloudProvisioningState = original.PrivateCloudProvisioningState

const (
	PrivateCloudProvisioningStateBuilding  PrivateCloudProvisioningState = original.PrivateCloudProvisioningStateBuilding
	PrivateCloudProvisioningStateCancelled PrivateCloudProvisioningState = original.PrivateCloudProvisioningStateCancelled
	PrivateCloudProvisioningStateFailed    PrivateCloudProvisioningState = original.PrivateCloudProvisioningStateFailed
	PrivateCloudProvisioningStatePending   PrivateCloudProvisioningState = original.PrivateCloudProvisioningStatePending
	PrivateCloudProvisioningStateSucceeded PrivateCloudProvisioningState = original.PrivateCloudProvisioningStateSucceeded
	PrivateCloudProvisioningStateUpdating  PrivateCloudProvisioningState = original.PrivateCloudProvisioningStateUpdating
)

type QuotaEnabled = original.QuotaEnabled

const (
	QuotaEnabledDisabled QuotaEnabled = original.QuotaEnabledDisabled
	QuotaEnabledEnabled  QuotaEnabled = original.QuotaEnabledEnabled
)

type SslEnum = original.SslEnum

const (
	SslEnumDisabled SslEnum = original.SslEnumDisabled
	SslEnumEnabled  SslEnum = original.SslEnumEnabled
)

type Status = original.Status

const (
	TrialAvailable Status = original.TrialAvailable
	TrialDisabled  Status = original.TrialDisabled
	TrialUsed      Status = original.TrialUsed
)

type APIError = original.APIError
type APIErrorBase = original.APIErrorBase
type AdminCredentials = original.AdminCredentials
type BaseClient = original.BaseClient
type Circuit = original.Circuit
type Cluster = original.Cluster
type ClusterList = original.ClusterList
type ClusterListIterator = original.ClusterListIterator
type ClusterListPage = original.ClusterListPage
type ClusterProperties = original.ClusterProperties
type ClustersClient = original.ClustersClient
type ClustersCreateOrUpdateFuture = original.ClustersCreateOrUpdateFuture
type ClustersDeleteFuture = original.ClustersDeleteFuture
type ClustersUpdateFuture = original.ClustersUpdateFuture
type DefaultClusterProperties = original.DefaultClusterProperties
type Endpoints = original.Endpoints
type ExpressRouteAuthorization = original.ExpressRouteAuthorization
type IdentitySource = original.IdentitySource
type LocationsClient = original.LocationsClient
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationListIterator = original.OperationListIterator
type OperationListPage = original.OperationListPage
type OperationsClient = original.OperationsClient
type PrivateCloud = original.PrivateCloud
type PrivateCloudList = original.PrivateCloudList
type PrivateCloudListIterator = original.PrivateCloudListIterator
type PrivateCloudListPage = original.PrivateCloudListPage
type PrivateCloudProperties = original.PrivateCloudProperties
type PrivateCloudsClient = original.PrivateCloudsClient
type PrivateCloudsCreateOrUpdateFuture = original.PrivateCloudsCreateOrUpdateFuture
type PrivateCloudsDeleteFuture = original.PrivateCloudsDeleteFuture
type PrivateCloudsUpdateFuture = original.PrivateCloudsUpdateFuture
type Quota = original.Quota
type Resource = original.Resource
type Sku = original.Sku
type TrackedResource = original.TrackedResource
type Trial = original.Trial

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewClusterListIterator(page ClusterListPage) ClusterListIterator {
	return original.NewClusterListIterator(page)
}
func NewClusterListPage(getNextPage func(context.Context, ClusterList) (ClusterList, error)) ClusterListPage {
	return original.NewClusterListPage(getNextPage)
}
func NewClustersClient(subscriptionID string) ClustersClient {
	return original.NewClustersClient(subscriptionID)
}
func NewClustersClientWithBaseURI(baseURI string, subscriptionID string) ClustersClient {
	return original.NewClustersClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocationsClient(subscriptionID string) LocationsClient {
	return original.NewLocationsClient(subscriptionID)
}
func NewLocationsClientWithBaseURI(baseURI string, subscriptionID string) LocationsClient {
	return original.NewLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return original.NewOperationListIterator(page)
}
func NewOperationListPage(getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return original.NewOperationListPage(getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateCloudListIterator(page PrivateCloudListPage) PrivateCloudListIterator {
	return original.NewPrivateCloudListIterator(page)
}
func NewPrivateCloudListPage(getNextPage func(context.Context, PrivateCloudList) (PrivateCloudList, error)) PrivateCloudListPage {
	return original.NewPrivateCloudListPage(getNextPage)
}
func NewPrivateCloudsClient(subscriptionID string) PrivateCloudsClient {
	return original.NewPrivateCloudsClient(subscriptionID)
}
func NewPrivateCloudsClientWithBaseURI(baseURI string, subscriptionID string) PrivateCloudsClient {
	return original.NewPrivateCloudsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return original.PossibleClusterProvisioningStateValues()
}
func PossibleInternetEnumValues() []InternetEnum {
	return original.PossibleInternetEnumValues()
}
func PossiblePrivateCloudProvisioningStateValues() []PrivateCloudProvisioningState {
	return original.PossiblePrivateCloudProvisioningStateValues()
}
func PossibleQuotaEnabledValues() []QuotaEnabled {
	return original.PossibleQuotaEnabledValues()
}
func PossibleSslEnumValues() []SslEnum {
	return original.PossibleSslEnumValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
