// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package aiplatform provides access to the Vertex AI API.
//
// For product documentation, see: https://cloud.google.com/vertex-ai/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/aiplatform/v1"
//	...
//	ctx := context.Background()
//	aiplatformService, err := aiplatform.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	aiplatformService, err := aiplatform.NewService(ctx, option.WithScopes(aiplatform.CloudPlatformReadOnlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	aiplatformService, err := aiplatform.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	aiplatformService, err := aiplatform.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package aiplatform // import "google.golang.org/api/aiplatform/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "aiplatform:v1"
const apiName = "aiplatform"
const apiVersion = "v1"
const basePath = "https://aiplatform.googleapis.com/"
const basePathTemplate = "https://aiplatform.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://aiplatform.mtls.googleapis.com/"
const defaultUniverseDomain = "googleapis.com"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View your data across Google Cloud services and see the email address
	// of your Google Account
	CloudPlatformReadOnlyScope = "https://www.googleapis.com/auth/cloud-platform.read-only"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud-platform.read-only",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.WithDefaultUniverseDomain(defaultUniverseDomain))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	s.Publishers = NewPublishersService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService

	Publishers *PublishersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.BatchPredictionJobs = NewProjectsLocationsBatchPredictionJobsService(s)
	rs.CustomJobs = NewProjectsLocationsCustomJobsService(s)
	rs.DataLabelingJobs = NewProjectsLocationsDataLabelingJobsService(s)
	rs.Datasets = NewProjectsLocationsDatasetsService(s)
	rs.DeploymentResourcePools = NewProjectsLocationsDeploymentResourcePoolsService(s)
	rs.Endpoints = NewProjectsLocationsEndpointsService(s)
	rs.FeatureGroups = NewProjectsLocationsFeatureGroupsService(s)
	rs.FeatureOnlineStores = NewProjectsLocationsFeatureOnlineStoresService(s)
	rs.Featurestores = NewProjectsLocationsFeaturestoresService(s)
	rs.HyperparameterTuningJobs = NewProjectsLocationsHyperparameterTuningJobsService(s)
	rs.IndexEndpoints = NewProjectsLocationsIndexEndpointsService(s)
	rs.Indexes = NewProjectsLocationsIndexesService(s)
	rs.MetadataStores = NewProjectsLocationsMetadataStoresService(s)
	rs.MigratableResources = NewProjectsLocationsMigratableResourcesService(s)
	rs.ModelDeploymentMonitoringJobs = NewProjectsLocationsModelDeploymentMonitoringJobsService(s)
	rs.Models = NewProjectsLocationsModelsService(s)
	rs.NasJobs = NewProjectsLocationsNasJobsService(s)
	rs.NotebookRuntimeTemplates = NewProjectsLocationsNotebookRuntimeTemplatesService(s)
	rs.NotebookRuntimes = NewProjectsLocationsNotebookRuntimesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PipelineJobs = NewProjectsLocationsPipelineJobsService(s)
	rs.Publishers = NewProjectsLocationsPublishersService(s)
	rs.Schedules = NewProjectsLocationsSchedulesService(s)
	rs.SpecialistPools = NewProjectsLocationsSpecialistPoolsService(s)
	rs.Studies = NewProjectsLocationsStudiesService(s)
	rs.Tensorboards = NewProjectsLocationsTensorboardsService(s)
	rs.TrainingPipelines = NewProjectsLocationsTrainingPipelinesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	BatchPredictionJobs *ProjectsLocationsBatchPredictionJobsService

	CustomJobs *ProjectsLocationsCustomJobsService

	DataLabelingJobs *ProjectsLocationsDataLabelingJobsService

	Datasets *ProjectsLocationsDatasetsService

	DeploymentResourcePools *ProjectsLocationsDeploymentResourcePoolsService

	Endpoints *ProjectsLocationsEndpointsService

	FeatureGroups *ProjectsLocationsFeatureGroupsService

	FeatureOnlineStores *ProjectsLocationsFeatureOnlineStoresService

	Featurestores *ProjectsLocationsFeaturestoresService

	HyperparameterTuningJobs *ProjectsLocationsHyperparameterTuningJobsService

	IndexEndpoints *ProjectsLocationsIndexEndpointsService

	Indexes *ProjectsLocationsIndexesService

	MetadataStores *ProjectsLocationsMetadataStoresService

	MigratableResources *ProjectsLocationsMigratableResourcesService

	ModelDeploymentMonitoringJobs *ProjectsLocationsModelDeploymentMonitoringJobsService

	Models *ProjectsLocationsModelsService

	NasJobs *ProjectsLocationsNasJobsService

	NotebookRuntimeTemplates *ProjectsLocationsNotebookRuntimeTemplatesService

	NotebookRuntimes *ProjectsLocationsNotebookRuntimesService

	Operations *ProjectsLocationsOperationsService

	PipelineJobs *ProjectsLocationsPipelineJobsService

	Publishers *ProjectsLocationsPublishersService

	Schedules *ProjectsLocationsSchedulesService

	SpecialistPools *ProjectsLocationsSpecialistPoolsService

	Studies *ProjectsLocationsStudiesService

	Tensorboards *ProjectsLocationsTensorboardsService

	TrainingPipelines *ProjectsLocationsTrainingPipelinesService
}

func NewProjectsLocationsBatchPredictionJobsService(s *Service) *ProjectsLocationsBatchPredictionJobsService {
	rs := &ProjectsLocationsBatchPredictionJobsService{s: s}
	return rs
}

type ProjectsLocationsBatchPredictionJobsService struct {
	s *Service
}

func NewProjectsLocationsCustomJobsService(s *Service) *ProjectsLocationsCustomJobsService {
	rs := &ProjectsLocationsCustomJobsService{s: s}
	rs.Operations = NewProjectsLocationsCustomJobsOperationsService(s)
	return rs
}

type ProjectsLocationsCustomJobsService struct {
	s *Service

	Operations *ProjectsLocationsCustomJobsOperationsService
}

func NewProjectsLocationsCustomJobsOperationsService(s *Service) *ProjectsLocationsCustomJobsOperationsService {
	rs := &ProjectsLocationsCustomJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCustomJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataLabelingJobsService(s *Service) *ProjectsLocationsDataLabelingJobsService {
	rs := &ProjectsLocationsDataLabelingJobsService{s: s}
	rs.Operations = NewProjectsLocationsDataLabelingJobsOperationsService(s)
	return rs
}

type ProjectsLocationsDataLabelingJobsService struct {
	s *Service

	Operations *ProjectsLocationsDataLabelingJobsOperationsService
}

func NewProjectsLocationsDataLabelingJobsOperationsService(s *Service) *ProjectsLocationsDataLabelingJobsOperationsService {
	rs := &ProjectsLocationsDataLabelingJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataLabelingJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsService(s *Service) *ProjectsLocationsDatasetsService {
	rs := &ProjectsLocationsDatasetsService{s: s}
	rs.AnnotationSpecs = NewProjectsLocationsDatasetsAnnotationSpecsService(s)
	rs.DataItems = NewProjectsLocationsDatasetsDataItemsService(s)
	rs.DatasetVersions = NewProjectsLocationsDatasetsDatasetVersionsService(s)
	rs.Operations = NewProjectsLocationsDatasetsOperationsService(s)
	rs.SavedQueries = NewProjectsLocationsDatasetsSavedQueriesService(s)
	return rs
}

type ProjectsLocationsDatasetsService struct {
	s *Service

	AnnotationSpecs *ProjectsLocationsDatasetsAnnotationSpecsService

	DataItems *ProjectsLocationsDatasetsDataItemsService

	DatasetVersions *ProjectsLocationsDatasetsDatasetVersionsService

	Operations *ProjectsLocationsDatasetsOperationsService

	SavedQueries *ProjectsLocationsDatasetsSavedQueriesService
}

func NewProjectsLocationsDatasetsAnnotationSpecsService(s *Service) *ProjectsLocationsDatasetsAnnotationSpecsService {
	rs := &ProjectsLocationsDatasetsAnnotationSpecsService{s: s}
	rs.Operations = NewProjectsLocationsDatasetsAnnotationSpecsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsAnnotationSpecsService struct {
	s *Service

	Operations *ProjectsLocationsDatasetsAnnotationSpecsOperationsService
}

func NewProjectsLocationsDatasetsAnnotationSpecsOperationsService(s *Service) *ProjectsLocationsDatasetsAnnotationSpecsOperationsService {
	rs := &ProjectsLocationsDatasetsAnnotationSpecsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsAnnotationSpecsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDataItemsService(s *Service) *ProjectsLocationsDatasetsDataItemsService {
	rs := &ProjectsLocationsDatasetsDataItemsService{s: s}
	rs.Annotations = NewProjectsLocationsDatasetsDataItemsAnnotationsService(s)
	rs.Operations = NewProjectsLocationsDatasetsDataItemsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsDataItemsService struct {
	s *Service

	Annotations *ProjectsLocationsDatasetsDataItemsAnnotationsService

	Operations *ProjectsLocationsDatasetsDataItemsOperationsService
}

func NewProjectsLocationsDatasetsDataItemsAnnotationsService(s *Service) *ProjectsLocationsDatasetsDataItemsAnnotationsService {
	rs := &ProjectsLocationsDatasetsDataItemsAnnotationsService{s: s}
	rs.Operations = NewProjectsLocationsDatasetsDataItemsAnnotationsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsDataItemsAnnotationsService struct {
	s *Service

	Operations *ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService
}

func NewProjectsLocationsDatasetsDataItemsAnnotationsOperationsService(s *Service) *ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService {
	rs := &ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDataItemsOperationsService(s *Service) *ProjectsLocationsDatasetsDataItemsOperationsService {
	rs := &ProjectsLocationsDatasetsDataItemsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDataItemsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDatasetVersionsService(s *Service) *ProjectsLocationsDatasetsDatasetVersionsService {
	rs := &ProjectsLocationsDatasetsDatasetVersionsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDatasetVersionsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsOperationsService(s *Service) *ProjectsLocationsDatasetsOperationsService {
	rs := &ProjectsLocationsDatasetsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsSavedQueriesService(s *Service) *ProjectsLocationsDatasetsSavedQueriesService {
	rs := &ProjectsLocationsDatasetsSavedQueriesService{s: s}
	rs.Operations = NewProjectsLocationsDatasetsSavedQueriesOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsSavedQueriesService struct {
	s *Service

	Operations *ProjectsLocationsDatasetsSavedQueriesOperationsService
}

func NewProjectsLocationsDatasetsSavedQueriesOperationsService(s *Service) *ProjectsLocationsDatasetsSavedQueriesOperationsService {
	rs := &ProjectsLocationsDatasetsSavedQueriesOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsSavedQueriesOperationsService struct {
	s *Service
}

func NewProjectsLocationsDeploymentResourcePoolsService(s *Service) *ProjectsLocationsDeploymentResourcePoolsService {
	rs := &ProjectsLocationsDeploymentResourcePoolsService{s: s}
	rs.Operations = NewProjectsLocationsDeploymentResourcePoolsOperationsService(s)
	return rs
}

type ProjectsLocationsDeploymentResourcePoolsService struct {
	s *Service

	Operations *ProjectsLocationsDeploymentResourcePoolsOperationsService
}

func NewProjectsLocationsDeploymentResourcePoolsOperationsService(s *Service) *ProjectsLocationsDeploymentResourcePoolsOperationsService {
	rs := &ProjectsLocationsDeploymentResourcePoolsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDeploymentResourcePoolsOperationsService struct {
	s *Service
}

func NewProjectsLocationsEndpointsService(s *Service) *ProjectsLocationsEndpointsService {
	rs := &ProjectsLocationsEndpointsService{s: s}
	rs.Operations = NewProjectsLocationsEndpointsOperationsService(s)
	return rs
}

type ProjectsLocationsEndpointsService struct {
	s *Service

	Operations *ProjectsLocationsEndpointsOperationsService
}

func NewProjectsLocationsEndpointsOperationsService(s *Service) *ProjectsLocationsEndpointsOperationsService {
	rs := &ProjectsLocationsEndpointsOperationsService{s: s}
	return rs
}

type ProjectsLocationsEndpointsOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureGroupsService(s *Service) *ProjectsLocationsFeatureGroupsService {
	rs := &ProjectsLocationsFeatureGroupsService{s: s}
	rs.Features = NewProjectsLocationsFeatureGroupsFeaturesService(s)
	rs.Operations = NewProjectsLocationsFeatureGroupsOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureGroupsService struct {
	s *Service

	Features *ProjectsLocationsFeatureGroupsFeaturesService

	Operations *ProjectsLocationsFeatureGroupsOperationsService
}

func NewProjectsLocationsFeatureGroupsFeaturesService(s *Service) *ProjectsLocationsFeatureGroupsFeaturesService {
	rs := &ProjectsLocationsFeatureGroupsFeaturesService{s: s}
	rs.Operations = NewProjectsLocationsFeatureGroupsFeaturesOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureGroupsFeaturesService struct {
	s *Service

	Operations *ProjectsLocationsFeatureGroupsFeaturesOperationsService
}

func NewProjectsLocationsFeatureGroupsFeaturesOperationsService(s *Service) *ProjectsLocationsFeatureGroupsFeaturesOperationsService {
	rs := &ProjectsLocationsFeatureGroupsFeaturesOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureGroupsFeaturesOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureGroupsOperationsService(s *Service) *ProjectsLocationsFeatureGroupsOperationsService {
	rs := &ProjectsLocationsFeatureGroupsOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureGroupsOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureOnlineStoresService(s *Service) *ProjectsLocationsFeatureOnlineStoresService {
	rs := &ProjectsLocationsFeatureOnlineStoresService{s: s}
	rs.FeatureViews = NewProjectsLocationsFeatureOnlineStoresFeatureViewsService(s)
	rs.Operations = NewProjectsLocationsFeatureOnlineStoresOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureOnlineStoresService struct {
	s *Service

	FeatureViews *ProjectsLocationsFeatureOnlineStoresFeatureViewsService

	Operations *ProjectsLocationsFeatureOnlineStoresOperationsService
}

func NewProjectsLocationsFeatureOnlineStoresFeatureViewsService(s *Service) *ProjectsLocationsFeatureOnlineStoresFeatureViewsService {
	rs := &ProjectsLocationsFeatureOnlineStoresFeatureViewsService{s: s}
	rs.FeatureViewSyncs = NewProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService(s)
	rs.Operations = NewProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureOnlineStoresFeatureViewsService struct {
	s *Service

	FeatureViewSyncs *ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService

	Operations *ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService
}

func NewProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService(s *Service) *ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService {
	rs := &ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService{s: s}
	return rs
}

type ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService struct {
	s *Service
}

func NewProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService(s *Service) *ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService {
	rs := &ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureOnlineStoresOperationsService(s *Service) *ProjectsLocationsFeatureOnlineStoresOperationsService {
	rs := &ProjectsLocationsFeatureOnlineStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureOnlineStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeaturestoresService(s *Service) *ProjectsLocationsFeaturestoresService {
	rs := &ProjectsLocationsFeaturestoresService{s: s}
	rs.EntityTypes = NewProjectsLocationsFeaturestoresEntityTypesService(s)
	rs.Operations = NewProjectsLocationsFeaturestoresOperationsService(s)
	return rs
}

type ProjectsLocationsFeaturestoresService struct {
	s *Service

	EntityTypes *ProjectsLocationsFeaturestoresEntityTypesService

	Operations *ProjectsLocationsFeaturestoresOperationsService
}

func NewProjectsLocationsFeaturestoresEntityTypesService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesService{s: s}
	rs.Features = NewProjectsLocationsFeaturestoresEntityTypesFeaturesService(s)
	rs.Operations = NewProjectsLocationsFeaturestoresEntityTypesOperationsService(s)
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesService struct {
	s *Service

	Features *ProjectsLocationsFeaturestoresEntityTypesFeaturesService

	Operations *ProjectsLocationsFeaturestoresEntityTypesOperationsService
}

func NewProjectsLocationsFeaturestoresEntityTypesFeaturesService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesFeaturesService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesFeaturesService{s: s}
	rs.Operations = NewProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService(s)
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesFeaturesService struct {
	s *Service

	Operations *ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService
}

func NewProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeaturestoresEntityTypesOperationsService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesOperationsService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeaturestoresOperationsService(s *Service) *ProjectsLocationsFeaturestoresOperationsService {
	rs := &ProjectsLocationsFeaturestoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeaturestoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsHyperparameterTuningJobsService(s *Service) *ProjectsLocationsHyperparameterTuningJobsService {
	rs := &ProjectsLocationsHyperparameterTuningJobsService{s: s}
	rs.Operations = NewProjectsLocationsHyperparameterTuningJobsOperationsService(s)
	return rs
}

type ProjectsLocationsHyperparameterTuningJobsService struct {
	s *Service

	Operations *ProjectsLocationsHyperparameterTuningJobsOperationsService
}

func NewProjectsLocationsHyperparameterTuningJobsOperationsService(s *Service) *ProjectsLocationsHyperparameterTuningJobsOperationsService {
	rs := &ProjectsLocationsHyperparameterTuningJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsHyperparameterTuningJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsIndexEndpointsService(s *Service) *ProjectsLocationsIndexEndpointsService {
	rs := &ProjectsLocationsIndexEndpointsService{s: s}
	rs.Operations = NewProjectsLocationsIndexEndpointsOperationsService(s)
	return rs
}

type ProjectsLocationsIndexEndpointsService struct {
	s *Service

	Operations *ProjectsLocationsIndexEndpointsOperationsService
}

func NewProjectsLocationsIndexEndpointsOperationsService(s *Service) *ProjectsLocationsIndexEndpointsOperationsService {
	rs := &ProjectsLocationsIndexEndpointsOperationsService{s: s}
	return rs
}

type ProjectsLocationsIndexEndpointsOperationsService struct {
	s *Service
}

func NewProjectsLocationsIndexesService(s *Service) *ProjectsLocationsIndexesService {
	rs := &ProjectsLocationsIndexesService{s: s}
	rs.Operations = NewProjectsLocationsIndexesOperationsService(s)
	return rs
}

type ProjectsLocationsIndexesService struct {
	s *Service

	Operations *ProjectsLocationsIndexesOperationsService
}

func NewProjectsLocationsIndexesOperationsService(s *Service) *ProjectsLocationsIndexesOperationsService {
	rs := &ProjectsLocationsIndexesOperationsService{s: s}
	return rs
}

type ProjectsLocationsIndexesOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresService(s *Service) *ProjectsLocationsMetadataStoresService {
	rs := &ProjectsLocationsMetadataStoresService{s: s}
	rs.Artifacts = NewProjectsLocationsMetadataStoresArtifactsService(s)
	rs.Contexts = NewProjectsLocationsMetadataStoresContextsService(s)
	rs.Executions = NewProjectsLocationsMetadataStoresExecutionsService(s)
	rs.MetadataSchemas = NewProjectsLocationsMetadataStoresMetadataSchemasService(s)
	rs.Operations = NewProjectsLocationsMetadataStoresOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresService struct {
	s *Service

	Artifacts *ProjectsLocationsMetadataStoresArtifactsService

	Contexts *ProjectsLocationsMetadataStoresContextsService

	Executions *ProjectsLocationsMetadataStoresExecutionsService

	MetadataSchemas *ProjectsLocationsMetadataStoresMetadataSchemasService

	Operations *ProjectsLocationsMetadataStoresOperationsService
}

func NewProjectsLocationsMetadataStoresArtifactsService(s *Service) *ProjectsLocationsMetadataStoresArtifactsService {
	rs := &ProjectsLocationsMetadataStoresArtifactsService{s: s}
	rs.Operations = NewProjectsLocationsMetadataStoresArtifactsOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresArtifactsService struct {
	s *Service

	Operations *ProjectsLocationsMetadataStoresArtifactsOperationsService
}

func NewProjectsLocationsMetadataStoresArtifactsOperationsService(s *Service) *ProjectsLocationsMetadataStoresArtifactsOperationsService {
	rs := &ProjectsLocationsMetadataStoresArtifactsOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresArtifactsOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresContextsService(s *Service) *ProjectsLocationsMetadataStoresContextsService {
	rs := &ProjectsLocationsMetadataStoresContextsService{s: s}
	rs.Operations = NewProjectsLocationsMetadataStoresContextsOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresContextsService struct {
	s *Service

	Operations *ProjectsLocationsMetadataStoresContextsOperationsService
}

func NewProjectsLocationsMetadataStoresContextsOperationsService(s *Service) *ProjectsLocationsMetadataStoresContextsOperationsService {
	rs := &ProjectsLocationsMetadataStoresContextsOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresContextsOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresExecutionsService(s *Service) *ProjectsLocationsMetadataStoresExecutionsService {
	rs := &ProjectsLocationsMetadataStoresExecutionsService{s: s}
	rs.Operations = NewProjectsLocationsMetadataStoresExecutionsOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresExecutionsService struct {
	s *Service

	Operations *ProjectsLocationsMetadataStoresExecutionsOperationsService
}

func NewProjectsLocationsMetadataStoresExecutionsOperationsService(s *Service) *ProjectsLocationsMetadataStoresExecutionsOperationsService {
	rs := &ProjectsLocationsMetadataStoresExecutionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresExecutionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresMetadataSchemasService(s *Service) *ProjectsLocationsMetadataStoresMetadataSchemasService {
	rs := &ProjectsLocationsMetadataStoresMetadataSchemasService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresMetadataSchemasService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresOperationsService(s *Service) *ProjectsLocationsMetadataStoresOperationsService {
	rs := &ProjectsLocationsMetadataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsMigratableResourcesService(s *Service) *ProjectsLocationsMigratableResourcesService {
	rs := &ProjectsLocationsMigratableResourcesService{s: s}
	rs.Operations = NewProjectsLocationsMigratableResourcesOperationsService(s)
	return rs
}

type ProjectsLocationsMigratableResourcesService struct {
	s *Service

	Operations *ProjectsLocationsMigratableResourcesOperationsService
}

func NewProjectsLocationsMigratableResourcesOperationsService(s *Service) *ProjectsLocationsMigratableResourcesOperationsService {
	rs := &ProjectsLocationsMigratableResourcesOperationsService{s: s}
	return rs
}

type ProjectsLocationsMigratableResourcesOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelDeploymentMonitoringJobsService(s *Service) *ProjectsLocationsModelDeploymentMonitoringJobsService {
	rs := &ProjectsLocationsModelDeploymentMonitoringJobsService{s: s}
	rs.Operations = NewProjectsLocationsModelDeploymentMonitoringJobsOperationsService(s)
	return rs
}

type ProjectsLocationsModelDeploymentMonitoringJobsService struct {
	s *Service

	Operations *ProjectsLocationsModelDeploymentMonitoringJobsOperationsService
}

func NewProjectsLocationsModelDeploymentMonitoringJobsOperationsService(s *Service) *ProjectsLocationsModelDeploymentMonitoringJobsOperationsService {
	rs := &ProjectsLocationsModelDeploymentMonitoringJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelDeploymentMonitoringJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelsService(s *Service) *ProjectsLocationsModelsService {
	rs := &ProjectsLocationsModelsService{s: s}
	rs.Evaluations = NewProjectsLocationsModelsEvaluationsService(s)
	rs.Operations = NewProjectsLocationsModelsOperationsService(s)
	return rs
}

type ProjectsLocationsModelsService struct {
	s *Service

	Evaluations *ProjectsLocationsModelsEvaluationsService

	Operations *ProjectsLocationsModelsOperationsService
}

func NewProjectsLocationsModelsEvaluationsService(s *Service) *ProjectsLocationsModelsEvaluationsService {
	rs := &ProjectsLocationsModelsEvaluationsService{s: s}
	rs.Operations = NewProjectsLocationsModelsEvaluationsOperationsService(s)
	rs.Slices = NewProjectsLocationsModelsEvaluationsSlicesService(s)
	return rs
}

type ProjectsLocationsModelsEvaluationsService struct {
	s *Service

	Operations *ProjectsLocationsModelsEvaluationsOperationsService

	Slices *ProjectsLocationsModelsEvaluationsSlicesService
}

func NewProjectsLocationsModelsEvaluationsOperationsService(s *Service) *ProjectsLocationsModelsEvaluationsOperationsService {
	rs := &ProjectsLocationsModelsEvaluationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelsEvaluationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelsEvaluationsSlicesService(s *Service) *ProjectsLocationsModelsEvaluationsSlicesService {
	rs := &ProjectsLocationsModelsEvaluationsSlicesService{s: s}
	return rs
}

type ProjectsLocationsModelsEvaluationsSlicesService struct {
	s *Service
}

func NewProjectsLocationsModelsOperationsService(s *Service) *ProjectsLocationsModelsOperationsService {
	rs := &ProjectsLocationsModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsNasJobsService(s *Service) *ProjectsLocationsNasJobsService {
	rs := &ProjectsLocationsNasJobsService{s: s}
	rs.NasTrialDetails = NewProjectsLocationsNasJobsNasTrialDetailsService(s)
	return rs
}

type ProjectsLocationsNasJobsService struct {
	s *Service

	NasTrialDetails *ProjectsLocationsNasJobsNasTrialDetailsService
}

func NewProjectsLocationsNasJobsNasTrialDetailsService(s *Service) *ProjectsLocationsNasJobsNasTrialDetailsService {
	rs := &ProjectsLocationsNasJobsNasTrialDetailsService{s: s}
	return rs
}

type ProjectsLocationsNasJobsNasTrialDetailsService struct {
	s *Service
}

func NewProjectsLocationsNotebookRuntimeTemplatesService(s *Service) *ProjectsLocationsNotebookRuntimeTemplatesService {
	rs := &ProjectsLocationsNotebookRuntimeTemplatesService{s: s}
	return rs
}

type ProjectsLocationsNotebookRuntimeTemplatesService struct {
	s *Service
}

func NewProjectsLocationsNotebookRuntimesService(s *Service) *ProjectsLocationsNotebookRuntimesService {
	rs := &ProjectsLocationsNotebookRuntimesService{s: s}
	return rs
}

type ProjectsLocationsNotebookRuntimesService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPipelineJobsService(s *Service) *ProjectsLocationsPipelineJobsService {
	rs := &ProjectsLocationsPipelineJobsService{s: s}
	rs.Operations = NewProjectsLocationsPipelineJobsOperationsService(s)
	return rs
}

type ProjectsLocationsPipelineJobsService struct {
	s *Service

	Operations *ProjectsLocationsPipelineJobsOperationsService
}

func NewProjectsLocationsPipelineJobsOperationsService(s *Service) *ProjectsLocationsPipelineJobsOperationsService {
	rs := &ProjectsLocationsPipelineJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsPipelineJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPublishersService(s *Service) *ProjectsLocationsPublishersService {
	rs := &ProjectsLocationsPublishersService{s: s}
	rs.Models = NewProjectsLocationsPublishersModelsService(s)
	return rs
}

type ProjectsLocationsPublishersService struct {
	s *Service

	Models *ProjectsLocationsPublishersModelsService
}

func NewProjectsLocationsPublishersModelsService(s *Service) *ProjectsLocationsPublishersModelsService {
	rs := &ProjectsLocationsPublishersModelsService{s: s}
	return rs
}

type ProjectsLocationsPublishersModelsService struct {
	s *Service
}

func NewProjectsLocationsSchedulesService(s *Service) *ProjectsLocationsSchedulesService {
	rs := &ProjectsLocationsSchedulesService{s: s}
	rs.Operations = NewProjectsLocationsSchedulesOperationsService(s)
	return rs
}

type ProjectsLocationsSchedulesService struct {
	s *Service

	Operations *ProjectsLocationsSchedulesOperationsService
}

func NewProjectsLocationsSchedulesOperationsService(s *Service) *ProjectsLocationsSchedulesOperationsService {
	rs := &ProjectsLocationsSchedulesOperationsService{s: s}
	return rs
}

type ProjectsLocationsSchedulesOperationsService struct {
	s *Service
}

func NewProjectsLocationsSpecialistPoolsService(s *Service) *ProjectsLocationsSpecialistPoolsService {
	rs := &ProjectsLocationsSpecialistPoolsService{s: s}
	rs.Operations = NewProjectsLocationsSpecialistPoolsOperationsService(s)
	return rs
}

type ProjectsLocationsSpecialistPoolsService struct {
	s *Service

	Operations *ProjectsLocationsSpecialistPoolsOperationsService
}

func NewProjectsLocationsSpecialistPoolsOperationsService(s *Service) *ProjectsLocationsSpecialistPoolsOperationsService {
	rs := &ProjectsLocationsSpecialistPoolsOperationsService{s: s}
	return rs
}

type ProjectsLocationsSpecialistPoolsOperationsService struct {
	s *Service
}

func NewProjectsLocationsStudiesService(s *Service) *ProjectsLocationsStudiesService {
	rs := &ProjectsLocationsStudiesService{s: s}
	rs.Operations = NewProjectsLocationsStudiesOperationsService(s)
	rs.Trials = NewProjectsLocationsStudiesTrialsService(s)
	return rs
}

type ProjectsLocationsStudiesService struct {
	s *Service

	Operations *ProjectsLocationsStudiesOperationsService

	Trials *ProjectsLocationsStudiesTrialsService
}

func NewProjectsLocationsStudiesOperationsService(s *Service) *ProjectsLocationsStudiesOperationsService {
	rs := &ProjectsLocationsStudiesOperationsService{s: s}
	return rs
}

type ProjectsLocationsStudiesOperationsService struct {
	s *Service
}

func NewProjectsLocationsStudiesTrialsService(s *Service) *ProjectsLocationsStudiesTrialsService {
	rs := &ProjectsLocationsStudiesTrialsService{s: s}
	rs.Operations = NewProjectsLocationsStudiesTrialsOperationsService(s)
	return rs
}

type ProjectsLocationsStudiesTrialsService struct {
	s *Service

	Operations *ProjectsLocationsStudiesTrialsOperationsService
}

func NewProjectsLocationsStudiesTrialsOperationsService(s *Service) *ProjectsLocationsStudiesTrialsOperationsService {
	rs := &ProjectsLocationsStudiesTrialsOperationsService{s: s}
	return rs
}

type ProjectsLocationsStudiesTrialsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsService(s *Service) *ProjectsLocationsTensorboardsService {
	rs := &ProjectsLocationsTensorboardsService{s: s}
	rs.Experiments = NewProjectsLocationsTensorboardsExperimentsService(s)
	rs.Operations = NewProjectsLocationsTensorboardsOperationsService(s)
	return rs
}

type ProjectsLocationsTensorboardsService struct {
	s *Service

	Experiments *ProjectsLocationsTensorboardsExperimentsService

	Operations *ProjectsLocationsTensorboardsOperationsService
}

func NewProjectsLocationsTensorboardsExperimentsService(s *Service) *ProjectsLocationsTensorboardsExperimentsService {
	rs := &ProjectsLocationsTensorboardsExperimentsService{s: s}
	rs.Operations = NewProjectsLocationsTensorboardsExperimentsOperationsService(s)
	rs.Runs = NewProjectsLocationsTensorboardsExperimentsRunsService(s)
	return rs
}

type ProjectsLocationsTensorboardsExperimentsService struct {
	s *Service

	Operations *ProjectsLocationsTensorboardsExperimentsOperationsService

	Runs *ProjectsLocationsTensorboardsExperimentsRunsService
}

func NewProjectsLocationsTensorboardsExperimentsOperationsService(s *Service) *ProjectsLocationsTensorboardsExperimentsOperationsService {
	rs := &ProjectsLocationsTensorboardsExperimentsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsExperimentsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsExperimentsRunsService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsService{s: s}
	rs.Operations = NewProjectsLocationsTensorboardsExperimentsRunsOperationsService(s)
	rs.TimeSeries = NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService(s)
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsService struct {
	s *Service

	Operations *ProjectsLocationsTensorboardsExperimentsRunsOperationsService

	TimeSeries *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService
}

func NewProjectsLocationsTensorboardsExperimentsRunsOperationsService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsOperationsService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService{s: s}
	rs.Operations = NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService(s)
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService struct {
	s *Service

	Operations *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService
}

func NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsOperationsService(s *Service) *ProjectsLocationsTensorboardsOperationsService {
	rs := &ProjectsLocationsTensorboardsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTrainingPipelinesService(s *Service) *ProjectsLocationsTrainingPipelinesService {
	rs := &ProjectsLocationsTrainingPipelinesService{s: s}
	rs.Operations = NewProjectsLocationsTrainingPipelinesOperationsService(s)
	return rs
}

type ProjectsLocationsTrainingPipelinesService struct {
	s *Service

	Operations *ProjectsLocationsTrainingPipelinesOperationsService
}

func NewProjectsLocationsTrainingPipelinesOperationsService(s *Service) *ProjectsLocationsTrainingPipelinesOperationsService {
	rs := &ProjectsLocationsTrainingPipelinesOperationsService{s: s}
	return rs
}

type ProjectsLocationsTrainingPipelinesOperationsService struct {
	s *Service
}

func NewPublishersService(s *Service) *PublishersService {
	rs := &PublishersService{s: s}
	rs.Models = NewPublishersModelsService(s)
	return rs
}

type PublishersService struct {
	s *Service

	Models *PublishersModelsService
}

func NewPublishersModelsService(s *Service) *PublishersModelsService {
	rs := &PublishersModelsService{s: s}
	return rs
}

type PublishersModelsService struct {
	s *Service
}

// CloudAiLargeModelsVisionEmbedVideoResponse: Video embedding response.
type CloudAiLargeModelsVisionEmbedVideoResponse struct {
	// VideoEmbeddings: The embedding vector for the video.
	VideoEmbeddings []interface{} `json:"videoEmbeddings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "VideoEmbeddings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "VideoEmbeddings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionEmbedVideoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionEmbedVideoResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionFilteredText: Details for filtered input
// text.
type CloudAiLargeModelsVisionFilteredText struct {
	// Category: Confidence level
	//
	// Possible values:
	//   "RAI_CATEGORY_UNSPECIFIED"
	//   "OBSCENE"
	//   "SEXUALLY_EXPLICIT" - Porn
	//   "IDENTITY_ATTACK" - Hate
	//   "VIOLENCE_ABUSE"
	//   "CSAI"
	//   "SPII"
	//   "CELEBRITY"
	//   "FACE_IMG"
	//   "WATERMARK_IMG"
	//   "MEMORIZATION_IMG"
	//   "CSAI_IMG"
	//   "PORN_IMG"
	//   "VIOLENCE_IMG"
	//   "CHILD_IMG"
	//   "TOXIC"
	//   "SENSITIVE_WORD"
	//   "PERSON_IMG"
	//   "ICA_IMG"
	//   "SEXUAL_IMG"
	//   "IU_IMG"
	//   "RACY_IMG"
	//   "PEDO_IMG"
	//   "DEATH_HARM_TRAGEDY" - SafetyAttributes returned but not filtered
	// on
	//   "HEALTH"
	//   "FIREARMS_WEAPONS"
	//   "RELIGIOUS_BELIEF"
	//   "ILLICIT_DRUGS"
	//   "WAR_CONFLICT"
	//   "POLITICS"
	//   "HATE_SYMBOL_IMG" - End of list
	//   "CHILD_TEXT"
	//   "DANGEROUS_CONTENT" - Text category from SafetyCat v3
	//   "RECITATION_TEXT"
	//   "CELEBRITY_IMG"
	Category string `json:"category,omitempty"`

	// Confidence: Filtered category
	//
	// Possible values:
	//   "CONFIDENCE_UNSPECIFIED"
	//   "CONFIDENCE_LOW"
	//   "CONFIDENCE_MEDIUM"
	//   "CONFIDENCE_HIGH"
	Confidence string `json:"confidence,omitempty"`

	// Prompt: Input prompt
	Prompt string `json:"prompt,omitempty"`

	// Score: Score for category
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionFilteredText) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionFilteredText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionFilteredText) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionFilteredText
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// CloudAiLargeModelsVisionGenerateVideoResponse: Generate video
// response.
type CloudAiLargeModelsVisionGenerateVideoResponse struct {
	// GeneratedSamples: The generates samples.
	GeneratedSamples []*CloudAiLargeModelsVisionMedia `json:"generatedSamples,omitempty"`

	// RaiMediaFilteredCount: Returns if any videos were filtered due to RAI
	// policies.
	RaiMediaFilteredCount int64 `json:"raiMediaFilteredCount,omitempty"`

	// RaiMediaFilteredReasons: Returns rai failure reasons if any.
	RaiMediaFilteredReasons []string `json:"raiMediaFilteredReasons,omitempty"`

	// RaiTextFilteredReason: Returns filtered text rai info.
	RaiTextFilteredReason *CloudAiLargeModelsVisionFilteredText `json:"raiTextFilteredReason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GeneratedSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GeneratedSamples") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionGenerateVideoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionGenerateVideoResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionImage: Image.
type CloudAiLargeModelsVisionImage struct {
	// Encoding: Image encoding, encoded as "image/png" or "image/jpg".
	Encoding string `json:"encoding,omitempty"`

	// Image: Raw bytes.
	Image string `json:"image,omitempty"`

	// ImageRaiScores: RAI scores for generated image.
	ImageRaiScores *CloudAiLargeModelsVisionImageRAIScores `json:"imageRaiScores,omitempty"`

	// RaiInfo: RAI info for image.
	RaiInfo *CloudAiLargeModelsVisionRaiInfo `json:"raiInfo,omitempty"`

	// SemanticFilterResponse: Semantic filter info for image.
	SemanticFilterResponse *CloudAiLargeModelsVisionSemanticFilterResponse `json:"semanticFilterResponse,omitempty"`

	// Text: Text/Expanded text input for imagen.
	Text string `json:"text,omitempty"`

	// Uri: Path to another storage (typically Google Cloud Storage).
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Encoding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Encoding") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionImage) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionImageRAIScores: RAI scores for generated
// image returned.
type CloudAiLargeModelsVisionImageRAIScores struct {
	// AgileWatermarkDetectionScore: Agile watermark score for image.
	AgileWatermarkDetectionScore float64 `json:"agileWatermarkDetectionScore,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AgileWatermarkDetectionScore") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AgileWatermarkDetectionScore") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionImageRAIScores) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionImageRAIScores
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionImageRAIScores) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionImageRAIScores
	var s1 struct {
		AgileWatermarkDetectionScore gensupport.JSONFloat64 `json:"agileWatermarkDetectionScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AgileWatermarkDetectionScore = float64(s1.AgileWatermarkDetectionScore)
	return nil
}

// CloudAiLargeModelsVisionMedia: Media.
type CloudAiLargeModelsVisionMedia struct {
	// Image: Image.
	Image *CloudAiLargeModelsVisionImage `json:"image,omitempty"`

	// Video: Video
	Video *CloudAiLargeModelsVisionVideo `json:"video,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Image") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionMedia) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionMedia
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionMediaGenerateContentResponse: Generate media
// content response
type CloudAiLargeModelsVisionMediaGenerateContentResponse struct {
	// Response: Response to the user's request.
	Response *CloudAiNlLlmProtoServiceGenerateMultiModalResponse `json:"response,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Response") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionMediaGenerateContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionMediaGenerateContentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CloudAiLargeModelsVisionNamedBoundingBox struct {
	Classes []string `json:"classes,omitempty"`

	Entities []string `json:"entities,omitempty"`

	Scores []float64 `json:"scores,omitempty"`

	X1 float64 `json:"x1,omitempty"`

	X2 float64 `json:"x2,omitempty"`

	Y1 float64 `json:"y1,omitempty"`

	Y2 float64 `json:"y2,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Classes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Classes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionNamedBoundingBox) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionNamedBoundingBox
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionNamedBoundingBox) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionNamedBoundingBox
	var s1 struct {
		Scores []gensupport.JSONFloat64 `json:"scores"`
		X1     gensupport.JSONFloat64   `json:"x1"`
		X2     gensupport.JSONFloat64   `json:"x2"`
		Y1     gensupport.JSONFloat64   `json:"y1"`
		Y2     gensupport.JSONFloat64   `json:"y2"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Scores = make([]float64, len(s1.Scores))
	for i := range s1.Scores {
		s.Scores[i] = float64(s1.Scores[i])
	}
	s.X1 = float64(s1.X1)
	s.X2 = float64(s1.X2)
	s.Y1 = float64(s1.Y1)
	s.Y2 = float64(s1.Y2)
	return nil
}

type CloudAiLargeModelsVisionRaiInfo struct {
	// RaiCategories: List of rai categories' information to return
	RaiCategories []string `json:"raiCategories,omitempty"`

	// Scores: List of rai scores mapping to the rai categories. Rounded to
	// 1 decimal place.
	Scores []float64 `json:"scores,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RaiCategories") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RaiCategories") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionRaiInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRaiInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionRaiInfo) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionRaiInfo
	var s1 struct {
		Scores []gensupport.JSONFloat64 `json:"scores"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Scores = make([]float64, len(s1.Scores))
	for i := range s1.Scores {
		s.Scores[i] = float64(s1.Scores[i])
	}
	return nil
}

// CloudAiLargeModelsVisionReasonVideoResponse: Video reasoning
// response.
type CloudAiLargeModelsVisionReasonVideoResponse struct {
	// Responses: Generated text responses. The generated responses for
	// different segments within the same video.
	Responses []*CloudAiLargeModelsVisionReasonVideoResponseTextResponse `json:"responses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Responses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Responses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionReasonVideoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionReasonVideoResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionReasonVideoResponseTextResponse: Contains
// text that is the response of the video captioning.
type CloudAiLargeModelsVisionReasonVideoResponseTextResponse struct {
	// RelativeTemporalPartition: Partition of the caption's video in time.
	// This field is intended for video captioning. To represent the start
	// time and end time of the caption's video.
	RelativeTemporalPartition *CloudAiLargeModelsVisionRelativeTemporalPartition `json:"relativeTemporalPartition,omitempty"`

	// Text: Text information
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "RelativeTemporalPartition") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "RelativeTemporalPartition") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionReasonVideoResponseTextResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionReasonVideoResponseTextResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionRelativeTemporalPartition: For ease of use,
// assume that the start_offset is inclusive and the end_offset is
// exclusive. In mathematical terms, the partition would be written as
// [start_offset, end_offset).
type CloudAiLargeModelsVisionRelativeTemporalPartition struct {
	// EndOffset: End time offset of the partition.
	EndOffset string `json:"endOffset,omitempty"`

	// StartOffset: Start time offset of the partition.
	StartOffset string `json:"startOffset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndOffset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionRelativeTemporalPartition) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRelativeTemporalPartition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CloudAiLargeModelsVisionSemanticFilterResponse struct {
	// NamedBoundingBoxes: Class labels of the bounding boxes that failed
	// the semantic filtering. Bounding box coordinates.
	NamedBoundingBoxes []*CloudAiLargeModelsVisionNamedBoundingBox `json:"namedBoundingBoxes,omitempty"`

	// PassedSemanticFilter: This response is added when semantic filter
	// config is turned on in EditConfig. It reports if this image is passed
	// semantic filter response. If passed_semantic_filter is false, the
	// bounding box information will be populated for user to check what
	// caused the semantic filter to fail.
	PassedSemanticFilter bool `json:"passedSemanticFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NamedBoundingBoxes")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NamedBoundingBoxes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionSemanticFilterResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionSemanticFilterResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionVideo: Video
type CloudAiLargeModelsVisionVideo struct {
	// Uri: Path to another storage (typically Google Cloud Storage).
	Uri string `json:"uri,omitempty"`

	// Video: Raw bytes.
	Video string `json:"video,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiLargeModelsVisionVideo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionVideo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CloudAiNlLlmProtoServiceCandidate struct {
	// CitationMetadata: Source attribution of the generated content.
	CitationMetadata *CloudAiNlLlmProtoServiceCitationMetadata `json:"citationMetadata,omitempty"`

	// Content: Content of the candidate.
	Content *CloudAiNlLlmProtoServiceContent `json:"content,omitempty"`

	// FinishMessage: A string that describes the filtering behavior in more
	// detail. Only filled when reason is set.
	FinishMessage string `json:"finishMessage,omitempty"`

	// FinishReason: The reason why the model stopped generating tokens.
	//
	// Possible values:
	//   "FINISH_REASON_UNSPECIFIED" - The finish reason is unspecified.
	//   "FINISH_REASON_STOP" - Natural stop point of the model or provided
	// stop sequence.
	//   "FINISH_REASON_MAX_TOKENS" - The maximum number of tokens as
	// specified in the request was reached.
	//   "FINISH_REASON_SAFETY" - The token generation was stopped as the
	// response was flagged for safety reasons. NOTE: When streaming the
	// Candidate.content will be empty if content filters blocked the
	// output.
	//   "FINISH_REASON_RECITATION" - The token generation was stopped as
	// the response was flagged for unauthorized citations.
	//   "FINISH_REASON_OTHER" - All other reasons that stopped the token
	// generation.
	//   "FINISH_REASON_BLOCKLIST" - The token generation was stopped as the
	// response was flagged for the terms which are included from the
	// terminology blocklist.
	//   "FINISH_REASON_PROHIBITED_CONTENT" - The token generation was
	// stopped as the response was flagged for the prohibited contents.
	//   "FINISH_REASON_SPII" - The token generation was stopped as the
	// response was flagged for Sensitive Personally Identifiable
	// Information (SPII) contents.
	FinishReason string `json:"finishReason,omitempty"`

	// GroundingMetadata: Grounding metadata. Combine with the facts list
	// from response to generate grounding citations for this choice.
	GroundingMetadata *LearningGenaiRootGroundingMetadata `json:"groundingMetadata,omitempty"`

	// Index: Index of the candidate.
	Index int64 `json:"index,omitempty"`

	// SafetyRatings: Safety ratings of the generated content.
	SafetyRatings []*CloudAiNlLlmProtoServiceSafetyRating `json:"safetyRatings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CitationMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CitationMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceCandidate) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceCandidate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServiceCitation: Source attributions for content.
type CloudAiNlLlmProtoServiceCitation struct {
	// EndIndex: End index into the content.
	EndIndex int64 `json:"endIndex,omitempty"`

	// License: License of the attribution.
	License string `json:"license,omitempty"`

	// PublicationDate: Publication date of the attribution.
	PublicationDate *GoogleTypeDate `json:"publicationDate,omitempty"`

	// StartIndex: Start index into the content.
	StartIndex int64 `json:"startIndex,omitempty"`

	// Title: Title of the attribution.
	Title string `json:"title,omitempty"`

	// Uri: Url reference of the attribution.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndIndex") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceCitation) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceCitation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServiceCitationMetadata: A collection of source
// attributions for a piece of content.
type CloudAiNlLlmProtoServiceCitationMetadata struct {
	// Citations: List of citations.
	Citations []*CloudAiNlLlmProtoServiceCitation `json:"citations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Citations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceCitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceCitationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServiceContent: The content of a single message from
// a participant.
type CloudAiNlLlmProtoServiceContent struct {
	// Parts: The parts of the message.
	Parts []*CloudAiNlLlmProtoServicePart `json:"parts,omitempty"`

	// Role: The role of the current conversation participant.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parts") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceContent) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServiceFact: A condense version of WorldFact
// (assistant/boq/lamda/factuality/proto/factuality.proto) to propagate
// the essential information about the fact used in factuality to the
// upstream caller.
type CloudAiNlLlmProtoServiceFact struct {
	// Query: Query that is used to retrieve this fact.
	Query string `json:"query,omitempty"`

	// Summary: If present, the summary/snippet of the fact.
	Summary string `json:"summary,omitempty"`

	// Title: If present, it refers to the title of this fact.
	Title string `json:"title,omitempty"`

	// Url: If present, this URL links to the webpage of the fact.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Query") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceFact) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceFact
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServiceFunctionCall: Function call details.
type CloudAiNlLlmProtoServiceFunctionCall struct {
	// Args: The function parameters and values in JSON format.
	Args googleapi.RawMessage `json:"args,omitempty"`

	// Name: Required. The name of the function to call.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceFunctionCall) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceFunctionCall
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServiceFunctionResponse: Function response details.
type CloudAiNlLlmProtoServiceFunctionResponse struct {
	// Name: Required. The name of the function to call.
	Name string `json:"name,omitempty"`

	// Response: Required. The function response in JSON object format.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceFunctionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceFunctionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CloudAiNlLlmProtoServiceGenerateMultiModalResponse struct {
	// Candidates: Possible candidate responses to the conversation up until
	// this point.
	Candidates []*CloudAiNlLlmProtoServiceCandidate `json:"candidates,omitempty"`

	// DebugMetadata: Debug information containing message metadata. Clients
	// should not consume this field, and this is only populated for Flow
	// Runner path.
	DebugMetadata *CloudAiNlLlmProtoServiceMessageMetadata `json:"debugMetadata,omitempty"`

	// Facts: External facts retrieved for factuality/grounding.
	Facts []*CloudAiNlLlmProtoServiceFact `json:"facts,omitempty"`

	// PromptFeedback: Content filter results for a prompt sent in the
	// request. Note: Sent only in the first stream chunk. Only happens when
	// no candidates were generated due to content violations.
	PromptFeedback *CloudAiNlLlmProtoServicePromptFeedback `json:"promptFeedback,omitempty"`

	// ReportingMetrics: Billable prediction metrics.
	ReportingMetrics *IntelligenceCloudAutomlXpsReportingMetrics `json:"reportingMetrics,omitempty"`

	// UsageMetadata: Usage metadata about the response(s).
	UsageMetadata *CloudAiNlLlmProtoServiceUsageMetadata `json:"usageMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Candidates") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceGenerateMultiModalResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceGenerateMultiModalResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CloudAiNlLlmProtoServiceMessageMetadata struct {
	// InputFilterInfo: Filter metadata of the input messages.
	InputFilterInfo *LearningServingLlmMessageMetadata `json:"inputFilterInfo,omitempty"`

	// ModelRoutingDecision: This score is generated by the router model to
	// decide which model to use
	ModelRoutingDecision *LearningGenaiRootRoutingDecision `json:"modelRoutingDecision,omitempty"`

	// OutputFilterInfo: Filter metadata of the output messages.
	OutputFilterInfo []*LearningServingLlmMessageMetadata `json:"outputFilterInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputFilterInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputFilterInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceMessageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceMessageMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServicePart: A single part of a message.
type CloudAiNlLlmProtoServicePart struct {
	// FileData: URI-based data.
	FileData *CloudAiNlLlmProtoServicePartFileData `json:"fileData,omitempty"`

	// FunctionCall: Function call data.
	FunctionCall *CloudAiNlLlmProtoServiceFunctionCall `json:"functionCall,omitempty"`

	// FunctionResponse: Function response data.
	FunctionResponse *CloudAiNlLlmProtoServiceFunctionResponse `json:"functionResponse,omitempty"`

	// InlineData: Inline bytes data
	InlineData *CloudAiNlLlmProtoServicePartBlob `json:"inlineData,omitempty"`

	// Text: Text input.
	Text string `json:"text,omitempty"`

	// VideoMetadata: Video metadata. The metadata should only be specified
	// while the video data is presented in inline_data or file_data.
	VideoMetadata *CloudAiNlLlmProtoServicePartVideoMetadata `json:"videoMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FileData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileData") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServicePart) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServicePart
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServicePartBlob: Represents arbitrary blob data
// input.
type CloudAiNlLlmProtoServicePartBlob struct {
	// Data: Inline data.
	Data string `json:"data,omitempty"`

	// MimeType: The mime type corresponding to this input.
	MimeType string `json:"mimeType,omitempty"`

	// OriginalFileData: Original file data where the blob comes from.
	OriginalFileData *CloudAiNlLlmProtoServicePartFileData `json:"originalFileData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServicePartBlob) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServicePartBlob
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServicePartFileData: Represents file data.
type CloudAiNlLlmProtoServicePartFileData struct {
	// FileUri: Inline data.
	FileUri string `json:"fileUri,omitempty"`

	// MimeType: The mime type corresponding to this input.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FileUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServicePartFileData) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServicePartFileData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServicePartVideoMetadata: Metadata describes the
// input video content.
type CloudAiNlLlmProtoServicePartVideoMetadata struct {
	// EndOffset: The end offset of the video.
	EndOffset string `json:"endOffset,omitempty"`

	// StartOffset: The start offset of the video.
	StartOffset string `json:"startOffset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndOffset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServicePartVideoMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServicePartVideoMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServicePromptFeedback: Content filter results for a
// prompt sent in the request.
type CloudAiNlLlmProtoServicePromptFeedback struct {
	// BlockReason: Blocked reason.
	//
	// Possible values:
	//   "BLOCKED_REASON_UNSPECIFIED" - Unspecified blocked reason.
	//   "SAFETY" - Candidates blocked due to safety.
	//   "OTHER" - Candidates blocked due to other reason.
	//   "BLOCKLIST" - Candidates blocked due to the terms which are
	// included from the terminology blocklist.
	//   "PROHIBITED_CONTENT" - Candidates blocked due to prohibited
	// content.
	BlockReason string `json:"blockReason,omitempty"`

	// BlockReasonMessage: A readable block reason message.
	BlockReasonMessage string `json:"blockReasonMessage,omitempty"`

	// SafetyRatings: Safety ratings.
	SafetyRatings []*CloudAiNlLlmProtoServiceSafetyRating `json:"safetyRatings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BlockReason") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlockReason") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServicePromptFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServicePromptFeedback
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServiceRaiResult: The RAI results for a given text.
type CloudAiNlLlmProtoServiceRaiResult struct {
	// AidaRecitationResult: Recitation result from Aida recitation checker.
	AidaRecitationResult *LanguageLabsAidaTrustRecitationProtoRecitationResult `json:"aidaRecitationResult,omitempty"`

	// Blocked: Use `triggered_blocklist`.
	Blocked bool `json:"blocked,omitempty"`

	// ErrorCodes: The error codes indicate which RAI filters block the
	// response.
	ErrorCodes []int64 `json:"errorCodes,omitempty"`

	// Filtered: Whether the text should be filtered and not shown to the
	// end user. This is determined based on a combination of
	// `triggered_recitation`, `triggered_blocklist`,
	// `language_filter_result`, and `triggered_safety_filter`.
	Filtered bool `json:"filtered,omitempty"`

	// LanguageFilterResult: Language filter result from SAFT LangId.
	LanguageFilterResult *LearningGenaiRootLanguageFilterResult `json:"languageFilterResult,omitempty"`

	// RaiSignals: The RAI signals for the text.
	RaiSignals []*CloudAiNlLlmProtoServiceRaiSignal `json:"raiSignals,omitempty"`

	// TriggeredBlocklist: Whether the text triggered the blocklist.
	TriggeredBlocklist bool `json:"triggeredBlocklist,omitempty"`

	// TriggeredRecitation: Whether the text should be blocked by the
	// recitation result from Aida recitation checker. It is determined from
	// aida_recitation_result.
	TriggeredRecitation bool `json:"triggeredRecitation,omitempty"`

	// TriggeredSafetyFilter: Whether the text triggered the safety filter.
	// Currently, this is due to CSAI triggering or one of four categories
	// (derogatory, sexual, toxic, violent) having a score over the filter
	// threshold.
	TriggeredSafetyFilter bool `json:"triggeredSafetyFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AidaRecitationResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AidaRecitationResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceRaiResult) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceRaiResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudAiNlLlmProtoServiceRaiSignal: An RAI signal for a single
// category.
type CloudAiNlLlmProtoServiceRaiSignal struct {
	// Confidence: The confidence level for the RAI category.
	//
	// Possible values:
	//   "CONFIDENCE_UNSPECIFIED"
	//   "CONFIDENCE_NONE"
	//   "CONFIDENCE_LOW"
	//   "CONFIDENCE_MEDIUM"
	//   "CONFIDENCE_HIGH"
	Confidence string `json:"confidence,omitempty"`

	// Flagged: Whether the category is flagged as being present. Currently,
	// this is set to true if score >= 0.5.
	Flagged bool `json:"flagged,omitempty"`

	// RaiCategory: The RAI category.
	//
	// Possible values:
	//   "RAI_CATEGORY_UNSPECIFIED"
	//   "TOXIC" - SafetyCat categories.
	//   "SEXUALLY_EXPLICIT"
	//   "HATE_SPEECH"
	//   "VIOLENT"
	//   "PROFANITY"
	//   "HARASSMENT"
	//   "DEATH_HARM_TRAGEDY"
	//   "FIREARMS_WEAPONS"
	//   "PUBLIC_SAFETY"
	//   "HEALTH"
	//   "RELIGIOUS_BELIEF"
	//   "ILLICIT_DRUGS"
	//   "WAR_CONFLICT"
	//   "POLITICS"
	//   "FINANCE"
	//   "LEGAL"
	//   "CSAI" - GRAIL categories that can't be exposed to end users.
	//   "FRINGE"
	//   "THREAT" - Unused categories.
	//   "SEVERE_TOXICITY"
	//   "TOXICITY" - Old category names.
	//   "SEXUAL"
	//   "INSULT"
	//   "DEROGATORY"
	//   "IDENTITY_ATTACK"
	//   "VIOLENCE_ABUSE"
	//   "OBSCENE"
	//   "DRUGS"
	//   "CSAM" - CSAM V2
	//   "SPII" - SPII
	//   "DANGEROUS_CONTENT" - New SafetyCat v3 categories
	//   "DANGEROUS_CONTENT_SEVERITY"
	//   "INSULT_SEVERITY"
	//   "DEROGATORY_SEVERITY"
	//   "SEXUAL_SEVERITY"
	RaiCategory string `json:"raiCategory,omitempty"`

	// Score: The score for the category, in the range [0.0, 1.0].
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceRaiSignal) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceRaiSignal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CloudAiNlLlmProtoServiceRaiSignal) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiNlLlmProtoServiceRaiSignal
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// CloudAiNlLlmProtoServiceSafetyRating: Safety rating corresponding to
// the generated content.
type CloudAiNlLlmProtoServiceSafetyRating struct {
	// Blocked: Indicates whether the content was filtered out because of
	// this rating.
	Blocked bool `json:"blocked,omitempty"`

	// Category: Harm category.
	//
	// Possible values:
	//   "HARM_CATEGORY_UNSPECIFIED" - The harm category is unspecified.
	//   "HARM_CATEGORY_HATE_SPEECH" - The harm category is hate speech.
	//   "HARM_CATEGORY_DANGEROUS_CONTENT" - The harm category is dengerous
	// content.
	//   "HARM_CATEGORY_HARASSMENT" - The harm category is harassment.
	//   "HARM_CATEGORY_SEXUALLY_EXPLICIT" - The harm category is sexually
	// explicit.
	Category string `json:"category,omitempty"`

	// InfluentialTerms: The influential terms that could potentially block
	// the response.
	InfluentialTerms []*CloudAiNlLlmProtoServiceSafetyRatingInfluentialTerm `json:"influentialTerms,omitempty"`

	// Probability: Harm probability levels in the content.
	//
	// Possible values:
	//   "HARM_PROBABILITY_UNSPECIFIED" - Harm probability unspecified.
	//   "NEGLIGIBLE" - Negligible level of harm.
	//   "LOW" - Low level of harm.
	//   "MEDIUM" - Medium level of harm.
	//   "HIGH" - High level of harm.
	Probability string `json:"probability,omitempty"`

	// ProbabilityScore: Harm probability score.
	ProbabilityScore float64 `json:"probabilityScore,omitempty"`

	// Severity: Harm severity levels in the content.
	//
	// Possible values:
	//   "HARM_SEVERITY_UNSPECIFIED" - Harm severity unspecified.
	//   "HARM_SEVERITY_NEGLIGIBLE" - Negligible level of harm severity.
	//   "HARM_SEVERITY_LOW" - Low level of harm severity.
	//   "HARM_SEVERITY_MEDIUM" - Medium level of harm severity.
	//   "HARM_SEVERITY_HIGH" - High level of harm severity.
	Severity string `json:"severity,omitempty"`

	// SeverityScore: Harm severity score.
	SeverityScore float64 `json:"severityScore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Blocked") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Blocked") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceSafetyRating) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceSafetyRating
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CloudAiNlLlmProtoServiceSafetyRating) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiNlLlmProtoServiceSafetyRating
	var s1 struct {
		ProbabilityScore gensupport.JSONFloat64 `json:"probabilityScore"`
		SeverityScore    gensupport.JSONFloat64 `json:"severityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ProbabilityScore = float64(s1.ProbabilityScore)
	s.SeverityScore = float64(s1.SeverityScore)
	return nil
}

// CloudAiNlLlmProtoServiceSafetyRatingInfluentialTerm: The influential
// term that could potentially block the response.
type CloudAiNlLlmProtoServiceSafetyRatingInfluentialTerm struct {
	// BeginOffset: The beginning offset of the influential term.
	BeginOffset int64 `json:"beginOffset,omitempty"`

	// Confidence: The confidence score of the influential term.
	Confidence float64 `json:"confidence,omitempty"`

	// Source: The source of the influential term, prompt or response.
	//
	// Possible values:
	//   "SOURCE_UNSPECIFIED" - Unspecified source.
	//   "PROMPT" - The influential term comes from the prompt.
	//   "RESPONSE" - The influential term comes from the response.
	Source string `json:"source,omitempty"`

	// Term: The influential term.
	Term string `json:"term,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BeginOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BeginOffset") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceSafetyRatingInfluentialTerm) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceSafetyRatingInfluentialTerm
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CloudAiNlLlmProtoServiceSafetyRatingInfluentialTerm) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiNlLlmProtoServiceSafetyRatingInfluentialTerm
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// CloudAiNlLlmProtoServiceUsageMetadata: Usage metadata about
// response(s).
type CloudAiNlLlmProtoServiceUsageMetadata struct {
	// CandidatesTokenCount: Number of tokens in the response(s).
	CandidatesTokenCount int64 `json:"candidatesTokenCount,omitempty"`

	// PromptTokenCount: Number of tokens in the request.
	PromptTokenCount int64 `json:"promptTokenCount,omitempty"`

	TotalTokenCount int64 `json:"totalTokenCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CandidatesTokenCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CandidatesTokenCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CloudAiNlLlmProtoServiceUsageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiNlLlmProtoServiceUsageMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It
// should only be used for payload formats that can't be represented as
// JSON, such as raw binary or an HTML page. This message can be used
// both in streaming and non-streaming API methods in the request as
// well as the response. It can be used as a top-level request field,
// which is convenient if one wants to extract parameters from either
// the URL or HTTP template into the request fields and also want access
// to the raw HTTP body. Example: message GetResourceRequest { // A
// unique request id. string request_id = 1; // The raw HTTP body is
// bound to this field. google.api.HttpBody http_body = 2; } service
// ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody)
// returns (google.protobuf.Empty); } Example with streaming methods:
// service CaldavService { rpc GetCalendar(stream google.api.HttpBody)
// returns (stream google.api.HttpBody); rpc UpdateCalendar(stream
// google.api.HttpBody) returns (stream google.api.HttpBody); } Use of
// this type only changes how the request and response bodies are
// handled, all other features will continue to work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the
	// content type of the body.
	ContentType string `json:"contentType,omitempty"`

	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`

	// Extensions: Application specific response metadata. Must be set in
	// the first response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ActiveLearningConfig: Parameters that
// configure the active learning pipeline. Active learning will label
// the data incrementally by several iterations. For every iteration, it
// will select a batch of data based on the sampling strategy.
type GoogleCloudAiplatformV1ActiveLearningConfig struct {
	// MaxDataItemCount: Max number of human labeled DataItems.
	MaxDataItemCount int64 `json:"maxDataItemCount,omitempty,string"`

	// MaxDataItemPercentage: Max percent of total DataItems for human
	// labeling.
	MaxDataItemPercentage int64 `json:"maxDataItemPercentage,omitempty"`

	// SampleConfig: Active learning data sampling config. For every active
	// learning labeling iteration, it will select a batch of data based on
	// the sampling strategy.
	SampleConfig *GoogleCloudAiplatformV1SampleConfig `json:"sampleConfig,omitempty"`

	// TrainingConfig: CMLE training config. For every active learning
	// labeling iteration, system will train a machine learning model on
	// CMLE. The trained model will be used by data sampling algorithm to
	// select DataItems.
	TrainingConfig *GoogleCloudAiplatformV1TrainingConfig `json:"trainingConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxDataItemCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxDataItemCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ActiveLearningConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ActiveLearningConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest:
// Request message for MetadataService.AddContextArtifactsAndExecutions.
type GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest struct {
	// Artifacts: The resource names of the Artifacts to attribute to the
	// Context. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore
	// }/artifacts/{artifact}`
	Artifacts []string `json:"artifacts,omitempty"`

	// Executions: The resource names of the Executions to associate with
	// the Context. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore
	// }/executions/{execution}`
	Executions []string `json:"executions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Artifacts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Artifacts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse:
// Response message for
// MetadataService.AddContextArtifactsAndExecutions.
type GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1AddContextChildrenRequest: Request message for
// MetadataService.AddContextChildren.
type GoogleCloudAiplatformV1AddContextChildrenRequest struct {
	// ChildContexts: The resource names of the child Contexts.
	ChildContexts []string `json:"childContexts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChildContexts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChildContexts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AddContextChildrenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AddContextChildrenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AddContextChildrenResponse: Response message
// for MetadataService.AddContextChildren.
type GoogleCloudAiplatformV1AddContextChildrenResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1AddExecutionEventsRequest: Request message for
// MetadataService.AddExecutionEvents.
type GoogleCloudAiplatformV1AddExecutionEventsRequest struct {
	// Events: The Events to create and add.
	Events []*GoogleCloudAiplatformV1Event `json:"events,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Events") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Events") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AddExecutionEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AddExecutionEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AddExecutionEventsResponse: Response message
// for MetadataService.AddExecutionEvents.
type GoogleCloudAiplatformV1AddExecutionEventsResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1AddTrialMeasurementRequest: Request message
// for VizierService.AddTrialMeasurement.
type GoogleCloudAiplatformV1AddTrialMeasurementRequest struct {
	// Measurement: Required. The measurement to be added to a Trial.
	Measurement *GoogleCloudAiplatformV1Measurement `json:"measurement,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Measurement") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Measurement") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AddTrialMeasurementRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AddTrialMeasurementRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Annotation: Used to assign specific
// AnnotationSpec to a particular area of a DataItem or the whole part
// of the DataItem.
type GoogleCloudAiplatformV1Annotation struct {
	// AnnotationSource: Output only. The source of the Annotation.
	AnnotationSource *GoogleCloudAiplatformV1UserActionReference `json:"annotationSource,omitempty"`

	// CreateTime: Output only. Timestamp when this Annotation was created.
	CreateTime string `json:"createTime,omitempty"`

	// Etag: Optional. Used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. The labels with user-defined metadata to organize
	// your Annotations. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. No more than 64 user labels can be associated with one
	// Annotation(System labels are excluded). See https://goo.gl/xmQnxf for
	// more information and examples of labels. System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	// Following system labels exist for each Annotation: *
	// "aiplatform.googleapis.com/annotation_set_name": optional, name of
	// the UI's annotation set this Annotation belongs to. If not set, the
	// Annotation is not visible in the UI. *
	// "aiplatform.googleapis.com/payload_schema": output only, its value is
	// the payload_schema's title.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. Resource name of the Annotation.
	Name string `json:"name,omitempty"`

	// Payload: Required. The schema of the payload can be found in
	// payload_schema.
	Payload interface{} `json:"payload,omitempty"`

	// PayloadSchemaUri: Required. Google Cloud Storage URI points to a YAML
	// file describing payload. The schema is defined as an OpenAPI 3.0.2
	// Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// The schema files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/annotation/, note that
	// the chosen schema must be consistent with the parent Dataset's
	// metadata.
	PayloadSchemaUri string `json:"payloadSchemaUri,omitempty"`

	// UpdateTime: Output only. Timestamp when this Annotation was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnnotationSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotationSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Annotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Annotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AnnotationSpec: Identifies a concept with
// which DataItems may be annotated with.
type GoogleCloudAiplatformV1AnnotationSpec struct {
	// CreateTime: Output only. Timestamp when this AnnotationSpec was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Required. The user-defined name of the AnnotationSpec.
	// The name can be up to 128 characters long and can consist of any
	// UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: Optional. Used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Name: Output only. Resource name of the AnnotationSpec.
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. Timestamp when AnnotationSpec was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AnnotationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AnnotationSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Artifact: Instance of a general artifact.
type GoogleCloudAiplatformV1Artifact struct {
	// CreateTime: Output only. Timestamp when this Artifact was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the Artifact
	Description string `json:"description,omitempty"`

	// DisplayName: User provided display name of the Artifact. May be up to
	// 128 Unicode characters.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: An eTag used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// Artifacts. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are
	// allowed. No more than 64 user labels can be associated with one
	// Artifact (System labels are excluded).
	Labels map[string]string `json:"labels,omitempty"`

	// Metadata: Properties of the Artifact. Top level metadata keys'
	// heading and trailing spaces will be trimmed. The size of this field
	// should not exceed 200KB.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: Output only. The resource name of the Artifact.
	Name string `json:"name,omitempty"`

	// SchemaTitle: The title of the schema describing the metadata. Schema
	// title and version is expected to be registered in earlier Create
	// Schema calls. And both are used together as unique identifiers to
	// identify schemas within the local metadata store.
	SchemaTitle string `json:"schemaTitle,omitempty"`

	// SchemaVersion: The version of the schema in schema_name to use.
	// Schema title and version is expected to be registered in earlier
	// Create Schema calls. And both are used together as unique identifiers
	// to identify schemas within the local metadata store.
	SchemaVersion string `json:"schemaVersion,omitempty"`

	// State: The state of this Artifact. This is a property of the
	// Artifact, and does not imply or capture any ongoing process. This
	// property is managed by clients (such as Vertex AI Pipelines), and the
	// system does not prescribe or check the validity of state transitions.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state for the Artifact.
	//   "PENDING" - A state used by systems like Vertex AI Pipelines to
	// indicate that the underlying data item represented by this Artifact
	// is being created.
	//   "LIVE" - A state indicating that the Artifact should exist, unless
	// something external to the system deletes it.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. Timestamp when this Artifact was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// Uri: The uniform resource identifier of the artifact file. May be
	// empty if there is no actual artifact file.
	Uri string `json:"uri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Artifact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Artifact
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AssignNotebookRuntimeOperationMetadata:
// Metadata information for NotebookService.AssignNotebookRuntime.
type GoogleCloudAiplatformV1AssignNotebookRuntimeOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ProgressMessage: A human-readable message that shows the intermediate
	// progress details of NotebookRuntime.
	ProgressMessage string `json:"progressMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AssignNotebookRuntimeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AssignNotebookRuntimeOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AssignNotebookRuntimeRequest: Request message
// for NotebookService.AssignNotebookRuntime.
type GoogleCloudAiplatformV1AssignNotebookRuntimeRequest struct {
	// NotebookRuntime: Required. Provide runtime specific information (e.g.
	// runtime owner, notebook id) used for NotebookRuntime assignment.
	NotebookRuntime *GoogleCloudAiplatformV1NotebookRuntime `json:"notebookRuntime,omitempty"`

	// NotebookRuntimeId: Optional. User specified ID for the notebook
	// runtime.
	NotebookRuntimeId string `json:"notebookRuntimeId,omitempty"`

	// NotebookRuntimeTemplate: Required. The resource name of the
	// NotebookRuntimeTemplate based on which a NotebookRuntime will be
	// assigned (reuse or create a new one).
	NotebookRuntimeTemplate string `json:"notebookRuntimeTemplate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NotebookRuntime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NotebookRuntime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AssignNotebookRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AssignNotebookRuntimeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Attribution: Attribution that explains a
// particular prediction output.
type GoogleCloudAiplatformV1Attribution struct {
	// ApproximationError: Output only. Error of feature_attributions caused
	// by approximation used in the explanation method. Lower value means
	// more precise attributions. * For Sampled Shapley attribution,
	// increasing path_count might reduce the error. * For Integrated
	// Gradients attribution, increasing step_count might reduce the error.
	// * For XRAI attribution, increasing step_count might reduce the error.
	// See this introduction (/vertex-ai/docs/explainable-ai/overview) for
	// more information.
	ApproximationError float64 `json:"approximationError,omitempty"`

	// BaselineOutputValue: Output only. Model predicted output if the input
	// instance is constructed from the baselines of all the features
	// defined in ExplanationMetadata.inputs. The field name of the output
	// is determined by the key in ExplanationMetadata.outputs. If the
	// Model's predicted output has multiple dimensions (rank > 1), this is
	// the value in the output located by output_index. If there are
	// multiple baselines, their output values are averaged.
	BaselineOutputValue float64 `json:"baselineOutputValue,omitempty"`

	// FeatureAttributions: Output only. Attributions of each explained
	// feature. Features are extracted from the prediction instances
	// according to explanation metadata for inputs. The value is a struct,
	// whose keys are the name of the feature. The values are how much the
	// feature in the instance contributed to the predicted result. The
	// format of the value is determined by the feature's input format: * If
	// the feature is a scalar value, the attribution value is a floating
	// number. * If the feature is an array of scalar values, the
	// attribution value is an array. * If the feature is a struct, the
	// attribution value is a struct. The keys in the attribution value
	// struct are the same as the keys in the feature struct. The formats of
	// the values in the attribution struct are determined by the formats of
	// the values in the feature struct. The
	// ExplanationMetadata.feature_attributions_schema_uri field, pointed to
	// by the ExplanationSpec field of the Endpoint.deployed_models object,
	// points to the schema file that describes the features and their
	// attribution values (if it is populated).
	FeatureAttributions interface{} `json:"featureAttributions,omitempty"`

	// InstanceOutputValue: Output only. Model predicted output on the
	// corresponding explanation instance. The field name of the output is
	// determined by the key in ExplanationMetadata.outputs. If the Model
	// predicted output has multiple dimensions, this is the value in the
	// output located by output_index.
	InstanceOutputValue float64 `json:"instanceOutputValue,omitempty"`

	// OutputDisplayName: Output only. The display name of the output
	// identified by output_index. For example, the predicted class name by
	// a multi-classification Model. This field is only populated iff the
	// Model predicts display names as a separate field along with the
	// explained output. The predicted display name must has the same shape
	// of the explained output, and can be located using output_index.
	OutputDisplayName string `json:"outputDisplayName,omitempty"`

	// OutputIndex: Output only. The index that locates the explained
	// prediction output. If the prediction output is a scalar value,
	// output_index is not populated. If the prediction output has multiple
	// dimensions, the length of the output_index list is the same as the
	// number of dimensions of the output. The i-th element in output_index
	// is the element index of the i-th dimension of the output vector.
	// Indices start from 0.
	OutputIndex []int64 `json:"outputIndex,omitempty"`

	// OutputName: Output only. Name of the explain output. Specified as the
	// key in ExplanationMetadata.outputs.
	OutputName string `json:"outputName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApproximationError")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApproximationError") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Attribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Attribution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1Attribution) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1Attribution
	var s1 struct {
		ApproximationError  gensupport.JSONFloat64 `json:"approximationError"`
		BaselineOutputValue gensupport.JSONFloat64 `json:"baselineOutputValue"`
		InstanceOutputValue gensupport.JSONFloat64 `json:"instanceOutputValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ApproximationError = float64(s1.ApproximationError)
	s.BaselineOutputValue = float64(s1.BaselineOutputValue)
	s.InstanceOutputValue = float64(s1.InstanceOutputValue)
	return nil
}

// GoogleCloudAiplatformV1AutomaticResources: A description of resources
// that to large degree are decided by Vertex AI, and require only a
// modest additional configuration. Each Model supporting these
// resources documents its specific guidelines.
type GoogleCloudAiplatformV1AutomaticResources struct {
	// MaxReplicaCount: Immutable. The maximum number of replicas this
	// DeployedModel may be deployed on when the traffic against it
	// increases. If the requested value is too large, the deployment will
	// error, but if deployment succeeds then the ability to scale the model
	// to that many replicas is guaranteed (barring service outages). If
	// traffic against the DeployedModel increases beyond what its replicas
	// at maximum may handle, a portion of the traffic will be dropped. If
	// this value is not provided, a no upper bound for scaling under heavy
	// traffic will be assume, though Vertex AI may be unable to scale
	// beyond certain replica number.
	MaxReplicaCount int64 `json:"maxReplicaCount,omitempty"`

	// MinReplicaCount: Immutable. The minimum number of replicas this
	// DeployedModel will be always deployed on. If traffic against it
	// increases, it may dynamically be deployed onto more replicas up to
	// max_replica_count, and as traffic decreases, some of these extra
	// replicas may be freed. If the requested value is too large, the
	// deployment will error.
	MinReplicaCount int64 `json:"minReplicaCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxReplicaCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxReplicaCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AutomaticResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AutomaticResources
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AutoscalingMetricSpec: The metric
// specification that defines the target resource utilization (CPU
// utilization, accelerator's duty cycle, and so on) for calculating the
// desired replica count.
type GoogleCloudAiplatformV1AutoscalingMetricSpec struct {
	// MetricName: Required. The resource metric name. Supported metrics: *
	// For Online Prediction: *
	// `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
	// * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
	MetricName string `json:"metricName,omitempty"`

	// Target: The target resource utilization in percentage (1% - 100%) for
	// the given metric; once the real usage deviates from the target by a
	// certain percentage, the machine replicas change. The default value is
	// 60 (representing 60%) if not provided.
	Target int64 `json:"target,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MetricName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MetricName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AutoscalingMetricSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AutoscalingMetricSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AvroSource: The storage details for Avro input
// content.
type GoogleCloudAiplatformV1AvroSource struct {
	// GcsSource: Required. Google Cloud Storage location.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1AvroSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AvroSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCancelPipelineJobsRequest: Request
// message for PipelineService.BatchCancelPipelineJobs.
type GoogleCloudAiplatformV1BatchCancelPipelineJobsRequest struct {
	// Names: Required. The names of the PipelineJobs to cancel. A maximum
	// of 32 PipelineJobs can be cancelled in a batch. Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
	Names []string `json:"names,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Names") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchCancelPipelineJobsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCancelPipelineJobsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata: Details
// of operations that perform batch create Features.
type GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Feature.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateFeaturesRequest: Request message
// for FeaturestoreService.BatchCreateFeatures.
type GoogleCloudAiplatformV1BatchCreateFeaturesRequest struct {
	// Requests: Required. The request message specifying the Features to
	// create. All Features must be created under the same parent
	// EntityType. The `parent` field in each child request message can be
	// omitted. If `parent` is set in a child request, then the value must
	// match the `parent` value in this request message.
	Requests []*GoogleCloudAiplatformV1CreateFeatureRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchCreateFeaturesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateFeaturesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateFeaturesResponse: Response message
// for FeaturestoreService.BatchCreateFeatures.
type GoogleCloudAiplatformV1BatchCreateFeaturesResponse struct {
	// Features: The Features created.
	Features []*GoogleCloudAiplatformV1Feature `json:"features,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Features") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchCreateFeaturesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateFeaturesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest: Request
// message for TensorboardService.BatchCreateTensorboardRuns.
type GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest struct {
	// Requests: Required. The request message specifying the
	// TensorboardRuns to create. A maximum of 1000 TensorboardRuns can be
	// created in a batch.
	Requests []*GoogleCloudAiplatformV1CreateTensorboardRunRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse: Response
// message for TensorboardService.BatchCreateTensorboardRuns.
type GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse struct {
	// TensorboardRuns: The created TensorboardRuns.
	TensorboardRuns []*GoogleCloudAiplatformV1TensorboardRun `json:"tensorboardRuns,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "TensorboardRuns") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TensorboardRuns") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest:
// Request message for
// TensorboardService.BatchCreateTensorboardTimeSeries.
type GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest struct {
	// Requests: Required. The request message specifying the
	// TensorboardTimeSeries to create. A maximum of 1000
	// TensorboardTimeSeries can be created in a batch.
	Requests []*GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse:
// Response message for
// TensorboardService.BatchCreateTensorboardTimeSeries.
type GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse struct {
	// TensorboardTimeSeries: The created TensorboardTimeSeries.
	TensorboardTimeSeries []*GoogleCloudAiplatformV1TensorboardTimeSeries `json:"tensorboardTimeSeries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "TensorboardTimeSeries") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TensorboardTimeSeries") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchDedicatedResources: A description of
// resources that are used for performing batch operations, are
// dedicated to a Model, and need manual configuration.
type GoogleCloudAiplatformV1BatchDedicatedResources struct {
	// MachineSpec: Required. Immutable. The specification of a single
	// machine.
	MachineSpec *GoogleCloudAiplatformV1MachineSpec `json:"machineSpec,omitempty"`

	// MaxReplicaCount: Immutable. The maximum number of machine replicas
	// the batch operation may be scaled to. The default value is 10.
	MaxReplicaCount int64 `json:"maxReplicaCount,omitempty"`

	// StartingReplicaCount: Immutable. The number of machine replicas used
	// at the start of the batch operation. If not set, Vertex AI decides
	// starting number, not greater than max_replica_count
	StartingReplicaCount int64 `json:"startingReplicaCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MachineSpec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MachineSpec") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchDedicatedResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchDedicatedResources
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchDeletePipelineJobsRequest: Request
// message for PipelineService.BatchDeletePipelineJobs.
type GoogleCloudAiplatformV1BatchDeletePipelineJobsRequest struct {
	// Names: Required. The names of the PipelineJobs to delete. A maximum
	// of 32 PipelineJobs can be deleted in a batch. Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
	Names []string `json:"names,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Names") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchDeletePipelineJobsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchDeletePipelineJobsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest:
// Request message for ModelService.BatchImportEvaluatedAnnotations
type GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest struct {
	// EvaluatedAnnotations: Required. Evaluated annotations resource to be
	// imported.
	EvaluatedAnnotations []*GoogleCloudAiplatformV1EvaluatedAnnotation `json:"evaluatedAnnotations,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EvaluatedAnnotations") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EvaluatedAnnotations") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse:
// Response message for ModelService.BatchImportEvaluatedAnnotations
type GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse struct {
	// ImportedEvaluatedAnnotationsCount: Output only. Number of
	// EvaluatedAnnotations imported.
	ImportedEvaluatedAnnotationsCount int64 `json:"importedEvaluatedAnnotationsCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ImportedEvaluatedAnnotationsCount") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ImportedEvaluatedAnnotationsCount") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest:
// Request message for ModelService.BatchImportModelEvaluationSlices
type GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest struct {
	// ModelEvaluationSlices: Required. Model evaluation slice resource to
	// be imported.
	ModelEvaluationSlices []*GoogleCloudAiplatformV1ModelEvaluationSlice `json:"modelEvaluationSlices,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ModelEvaluationSlices") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ModelEvaluationSlices") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse:
// Response message for ModelService.BatchImportModelEvaluationSlices
type GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse struct {
	// ImportedModelEvaluationSlices: Output only. List of imported
	// ModelEvaluationSlice.name.
	ImportedModelEvaluationSlices []string `json:"importedModelEvaluationSlices,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ImportedModelEvaluationSlices") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ImportedModelEvaluationSlices") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata:
// Runtime operation information for
// MigrationService.BatchMigrateResources.
type GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// PartialResults: Partial results that reflect the latest migration
	// operation progress.
	PartialResults []*GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult `json:"partialResults,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialRe
// sult: Represents a partial result in batch migration operation for
// one MigrateResourceRequest.
type GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult struct {
	// Dataset: Migrated dataset resource name.
	Dataset string `json:"dataset,omitempty"`

	// Error: The error result of the migration request in case of failure.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Model: Migrated model resource name.
	Model string `json:"model,omitempty"`

	// Request: It's the same as the value in
	// MigrateResourceRequest.migrate_resource_requests.
	Request *GoogleCloudAiplatformV1MigrateResourceRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dataset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchMigrateResourcesRequest: Request message
// for MigrationService.BatchMigrateResources.
type GoogleCloudAiplatformV1BatchMigrateResourcesRequest struct {
	// MigrateResourceRequests: Required. The request messages specifying
	// the resources to migrate. They must be in the same location as the
	// destination. Up to 50 resources can be migrated in one batch.
	MigrateResourceRequests []*GoogleCloudAiplatformV1MigrateResourceRequest `json:"migrateResourceRequests,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MigrateResourceRequests") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MigrateResourceRequests")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchMigrateResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchMigrateResourcesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchMigrateResourcesResponse: Response
// message for MigrationService.BatchMigrateResources.
type GoogleCloudAiplatformV1BatchMigrateResourcesResponse struct {
	// MigrateResourceResponses: Successfully migrated resources.
	MigrateResourceResponses []*GoogleCloudAiplatformV1MigrateResourceResponse `json:"migrateResourceResponses,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MigrateResourceResponses") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MigrateResourceResponses")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchMigrateResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchMigrateResourcesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJob: A job that uses a Model to
// produce predictions on multiple input instances. If predictions for
// significant portion of the instances fail, the job may finish without
// attempting predictions for all remaining instances.
type GoogleCloudAiplatformV1BatchPredictionJob struct {
	// CompletionStats: Output only. Statistics on completed and failed
	// prediction instances.
	CompletionStats *GoogleCloudAiplatformV1CompletionStats `json:"completionStats,omitempty"`

	// CreateTime: Output only. Time when the BatchPredictionJob was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DedicatedResources: The config of resources used by the Model during
	// the batch prediction. If the Model supports DEDICATED_RESOURCES this
	// config may be provided (and the job will use these resources), if the
	// Model doesn't support AUTOMATIC_RESOURCES, this config must be
	// provided.
	DedicatedResources *GoogleCloudAiplatformV1BatchDedicatedResources `json:"dedicatedResources,omitempty"`

	// DisableContainerLogging: For custom-trained Models and AutoML Tabular
	// Models, the container of the DeployedModel instances will send
	// `stderr` and `stdout` streams to Cloud Logging by default. Please
	// note that the logs incur cost, which are subject to Cloud Logging
	// pricing (https://cloud.google.com/logging/pricing). User can disable
	// container logging by setting this flag to true.
	DisableContainerLogging bool `json:"disableContainerLogging,omitempty"`

	// DisplayName: Required. The user-defined name of this
	// BatchPredictionJob.
	DisplayName string `json:"displayName,omitempty"`

	// EncryptionSpec: Customer-managed encryption key options for a
	// BatchPredictionJob. If this is set, then all resources created by the
	// BatchPredictionJob will be encrypted with the provided encryption
	// key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// EndTime: Output only. Time when the BatchPredictionJob entered any of
	// the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
	// `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`

	// Error: Output only. Only populated when the job's state is
	// JOB_STATE_FAILED or JOB_STATE_CANCELLED.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// ExplanationSpec: Explanation configuration for this
	// BatchPredictionJob. Can be specified only if generate_explanation is
	// set to `true`. This value overrides the value of
	// Model.explanation_spec. All fields of explanation_spec are optional
	// in the request. If a field of the explanation_spec object is not
	// populated, the corresponding field of the Model.explanation_spec
	// object is inherited.
	ExplanationSpec *GoogleCloudAiplatformV1ExplanationSpec `json:"explanationSpec,omitempty"`

	// GenerateExplanation: Generate explanation with the batch prediction
	// results. When set to `true`, the batch prediction output changes
	// based on the `predictions_format` field of the
	// BatchPredictionJob.output_config object: * `bigquery`: output
	// includes a column named `explanation`. The value is a struct that
	// conforms to the Explanation object. * `jsonl`: The JSON objects on
	// each line include an additional entry keyed `explanation`. The value
	// of the entry is a JSON object that conforms to the Explanation
	// object. * `csv`: Generating explanations for CSV format is not
	// supported. If this field is set to true, either the
	// Model.explanation_spec or explanation_spec must be populated.
	GenerateExplanation bool `json:"generateExplanation,omitempty"`

	// InputConfig: Required. Input configuration of the instances on which
	// predictions are performed. The schema of any single instance may be
	// specified via the Model's PredictSchemata's instance_schema_uri.
	InputConfig *GoogleCloudAiplatformV1BatchPredictionJobInputConfig `json:"inputConfig,omitempty"`

	// InstanceConfig: Configuration for how to convert batch prediction
	// input instances to the prediction instances that are sent to the
	// Model.
	InstanceConfig *GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig `json:"instanceConfig,omitempty"`

	// Labels: The labels with user-defined metadata to organize
	// BatchPredictionJobs. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. See https://goo.gl/xmQnxf for more information and
	// examples of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// ManualBatchTuningParameters: Immutable. Parameters configuring the
	// batch behavior. Currently only applicable when dedicated_resources
	// are used (in other cases Vertex AI does the tuning itself).
	ManualBatchTuningParameters *GoogleCloudAiplatformV1ManualBatchTuningParameters `json:"manualBatchTuningParameters,omitempty"`

	// Model: The name of the Model resource that produces the predictions
	// via this job, must share the same ancestor Location. Starting this
	// job has no impact on any existing deployments of the Model and their
	// resources. Exactly one of model and unmanaged_container_model must be
	// set. The model resource name may contain version id or version alias
	// to specify the version. Example:
	// `projects/{project}/locations/{location}/models/{model}@2` or
	// `projects/{project}/locations/{location}/models/{model}@golden` if no
	// version is specified, the default version will be deployed. The model
	// resource could also be a publisher model. Example:
	// `publishers/{publisher}/models/{model}` or
	// `projects/{project}/locations/{location}/publishers/{publisher}/models
	// /{model}`
	Model string `json:"model,omitempty"`

	// ModelParameters: The parameters that govern the predictions. The
	// schema of the parameters may be specified via the Model's
	// PredictSchemata's parameters_schema_uri.
	ModelParameters interface{} `json:"modelParameters,omitempty"`

	// ModelVersionId: Output only. The version ID of the Model that
	// produces the predictions via this job.
	ModelVersionId string `json:"modelVersionId,omitempty"`

	// Name: Output only. Resource name of the BatchPredictionJob.
	Name string `json:"name,omitempty"`

	// OutputConfig: Required. The Configuration specifying where output
	// predictions should be written. The schema of any single prediction
	// may be specified as a concatenation of Model's PredictSchemata's
	// instance_schema_uri and prediction_schema_uri.
	OutputConfig *GoogleCloudAiplatformV1BatchPredictionJobOutputConfig `json:"outputConfig,omitempty"`

	// OutputInfo: Output only. Information further describing the output of
	// this job.
	OutputInfo *GoogleCloudAiplatformV1BatchPredictionJobOutputInfo `json:"outputInfo,omitempty"`

	// PartialFailures: Output only. Partial failures encountered. For
	// example, single files that can't be read. This field never exceeds 20
	// entries. Status details fields contain standard Google Cloud error
	// details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`

	// ResourcesConsumed: Output only. Information about resources that had
	// been consumed by this job. Provided in real time at best effort
	// basis, as well as a final value once the job completes. Note: This
	// field currently may be not populated for batch predictions that use
	// AutoML Models.
	ResourcesConsumed *GoogleCloudAiplatformV1ResourcesConsumed `json:"resourcesConsumed,omitempty"`

	// ServiceAccount: The service account that the DeployedModel's
	// container runs as. If not specified, a system generated one will be
	// used, which has minimal permissions and the custom container, if
	// used, may not have enough permission to access other Google Cloud
	// resources. Users deploying the Model must have the
	// `iam.serviceAccounts.actAs` permission on this service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// StartTime: Output only. Time when the BatchPredictionJob for the
	// first time entered the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this
	// state the job may only go to either `JOB_STATE_SUCCEEDED`,
	// `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to
	// the `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded,
	// some results may be missing due to errors.
	State string `json:"state,omitempty"`

	// UnmanagedContainerModel: Contains model information necessary to
	// perform batch prediction without requiring uploading to model
	// registry. Exactly one of model and unmanaged_container_model must be
	// set.
	UnmanagedContainerModel *GoogleCloudAiplatformV1UnmanagedContainerModel `json:"unmanagedContainerModel,omitempty"`

	// UpdateTime: Output only. Time when the BatchPredictionJob was most
	// recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CompletionStats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompletionStats") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchPredictionJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJob
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJobInputConfig: Configures the
// input to BatchPredictionJob. See
// Model.supported_input_storage_formats for Model's supported input
// formats, and how instances should be expressed via any of them.
type GoogleCloudAiplatformV1BatchPredictionJobInputConfig struct {
	// BigquerySource: The BigQuery location of the input table. The schema
	// of the table should be in the format described by the given context
	// OpenAPI Schema, if one is provided. The table may contain additional
	// columns that are not described by the schema, and they will be
	// ignored.
	BigquerySource *GoogleCloudAiplatformV1BigQuerySource `json:"bigquerySource,omitempty"`

	// GcsSource: The Cloud Storage location for the input instances.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`

	// InstancesFormat: Required. The format in which instances are given,
	// must be one of the Model's supported_input_storage_formats.
	InstancesFormat string `json:"instancesFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigquerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchPredictionJobInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJobInputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig:
// Configuration defining how to transform batch prediction input
// instances to the instances that the Model accepts.
type GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig struct {
	// ExcludedFields: Fields that will be excluded in the prediction
	// instance that is sent to the Model. Excluded will be attached to the
	// batch prediction output if key_field is not specified. When
	// excluded_fields is populated, included_fields must be empty. The
	// input must be JSONL with objects at each line, BigQuery or TfRecord.
	ExcludedFields []string `json:"excludedFields,omitempty"`

	// IncludedFields: Fields that will be included in the prediction
	// instance that is sent to the Model. If instance_type is `array`, the
	// order of field names in included_fields also determines the order of
	// the values in the array. When included_fields is populated,
	// excluded_fields must be empty. The input must be JSONL with objects
	// at each line, BigQuery or TfRecord.
	IncludedFields []string `json:"includedFields,omitempty"`

	// InstanceType: The format of the instance that the Model accepts.
	// Vertex AI will convert compatible batch prediction input instance
	// formats to the specified format. Supported values are: * `object`:
	// Each input is converted to JSON object format. * For `bigquery`, each
	// row is converted to an object. * For `jsonl`, each line of the JSONL
	// input must be an object. * Does not apply to `csv`, `file-list`,
	// `tf-record`, or `tf-record-gzip`. * `array`: Each input is converted
	// to JSON array format. * For `bigquery`, each row is converted to an
	// array. The order of columns is determined by the BigQuery column
	// order, unless included_fields is populated. included_fields must be
	// populated for specifying field orders. * For `jsonl`, if each line of
	// the JSONL input is an object, included_fields must be populated for
	// specifying field orders. * Does not apply to `csv`, `file-list`,
	// `tf-record`, or `tf-record-gzip`. If not specified, Vertex AI
	// converts the batch prediction input as follows: * For `bigquery` and
	// `csv`, the behavior is the same as `array`. The order of columns is
	// the same as defined in the file or table, unless included_fields is
	// populated. * For `jsonl`, the prediction instance format is
	// determined by each line of the input. * For
	// `tf-record`/`tf-record-gzip`, each record will be converted to an
	// object in the format of `{"b64": }`, where `` is the Base64-encoded
	// string of the content of the record. * For `file-list`, each file in
	// the list will be converted to an object in the format of `{"b64": }`,
	// where `` is the Base64-encoded string of the content of the file.
	InstanceType string `json:"instanceType,omitempty"`

	// KeyField: The name of the field that is considered as a key. The
	// values identified by the key field is not included in the transformed
	// instances that is sent to the Model. This is similar to specifying
	// this name of the field in excluded_fields. In addition, the batch
	// prediction output will not include the instances. Instead the output
	// will only include the value of the key field, in a field named `key`
	// in the output: * For `jsonl` output format, the output will have a
	// `key` field instead of the `instance` field. * For `csv`/`bigquery`
	// output format, the output will have have a `key` column instead of
	// the instance feature columns. The input must be JSONL with objects at
	// each line, CSV, BigQuery or TfRecord.
	KeyField string `json:"keyField,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExcludedFields") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExcludedFields") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJobOutputConfig: Configures the
// output of BatchPredictionJob. See
// Model.supported_output_storage_formats for supported output formats,
// and how predictions are expressed via any of them.
type GoogleCloudAiplatformV1BatchPredictionJobOutputConfig struct {
	// BigqueryDestination: The BigQuery project or dataset location where
	// the output is to be written to. If project is provided, a new dataset
	// is created with name `prediction__` where is made
	// BigQuery-dataset-name compatible (for example, most special
	// characters become underscores), and timestamp is in
	// YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
	// two tables will be created, `predictions`, and `errors`. If the Model
	// has both instance and prediction schemata defined then the tables
	// have columns as follows: The `predictions` table contains instances
	// for which the prediction succeeded, it has columns as per a
	// concatenation of the Model's instance and prediction schemata. The
	// `errors` table contains rows for which the prediction has failed, it
	// has instance columns, as per the instance schema, followed by a
	// single "errors" column, which as values has google.rpc.Status
	// represented as a STRUCT, and containing only `code` and `message`.
	BigqueryDestination *GoogleCloudAiplatformV1BigQueryDestination `json:"bigqueryDestination,omitempty"`

	// GcsDestination: The Cloud Storage location of the directory where the
	// output is to be written to. In the given directory a new directory is
	// created. Its name is `prediction--`, where timestamp is in
	// YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. Inside of it files
	// `predictions_0001.`, `predictions_0002.`, ..., `predictions_N.` are
	// created where `` depends on chosen predictions_format, and N may
	// equal 0001 and depends on the total number of successfully predicted
	// instances. If the Model has both instance and prediction schemata
	// defined then each such file contains predictions as per the
	// predictions_format. If prediction for any instance failed (partially
	// or completely), then an additional `errors_0001.`,
	// `errors_0002.`,..., `errors_N.` files are created (N depends on total
	// number of failed predictions). These files contain the failed
	// instances, as per their schema, followed by an additional `error`
	// field which as value has google.rpc.Status containing only `code` and
	// `message` fields.
	GcsDestination *GoogleCloudAiplatformV1GcsDestination `json:"gcsDestination,omitempty"`

	// PredictionsFormat: Required. The format in which Vertex AI gives the
	// predictions, must be one of the Model's
	// supported_output_storage_formats.
	PredictionsFormat string `json:"predictionsFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigqueryDestination")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchPredictionJobOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJobOutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJobOutputInfo: Further
// describes this job's output. Supplements output_config.
type GoogleCloudAiplatformV1BatchPredictionJobOutputInfo struct {
	// BigqueryOutputDataset: Output only. The path of the BigQuery dataset
	// created, in `bq://projectId.bqDatasetId` format, into which the
	// prediction output is written.
	BigqueryOutputDataset string `json:"bigqueryOutputDataset,omitempty"`

	// BigqueryOutputTable: Output only. The name of the BigQuery table
	// created, in `predictions_` format, into which the prediction output
	// is written. Can be used by UI to generate the BigQuery output path,
	// for example.
	BigqueryOutputTable string `json:"bigqueryOutputTable,omitempty"`

	// GcsOutputDirectory: Output only. The full path of the Cloud Storage
	// directory created, into which the prediction output is written.
	GcsOutputDirectory string `json:"gcsOutputDirectory,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BigqueryOutputDataset") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryOutputDataset") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchPredictionJobOutputInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJobOutputInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata:
// Details of operations that batch reads Feature values.
type GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore batch read
	// Features values.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesRequest: Request message
// for FeaturestoreService.BatchReadFeatureValues.
type GoogleCloudAiplatformV1BatchReadFeatureValuesRequest struct {
	// BigqueryReadInstances: Similar to csv_read_instances, but from
	// BigQuery source.
	BigqueryReadInstances *GoogleCloudAiplatformV1BigQuerySource `json:"bigqueryReadInstances,omitempty"`

	// CsvReadInstances: Each read instance consists of exactly one read
	// timestamp and one or more entity IDs identifying entities of the
	// corresponding EntityTypes whose Features are requested. Each output
	// instance contains Feature values of requested entities concatenated
	// together as of the read time. An example read instance may be
	// `foo_entity_id, bar_entity_id, 2020-01-01T10:00:00.123Z`. An example
	// output instance may be `foo_entity_id, bar_entity_id,
	// 2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
	// bar_entity_feature2_value`. Timestamp in each read instance must be
	// millisecond-aligned. `csv_read_instances` are read instances stored
	// in a plain-text CSV file. The header should be: [ENTITY_TYPE_ID1],
	// [ENTITY_TYPE_ID2], ..., timestamp The columns can be in any order.
	// Values in the timestamp column must use the RFC 3339 format, e.g.
	// `2012-07-30T10:43:17.123Z`.
	CsvReadInstances *GoogleCloudAiplatformV1CsvSource `json:"csvReadInstances,omitempty"`

	// Destination: Required. Specifies output location and format.
	Destination *GoogleCloudAiplatformV1FeatureValueDestination `json:"destination,omitempty"`

	// EntityTypeSpecs: Required. Specifies EntityType grouping Features to
	// read values of and settings.
	EntityTypeSpecs []*GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec `json:"entityTypeSpecs,omitempty"`

	// PassThroughFields: When not empty, the specified fields in the
	// *_read_instances source will be joined as-is in the output, in
	// addition to those fields from the Featurestore Entity. For BigQuery
	// source, the type of the pass-through values will be automatically
	// inferred. For CSV source, the pass-through values will be passed as
	// opaque bytes.
	PassThroughFields []*GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField `json:"passThroughFields,omitempty"`

	// StartTime: Optional. Excludes Feature values with feature generation
	// timestamp before this timestamp. If not set, retrieve oldest values
	// kept in Feature Store. Timestamp, if present, must not have higher
	// than millisecond precision.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BigqueryReadInstances") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryReadInstances") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchReadFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadFeatureValuesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec:
// Selects Features of an EntityType to read values of and specifies
// read settings.
type GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec struct {
	// EntityTypeId: Required. ID of the EntityType to select Features. The
	// EntityType id is the entity_type_id specified during EntityType
	// creation.
	EntityTypeId string `json:"entityTypeId,omitempty"`

	// FeatureSelector: Required. Selectors choosing which Feature values to
	// read from the EntityType.
	FeatureSelector *GoogleCloudAiplatformV1FeatureSelector `json:"featureSelector,omitempty"`

	// Settings: Per-Feature settings for the batch read.
	Settings []*GoogleCloudAiplatformV1DestinationFeatureSetting `json:"settings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityTypeId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityTypeId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField:
// Describe pass-through fields in read_instance source.
type GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField struct {
	// FieldName: Required. The name of the field in the CSV header or the
	// name of the column in BigQuery table. The naming restriction is the
	// same as Feature.name.
	FieldName string `json:"fieldName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesResponse: Response
// message for FeaturestoreService.BatchReadFeatureValues.
type GoogleCloudAiplatformV1BatchReadFeatureValuesResponse struct {
}

// GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse:
// Response message for
// TensorboardService.BatchReadTensorboardTimeSeriesData.
type GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse struct {
	// TimeSeriesData: The returned time series data.
	TimeSeriesData []*GoogleCloudAiplatformV1TimeSeriesData `json:"timeSeriesData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "TimeSeriesData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TimeSeriesData") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BigQueryDestination: The BigQuery location for
// the output content.
type GoogleCloudAiplatformV1BigQueryDestination struct {
	// OutputUri: Required. BigQuery URI to a project or table, up to 2000
	// characters long. When only the project is specified, the Dataset and
	// Table is created. When the full table reference is specified, the
	// Dataset must exist and table must not exist. Accepted forms: *
	// BigQuery path. For example: `bq://projectId` or
	// `bq://projectId.bqDatasetId` or
	// `bq://projectId.bqDatasetId.bqTableId`.
	OutputUri string `json:"outputUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OutputUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BigQueryDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BigQuerySource: The BigQuery location for the
// input content.
type GoogleCloudAiplatformV1BigQuerySource struct {
	// InputUri: Required. BigQuery URI to a table, up to 2000 characters
	// long. Accepted forms: * BigQuery path. For example:
	// `bq://projectId.bqDatasetId.bqTableId`.
	InputUri string `json:"inputUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BigQuerySource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Blob: Raw media bytes. Text should not be sent
// as raw bytes, use the 'text' field.
type GoogleCloudAiplatformV1Blob struct {
	// Data: Required. Raw bytes for media formats.
	Data string `json:"data,omitempty"`

	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Blob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Blob
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BlurBaselineConfig: Config for blur baseline.
// When enabled, a linear path from the maximally blurred image to the
// input image is created. Using a blurred baseline instead of zero
// (black image) is motivated by the BlurIG approach explained here:
// https://arxiv.org/abs/2004.03383
type GoogleCloudAiplatformV1BlurBaselineConfig struct {
	// MaxBlurSigma: The standard deviation of the blur kernel for the
	// blurred baseline. The same blurring parameter is used for both the
	// height and the width dimension. If not set, the method defaults to
	// the zero (i.e. black for images) baseline.
	MaxBlurSigma float64 `json:"maxBlurSigma,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxBlurSigma") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxBlurSigma") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BlurBaselineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BlurBaselineConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1BlurBaselineConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1BlurBaselineConfig
	var s1 struct {
		MaxBlurSigma gensupport.JSONFloat64 `json:"maxBlurSigma"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxBlurSigma = float64(s1.MaxBlurSigma)
	return nil
}

// GoogleCloudAiplatformV1BoolArray: A list of boolean values.
type GoogleCloudAiplatformV1BoolArray struct {
	// Values: A list of bool values.
	Values []bool `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1BoolArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BoolArray
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CancelBatchPredictionJobRequest: Request
// message for JobService.CancelBatchPredictionJob.
type GoogleCloudAiplatformV1CancelBatchPredictionJobRequest struct {
}

// GoogleCloudAiplatformV1CancelCustomJobRequest: Request message for
// JobService.CancelCustomJob.
type GoogleCloudAiplatformV1CancelCustomJobRequest struct {
}

// GoogleCloudAiplatformV1CancelDataLabelingJobRequest: Request message
// for JobService.CancelDataLabelingJob.
type GoogleCloudAiplatformV1CancelDataLabelingJobRequest struct {
}

// GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest: Request
// message for JobService.CancelHyperparameterTuningJob.
type GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest struct {
}

// GoogleCloudAiplatformV1CancelNasJobRequest: Request message for
// JobService.CancelNasJob.
type GoogleCloudAiplatformV1CancelNasJobRequest struct {
}

// GoogleCloudAiplatformV1CancelPipelineJobRequest: Request message for
// PipelineService.CancelPipelineJob.
type GoogleCloudAiplatformV1CancelPipelineJobRequest struct {
}

// GoogleCloudAiplatformV1CancelTrainingPipelineRequest: Request message
// for PipelineService.CancelTrainingPipeline.
type GoogleCloudAiplatformV1CancelTrainingPipelineRequest struct {
}

// GoogleCloudAiplatformV1Candidate: A response candidate generated from
// the model.
type GoogleCloudAiplatformV1Candidate struct {
	// CitationMetadata: Output only. Source attribution of the generated
	// content.
	CitationMetadata *GoogleCloudAiplatformV1CitationMetadata `json:"citationMetadata,omitempty"`

	// Content: Output only. Content parts of the candidate.
	Content *GoogleCloudAiplatformV1Content `json:"content,omitempty"`

	// FinishMessage: Output only. Describes the reason the mode stopped
	// generating tokens in more detail. This is only filled when
	// `finish_reason` is set.
	FinishMessage string `json:"finishMessage,omitempty"`

	// FinishReason: Output only. The reason why the model stopped
	// generating tokens. If empty, the model has not stopped generating the
	// tokens.
	//
	// Possible values:
	//   "FINISH_REASON_UNSPECIFIED" - The finish reason is unspecified.
	//   "STOP" - Natural stop point of the model or provided stop sequence.
	//   "MAX_TOKENS" - The maximum number of tokens as specified in the
	// request was reached.
	//   "SAFETY" - The token generation was stopped as the response was
	// flagged for safety reasons. NOTE: When streaming the
	// Candidate.content will be empty if content filters blocked the
	// output.
	//   "RECITATION" - The token generation was stopped as the response was
	// flagged for unauthorized citations.
	//   "OTHER" - All other reasons that stopped the token generation
	FinishReason string `json:"finishReason,omitempty"`

	// GroundingMetadata: Output only. Metadata specifies sources used to
	// ground generated content.
	GroundingMetadata *GoogleCloudAiplatformV1GroundingMetadata `json:"groundingMetadata,omitempty"`

	// Index: Output only. Index of the candidate.
	Index int64 `json:"index,omitempty"`

	// SafetyRatings: Output only. List of ratings for the safety of a
	// response candidate. There is at most one rating per category.
	SafetyRatings []*GoogleCloudAiplatformV1SafetyRating `json:"safetyRatings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CitationMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CitationMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Candidate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Candidate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata: This
// message will be placed in the metadata field of a
// google.longrunning.Operation associated with a
// CheckTrialEarlyStoppingState request.
type GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata struct {
	// GenericMetadata: Operation metadata for suggesting Trials.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// Study: The name of the Study that the Trial belongs to.
	Study string `json:"study,omitempty"`

	// Trial: The Trial name.
	Trial string `json:"trial,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest: Request
// message for VizierService.CheckTrialEarlyStoppingState.
type GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest struct {
}

// GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse: Response
// message for VizierService.CheckTrialEarlyStoppingState.
type GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse struct {
	// ShouldStop: True if the Trial should stop.
	ShouldStop bool `json:"shouldStop,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ShouldStop") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ShouldStop") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Citation: Source attributions for content.
type GoogleCloudAiplatformV1Citation struct {
	// EndIndex: Output only. End index into the content.
	EndIndex int64 `json:"endIndex,omitempty"`

	// License: Output only. License of the attribution.
	License string `json:"license,omitempty"`

	// PublicationDate: Output only. Publication date of the attribution.
	PublicationDate *GoogleTypeDate `json:"publicationDate,omitempty"`

	// StartIndex: Output only. Start index into the content.
	StartIndex int64 `json:"startIndex,omitempty"`

	// Title: Output only. Title of the attribution.
	Title string `json:"title,omitempty"`

	// Uri: Output only. Url reference of the attribution.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndIndex") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Citation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Citation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CitationMetadata: A collection of source
// attributions for a piece of content.
type GoogleCloudAiplatformV1CitationMetadata struct {
	// Citations: Output only. List of citations.
	Citations []*GoogleCloudAiplatformV1Citation `json:"citations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Citations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CitationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CompleteTrialRequest: Request message for
// VizierService.CompleteTrial.
type GoogleCloudAiplatformV1CompleteTrialRequest struct {
	// FinalMeasurement: Optional. If provided, it will be used as the
	// completed Trial's final_measurement; Otherwise, the service will
	// auto-select a previously reported measurement as the
	// final-measurement
	FinalMeasurement *GoogleCloudAiplatformV1Measurement `json:"finalMeasurement,omitempty"`

	// InfeasibleReason: Optional. A human readable reason why the trial was
	// infeasible. This should only be provided if `trial_infeasible` is
	// true.
	InfeasibleReason string `json:"infeasibleReason,omitempty"`

	// TrialInfeasible: Optional. True if the Trial cannot be run with the
	// given Parameter, and final_measurement will be ignored.
	TrialInfeasible bool `json:"trialInfeasible,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinalMeasurement") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinalMeasurement") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CompleteTrialRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CompleteTrialRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CompletionStats: Success and error statistics
// of processing multiple entities (for example, DataItems or structured
// data rows) in batch.
type GoogleCloudAiplatformV1CompletionStats struct {
	// FailedCount: Output only. The number of entities for which any error
	// was encountered.
	FailedCount int64 `json:"failedCount,omitempty,string"`

	// IncompleteCount: Output only. In cases when enough errors are
	// encountered a job, pipeline, or operation may be failed as a whole.
	// Below is the number of entities for which the processing had not been
	// finished (either in successful or failed state). Set to -1 if the
	// number is unknown (for example, the operation failed before the total
	// entity number could be collected).
	IncompleteCount int64 `json:"incompleteCount,omitempty,string"`

	// SuccessfulCount: Output only. The number of entities that had been
	// processed successfully.
	SuccessfulCount int64 `json:"successfulCount,omitempty,string"`

	// SuccessfulForecastPointCount: Output only. The number of the
	// successful forecast points that are generated by the forecasting
	// model. This is ONLY used by the forecasting batch prediction.
	SuccessfulForecastPointCount int64 `json:"successfulForecastPointCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "FailedCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FailedCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CompletionStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CompletionStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ComputeTokensRequest: Request message for
// ComputeTokens RPC call.
type GoogleCloudAiplatformV1ComputeTokensRequest struct {
	// Instances: Required. The instances that are the input to token
	// computing API call. Schema is identical to the prediction schema of
	// the text model, even for the non-text models, like chat models, or
	// Codey models.
	Instances []interface{} `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ComputeTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ComputeTokensRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ComputeTokensResponse: Response message for
// ComputeTokens RPC call.
type GoogleCloudAiplatformV1ComputeTokensResponse struct {
	// TokensInfo: Lists of tokens info from the input. A
	// ComputeTokensRequest could have multiple instances with a prompt in
	// each instance. We also need to return lists of tokens info for the
	// request with multiple instances.
	TokensInfo []*GoogleCloudAiplatformV1TokensInfo `json:"tokensInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "TokensInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TokensInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ComputeTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ComputeTokensResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ContainerRegistryDestination: The Container
// Registry location for the container image.
type GoogleCloudAiplatformV1ContainerRegistryDestination struct {
	// OutputUri: Required. Container Registry URI of a container image.
	// Only Google Container Registry and Artifact Registry are supported
	// now. Accepted forms: * Google Container Registry path. For example:
	// `gcr.io/projectId/imageName:tag`. * Artifact Registry path. For
	// example:
	// `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`. If a
	// tag is not specified, "latest" will be used as the default tag.
	OutputUri string `json:"outputUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OutputUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ContainerRegistryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ContainerRegistryDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ContainerSpec: The spec of a Container.
type GoogleCloudAiplatformV1ContainerSpec struct {
	// Args: The arguments to be passed when starting the container.
	Args []string `json:"args,omitempty"`

	// Command: The command to be invoked when the container is started. It
	// overrides the entrypoint instruction in Dockerfile when provided.
	Command []string `json:"command,omitempty"`

	// Env: Environment variables to be passed to the container. Maximum
	// limit is 100.
	Env []*GoogleCloudAiplatformV1EnvVar `json:"env,omitempty"`

	// ImageUri: Required. The URI of a container image in the Container
	// Registry that is to be run on each worker replica.
	ImageUri string `json:"imageUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ContainerSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ContainerSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Content: The base structured datatype
// containing multi-part content of a message. A `Content` includes a
// `role` field designating the producer of the `Content` and a `parts`
// field containing multi-part data that contains the content of the
// message turn.
type GoogleCloudAiplatformV1Content struct {
	// Parts: Required. Ordered `Parts` that constitute a single message.
	// Parts may have different IANA MIME types.
	Parts []*GoogleCloudAiplatformV1Part `json:"parts,omitempty"`

	// Role: Optional. The producer of the content. Must be either 'user' or
	// 'model'. Useful to set for multi-turn conversations, otherwise can be
	// left blank or unset.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parts") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Content) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Content
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Context: Instance of a general context.
type GoogleCloudAiplatformV1Context struct {
	// CreateTime: Output only. Timestamp when this Context was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the Context
	Description string `json:"description,omitempty"`

	// DisplayName: User provided display name of the Context. May be up to
	// 128 Unicode characters.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: An eTag used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// Contexts. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are
	// allowed. No more than 64 user labels can be associated with one
	// Context (System labels are excluded).
	Labels map[string]string `json:"labels,omitempty"`

	// Metadata: Properties of the Context. Top level metadata keys' heading
	// and trailing spaces will be trimmed. The size of this field should
	// not exceed 200KB.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: Immutable. The resource name of the Context.
	Name string `json:"name,omitempty"`

	// ParentContexts: Output only. A list of resource names of Contexts
	// that are parents of this Context. A Context may have at most 10
	// parent_contexts.
	ParentContexts []string `json:"parentContexts,omitempty"`

	// SchemaTitle: The title of the schema describing the metadata. Schema
	// title and version is expected to be registered in earlier Create
	// Schema calls. And both are used together as unique identifiers to
	// identify schemas within the local metadata store.
	SchemaTitle string `json:"schemaTitle,omitempty"`

	// SchemaVersion: The version of the schema in schema_name to use.
	// Schema title and version is expected to be registered in earlier
	// Create Schema calls. And both are used together as unique identifiers
	// to identify schemas within the local metadata store.
	SchemaVersion string `json:"schemaVersion,omitempty"`

	// UpdateTime: Output only. Timestamp when this Context was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Context
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CopyModelOperationMetadata: Details of
// ModelService.CopyModel operation.
type GoogleCloudAiplatformV1CopyModelOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CopyModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CopyModelOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CopyModelRequest: Request message for
// ModelService.CopyModel.
type GoogleCloudAiplatformV1CopyModelRequest struct {
	// EncryptionSpec: Customer-managed encryption key options. If this is
	// set, then the Model copy will be encrypted with the provided
	// encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// ModelId: Optional. Copy source_model into a new Model with this ID.
	// The ID will become the final component of the model resource name.
	// This value may be up to 63 characters, and valid characters are
	// `[a-z0-9_-]`. The first character cannot be a number or hyphen.
	ModelId string `json:"modelId,omitempty"`

	// ParentModel: Optional. Specify this field to copy source_model into
	// this existing Model as a new version. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	ParentModel string `json:"parentModel,omitempty"`

	// SourceModel: Required. The resource name of the Model to copy. That
	// Model must be in the same Project. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	SourceModel string `json:"sourceModel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EncryptionSpec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CopyModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CopyModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CopyModelResponse: Response message of
// ModelService.CopyModel operation.
type GoogleCloudAiplatformV1CopyModelResponse struct {
	// Model: The name of the copied Model resource. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	Model string `json:"model,omitempty"`

	// ModelVersionId: Output only. The version ID of the model that is
	// copied.
	ModelVersionId string `json:"modelVersionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Model") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CopyModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CopyModelResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CountTokensRequest: Request message for
// PredictionService.CountTokens.
type GoogleCloudAiplatformV1CountTokensRequest struct {
	// Contents: Required. Input content.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`

	// Instances: Required. The instances that are the input to token
	// counting call. Schema is identical to the prediction schema of the
	// underlying model.
	Instances []interface{} `json:"instances,omitempty"`

	// Model: Required. The name of the publisher model requested to serve
	// the prediction. Format:
	// `projects/{project}/locations/{location}/publishers/*/models/*`
	Model string `json:"model,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CountTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CountTokensRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CountTokensResponse: Response message for
// PredictionService.CountTokens.
type GoogleCloudAiplatformV1CountTokensResponse struct {
	// TotalBillableCharacters: The total number of billable characters
	// counted across all instances from the request.
	TotalBillableCharacters int64 `json:"totalBillableCharacters,omitempty"`

	// TotalTokens: The total number of tokens counted across all instances
	// from the request.
	TotalTokens int64 `json:"totalTokens,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "TotalBillableCharacters") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TotalBillableCharacters")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CountTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CountTokensResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateDatasetOperationMetadata: Runtime
// operation information for DatasetService.CreateDataset.
type GoogleCloudAiplatformV1CreateDatasetOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateDatasetOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata: Runtime
// operation information for DatasetService.CreateDatasetVersion.
type GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateDeploymentResourcePoolOperationMetadata:
// Runtime operation information for CreateDeploymentResourcePool
// method.
type GoogleCloudAiplatformV1CreateDeploymentResourcePoolOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateDeploymentResourcePoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateDeploymentResourcePoolOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest: Request
// message for CreateDeploymentResourcePool method.
type GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest struct {
	// DeploymentResourcePool: Required. The DeploymentResourcePool to
	// create.
	DeploymentResourcePool *GoogleCloudAiplatformV1DeploymentResourcePool `json:"deploymentResourcePool,omitempty"`

	// DeploymentResourcePoolId: Required. The ID to use for the
	// DeploymentResourcePool, which will become the final component of the
	// DeploymentResourcePool's resource name. The maximum length is 63
	// characters, and valid characters are `/^a-z
	// ([a-z0-9-]{0,61}[a-z0-9])?$/`.
	DeploymentResourcePoolId string `json:"deploymentResourcePoolId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DeploymentResourcePool") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeploymentResourcePool")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateEndpointOperationMetadata: Runtime
// operation information for EndpointService.CreateEndpoint.
type GoogleCloudAiplatformV1CreateEndpointOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateEndpointOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateEndpointOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata: Details of
// operations that perform create EntityType.
type GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata struct {
	// GenericMetadata: Operation metadata for EntityType.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureGroupOperationMetadata: Details
// of operations that perform create FeatureGroup.
type GoogleCloudAiplatformV1CreateFeatureGroupOperationMetadata struct {
	// GenericMetadata: Operation metadata for FeatureGroup.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateFeatureGroupOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureGroupOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureOnlineStoreOperationMetadata:
// Details of operations that perform create FeatureOnlineStore.
type GoogleCloudAiplatformV1CreateFeatureOnlineStoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for FeatureOnlineStore.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateFeatureOnlineStoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureOnlineStoreOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureOperationMetadata: Details of
// operations that perform create Feature.
type GoogleCloudAiplatformV1CreateFeatureOperationMetadata struct {
	// GenericMetadata: Operation metadata for Feature.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateFeatureOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureRequest: Request message for
// FeaturestoreService.CreateFeature. Request message for
// FeatureRegistryService.CreateFeature.
type GoogleCloudAiplatformV1CreateFeatureRequest struct {
	// Feature: Required. The Feature to create.
	Feature *GoogleCloudAiplatformV1Feature `json:"feature,omitempty"`

	// FeatureId: Required. The ID to use for the Feature, which will become
	// the final component of the Feature's resource name. This value may be
	// up to 128 characters, and valid characters are `[a-z0-9_]`. The first
	// character cannot be a number. The value must be unique within an
	// EntityType/FeatureGroup.
	FeatureId string `json:"featureId,omitempty"`

	// Parent: Required. The resource name of the EntityType or FeatureGroup
	// to create a Feature. Format for entity_type as parent:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/
	// entityTypes/{entity_type}` Format for feature_group as parent:
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}
	// `
	Parent string `json:"parent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Feature") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Feature") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateFeatureRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureViewOperationMetadata: Details of
// operations that perform create FeatureView.
type GoogleCloudAiplatformV1CreateFeatureViewOperationMetadata struct {
	// GenericMetadata: Operation metadata for FeatureView Create.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateFeatureViewOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureViewOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata: Details
// of operations that perform create Featurestore.
type GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata: Runtime
// operation information for IndexEndpointService.CreateIndexEndpoint.
type GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateIndexOperationMetadata: Runtime
// operation information for IndexService.CreateIndex.
type GoogleCloudAiplatformV1CreateIndexOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// NearestNeighborSearchOperationMetadata: The operation metadata with
	// regard to Matching Engine Index operation.
	NearestNeighborSearchOperationMetadata *GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata `json:"nearestNeighborSearchOperationMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateIndexOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateIndexOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata: Details
// of operations that perform MetadataService.CreateMetadataStore.
type GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for creating a MetadataStore.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateNotebookRuntimeTemplateOperationMetadata:
//
//	Metadata information for
//
// NotebookService.CreateNotebookRuntimeTemplate.
type GoogleCloudAiplatformV1CreateNotebookRuntimeTemplateOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateNotebookRuntimeTemplateOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateNotebookRuntimeTemplateOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreatePipelineJobRequest: Request message for
// PipelineService.CreatePipelineJob.
type GoogleCloudAiplatformV1CreatePipelineJobRequest struct {
	// Parent: Required. The resource name of the Location to create the
	// PipelineJob in. Format: `projects/{project}/locations/{location}`
	Parent string `json:"parent,omitempty"`

	// PipelineJob: Required. The PipelineJob to create.
	PipelineJob *GoogleCloudAiplatformV1PipelineJob `json:"pipelineJob,omitempty"`

	// PipelineJobId: The ID to use for the PipelineJob, which will become
	// the final component of the PipelineJob name. If not provided, an ID
	// will be automatically generated. This value should be less than 128
	// characters, and valid characters are `/a-z-/`.
	PipelineJobId string `json:"pipelineJobId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreatePipelineJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreatePipelineJobRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateRegistryFeatureOperationMetadata:
// Details of operations that perform create FeatureGroup.
type GoogleCloudAiplatformV1CreateRegistryFeatureOperationMetadata struct {
	// GenericMetadata: Operation metadata for Feature.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateRegistryFeatureOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateRegistryFeatureOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata: Runtime
// operation information for SpecialistPoolService.CreateSpecialistPool.
type GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateTensorboardOperationMetadata: Details of
// operations that perform create Tensorboard.
type GoogleCloudAiplatformV1CreateTensorboardOperationMetadata struct {
	// GenericMetadata: Operation metadata for Tensorboard.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateTensorboardOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateTensorboardOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateTensorboardRunRequest: Request message
// for TensorboardService.CreateTensorboardRun.
type GoogleCloudAiplatformV1CreateTensorboardRunRequest struct {
	// Parent: Required. The resource name of the TensorboardExperiment to
	// create the TensorboardRun in. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/ex
	// periments/{experiment}`
	Parent string `json:"parent,omitempty"`

	// TensorboardRun: Required. The TensorboardRun to create.
	TensorboardRun *GoogleCloudAiplatformV1TensorboardRun `json:"tensorboardRun,omitempty"`

	// TensorboardRunId: Required. The ID to use for the Tensorboard run,
	// which becomes the final component of the Tensorboard run's resource
	// name. This value should be 1-128 characters, and valid characters are
	// `/a-z-/`.
	TensorboardRunId string `json:"tensorboardRunId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateTensorboardRunRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateTensorboardRunRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest: Request
// message for TensorboardService.CreateTensorboardTimeSeries.
type GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest struct {
	// Parent: Required. The resource name of the TensorboardRun to create
	// the TensorboardTimeSeries in. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/ex
	// periments/{experiment}/runs/{run}`
	Parent string `json:"parent,omitempty"`

	// TensorboardTimeSeries: Required. The TensorboardTimeSeries to create.
	TensorboardTimeSeries *GoogleCloudAiplatformV1TensorboardTimeSeries `json:"tensorboardTimeSeries,omitempty"`

	// TensorboardTimeSeriesId: Optional. The user specified unique ID to
	// use for the TensorboardTimeSeries, which becomes the final component
	// of the TensorboardTimeSeries's resource name. This value should match
	// "a-z0-9{0, 127}"
	TensorboardTimeSeriesId string `json:"tensorboardTimeSeriesId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CsvDestination: The storage details for CSV
// output content.
type GoogleCloudAiplatformV1CsvDestination struct {
	// GcsDestination: Required. Google Cloud Storage location.
	GcsDestination *GoogleCloudAiplatformV1GcsDestination `json:"gcsDestination,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CsvDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CsvDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CsvSource: The storage details for CSV input
// content.
type GoogleCloudAiplatformV1CsvSource struct {
	// GcsSource: Required. Google Cloud Storage location.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CsvSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CsvSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CustomJob: Represents a job that runs custom
// workloads such as a Docker container or a Python package. A CustomJob
// can have multiple worker pools and each worker pool can have its own
// machine and input spec. A CustomJob will be cleaned up once the job
// enters terminal state (failed or succeeded).
type GoogleCloudAiplatformV1CustomJob struct {
	// CreateTime: Output only. Time when the CustomJob was created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Required. The display name of the CustomJob. The name
	// can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `json:"displayName,omitempty"`

	// EncryptionSpec: Customer-managed encryption key options for a
	// CustomJob. If this is set, then all resources created by the
	// CustomJob will be encrypted with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// EndTime: Output only. Time when the CustomJob entered any of the
	// following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
	// `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`

	// Error: Output only. Only populated when job's state is
	// `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// JobSpec: Required. Job spec.
	JobSpec *GoogleCloudAiplatformV1CustomJobSpec `json:"jobSpec,omitempty"`

	// Labels: The labels with user-defined metadata to organize CustomJobs.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. See
	// https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. Resource name of a CustomJob.
	Name string `json:"name,omitempty"`

	// StartTime: Output only. Time when the CustomJob for the first time
	// entered the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this
	// state the job may only go to either `JOB_STATE_SUCCEEDED`,
	// `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to
	// the `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded,
	// some results may be missing due to errors.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. Time when the CustomJob was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// WebAccessUris: Output only. URIs for accessing interactive shells
	// (https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
	// (one URI for each training node). Only available if
	// job_spec.enable_web_access is `true`. The keys are names of each node
	// in the training job; for example, `workerpool0-0` for the primary
	// node, `workerpool1-0` for the first node in the second worker pool,
	// and `workerpool1-1` for the second node in the second worker pool.
	// The values are the URIs for each node's interactive shell.
	WebAccessUris map[string]string `json:"webAccessUris,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CustomJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CustomJob
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CustomJobSpec: Represents the spec of a
// CustomJob.
type GoogleCloudAiplatformV1CustomJobSpec struct {
	// BaseOutputDirectory: The Cloud Storage location to store the output
	// of this CustomJob or HyperparameterTuningJob. For
	// HyperparameterTuningJob, the baseOutputDirectory of each child
	// CustomJob backing a Trial is set to a subdirectory of name id under
	// its parent HyperparameterTuningJob's baseOutputDirectory. The
	// following Vertex AI environment variables will be passed to
	// containers or python modules when this field is set: For CustomJob: *
	// AIP_MODEL_DIR = `/model/` * AIP_CHECKPOINT_DIR = `/checkpoints/` *
	// AIP_TENSORBOARD_LOG_DIR = `/logs/` For CustomJob backing a Trial of
	// HyperparameterTuningJob: * AIP_MODEL_DIR = `//model/` *
	// AIP_CHECKPOINT_DIR = `//checkpoints/` * AIP_TENSORBOARD_LOG_DIR =
	// `//logs/`
	BaseOutputDirectory *GoogleCloudAiplatformV1GcsDestination `json:"baseOutputDirectory,omitempty"`

	// EnableDashboardAccess: Optional. Whether you want Vertex AI to enable
	// access to the customized dashboard in training chief container. If
	// set to `true`, you can access the dashboard at the URIs given by
	// CustomJob.web_access_uris or Trial.web_access_uris (within
	// HyperparameterTuningJob.trials).
	EnableDashboardAccess bool `json:"enableDashboardAccess,omitempty"`

	// EnableWebAccess: Optional. Whether you want Vertex AI to enable
	// interactive shell access
	// (https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
	// to training containers. If set to `true`, you can access interactive
	// shells at the URIs given by CustomJob.web_access_uris or
	// Trial.web_access_uris (within HyperparameterTuningJob.trials).
	EnableWebAccess bool `json:"enableWebAccess,omitempty"`

	// Experiment: Optional. The Experiment associated with this job.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadataStore
	// s}/contexts/{experiment-name}`
	Experiment string `json:"experiment,omitempty"`

	// ExperimentRun: Optional. The Experiment Run associated with this job.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadataStore
	// s}/contexts/{experiment-name}-{experiment-run-name}`
	ExperimentRun string `json:"experimentRun,omitempty"`

	// Models: Optional. The name of the Model resources for which to
	// generate a mapping to artifact URIs. Applicable only to some of the
	// Google-provided custom jobs. Format:
	// `projects/{project}/locations/{location}/models/{model}` In order to
	// retrieve a specific version of the model, also provide the version ID
	// or version alias. Example:
	// `projects/{project}/locations/{location}/models/{model}@2` or
	// `projects/{project}/locations/{location}/models/{model}@golden` If no
	// version ID or alias is specified, the "default" version will be
	// returned. The "default" version alias is created for the first
	// version of the model, and can be moved to other versions later on.
	// There will be exactly one default version.
	Models []string `json:"models,omitempty"`

	// Network: Optional. The full name of the Compute Engine network
	// (/compute/docs/networks-and-firewalls#networks) to which the Job
	// should be peered. For example,
	// `projects/12345/global/networks/myVPC`. Format
	// (/compute/docs/reference/rest/v1/networks/insert) is of the form
	// `projects/{project}/global/networks/{network}`. Where {project} is a
	// project number, as in `12345`, and {network} is a network name. To
	// specify this field, you must have already configured VPC Network
	// Peering for Vertex AI
	// (https://cloud.google.com/vertex-ai/docs/general/vpc-peering). If
	// this field is left unspecified, the job is not peered with any
	// network.
	Network string `json:"network,omitempty"`

	// ProtectedArtifactLocationId: The ID of the location to store
	// protected artifacts. e.g. us-central1. Populate only when the
	// location is different than CustomJob location. List of supported
	// locations: https://cloud.google.com/vertex-ai/docs/general/locations
	ProtectedArtifactLocationId string `json:"protectedArtifactLocationId,omitempty"`

	// ReservedIpRanges: Optional. A list of names for the reserved ip
	// ranges under the VPC network that can be used for this job. If set,
	// we will deploy the job within the provided ip ranges. Otherwise, the
	// job will be deployed to any ip ranges under the provided VPC network.
	// Example: ['vertex-ai-ip-range'].
	ReservedIpRanges []string `json:"reservedIpRanges,omitempty"`

	// Scheduling: Scheduling options for a CustomJob.
	Scheduling *GoogleCloudAiplatformV1Scheduling `json:"scheduling,omitempty"`

	// ServiceAccount: Specifies the service account for workload run-as
	// account. Users submitting jobs must have act-as permission on this
	// run-as account. If unspecified, the Vertex AI Custom Code Service
	// Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// for the CustomJob's project is used.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// Tensorboard: Optional. The name of a Vertex AI Tensorboard resource
	// to which this CustomJob will upload Tensorboard logs. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Tensorboard string `json:"tensorboard,omitempty"`

	// WorkerPoolSpecs: Required. The spec of the worker pools including
	// machine type and Docker image. All worker pools except the first one
	// are optional and can be skipped by providing an empty value.
	WorkerPoolSpecs []*GoogleCloudAiplatformV1WorkerPoolSpec `json:"workerPoolSpecs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BaseOutputDirectory")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BaseOutputDirectory") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1CustomJobSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CustomJobSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DataItem: A piece of data in a Dataset. Could
// be an image, a video, a document or plain text.
type GoogleCloudAiplatformV1DataItem struct {
	// CreateTime: Output only. Timestamp when this DataItem was created.
	CreateTime string `json:"createTime,omitempty"`

	// Etag: Optional. Used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. The labels with user-defined metadata to organize
	// your DataItems. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. No more than 64 user labels can be associated with one
	// DataItem(System labels are excluded). See https://goo.gl/xmQnxf for
	// more information and examples of labels. System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The resource name of the DataItem.
	Name string `json:"name,omitempty"`

	// Payload: Required. The data that the DataItem represents (for
	// example, an image or a text snippet). The schema of the payload is
	// stored in the parent Dataset's metadata schema's dataItemSchemaUri
	// field.
	Payload interface{} `json:"payload,omitempty"`

	// UpdateTime: Output only. Timestamp when this DataItem was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DataItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DataItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DataItemView: A container for a single
// DataItem and Annotations on it.
type GoogleCloudAiplatformV1DataItemView struct {
	// Annotations: The Annotations on the DataItem. If too many Annotations
	// should be returned for the DataItem, this field will be truncated per
	// annotations_limit in request. If it was, then the
	// has_truncated_annotations will be set to true.
	Annotations []*GoogleCloudAiplatformV1Annotation `json:"annotations,omitempty"`

	// DataItem: The DataItem.
	DataItem *GoogleCloudAiplatformV1DataItem `json:"dataItem,omitempty"`

	// HasTruncatedAnnotations: True if and only if the Annotations field
	// has been truncated. It happens if more Annotations for this DataItem
	// met the request's annotation_filter than are allowed to be returned
	// by annotations_limit. Note that if Annotations field is not being
	// returned due to field mask, then this field will not be set to true
	// no matter how many Annotations are there.
	HasTruncatedAnnotations bool `json:"hasTruncatedAnnotations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DataItemView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DataItemView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DataLabelingJob: DataLabelingJob is used to
// trigger a human labeling job on unlabeled data from the following
// Dataset:
type GoogleCloudAiplatformV1DataLabelingJob struct {
	// ActiveLearningConfig: Parameters that configure the active learning
	// pipeline. Active learning will label the data incrementally via
	// several iterations. For every iteration, it will select a batch of
	// data based on the sampling strategy.
	ActiveLearningConfig *GoogleCloudAiplatformV1ActiveLearningConfig `json:"activeLearningConfig,omitempty"`

	// AnnotationLabels: Labels to assign to annotations generated by this
	// DataLabelingJob. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. See https://goo.gl/xmQnxf for more information and
	// examples of labels. System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	AnnotationLabels map[string]string `json:"annotationLabels,omitempty"`

	// CreateTime: Output only. Timestamp when this DataLabelingJob was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// CurrentSpend: Output only. Estimated cost(in US dollars) that the
	// DataLabelingJob has incurred to date.
	CurrentSpend *GoogleTypeMoney `json:"currentSpend,omitempty"`

	// Datasets: Required. Dataset resource names. Right now we only support
	// labeling from a single Dataset. Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Datasets []string `json:"datasets,omitempty"`

	// DisplayName: Required. The user-defined name of the DataLabelingJob.
	// The name can be up to 128 characters long and can consist of any
	// UTF-8 characters. Display name of a DataLabelingJob.
	DisplayName string `json:"displayName,omitempty"`

	// EncryptionSpec: Customer-managed encryption key spec for a
	// DataLabelingJob. If set, this DataLabelingJob will be secured by this
	// key. Note: Annotations created in the DataLabelingJob are associated
	// with the EncryptionSpec of the Dataset they are exported to.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// Error: Output only. DataLabelingJob errors. It is only populated when
	// job's state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Inputs: Required. Input config parameters for the DataLabelingJob.
	Inputs interface{} `json:"inputs,omitempty"`

	// InputsSchemaUri: Required. Points to a YAML file stored on Google
	// Cloud Storage describing the config for a specific type of
	// DataLabelingJob. The schema files that can be used here are found in
	// the https://storage.googleapis.com/google-cloud-aiplatform bucket in
	// the /schema/datalabelingjob/inputs/ folder.
	InputsSchemaUri string `json:"inputsSchemaUri,omitempty"`

	// InstructionUri: Required. The Google Cloud Storage location of the
	// instruction pdf. This pdf is shared with labelers, and provides
	// detailed description on how to label DataItems in Datasets.
	InstructionUri string `json:"instructionUri,omitempty"`

	// LabelerCount: Required. Number of labelers to work on each DataItem.
	LabelerCount int64 `json:"labelerCount,omitempty"`

	// LabelingProgress: Output only. Current labeling job progress
	// percentage scaled in interval [0, 100], indicating the percentage of
	// DataItems that has been finished.
	LabelingProgress int64 `json:"labelingProgress,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// DataLabelingJobs. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. See https://goo.gl/xmQnxf for more information and
	// examples of labels. System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable. Following system
	// labels exist for each DataLabelingJob: *
	// "aiplatform.googleapis.com/schema": output only, its value is the
	// inputs_schema's title.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. Resource name of the DataLabelingJob.
	Name string `json:"name,omitempty"`

	// SpecialistPools: The SpecialistPools' resource names associated with
	// this job.
	SpecialistPools []string `json:"specialistPools,omitempty"`

	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this
	// state the job may only go to either `JOB_STATE_SUCCEEDED`,
	// `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to
	// the `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded,
	// some results may be missing due to errors.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. Timestamp when this DataLabelingJob was
	// updated most recently.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ActiveLearningConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActiveLearningConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DataLabelingJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DataLabelingJob
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Dataset: A collection of DataItems and
// Annotations on them.
type GoogleCloudAiplatformV1Dataset struct {
	// CreateTime: Output only. Timestamp when this Dataset was created.
	CreateTime string `json:"createTime,omitempty"`

	// DataItemCount: Output only. The number of DataItems in this Dataset.
	// Only apply for non-structured Dataset.
	DataItemCount int64 `json:"dataItemCount,omitempty,string"`

	// Description: The description of the Dataset.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The user-defined name of the Dataset. The name
	// can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `json:"displayName,omitempty"`

	// EncryptionSpec: Customer-managed encryption key spec for a Dataset.
	// If set, this Dataset and all sub-resources of this Dataset will be
	// secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// Etag: Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// Datasets. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are
	// allowed. No more than 64 user labels can be associated with one
	// Dataset (System labels are excluded). See https://goo.gl/xmQnxf for
	// more information and examples of labels. System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	// Following system labels exist for each Dataset: *
	// "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
	// value is the metadata_schema's title.
	Labels map[string]string `json:"labels,omitempty"`

	// Metadata: Required. Additional information about the Dataset.
	Metadata interface{} `json:"metadata,omitempty"`

	// MetadataArtifact: Output only. The resource name of the Artifact that
	// was created in MetadataStore when creating the Dataset. The Artifact
	// resource name pattern is
	// `projects/{project}/locations/{location}/metadataStores/{metadata_stor
	// e}/artifacts/{artifact}`.
	MetadataArtifact string `json:"metadataArtifact,omitempty"`

	// MetadataSchemaUri: Required. Points to a YAML file stored on Google
	// Cloud Storage describing additional information about the Dataset.
	// The schema is defined as an OpenAPI 3.0.2 Schema Object. The schema
	// files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/metadata/.
	MetadataSchemaUri string `json:"metadataSchemaUri,omitempty"`

	// Name: Output only. The resource name of the Dataset.
	Name string `json:"name,omitempty"`

	// SavedQueries: All SavedQueries belong to the Dataset will be returned
	// in List/Get Dataset response. The annotation_specs field will not be
	// populated except for UI cases which will only use
	// annotation_spec_count. In CreateDataset request, a SavedQuery is
	// created together if this field is set, up to one SavedQuery can be
	// set in CreateDatasetRequest. The SavedQuery should not contain any
	// AnnotationSpec.
	SavedQueries []*GoogleCloudAiplatformV1SavedQuery `json:"savedQueries,omitempty"`

	// UpdateTime: Output only. Timestamp when this Dataset was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Dataset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DatasetVersion: Describes the dataset version.
type GoogleCloudAiplatformV1DatasetVersion struct {
	// BigQueryDatasetName: Output only. Name of the associated BigQuery
	// dataset.
	BigQueryDatasetName string `json:"bigQueryDatasetName,omitempty"`

	// CreateTime: Output only. Timestamp when this DatasetVersion was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: The user-defined name of the DatasetVersion. The name
	// can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Metadata: Required. Output only. Additional information about the
	// DatasetVersion.
	Metadata interface{} `json:"metadata,omitempty"`

	// Name: Output only. The resource name of the DatasetVersion.
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. Timestamp when this DatasetVersion was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BigQueryDatasetName")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQueryDatasetName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DatasetVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DatasetVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DedicatedResources: A description of resources
// that are dedicated to a DeployedModel, and that need a higher degree
// of manual configuration.
type GoogleCloudAiplatformV1DedicatedResources struct {
	// AutoscalingMetricSpecs: Immutable. The metric specifications that
	// overrides a resource utilization metric (CPU utilization,
	// accelerator's duty cycle, and so on) target value (default to 60 if
	// not set). At most one entry is allowed per metric. If
	// machine_spec.accelerator_count is above 0, the autoscaling will be
	// based on both CPU utilization and accelerator's duty cycle metrics
	// and scale up when either metrics exceeds its target value while scale
	// down if both metrics are under their target value. The default target
	// value is 60 for both metrics. If machine_spec.accelerator_count is 0,
	// the autoscaling will be based on CPU utilization metric only with
	// default target value 60 if not explicitly set. For example, in the
	// case of Online Prediction, if you want to override target CPU
	// utilization to 80, you should set
	// autoscaling_metric_specs.metric_name to
	// `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
	// autoscaling_metric_specs.target to `80`.
	AutoscalingMetricSpecs []*GoogleCloudAiplatformV1AutoscalingMetricSpec `json:"autoscalingMetricSpecs,omitempty"`

	// MachineSpec: Required. Immutable. The specification of a single
	// machine used by the prediction.
	MachineSpec *GoogleCloudAiplatformV1MachineSpec `json:"machineSpec,omitempty"`

	// MaxReplicaCount: Immutable. The maximum number of replicas this
	// DeployedModel may be deployed on when the traffic against it
	// increases. If the requested value is too large, the deployment will
	// error, but if deployment succeeds then the ability to scale the model
	// to that many replicas is guaranteed (barring service outages). If
	// traffic against the DeployedModel increases beyond what its replicas
	// at maximum may handle, a portion of the traffic will be dropped. If
	// this value is not provided, will use min_replica_count as the default
	// value. The value of this field impacts the charge against Vertex CPU
	// and GPU quotas. Specifically, you will be charged for
	// (max_replica_count * number of cores in the selected machine type)
	// and (max_replica_count * number of GPUs per replica in the selected
	// machine type).
	MaxReplicaCount int64 `json:"maxReplicaCount,omitempty"`

	// MinReplicaCount: Required. Immutable. The minimum number of machine
	// replicas this DeployedModel will be always deployed on. This value
	// must be greater than or equal to 1. If traffic against the
	// DeployedModel increases, it may dynamically be deployed onto more
	// replicas, and as traffic decreases, some of these extra replicas may
	// be freed.
	MinReplicaCount int64 `json:"minReplicaCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AutoscalingMetricSpecs") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoscalingMetricSpecs")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DedicatedResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DedicatedResources
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata: Details
// of operations that delete Feature values.
type GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore delete Features
	// values.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesRequest: Request message
// for FeaturestoreService.DeleteFeatureValues.
type GoogleCloudAiplatformV1DeleteFeatureValuesRequest struct {
	// SelectEntity: Select feature values to be deleted by specifying
	// entities.
	SelectEntity *GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity `json:"selectEntity,omitempty"`

	// SelectTimeRangeAndFeature: Select feature values to be deleted by
	// specifying time range and features.
	SelectTimeRangeAndFeature *GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature `json:"selectTimeRangeAndFeature,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SelectEntity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SelectEntity") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeleteFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity:
// Message to select entity. If an entity id is selected, all the
// feature values corresponding to the entity id will be deleted,
// including the entityId.
type GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity struct {
	// EntityIdSelector: Required. Selectors choosing feature values of
	// which entity id to be deleted from the EntityType.
	EntityIdSelector *GoogleCloudAiplatformV1EntityIdSelector `json:"entityIdSelector,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityIdSelector") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityIdSelector") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFea
// ture: Message to select time range and feature. Values of the
// selected feature generated within an inclusive time range will be
// deleted. Using this option permanently deletes the feature values
// from the specified feature IDs within the specified time range. This
// might include data from the online storage. If you want to retain any
// deleted historical data in the online storage, you must re-ingest it.
type GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature struct {
	// FeatureSelector: Required. Selectors choosing which feature values to
	// be deleted from the EntityType.
	FeatureSelector *GoogleCloudAiplatformV1FeatureSelector `json:"featureSelector,omitempty"`

	// SkipOnlineStorageDelete: If set, data will not be deleted from online
	// storage. When time range is older than the data in online storage,
	// setting this to be true will make the deletion have no impact on
	// online serving.
	SkipOnlineStorageDelete bool `json:"skipOnlineStorageDelete,omitempty"`

	// TimeRange: Required. Select feature generated within a half-inclusive
	// time range. The time range is lower inclusive and upper exclusive.
	TimeRange *GoogleTypeInterval `json:"timeRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FeatureSelector") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureSelector") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesResponse: Response message
// for FeaturestoreService.DeleteFeatureValues.
type GoogleCloudAiplatformV1DeleteFeatureValuesResponse struct {
	// SelectEntity: Response for request specifying the entities to delete
	SelectEntity *GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity `json:"selectEntity,omitempty"`

	// SelectTimeRangeAndFeature: Response for request specifying time range
	// and feature
	SelectTimeRangeAndFeature *GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature `json:"selectTimeRangeAndFeature,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SelectEntity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SelectEntity") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeleteFeatureValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity:
// Response message if the request uses the SelectEntity option.
type GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity struct {
	// OfflineStorageDeletedEntityRowCount: The count of deleted entity rows
	// in the offline storage. Each row corresponds to the combination of an
	// entity ID and a timestamp. One entity ID can have multiple rows in
	// the offline storage.
	OfflineStorageDeletedEntityRowCount int64 `json:"offlineStorageDeletedEntityRowCount,omitempty,string"`

	// OnlineStorageDeletedEntityCount: The count of deleted entities in the
	// online storage. Each entity ID corresponds to one entity.
	OnlineStorageDeletedEntityCount int64 `json:"onlineStorageDeletedEntityCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "OfflineStorageDeletedEntityRowCount") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "OfflineStorageDeletedEntityRowCount") to include in API requests
	// with the JSON null value. By default, fields with empty values are
	// omitted from API requests. However, any field with an empty value
	// appearing in NullFields will be sent to the server as null. It is an
	// error if a field in this list has a non-empty value. This may be used
	// to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFe
// ature: Response message if the request uses the
// SelectTimeRangeAndFeature option.
type GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature struct {
	// ImpactedFeatureCount: The count of the features or columns impacted.
	// This is the same as the feature count in the request.
	ImpactedFeatureCount int64 `json:"impactedFeatureCount,omitempty,string"`

	// OfflineStorageModifiedEntityRowCount: The count of modified entity
	// rows in the offline storage. Each row corresponds to the combination
	// of an entity ID and a timestamp. One entity ID can have multiple rows
	// in the offline storage. Within each row, only the features specified
	// in the request are deleted.
	OfflineStorageModifiedEntityRowCount int64 `json:"offlineStorageModifiedEntityRowCount,omitempty,string"`

	// OnlineStorageModifiedEntityCount: The count of modified entities in
	// the online storage. Each entity ID corresponds to one entity. Within
	// each entity, only the features specified in the request are deleted.
	OnlineStorageModifiedEntityCount int64 `json:"onlineStorageModifiedEntityCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "ImpactedFeatureCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImpactedFeatureCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata: Details
// of operations that perform MetadataService.DeleteMetadataStore.
type GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for deleting a MetadataStore.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteOperationMetadata: Details of operations
// that perform deletes of any entities.
type GoogleCloudAiplatformV1DeleteOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeleteOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployIndexOperationMetadata: Runtime
// operation information for IndexEndpointService.DeployIndex.
type GoogleCloudAiplatformV1DeployIndexOperationMetadata struct {
	// DeployedIndexId: The unique index id specified by user
	DeployedIndexId string `json:"deployedIndexId,omitempty"`

	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedIndexId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployIndexOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployIndexOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployIndexRequest: Request message for
// IndexEndpointService.DeployIndex.
type GoogleCloudAiplatformV1DeployIndexRequest struct {
	// DeployedIndex: Required. The DeployedIndex to be created within the
	// IndexEndpoint.
	DeployedIndex *GoogleCloudAiplatformV1DeployedIndex `json:"deployedIndex,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedIndex") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployIndexRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployIndexRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployIndexResponse: Response message for
// IndexEndpointService.DeployIndex.
type GoogleCloudAiplatformV1DeployIndexResponse struct {
	// DeployedIndex: The DeployedIndex that had been deployed in the
	// IndexEndpoint.
	DeployedIndex *GoogleCloudAiplatformV1DeployedIndex `json:"deployedIndex,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedIndex") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployIndexResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployIndexResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployModelOperationMetadata: Runtime
// operation information for EndpointService.DeployModel.
type GoogleCloudAiplatformV1DeployModelOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployModelOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployModelRequest: Request message for
// EndpointService.DeployModel.
type GoogleCloudAiplatformV1DeployModelRequest struct {
	// DeployedModel: Required. The DeployedModel to be created within the
	// Endpoint. Note that Endpoint.traffic_split must be updated for the
	// DeployedModel to start receiving traffic, either as part of this
	// call, or via EndpointService.UpdateEndpoint.
	DeployedModel *GoogleCloudAiplatformV1DeployedModel `json:"deployedModel,omitempty"`

	// TrafficSplit: A map from a DeployedModel's ID to the percentage of
	// this Endpoint's traffic that should be forwarded to that
	// DeployedModel. If this field is non-empty, then the Endpoint's
	// traffic_split will be overwritten with it. To refer to the ID of the
	// just being deployed Model, a "0" should be used, and the actual ID of
	// the new DeployedModel will be filled in its place by this method. The
	// traffic percentage values must add up to 100. If this field is empty,
	// then the Endpoint's traffic_split is not updated.
	TrafficSplit map[string]int64 `json:"trafficSplit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedModel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployModelResponse: Response message for
// EndpointService.DeployModel.
type GoogleCloudAiplatformV1DeployModelResponse struct {
	// DeployedModel: The DeployedModel that had been deployed in the
	// Endpoint.
	DeployedModel *GoogleCloudAiplatformV1DeployedModel `json:"deployedModel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedModel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployModelResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedIndex: A deployment of an Index.
// IndexEndpoints contain one or more DeployedIndexes.
type GoogleCloudAiplatformV1DeployedIndex struct {
	// AutomaticResources: Optional. A description of resources that the
	// DeployedIndex uses, which to large degree are decided by Vertex AI,
	// and optionally allows only a modest additional configuration. If
	// min_replica_count is not set, the default value is 2 (we don't
	// provide SLA when min_replica_count=1). If max_replica_count is not
	// set, the default value is min_replica_count. The max allowed replica
	// count is 1000.
	AutomaticResources *GoogleCloudAiplatformV1AutomaticResources `json:"automaticResources,omitempty"`

	// CreateTime: Output only. Timestamp when the DeployedIndex was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DedicatedResources: Optional. A description of resources that are
	// dedicated to the DeployedIndex, and that need a higher degree of
	// manual configuration. The field min_replica_count must be set to a
	// value strictly greater than 0, or else validation will fail. We don't
	// provide SLA when min_replica_count=1. If max_replica_count is not
	// set, the default value is min_replica_count. The max allowed replica
	// count is 1000. Available machine types for SMALL shard: e2-standard-2
	// and all machine types available for MEDIUM and LARGE shard. Available
	// machine types for MEDIUM shard: e2-standard-16 and all machine types
	// available for LARGE shard. Available machine types for LARGE shard:
	// e2-highmem-16, n2d-standard-32. n1-standard-16 and n1-standard-32 are
	// still available, but we recommend e2-standard-16 and e2-highmem-16
	// for cost efficiency.
	DedicatedResources *GoogleCloudAiplatformV1DedicatedResources `json:"dedicatedResources,omitempty"`

	// DeployedIndexAuthConfig: Optional. If set, the authentication is
	// enabled for the private endpoint.
	DeployedIndexAuthConfig *GoogleCloudAiplatformV1DeployedIndexAuthConfig `json:"deployedIndexAuthConfig,omitempty"`

	// DeploymentGroup: Optional. The deployment group can be no longer than
	// 64 characters (eg: 'test', 'prod'). If not set, we will use the
	// 'default' deployment group. Creating `deployment_groups` with
	// `reserved_ip_ranges` is a recommended practice when the peered
	// network has multiple peering ranges. This creates your deployments
	// from predictable IP spaces for easier traffic administration. Also,
	// one deployment_group (except 'default') can only be used with the
	// same reserved_ip_ranges which means if the deployment_group has been
	// used with reserved_ip_ranges: [a, b, c], using it with [a, b] or [d,
	// e] is disallowed. Note: we only support up to 5 deployment groups(not
	// including 'default').
	DeploymentGroup string `json:"deploymentGroup,omitempty"`

	// DisplayName: The display name of the DeployedIndex. If not provided
	// upon creation, the Index's display_name is used.
	DisplayName string `json:"displayName,omitempty"`

	// EnableAccessLogging: Optional. If true, private endpoint's access
	// logs are sent to Cloud Logging. These logs are like standard server
	// access logs, containing information like timestamp and latency for
	// each MatchRequest. Note that logs may incur a cost, especially if the
	// deployed index receives a high queries per second rate (QPS).
	// Estimate your costs before enabling this option.
	EnableAccessLogging bool `json:"enableAccessLogging,omitempty"`

	// Id: Required. The user specified ID of the DeployedIndex. The ID can
	// be up to 128 characters long and must start with a letter and only
	// contain letters, numbers, and underscores. The ID must be unique
	// within the project it is created in.
	Id string `json:"id,omitempty"`

	// Index: Required. The name of the Index this is the deployment of. We
	// may refer to this Index as the DeployedIndex's "original" Index.
	Index string `json:"index,omitempty"`

	// IndexSyncTime: Output only. The DeployedIndex may depend on various
	// data on its original Index. Additionally when certain changes to the
	// original Index are being done (e.g. when what the Index contains is
	// being changed) the DeployedIndex may be asynchronously updated in the
	// background to reflect these changes. If this timestamp's value is at
	// least the Index.update_time of the original Index, it means that this
	// DeployedIndex and the original Index are in sync. If this timestamp
	// is older, then to see which updates this DeployedIndex already
	// contains (and which it does not), one must list the operations that
	// are running on the original Index. Only the successfully completed
	// Operations with update_time equal or before this sync time are
	// contained in this DeployedIndex.
	IndexSyncTime string `json:"indexSyncTime,omitempty"`

	// PrivateEndpoints: Output only. Provides paths for users to send
	// requests directly to the deployed index services running on Cloud via
	// private services access. This field is populated if network is
	// configured.
	PrivateEndpoints *GoogleCloudAiplatformV1IndexPrivateEndpoints `json:"privateEndpoints,omitempty"`

	// ReservedIpRanges: Optional. A list of reserved ip ranges under the
	// VPC network that can be used for this DeployedIndex. If set, we will
	// deploy the index within the provided ip ranges. Otherwise, the index
	// might be deployed to any ip ranges under the provided VPC network.
	// The value should be the name of the address
	// (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
	// Example: ['vertex-ai-ip-range']. For more information about subnets
	// and network IP ranges, please see
	// https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
	ReservedIpRanges []string `json:"reservedIpRanges,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutomaticResources")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutomaticResources") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployedIndex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedIndex
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedIndexAuthConfig: Used to set up the
// auth on the DeployedIndex's private endpoint.
type GoogleCloudAiplatformV1DeployedIndexAuthConfig struct {
	// AuthProvider: Defines the authentication provider that the
	// DeployedIndex uses.
	AuthProvider *GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider `json:"authProvider,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuthProvider") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuthProvider") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployedIndexAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedIndexAuthConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider:
// Configuration for an authentication provider, including support for
// JSON Web Token (JWT)
// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
type GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider struct {
	// AllowedIssuers: A list of allowed JWT issuers. Each entry must be a
	// valid Google service account, in the following format:
	// `service-account-name@project-id.iam.gserviceaccount.com`
	AllowedIssuers []string `json:"allowedIssuers,omitempty"`

	// Audiences: The list of JWT audiences
	// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
	// that are allowed to access. A JWT containing any of these audiences
	// will be accepted.
	Audiences []string `json:"audiences,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowedIssuers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowedIssuers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedIndexRef: Points to a DeployedIndex.
type GoogleCloudAiplatformV1DeployedIndexRef struct {
	// DeployedIndexId: Immutable. The ID of the DeployedIndex in the above
	// IndexEndpoint.
	DeployedIndexId string `json:"deployedIndexId,omitempty"`

	// DisplayName: Output only. The display name of the DeployedIndex.
	DisplayName string `json:"displayName,omitempty"`

	// IndexEndpoint: Immutable. A resource name of the IndexEndpoint.
	IndexEndpoint string `json:"indexEndpoint,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedIndexId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployedIndexRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedIndexRef
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedModel: A deployment of a Model.
// Endpoints contain one or more DeployedModels.
type GoogleCloudAiplatformV1DeployedModel struct {
	// AutomaticResources: A description of resources that to large degree
	// are decided by Vertex AI, and require only a modest additional
	// configuration.
	AutomaticResources *GoogleCloudAiplatformV1AutomaticResources `json:"automaticResources,omitempty"`

	// CreateTime: Output only. Timestamp when the DeployedModel was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DedicatedResources: A description of resources that are dedicated to
	// the DeployedModel, and that need a higher degree of manual
	// configuration.
	DedicatedResources *GoogleCloudAiplatformV1DedicatedResources `json:"dedicatedResources,omitempty"`

	// DisableContainerLogging: For custom-trained Models and AutoML Tabular
	// Models, the container of the DeployedModel instances will send
	// `stderr` and `stdout` streams to Cloud Logging by default. Please
	// note that the logs incur cost, which are subject to Cloud Logging
	// pricing (https://cloud.google.com/logging/pricing). User can disable
	// container logging by setting this flag to true.
	DisableContainerLogging bool `json:"disableContainerLogging,omitempty"`

	// DisplayName: The display name of the DeployedModel. If not provided
	// upon creation, the Model's display_name is used.
	DisplayName string `json:"displayName,omitempty"`

	// EnableAccessLogging: If true, online prediction access logs are sent
	// to Cloud Logging. These logs are like standard server access logs,
	// containing information like timestamp and latency for each prediction
	// request. Note that logs may incur a cost, especially if your project
	// receives prediction requests at a high queries per second rate (QPS).
	// Estimate your costs before enabling this option.
	EnableAccessLogging bool `json:"enableAccessLogging,omitempty"`

	// ExplanationSpec: Explanation configuration for this DeployedModel.
	// When deploying a Model using EndpointService.DeployModel, this value
	// overrides the value of Model.explanation_spec. All fields of
	// explanation_spec are optional in the request. If a field of
	// explanation_spec is not populated, the value of the same field of
	// Model.explanation_spec is inherited. If the corresponding
	// Model.explanation_spec is not populated, all fields of the
	// explanation_spec will be used for the explanation configuration.
	ExplanationSpec *GoogleCloudAiplatformV1ExplanationSpec `json:"explanationSpec,omitempty"`

	// Id: Immutable. The ID of the DeployedModel. If not provided upon
	// deployment, Vertex AI will generate a value for this ID. This value
	// should be 1-10 characters, and valid characters are `/[0-9]/`.
	Id string `json:"id,omitempty"`

	// Model: Required. The resource name of the Model that this is the
	// deployment of. Note that the Model may be in a different location
	// than the DeployedModel's Endpoint. The resource name may contain
	// version id or version alias to specify the version. Example:
	// `projects/{project}/locations/{location}/models/{model}@2` or
	// `projects/{project}/locations/{location}/models/{model}@golden` if no
	// version is specified, the default version will be deployed.
	Model string `json:"model,omitempty"`

	// ModelVersionId: Output only. The version ID of the model that is
	// deployed.
	ModelVersionId string `json:"modelVersionId,omitempty"`

	// PrivateEndpoints: Output only. Provide paths for users to send
	// predict/explain/health requests directly to the deployed model
	// services running on Cloud via private services access. This field is
	// populated if network is configured.
	PrivateEndpoints *GoogleCloudAiplatformV1PrivateEndpoints `json:"privateEndpoints,omitempty"`

	// ServiceAccount: The service account that the DeployedModel's
	// container runs as. Specify the email address of the service account.
	// If this service account is not specified, the container runs as a
	// service account that doesn't have access to the resource project.
	// Users deploying the Model must have the `iam.serviceAccounts.actAs`
	// permission on this service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// SharedResources: The resource name of the shared
	// DeploymentResourcePool to deploy on. Format:
	// `projects/{project}/locations/{location}/deploymentResourcePools/{depl
	// oyment_resource_pool}`
	SharedResources string `json:"sharedResources,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutomaticResources")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutomaticResources") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployedModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedModel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedModelRef: Points to a DeployedModel.
type GoogleCloudAiplatformV1DeployedModelRef struct {
	// DeployedModelId: Immutable. An ID of a DeployedModel in the above
	// Endpoint.
	DeployedModelId string `json:"deployedModelId,omitempty"`

	// Endpoint: Immutable. A resource name of an Endpoint.
	Endpoint string `json:"endpoint,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedModelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedModelId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeployedModelRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedModelRef
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeploymentResourcePool: A description of
// resources that can be shared by multiple DeployedModels, whose
// underlying specification consists of a DedicatedResources.
type GoogleCloudAiplatformV1DeploymentResourcePool struct {
	// CreateTime: Output only. Timestamp when this DeploymentResourcePool
	// was created.
	CreateTime string `json:"createTime,omitempty"`

	// DedicatedResources: Required. The underlying DedicatedResources that
	// the DeploymentResourcePool uses.
	DedicatedResources *GoogleCloudAiplatformV1DedicatedResources `json:"dedicatedResources,omitempty"`

	// Name: Immutable. The resource name of the DeploymentResourcePool.
	// Format:
	// `projects/{project}/locations/{location}/deploymentResourcePools/{depl
	// oyment_resource_pool}`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DeploymentResourcePool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeploymentResourcePool
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1DestinationFeatureSetting struct {
	// DestinationField: Specify the field name in the export destination.
	// If not specified, Feature ID is used.
	DestinationField string `json:"destinationField,omitempty"`

	// FeatureId: Required. The ID of the Feature to apply the setting to.
	FeatureId string `json:"featureId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestinationField") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestinationField") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DestinationFeatureSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DestinationFeatureSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DirectPredictRequest: Request message for
// PredictionService.DirectPredict.
type GoogleCloudAiplatformV1DirectPredictRequest struct {
	// Inputs: The prediction input.
	Inputs []*GoogleCloudAiplatformV1Tensor `json:"inputs,omitempty"`

	// Parameters: The parameters that govern the prediction.
	Parameters *GoogleCloudAiplatformV1Tensor `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Inputs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Inputs") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DirectPredictRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DirectPredictRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DirectPredictResponse: Response message for
// PredictionService.DirectPredict.
type GoogleCloudAiplatformV1DirectPredictResponse struct {
	// Outputs: The prediction output.
	Outputs []*GoogleCloudAiplatformV1Tensor `json:"outputs,omitempty"`

	// Parameters: The parameters that govern the prediction.
	Parameters *GoogleCloudAiplatformV1Tensor `json:"parameters,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Outputs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Outputs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DirectPredictResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DirectPredictResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DirectRawPredictRequest: Request message for
// PredictionService.DirectRawPredict.
type GoogleCloudAiplatformV1DirectRawPredictRequest struct {
	// Input: The prediction input.
	Input string `json:"input,omitempty"`

	// MethodName: Fully qualified name of the API method being invoked to
	// perform predictions. Format: `/namespace.Service/Method/` Example:
	// `/tensorflow.serving.PredictionService/Predict`
	MethodName string `json:"methodName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Input") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Input") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DirectRawPredictRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DirectRawPredictRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DirectRawPredictResponse: Response message for
// PredictionService.DirectRawPredict.
type GoogleCloudAiplatformV1DirectRawPredictResponse struct {
	// Output: The prediction output.
	Output string `json:"output,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Output") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Output") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DirectRawPredictResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DirectRawPredictResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DiskSpec: Represents the spec of disk options.
type GoogleCloudAiplatformV1DiskSpec struct {
	// BootDiskSizeGb: Size in GB of the boot disk (default is 100GB).
	BootDiskSizeGb int64 `json:"bootDiskSizeGb,omitempty"`

	// BootDiskType: Type of the boot disk (default is "pd-ssd"). Valid
	// values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard"
	// (Persistent Disk Hard Disk Drive).
	BootDiskType string `json:"bootDiskType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BootDiskSizeGb") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BootDiskSizeGb") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DiskSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DiskSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DoubleArray: A list of double values.
type GoogleCloudAiplatformV1DoubleArray struct {
	// Values: A list of double values.
	Values []float64 `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1DoubleArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DoubleArray
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1DoubleArray) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1DoubleArray
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudAiplatformV1EncryptionSpec: Represents a customer-managed
// encryption key spec that can be applied to a top-level resource.
type GoogleCloudAiplatformV1EncryptionSpec struct {
	// KmsKeyName: Required. The Cloud KMS resource identifier of the
	// customer managed encryption key used to protect a resource. Has the
	// form:
	// `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-
	// key`. The key needs to be in the same region as where the compute
	// resource is created.
	KmsKeyName string `json:"kmsKeyName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KmsKeyName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EncryptionSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Endpoint: Models are deployed into it, and
// afterwards Endpoint is called to obtain predictions and explanations.
type GoogleCloudAiplatformV1Endpoint struct {
	// CreateTime: Output only. Timestamp when this Endpoint was created.
	CreateTime string `json:"createTime,omitempty"`

	// DeployedModels: Output only. The models deployed in this Endpoint. To
	// add or remove DeployedModels use EndpointService.DeployModel and
	// EndpointService.UndeployModel respectively.
	DeployedModels []*GoogleCloudAiplatformV1DeployedModel `json:"deployedModels,omitempty"`

	// Description: The description of the Endpoint.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The display name of the Endpoint. The name can
	// be up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`

	// EnablePrivateServiceConnect: Deprecated: If true, expose the Endpoint
	// via private service connect. Only one of the fields, network or
	// enable_private_service_connect, can be set.
	EnablePrivateServiceConnect bool `json:"enablePrivateServiceConnect,omitempty"`

	// EncryptionSpec: Customer-managed encryption key spec for an Endpoint.
	// If set, this Endpoint and all sub-resources of this Endpoint will be
	// secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// Etag: Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// Endpoints. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are
	// allowed. See https://goo.gl/xmQnxf for more information and examples
	// of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// ModelDeploymentMonitoringJob: Output only. Resource name of the Model
	// Monitoring job associated with this Endpoint if monitoring is enabled
	// by JobService.CreateModelDeploymentMonitoringJob. Format:
	// `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs
	// /{model_deployment_monitoring_job}`
	ModelDeploymentMonitoringJob string `json:"modelDeploymentMonitoringJob,omitempty"`

	// Name: Output only. The resource name of the Endpoint.
	Name string `json:"name,omitempty"`

	// Network: Optional. The full name of the Google Compute Engine network
	// (https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
	// to which the Endpoint should be peered. Private services access must
	// already be configured for the network. If left unspecified, the
	// Endpoint is not peered with any network. Only one of the fields,
	// network or enable_private_service_connect, can be set. Format
	// (https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
	// `projects/{project}/global/networks/{network}`. Where `{project}` is
	// a project number, as in `12345`, and `{network}` is network name.
	Network string `json:"network,omitempty"`

	// PredictRequestResponseLoggingConfig: Configures the request-response
	// logging for online prediction.
	PredictRequestResponseLoggingConfig *GoogleCloudAiplatformV1PredictRequestResponseLoggingConfig `json:"predictRequestResponseLoggingConfig,omitempty"`

	// PrivateServiceConnectConfig: Optional. Configuration for private
	// service connect. network and private_service_connect_config are
	// mutually exclusive.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1PrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`

	// TrafficSplit: A map from a DeployedModel's ID to the percentage of
	// this Endpoint's traffic that should be forwarded to that
	// DeployedModel. If a DeployedModel's ID is not listed in this map,
	// then it receives no traffic. The traffic percentage values must add
	// up to 100, or map must be empty if the Endpoint is to not accept any
	// traffic at a moment.
	TrafficSplit map[string]int64 `json:"trafficSplit,omitempty"`

	// UpdateTime: Output only. Timestamp when this Endpoint was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Endpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Endpoint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EntityIdSelector: Selector for entityId.
// Getting ids from the given source.
type GoogleCloudAiplatformV1EntityIdSelector struct {
	// CsvSource: Source of Csv
	CsvSource *GoogleCloudAiplatformV1CsvSource `json:"csvSource,omitempty"`

	// EntityIdField: Source column that holds entity IDs. If not provided,
	// entity IDs are extracted from the column named entity_id.
	EntityIdField string `json:"entityIdField,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CsvSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CsvSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1EntityIdSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EntityIdSelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EntityType: An entity type is a type of object
// in a system that needs to be modeled and have stored information
// about. For example, driver is an entity type, and driver0 is an
// instance of an entity type driver.
type GoogleCloudAiplatformV1EntityType struct {
	// CreateTime: Output only. Timestamp when this EntityType was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the EntityType.
	Description string `json:"description,omitempty"`

	// Etag: Optional. Used to perform a consistent read-modify-write
	// updates. If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. The labels with user-defined metadata to organize
	// your EntityTypes. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. See https://goo.gl/xmQnxf for more information on and
	// examples of labels. No more than 64 user labels can be associated
	// with one EntityType (System labels are excluded)." System reserved
	// label keys are prefixed with "aiplatform.googleapis.com/" and are
	// immutable.
	Labels map[string]string `json:"labels,omitempty"`

	// MonitoringConfig: Optional. The default monitoring configuration for
	// all Features with value type (Feature.ValueType) BOOL, STRING, DOUBLE
	// or INT64 under this EntityType. If this is populated with
	// [FeaturestoreMonitoringConfig.monitoring_interval] specified,
	// snapshot analysis monitoring is enabled. Otherwise, snapshot analysis
	// monitoring is disabled.
	MonitoringConfig *GoogleCloudAiplatformV1FeaturestoreMonitoringConfig `json:"monitoringConfig,omitempty"`

	// Name: Immutable. Name of the EntityType. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/
	// entityTypes/{entity_type}` The last part entity_type is assigned by
	// the client. The entity_type can be up to 64 characters long and can
	// consist only of ASCII Latin letters A-Z and a-z and underscore(_),
	// and ASCII digits 0-9 starting with a letter. The value will be unique
	// given a featurestore.
	Name string `json:"name,omitempty"`

	// OfflineStorageTtlDays: Optional. Config for data retention policy in
	// offline storage. TTL in days for feature values that will be stored
	// in offline storage. The Feature Store offline storage periodically
	// removes obsolete feature values older than `offline_storage_ttl_days`
	// since the feature generation time. If unset (or explicitly set to 0),
	// default to 4000 days TTL.
	OfflineStorageTtlDays int64 `json:"offlineStorageTtlDays,omitempty"`

	// UpdateTime: Output only. Timestamp when this EntityType was most
	// recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EntityType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EnvVar: Represents an environment variable
// present in a Container or Python Module.
type GoogleCloudAiplatformV1EnvVar struct {
	// Name: Required. Name of the environment variable. Must be a valid C
	// identifier.
	Name string `json:"name,omitempty"`

	// Value: Required. Variables that reference a $(VAR_NAME) are expanded
	// using the previous defined environment variables in the container and
	// any service environment variables. If a variable cannot be resolved,
	// the reference in the input string will be unchanged. The $(VAR_NAME)
	// syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
	// references will never be expanded, regardless of whether the variable
	// exists or not.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1EnvVar) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EnvVar
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ErrorAnalysisAnnotation: Model error analysis
// for each annotation.
type GoogleCloudAiplatformV1ErrorAnalysisAnnotation struct {
	// AttributedItems: Attributed items for a given annotation, typically
	// representing neighbors from the training sets constrained by the
	// query type.
	AttributedItems []*GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem `json:"attributedItems,omitempty"`

	// OutlierScore: The outlier score of this annotated item. Usually
	// defined as the min of all distances from attributed items.
	OutlierScore float64 `json:"outlierScore,omitempty"`

	// OutlierThreshold: The threshold used to determine if this annotation
	// is an outlier or not.
	OutlierThreshold float64 `json:"outlierThreshold,omitempty"`

	// QueryType: The query type used for finding the attributed items.
	//
	// Possible values:
	//   "QUERY_TYPE_UNSPECIFIED" - Unspecified query type for model error
	// analysis.
	//   "ALL_SIMILAR" - Query similar samples across all classes in the
	// dataset.
	//   "SAME_CLASS_SIMILAR" - Query similar samples from the same class of
	// the input sample.
	//   "SAME_CLASS_DISSIMILAR" - Query dissimilar samples from the same
	// class of the input sample.
	QueryType string `json:"queryType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributedItems") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributedItems") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ErrorAnalysisAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ErrorAnalysisAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ErrorAnalysisAnnotation) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ErrorAnalysisAnnotation
	var s1 struct {
		OutlierScore     gensupport.JSONFloat64 `json:"outlierScore"`
		OutlierThreshold gensupport.JSONFloat64 `json:"outlierThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.OutlierScore = float64(s1.OutlierScore)
	s.OutlierThreshold = float64(s1.OutlierThreshold)
	return nil
}

// GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem:
// Attributed items for a given annotation, typically representing
// neighbors from the training sets constrained by the query type.
type GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem struct {
	// AnnotationResourceName: The unique ID for each annotation. Used by FE
	// to allocate the annotation in DB.
	AnnotationResourceName string `json:"annotationResourceName,omitempty"`

	// Distance: The distance of this item to the annotation.
	Distance float64 `json:"distance,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AnnotationResourceName") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotationResourceName")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem
	var s1 struct {
		Distance gensupport.JSONFloat64 `json:"distance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Distance = float64(s1.Distance)
	return nil
}

// GoogleCloudAiplatformV1EvaluatedAnnotation: True positive, false
// positive, or false negative. EvaluatedAnnotation is only available
// under ModelEvaluationSlice with slice of `annotationSpec` dimension.
type GoogleCloudAiplatformV1EvaluatedAnnotation struct {
	// DataItemPayload: Output only. The data item payload that the Model
	// predicted this EvaluatedAnnotation on.
	DataItemPayload interface{} `json:"dataItemPayload,omitempty"`

	// ErrorAnalysisAnnotations: Annotations of model error analysis
	// results.
	ErrorAnalysisAnnotations []*GoogleCloudAiplatformV1ErrorAnalysisAnnotation `json:"errorAnalysisAnnotations,omitempty"`

	// EvaluatedDataItemViewId: Output only. ID of the EvaluatedDataItemView
	// under the same ancestor ModelEvaluation. The EvaluatedDataItemView
	// consists of all ground truths and predictions on data_item_payload.
	EvaluatedDataItemViewId string `json:"evaluatedDataItemViewId,omitempty"`

	// Explanations: Explanations of predictions. Each element of the
	// explanations indicates the explanation for one explanation Method.
	// The attributions list in the
	// EvaluatedAnnotationExplanation.explanation object corresponds to the
	// predictions list. For example, the second element in the attributions
	// list explains the second element in the predictions list.
	Explanations []*GoogleCloudAiplatformV1EvaluatedAnnotationExplanation `json:"explanations,omitempty"`

	// GroundTruths: Output only. The ground truth Annotations, i.e. the
	// Annotations that exist in the test data the Model is evaluated on.
	// For true positive, there is one and only one ground truth annotation,
	// which matches the only prediction in predictions. For false positive,
	// there are zero or more ground truth annotations that are similar to
	// the only prediction in predictions, but not enough for a match. For
	// false negative, there is one and only one ground truth annotation,
	// which doesn't match any predictions created by the model. The schema
	// of the ground truth is stored in
	// ModelEvaluation.annotation_schema_uri
	GroundTruths []interface{} `json:"groundTruths,omitempty"`

	// Predictions: Output only. The model predicted annotations. For true
	// positive, there is one and only one prediction, which matches the
	// only one ground truth annotation in ground_truths. For false
	// positive, there is one and only one prediction, which doesn't match
	// any ground truth annotation of the corresponding data_item_view_id.
	// For false negative, there are zero or more predictions which are
	// similar to the only ground truth annotation in ground_truths but not
	// enough for a match. The schema of the prediction is stored in
	// ModelEvaluation.annotation_schema_uri
	Predictions []interface{} `json:"predictions,omitempty"`

	// Type: Output only. Type of the EvaluatedAnnotation.
	//
	// Possible values:
	//   "EVALUATED_ANNOTATION_TYPE_UNSPECIFIED" - Invalid value.
	//   "TRUE_POSITIVE" - The EvaluatedAnnotation is a true positive. It
	// has a prediction created by the Model and a ground truth Annotation
	// which the prediction matches.
	//   "FALSE_POSITIVE" - The EvaluatedAnnotation is false positive. It
	// has a prediction created by the Model which does not match any ground
	// truth annotation.
	//   "FALSE_NEGATIVE" - The EvaluatedAnnotation is false negative. It
	// has a ground truth annotation which is not matched by any of the
	// model created predictions.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataItemPayload") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataItemPayload") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1EvaluatedAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluatedAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluatedAnnotationExplanation: Explanation
// result of the prediction produced by the Model.
type GoogleCloudAiplatformV1EvaluatedAnnotationExplanation struct {
	// Explanation: Explanation attribution response details.
	Explanation *GoogleCloudAiplatformV1Explanation `json:"explanation,omitempty"`

	// ExplanationType: Explanation type. For AutoML Image Classification
	// models, possible values are: * `image-integrated-gradients` *
	// `image-xrai`
	ExplanationType string `json:"explanationType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Explanation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Explanation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1EvaluatedAnnotationExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluatedAnnotationExplanation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Event: An edge describing the relationship
// between an Artifact and an Execution in a lineage graph.
type GoogleCloudAiplatformV1Event struct {
	// Artifact: Required. The relative resource name of the Artifact in the
	// Event.
	Artifact string `json:"artifact,omitempty"`

	// EventTime: Output only. Time the Event occurred.
	EventTime string `json:"eventTime,omitempty"`

	// Execution: Output only. The relative resource name of the Execution
	// in the Event.
	Execution string `json:"execution,omitempty"`

	// Labels: The labels with user-defined metadata to annotate Events.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. No more
	// than 64 user labels can be associated with one Event (System labels
	// are excluded). See https://goo.gl/xmQnxf for more information and
	// examples of labels. System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`

	// Type: Required. The type of the Event.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified whether input or output of the
	// Execution.
	//   "INPUT" - An input of the Execution.
	//   "OUTPUT" - An output of the Execution.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Artifact") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Artifact") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Event) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Event
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Examples: Example-based explainability that
// returns the nearest neighbors from the provided dataset.
type GoogleCloudAiplatformV1Examples struct {
	// ExampleGcsSource: The Cloud Storage input instances.
	ExampleGcsSource *GoogleCloudAiplatformV1ExamplesExampleGcsSource `json:"exampleGcsSource,omitempty"`

	// NearestNeighborSearchConfig: The full configuration for the generated
	// index, the semantics are the same as metadata and should match
	// NearestNeighborSearchConfig
	// (https://cloud.google.com/vertex-ai/docs/explainable-ai/configuring-explanations-example-based#nearest-neighbor-search-config).
	NearestNeighborSearchConfig interface{} `json:"nearestNeighborSearchConfig,omitempty"`

	// NeighborCount: The number of neighbors to return when querying for
	// examples.
	NeighborCount int64 `json:"neighborCount,omitempty"`

	// Presets: Simplified preset configuration, which automatically sets
	// configuration values based on the desired query speed-precision
	// trade-off and modality.
	Presets *GoogleCloudAiplatformV1Presets `json:"presets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExampleGcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExampleGcsSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Examples) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Examples
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExamplesExampleGcsSource: The Cloud Storage
// input instances.
type GoogleCloudAiplatformV1ExamplesExampleGcsSource struct {
	// DataFormat: The format in which instances are given, if not
	// specified, assume it's JSONL format. Currently only JSONL format is
	// supported.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Format unspecified, used when unset.
	//   "JSONL" - Examples are stored in JSONL files.
	DataFormat string `json:"dataFormat,omitempty"`

	// GcsSource: The Cloud Storage location for the input instances.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataFormat") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExamplesExampleGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExamplesExampleGcsSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExamplesOverride: Overrides for example-based
// explanations.
type GoogleCloudAiplatformV1ExamplesOverride struct {
	// CrowdingCount: The number of neighbors to return that have the same
	// crowding tag.
	CrowdingCount int64 `json:"crowdingCount,omitempty"`

	// DataFormat: The format of the data being provided with each call.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format. Must not be used.
	//   "INSTANCES" - Provided data is a set of model inputs.
	//   "EMBEDDINGS" - Provided data is a set of embeddings.
	DataFormat string `json:"dataFormat,omitempty"`

	// NeighborCount: The number of neighbors to return.
	NeighborCount int64 `json:"neighborCount,omitempty"`

	// Restrictions: Restrict the resulting nearest neighbors to respect
	// these constraints.
	Restrictions []*GoogleCloudAiplatformV1ExamplesRestrictionsNamespace `json:"restrictions,omitempty"`

	// ReturnEmbeddings: If true, return the embeddings instead of
	// neighbors.
	ReturnEmbeddings bool `json:"returnEmbeddings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CrowdingCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CrowdingCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExamplesOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExamplesOverride
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExamplesRestrictionsNamespace: Restrictions
// namespace for example-based explanations overrides.
type GoogleCloudAiplatformV1ExamplesRestrictionsNamespace struct {
	// Allow: The list of allowed tags.
	Allow []string `json:"allow,omitempty"`

	// Deny: The list of deny tags.
	Deny []string `json:"deny,omitempty"`

	// NamespaceName: The namespace name.
	NamespaceName string `json:"namespaceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Allow") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Allow") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExamplesRestrictionsNamespace) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExamplesRestrictionsNamespace
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Execution: Instance of a general execution.
type GoogleCloudAiplatformV1Execution struct {
	// CreateTime: Output only. Timestamp when this Execution was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the Execution
	Description string `json:"description,omitempty"`

	// DisplayName: User provided display name of the Execution. May be up
	// to 128 Unicode characters.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: An eTag used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// Executions. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are
	// allowed. No more than 64 user labels can be associated with one
	// Execution (System labels are excluded).
	Labels map[string]string `json:"labels,omitempty"`

	// Metadata: Properties of the Execution. Top level metadata keys'
	// heading and trailing spaces will be trimmed. The size of this field
	// should not exceed 200KB.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: Output only. The resource name of the Execution.
	Name string `json:"name,omitempty"`

	// SchemaTitle: The title of the schema describing the metadata. Schema
	// title and version is expected to be registered in earlier Create
	// Schema calls. And both are used together as unique identifiers to
	// identify schemas within the local metadata store.
	SchemaTitle string `json:"schemaTitle,omitempty"`

	// SchemaVersion: The version of the schema in `schema_title` to use.
	// Schema title and version is expected to be registered in earlier
	// Create Schema calls. And both are used together as unique identifiers
	// to identify schemas within the local metadata store.
	SchemaVersion string `json:"schemaVersion,omitempty"`

	// State: The state of this Execution. This is a property of the
	// Execution, and does not imply or capture any ongoing process. This
	// property is managed by clients (such as Vertex AI Pipelines) and the
	// system does not prescribe or check the validity of state transitions.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified Execution state
	//   "NEW" - The Execution is new
	//   "RUNNING" - The Execution is running
	//   "COMPLETE" - The Execution has finished running
	//   "FAILED" - The Execution has failed
	//   "CACHED" - The Execution completed through Cache hit.
	//   "CANCELLED" - The Execution was cancelled.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. Timestamp when this Execution was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Execution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Execution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplainRequest: Request message for
// PredictionService.Explain.
type GoogleCloudAiplatformV1ExplainRequest struct {
	// DeployedModelId: If specified, this ExplainRequest will be served by
	// the chosen DeployedModel, overriding Endpoint.traffic_split.
	DeployedModelId string `json:"deployedModelId,omitempty"`

	// ExplanationSpecOverride: If specified, overrides the explanation_spec
	// of the DeployedModel. Can be used for explaining prediction results
	// with different configurations, such as: - Explaining top-5
	// predictions results as opposed to top-1; - Increasing path count or
	// step count of the attribution methods to reduce approximate errors; -
	// Using different baselines for explaining the prediction results.
	ExplanationSpecOverride *GoogleCloudAiplatformV1ExplanationSpecOverride `json:"explanationSpecOverride,omitempty"`

	// Instances: Required. The instances that are the input to the
	// explanation call. A DeployedModel may have an upper limit on the
	// number of instances it supports per request, and when it is exceeded
	// the explanation call errors in case of AutoML Models, or, in case of
	// customer created Models, the behaviour is as documented by that
	// Model. The schema of any single instance may be specified via
	// Endpoint's DeployedModels' Model's PredictSchemata's
	// instance_schema_uri.
	Instances []interface{} `json:"instances,omitempty"`

	// Parameters: The parameters that govern the prediction. The schema of
	// the parameters may be specified via Endpoint's DeployedModels'
	// Model's PredictSchemata's parameters_schema_uri.
	Parameters interface{} `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedModelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedModelId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplainRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplainRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplainResponse: Response message for
// PredictionService.Explain.
type GoogleCloudAiplatformV1ExplainResponse struct {
	// DeployedModelId: ID of the Endpoint's DeployedModel that served this
	// explanation.
	DeployedModelId string `json:"deployedModelId,omitempty"`

	// Explanations: The explanations of the Model's
	// PredictResponse.predictions. It has the same number of elements as
	// instances to be explained.
	Explanations []*GoogleCloudAiplatformV1Explanation `json:"explanations,omitempty"`

	// Predictions: The predictions that are the output of the predictions
	// call. Same as PredictResponse.predictions.
	Predictions []interface{} `json:"predictions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DeployedModelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedModelId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplainResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplainResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Explanation: Explanation of a prediction
// (provided in PredictResponse.predictions) produced by the Model on a
// given instance.
type GoogleCloudAiplatformV1Explanation struct {
	// Attributions: Output only. Feature attributions grouped by predicted
	// outputs. For Models that predict only one output, such as regression
	// Models that predict only one score, there is only one attibution that
	// explains the predicted output. For Models that predict multiple
	// outputs, such as multiclass Models that predict multiple classes,
	// each element explains one specific item. Attribution.output_index can
	// be used to identify which output this attribution is explaining. By
	// default, we provide Shapley values for the predicted class. However,
	// you can configure the explanation request to generate Shapley values
	// for any other classes too. For example, if a model predicts a
	// probability of `0.4` for approving a loan application, the model's
	// decision is to reject the application since `p(reject) = 0.6 >
	// p(approve) = 0.4`, and the default Shapley values would be computed
	// for rejection decision and not approval, even though the latter might
	// be the positive class. If users set ExplanationParameters.top_k, the
	// attributions are sorted by instance_output_value in descending order.
	// If ExplanationParameters.output_indices is specified, the
	// attributions are stored by Attribution.output_index in the same order
	// as they appear in the output_indices.
	Attributions []*GoogleCloudAiplatformV1Attribution `json:"attributions,omitempty"`

	// Neighbors: Output only. List of the nearest neighbors for
	// example-based explanations. For models deployed with the examples
	// explanations feature enabled, the attributions field is empty and
	// instead the neighbors field is populated.
	Neighbors []*GoogleCloudAiplatformV1Neighbor `json:"neighbors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attributions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Explanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Explanation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadata: Metadata describing the
// Model's input and output for explanation.
type GoogleCloudAiplatformV1ExplanationMetadata struct {
	// FeatureAttributionsSchemaUri: Points to a YAML file stored on Google
	// Cloud Storage describing the format of the feature attributions. The
	// schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// AutoML tabular Models always have this field populated by Vertex AI.
	// Note: The URI given on output may be different, including the URI
	// scheme, than the one given on input. The output URI will point to a
	// location where the user only has a read access.
	FeatureAttributionsSchemaUri string `json:"featureAttributionsSchemaUri,omitempty"`

	// Inputs: Required. Map from feature names to feature input metadata.
	// Keys are the name of the features. Values are the specification of
	// the feature. An empty InputMetadata is valid. It describes a text
	// feature which has the name specified as the key in
	// ExplanationMetadata.inputs. The baseline of the empty feature is
	// chosen by Vertex AI. For Vertex AI-provided Tensorflow images, the
	// key can be any friendly name of the feature. Once specified,
	// featureAttributions are keyed by this key (if not grouped with
	// another feature). For custom images, the key must match with the key
	// in instance.
	Inputs map[string]GoogleCloudAiplatformV1ExplanationMetadataInputMetadata `json:"inputs,omitempty"`

	// LatentSpaceSource: Name of the source to generate embeddings for
	// example based explanations.
	LatentSpaceSource string `json:"latentSpaceSource,omitempty"`

	// Outputs: Required. Map from output names to output metadata. For
	// Vertex AI-provided Tensorflow images, keys can be any user defined
	// string that consists of any UTF-8 characters. For custom images, keys
	// are the name of the output field in the prediction to be explained.
	// Currently only one key is allowed.
	Outputs map[string]GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata `json:"outputs,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "FeatureAttributionsSchemaUri") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "FeatureAttributionsSchemaUri") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadataInputMetadata: Metadata of
// the input of a feature. Fields other than
// InputMetadata.input_baselines are applicable only for Models that are
// using Vertex AI-provided images for Tensorflow.
type GoogleCloudAiplatformV1ExplanationMetadataInputMetadata struct {
	// DenseShapeTensorName: Specifies the shape of the values of the input
	// if the input is a sparse representation. Refer to Tensorflow
	// documentation for more details:
	// https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
	DenseShapeTensorName string `json:"denseShapeTensorName,omitempty"`

	// EncodedBaselines: A list of baselines for the encoded tensor. The
	// shape of each baseline should match the shape of the encoded tensor.
	// If a scalar is provided, Vertex AI broadcasts to the same shape as
	// the encoded tensor.
	EncodedBaselines []interface{} `json:"encodedBaselines,omitempty"`

	// EncodedTensorName: Encoded tensor is a transformation of the input
	// tensor. Must be provided if choosing Integrated Gradients attribution
	// or XRAI attribution and the input tensor is not differentiable. An
	// encoded tensor is generated if the input tensor is encoded by a
	// lookup table.
	EncodedTensorName string `json:"encodedTensorName,omitempty"`

	// Encoding: Defines how the feature is encoded into the input tensor.
	// Defaults to IDENTITY.
	//
	// Possible values:
	//   "ENCODING_UNSPECIFIED" - Default value. This is the same as
	// IDENTITY.
	//   "IDENTITY" - The tensor represents one feature.
	//   "BAG_OF_FEATURES" - The tensor represents a bag of features where
	// each index maps to a feature. InputMetadata.index_feature_mapping
	// must be provided for this encoding. For example: ``` input = [27,
	// 6.0, 150] index_feature_mapping = ["age", "height", "weight"] ```
	//   "BAG_OF_FEATURES_SPARSE" - The tensor represents a bag of features
	// where each index maps to a feature. Zero values in the tensor
	// indicates feature being non-existent.
	// InputMetadata.index_feature_mapping must be provided for this
	// encoding. For example: ``` input = [2, 0, 5, 0, 1]
	// index_feature_mapping = ["a", "b", "c", "d", "e"] ```
	//   "INDICATOR" - The tensor is a list of binaries representing whether
	// a feature exists or not (1 indicates existence).
	// InputMetadata.index_feature_mapping must be provided for this
	// encoding. For example: ``` input = [1, 0, 1, 0, 1]
	// index_feature_mapping = ["a", "b", "c", "d", "e"] ```
	//   "COMBINED_EMBEDDING" - The tensor is encoded into a 1-dimensional
	// array represented by an encoded tensor.
	// InputMetadata.encoded_tensor_name must be provided for this encoding.
	// For example: ``` input = ["This", "is", "a", "test", "."] encoded =
	// [0.1, 0.2, 0.3, 0.4, 0.5] ```
	//   "CONCAT_EMBEDDING" - Select this encoding when the input tensor is
	// encoded into a 2-dimensional array represented by an encoded tensor.
	// InputMetadata.encoded_tensor_name must be provided for this encoding.
	// The first dimension of the encoded tensor's shape is the same as the
	// input tensor's shape. For example: ``` input = ["This", "is", "a",
	// "test", "."] encoded = [[0.1, 0.2, 0.3, 0.4, 0.5], [0.2, 0.1, 0.4,
	// 0.3, 0.5], [0.5, 0.1, 0.3, 0.5, 0.4], [0.5, 0.3, 0.1, 0.2, 0.4],
	// [0.4, 0.3, 0.2, 0.5, 0.1]] ```
	Encoding string `json:"encoding,omitempty"`

	// FeatureValueDomain: The domain details of the input feature value.
	// Like min/max, original mean or standard deviation if normalized.
	FeatureValueDomain *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain `json:"featureValueDomain,omitempty"`

	// GroupName: Name of the group that the input belongs to. Features with
	// the same group name will be treated as one feature when computing
	// attributions. Features grouped together can have different shapes in
	// value. If provided, there will be one single attribution generated in
	// Attribution.feature_attributions, keyed by the group name.
	GroupName string `json:"groupName,omitempty"`

	// IndexFeatureMapping: A list of feature names for each index in the
	// input tensor. Required when the input InputMetadata.encoding is
	// BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
	IndexFeatureMapping []string `json:"indexFeatureMapping,omitempty"`

	// IndicesTensorName: Specifies the index of the values of the input
	// tensor. Required when the input tensor is a sparse representation.
	// Refer to Tensorflow documentation for more details:
	// https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
	IndicesTensorName string `json:"indicesTensorName,omitempty"`

	// InputBaselines: Baseline inputs for this feature. If no baseline is
	// specified, Vertex AI chooses the baseline for this feature. If
	// multiple baselines are specified, Vertex AI returns the average
	// attributions across them in Attribution.feature_attributions. For
	// Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape of
	// each baseline must match the shape of the input tensor. If a scalar
	// is provided, we broadcast to the same shape as the input tensor. For
	// custom images, the element of the baselines must be in the same
	// format as the feature's input in the instance[]. The schema of any
	// single instance may be specified via Endpoint's DeployedModels'
	// Model's PredictSchemata's instance_schema_uri.
	InputBaselines []interface{} `json:"inputBaselines,omitempty"`

	// InputTensorName: Name of the input tensor for this feature. Required
	// and is only applicable to Vertex AI-provided images for Tensorflow.
	InputTensorName string `json:"inputTensorName,omitempty"`

	// Modality: Modality of the feature. Valid values are: numeric, image.
	// Defaults to numeric.
	Modality string `json:"modality,omitempty"`

	// Visualization: Visualization configurations for image explanation.
	Visualization *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization `json:"visualization,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DenseShapeTensorName") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DenseShapeTensorName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataInputMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDom
// ain: Domain details of the input feature value. Provides numeric
// information about the feature, such as its range (min, max). If the
// feature has been pre-processed, for example with z-scoring, then it
// provides information about how to recover the original feature. For
// example, if the input feature is an image and it has been
// pre-processed to obtain 0-mean and stddev = 1 values, then
// original_mean, and original_stddev refer to the mean and stddev of
// the original feature (e.g. image tensor) from which input feature
// (with mean = 0 and stddev = 1) was obtained.
type GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain struct {
	// MaxValue: The maximum permissible value for this feature.
	MaxValue float64 `json:"maxValue,omitempty"`

	// MinValue: The minimum permissible value for this feature.
	MinValue float64 `json:"minValue,omitempty"`

	// OriginalMean: If this input feature has been normalized to a mean
	// value of 0, the original_mean specifies the mean value of the domain
	// prior to normalization.
	OriginalMean float64 `json:"originalMean,omitempty"`

	// OriginalStddev: If this input feature has been normalized to a
	// standard deviation of 1.0, the original_stddev specifies the standard
	// deviation of the domain prior to normalization.
	OriginalStddev float64 `json:"originalStddev,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxValue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain
	var s1 struct {
		MaxValue       gensupport.JSONFloat64 `json:"maxValue"`
		MinValue       gensupport.JSONFloat64 `json:"minValue"`
		OriginalMean   gensupport.JSONFloat64 `json:"originalMean"`
		OriginalStddev gensupport.JSONFloat64 `json:"originalStddev"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxValue = float64(s1.MaxValue)
	s.MinValue = float64(s1.MinValue)
	s.OriginalMean = float64(s1.OriginalMean)
	s.OriginalStddev = float64(s1.OriginalStddev)
	return nil
}

// GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization:
// Visualization configurations for image explanation.
type GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization struct {
	// ClipPercentLowerbound: Excludes attributions below the specified
	// percentile, from the highlighted areas. Defaults to 62.
	ClipPercentLowerbound float64 `json:"clipPercentLowerbound,omitempty"`

	// ClipPercentUpperbound: Excludes attributions above the specified
	// percentile from the highlighted areas. Using the
	// clip_percent_upperbound and clip_percent_lowerbound together can be
	// useful for filtering out noise and making it easier to see areas of
	// strong attribution. Defaults to 99.9.
	ClipPercentUpperbound float64 `json:"clipPercentUpperbound,omitempty"`

	// ColorMap: The color scheme used for the highlighted areas. Defaults
	// to PINK_GREEN for Integrated Gradients attribution, which shows
	// positive attributions in green and negative in pink. Defaults to
	// VIRIDIS for XRAI attribution, which highlights the most influential
	// regions in yellow and the least influential in blue.
	//
	// Possible values:
	//   "COLOR_MAP_UNSPECIFIED" - Should not be used.
	//   "PINK_GREEN" - Positive: green. Negative: pink.
	//   "VIRIDIS" - Viridis color map: A perceptually uniform color mapping
	// which is easier to see by those with colorblindness and progresses
	// from yellow to green to blue. Positive: yellow. Negative: blue.
	//   "RED" - Positive: red. Negative: red.
	//   "GREEN" - Positive: green. Negative: green.
	//   "RED_GREEN" - Positive: green. Negative: red.
	//   "PINK_WHITE_GREEN" - PiYG palette.
	ColorMap string `json:"colorMap,omitempty"`

	// OverlayType: How the original image is displayed in the
	// visualization. Adjusting the overlay can help increase visual clarity
	// if the original image makes it difficult to view the visualization.
	// Defaults to NONE.
	//
	// Possible values:
	//   "OVERLAY_TYPE_UNSPECIFIED" - Default value. This is the same as
	// NONE.
	//   "NONE" - No overlay.
	//   "ORIGINAL" - The attributions are shown on top of the original
	// image.
	//   "GRAYSCALE" - The attributions are shown on top of grayscaled
	// version of the original image.
	//   "MASK_BLACK" - The attributions are used as a mask to reveal
	// predictive parts of the image and hide the un-predictive parts.
	OverlayType string `json:"overlayType,omitempty"`

	// Polarity: Whether to only highlight pixels with positive
	// contributions, negative or both. Defaults to POSITIVE.
	//
	// Possible values:
	//   "POLARITY_UNSPECIFIED" - Default value. This is the same as
	// POSITIVE.
	//   "POSITIVE" - Highlights the pixels/outlines that were most
	// influential to the model's prediction.
	//   "NEGATIVE" - Setting polarity to negative highlights areas that
	// does not lead to the models's current prediction.
	//   "BOTH" - Shows both positive and negative attributions.
	Polarity string `json:"polarity,omitempty"`

	// Type: Type of the image visualization. Only applicable to Integrated
	// Gradients attribution. OUTLINES shows regions of attribution, while
	// PIXELS shows per-pixel attribution. Defaults to OUTLINES.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Should not be used.
	//   "PIXELS" - Shows which pixel contributed to the image prediction.
	//   "OUTLINES" - Shows which region contributed to the image prediction
	// by outlining the region.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ClipPercentLowerbound") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClipPercentLowerbound") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization
	var s1 struct {
		ClipPercentLowerbound gensupport.JSONFloat64 `json:"clipPercentLowerbound"`
		ClipPercentUpperbound gensupport.JSONFloat64 `json:"clipPercentUpperbound"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClipPercentLowerbound = float64(s1.ClipPercentLowerbound)
	s.ClipPercentUpperbound = float64(s1.ClipPercentUpperbound)
	return nil
}

// GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata: Metadata of
// the prediction output to be explained.
type GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata struct {
	// DisplayNameMappingKey: Specify a field name in the prediction to look
	// for the display name. Use this if the prediction contains the display
	// names for the outputs. The display names in the prediction must have
	// the same shape of the outputs, so that it can be located by
	// Attribution.output_index for a specific output.
	DisplayNameMappingKey string `json:"displayNameMappingKey,omitempty"`

	// IndexDisplayNameMapping: Static mapping between the index and display
	// name. Use this if the outputs are a deterministic n-dimensional
	// array, e.g. a list of scores of all the classes in a pre-defined
	// order for a multi-classification Model. It's not feasible if the
	// outputs are non-deterministic, e.g. the Model produces top-k classes
	// or sort the outputs by their values. The shape of the value must be
	// an n-dimensional array of strings. The number of dimensions must
	// match that of the outputs to be explained. The
	// Attribution.output_display_name is populated by locating in the
	// mapping with Attribution.output_index.
	IndexDisplayNameMapping interface{} `json:"indexDisplayNameMapping,omitempty"`

	// OutputTensorName: Name of the output tensor. Required and is only
	// applicable to Vertex AI provided images for Tensorflow.
	OutputTensorName string `json:"outputTensorName,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DisplayNameMappingKey") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayNameMappingKey") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadataOverride: The
// ExplanationMetadata entries that can be overridden at online
// explanation time.
type GoogleCloudAiplatformV1ExplanationMetadataOverride struct {
	// Inputs: Required. Overrides the input metadata of the features. The
	// key is the name of the feature to be overridden. The keys specified
	// here must exist in the input metadata to be overridden. If a feature
	// is not specified here, the corresponding feature's input metadata is
	// not overridden.
	Inputs map[string]GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride `json:"inputs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Inputs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Inputs") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataOverride
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverrid
// e: The input metadata entries to be overridden.
type GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride struct {
	// InputBaselines: Baseline inputs for this feature. This overrides the
	// `input_baseline` field of the ExplanationMetadata.InputMetadata
	// object of the corresponding feature's input metadata. If it's not
	// specified, the original baselines are not overridden.
	InputBaselines []interface{} `json:"inputBaselines,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputBaselines") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputBaselines") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationParameters: Parameters to configure
// explaining for Model's predictions.
type GoogleCloudAiplatformV1ExplanationParameters struct {
	// Examples: Example-based explanations that returns the nearest
	// neighbors from the provided dataset.
	Examples *GoogleCloudAiplatformV1Examples `json:"examples,omitempty"`

	// IntegratedGradientsAttribution: An attribution method that computes
	// Aumann-Shapley values taking advantage of the model's fully
	// differentiable structure. Refer to this paper for more details:
	// https://arxiv.org/abs/1703.01365
	IntegratedGradientsAttribution *GoogleCloudAiplatformV1IntegratedGradientsAttribution `json:"integratedGradientsAttribution,omitempty"`

	// OutputIndices: If populated, only returns attributions that have
	// output_index contained in output_indices. It must be an ndarray of
	// integers, with the same shape of the output it's explaining. If not
	// populated, returns attributions for top_k indices of outputs. If
	// neither top_k nor output_indices is populated, returns the argmax
	// index of the outputs. Only applicable to Models that predict multiple
	// outputs (e,g, multi-class Models that predict multiple classes).
	OutputIndices []interface{} `json:"outputIndices,omitempty"`

	// SampledShapleyAttribution: An attribution method that approximates
	// Shapley values for features that contribute to the label being
	// predicted. A sampling strategy is used to approximate the value
	// rather than considering all subsets of features. Refer to this paper
	// for model details: https://arxiv.org/abs/1306.4265.
	SampledShapleyAttribution *GoogleCloudAiplatformV1SampledShapleyAttribution `json:"sampledShapleyAttribution,omitempty"`

	// TopK: If populated, returns attributions for top K indices of outputs
	// (defaults to 1). Only applies to Models that predicts more than one
	// outputs (e,g, multi-class Models). When set to -1, returns
	// explanations for all outputs.
	TopK int64 `json:"topK,omitempty"`

	// XraiAttribution: An attribution method that redistributes Integrated
	// Gradients attribution to segmented regions, taking advantage of the
	// model's fully differentiable structure. Refer to this paper for more
	// details: https://arxiv.org/abs/1906.02825 XRAI currently performs
	// better on natural images, like a picture of a house or an animal. If
	// the images are taken in artificial environments, like a lab or
	// manufacturing line, or from diagnostic equipment, like x-rays or
	// quality-control cameras, use Integrated Gradients instead.
	XraiAttribution *GoogleCloudAiplatformV1XraiAttribution `json:"xraiAttribution,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Examples") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationParameters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationSpec: Specification of Model
// explanation.
type GoogleCloudAiplatformV1ExplanationSpec struct {
	// Metadata: Optional. Metadata describing the Model's input and output
	// for explanation.
	Metadata *GoogleCloudAiplatformV1ExplanationMetadata `json:"metadata,omitempty"`

	// Parameters: Required. Parameters that configure explaining of the
	// Model's predictions.
	Parameters *GoogleCloudAiplatformV1ExplanationParameters `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationSpecOverride: The ExplanationSpec
// entries that can be overridden at online explanation time.
type GoogleCloudAiplatformV1ExplanationSpecOverride struct {
	// ExamplesOverride: The example-based explanations parameter overrides.
	ExamplesOverride *GoogleCloudAiplatformV1ExamplesOverride `json:"examplesOverride,omitempty"`

	// Metadata: The metadata to be overridden. If not specified, no
	// metadata is overridden.
	Metadata *GoogleCloudAiplatformV1ExplanationMetadataOverride `json:"metadata,omitempty"`

	// Parameters: The parameters to be overridden. Note that the
	// attribution method cannot be changed. If not specified, no parameter
	// is overridden.
	Parameters *GoogleCloudAiplatformV1ExplanationParameters `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExamplesOverride") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExamplesOverride") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExplanationSpecOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationSpecOverride
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportDataConfig: Describes what part of the
// Dataset is to be exported, the destination of the export and how to
// export.
type GoogleCloudAiplatformV1ExportDataConfig struct {
	// AnnotationSchemaUri: The Cloud Storage URI that points to a YAML file
	// describing the annotation schema. The schema is defined as an OpenAPI
	// 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// The schema files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/annotation/, note that
	// the chosen schema must be consistent with metadata of the Dataset
	// specified by dataset_id. Only used for custom training data export
	// use cases. Only applicable to Datasets that have DataItems and
	// Annotations. Only Annotations that both match this schema and belong
	// to DataItems not ignored by the split method are used in respectively
	// training, validation or test role, depending on the role of the
	// DataItem they are on. When used in conjunction with
	// annotations_filter, the Annotations used for training are filtered by
	// both annotations_filter and annotation_schema_uri.
	AnnotationSchemaUri string `json:"annotationSchemaUri,omitempty"`

	// AnnotationsFilter: An expression for filtering what part of the
	// Dataset is to be exported. Only Annotations that match this filter
	// will be exported. The filter syntax is the same as in
	// ListAnnotations.
	AnnotationsFilter string `json:"annotationsFilter,omitempty"`

	// ExportUse: Indicates the usage of the exported files.
	//
	// Possible values:
	//   "EXPORT_USE_UNSPECIFIED" - Regular user export.
	//   "CUSTOM_CODE_TRAINING" - Export for custom code training.
	ExportUse string `json:"exportUse,omitempty"`

	// FilterSplit: Split based on the provided filters for each set.
	FilterSplit *GoogleCloudAiplatformV1ExportFilterSplit `json:"filterSplit,omitempty"`

	// FractionSplit: Split based on fractions defining the size of each
	// set.
	FractionSplit *GoogleCloudAiplatformV1ExportFractionSplit `json:"fractionSplit,omitempty"`

	// GcsDestination: The Google Cloud Storage location where the output is
	// to be written to. In the given directory a new directory will be
	// created with name: `export-data--` where timestamp is in
	// YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export output will be
	// written into that directory. Inside that directory, annotations with
	// the same schema will be grouped into sub directories which are named
	// with the corresponding annotations' schema title. Inside these sub
	// directories, a schema.yaml will be created to describe the output
	// format.
	GcsDestination *GoogleCloudAiplatformV1GcsDestination `json:"gcsDestination,omitempty"`

	// SavedQueryId: The ID of a SavedQuery (annotation set) under the
	// Dataset specified by dataset_id used for filtering Annotations for
	// training. Only used for custom training data export use cases. Only
	// applicable to Datasets that have SavedQueries. Only Annotations that
	// are associated with this SavedQuery are used in respectively
	// training. When used in conjunction with annotations_filter, the
	// Annotations used for training are filtered by both saved_query_id and
	// annotations_filter. Only one of saved_query_id and
	// annotation_schema_uri should be specified as both of them represent
	// the same thing: problem type.
	SavedQueryId string `json:"savedQueryId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnnotationSchemaUri")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotationSchemaUri") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportDataConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportDataOperationMetadata: Runtime operation
// information for DatasetService.ExportData.
type GoogleCloudAiplatformV1ExportDataOperationMetadata struct {
	// GcsOutputDirectory: A Google Cloud Storage directory which path ends
	// with '/'. The exported data is stored in the directory.
	GcsOutputDirectory string `json:"gcsOutputDirectory,omitempty"`

	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsOutputDirectory")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsOutputDirectory") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportDataOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportDataRequest: Request message for
// DatasetService.ExportData.
type GoogleCloudAiplatformV1ExportDataRequest struct {
	// ExportConfig: Required. The desired output location.
	ExportConfig *GoogleCloudAiplatformV1ExportDataConfig `json:"exportConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExportConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExportConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportDataRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportDataResponse: Response message for
// DatasetService.ExportData.
type GoogleCloudAiplatformV1ExportDataResponse struct {
	// DataStats: Only present for custom code training export use case.
	// Records data stats, i.e., train/validation/test item/annotation
	// counts calculated during the export operation.
	DataStats *GoogleCloudAiplatformV1ModelDataStats `json:"dataStats,omitempty"`

	// ExportedFiles: All of the files that are exported in this export
	// operation. For custom code training export, only three (training,
	// validation and test) Cloud Storage paths in wildcard format are
	// populated (for example, gs://.../training-*).
	ExportedFiles []string `json:"exportedFiles,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataStats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataStats") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportDataResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata: Details
// of operations that exports Features values.
type GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore export Feature
	// values.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesRequest: Request message
// for FeaturestoreService.ExportFeatureValues.
type GoogleCloudAiplatformV1ExportFeatureValuesRequest struct {
	// Destination: Required. Specifies destination location and format.
	Destination *GoogleCloudAiplatformV1FeatureValueDestination `json:"destination,omitempty"`

	// FeatureSelector: Required. Selects Features to export values of.
	FeatureSelector *GoogleCloudAiplatformV1FeatureSelector `json:"featureSelector,omitempty"`

	// FullExport: Exports all historical values of all entities of the
	// EntityType within a time range
	FullExport *GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport `json:"fullExport,omitempty"`

	// Settings: Per-Feature export settings.
	Settings []*GoogleCloudAiplatformV1DestinationFeatureSetting `json:"settings,omitempty"`

	// SnapshotExport: Exports the latest Feature values of all entities of
	// the EntityType within a time range.
	SnapshotExport *GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport `json:"snapshotExport,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Destination") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFeatureValuesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport:
// Describes exporting all historical Feature values of all entities of
// the EntityType between [start_time, end_time].
type GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport struct {
	// EndTime: Exports Feature values as of this timestamp. If not set,
	// retrieve values as of now. Timestamp, if present, must not have
	// higher than millisecond precision.
	EndTime string `json:"endTime,omitempty"`

	// StartTime: Excludes Feature values with feature generation timestamp
	// before this timestamp. If not set, retrieve oldest values kept in
	// Feature Store. Timestamp, if present, must not have higher than
	// millisecond precision.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport:
// Describes exporting the latest Feature values of all entities of the
// EntityType between [start_time, snapshot_time].
type GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport struct {
	// SnapshotTime: Exports Feature values as of this timestamp. If not
	// set, retrieve values as of now. Timestamp, if present, must not have
	// higher than millisecond precision.
	SnapshotTime string `json:"snapshotTime,omitempty"`

	// StartTime: Excludes Feature values with feature generation timestamp
	// before this timestamp. If not set, retrieve oldest values kept in
	// Feature Store. Timestamp, if present, must not have higher than
	// millisecond precision.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SnapshotTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SnapshotTime") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesResponse: Response message
// for FeaturestoreService.ExportFeatureValues.
type GoogleCloudAiplatformV1ExportFeatureValuesResponse struct {
}

// GoogleCloudAiplatformV1ExportFilterSplit: Assigns input data to
// training, validation, and test sets based on the given filters, data
// pieces not matched by any filter are ignored. Currently only
// supported for Datasets containing DataItems. If any of the filters in
// this message are to match nothing, then they can be set as '-' (the
// minus sign). Supported only for unstructured Datasets.
type GoogleCloudAiplatformV1ExportFilterSplit struct {
	// TestFilter: Required. A filter on DataItems of the Dataset. DataItems
	// that match this filter are used to test the Model. A filter with same
	// syntax as the one used in DatasetService.ListDataItems may be used.
	// If a single DataItem is matched by more than one of the FilterSplit
	// filters, then it is assigned to the first set that applies to it in
	// the training, validation, test order.
	TestFilter string `json:"testFilter,omitempty"`

	// TrainingFilter: Required. A filter on DataItems of the Dataset.
	// DataItems that match this filter are used to train the Model. A
	// filter with same syntax as the one used in
	// DatasetService.ListDataItems may be used. If a single DataItem is
	// matched by more than one of the FilterSplit filters, then it is
	// assigned to the first set that applies to it in the training,
	// validation, test order.
	TrainingFilter string `json:"trainingFilter,omitempty"`

	// ValidationFilter: Required. A filter on DataItems of the Dataset.
	// DataItems that match this filter are used to validate the Model. A
	// filter with same syntax as the one used in
	// DatasetService.ListDataItems may be used. If a single DataItem is
	// matched by more than one of the FilterSplit filters, then it is
	// assigned to the first set that applies to it in the training,
	// validation, test order.
	ValidationFilter string `json:"validationFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TestFilter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TestFilter") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportFilterSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFilterSplit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFractionSplit: Assigns the input data to
// training, validation, and test sets as per the given fractions. Any
// of `training_fraction`, `validation_fraction` and `test_fraction` may
// optionally be provided, they must sum to up to 1. If the provided
// ones sum to less than 1, the remainder is assigned to sets as decided
// by Vertex AI. If none of the fractions are set, by default roughly
// 80% of data is used for training, 10% for validation, and 10% for
// test.
type GoogleCloudAiplatformV1ExportFractionSplit struct {
	// TestFraction: The fraction of the input data that is to be used to
	// evaluate the Model.
	TestFraction float64 `json:"testFraction,omitempty"`

	// TrainingFraction: The fraction of the input data that is to be used
	// to train the Model.
	TrainingFraction float64 `json:"trainingFraction,omitempty"`

	// ValidationFraction: The fraction of the input data that is to be used
	// to validate the Model.
	ValidationFraction float64 `json:"validationFraction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TestFraction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TestFraction") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportFractionSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFractionSplit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ExportFractionSplit) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ExportFractionSplit
	var s1 struct {
		TestFraction       gensupport.JSONFloat64 `json:"testFraction"`
		TrainingFraction   gensupport.JSONFloat64 `json:"trainingFraction"`
		ValidationFraction gensupport.JSONFloat64 `json:"validationFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TestFraction = float64(s1.TestFraction)
	s.TrainingFraction = float64(s1.TrainingFraction)
	s.ValidationFraction = float64(s1.ValidationFraction)
	return nil
}

// GoogleCloudAiplatformV1ExportModelOperationMetadata: Details of
// ModelService.ExportModel operation.
type GoogleCloudAiplatformV1ExportModelOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// OutputInfo: Output only. Information further describing the output of
	// this Model export.
	OutputInfo *GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo `json:"outputInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportModelOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo:
// Further describes the output of the ExportModel. Supplements
// ExportModelRequest.OutputConfig.
type GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo struct {
	// ArtifactOutputUri: Output only. If the Model artifact is being
	// exported to Google Cloud Storage this is the full path of the
	// directory created, into which the Model files are being written to.
	ArtifactOutputUri string `json:"artifactOutputUri,omitempty"`

	// ImageOutputUri: Output only. If the Model image is being exported to
	// Google Container Registry or Artifact Registry this is the full path
	// of the image created.
	ImageOutputUri string `json:"imageOutputUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ArtifactOutputUri")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArtifactOutputUri") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportModelRequest: Request message for
// ModelService.ExportModel.
type GoogleCloudAiplatformV1ExportModelRequest struct {
	// OutputConfig: Required. The desired output location and
	// configuration.
	OutputConfig *GoogleCloudAiplatformV1ExportModelRequestOutputConfig `json:"outputConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OutputConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OutputConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportModelRequestOutputConfig: Output
// configuration for the Model export.
type GoogleCloudAiplatformV1ExportModelRequestOutputConfig struct {
	// ArtifactDestination: The Cloud Storage location where the Model
	// artifact is to be written to. Under the directory given as the
	// destination a new one with name "model-export--", where timestamp
	// is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format, will be created.
	// Inside, the Model and any of its supporting files will be written.
	// This field should only be set when the `exportableContent` field of
	// the [Model.supported_export_formats] object contains `ARTIFACT`.
	ArtifactDestination *GoogleCloudAiplatformV1GcsDestination `json:"artifactDestination,omitempty"`

	// ExportFormatId: The ID of the format in which the Model must be
	// exported. Each Model lists the export formats it supports. If no
	// value is provided here, then the first from the list of the Model's
	// supported formats is used by default.
	ExportFormatId string `json:"exportFormatId,omitempty"`

	// ImageDestination: The Google Container Registry or Artifact Registry
	// uri where the Model container image will be copied to. This field
	// should only be set when the `exportableContent` field of the
	// [Model.supported_export_formats] object contains `IMAGE`.
	ImageDestination *GoogleCloudAiplatformV1ContainerRegistryDestination `json:"imageDestination,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ArtifactDestination")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArtifactDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportModelRequestOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportModelRequestOutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportModelResponse: Response message of
// ModelService.ExportModel operation.
type GoogleCloudAiplatformV1ExportModelResponse struct {
}

// GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest:
// Request message for
// TensorboardService.ExportTensorboardTimeSeriesData.
type GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest struct {
	// Filter: Exports the TensorboardTimeSeries' data that match the filter
	// expression.
	Filter string `json:"filter,omitempty"`

	// OrderBy: Field to use to sort the TensorboardTimeSeries' data. By
	// default, TensorboardTimeSeries' data is returned in a pseudo random
	// order.
	OrderBy string `json:"orderBy,omitempty"`

	// PageSize: The maximum number of data points to return per page. The
	// default page_size is 1000. Values must be between 1 and 10000. Values
	// above 10000 are coerced to 10000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous
	// ExportTensorboardTimeSeriesData call. Provide this to retrieve the
	// subsequent page. When paginating, all other parameters provided to
	// ExportTensorboardTimeSeriesData must match the call that provided the
	// page token.
	PageToken string `json:"pageToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse:
// Response message for
// TensorboardService.ExportTensorboardTimeSeriesData.
type GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse struct {
	// NextPageToken: A token, which can be sent as page_token to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TimeSeriesDataPoints: The returned time series data points.
	TimeSeriesDataPoints []*GoogleCloudAiplatformV1TimeSeriesDataPoint `json:"timeSeriesDataPoints,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Feature: Feature Metadata information. For
// example, color is a feature that describes an apple.
type GoogleCloudAiplatformV1Feature struct {
	// CreateTime: Output only. Only applicable for Vertex AI Feature Store
	// (Legacy). Timestamp when this EntityType was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the Feature.
	Description string `json:"description,omitempty"`

	// DisableMonitoring: Optional. Only applicable for Vertex AI Feature
	// Store (Legacy). If not set, use the monitoring_config defined for the
	// EntityType this Feature belongs to. Only Features with type
	// (Feature.ValueType) BOOL, STRING, DOUBLE or INT64 can enable
	// monitoring. If set to true, all types of data monitoring are disabled
	// despite the config on EntityType.
	DisableMonitoring bool `json:"disableMonitoring,omitempty"`

	// Etag: Used to perform a consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. The labels with user-defined metadata to organize
	// your Features. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. See https://goo.gl/xmQnxf for more information on and
	// examples of labels. No more than 64 user labels can be associated
	// with one Feature (System labels are excluded)." System reserved label
	// keys are prefixed with "aiplatform.googleapis.com/" and are
	// immutable.
	Labels map[string]string `json:"labels,omitempty"`

	// MonitoringStatsAnomalies: Output only. Only applicable for Vertex AI
	// Feature Store (Legacy). The list of historical stats and anomalies
	// with specified objectives.
	MonitoringStatsAnomalies []*GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly `json:"monitoringStatsAnomalies,omitempty"`

	// Name: Immutable. Name of the Feature. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/
	// entityTypes/{entity_type}/features/{feature}`
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}
	// /features/{feature}` The last part feature is assigned by the client.
	// The feature can be up to 64 characters long and can consist only of
	// ASCII Latin letters A-Z and a-z, underscore(_), and ASCII digits 0-9
	// starting with a letter. The value will be unique given an entity
	// type.
	Name string `json:"name,omitempty"`

	// PointOfContact: Entity responsible for maintaining this feature. Can
	// be comma separated list of email addresses or URIs.
	PointOfContact string `json:"pointOfContact,omitempty"`

	// UpdateTime: Output only. Only applicable for Vertex AI Feature Store
	// (Legacy). Timestamp when this EntityType was most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ValueType: Immutable. Only applicable for Vertex AI Feature Store
	// (Legacy). Type of Feature value.
	//
	// Possible values:
	//   "VALUE_TYPE_UNSPECIFIED" - The value type is unspecified.
	//   "BOOL" - Used for Feature that is a boolean.
	//   "BOOL_ARRAY" - Used for Feature that is a list of boolean.
	//   "DOUBLE" - Used for Feature that is double.
	//   "DOUBLE_ARRAY" - Used for Feature that is a list of double.
	//   "INT64" - Used for Feature that is INT64.
	//   "INT64_ARRAY" - Used for Feature that is a list of INT64.
	//   "STRING" - Used for Feature that is string.
	//   "STRING_ARRAY" - Used for Feature that is a list of String.
	//   "BYTES" - Used for Feature that is bytes.
	ValueType string `json:"valueType,omitempty"`

	// VersionColumnName: Only applicable for Vertex AI Feature Store. The
	// name of the BigQuery Table/View column hosting data for this version.
	// If no value is provided, will use feature_id.
	VersionColumnName string `json:"versionColumnName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Feature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Feature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureGroup: Vertex AI Feature Group.
type GoogleCloudAiplatformV1FeatureGroup struct {
	// BigQuery: Indicates that features for this group come from BigQuery
	// Table/View. By default treats the source as a sparse time series
	// source, which is required to have an entity_id and a
	// feature_timestamp column in the source.
	BigQuery *GoogleCloudAiplatformV1FeatureGroupBigQuery `json:"bigQuery,omitempty"`

	// CreateTime: Output only. Timestamp when this FeatureGroup was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the FeatureGroup.
	Description string `json:"description,omitempty"`

	// Etag: Optional. Used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. The labels with user-defined metadata to organize
	// your FeatureGroup. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. See https://goo.gl/xmQnxf for more information on and
	// examples of labels. No more than 64 user labels can be associated
	// with one FeatureGroup(System labels are excluded)." System reserved
	// label keys are prefixed with "aiplatform.googleapis.com/" and are
	// immutable.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Identifier. Name of the FeatureGroup. Format:
	// `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. Timestamp when this FeatureGroup was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BigQuery") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQuery") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureGroupBigQuery: Input source type for
// BigQuery Tables and Views.
type GoogleCloudAiplatformV1FeatureGroupBigQuery struct {
	// BigQuerySource: Required. Immutable. The BigQuery source URI that
	// points to either a BigQuery Table or View.
	BigQuerySource *GoogleCloudAiplatformV1BigQuerySource `json:"bigQuerySource,omitempty"`

	// EntityIdColumns: Optional. Columns to construct entity_id / row keys.
	// If not provided defaults to `entity_id`.
	EntityIdColumns []string `json:"entityIdColumns,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQuerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureGroupBigQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureGroupBigQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly: A list of
// historical SnapshotAnalysis or ImportFeaturesAnalysis stats requested
// by user, sorted by FeatureStatsAnomaly.start_time descending.
type GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly struct {
	// FeatureStatsAnomaly: Output only. The stats and anomalies generated
	// at specific timestamp.
	FeatureStatsAnomaly *GoogleCloudAiplatformV1FeatureStatsAnomaly `json:"featureStatsAnomaly,omitempty"`

	// Objective: Output only. The objective for each stats.
	//
	// Possible values:
	//   "OBJECTIVE_UNSPECIFIED" - If it's OBJECTIVE_UNSPECIFIED,
	// monitoring_stats will be empty.
	//   "IMPORT_FEATURE_ANALYSIS" - Stats are generated by Import Feature
	// Analysis.
	//   "SNAPSHOT_ANALYSIS" - Stats are generated by Snapshot Analysis.
	Objective string `json:"objective,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FeatureStatsAnomaly")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureStatsAnomaly") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureNoiseSigma: Noise sigma by features.
// Noise sigma represents the standard deviation of the gaussian kernel
// that will be used to add noise to interpolated inputs prior to
// computing gradients.
type GoogleCloudAiplatformV1FeatureNoiseSigma struct {
	// NoiseSigma: Noise sigma per feature. No noise is added to features
	// that are not set.
	NoiseSigma []*GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature `json:"noiseSigma,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NoiseSigma") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NoiseSigma") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureNoiseSigma) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureNoiseSigma
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature: Noise
// sigma for a single feature.
type GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature struct {
	// Name: The name of the input feature for which noise sigma is
	// provided. The features are defined in explanation metadata inputs.
	Name string `json:"name,omitempty"`

	// Sigma: This represents the standard deviation of the Gaussian kernel
	// that will be used to add noise to the feature prior to computing
	// gradients. Similar to noise_sigma but represents the noise added to
	// the current feature. Defaults to 0.1.
	Sigma float64 `json:"sigma,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature
	var s1 struct {
		Sigma gensupport.JSONFloat64 `json:"sigma"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Sigma = float64(s1.Sigma)
	return nil
}

// GoogleCloudAiplatformV1FeatureOnlineStore: Vertex AI Feature Online
// Store provides a centralized repository for serving ML features and
// embedding indexes at low latency. The Feature Online Store is a
// top-level container.
type GoogleCloudAiplatformV1FeatureOnlineStore struct {
	// Bigtable: Contains settings for the Cloud Bigtable instance that will
	// be created to serve featureValues for all FeatureViews under this
	// FeatureOnlineStore.
	Bigtable *GoogleCloudAiplatformV1FeatureOnlineStoreBigtable `json:"bigtable,omitempty"`

	// CreateTime: Output only. Timestamp when this FeatureOnlineStore was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Etag: Optional. Used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. The labels with user-defined metadata to organize
	// your FeatureOnlineStore. Label keys and values can be no longer than
	// 64 characters (Unicode codepoints), can only contain lowercase
	// letters, numeric characters, underscores and dashes. International
	// characters are allowed. See https://goo.gl/xmQnxf for more
	// information on and examples of labels. No more than 64 user labels
	// can be associated with one FeatureOnlineStore(System labels are
	// excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Identifier. Name of the FeatureOnlineStore. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{featureO
	// nlineStore}`
	Name string `json:"name,omitempty"`

	// State: Output only. State of the featureOnlineStore.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "STABLE" - State when the featureOnlineStore configuration is not
	// being updated and the fields reflect the current configuration of the
	// featureOnlineStore. The featureOnlineStore is usable in this state.
	//   "UPDATING" - The state of the featureOnlineStore configuration when
	// it is being updated. During an update, the fields reflect either the
	// original configuration or the updated configuration of the
	// featureOnlineStore. The featureOnlineStore is still usable in this
	// state.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. Timestamp when this FeatureOnlineStore was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Bigtable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bigtable") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureOnlineStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureOnlineStore
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1FeatureOnlineStoreBigtable struct {
	// AutoScaling: Required. Autoscaling config applied to Bigtable
	// Instance.
	AutoScaling *GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling `json:"autoScaling,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoScaling") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoScaling") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureOnlineStoreBigtable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureOnlineStoreBigtable
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling struct {
	// CpuUtilizationTarget: Optional. A percentage of the cluster's CPU
	// capacity. Can be from 10% to 80%. When a cluster's CPU utilization
	// exceeds the target that you have set, Bigtable immediately adds nodes
	// to the cluster. When CPU utilization is substantially lower than the
	// target, Bigtable removes nodes. If not set will default to 50%.
	CpuUtilizationTarget int64 `json:"cpuUtilizationTarget,omitempty"`

	// MaxNodeCount: Required. The maximum number of nodes to scale up to.
	// Must be greater than or equal to min_node_count, and less than or
	// equal to 10 times of 'min_node_count'.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`

	// MinNodeCount: Required. The minimum number of nodes to scale down to.
	// Must be greater than or equal to 1.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CpuUtilizationTarget") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpuUtilizationTarget") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureSelector: Selector for Features of an
// EntityType.
type GoogleCloudAiplatformV1FeatureSelector struct {
	// IdMatcher: Required. Matches Features based on ID.
	IdMatcher *GoogleCloudAiplatformV1IdMatcher `json:"idMatcher,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IdMatcher") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IdMatcher") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureSelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureStatsAnomaly: Stats and Anomaly
// generated at specific timestamp for specific Feature. The start_time
// and end_time are used to define the time range of the dataset that
// current stats belongs to, e.g. prediction traffic is bucketed into
// prediction datasets by time window. If the Dataset is not defined by
// time window, start_time = end_time. Timestamp of the stats and
// anomalies always refers to end_time. Raw stats and anomalies are
// stored in stats_uri or anomaly_uri in the tensorflow defined protos.
// Field data_stats contains almost identical information with the raw
// stats in Vertex AI defined proto, for UI to display.
type GoogleCloudAiplatformV1FeatureStatsAnomaly struct {
	// AnomalyDetectionThreshold: This is the threshold used when detecting
	// anomalies. The threshold can be changed by user, so this one might be
	// different from ThresholdConfig.value.
	AnomalyDetectionThreshold float64 `json:"anomalyDetectionThreshold,omitempty"`

	// AnomalyUri: Path of the anomaly file for current feature values in
	// Cloud Storage bucket. Format: gs:////anomalies. Example:
	// gs://monitoring_bucket/feature_name/anomalies. Stats are stored as
	// binary format with Protobuf message Anoamlies are stored as binary
	// format with Protobuf message [tensorflow.metadata.v0.AnomalyInfo]
	// (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
	AnomalyUri string `json:"anomalyUri,omitempty"`

	// DistributionDeviation: Deviation from the current stats to baseline
	// stats. 1. For categorical feature, the distribution distance is
	// calculated by L-inifinity norm. 2. For numerical feature, the
	// distribution distance is calculated by Jensen–Shannon divergence.
	DistributionDeviation float64 `json:"distributionDeviation,omitempty"`

	// EndTime: The end timestamp of window where stats were generated. For
	// objectives where time window doesn't make sense (e.g. Featurestore
	// Snapshot Monitoring), end_time indicates the timestamp of the data
	// used to generate stats (e.g. timestamp we take snapshots for feature
	// values).
	EndTime string `json:"endTime,omitempty"`

	// Score: Feature importance score, only populated when cross-feature
	// monitoring is enabled. For now only used to represent feature
	// attribution score within range [0, 1] for
	// ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW and
	// ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT.
	Score float64 `json:"score,omitempty"`

	// StartTime: The start timestamp of window where stats were generated.
	// For objectives where time window doesn't make sense (e.g.
	// Featurestore Snapshot Monitoring), start_time is only used to
	// indicate the monitoring intervals, so it always equals to (end_time -
	// monitoring_interval).
	StartTime string `json:"startTime,omitempty"`

	// StatsUri: Path of the stats file for current feature values in Cloud
	// Storage bucket. Format: gs:////stats. Example:
	// gs://monitoring_bucket/feature_name/stats. Stats are stored as binary
	// format with Protobuf message
	// tensorflow.metadata.v0.FeatureNameStatistics
	// (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
	StatsUri string `json:"statsUri,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AnomalyDetectionThreshold") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AnomalyDetectionThreshold") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureStatsAnomaly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureStatsAnomaly
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FeatureStatsAnomaly) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FeatureStatsAnomaly
	var s1 struct {
		AnomalyDetectionThreshold gensupport.JSONFloat64 `json:"anomalyDetectionThreshold"`
		DistributionDeviation     gensupport.JSONFloat64 `json:"distributionDeviation"`
		Score                     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnomalyDetectionThreshold = float64(s1.AnomalyDetectionThreshold)
	s.DistributionDeviation = float64(s1.DistributionDeviation)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1FeatureValue: Value for a feature.
type GoogleCloudAiplatformV1FeatureValue struct {
	// BoolArrayValue: A list of bool type feature value.
	BoolArrayValue *GoogleCloudAiplatformV1BoolArray `json:"boolArrayValue,omitempty"`

	// BoolValue: Bool type feature value.
	BoolValue bool `json:"boolValue,omitempty"`

	// BytesValue: Bytes feature value.
	BytesValue string `json:"bytesValue,omitempty"`

	// DoubleArrayValue: A list of double type feature value.
	DoubleArrayValue *GoogleCloudAiplatformV1DoubleArray `json:"doubleArrayValue,omitempty"`

	// DoubleValue: Double type feature value.
	DoubleValue float64 `json:"doubleValue,omitempty"`

	// Int64ArrayValue: A list of int64 type feature value.
	Int64ArrayValue *GoogleCloudAiplatformV1Int64Array `json:"int64ArrayValue,omitempty"`

	// Int64Value: Int64 feature value.
	Int64Value int64 `json:"int64Value,omitempty,string"`

	// Metadata: Metadata of feature value.
	Metadata *GoogleCloudAiplatformV1FeatureValueMetadata `json:"metadata,omitempty"`

	// StringArrayValue: A list of string type feature value.
	StringArrayValue *GoogleCloudAiplatformV1StringArray `json:"stringArrayValue,omitempty"`

	// StringValue: String feature value.
	StringValue string `json:"stringValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BoolArrayValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoolArrayValue") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FeatureValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FeatureValue
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	return nil
}

// GoogleCloudAiplatformV1FeatureValueDestination: A destination
// location for Feature values and format.
type GoogleCloudAiplatformV1FeatureValueDestination struct {
	// BigqueryDestination: Output in BigQuery format.
	// BigQueryDestination.output_uri in
	// FeatureValueDestination.bigquery_destination must refer to a table.
	BigqueryDestination *GoogleCloudAiplatformV1BigQueryDestination `json:"bigqueryDestination,omitempty"`

	// CsvDestination: Output in CSV format. Array Feature value types are
	// not allowed in CSV format.
	CsvDestination *GoogleCloudAiplatformV1CsvDestination `json:"csvDestination,omitempty"`

	// TfrecordDestination: Output in TFRecord format. Below are the mapping
	// from Feature value type in Featurestore to Feature value type in
	// TFRecord: Value type in Featurestore | Value type in TFRecord DOUBLE,
	// DOUBLE_ARRAY | FLOAT_LIST INT64, INT64_ARRAY | INT64_LIST STRING,
	// STRING_ARRAY, BYTES | BYTES_LIST true -> byte_string("true"), false
	// -> byte_string("false") BOOL, BOOL_ARRAY (true, false) | BYTES_LIST
	TfrecordDestination *GoogleCloudAiplatformV1TFRecordDestination `json:"tfrecordDestination,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigqueryDestination")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureValueDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureValueDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureValueList: Container for list of
// values.
type GoogleCloudAiplatformV1FeatureValueList struct {
	// Values: A list of feature values. All of them should be the same data
	// type.
	Values []*GoogleCloudAiplatformV1FeatureValue `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureValueList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureValueList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureValueMetadata: Metadata of feature
// value.
type GoogleCloudAiplatformV1FeatureValueMetadata struct {
	// GenerateTime: Feature generation timestamp. Typically, it is provided
	// by user at feature ingestion time. If not, feature store will use the
	// system timestamp when the data is ingested into feature store. For
	// streaming ingestion, the time, aligned by days, must be no older than
	// five years (1825 days) and no later than one year (366 days) in the
	// future.
	GenerateTime string `json:"generateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenerateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenerateTime") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureValueMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureValueMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureView: FeatureView is representation of
// values that the FeatureOnlineStore will serve based on its
// syncConfig.
type GoogleCloudAiplatformV1FeatureView struct {
	// BigQuerySource: Optional. Configures how data is supposed to be
	// extracted from a BigQuery source to be loaded onto the
	// FeatureOnlineStore.
	BigQuerySource *GoogleCloudAiplatformV1FeatureViewBigQuerySource `json:"bigQuerySource,omitempty"`

	// CreateTime: Output only. Timestamp when this FeatureView was created.
	CreateTime string `json:"createTime,omitempty"`

	// Etag: Optional. Used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// FeatureRegistrySource: Optional. Configures the features from a
	// Feature Registry source that need to be loaded onto the
	// FeatureOnlineStore.
	FeatureRegistrySource *GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource `json:"featureRegistrySource,omitempty"`

	// Labels: Optional. The labels with user-defined metadata to organize
	// your FeatureViews. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. See https://goo.gl/xmQnxf for more information on and
	// examples of labels. No more than 64 user labels can be associated
	// with one FeatureOnlineStore(System labels are excluded)." System
	// reserved label keys are prefixed with "aiplatform.googleapis.com/"
	// and are immutable.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Identifier. Name of the FeatureView. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_
	// online_store}/featureViews/{feature_view}`
	Name string `json:"name,omitempty"`

	// SyncConfig: Configures when data is to be synced/updated for this
	// FeatureView. At the end of the sync the latest featureValues for each
	// entityId of this FeatureView are made ready for online serving.
	SyncConfig *GoogleCloudAiplatformV1FeatureViewSyncConfig `json:"syncConfig,omitempty"`

	// UpdateTime: Output only. Timestamp when this FeatureView was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQuerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1FeatureViewBigQuerySource struct {
	// EntityIdColumns: Required. Columns to construct entity_id / row keys.
	EntityIdColumns []string `json:"entityIdColumns,omitempty"`

	// Uri: Required. The BigQuery view URI that will be materialized on
	// each sync trigger based on FeatureView.SyncConfig.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityIdColumns") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityIdColumns") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureViewBigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewBigQuerySource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewDataKey: Lookup key for a feature
// view.
type GoogleCloudAiplatformV1FeatureViewDataKey struct {
	// CompositeKey: The actual Entity ID will be composed from this struct.
	// This should match with the way ID is defined in the FeatureView spec.
	CompositeKey *GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey `json:"compositeKey,omitempty"`

	// Key: String key to use for lookup.
	Key string `json:"key,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompositeKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompositeKey") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureViewDataKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewDataKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey: ID that is
// comprised from several parts (columns).
type GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey struct {
	// Parts: Parts to construct Entity ID. Should match with the same ID
	// columns as defined in FeatureView in the same order.
	Parts []string `json:"parts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parts") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource: A Feature
// Registry source for features that need to be synced to Online Store.
type GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource struct {
	// FeatureGroups: Required. List of features that need to be synced to
	// Online Store.
	FeatureGroups []*GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup `json:"featureGroups,omitempty"`

	// ProjectNumber: Optional. The project number of the parent project of
	// the Feature Groups.
	ProjectNumber int64 `json:"projectNumber,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "FeatureGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureGroups") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup:
// Features belonging to a single feature group that will be synced to
// Online Store.
type GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup struct {
	// FeatureGroupId: Required. Identifier of the feature group.
	FeatureGroupId string `json:"featureGroupId,omitempty"`

	// FeatureIds: Required. Identifiers of features under the feature
	// group.
	FeatureIds []string `json:"featureIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FeatureGroupId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureGroupId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewSync: FeatureViewSync is a
// representation of sync operation which copies data from data source
// to Feature View in Online Store.
type GoogleCloudAiplatformV1FeatureViewSync struct {
	// CreateTime: Output only. Time when this FeatureViewSync is created.
	// Creation of a FeatureViewSync means that the job is pending / waiting
	// for sufficient resources but may not have started the actual data
	// transfer yet.
	CreateTime string `json:"createTime,omitempty"`

	// FinalStatus: Output only. Final status of the FeatureViewSync.
	FinalStatus *GoogleRpcStatus `json:"finalStatus,omitempty"`

	// Name: Identifier. Name of the FeatureViewSync. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_
	// online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_vi
	// ew_sync}`
	Name string `json:"name,omitempty"`

	// RunTime: Output only. Time when this FeatureViewSync is finished.
	RunTime *GoogleTypeInterval `json:"runTime,omitempty"`

	// SyncSummary: Output only. Summary of the sync job.
	SyncSummary *GoogleCloudAiplatformV1FeatureViewSyncSyncSummary `json:"syncSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureViewSync) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewSync
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewSyncConfig: Configuration for Sync.
// Only one option is set.
type GoogleCloudAiplatformV1FeatureViewSyncConfig struct {
	// Cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch
	// scheduled runs. To explicitly set a timezone to the cron tab, apply a
	// prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
	// "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid
	// string from IANA time zone database. For example,
	// "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * *
	// *".
	Cron string `json:"cron,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cron") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cron") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureViewSyncConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewSyncConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewSyncSyncSummary: Summary from the
// Sync job. For continuous syncs, the summary is updated periodically.
// For batch syncs, it gets updated on completion of the sync.
type GoogleCloudAiplatformV1FeatureViewSyncSyncSummary struct {
	// RowSynced: Output only. Total number of rows synced.
	RowSynced int64 `json:"rowSynced,omitempty,string"`

	// TotalSlot: Output only. BigQuery slot milliseconds consumed for the
	// sync job.
	TotalSlot int64 `json:"totalSlot,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "RowSynced") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RowSynced") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeatureViewSyncSyncSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewSyncSyncSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Featurestore: Vertex AI Feature Store provides
// a centralized repository for organizing, storing, and serving ML
// features. The Featurestore is a top-level container for your features
// and their values.
type GoogleCloudAiplatformV1Featurestore struct {
	// CreateTime: Output only. Timestamp when this Featurestore was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// EncryptionSpec: Optional. Customer-managed encryption key spec for
	// data storage. If set, both of the online and offline data storage
	// will be secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// Etag: Optional. Used to perform consistent read-modify-write updates.
	// If not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. The labels with user-defined metadata to organize
	// your Featurestore. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. See https://goo.gl/xmQnxf for more information on and
	// examples of labels. No more than 64 user labels can be associated
	// with one Featurestore(System labels are excluded)." System reserved
	// label keys are prefixed with "aiplatform.googleapis.com/" and are
	// immutable.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. Name of the Featurestore. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}`
	Name string `json:"name,omitempty"`

	// OnlineServingConfig: Optional. Config for online storage resources.
	// The field should not co-exist with the field of
	// `OnlineStoreReplicationConfig`. If both of it and
	// OnlineStoreReplicationConfig are unset, the feature store will not
	// have an online store and cannot be used for online serving.
	OnlineServingConfig *GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig `json:"onlineServingConfig,omitempty"`

	// OnlineStorageTtlDays: Optional. TTL in days for feature values that
	// will be stored in online serving storage. The Feature Store online
	// storage periodically removes obsolete feature values older than
	// `online_storage_ttl_days` since the feature generation time. Note
	// that `online_storage_ttl_days` should be less than or equal to
	// `offline_storage_ttl_days` for each EntityType under a featurestore.
	// If not set, default to 4000 days
	OnlineStorageTtlDays int64 `json:"onlineStorageTtlDays,omitempty"`

	// State: Output only. State of the featurestore.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "STABLE" - State when the featurestore configuration is not being
	// updated and the fields reflect the current configuration of the
	// featurestore. The featurestore is usable in this state.
	//   "UPDATING" - The state of the featurestore configuration when it is
	// being updated. During an update, the fields reflect either the
	// original configuration or the updated configuration of the
	// featurestore. For example, `online_serving_config.fixed_node_count`
	// can take minutes to update. While the update is in progress, the
	// featurestore is in the UPDATING state, and the value of
	// `fixed_node_count` can be the original value or the updated value,
	// depending on the progress of the operation. Until the update
	// completes, the actual number of nodes can still be the original value
	// of `fixed_node_count`. The featurestore is still usable in this
	// state.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. Timestamp when this Featurestore was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Featurestore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Featurestore
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreMonitoringConfig: Configuration of
// how features in Featurestore are monitored.
type GoogleCloudAiplatformV1FeaturestoreMonitoringConfig struct {
	// CategoricalThresholdConfig: Threshold for categorical features of
	// anomaly detection. This is shared by all types of Featurestore
	// Monitoring for categorical features (i.e. Features with type
	// (Feature.ValueType) BOOL or STRING).
	CategoricalThresholdConfig *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig `json:"categoricalThresholdConfig,omitempty"`

	// ImportFeaturesAnalysis: The config for ImportFeatures Analysis Based
	// Feature Monitoring.
	ImportFeaturesAnalysis *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis `json:"importFeaturesAnalysis,omitempty"`

	// NumericalThresholdConfig: Threshold for numerical features of anomaly
	// detection. This is shared by all objectives of Featurestore
	// Monitoring for numerical features (i.e. Features with type
	// (Feature.ValueType) DOUBLE or INT64).
	NumericalThresholdConfig *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig `json:"numericalThresholdConfig,omitempty"`

	// SnapshotAnalysis: The config for Snapshot Analysis Based Feature
	// Monitoring.
	SnapshotAnalysis *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis `json:"snapshotAnalysis,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CategoricalThresholdConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CategoricalThresholdConfig") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeaturestoreMonitoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnaly
// sis: Configuration of the Featurestore's ImportFeature Analysis Based
// Monitoring. This type of analysis generates statistics for values of
// each Feature imported by every ImportFeatureValues operation.
type GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis struct {
	// AnomalyDetectionBaseline: The baseline used to do anomaly detection
	// for the statistics generated by import features analysis.
	//
	// Possible values:
	//   "BASELINE_UNSPECIFIED" - Should not be used.
	//   "LATEST_STATS" - Choose the later one statistics generated by
	// either most recent snapshot analysis or previous import features
	// analysis. If non of them exists, skip anomaly detection and only
	// generate a statistics.
	//   "MOST_RECENT_SNAPSHOT_STATS" - Use the statistics generated by the
	// most recent snapshot analysis if exists.
	//   "PREVIOUS_IMPORT_FEATURES_STATS" - Use the statistics generated by
	// the previous import features analysis if exists.
	AnomalyDetectionBaseline string `json:"anomalyDetectionBaseline,omitempty"`

	// State: Whether to enable / disable / inherite default hebavior for
	// import features analysis.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Should not be used.
	//   "DEFAULT" - The default behavior of whether to enable the
	// monitoring. EntityType-level config: disabled. Feature-level config:
	// inherited from the configuration of EntityType this Feature belongs
	// to.
	//   "ENABLED" - Explicitly enables import features analysis.
	// EntityType-level config: by default enables import features analysis
	// for all Features under it. Feature-level config: enables import
	// features analysis regardless of the EntityType-level config.
	//   "DISABLED" - Explicitly disables import features analysis.
	// EntityType-level config: by default disables import features analysis
	// for all Features under it. Feature-level config: disables import
	// features analysis regardless of the EntityType-level config.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AnomalyDetectionBaseline") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnomalyDetectionBaseline")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis:
// Configuration of the Featurestore's Snapshot Analysis Based
// Monitoring. This type of analysis generates statistics for each
// Feature based on a snapshot of the latest feature value of each
// entities every monitoring_interval.
type GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis struct {
	// Disabled: The monitoring schedule for snapshot analysis. For
	// EntityType-level config: unset / disabled = true indicates disabled
	// by default for Features under it; otherwise by default enable
	// snapshot analysis monitoring with monitoring_interval for Features
	// under it. Feature-level config: disabled = true indicates disabled
	// regardless of the EntityType-level config; unset monitoring_interval
	// indicates going with EntityType-level config; otherwise run snapshot
	// analysis monitoring with monitoring_interval regardless of the
	// EntityType-level config. Explicitly Disable the snapshot analysis
	// based monitoring.
	Disabled bool `json:"disabled,omitempty"`

	// MonitoringIntervalDays: Configuration of the snapshot analysis based
	// monitoring pipeline running interval. The value indicates number of
	// days.
	MonitoringIntervalDays int64 `json:"monitoringIntervalDays,omitempty"`

	// StalenessDays: Customized export features time window for snapshot
	// analysis. Unit is one day. Default value is 3 weeks. Minimum value is
	// 1 day. Maximum value is 4000 days.
	StalenessDays int64 `json:"stalenessDays,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig:
// The config for Featurestore Monitoring threshold.
type GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig struct {
	// Value: Specify a threshold value that can trigger the alert. 1. For
	// categorical feature, the distribution distance is calculated by
	// L-inifinity norm. 2. For numerical feature, the distribution distance
	// is calculated by Jensen–Shannon divergence. Each feature must have
	// a non-zero threshold if they need to be monitored. Otherwise no alert
	// will be triggered for that feature.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig:
// OnlineServingConfig specifies the details for provisioning online
// serving resources.
type GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig struct {
	// FixedNodeCount: The number of nodes for the online store. The number
	// of nodes doesn't scale automatically, but you can manually update the
	// number of nodes. If set to 0, the featurestore will not have an
	// online store and cannot be used for online serving.
	FixedNodeCount int64 `json:"fixedNodeCount,omitempty"`

	// Scaling: Online serving scaling configuration. Only one of
	// `fixed_node_count` and `scaling` can be set. Setting one will reset
	// the other.
	Scaling *GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling `json:"scaling,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FixedNodeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FixedNodeCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling: Online
// serving scaling configuration. If min_node_count and max_node_count
// are set to the same value, the cluster will be configured with the
// fixed number of node (no auto-scaling).
type GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling struct {
	// CpuUtilizationTarget: Optional. The cpu utilization that the
	// Autoscaler should be trying to achieve. This number is on a scale
	// from 0 (no utilization) to 100 (total utilization), and is limited
	// between 10 and 80. When a cluster's CPU utilization exceeds the
	// target that you have set, Bigtable immediately adds nodes to the
	// cluster. When CPU utilization is substantially lower than the target,
	// Bigtable removes nodes. If not set or set to 0, default to 50.
	CpuUtilizationTarget int64 `json:"cpuUtilizationTarget,omitempty"`

	// MaxNodeCount: The maximum number of nodes to scale up to. Must be
	// greater than min_node_count, and less than or equal to 10 times of
	// 'min_node_count'.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`

	// MinNodeCount: Required. The minimum number of nodes to scale down to.
	// Must be greater than or equal to 1.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CpuUtilizationTarget") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpuUtilizationTarget") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FetchFeatureValuesRequest: Request message for
// FeatureOnlineStoreService.FetchFeatureValues. All the features under
// the requested feature view will be returned.
type GoogleCloudAiplatformV1FetchFeatureValuesRequest struct {
	// DataFormat: Optional. Response data format. If not set,
	// FeatureViewDataFormat.KEY_VALUE will be used.
	//
	// Possible values:
	//   "FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED" - Not set. Will be treated
	// as the KeyValue format.
	//   "KEY_VALUE" - Return response data in key-value format.
	//   "PROTO_STRUCT" - Return response data in proto Struct format.
	DataFormat string `json:"dataFormat,omitempty"`

	// DataKey: Optional. The request key to fetch feature values for.
	DataKey *GoogleCloudAiplatformV1FeatureViewDataKey `json:"dataKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataFormat") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FetchFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FetchFeatureValuesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FetchFeatureValuesResponse: Response message
// for FeatureOnlineStoreService.FetchFeatureValues
type GoogleCloudAiplatformV1FetchFeatureValuesResponse struct {
	// KeyValues: Feature values in KeyValue format.
	KeyValues *GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList `json:"keyValues,omitempty"`

	// ProtoStruct: Feature values in proto Struct format.
	ProtoStruct googleapi.RawMessage `json:"protoStruct,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "KeyValues") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KeyValues") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FetchFeatureValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FetchFeatureValuesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairL
// ist: Response structure in the format of key (feature name) and
// (feature) value pair.
type GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList struct {
	// Features: List of feature names and values.
	Features []*GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair `json:"features,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Features") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairL
// istFeatureNameValuePair: Feature name & value pair.
type GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair struct {
	// Name: Feature short name.
	Name string `json:"name,omitempty"`

	// Value: Feature value.
	Value *GoogleCloudAiplatformV1FeatureValue `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FileData: URI based data.
type GoogleCloudAiplatformV1FileData struct {
	// FileUri: Required. URI.
	FileUri string `json:"fileUri,omitempty"`

	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FileUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FileData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FileData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FilterSplit: Assigns input data to training,
// validation, and test sets based on the given filters, data pieces not
// matched by any filter are ignored. Currently only supported for
// Datasets containing DataItems. If any of the filters in this message
// are to match nothing, then they can be set as '-' (the minus sign).
// Supported only for unstructured Datasets.
type GoogleCloudAiplatformV1FilterSplit struct {
	// TestFilter: Required. A filter on DataItems of the Dataset. DataItems
	// that match this filter are used to test the Model. A filter with same
	// syntax as the one used in DatasetService.ListDataItems may be used.
	// If a single DataItem is matched by more than one of the FilterSplit
	// filters, then it is assigned to the first set that applies to it in
	// the training, validation, test order.
	TestFilter string `json:"testFilter,omitempty"`

	// TrainingFilter: Required. A filter on DataItems of the Dataset.
	// DataItems that match this filter are used to train the Model. A
	// filter with same syntax as the one used in
	// DatasetService.ListDataItems may be used. If a single DataItem is
	// matched by more than one of the FilterSplit filters, then it is
	// assigned to the first set that applies to it in the training,
	// validation, test order.
	TrainingFilter string `json:"trainingFilter,omitempty"`

	// ValidationFilter: Required. A filter on DataItems of the Dataset.
	// DataItems that match this filter are used to validate the Model. A
	// filter with same syntax as the one used in
	// DatasetService.ListDataItems may be used. If a single DataItem is
	// matched by more than one of the FilterSplit filters, then it is
	// assigned to the first set that applies to it in the training,
	// validation, test order.
	ValidationFilter string `json:"validationFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TestFilter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TestFilter") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FilterSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FilterSplit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FindNeighborsRequest: The request message for
// MatchService.FindNeighbors.
type GoogleCloudAiplatformV1FindNeighborsRequest struct {
	// DeployedIndexId: The ID of the DeployedIndex that will serve the
	// request. This request is sent to a specific IndexEndpoint, as per the
	// IndexEndpoint.network. That IndexEndpoint also has
	// IndexEndpoint.deployed_indexes, and each such index has a
	// DeployedIndex.id field. The value of the field below must equal one
	// of the DeployedIndex.id fields of the IndexEndpoint that is being
	// called for this request.
	DeployedIndexId string `json:"deployedIndexId,omitempty"`

	// Queries: The list of queries.
	Queries []*GoogleCloudAiplatformV1FindNeighborsRequestQuery `json:"queries,omitempty"`

	// ReturnFullDatapoint: If set to true, the full datapoints (including
	// all vector values and restricts) of the nearest neighbors are
	// returned. Note that returning full datapoint will significantly
	// increase the latency and cost of the query.
	ReturnFullDatapoint bool `json:"returnFullDatapoint,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedIndexId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FindNeighborsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FindNeighborsRequestQuery: A query to find a
// number of the nearest neighbors (most similar vectors) of a vector.
type GoogleCloudAiplatformV1FindNeighborsRequestQuery struct {
	// ApproximateNeighborCount: The number of neighbors to find via
	// approximate search before exact reordering is performed. If not set,
	// the default value from scam config is used; if set, this value must
	// be > 0.
	ApproximateNeighborCount int64 `json:"approximateNeighborCount,omitempty"`

	// Datapoint: Required. The datapoint/vector whose nearest neighbors
	// should be searched for.
	Datapoint *GoogleCloudAiplatformV1IndexDatapoint `json:"datapoint,omitempty"`

	// FractionLeafNodesToSearchOverride: The fraction of the number of
	// leaves to search, set at query time allows user to tune search
	// performance. This value increase result in both search accuracy and
	// latency increase. The value should be between 0.0 and 1.0. If not set
	// or set to 0.0, query uses the default value specified in
	// NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search
	// .
	FractionLeafNodesToSearchOverride float64 `json:"fractionLeafNodesToSearchOverride,omitempty"`

	// NeighborCount: The number of nearest neighbors to be retrieved from
	// database for each query. If not set, will use the default from the
	// service configuration
	// (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
	NeighborCount int64 `json:"neighborCount,omitempty"`

	// PerCrowdingAttributeNeighborCount: Crowding is a constraint on a
	// neighbor list produced by nearest neighbor search requiring that no
	// more than some value k' of the k neighbors returned have the same
	// value of crowding_attribute. It's used for improving result
	// diversity. This field is the maximum number of matches with the same
	// crowding tag.
	PerCrowdingAttributeNeighborCount int64 `json:"perCrowdingAttributeNeighborCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ApproximateNeighborCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApproximateNeighborCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FindNeighborsRequestQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsRequestQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FindNeighborsRequestQuery) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsRequestQuery
	var s1 struct {
		FractionLeafNodesToSearchOverride gensupport.JSONFloat64 `json:"fractionLeafNodesToSearchOverride"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FractionLeafNodesToSearchOverride = float64(s1.FractionLeafNodesToSearchOverride)
	return nil
}

// GoogleCloudAiplatformV1FindNeighborsResponse: The response message
// for MatchService.FindNeighbors.
type GoogleCloudAiplatformV1FindNeighborsResponse struct {
	// NearestNeighbors: The nearest neighbors of the query datapoints.
	NearestNeighbors []*GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors `json:"nearestNeighbors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NearestNeighbors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NearestNeighbors") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FindNeighborsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors: Nearest
// neighbors for one query.
type GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors struct {
	// Id: The ID of the query datapoint.
	Id string `json:"id,omitempty"`

	// Neighbors: All its neighbors.
	Neighbors []*GoogleCloudAiplatformV1FindNeighborsResponseNeighbor `json:"neighbors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FindNeighborsResponseNeighbor: A neighbor of
// the query vector.
type GoogleCloudAiplatformV1FindNeighborsResponseNeighbor struct {
	// Datapoint: The datapoint of the neighbor. Note that full datapoints
	// are returned only when "return_full_datapoint" is set to true.
	// Otherwise, only the "datapoint_id" and "crowding_tag" fields are
	// populated.
	Datapoint *GoogleCloudAiplatformV1IndexDatapoint `json:"datapoint,omitempty"`

	// Distance: The distance between the neighbor and the query vector.
	Distance float64 `json:"distance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Datapoint") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Datapoint") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FindNeighborsResponseNeighbor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsResponseNeighbor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FindNeighborsResponseNeighbor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsResponseNeighbor
	var s1 struct {
		Distance gensupport.JSONFloat64 `json:"distance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Distance = float64(s1.Distance)
	return nil
}

// GoogleCloudAiplatformV1FractionSplit: Assigns the input data to
// training, validation, and test sets as per the given fractions. Any
// of `training_fraction`, `validation_fraction` and `test_fraction` may
// optionally be provided, they must sum to up to 1. If the provided
// ones sum to less than 1, the remainder is assigned to sets as decided
// by Vertex AI. If none of the fractions are set, by default roughly
// 80% of data is used for training, 10% for validation, and 10% for
// test.
type GoogleCloudAiplatformV1FractionSplit struct {
	// TestFraction: The fraction of the input data that is to be used to
	// evaluate the Model.
	TestFraction float64 `json:"testFraction,omitempty"`

	// TrainingFraction: The fraction of the input data that is to be used
	// to train the Model.
	TrainingFraction float64 `json:"trainingFraction,omitempty"`

	// ValidationFraction: The fraction of the input data that is to be used
	// to validate the Model.
	ValidationFraction float64 `json:"validationFraction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TestFraction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TestFraction") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FractionSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FractionSplit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FractionSplit) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FractionSplit
	var s1 struct {
		TestFraction       gensupport.JSONFloat64 `json:"testFraction"`
		TrainingFraction   gensupport.JSONFloat64 `json:"trainingFraction"`
		ValidationFraction gensupport.JSONFloat64 `json:"validationFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TestFraction = float64(s1.TestFraction)
	s.TrainingFraction = float64(s1.TrainingFraction)
	s.ValidationFraction = float64(s1.ValidationFraction)
	return nil
}

// GoogleCloudAiplatformV1FunctionCall: A predicted [FunctionCall]
// returned from the model that contains a string representing the
// [FunctionDeclaration.name] and a structured JSON object containing
// the parameters and their values.
type GoogleCloudAiplatformV1FunctionCall struct {
	// Args: Optional. Required. The function parameters and values in JSON
	// object format. See [FunctionDeclaration.parameters] for parameter
	// details.
	Args googleapi.RawMessage `json:"args,omitempty"`

	// Name: Required. The name of the function to call. Matches
	// [FunctionDeclaration.name].
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FunctionCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionCall
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FunctionDeclaration: Structured representation
// of a function declaration as defined by the OpenAPI 3.0 specification
// (https://spec.openapis.org/oas/v3.0.3). Included in this declaration
// are the function name and parameters. This FunctionDeclaration is a
// representation of a block of code that can be used as a `Tool` by the
// model and executed by the client.
type GoogleCloudAiplatformV1FunctionDeclaration struct {
	// Description: Optional. Description and purpose of the function. Model
	// uses it to decide how and whether to call the function.
	Description string `json:"description,omitempty"`

	// Name: Required. The name of the function to call. Must start with a
	// letter or an underscore. Must be a-z, A-Z, 0-9, or contain
	// underscores and dashes, with a maximum length of 64.
	Name string `json:"name,omitempty"`

	// Parameters: Optional. Describes the parameters to this function in
	// JSON Schema Object format. Reflects the Open API 3.03 Parameter
	// Object. string Key: the name of the parameter. Parameter names are
	// case sensitive. Schema Value: the Schema defining the type used for
	// the parameter. For function with no parameters, this can be left
	// unset. Example with 1 required and 1 optional parameter: type: OBJECT
	// properties: param1: type: STRING param2: type: INTEGER required: -
	// param1
	Parameters *GoogleCloudAiplatformV1Schema `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FunctionDeclaration) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionDeclaration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FunctionResponse: The result output from a
// [FunctionCall] that contains a string representing the
// [FunctionDeclaration.name] and a structured JSON object containing
// any output from the function is used as context to the model. This
// should contain the result of a [FunctionCall] made based on model
// prediction.
type GoogleCloudAiplatformV1FunctionResponse struct {
	// Name: Required. The name of the function to call. Matches
	// [FunctionDeclaration.name] and [FunctionCall.name].
	Name string `json:"name,omitempty"`

	// Response: Required. The function response in JSON object format.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1FunctionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GcsDestination: The Google Cloud Storage
// location where the output is to be written to.
type GoogleCloudAiplatformV1GcsDestination struct {
	// OutputUriPrefix: Required. Google Cloud Storage URI to output
	// directory. If the uri doesn't end with '/', a '/' will be
	// automatically appended. The directory is created if it doesn't exist.
	OutputUriPrefix string `json:"outputUriPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OutputUriPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OutputUriPrefix") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GcsDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GcsSource: The Google Cloud Storage location
// for the input content.
type GoogleCloudAiplatformV1GcsSource struct {
	// Uris: Required. Google Cloud Storage URI(-s) to the input file(s).
	// May contain wildcards. For more information on wildcards, see
	// https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
	Uris []string `json:"uris,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uris") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uris") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GcsSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateContentRequest: Request message for
// [PredictionService.GenerateContent].
type GoogleCloudAiplatformV1GenerateContentRequest struct {
	// Contents: Required. The content of the current conversation with the
	// model. For single-turn queries, this is a single instance. For
	// multi-turn queries, this is a repeated field that contains
	// conversation history + latest request.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`

	// GenerationConfig: Optional. Generation config.
	GenerationConfig *GoogleCloudAiplatformV1GenerationConfig `json:"generationConfig,omitempty"`

	// SafetySettings: Optional. Per request settings for blocking unsafe
	// content. Enforced on GenerateContentResponse.candidates.
	SafetySettings []*GoogleCloudAiplatformV1SafetySetting `json:"safetySettings,omitempty"`

	// Tools: Optional. A list of `Tools` the model may use to generate the
	// next response. A `Tool` is a piece of code that enables the system to
	// interact with external systems to perform an action, or set of
	// actions, outside of knowledge and scope of the model.
	Tools []*GoogleCloudAiplatformV1Tool `json:"tools,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GenerateContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateContentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateContentResponse: Response message for
// [PredictionService.GenerateContent].
type GoogleCloudAiplatformV1GenerateContentResponse struct {
	// Candidates: Output only. Generated candidates.
	Candidates []*GoogleCloudAiplatformV1Candidate `json:"candidates,omitempty"`

	// PromptFeedback: Output only. Content filter results for a prompt sent
	// in the request. Note: Sent only in the first stream chunk. Only
	// happens when no candidates were generated due to content violations.
	PromptFeedback *GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback `json:"promptFeedback,omitempty"`

	// UsageMetadata: Usage metadata about the response(s).
	UsageMetadata *GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata `json:"usageMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Candidates") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GenerateContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateContentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback: Content
// filter results for a prompt sent in the request.
type GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback struct {
	// BlockReason: Output only. Blocked reason.
	//
	// Possible values:
	//   "BLOCKED_REASON_UNSPECIFIED" - Unspecified blocked reason.
	//   "SAFETY" - Candidates blocked due to safety.
	//   "OTHER" - Candidates blocked due to other reason.
	BlockReason string `json:"blockReason,omitempty"`

	// BlockReasonMessage: Output only. A readable block reason message.
	BlockReasonMessage string `json:"blockReasonMessage,omitempty"`

	// SafetyRatings: Output only. Safety ratings.
	SafetyRatings []*GoogleCloudAiplatformV1SafetyRating `json:"safetyRatings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BlockReason") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlockReason") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata: Usage
// metadata about response(s).
type GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata struct {
	// CandidatesTokenCount: Number of tokens in the response(s).
	CandidatesTokenCount int64 `json:"candidatesTokenCount,omitempty"`

	// PromptTokenCount: Number of tokens in the request.
	PromptTokenCount int64 `json:"promptTokenCount,omitempty"`

	TotalTokenCount int64 `json:"totalTokenCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CandidatesTokenCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CandidatesTokenCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerationConfig: Generation config.
type GoogleCloudAiplatformV1GenerationConfig struct {
	// CandidateCount: Optional. Number of candidates to generate.
	CandidateCount int64 `json:"candidateCount,omitempty"`

	// MaxOutputTokens: Optional. The maximum number of output tokens to
	// generate per message.
	MaxOutputTokens int64 `json:"maxOutputTokens,omitempty"`

	// StopSequences: Optional. Stop sequences.
	StopSequences []string `json:"stopSequences,omitempty"`

	// Temperature: Optional. Controls the randomness of predictions.
	Temperature float64 `json:"temperature,omitempty"`

	// TopK: Optional. If specified, top-k sampling will be used.
	TopK float64 `json:"topK,omitempty"`

	// TopP: Optional. If specified, nucleus sampling will be used.
	TopP float64 `json:"topP,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CandidateCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CandidateCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GenerationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1GenerationConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1GenerationConfig
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopK        gensupport.JSONFloat64 `json:"topK"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopK = float64(s1.TopK)
	s.TopP = float64(s1.TopP)
	return nil
}

// GoogleCloudAiplatformV1GenericOperationMetadata: Generic Metadata
// shared by all operations.
type GoogleCloudAiplatformV1GenericOperationMetadata struct {
	// CreateTime: Output only. Time when the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// PartialFailures: Output only. Partial failures encountered. E.g.
	// single files that couldn't be read. This field should never exceed 20
	// entries. Status details field will contain standard Google Cloud
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`

	// UpdateTime: Output only. Time when the operation was updated for the
	// last time. If the operation has finished (successfully or not), this
	// is the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GenericOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenericOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenieSource: Contains information about the
// source of the models generated from Generative AI Studio.
type GoogleCloudAiplatformV1GenieSource struct {
	// BaseModelUri: Required. The public base model URI.
	BaseModelUri string `json:"baseModelUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BaseModelUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BaseModelUri") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GenieSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenieSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingAttribution: Grounding attribution.
type GoogleCloudAiplatformV1GroundingAttribution struct {
	// ConfidenceScore: Optional. Output only. Confidence score of the
	// attribution. Ranges from 0 to 1. 1 is the most confident.
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`

	// Segment: Output only. Segment of the content this attribution belongs
	// to.
	Segment *GoogleCloudAiplatformV1Segment `json:"segment,omitempty"`

	// Web: Optional. Attribution from the web.
	Web *GoogleCloudAiplatformV1GroundingAttributionWeb `json:"web,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfidenceScore") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GroundingAttribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingAttribution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1GroundingAttribution) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1GroundingAttribution
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudAiplatformV1GroundingAttributionWeb: Attribution from the
// web.
type GoogleCloudAiplatformV1GroundingAttributionWeb struct {
	// Title: Output only. Title of the attribution.
	Title string `json:"title,omitempty"`

	// Uri: Output only. URI reference of the attribution.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Title") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GroundingAttributionWeb) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingAttributionWeb
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingMetadata: Metadata returned to client
// when grounding is enabled.
type GoogleCloudAiplatformV1GroundingMetadata struct {
	// GroundingAttributions: Optional. List of grounding attributions.
	GroundingAttributions []*GoogleCloudAiplatformV1GroundingAttribution `json:"groundingAttributions,omitempty"`

	// WebSearchQueries: Optional. Web search queries for the following-up
	// web search.
	WebSearchQueries []string `json:"webSearchQueries,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "GroundingAttributions") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroundingAttributions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1GroundingMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1HyperparameterTuningJob: Represents a
// HyperparameterTuningJob. A HyperparameterTuningJob has a Study
// specification and multiple CustomJobs with identical CustomJob
// specification.
type GoogleCloudAiplatformV1HyperparameterTuningJob struct {
	// CreateTime: Output only. Time when the HyperparameterTuningJob was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Required. The display name of the
	// HyperparameterTuningJob. The name can be up to 128 characters long
	// and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`

	// EncryptionSpec: Customer-managed encryption key options for a
	// HyperparameterTuningJob. If this is set, then all resources created
	// by the HyperparameterTuningJob will be encrypted with the provided
	// encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// EndTime: Output only. Time when the HyperparameterTuningJob entered
	// any of the following states: `JOB_STATE_SUCCEEDED`,
	// `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`

	// Error: Output only. Only populated when job's state is
	// JOB_STATE_FAILED or JOB_STATE_CANCELLED.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Labels: The labels with user-defined metadata to organize
	// HyperparameterTuningJobs. Label keys and values can be no longer than
	// 64 characters (Unicode codepoints), can only contain lowercase
	// letters, numeric characters, underscores and dashes. International
	// characters are allowed. See https://goo.gl/xmQnxf for more
	// information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// MaxFailedTrialCount: The number of failed Trials that need to be seen
	// before failing the HyperparameterTuningJob. If set to 0, Vertex AI
	// decides how many Trials must fail before the whole job fails.
	MaxFailedTrialCount int64 `json:"maxFailedTrialCount,omitempty"`

	// MaxTrialCount: Required. The desired total number of Trials.
	MaxTrialCount int64 `json:"maxTrialCount,omitempty"`

	// Name: Output only. Resource name of the HyperparameterTuningJob.
	Name string `json:"name,omitempty"`

	// ParallelTrialCount: Required. The desired number of Trials to run in
	// parallel.
	ParallelTrialCount int64 `json:"parallelTrialCount,omitempty"`

	// StartTime: Output only. Time when the HyperparameterTuningJob for the
	// first time entered the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this
	// state the job may only go to either `JOB_STATE_SUCCEEDED`,
	// `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to
	// the `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded,
	// some results may be missing due to errors.
	State string `json:"state,omitempty"`

	// StudySpec: Required. Study configuration of the
	// HyperparameterTuningJob.
	StudySpec *GoogleCloudAiplatformV1StudySpec `json:"studySpec,omitempty"`

	// TrialJobSpec: Required. The spec of a trial job. The same spec
	// applies to the CustomJobs created in all the trials.
	TrialJobSpec *GoogleCloudAiplatformV1CustomJobSpec `json:"trialJobSpec,omitempty"`

	// Trials: Output only. Trials of the HyperparameterTuningJob.
	Trials []*GoogleCloudAiplatformV1Trial `json:"trials,omitempty"`

	// UpdateTime: Output only. Time when the HyperparameterTuningJob was
	// most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1HyperparameterTuningJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1HyperparameterTuningJob
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IdMatcher: Matcher for Features of an
// EntityType by Feature ID.
type GoogleCloudAiplatformV1IdMatcher struct {
	// Ids: Required. The following are accepted as `ids`: * A
	// single-element list containing only `*`, which selects all Features
	// in the target EntityType, or * A list containing only Feature IDs,
	// which selects only Features with those IDs in the target EntityType.
	Ids []string `json:"ids,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Ids") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ids") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1IdMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IdMatcher
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportDataConfig: Describes the location from
// where we import data into a Dataset, together with the labels that
// will be applied to the DataItems and the Annotations.
type GoogleCloudAiplatformV1ImportDataConfig struct {
	// AnnotationLabels: Labels that will be applied to newly imported
	// Annotations. If two Annotations are identical, one of them will be
	// deduped. Two Annotations are considered identical if their payload,
	// payload_schema_uri and all of their labels are the same. These labels
	// will be overridden by Annotation labels specified inside index file
	// referenced by import_schema_uri, e.g. jsonl file.
	AnnotationLabels map[string]string `json:"annotationLabels,omitempty"`

	// DataItemLabels: Labels that will be applied to newly imported
	// DataItems. If an identical DataItem as one being imported already
	// exists in the Dataset, then these labels will be appended to these of
	// the already existing one, and if labels with identical key is
	// imported before, the old label value will be overwritten. If two
	// DataItems are identical in the same import data operation, the labels
	// will be combined and if key collision happens in this case, one of
	// the values will be picked randomly. Two DataItems are considered
	// identical if their content bytes are identical (e.g. image bytes or
	// pdf bytes). These labels will be overridden by Annotation labels
	// specified inside index file referenced by import_schema_uri, e.g.
	// jsonl file.
	DataItemLabels map[string]string `json:"dataItemLabels,omitempty"`

	// GcsSource: The Google Cloud Storage location for the input content.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`

	// ImportSchemaUri: Required. Points to a YAML file stored on Google
	// Cloud Storage describing the import format. Validation will be done
	// against the schema. The schema is defined as an OpenAPI 3.0.2 Schema
	// Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	ImportSchemaUri string `json:"importSchemaUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnnotationLabels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotationLabels") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ImportDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportDataConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportDataOperationMetadata: Runtime operation
// information for DatasetService.ImportData.
type GoogleCloudAiplatformV1ImportDataOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ImportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportDataOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportDataRequest: Request message for
// DatasetService.ImportData.
type GoogleCloudAiplatformV1ImportDataRequest struct {
	// ImportConfigs: Required. The desired input locations. The contents of
	// all input locations will be imported in one batch.
	ImportConfigs []*GoogleCloudAiplatformV1ImportDataConfig `json:"importConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImportConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImportConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ImportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportDataRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportDataResponse: Response message for
// DatasetService.ImportData.
type GoogleCloudAiplatformV1ImportDataResponse struct {
}

// GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata: Details
// of operations that perform import Feature values.
type GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata struct {
	// BlockingOperationIds: List of ImportFeatureValues operations running
	// under a single EntityType that are blocking this operation.
	BlockingOperationIds googleapi.Int64s `json:"blockingOperationIds,omitempty"`

	// GenericMetadata: Operation metadata for Featurestore import Feature
	// values.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ImportedEntityCount: Number of entities that have been imported by
	// the operation.
	ImportedEntityCount int64 `json:"importedEntityCount,omitempty,string"`

	// ImportedFeatureValueCount: Number of Feature values that have been
	// imported by the operation.
	ImportedFeatureValueCount int64 `json:"importedFeatureValueCount,omitempty,string"`

	// InvalidRowCount: The number of rows in input source that weren't
	// imported due to either * Not having any featureValues. * Having a
	// null entityId. * Having a null timestamp. * Not being parsable
	// (applicable for CSV sources).
	InvalidRowCount int64 `json:"invalidRowCount,omitempty,string"`

	// SourceUris: The source URI from where Feature values are imported.
	SourceUris []string `json:"sourceUris,omitempty"`

	// TimestampOutsideRetentionRowsCount: The number rows that weren't
	// ingested due to having timestamps outside the retention boundary.
	TimestampOutsideRetentionRowsCount int64 `json:"timestampOutsideRetentionRowsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "BlockingOperationIds") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlockingOperationIds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportFeatureValuesRequest: Request message
// for FeaturestoreService.ImportFeatureValues.
type GoogleCloudAiplatformV1ImportFeatureValuesRequest struct {
	AvroSource *GoogleCloudAiplatformV1AvroSource `json:"avroSource,omitempty"`

	BigquerySource *GoogleCloudAiplatformV1BigQuerySource `json:"bigquerySource,omitempty"`

	CsvSource *GoogleCloudAiplatformV1CsvSource `json:"csvSource,omitempty"`

	// DisableIngestionAnalysis: If true, API doesn't start ingestion
	// analysis pipeline.
	DisableIngestionAnalysis bool `json:"disableIngestionAnalysis,omitempty"`

	// DisableOnlineServing: If set, data will not be imported for online
	// serving. This is typically used for backfilling, where Feature
	// generation timestamps are not in the timestamp range needed for
	// online serving.
	DisableOnlineServing bool `json:"disableOnlineServing,omitempty"`

	// EntityIdField: Source column that holds entity IDs. If not provided,
	// entity IDs are extracted from the column named entity_id.
	EntityIdField string `json:"entityIdField,omitempty"`

	// FeatureSpecs: Required. Specifications defining which Feature values
	// to import from the entity. The request fails if no feature_specs are
	// provided, and having multiple feature_specs for one Feature is not
	// allowed.
	FeatureSpecs []*GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec `json:"featureSpecs,omitempty"`

	// FeatureTime: Single Feature timestamp for all entities being
	// imported. The timestamp must not have higher than millisecond
	// precision.
	FeatureTime string `json:"featureTime,omitempty"`

	// FeatureTimeField: Source column that holds the Feature timestamp for
	// all Feature values in each entity.
	FeatureTimeField string `json:"featureTimeField,omitempty"`

	// WorkerCount: Specifies the number of workers that are used to write
	// data to the Featurestore. Consider the online serving capacity that
	// you require to achieve the desired import throughput without
	// interfering with online serving. The value must be positive, and less
	// than or equal to 100. If not set, defaults to using 1 worker. The low
	// count ensures minimal impact on online serving performance.
	WorkerCount int64 `json:"workerCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AvroSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvroSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ImportFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportFeatureValuesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec: Defines
// the Feature value(s) to import.
type GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec struct {
	// Id: Required. ID of the Feature to import values of. This Feature
	// must exist in the target EntityType, or the request will fail.
	Id string `json:"id,omitempty"`

	// SourceField: Source column to get the Feature values from. If not
	// set, uses the column with the same name as the Feature ID.
	SourceField string `json:"sourceField,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportFeatureValuesResponse: Response message
// for FeaturestoreService.ImportFeatureValues.
type GoogleCloudAiplatformV1ImportFeatureValuesResponse struct {
	// ImportedEntityCount: Number of entities that have been imported by
	// the operation.
	ImportedEntityCount int64 `json:"importedEntityCount,omitempty,string"`

	// ImportedFeatureValueCount: Number of Feature values that have been
	// imported by the operation.
	ImportedFeatureValueCount int64 `json:"importedFeatureValueCount,omitempty,string"`

	// InvalidRowCount: The number of rows in input source that weren't
	// imported due to either * Not having any featureValues. * Having a
	// null entityId. * Having a null timestamp. * Not being parsable
	// (applicable for CSV sources).
	InvalidRowCount int64 `json:"invalidRowCount,omitempty,string"`

	// TimestampOutsideRetentionRowsCount: The number rows that weren't
	// ingested due to having feature timestamps outside the retention
	// boundary.
	TimestampOutsideRetentionRowsCount int64 `json:"timestampOutsideRetentionRowsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ImportedEntityCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImportedEntityCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ImportFeatureValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportFeatureValuesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportModelEvaluationRequest: Request message
// for ModelService.ImportModelEvaluation
type GoogleCloudAiplatformV1ImportModelEvaluationRequest struct {
	// ModelEvaluation: Required. Model evaluation resource to be imported.
	ModelEvaluation *GoogleCloudAiplatformV1ModelEvaluation `json:"modelEvaluation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ModelEvaluation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ModelEvaluation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ImportModelEvaluationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportModelEvaluationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Index: A representation of a collection of
// database items organized in a way that allows for approximate nearest
// neighbor (a.k.a ANN) algorithms search.
type GoogleCloudAiplatformV1Index struct {
	// CreateTime: Output only. Timestamp when this Index was created.
	CreateTime string `json:"createTime,omitempty"`

	// DeployedIndexes: Output only. The pointers to DeployedIndexes created
	// from this Index. An Index can be only deleted if all its
	// DeployedIndexes had been undeployed first.
	DeployedIndexes []*GoogleCloudAiplatformV1DeployedIndexRef `json:"deployedIndexes,omitempty"`

	// Description: The description of the Index.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The display name of the Index. The name can be
	// up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`

	// EncryptionSpec: Immutable. Customer-managed encryption key spec for
	// an Index. If set, this Index and all sub-resources of this Index will
	// be secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// Etag: Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// IndexStats: Output only. Stats of the index resource.
	IndexStats *GoogleCloudAiplatformV1IndexStats `json:"indexStats,omitempty"`

	// IndexUpdateMethod: Immutable. The update method to use with this
	// Index. If not set, BATCH_UPDATE will be used by default.
	//
	// Possible values:
	//   "INDEX_UPDATE_METHOD_UNSPECIFIED" - Should not be used.
	//   "BATCH_UPDATE" - BatchUpdate: user can call UpdateIndex with files
	// on Cloud Storage of Datapoints to update.
	//   "STREAM_UPDATE" - StreamUpdate: user can call
	// UpsertDatapoints/DeleteDatapoints to update the Index and the updates
	// will be applied in corresponding DeployedIndexes in nearly real-time.
	IndexUpdateMethod string `json:"indexUpdateMethod,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// Indexes. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are
	// allowed. See https://goo.gl/xmQnxf for more information and examples
	// of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// Metadata: An additional information about the Index; the schema of
	// the metadata can be found in metadata_schema.
	Metadata interface{} `json:"metadata,omitempty"`

	// MetadataSchemaUri: Immutable. Points to a YAML file stored on Google
	// Cloud Storage describing additional information about the Index, that
	// is specific to it. Unset if the Index does not have any additional
	// information. The schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// Note: The URI given on output will be immutable and probably
	// different, including the URI scheme, than the one given on input. The
	// output URI will point to a location where the user only has a read
	// access.
	MetadataSchemaUri string `json:"metadataSchemaUri,omitempty"`

	// Name: Output only. The resource name of the Index.
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. Timestamp when this Index was most recently
	// updated. This also includes any update to the contents of the Index.
	// Note that Operations working on this Index may have their
	// Operations.metadata.generic_metadata.update_time a little after the
	// value of this timestamp, yet that does not mean their results are not
	// already reflected in the Index. Result of any successfully completed
	// Operation on the Index is reflected in it.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Index) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Index
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexDatapoint: A datapoint of Index.
type GoogleCloudAiplatformV1IndexDatapoint struct {
	// CrowdingTag: Optional. CrowdingTag of the datapoint, the number of
	// neighbors to return in each crowding can be configured during query.
	CrowdingTag *GoogleCloudAiplatformV1IndexDatapointCrowdingTag `json:"crowdingTag,omitempty"`

	// DatapointId: Required. Unique identifier of the datapoint.
	DatapointId string `json:"datapointId,omitempty"`

	// FeatureVector: Required. Feature embedding vector. An array of
	// numbers with the length of [NearestNeighborSearchConfig.dimensions].
	FeatureVector []float64 `json:"featureVector,omitempty"`

	// NumericRestricts: Optional. List of Restrict of the datapoint, used
	// to perform "restricted searches" where boolean rule are used to
	// filter the subset of the database eligible for matching. This uses
	// numeric comparisons.
	NumericRestricts []*GoogleCloudAiplatformV1IndexDatapointNumericRestriction `json:"numericRestricts,omitempty"`

	// Restricts: Optional. List of Restrict of the datapoint, used to
	// perform "restricted searches" where boolean rule are used to filter
	// the subset of the database eligible for matching. This uses
	// categorical tokens. See:
	// https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
	Restricts []*GoogleCloudAiplatformV1IndexDatapointRestriction `json:"restricts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CrowdingTag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CrowdingTag") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1IndexDatapoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexDatapoint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1IndexDatapoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1IndexDatapoint
	var s1 struct {
		FeatureVector []gensupport.JSONFloat64 `json:"featureVector"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FeatureVector = make([]float64, len(s1.FeatureVector))
	for i := range s1.FeatureVector {
		s.FeatureVector[i] = float64(s1.FeatureVector[i])
	}
	return nil
}

// GoogleCloudAiplatformV1IndexDatapointCrowdingTag: Crowding tag is a
// constraint on a neighbor list produced by nearest neighbor search
// requiring that no more than some value k' of the k neighbors returned
// have the same value of crowding_attribute.
type GoogleCloudAiplatformV1IndexDatapointCrowdingTag struct {
	// CrowdingAttribute: The attribute value used for crowding. The maximum
	// number of neighbors to return per crowding attribute value
	// (per_crowding_attribute_num_neighbors) is configured per-query. This
	// field is ignored if per_crowding_attribute_num_neighbors is larger
	// than the total number of neighbors to return for a given query.
	CrowdingAttribute string `json:"crowdingAttribute,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CrowdingAttribute")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CrowdingAttribute") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1IndexDatapointCrowdingTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointCrowdingTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexDatapointNumericRestriction: This field
// allows restricts to be based on numeric comparisons rather than
// categorical tokens.
type GoogleCloudAiplatformV1IndexDatapointNumericRestriction struct {
	// Namespace: The namespace of this restriction. e.g.: cost.
	Namespace string `json:"namespace,omitempty"`

	// Op: This MUST be specified for queries and must NOT be specified for
	// datapoints.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - Default value of the enum.
	//   "LESS" - Datapoints are eligible iff their value is < the query's.
	//   "LESS_EQUAL" - Datapoints are eligible iff their value is <= the
	// query's.
	//   "EQUAL" - Datapoints are eligible iff their value is == the
	// query's.
	//   "GREATER_EQUAL" - Datapoints are eligible iff their value is >= the
	// query's.
	//   "GREATER" - Datapoints are eligible iff their value is > the
	// query's.
	//   "NOT_EQUAL" - Datapoints are eligible iff their value is != the
	// query's.
	Op string `json:"op,omitempty"`

	// ValueDouble: Represents 64 bit float.
	ValueDouble float64 `json:"valueDouble,omitempty"`

	// ValueFloat: Represents 32 bit float.
	ValueFloat float64 `json:"valueFloat,omitempty"`

	// ValueInt: Represents 64 bit integer.
	ValueInt int64 `json:"valueInt,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Namespace") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Namespace") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1IndexDatapointNumericRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointNumericRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1IndexDatapointNumericRestriction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointNumericRestriction
	var s1 struct {
		ValueDouble gensupport.JSONFloat64 `json:"valueDouble"`
		ValueFloat  gensupport.JSONFloat64 `json:"valueFloat"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ValueDouble = float64(s1.ValueDouble)
	s.ValueFloat = float64(s1.ValueFloat)
	return nil
}

// GoogleCloudAiplatformV1IndexDatapointRestriction: Restriction of a
// datapoint which describe its attributes(tokens) from each of several
// attribute categories(namespaces).
type GoogleCloudAiplatformV1IndexDatapointRestriction struct {
	// AllowList: The attributes to allow in this namespace. e.g.: 'red'
	AllowList []string `json:"allowList,omitempty"`

	// DenyList: The attributes to deny in this namespace. e.g.: 'blue'
	DenyList []string `json:"denyList,omitempty"`

	// Namespace: The namespace of this restriction. e.g.: color.
	Namespace string `json:"namespace,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowList") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowList") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1IndexDatapointRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexEndpoint: Indexes are deployed into it.
// An IndexEndpoint can have multiple DeployedIndexes.
type GoogleCloudAiplatformV1IndexEndpoint struct {
	// CreateTime: Output only. Timestamp when this IndexEndpoint was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DeployedIndexes: Output only. The indexes deployed in this endpoint.
	DeployedIndexes []*GoogleCloudAiplatformV1DeployedIndex `json:"deployedIndexes,omitempty"`

	// Description: The description of the IndexEndpoint.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The display name of the IndexEndpoint. The
	// name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `json:"displayName,omitempty"`

	// EnablePrivateServiceConnect: Optional. Deprecated: If true, expose
	// the IndexEndpoint via private service connect. Only one of the
	// fields, network or enable_private_service_connect, can be set.
	EnablePrivateServiceConnect bool `json:"enablePrivateServiceConnect,omitempty"`

	// EncryptionSpec: Immutable. Customer-managed encryption key spec for
	// an IndexEndpoint. If set, this IndexEndpoint and all sub-resources of
	// this IndexEndpoint will be secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// Etag: Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// IndexEndpoints. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. See https://goo.gl/xmQnxf for more information and
	// examples of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The resource name of the IndexEndpoint.
	Name string `json:"name,omitempty"`

	// Network: Optional. The full name of the Google Compute Engine network
	// (https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
	// to which the IndexEndpoint should be peered. Private services access
	// must already be configured for the network. If left unspecified, the
	// Endpoint is not peered with any network. network and
	// private_service_connect_config are mutually exclusive. Format
	// (https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
	// `projects/{project}/global/networks/{network}`. Where {project} is a
	// project number, as in '12345', and {network} is network name.
	Network string `json:"network,omitempty"`

	// PrivateServiceConnectConfig: Optional. Configuration for private
	// service connect. network and private_service_connect_config are
	// mutually exclusive.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1PrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`

	// PublicEndpointDomainName: Output only. If public_endpoint_enabled is
	// true, this field will be populated with the domain name to use for
	// this index endpoint.
	PublicEndpointDomainName string `json:"publicEndpointDomainName,omitempty"`

	// PublicEndpointEnabled: Optional. If true, the deployed index will be
	// accessible through public endpoint.
	PublicEndpointEnabled bool `json:"publicEndpointEnabled,omitempty"`

	// UpdateTime: Output only. Timestamp when this IndexEndpoint was last
	// updated. This timestamp is not updated when the endpoint's
	// DeployedIndexes are updated, e.g. due to updates of the original
	// Indexes they are the deployments of.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1IndexEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexEndpoint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexPrivateEndpoints: IndexPrivateEndpoints
// proto is used to provide paths for users to send requests via private
// endpoints (e.g. private service access, private service connect). To
// send request via private service access, use match_grpc_address. To
// send request via private service connect, use service_attachment.
type GoogleCloudAiplatformV1IndexPrivateEndpoints struct {
	// MatchGrpcAddress: Output only. The ip address used to send match gRPC
	// requests.
	MatchGrpcAddress string `json:"matchGrpcAddress,omitempty"`

	// PscAutomatedEndpoints: Output only. PscAutomatedEndpoints is
	// populated if private service connect is enabled if PscAutomatedConfig
	// is set.
	PscAutomatedEndpoints []*GoogleCloudAiplatformV1PscAutomatedEndpoints `json:"pscAutomatedEndpoints,omitempty"`

	// ServiceAttachment: Output only. The name of the service attachment
	// resource. Populated if private service connect is enabled.
	ServiceAttachment string `json:"serviceAttachment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MatchGrpcAddress") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MatchGrpcAddress") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1IndexPrivateEndpoints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexPrivateEndpoints
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexStats: Stats of the Index.
type GoogleCloudAiplatformV1IndexStats struct {
	// ShardsCount: Output only. The number of shards in the Index.
	ShardsCount int64 `json:"shardsCount,omitempty"`

	// VectorsCount: Output only. The number of vectors in the Index.
	VectorsCount int64 `json:"vectorsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ShardsCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ShardsCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1IndexStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1InputDataConfig: Specifies Vertex AI owned
// input data to be used for training, and possibly evaluating, the
// Model.
type GoogleCloudAiplatformV1InputDataConfig struct {
	// AnnotationSchemaUri: Applicable only to custom training with Datasets
	// that have DataItems and Annotations. Cloud Storage URI that points to
	// a YAML file describing the annotation schema. The schema is defined
	// as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// The schema files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that
	// the chosen schema must be consistent with metadata of the Dataset
	// specified by dataset_id. Only Annotations that both match this schema
	// and belong to DataItems not ignored by the split method are used in
	// respectively training, validation or test role, depending on the role
	// of the DataItem they are on. When used in conjunction with
	// annotations_filter, the Annotations used for training are filtered by
	// both annotations_filter and annotation_schema_uri.
	AnnotationSchemaUri string `json:"annotationSchemaUri,omitempty"`

	// AnnotationsFilter: Applicable only to Datasets that have DataItems
	// and Annotations. A filter on Annotations of the Dataset. Only
	// Annotations that both match this filter and belong to DataItems not
	// ignored by the split method are used in respectively training,
	// validation or test role, depending on the role of the DataItem they
	// are on (for the auto-assigned that role is decided by Vertex AI). A
	// filter with same syntax as the one used in ListAnnotations may be
	// used, but note here it filters across all Annotations of the Dataset,
	// and not just within a single DataItem.
	AnnotationsFilter string `json:"annotationsFilter,omitempty"`

	// BigqueryDestination: Only applicable to custom training with tabular
	// Dataset with BigQuery source. The BigQuery project location where the
	// training data is to be written to. In the given project a new dataset
	// is created with name `dataset___` where timestamp is in
	// YYYY_MM_DDThh_mm_ss_sssZ format. All training input data is written
	// into that dataset. In the dataset three tables are created,
	// `training`, `validation` and `test`. * AIP_DATA_FORMAT = "bigquery".
	// * AIP_TRAINING_DATA_URI = "bigquery_destination.dataset___.training"
	// * AIP_VALIDATION_DATA_URI =
	// "bigquery_destination.dataset___.validation" * AIP_TEST_DATA_URI =
	// "bigquery_destination.dataset___.test"
	BigqueryDestination *GoogleCloudAiplatformV1BigQueryDestination `json:"bigqueryDestination,omitempty"`

	// DatasetId: Required. The ID of the Dataset in the same Project and
	// Location which data will be used to train the Model. The Dataset must
	// use schema compatible with Model being trained, and what is
	// compatible should be described in the used TrainingPipeline's
	// training_task_definition. For tabular Datasets, all their data is
	// exported to training, to pick and choose from.
	DatasetId string `json:"datasetId,omitempty"`

	// FilterSplit: Split based on the provided filters for each set.
	FilterSplit *GoogleCloudAiplatformV1FilterSplit `json:"filterSplit,omitempty"`

	// FractionSplit: Split based on fractions defining the size of each
	// set.
	FractionSplit *GoogleCloudAiplatformV1FractionSplit `json:"fractionSplit,omitempty"`

	// GcsDestination: The Cloud Storage location where the training data is
	// to be written to. In the given directory a new directory is created
	// with name: `dataset---` where timestamp is in
	// YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All training input data is
	// written into that directory. The Vertex AI environment variables
	// representing Cloud Storage data URIs are represented in the Cloud
	// Storage wildcard format to support sharded data. e.g.:
	// "gs://.../training-*.jsonl" * AIP_DATA_FORMAT = "jsonl" for
	// non-tabular data, "csv" for tabular data * AIP_TRAINING_DATA_URI =
	// "gcs_destination/dataset---/training-*.${AIP_DATA_FORMAT}" *
	// AIP_VALIDATION_DATA_URI =
	// "gcs_destination/dataset---/validation-*.${AIP_DATA_FORMAT}" *
	// AIP_TEST_DATA_URI =
	// "gcs_destination/dataset---/test-*.${AIP_DATA_FORMAT}"
	GcsDestination *GoogleCloudAiplatformV1GcsDestination `json:"gcsDestination,omitempty"`

	// PersistMlUseAssignment: Whether to persist the ML use assignment to
	// data item system labels.
	PersistMlUseAssignment bool `json:"persistMlUseAssignment,omitempty"`

	// PredefinedSplit: Supported only for tabular Datasets. Split based on
	// a predefined key.
	PredefinedSplit *GoogleCloudAiplatformV1PredefinedSplit `json:"predefinedSplit,omitempty"`

	// SavedQueryId: Only applicable to Datasets that have SavedQueries. The
	// ID of a SavedQuery (annotation set) under the Dataset specified by
	// dataset_id used for filtering Annotations for training. Only
	// Annotations that are associated with this SavedQuery are used in
	// respectively training. When used in conjunction with
	// annotations_filter, the Annotations used for training are filtered by
	// both saved_query_id and annotations_filter. Only one of
	// saved_query_id and annotation_schema_uri should be specified as both
	// of them represent the same thing: problem type.
	SavedQueryId string `json:"savedQueryId,omitempty"`

	// StratifiedSplit: Supported only for tabular Datasets. Split based on
	// the distribution of the specified column.
	StratifiedSplit *GoogleCloudAiplatformV1StratifiedSplit `json:"stratifiedSplit,omitempty"`

	// TimestampSplit: Supported only for tabular Datasets. Split based on
	// the timestamp of the input data pieces.
	TimestampSplit *GoogleCloudAiplatformV1TimestampSplit `json:"timestampSplit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnnotationSchemaUri")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotationSchemaUri") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1InputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1InputDataConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Int64Array: A list of int64 values.
type GoogleCloudAiplatformV1Int64Array struct {
	// Values: A list of int64 values.
	Values googleapi.Int64s `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Int64Array) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Int64Array
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IntegratedGradientsAttribution: An attribution
// method that computes the Aumann-Shapley value taking advantage of the
// model's fully differentiable structure. Refer to this paper for more
// details: https://arxiv.org/abs/1703.01365
type GoogleCloudAiplatformV1IntegratedGradientsAttribution struct {
	// BlurBaselineConfig: Config for IG with blur baseline. When enabled, a
	// linear path from the maximally blurred image to the input image is
	// created. Using a blurred baseline instead of zero (black image) is
	// motivated by the BlurIG approach explained here:
	// https://arxiv.org/abs/2004.03383
	BlurBaselineConfig *GoogleCloudAiplatformV1BlurBaselineConfig `json:"blurBaselineConfig,omitempty"`

	// SmoothGradConfig: Config for SmoothGrad approximation of gradients.
	// When enabled, the gradients are approximated by averaging the
	// gradients from noisy samples in the vicinity of the inputs. Adding
	// noise can help improve the computed gradients. Refer to this paper
	// for more details: https://arxiv.org/pdf/1706.03825.pdf
	SmoothGradConfig *GoogleCloudAiplatformV1SmoothGradConfig `json:"smoothGradConfig,omitempty"`

	// StepCount: Required. The number of steps for approximating the path
	// integral. A good value to start is 50 and gradually increase until
	// the sum to diff property is within the desired error range. Valid
	// range of its value is [1, 100], inclusively.
	StepCount int64 `json:"stepCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BlurBaselineConfig")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlurBaselineConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1IntegratedGradientsAttribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IntegratedGradientsAttribution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1LargeModelReference: Contains information
// about the Large Model.
type GoogleCloudAiplatformV1LargeModelReference struct {
	// Name: Required. The unique name of the large Foundation or pre-built
	// model. Like "chat-bison", "text-bison". Or model name with version
	// ID, like "chat-bison@001", "text-bison@005", etc.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1LargeModelReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1LargeModelReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1LineageSubgraph: A subgraph of the overall
// lineage graph. Event edges connect Artifact and Execution nodes.
type GoogleCloudAiplatformV1LineageSubgraph struct {
	// Artifacts: The Artifact nodes in the subgraph.
	Artifacts []*GoogleCloudAiplatformV1Artifact `json:"artifacts,omitempty"`

	// Events: The Event edges between Artifacts and Executions in the
	// subgraph.
	Events []*GoogleCloudAiplatformV1Event `json:"events,omitempty"`

	// Executions: The Execution nodes in the subgraph.
	Executions []*GoogleCloudAiplatformV1Execution `json:"executions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Artifacts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Artifacts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1LineageSubgraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1LineageSubgraph
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListAnnotationsResponse: Response message for
// DatasetService.ListAnnotations.
type GoogleCloudAiplatformV1ListAnnotationsResponse struct {
	// Annotations: A list of Annotations that matches the specified filter
	// in the request.
	Annotations []*GoogleCloudAiplatformV1Annotation `json:"annotations,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListAnnotationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListAnnotationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListArtifactsResponse: Response message for
// MetadataService.ListArtifacts.
type GoogleCloudAiplatformV1ListArtifactsResponse struct {
	// Artifacts: The Artifacts retrieved from the MetadataStore.
	Artifacts []*GoogleCloudAiplatformV1Artifact `json:"artifacts,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListArtifactsRequest.page_token to retrieve the next page. If this
	// field is not populated, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Artifacts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Artifacts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListArtifactsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListArtifactsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListBatchPredictionJobsResponse: Response
// message for JobService.ListBatchPredictionJobs
type GoogleCloudAiplatformV1ListBatchPredictionJobsResponse struct {
	// BatchPredictionJobs: List of BatchPredictionJobs in the requested
	// page.
	BatchPredictionJobs []*GoogleCloudAiplatformV1BatchPredictionJob `json:"batchPredictionJobs,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListBatchPredictionJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BatchPredictionJobs")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchPredictionJobs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListBatchPredictionJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListBatchPredictionJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListContextsResponse: Response message for
// MetadataService.ListContexts.
type GoogleCloudAiplatformV1ListContextsResponse struct {
	// Contexts: The Contexts retrieved from the MetadataStore.
	Contexts []*GoogleCloudAiplatformV1Context `json:"contexts,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListContextsRequest.page_token to retrieve the next page. If this
	// field is not populated, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Contexts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contexts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListContextsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListContextsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListCustomJobsResponse: Response message for
// JobService.ListCustomJobs
type GoogleCloudAiplatformV1ListCustomJobsResponse struct {
	// CustomJobs: List of CustomJobs in the requested page.
	CustomJobs []*GoogleCloudAiplatformV1CustomJob `json:"customJobs,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListCustomJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomJobs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomJobs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListCustomJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListCustomJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListDataItemsResponse: Response message for
// DatasetService.ListDataItems.
type GoogleCloudAiplatformV1ListDataItemsResponse struct {
	// DataItems: A list of DataItems that matches the specified filter in
	// the request.
	DataItems []*GoogleCloudAiplatformV1DataItem `json:"dataItems,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataItems") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataItems") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListDataItemsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListDataItemsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListDataLabelingJobsResponse: Response message
// for JobService.ListDataLabelingJobs.
type GoogleCloudAiplatformV1ListDataLabelingJobsResponse struct {
	// DataLabelingJobs: A list of DataLabelingJobs that matches the
	// specified filter in the request.
	DataLabelingJobs []*GoogleCloudAiplatformV1DataLabelingJob `json:"dataLabelingJobs,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataLabelingJobs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataLabelingJobs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListDataLabelingJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListDataLabelingJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListDatasetVersionsResponse: Response message
// for DatasetService.ListDatasetVersions.
type GoogleCloudAiplatformV1ListDatasetVersionsResponse struct {
	// DatasetVersions: A list of DatasetVersions that matches the specified
	// filter in the request.
	DatasetVersions []*GoogleCloudAiplatformV1DatasetVersion `json:"datasetVersions,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DatasetVersions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DatasetVersions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListDatasetVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListDatasetVersionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListDatasetsResponse: Response message for
// DatasetService.ListDatasets.
type GoogleCloudAiplatformV1ListDatasetsResponse struct {
	// Datasets: A list of Datasets that matches the specified filter in the
	// request.
	Datasets []*GoogleCloudAiplatformV1Dataset `json:"datasets,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Datasets") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListDatasetsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListDeploymentResourcePoolsResponse: Response
// message for ListDeploymentResourcePools method.
type GoogleCloudAiplatformV1ListDeploymentResourcePoolsResponse struct {
	// DeploymentResourcePools: The DeploymentResourcePools from the
	// specified location.
	DeploymentResourcePools []*GoogleCloudAiplatformV1DeploymentResourcePool `json:"deploymentResourcePools,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DeploymentResourcePools") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeploymentResourcePools")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListDeploymentResourcePoolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListDeploymentResourcePoolsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListEndpointsResponse: Response message for
// EndpointService.ListEndpoints.
type GoogleCloudAiplatformV1ListEndpointsResponse struct {
	// Endpoints: List of Endpoints in the requested page.
	Endpoints []*GoogleCloudAiplatformV1Endpoint `json:"endpoints,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListEndpointsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Endpoints") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Endpoints") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListEndpointsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListEndpointsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListEntityTypesResponse: Response message for
// FeaturestoreService.ListEntityTypes.
type GoogleCloudAiplatformV1ListEntityTypesResponse struct {
	// EntityTypes: The EntityTypes matching the request.
	EntityTypes []*GoogleCloudAiplatformV1EntityType `json:"entityTypes,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListEntityTypesRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityTypes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListEntityTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListExecutionsResponse: Response message for
// MetadataService.ListExecutions.
type GoogleCloudAiplatformV1ListExecutionsResponse struct {
	// Executions: The Executions retrieved from the MetadataStore.
	Executions []*GoogleCloudAiplatformV1Execution `json:"executions,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListExecutionsRequest.page_token to retrieve the next page. If this
	// field is not populated, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Executions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Executions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListExecutionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListExecutionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListFeatureGroupsResponse: Response message
// for FeatureRegistryService.ListFeatureGroups.
type GoogleCloudAiplatformV1ListFeatureGroupsResponse struct {
	// FeatureGroups: The FeatureGroups matching the request.
	FeatureGroups []*GoogleCloudAiplatformV1FeatureGroup `json:"featureGroups,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListFeatureGroupsRequest.page_token to retrieve the next page. If
	// this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FeatureGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureGroups") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListFeatureGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListFeatureGroupsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListFeatureOnlineStoresResponse: Response
// message for FeatureOnlineStoreAdminService.ListFeatureOnlineStores.
type GoogleCloudAiplatformV1ListFeatureOnlineStoresResponse struct {
	// FeatureOnlineStores: The FeatureOnlineStores matching the request.
	FeatureOnlineStores []*GoogleCloudAiplatformV1FeatureOnlineStore `json:"featureOnlineStores,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListFeatureOnlineStoresRequest.page_token to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FeatureOnlineStores")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureOnlineStores") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListFeatureOnlineStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListFeatureOnlineStoresResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListFeatureViewSyncsResponse: Response message
// for FeatureOnlineStoreAdminService.ListFeatureViewSyncs.
type GoogleCloudAiplatformV1ListFeatureViewSyncsResponse struct {
	// FeatureViewSyncs: The FeatureViewSyncs matching the request.
	FeatureViewSyncs []*GoogleCloudAiplatformV1FeatureViewSync `json:"featureViewSyncs,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListFeatureViewSyncsRequest.page_token to retrieve the next page. If
	// this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FeatureViewSyncs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureViewSyncs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListFeatureViewSyncsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListFeatureViewSyncsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListFeatureViewsResponse: Response message for
// FeatureOnlineStoreAdminService.ListFeatureViews.
type GoogleCloudAiplatformV1ListFeatureViewsResponse struct {
	// FeatureViews: The FeatureViews matching the request.
	FeatureViews []*GoogleCloudAiplatformV1FeatureView `json:"featureViews,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListFeatureViewsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FeatureViews") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureViews") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListFeatureViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListFeatureViewsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListFeaturesResponse: Response message for
// FeaturestoreService.ListFeatures. Response message for
// FeatureRegistryService.ListFeatures.
type GoogleCloudAiplatformV1ListFeaturesResponse struct {
	// Features: The Features matching the request.
	Features []*GoogleCloudAiplatformV1Feature `json:"features,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListFeaturesRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Features") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListFeaturesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListFeaturesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListFeaturestoresResponse: Response message
// for FeaturestoreService.ListFeaturestores.
type GoogleCloudAiplatformV1ListFeaturestoresResponse struct {
	// Featurestores: The Featurestores matching the request.
	Featurestores []*GoogleCloudAiplatformV1Featurestore `json:"featurestores,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListFeaturestoresRequest.page_token to retrieve the next page. If
	// this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Featurestores") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Featurestores") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListFeaturestoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListFeaturestoresResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListHyperparameterTuningJobsResponse: Response
// message for JobService.ListHyperparameterTuningJobs
type GoogleCloudAiplatformV1ListHyperparameterTuningJobsResponse struct {
	// HyperparameterTuningJobs: List of HyperparameterTuningJobs in the
	// requested page. HyperparameterTuningJob.trials of the jobs will be
	// not be returned.
	HyperparameterTuningJobs []*GoogleCloudAiplatformV1HyperparameterTuningJob `json:"hyperparameterTuningJobs,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListHyperparameterTuningJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "HyperparameterTuningJobs") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HyperparameterTuningJobs")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListHyperparameterTuningJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListHyperparameterTuningJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListIndexEndpointsResponse: Response message
// for IndexEndpointService.ListIndexEndpoints.
type GoogleCloudAiplatformV1ListIndexEndpointsResponse struct {
	// IndexEndpoints: List of IndexEndpoints in the requested page.
	IndexEndpoints []*GoogleCloudAiplatformV1IndexEndpoint `json:"indexEndpoints,omitempty"`

	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListIndexEndpointsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "IndexEndpoints") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IndexEndpoints") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListIndexEndpointsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListIndexEndpointsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListIndexesResponse: Response message for
// IndexService.ListIndexes.
type GoogleCloudAiplatformV1ListIndexesResponse struct {
	// Indexes: List of indexes in the requested page.
	Indexes []*GoogleCloudAiplatformV1Index `json:"indexes,omitempty"`

	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListIndexesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Indexes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Indexes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListIndexesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListIndexesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListMetadataSchemasResponse: Response message
// for MetadataService.ListMetadataSchemas.
type GoogleCloudAiplatformV1ListMetadataSchemasResponse struct {
	// MetadataSchemas: The MetadataSchemas found for the MetadataStore.
	MetadataSchemas []*GoogleCloudAiplatformV1MetadataSchema `json:"metadataSchemas,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListMetadataSchemasRequest.page_token to retrieve the next page. If
	// this field is not populated, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "MetadataSchemas") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MetadataSchemas") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListMetadataSchemasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListMetadataSchemasResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListMetadataStoresResponse: Response message
// for MetadataService.ListMetadataStores.
type GoogleCloudAiplatformV1ListMetadataStoresResponse struct {
	// MetadataStores: The MetadataStores found for the Location.
	MetadataStores []*GoogleCloudAiplatformV1MetadataStore `json:"metadataStores,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListMetadataStoresRequest.page_token to retrieve the next page. If
	// this field is not populated, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "MetadataStores") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MetadataStores") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListMetadataStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListMetadataStoresResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListModelDeploymentMonitoringJobsResponse:
// Response message for JobService.ListModelDeploymentMonitoringJobs.
type GoogleCloudAiplatformV1ListModelDeploymentMonitoringJobsResponse struct {
	// ModelDeploymentMonitoringJobs: A list of
	// ModelDeploymentMonitoringJobs that matches the specified filter in
	// the request.
	ModelDeploymentMonitoringJobs []*GoogleCloudAiplatformV1ModelDeploymentMonitoringJob `json:"modelDeploymentMonitoringJobs,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ModelDeploymentMonitoringJobs") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ModelDeploymentMonitoringJobs") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListModelDeploymentMonitoringJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListModelDeploymentMonitoringJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListModelEvaluationSlicesResponse: Response
// message for ModelService.ListModelEvaluationSlices.
type GoogleCloudAiplatformV1ListModelEvaluationSlicesResponse struct {
	// ModelEvaluationSlices: List of ModelEvaluations in the requested
	// page.
	ModelEvaluationSlices []*GoogleCloudAiplatformV1ModelEvaluationSlice `json:"modelEvaluationSlices,omitempty"`

	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListModelEvaluationSlicesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ModelEvaluationSlices") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ModelEvaluationSlices") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListModelEvaluationSlicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListModelEvaluationSlicesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListModelEvaluationsResponse: Response message
// for ModelService.ListModelEvaluations.
type GoogleCloudAiplatformV1ListModelEvaluationsResponse struct {
	// ModelEvaluations: List of ModelEvaluations in the requested page.
	ModelEvaluations []*GoogleCloudAiplatformV1ModelEvaluation `json:"modelEvaluations,omitempty"`

	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListModelEvaluationsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ModelEvaluations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ModelEvaluations") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListModelEvaluationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListModelEvaluationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListModelVersionsResponse: Response message
// for ModelService.ListModelVersions
type GoogleCloudAiplatformV1ListModelVersionsResponse struct {
	// Models: List of Model versions in the requested page. In the returned
	// Model name field, version ID instead of regvision tag will be
	// included.
	Models []*GoogleCloudAiplatformV1Model `json:"models,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListModelVersionsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Models") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListModelVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListModelVersionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListModelsResponse: Response message for
// ModelService.ListModels
type GoogleCloudAiplatformV1ListModelsResponse struct {
	// Models: List of Models in the requested page.
	Models []*GoogleCloudAiplatformV1Model `json:"models,omitempty"`

	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListModelsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Models") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListModelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListNasJobsResponse: Response message for
// JobService.ListNasJobs
type GoogleCloudAiplatformV1ListNasJobsResponse struct {
	// NasJobs: List of NasJobs in the requested page. NasJob.nas_job_output
	// of the jobs will not be returned.
	NasJobs []*GoogleCloudAiplatformV1NasJob `json:"nasJobs,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListNasJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NasJobs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NasJobs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListNasJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListNasJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListNasTrialDetailsResponse: Response message
// for JobService.ListNasTrialDetails
type GoogleCloudAiplatformV1ListNasTrialDetailsResponse struct {
	// NasTrialDetails: List of top NasTrials in the requested page.
	NasTrialDetails []*GoogleCloudAiplatformV1NasTrialDetail `json:"nasTrialDetails,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListNasTrialDetailsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NasTrialDetails") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NasTrialDetails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListNasTrialDetailsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListNasTrialDetailsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListNotebookRuntimeTemplatesResponse: Response
// message for NotebookService.ListNotebookRuntimeTemplates.
type GoogleCloudAiplatformV1ListNotebookRuntimeTemplatesResponse struct {
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListNotebookRuntimeTemplatesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// NotebookRuntimeTemplates: List of NotebookRuntimeTemplates in the
	// requested page.
	NotebookRuntimeTemplates []*GoogleCloudAiplatformV1NotebookRuntimeTemplate `json:"notebookRuntimeTemplates,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListNotebookRuntimeTemplatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListNotebookRuntimeTemplatesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListNotebookRuntimesResponse: Response message
// for NotebookService.ListNotebookRuntimes.
type GoogleCloudAiplatformV1ListNotebookRuntimesResponse struct {
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListNotebookRuntimesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// NotebookRuntimes: List of NotebookRuntimes in the requested page.
	NotebookRuntimes []*GoogleCloudAiplatformV1NotebookRuntime `json:"notebookRuntimes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListNotebookRuntimesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListNotebookRuntimesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListOptimalTrialsRequest: Request message for
// VizierService.ListOptimalTrials.
type GoogleCloudAiplatformV1ListOptimalTrialsRequest struct {
}

// GoogleCloudAiplatformV1ListOptimalTrialsResponse: Response message
// for VizierService.ListOptimalTrials.
type GoogleCloudAiplatformV1ListOptimalTrialsResponse struct {
	// OptimalTrials: The pareto-optimal Trials for multiple objective Study
	// or the optimal trial for single objective Study. The definition of
	// pareto-optimal can be checked in wiki page.
	// https://en.wikipedia.org/wiki/Pareto_efficiency
	OptimalTrials []*GoogleCloudAiplatformV1Trial `json:"optimalTrials,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "OptimalTrials") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OptimalTrials") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListOptimalTrialsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListOptimalTrialsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListPipelineJobsResponse: Response message for
// PipelineService.ListPipelineJobs
type GoogleCloudAiplatformV1ListPipelineJobsResponse struct {
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListPipelineJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// PipelineJobs: List of PipelineJobs in the requested page.
	PipelineJobs []*GoogleCloudAiplatformV1PipelineJob `json:"pipelineJobs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListPipelineJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListPipelineJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListSavedQueriesResponse: Response message for
// DatasetService.ListSavedQueries.
type GoogleCloudAiplatformV1ListSavedQueriesResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SavedQueries: A list of SavedQueries that match the specified filter
	// in the request.
	SavedQueries []*GoogleCloudAiplatformV1SavedQuery `json:"savedQueries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListSavedQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListSavedQueriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListSchedulesResponse: Response message for
// ScheduleService.ListSchedules
type GoogleCloudAiplatformV1ListSchedulesResponse struct {
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListSchedulesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Schedules: List of Schedules in the requested page.
	Schedules []*GoogleCloudAiplatformV1Schedule `json:"schedules,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListSchedulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListSchedulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListSpecialistPoolsResponse: Response message
// for SpecialistPoolService.ListSpecialistPools.
type GoogleCloudAiplatformV1ListSpecialistPoolsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SpecialistPools: A list of SpecialistPools that matches the specified
	// filter in the request.
	SpecialistPools []*GoogleCloudAiplatformV1SpecialistPool `json:"specialistPools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListSpecialistPoolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListSpecialistPoolsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListStudiesResponse: Response message for
// VizierService.ListStudies.
type GoogleCloudAiplatformV1ListStudiesResponse struct {
	// NextPageToken: Passes this token as the `page_token` field of the
	// request for a subsequent call. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Studies: The studies associated with the project.
	Studies []*GoogleCloudAiplatformV1Study `json:"studies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListStudiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListStudiesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListTensorboardExperimentsResponse: Response
// message for TensorboardService.ListTensorboardExperiments.
type GoogleCloudAiplatformV1ListTensorboardExperimentsResponse struct {
	// NextPageToken: A token, which can be sent as
	// ListTensorboardExperimentsRequest.page_token to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TensorboardExperiments: The TensorboardExperiments mathching the
	// request.
	TensorboardExperiments []*GoogleCloudAiplatformV1TensorboardExperiment `json:"tensorboardExperiments,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListTensorboardExperimentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListTensorboardExperimentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListTensorboardRunsResponse: Response message
// for TensorboardService.ListTensorboardRuns.
type GoogleCloudAiplatformV1ListTensorboardRunsResponse struct {
	// NextPageToken: A token, which can be sent as
	// ListTensorboardRunsRequest.page_token to retrieve the next page. If
	// this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TensorboardRuns: The TensorboardRuns mathching the request.
	TensorboardRuns []*GoogleCloudAiplatformV1TensorboardRun `json:"tensorboardRuns,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListTensorboardRunsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListTensorboardRunsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListTensorboardTimeSeriesResponse: Response
// message for TensorboardService.ListTensorboardTimeSeries.
type GoogleCloudAiplatformV1ListTensorboardTimeSeriesResponse struct {
	// NextPageToken: A token, which can be sent as
	// ListTensorboardTimeSeriesRequest.page_token to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TensorboardTimeSeries: The TensorboardTimeSeries mathching the
	// request.
	TensorboardTimeSeries []*GoogleCloudAiplatformV1TensorboardTimeSeries `json:"tensorboardTimeSeries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListTensorboardTimeSeriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListTensorboardTimeSeriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListTensorboardsResponse: Response message for
// TensorboardService.ListTensorboards.
type GoogleCloudAiplatformV1ListTensorboardsResponse struct {
	// NextPageToken: A token, which can be sent as
	// ListTensorboardsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Tensorboards: The Tensorboards mathching the request.
	Tensorboards []*GoogleCloudAiplatformV1Tensorboard `json:"tensorboards,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListTensorboardsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListTensorboardsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListTrainingPipelinesResponse: Response
// message for PipelineService.ListTrainingPipelines
type GoogleCloudAiplatformV1ListTrainingPipelinesResponse struct {
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListTrainingPipelinesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TrainingPipelines: List of TrainingPipelines in the requested page.
	TrainingPipelines []*GoogleCloudAiplatformV1TrainingPipeline `json:"trainingPipelines,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListTrainingPipelinesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListTrainingPipelinesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ListTrialsResponse: Response message for
// VizierService.ListTrials.
type GoogleCloudAiplatformV1ListTrialsResponse struct {
	// NextPageToken: Pass this token as the `page_token` field of the
	// request for a subsequent call. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Trials: The Trials associated with the Study.
	Trials []*GoogleCloudAiplatformV1Trial `json:"trials,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ListTrialsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ListTrialsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1LookupStudyRequest: Request message for
// VizierService.LookupStudy.
type GoogleCloudAiplatformV1LookupStudyRequest struct {
	// DisplayName: Required. The user-defined display name of the Study
	DisplayName string `json:"displayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1LookupStudyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1LookupStudyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MachineSpec: Specification of a single
// machine.
type GoogleCloudAiplatformV1MachineSpec struct {
	// AcceleratorCount: The number of accelerators to attach to the
	// machine.
	AcceleratorCount int64 `json:"acceleratorCount,omitempty"`

	// AcceleratorType: Immutable. The type of accelerator(s) that may be
	// attached to the machine as per accelerator_count.
	//
	// Possible values:
	//   "ACCELERATOR_TYPE_UNSPECIFIED" - Unspecified accelerator type,
	// which means no accelerator.
	//   "NVIDIA_TESLA_K80" - Nvidia Tesla K80 GPU.
	//   "NVIDIA_TESLA_P100" - Nvidia Tesla P100 GPU.
	//   "NVIDIA_TESLA_V100" - Nvidia Tesla V100 GPU.
	//   "NVIDIA_TESLA_P4" - Nvidia Tesla P4 GPU.
	//   "NVIDIA_TESLA_T4" - Nvidia Tesla T4 GPU.
	//   "NVIDIA_TESLA_A100" - Nvidia Tesla A100 GPU.
	//   "NVIDIA_A100_80GB" - Nvidia A100 80GB GPU.
	//   "NVIDIA_L4" - Nvidia L4 GPU.
	//   "NVIDIA_H100_80GB" - Nvidia H100 80Gb GPU.
	//   "TPU_V2" - TPU v2.
	//   "TPU_V3" - TPU v3.
	//   "TPU_V4_POD" - TPU v4.
	AcceleratorType string `json:"acceleratorType,omitempty"`

	// MachineType: Immutable. The type of the machine. See the list of
	// machine types supported for prediction
	// (https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types)
	// See the list of machine types supported for custom training
	// (https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types).
	// For DeployedModel this field is optional, and the default value is
	// `n1-standard-2`. For BatchPredictionJob or as part of WorkerPoolSpec
	// this field is required.
	MachineType string `json:"machineType,omitempty"`

	// TpuTopology: Immutable. The topology of the TPUs. Corresponds to the
	// TPU topologies available from GKE. (Example: tpu_topology: "2x2x1").
	TpuTopology string `json:"tpuTopology,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcceleratorCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcceleratorCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MachineSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MachineSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ManualBatchTuningParameters: Manual batch
// tuning parameters.
type GoogleCloudAiplatformV1ManualBatchTuningParameters struct {
	// BatchSize: Immutable. The number of the records (e.g. instances) of
	// the operation given in each batch to a machine replica. Machine type,
	// and size of a single record should be considered when setting this
	// parameter, higher value speeds up the batch operation's execution,
	// but too high value will result in a whole batch not fitting in a
	// machine's memory, and the whole operation will fail. The default
	// value is 64.
	BatchSize int64 `json:"batchSize,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BatchSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BatchSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ManualBatchTuningParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ManualBatchTuningParameters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Measurement: A message representing a
// Measurement of a Trial. A Measurement contains the Metrics got by
// executing a Trial using suggested hyperparameter values.
type GoogleCloudAiplatformV1Measurement struct {
	// ElapsedDuration: Output only. Time that the Trial has been running at
	// the point of this Measurement.
	ElapsedDuration string `json:"elapsedDuration,omitempty"`

	// Metrics: Output only. A list of metrics got by evaluating the
	// objective functions using suggested Parameter values.
	Metrics []*GoogleCloudAiplatformV1MeasurementMetric `json:"metrics,omitempty"`

	// StepCount: Output only. The number of steps the machine learning
	// model has been trained for. Must be non-negative.
	StepCount int64 `json:"stepCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ElapsedDuration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ElapsedDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Measurement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Measurement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MeasurementMetric: A message representing a
// metric in the measurement.
type GoogleCloudAiplatformV1MeasurementMetric struct {
	// MetricId: Output only. The ID of the Metric. The Metric should be
	// defined in StudySpec's Metrics.
	MetricId string `json:"metricId,omitempty"`

	// Value: Output only. The value for this metric.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MetricId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MetricId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MeasurementMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MeasurementMetric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1MeasurementMetric) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1MeasurementMetric
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// GoogleCloudAiplatformV1MergeVersionAliasesRequest: Request message
// for ModelService.MergeVersionAliases.
type GoogleCloudAiplatformV1MergeVersionAliasesRequest struct {
	// VersionAliases: Required. The set of version aliases to merge. The
	// alias should be at most 128 characters, and match
	// `a-z{0,126}[a-z-0-9]`. Add the `-` prefix to an alias means removing
	// that alias from the version. `-` is NOT counted in the 128
	// characters. Example: `-golden` means removing the `golden` alias from
	// the version. There is NO ordering in aliases, which means 1) The
	// aliases returned from GetModel API might not have the exactly same
	// order from this MergeVersionAliases API. 2) Adding and deleting the
	// same alias in the request is not recommended, and the 2 operations
	// will be cancelled out.
	VersionAliases []string `json:"versionAliases,omitempty"`

	// ForceSendFields is a list of field names (e.g. "VersionAliases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "VersionAliases") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MergeVersionAliasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MergeVersionAliasesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MetadataSchema: Instance of a general
// MetadataSchema.
type GoogleCloudAiplatformV1MetadataSchema struct {
	// CreateTime: Output only. Timestamp when this MetadataSchema was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the Metadata Schema
	Description string `json:"description,omitempty"`

	// Name: Output only. The resource name of the MetadataSchema.
	Name string `json:"name,omitempty"`

	// Schema: Required. The raw YAML string representation of the
	// MetadataSchema. The combination of [MetadataSchema.version] and the
	// schema name given by `title` in [MetadataSchema.schema] must be
	// unique within a MetadataStore. The schema is defined as an OpenAPI
	// 3.0.2 MetadataSchema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.2.md#schemaObject)
	Schema string `json:"schema,omitempty"`

	// SchemaType: The type of the MetadataSchema. This is a property that
	// identifies which metadata types will use the MetadataSchema.
	//
	// Possible values:
	//   "METADATA_SCHEMA_TYPE_UNSPECIFIED" - Unspecified type for the
	// MetadataSchema.
	//   "ARTIFACT_TYPE" - A type indicating that the MetadataSchema will be
	// used by Artifacts.
	//   "EXECUTION_TYPE" - A typee indicating that the MetadataSchema will
	// be used by Executions.
	//   "CONTEXT_TYPE" - A state indicating that the MetadataSchema will be
	// used by Contexts.
	SchemaType string `json:"schemaType,omitempty"`

	// SchemaVersion: The version of the MetadataSchema. The version's
	// format must match the following regular expression: `^[0-9]+.+.+$`,
	// which would allow to order/compare different versions. Example:
	// 1.0.0, 1.0.1, etc.
	SchemaVersion string `json:"schemaVersion,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MetadataSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MetadataSchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MetadataStore: Instance of a metadata store.
// Contains a set of metadata that can be queried.
type GoogleCloudAiplatformV1MetadataStore struct {
	// CreateTime: Output only. Timestamp when this MetadataStore was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the MetadataStore.
	Description string `json:"description,omitempty"`

	// EncryptionSpec: Customer-managed encryption key spec for a Metadata
	// Store. If set, this Metadata Store and all sub-resources of this
	// Metadata Store are secured using this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// Name: Output only. The resource name of the MetadataStore instance.
	Name string `json:"name,omitempty"`

	// State: Output only. State information of the MetadataStore.
	State *GoogleCloudAiplatformV1MetadataStoreMetadataStoreState `json:"state,omitempty"`

	// UpdateTime: Output only. Timestamp when this MetadataStore was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MetadataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MetadataStore
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MetadataStoreMetadataStoreState: Represents
// state information for a MetadataStore.
type GoogleCloudAiplatformV1MetadataStoreMetadataStoreState struct {
	// DiskUtilizationBytes: The disk utilization of the MetadataStore in
	// bytes.
	DiskUtilizationBytes int64 `json:"diskUtilizationBytes,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "DiskUtilizationBytes") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskUtilizationBytes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MetadataStoreMetadataStoreState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MetadataStoreMetadataStoreState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigratableResource: Represents one resource
// that exists in automl.googleapis.com, datalabeling.googleapis.com or
// ml.googleapis.com.
type GoogleCloudAiplatformV1MigratableResource struct {
	// AutomlDataset: Output only. Represents one Dataset in
	// automl.googleapis.com.
	AutomlDataset *GoogleCloudAiplatformV1MigratableResourceAutomlDataset `json:"automlDataset,omitempty"`

	// AutomlModel: Output only. Represents one Model in
	// automl.googleapis.com.
	AutomlModel *GoogleCloudAiplatformV1MigratableResourceAutomlModel `json:"automlModel,omitempty"`

	// DataLabelingDataset: Output only. Represents one Dataset in
	// datalabeling.googleapis.com.
	DataLabelingDataset *GoogleCloudAiplatformV1MigratableResourceDataLabelingDataset `json:"dataLabelingDataset,omitempty"`

	// LastMigrateTime: Output only. Timestamp when the last migration
	// attempt on this MigratableResource started. Will not be set if
	// there's no migration attempt on this MigratableResource.
	LastMigrateTime string `json:"lastMigrateTime,omitempty"`

	// LastUpdateTime: Output only. Timestamp when this MigratableResource
	// was last updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`

	// MlEngineModelVersion: Output only. Represents one Version in
	// ml.googleapis.com.
	MlEngineModelVersion *GoogleCloudAiplatformV1MigratableResourceMlEngineModelVersion `json:"mlEngineModelVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutomlDataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutomlDataset") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigratableResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigratableResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigratableResourceAutomlDataset: Represents
// one Dataset in automl.googleapis.com.
type GoogleCloudAiplatformV1MigratableResourceAutomlDataset struct {
	// Dataset: Full resource name of automl Dataset. Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`.
	Dataset string `json:"dataset,omitempty"`

	// DatasetDisplayName: The Dataset's display name in
	// automl.googleapis.com.
	DatasetDisplayName string `json:"datasetDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dataset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigratableResourceAutomlDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigratableResourceAutomlDataset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigratableResourceAutomlModel: Represents one
// Model in automl.googleapis.com.
type GoogleCloudAiplatformV1MigratableResourceAutomlModel struct {
	// Model: Full resource name of automl Model. Format:
	// `projects/{project}/locations/{location}/models/{model}`.
	Model string `json:"model,omitempty"`

	// ModelDisplayName: The Model's display name in automl.googleapis.com.
	ModelDisplayName string `json:"modelDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Model") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigratableResourceAutomlModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigratableResourceAutomlModel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigratableResourceDataLabelingDataset:
// Represents one Dataset in datalabeling.googleapis.com.
type GoogleCloudAiplatformV1MigratableResourceDataLabelingDataset struct {
	// DataLabelingAnnotatedDatasets: The migratable AnnotatedDataset in
	// datalabeling.googleapis.com belongs to the data labeling Dataset.
	DataLabelingAnnotatedDatasets []*GoogleCloudAiplatformV1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset `json:"dataLabelingAnnotatedDatasets,omitempty"`

	// Dataset: Full resource name of data labeling Dataset. Format:
	// `projects/{project}/datasets/{dataset}`.
	Dataset string `json:"dataset,omitempty"`

	// DatasetDisplayName: The Dataset's display name in
	// datalabeling.googleapis.com.
	DatasetDisplayName string `json:"datasetDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DataLabelingAnnotatedDatasets") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "DataLabelingAnnotatedDatasets") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigratableResourceDataLabelingDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigratableResourceDataLabelingDataset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigratableResourceDataLabelingDatasetDataLabeli
// ngAnnotatedDataset: Represents one AnnotatedDataset in
// datalabeling.googleapis.com.
type GoogleCloudAiplatformV1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset struct {
	// AnnotatedDataset: Full resource name of data labeling
	// AnnotatedDataset. Format:
	// `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_da
	// taset}`.
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`

	// AnnotatedDatasetDisplayName: The AnnotatedDataset's display name in
	// datalabeling.googleapis.com.
	AnnotatedDatasetDisplayName string `json:"annotatedDatasetDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotatedDataset") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigratableResourceMlEngineModelVersion:
// Represents one model Version in ml.googleapis.com.
type GoogleCloudAiplatformV1MigratableResourceMlEngineModelVersion struct {
	// Endpoint: The ml.googleapis.com endpoint that this model Version
	// currently lives in. Example values: * ml.googleapis.com *
	// us-centrall-ml.googleapis.com * europe-west4-ml.googleapis.com *
	// asia-east1-ml.googleapis.com
	Endpoint string `json:"endpoint,omitempty"`

	// Version: Full resource name of ml engine model Version. Format:
	// `projects/{project}/models/{model}/versions/{version}`.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Endpoint") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Endpoint") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigratableResourceMlEngineModelVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigratableResourceMlEngineModelVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigrateResourceRequest: Config of migrating
// one resource from automl.googleapis.com, datalabeling.googleapis.com
// and ml.googleapis.com to Vertex AI.
type GoogleCloudAiplatformV1MigrateResourceRequest struct {
	// MigrateAutomlDatasetConfig: Config for migrating Dataset in
	// automl.googleapis.com to Vertex AI's Dataset.
	MigrateAutomlDatasetConfig *GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlDatasetConfig `json:"migrateAutomlDatasetConfig,omitempty"`

	// MigrateAutomlModelConfig: Config for migrating Model in
	// automl.googleapis.com to Vertex AI's Model.
	MigrateAutomlModelConfig *GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlModelConfig `json:"migrateAutomlModelConfig,omitempty"`

	// MigrateDataLabelingDatasetConfig: Config for migrating Dataset in
	// datalabeling.googleapis.com to Vertex AI's Dataset.
	MigrateDataLabelingDatasetConfig *GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfig `json:"migrateDataLabelingDatasetConfig,omitempty"`

	// MigrateMlEngineModelVersionConfig: Config for migrating Version in
	// ml.googleapis.com to Vertex AI's Model.
	MigrateMlEngineModelVersionConfig *GoogleCloudAiplatformV1MigrateResourceRequestMigrateMlEngineModelVersionConfig `json:"migrateMlEngineModelVersionConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MigrateAutomlDatasetConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "MigrateAutomlDatasetConfig") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigrateResourceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigrateResourceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlDatasetConfi
// g: Config for migrating Dataset in automl.googleapis.com to Vertex
// AI's Dataset.
type GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlDatasetConfig struct {
	// Dataset: Required. Full resource name of automl Dataset. Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`.
	Dataset string `json:"dataset,omitempty"`

	// DatasetDisplayName: Required. Display name of the Dataset in Vertex
	// AI. System will pick a display name if unspecified.
	DatasetDisplayName string `json:"datasetDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dataset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlDatasetConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlDatasetConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlModelConfig:
//
//	Config for migrating Model in automl.googleapis.com to Vertex AI's
//
// Model.
type GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlModelConfig struct {
	// Model: Required. Full resource name of automl Model. Format:
	// `projects/{project}/locations/{location}/models/{model}`.
	Model string `json:"model,omitempty"`

	// ModelDisplayName: Optional. Display name of the model in Vertex AI.
	// System will pick a display name if unspecified.
	ModelDisplayName string `json:"modelDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Model") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlModelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlModelConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatase
// tConfig: Config for migrating Dataset in datalabeling.googleapis.com
// to Vertex AI's Dataset.
type GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfig struct {
	// Dataset: Required. Full resource name of data labeling Dataset.
	// Format: `projects/{project}/datasets/{dataset}`.
	Dataset string `json:"dataset,omitempty"`

	// DatasetDisplayName: Optional. Display name of the Dataset in Vertex
	// AI. System will pick a display name if unspecified.
	DatasetDisplayName string `json:"datasetDisplayName,omitempty"`

	// MigrateDataLabelingAnnotatedDatasetConfigs: Optional. Configs for
	// migrating AnnotatedDataset in datalabeling.googleapis.com to Vertex
	// AI's SavedQuery. The specified AnnotatedDatasets have to belong to
	// the datalabeling Dataset.
	MigrateDataLabelingAnnotatedDatasetConfigs []*GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig `json:"migrateDataLabelingAnnotatedDatasetConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dataset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatase
// tConfigMigrateDataLabelingAnnotatedDatasetConfig: Config for
// migrating AnnotatedDataset in datalabeling.googleapis.com to Vertex
// AI's SavedQuery.
type GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig struct {
	// AnnotatedDataset: Required. Full resource name of data labeling
	// AnnotatedDataset. Format:
	// `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_da
	// taset}`.
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotatedDataset") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigrateResourceRequestMigrateMlEngineModelVersi
// onConfig: Config for migrating version in ml.googleapis.com to Vertex
// AI's Model.
type GoogleCloudAiplatformV1MigrateResourceRequestMigrateMlEngineModelVersionConfig struct {
	// Endpoint: Required. The ml.googleapis.com endpoint that this model
	// version should be migrated from. Example values: * ml.googleapis.com
	// * us-centrall-ml.googleapis.com * europe-west4-ml.googleapis.com *
	// asia-east1-ml.googleapis.com
	Endpoint string `json:"endpoint,omitempty"`

	// ModelDisplayName: Required. Display name of the model in Vertex AI.
	// System will pick a display name if unspecified.
	ModelDisplayName string `json:"modelDisplayName,omitempty"`

	// ModelVersion: Required. Full resource name of ml engine model
	// version. Format:
	// `projects/{project}/models/{model}/versions/{version}`.
	ModelVersion string `json:"modelVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Endpoint") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Endpoint") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigrateResourceRequestMigrateMlEngineModelVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigrateResourceRequestMigrateMlEngineModelVersionConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MigrateResourceResponse: Describes a
// successfully migrated resource.
type GoogleCloudAiplatformV1MigrateResourceResponse struct {
	// Dataset: Migrated Dataset's resource name.
	Dataset string `json:"dataset,omitempty"`

	// MigratableResource: Before migration, the identifier in
	// ml.googleapis.com, automl.googleapis.com or
	// datalabeling.googleapis.com.
	MigratableResource *GoogleCloudAiplatformV1MigratableResource `json:"migratableResource,omitempty"`

	// Model: Migrated Model's resource name.
	Model string `json:"model,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dataset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MigrateResourceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MigrateResourceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Model: A trained machine learning Model.
type GoogleCloudAiplatformV1Model struct {
	// ArtifactUri: Immutable. The path to the directory containing the
	// Model artifact and any of its supporting files. Not required for
	// AutoML Models.
	ArtifactUri string `json:"artifactUri,omitempty"`

	// BaseModelSource: Optional. User input field to specify the base model
	// source. Currently it only supports specifing the Model Garden models
	// and Genie models.
	BaseModelSource *GoogleCloudAiplatformV1ModelBaseModelSource `json:"baseModelSource,omitempty"`

	// ContainerSpec: Input only. The specification of the container that is
	// to be used when deploying this Model. The specification is ingested
	// upon ModelService.UploadModel, and all binaries it contains are
	// copied and stored internally by Vertex AI. Not required for AutoML
	// Models.
	ContainerSpec *GoogleCloudAiplatformV1ModelContainerSpec `json:"containerSpec,omitempty"`

	// CreateTime: Output only. Timestamp when this Model was uploaded into
	// Vertex AI.
	CreateTime string `json:"createTime,omitempty"`

	// DataStats: Stats of data used for training or evaluating the Model.
	// Only populated when the Model is trained by a TrainingPipeline with
	// data_input_config.
	DataStats *GoogleCloudAiplatformV1ModelDataStats `json:"dataStats,omitempty"`

	// DeployedModels: Output only. The pointers to DeployedModels created
	// from this Model. Note that Model could have been deployed to
	// Endpoints in different Locations.
	DeployedModels []*GoogleCloudAiplatformV1DeployedModelRef `json:"deployedModels,omitempty"`

	// Description: The description of the Model.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The display name of the Model. The name can be
	// up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`

	// EncryptionSpec: Customer-managed encryption key spec for a Model. If
	// set, this Model and all sub-resources of this Model will be secured
	// by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// Etag: Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`

	// ExplanationSpec: The default explanation specification for this
	// Model. The Model can be used for requesting explanation after being
	// deployed if it is populated. The Model can be used for batch
	// explanation if it is populated. All fields of the explanation_spec
	// can be overridden by explanation_spec of
	// DeployModelRequest.deployed_model, or explanation_spec of
	// BatchPredictionJob. If the default explanation specification is not
	// set for this Model, this Model can still be used for requesting
	// explanation by setting explanation_spec of
	// DeployModelRequest.deployed_model and for batch explanation by
	// setting explanation_spec of BatchPredictionJob.
	ExplanationSpec *GoogleCloudAiplatformV1ExplanationSpec `json:"explanationSpec,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// Models. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are
	// allowed. See https://goo.gl/xmQnxf for more information and examples
	// of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// Metadata: Immutable. An additional information about the Model; the
	// schema of the metadata can be found in metadata_schema. Unset if the
	// Model does not have any additional information.
	Metadata interface{} `json:"metadata,omitempty"`

	// MetadataArtifact: Output only. The resource name of the Artifact that
	// was created in MetadataStore when creating the Model. The Artifact
	// resource name pattern is
	// `projects/{project}/locations/{location}/metadataStores/{metadata_stor
	// e}/artifacts/{artifact}`.
	MetadataArtifact string `json:"metadataArtifact,omitempty"`

	// MetadataSchemaUri: Immutable. Points to a YAML file stored on Google
	// Cloud Storage describing additional information about the Model, that
	// is specific to it. Unset if the Model does not have any additional
	// information. The schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// AutoML Models always have this field populated by Vertex AI, if no
	// additional metadata is needed, this field is set to an empty string.
	// Note: The URI given on output will be immutable and probably
	// different, including the URI scheme, than the one given on input. The
	// output URI will point to a location where the user only has a read
	// access.
	MetadataSchemaUri string `json:"metadataSchemaUri,omitempty"`

	// ModelSourceInfo: Output only. Source of a model. It can either be
	// automl training pipeline, custom training pipeline, BigQuery ML, or
	// saved and tuned from Genie or Model Garden.
	ModelSourceInfo *GoogleCloudAiplatformV1ModelSourceInfo `json:"modelSourceInfo,omitempty"`

	// Name: The resource name of the Model.
	Name string `json:"name,omitempty"`

	// OriginalModelInfo: Output only. If this Model is a copy of another
	// Model, this contains info about the original.
	OriginalModelInfo *GoogleCloudAiplatformV1ModelOriginalModelInfo `json:"originalModelInfo,omitempty"`

	// PipelineJob: Optional. This field is populated if the model is
	// produced by a pipeline job.
	PipelineJob string `json:"pipelineJob,omitempty"`

	// PredictSchemata: The schemata that describe formats of the Model's
	// predictions and explanations as given and returned via
	// PredictionService.Predict and PredictionService.Explain.
	PredictSchemata *GoogleCloudAiplatformV1PredictSchemata `json:"predictSchemata,omitempty"`

	// SupportedDeploymentResourcesTypes: Output only. When this Model is
	// deployed, its prediction resources are described by the
	// `prediction_resources` field of the Endpoint.deployed_models object.
	// Because not all Models support all resource configuration types, the
	// configuration types this Model supports are listed here. If no
	// configuration types are listed, the Model cannot be deployed to an
	// Endpoint and does not support online predictions
	// (PredictionService.Predict or PredictionService.Explain). Such a
	// Model can serve predictions by using a BatchPredictionJob, if it has
	// at least one entry each in supported_input_storage_formats and
	// supported_output_storage_formats.
	//
	// Possible values:
	//   "DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED" - Should not be used.
	//   "DEDICATED_RESOURCES" - Resources that are dedicated to the
	// DeployedModel, and that need a higher degree of manual configuration.
	//   "AUTOMATIC_RESOURCES" - Resources that to large degree are decided
	// by Vertex AI, and require only a modest additional configuration.
	//   "SHARED_RESOURCES" - Resources that can be shared by multiple
	// DeployedModels. A pre-configured DeploymentResourcePool is required.
	SupportedDeploymentResourcesTypes []string `json:"supportedDeploymentResourcesTypes,omitempty"`

	// SupportedExportFormats: Output only. The formats in which this Model
	// may be exported. If empty, this Model is not available for export.
	SupportedExportFormats []*GoogleCloudAiplatformV1ModelExportFormat `json:"supportedExportFormats,omitempty"`

	// SupportedInputStorageFormats: Output only. The formats this Model
	// supports in BatchPredictionJob.input_config. If
	// PredictSchemata.instance_schema_uri exists, the instances should be
	// given as per that schema. The possible formats are: * `jsonl` The
	// JSON Lines format, where each instance is a single line. Uses
	// GcsSource. * `csv` The CSV format, where each instance is a single
	// comma-separated line. The first line in the file is the header,
	// containing comma-separated field names. Uses GcsSource. * `tf-record`
	// The TFRecord format, where each instance is a single record in
	// tfrecord syntax. Uses GcsSource. * `tf-record-gzip` Similar to
	// `tf-record`, but the file is gzipped. Uses GcsSource. * `bigquery`
	// Each instance is a single row in BigQuery. Uses BigQuerySource. *
	// `file-list` Each line of the file is the location of an instance to
	// process, uses `gcs_source` field of the InputConfig object. If this
	// Model doesn't support any of these formats it means it cannot be used
	// with a BatchPredictionJob. However, if it has
	// supported_deployment_resources_types, it could serve online
	// predictions by using PredictionService.Predict or
	// PredictionService.Explain.
	SupportedInputStorageFormats []string `json:"supportedInputStorageFormats,omitempty"`

	// SupportedOutputStorageFormats: Output only. The formats this Model
	// supports in BatchPredictionJob.output_config. If both
	// PredictSchemata.instance_schema_uri and
	// PredictSchemata.prediction_schema_uri exist, the predictions are
	// returned together with their instances. In other words, the
	// prediction has the original instance data first, followed by the
	// actual prediction content (as per the schema). The possible formats
	// are: * `jsonl` The JSON Lines format, where each prediction is a
	// single line. Uses GcsDestination. * `csv` The CSV format, where each
	// prediction is a single comma-separated line. The first line in the
	// file is the header, containing comma-separated field names. Uses
	// GcsDestination. * `bigquery` Each prediction is a single row in a
	// BigQuery table, uses BigQueryDestination . If this Model doesn't
	// support any of these formats it means it cannot be used with a
	// BatchPredictionJob. However, if it has
	// supported_deployment_resources_types, it could serve online
	// predictions by using PredictionService.Predict or
	// PredictionService.Explain.
	SupportedOutputStorageFormats []string `json:"supportedOutputStorageFormats,omitempty"`

	// TrainingPipeline: Output only. The resource name of the
	// TrainingPipeline that uploaded this Model, if any.
	TrainingPipeline string `json:"trainingPipeline,omitempty"`

	// UpdateTime: Output only. Timestamp when this Model was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// VersionAliases: User provided version aliases so that a model version
	// can be referenced via alias (i.e.
	// `projects/{project}/locations/{location}/models/{model_id}@{version_al
	// ias}` instead of auto-generated version id (i.e.
	// `projects/{project}/locations/{location}/models/{model_id}@{version_id
	// })`. The format is a-z{0,126}[a-z0-9] to distinguish from version_id.
	// A default version alias will be created for the first version of the
	// model, and there must be exactly one default version alias for a
	// model.
	VersionAliases []string `json:"versionAliases,omitempty"`

	// VersionCreateTime: Output only. Timestamp when this version was
	// created.
	VersionCreateTime string `json:"versionCreateTime,omitempty"`

	// VersionDescription: The description of this version.
	VersionDescription string `json:"versionDescription,omitempty"`

	// VersionId: Output only. Immutable. The version ID of the model. A new
	// version is committed when a new model version is uploaded or trained
	// under an existing model id. It is an auto-incrementing decimal number
	// in string representation.
	VersionId string `json:"versionId,omitempty"`

	// VersionUpdateTime: Output only. Timestamp when this version was most
	// recently updated.
	VersionUpdateTime string `json:"versionUpdateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ArtifactUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArtifactUri") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Model) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Model
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelBaseModelSource: User input field to
// specify the base model source. Currently it only supports specifing
// the Model Garden models and Genie models.
type GoogleCloudAiplatformV1ModelBaseModelSource struct {
	// GenieSource: Information about the base model of Genie models.
	GenieSource *GoogleCloudAiplatformV1GenieSource `json:"genieSource,omitempty"`

	// ModelGardenSource: Source information of Model Garden models.
	ModelGardenSource *GoogleCloudAiplatformV1ModelGardenSource `json:"modelGardenSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenieSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenieSource") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelBaseModelSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelBaseModelSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelContainerSpec: Specification of a
// container for serving predictions. Some fields in this message
// correspond to fields in the Kubernetes Container v1 core
// specification
// (https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
type GoogleCloudAiplatformV1ModelContainerSpec struct {
	// Args: Immutable. Specifies arguments for the command that runs when
	// the container starts. This overrides the container's `CMD`
	// (https://docs.docker.com/engine/reference/builder/#cmd). Specify this
	// field as an array of executable and arguments, similar to a Docker
	// `CMD`'s "default parameters" form. If you don't specify this field
	// but do specify the command field, then the command from the `command`
	// field runs without any additional arguments. See the Kubernetes
	// documentation about how the `command` and `args` fields interact with
	// a container's `ENTRYPOINT` and `CMD`
	// (https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
	// If you don't specify this field and don't specify the `command`
	// field, then the container's `ENTRYPOINT`
	// (https://docs.docker.com/engine/reference/builder/#cmd) and `CMD`
	// determine what runs based on their default behavior. See the Docker
	// documentation about how `CMD` and `ENTRYPOINT` interact
	// (https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
	// In this field, you can reference environment variables set by Vertex
	// AI
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
	// and environment variables set in the env field. You cannot reference
	// environment variables set in the Docker image. In order for
	// environment variables to be expanded, reference them by using the
	// following syntax: $( VARIABLE_NAME) Note that this differs from Bash
	// variable expansion, which does not use parentheses. If a variable
	// cannot be resolved, the reference in the input string is used
	// unchanged. To avoid variable expansion, you can escape this syntax
	// with `$$`; for example: $$(VARIABLE_NAME) This field corresponds to
	// the `args` field of the Kubernetes Containers v1 core API
	// (https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
	Args []string `json:"args,omitempty"`

	// Command: Immutable. Specifies the command that runs when the
	// container starts. This overrides the container's ENTRYPOINT
	// (https://docs.docker.com/engine/reference/builder/#entrypoint).
	// Specify this field as an array of executable and arguments, similar
	// to a Docker `ENTRYPOINT`'s "exec" form, not its "shell" form. If you
	// do not specify this field, then the container's `ENTRYPOINT` runs, in
	// conjunction with the args field or the container's `CMD`
	// (https://docs.docker.com/engine/reference/builder/#cmd), if either
	// exists. If this field is not specified and the container does not
	// have an `ENTRYPOINT`, then refer to the Docker documentation about
	// how `CMD` and `ENTRYPOINT` interact
	// (https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
	// If you specify this field, then you can also specify the `args` field
	// to provide additional arguments for this command. However, if you
	// specify this field, then the container's `CMD` is ignored. See the
	// Kubernetes documentation about how the `command` and `args` fields
	// interact with a container's `ENTRYPOINT` and `CMD`
	// (https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
	// In this field, you can reference environment variables set by Vertex
	// AI
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
	// and environment variables set in the env field. You cannot reference
	// environment variables set in the Docker image. In order for
	// environment variables to be expanded, reference them by using the
	// following syntax: $( VARIABLE_NAME) Note that this differs from Bash
	// variable expansion, which does not use parentheses. If a variable
	// cannot be resolved, the reference in the input string is used
	// unchanged. To avoid variable expansion, you can escape this syntax
	// with `$$`; for example: $$(VARIABLE_NAME) This field corresponds to
	// the `command` field of the Kubernetes Containers v1 core API
	// (https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
	Command []string `json:"command,omitempty"`

	// DeploymentTimeout: Immutable. Deployment timeout. Limit for
	// deployment timeout is 2 hours.
	DeploymentTimeout string `json:"deploymentTimeout,omitempty"`

	// Env: Immutable. List of environment variables to set in the
	// container. After the container starts running, code running in the
	// container can read these environment variables. Additionally, the
	// command and args fields can reference these variables. Later entries
	// in this list can also reference earlier entries. For example, the
	// following example sets the variable `VAR_2` to have the value `foo
	// bar`: ```json [ { "name": "VAR_1", "value": "foo" }, { "name":
	// "VAR_2", "value": "$(VAR_1) bar" } ] ``` If you switch the order of
	// the variables in the example, then the expansion does not occur. This
	// field corresponds to the `env` field of the Kubernetes Containers v1
	// core API
	// (https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
	Env []*GoogleCloudAiplatformV1EnvVar `json:"env,omitempty"`

	// GrpcPorts: Immutable. List of ports to expose from the container.
	// Vertex AI sends gRPC prediction requests that it receives to the
	// first port on this list. Vertex AI also sends liveness and health
	// checks to this port. If you do not specify this field, gRPC requests
	// to the container will be disabled. Vertex AI does not use ports other
	// than the first one listed. This field corresponds to the `ports`
	// field of the Kubernetes Containers v1 core API.
	GrpcPorts []*GoogleCloudAiplatformV1Port `json:"grpcPorts,omitempty"`

	// HealthProbe: Immutable. Specification for Kubernetes readiness probe.
	HealthProbe *GoogleCloudAiplatformV1Probe `json:"healthProbe,omitempty"`

	// HealthRoute: Immutable. HTTP path on the container to send health
	// checks to. Vertex AI intermittently sends GET requests to this path
	// on the container's IP address and port to check that the container is
	// healthy. Read more about health checks
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
	// For example, if you set this field to `/bar`, then Vertex AI
	// intermittently sends a GET request to the `/bar` path on the port of
	// your container specified by the first value of this
	// `ModelContainerSpec`'s ports field. If you don't specify this field,
	// it defaults to the following value when you deploy this Model to an
	// Endpoint: /v1/endpoints/ENDPOINT/deployedModels/
	// DEPLOYED_MODEL:predict The placeholders in this value are replaced as
	// follows: * ENDPOINT: The last segment (following `endpoints/`)of the
	// Endpoint.name][] field of the Endpoint where this Model has been
	// deployed. (Vertex AI makes this value available to your container
	// code as the `AIP_ENDPOINT_ID` environment variable
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
	// * DEPLOYED_MODEL: DeployedModel.id of the `DeployedModel`. (Vertex AI
	// makes this value available to your container code as the
	// `AIP_DEPLOYED_MODEL_ID` environment variable
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
	HealthRoute string `json:"healthRoute,omitempty"`

	// ImageUri: Required. Immutable. URI of the Docker image to be used as
	// the custom container for serving predictions. This URI must identify
	// an image in Artifact Registry or Container Registry. Learn more about
	// the container publishing requirements
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
	// including permissions requirements for the Vertex AI Service Agent.
	// The container image is ingested upon ModelService.UploadModel, stored
	// internally, and this original path is afterwards not used. To learn
	// about the requirements for the Docker image itself, see Custom
	// container requirements
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
	// You can use the URI to one of Vertex AI's pre-built container images
	// for prediction
	// (https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
	// in this field.
	ImageUri string `json:"imageUri,omitempty"`

	// Ports: Immutable. List of ports to expose from the container. Vertex
	// AI sends any prediction requests that it receives to the first port
	// on this list. Vertex AI also sends liveness and health checks
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
	// to this port. If you do not specify this field, it defaults to
	// following value: ```json [ { "containerPort": 8080 } ] ``` Vertex AI
	// does not use ports other than the first one listed. This field
	// corresponds to the `ports` field of the Kubernetes Containers v1 core
	// API
	// (https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
	Ports []*GoogleCloudAiplatformV1Port `json:"ports,omitempty"`

	// PredictRoute: Immutable. HTTP path on the container to send
	// prediction requests to. Vertex AI forwards requests sent using
	// projects.locations.endpoints.predict to this path on the container's
	// IP address and port. Vertex AI then returns the container's response
	// in the API response. For example, if you set this field to `/foo`,
	// then when Vertex AI receives a prediction request, it forwards the
	// request body in a POST request to the `/foo` path on the port of your
	// container specified by the first value of this `ModelContainerSpec`'s
	// ports field. If you don't specify this field, it defaults to the
	// following value when you deploy this Model to an Endpoint:
	// /v1/endpoints/ENDPOINT/deployedModels/DEPLOYED_MODEL:predict The
	// placeholders in this value are replaced as follows: * ENDPOINT: The
	// last segment (following `endpoints/`)of the Endpoint.name][] field of
	// the Endpoint where this Model has been deployed. (Vertex AI makes
	// this value available to your container code as the `AIP_ENDPOINT_ID`
	// environment variable
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
	// * DEPLOYED_MODEL: DeployedModel.id of the `DeployedModel`. (Vertex AI
	// makes this value available to your container code as the
	// `AIP_DEPLOYED_MODEL_ID` environment variable
	// (https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
	PredictRoute string `json:"predictRoute,omitempty"`

	// SharedMemorySizeMb: Immutable. The amount of the VM memory to reserve
	// as the shared memory for the model in megabytes.
	SharedMemorySizeMb int64 `json:"sharedMemorySizeMb,omitempty,string"`

	// StartupProbe: Immutable. Specification for Kubernetes startup probe.
	StartupProbe *GoogleCloudAiplatformV1Probe `json:"startupProbe,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelContainerSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelContainerSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelDataStats: Stats of data used for train
// or evaluate the Model.
type GoogleCloudAiplatformV1ModelDataStats struct {
	// TestAnnotationsCount: Number of Annotations that are used for
	// evaluating this Model. If the Model is evaluated multiple times, this
	// will be the number of test Annotations used by the first evaluation.
	// If the Model is not evaluated, the number is 0.
	TestAnnotationsCount int64 `json:"testAnnotationsCount,omitempty,string"`

	// TestDataItemsCount: Number of DataItems that were used for evaluating
	// this Model. If the Model is evaluated multiple times, this will be
	// the number of test DataItems used by the first evaluation. If the
	// Model is not evaluated, the number is 0.
	TestDataItemsCount int64 `json:"testDataItemsCount,omitempty,string"`

	// TrainingAnnotationsCount: Number of Annotations that are used for
	// training this Model.
	TrainingAnnotationsCount int64 `json:"trainingAnnotationsCount,omitempty,string"`

	// TrainingDataItemsCount: Number of DataItems that were used for
	// training this Model.
	TrainingDataItemsCount int64 `json:"trainingDataItemsCount,omitempty,string"`

	// ValidationAnnotationsCount: Number of Annotations that are used for
	// validating this Model during training.
	ValidationAnnotationsCount int64 `json:"validationAnnotationsCount,omitempty,string"`

	// ValidationDataItemsCount: Number of DataItems that were used for
	// validating this Model during training.
	ValidationDataItemsCount int64 `json:"validationDataItemsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "TestAnnotationsCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TestAnnotationsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelDataStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelDataStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelDeploymentMonitoringBigQueryTable:
// ModelDeploymentMonitoringBigQueryTable specifies the BigQuery table
// name as well as some information of the logs stored in this table.
type GoogleCloudAiplatformV1ModelDeploymentMonitoringBigQueryTable struct {
	// BigqueryTablePath: The created BigQuery table to store logs. Customer
	// could do their own query & analysis. Format:
	// `bq://.model_deployment_monitoring_._`
	BigqueryTablePath string `json:"bigqueryTablePath,omitempty"`

	// LogSource: The source of log.
	//
	// Possible values:
	//   "LOG_SOURCE_UNSPECIFIED" - Unspecified source.
	//   "TRAINING" - Logs coming from Training dataset.
	//   "SERVING" - Logs coming from Serving traffic.
	LogSource string `json:"logSource,omitempty"`

	// LogType: The type of log.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Unspecified type.
	//   "PREDICT" - Predict logs.
	//   "EXPLAIN" - Explain logs.
	LogType string `json:"logType,omitempty"`

	// RequestResponseLoggingSchemaVersion: Output only. The schema version
	// of the request/response logging BigQuery table. Default to v1 if
	// unset.
	RequestResponseLoggingSchemaVersion string `json:"requestResponseLoggingSchemaVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigqueryTablePath")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryTablePath") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelDeploymentMonitoringBigQueryTable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelDeploymentMonitoringBigQueryTable
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelDeploymentMonitoringJob: Represents a job
// that runs periodically to monitor the deployed models in an endpoint.
// It will analyze the logged training & prediction data to detect any
// abnormal behaviors.
type GoogleCloudAiplatformV1ModelDeploymentMonitoringJob struct {
	// AnalysisInstanceSchemaUri: YAML schema file uri describing the format
	// of a single instance that you want Tensorflow Data Validation (TFDV)
	// to analyze. If this field is empty, all the feature data types are
	// inferred from predict_instance_schema_uri, meaning that TFDV will use
	// the data in the exact format(data type) as prediction
	// request/response. If there are any data type differences between
	// predict instance and TFDV instance, this field can be used to
	// override the schema. For models trained with Vertex AI, this field
	// must be set as all the fields in predict instance formatted as
	// string.
	AnalysisInstanceSchemaUri string `json:"analysisInstanceSchemaUri,omitempty"`

	// BigqueryTables: Output only. The created bigquery tables for the job
	// under customer project. Customer could do their own query & analysis.
	// There could be 4 log tables in maximum: 1. Training data logging
	// predict request/response 2. Serving data logging predict
	// request/response
	BigqueryTables []*GoogleCloudAiplatformV1ModelDeploymentMonitoringBigQueryTable `json:"bigqueryTables,omitempty"`

	// CreateTime: Output only. Timestamp when this
	// ModelDeploymentMonitoringJob was created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Required. The user-defined name of the
	// ModelDeploymentMonitoringJob. The name can be up to 128 characters
	// long and can consist of any UTF-8 characters. Display name of a
	// ModelDeploymentMonitoringJob.
	DisplayName string `json:"displayName,omitempty"`

	// EnableMonitoringPipelineLogs: If true, the scheduled monitoring
	// pipeline logs are sent to Google Cloud Logging, including pipeline
	// status and anomalies detected. Please note the logs incur cost, which
	// are subject to Cloud Logging pricing
	// (https://cloud.google.com/logging#pricing).
	EnableMonitoringPipelineLogs bool `json:"enableMonitoringPipelineLogs,omitempty"`

	// EncryptionSpec: Customer-managed encryption key spec for a
	// ModelDeploymentMonitoringJob. If set, this
	// ModelDeploymentMonitoringJob and all sub-resources of this
	// ModelDeploymentMonitoringJob will be secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// Endpoint: Required. Endpoint resource name. Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `json:"endpoint,omitempty"`

	// Error: Output only. Only populated when the job's state is
	// `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// ModelDeploymentMonitoringJob. Label keys and values can be no longer
	// than 64 characters (Unicode codepoints), can only contain lowercase
	// letters, numeric characters, underscores and dashes. International
	// characters are allowed. See https://goo.gl/xmQnxf for more
	// information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// LatestMonitoringPipelineMetadata: Output only. Latest triggered
	// monitoring pipeline metadata.
	LatestMonitoringPipelineMetadata *GoogleCloudAiplatformV1ModelDeploymentMonitoringJobLatestMonitoringPipelineMetadata `json:"latestMonitoringPipelineMetadata,omitempty"`

	// LogTtl: The TTL of BigQuery tables in user projects which stores
	// logs. A day is the basic unit of the TTL and we take the ceil of
	// TTL/86400(a day). e.g. { second: 3600} indicates ttl = 1 day.
	LogTtl string `json:"logTtl,omitempty"`

	// LoggingSamplingStrategy: Required. Sample Strategy for logging.
	LoggingSamplingStrategy *GoogleCloudAiplatformV1SamplingStrategy `json:"loggingSamplingStrategy,omitempty"`

	// ModelDeploymentMonitoringObjectiveConfigs: Required. The config for
	// monitoring objectives. This is a per DeployedModel config. Each
	// DeployedModel needs to be configured separately.
	ModelDeploymentMonitoringObjectiveConfigs []*GoogleCloudAiplatformV1ModelDeploymentMonitoringObjectiveConfig `json:"modelDeploymentMonitoringObjectiveConfigs,omitempty"`

	// ModelDeploymentMonitoringScheduleConfig: Required. Schedule config
	// for running the monitoring job.
	ModelDeploymentMonitoringScheduleConfig *GoogleCloudAiplatformV1ModelDeploymentMonitoringScheduleConfig `json:"modelDeploymentMonitoringScheduleConfig,omitempty"`

	// ModelMonitoringAlertConfig: Alert config for model monitoring.
	ModelMonitoringAlertConfig *GoogleCloudAiplatformV1ModelMonitoringAlertConfig `json:"modelMonitoringAlertConfig,omitempty"`

	// Name: Output only. Resource name of a ModelDeploymentMonitoringJob.
	Name string `json:"name,omitempty"`

	// NextScheduleTime: Output only. Timestamp when this monitoring
	// pipeline will be scheduled to run for the next round.
	NextScheduleTime string `json:"nextScheduleTime,omitempty"`

	// PredictInstanceSchemaUri: YAML schema file uri describing the format
	// of a single instance, which are given to format this Endpoint's
	// prediction (and explanation). If not set, we will generate predict
	// schema from collected predict requests.
	PredictInstanceSchemaUri string `json:"predictInstanceSchemaUri,omitempty"`

	// SamplePredictInstance: Sample Predict instance, same format as
	// PredictRequest.instances, this can be set as a replacement of
	// ModelDeploymentMonitoringJob.predict_instance_schema_uri. If not set,
	// we will generate predict schema from collected predict requests.
	SamplePredictInstance interface{} `json:"samplePredictInstance,omitempty"`

	// ScheduleState: Output only. Schedule state when the monitoring job is
	// in Running state.
	//
	// Possible values:
	//   "MONITORING_SCHEDULE_STATE_UNSPECIFIED" - Unspecified state.
	//   "PENDING" - The pipeline is picked up and wait to run.
	//   "OFFLINE" - The pipeline is offline and will be scheduled for next
	// run.
	//   "RUNNING" - The pipeline is running.
	ScheduleState string `json:"scheduleState,omitempty"`

	// State: Output only. The detailed state of the monitoring job. When
	// the job is still creating, the state will be 'PENDING'. Once the job
	// is successfully created, the state will be 'RUNNING'. Pause the job,
	// the state will be 'PAUSED'. Resume the job, the state will return to
	// 'RUNNING'.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this
	// state the job may only go to either `JOB_STATE_SUCCEEDED`,
	// `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to
	// the `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded,
	// some results may be missing due to errors.
	State string `json:"state,omitempty"`

	// StatsAnomaliesBaseDirectory: Stats anomalies base folder path.
	StatsAnomaliesBaseDirectory *GoogleCloudAiplatformV1GcsDestination `json:"statsAnomaliesBaseDirectory,omitempty"`

	// UpdateTime: Output only. Timestamp when this
	// ModelDeploymentMonitoringJob was updated most recently.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AnalysisInstanceSchemaUri") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AnalysisInstanceSchemaUri") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelDeploymentMonitoringJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelDeploymentMonitoringJob
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelDeploymentMonitoringJobLatestMonitoringPip
// elineMetadata: All metadata of most recent monitoring pipelines.
type GoogleCloudAiplatformV1ModelDeploymentMonitoringJobLatestMonitoringPipelineMetadata struct {
	// RunTime: The time that most recent monitoring pipelines that is
	// related to this run.
	RunTime string `json:"runTime,omitempty"`

	// Status: The status of the most recent monitoring pipeline.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RunTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RunTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelDeploymentMonitoringJobLatestMonitoringPipelineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelDeploymentMonitoringJobLatestMonitoringPipelineMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelDeploymentMonitoringObjectiveConfig:
// ModelDeploymentMonitoringObjectiveConfig contains the pair of
// deployed_model_id to ModelMonitoringObjectiveConfig.
type GoogleCloudAiplatformV1ModelDeploymentMonitoringObjectiveConfig struct {
	// DeployedModelId: The DeployedModel ID of the objective config.
	DeployedModelId string `json:"deployedModelId,omitempty"`

	// ObjectiveConfig: The objective config of for the modelmonitoring job
	// of this deployed model.
	ObjectiveConfig *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfig `json:"objectiveConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedModelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedModelId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelDeploymentMonitoringObjectiveConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelDeploymentMonitoringObjectiveConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelDeploymentMonitoringScheduleConfig: The
// config for scheduling monitoring job.
type GoogleCloudAiplatformV1ModelDeploymentMonitoringScheduleConfig struct {
	// MonitorInterval: Required. The model monitoring job scheduling
	// interval. It will be rounded up to next full hour. This defines how
	// often the monitoring jobs are triggered.
	MonitorInterval string `json:"monitorInterval,omitempty"`

	// MonitorWindow: The time window of the prediction data being included
	// in each prediction dataset. This window specifies how long the data
	// should be collected from historical model results for each run. If
	// not set, ModelDeploymentMonitoringScheduleConfig.monitor_interval
	// will be used. e.g. If currently the cutoff time is 2022-01-08
	// 14:30:00 and the monitor_window is set to be 3600, then data from
	// 2022-01-08 13:30:00 to 2022-01-08 14:30:00 will be retrieved and
	// aggregated to calculate the monitoring statistics.
	MonitorWindow string `json:"monitorWindow,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MonitorInterval") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MonitorInterval") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelDeploymentMonitoringScheduleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelDeploymentMonitoringScheduleConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelEvaluation: A collection of metrics
// calculated by comparing Model's predictions on all of the test data
// against annotations from the test data.
type GoogleCloudAiplatformV1ModelEvaluation struct {
	// AnnotationSchemaUri: Points to a YAML file stored on Google Cloud
	// Storage describing EvaluatedDataItemView.predictions,
	// EvaluatedDataItemView.ground_truths, EvaluatedAnnotation.predictions,
	// and EvaluatedAnnotation.ground_truths. The schema is defined as an
	// OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// This field is not populated if there are neither
	// EvaluatedDataItemViews nor EvaluatedAnnotations under this
	// ModelEvaluation.
	AnnotationSchemaUri string `json:"annotationSchemaUri,omitempty"`

	// CreateTime: Output only. Timestamp when this ModelEvaluation was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DataItemSchemaUri: Points to a YAML file stored on Google Cloud
	// Storage describing EvaluatedDataItemView.data_item_payload and
	// EvaluatedAnnotation.data_item_payload. The schema is defined as an
	// OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// This field is not populated if there are neither
	// EvaluatedDataItemViews nor EvaluatedAnnotations under this
	// ModelEvaluation.
	DataItemSchemaUri string `json:"dataItemSchemaUri,omitempty"`

	// DisplayName: The display name of the ModelEvaluation.
	DisplayName string `json:"displayName,omitempty"`

	// ExplanationSpecs: Describes the values of ExplanationSpec that are
	// used for explaining the predicted values on the evaluated data.
	ExplanationSpecs []*GoogleCloudAiplatformV1ModelEvaluationModelEvaluationExplanationSpec `json:"explanationSpecs,omitempty"`

	// Metadata: The metadata of the ModelEvaluation. For the
	// ModelEvaluation uploaded from Managed Pipeline, metadata contains a
	// structured value with keys of "pipeline_job_id",
	// "evaluation_dataset_type", "evaluation_dataset_path",
	// "row_based_metrics_path".
	Metadata interface{} `json:"metadata,omitempty"`

	// Metrics: Evaluation metrics of the Model. The schema of the metrics
	// is stored in metrics_schema_uri
	Metrics interface{} `json:"metrics,omitempty"`

	// MetricsSchemaUri: Points to a YAML file stored on Google Cloud
	// Storage describing the metrics of this ModelEvaluation. The schema is
	// defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	MetricsSchemaUri string `json:"metricsSchemaUri,omitempty"`

	// ModelExplanation: Aggregated explanation metrics for the Model's
	// prediction output over the data this ModelEvaluation uses. This field
	// is populated only if the Model is evaluated with explanations, and
	// only for AutoML tabular Models.
	ModelExplanation *GoogleCloudAiplatformV1ModelExplanation `json:"modelExplanation,omitempty"`

	// Name: Output only. The resource name of the ModelEvaluation.
	Name string `json:"name,omitempty"`

	// SliceDimensions: All possible dimensions of ModelEvaluationSlices.
	// The dimensions can be used as the filter of the
	// ModelService.ListModelEvaluationSlices request, in the form of
	// `slice.dimension = `.
	SliceDimensions []string `json:"sliceDimensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AnnotationSchemaUri")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotationSchemaUri") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1ModelEvaluationModelEvaluationExplanationSpec struct {
	// ExplanationSpec: Explanation spec details.
	ExplanationSpec *GoogleCloudAiplatformV1ExplanationSpec `json:"explanationSpec,omitempty"`

	// ExplanationType: Explanation type. For AutoML Image Classification
	// models, possible values are: * `image-integrated-gradients` *
	// `image-xrai`
	ExplanationType string `json:"explanationType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExplanationSpec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExplanationSpec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelEvaluationModelEvaluationExplanationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluationModelEvaluationExplanationSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelEvaluationSlice: A collection of metrics
// calculated by comparing Model's predictions on a slice of the test
// data against ground truth annotations.
type GoogleCloudAiplatformV1ModelEvaluationSlice struct {
	// CreateTime: Output only. Timestamp when this ModelEvaluationSlice was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Metrics: Output only. Sliced evaluation metrics of the Model. The
	// schema of the metrics is stored in metrics_schema_uri
	Metrics interface{} `json:"metrics,omitempty"`

	// MetricsSchemaUri: Output only. Points to a YAML file stored on Google
	// Cloud Storage describing the metrics of this ModelEvaluationSlice.
	// The schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	MetricsSchemaUri string `json:"metricsSchemaUri,omitempty"`

	// ModelExplanation: Output only. Aggregated explanation metrics for the
	// Model's prediction output over the data this ModelEvaluation uses.
	// This field is populated only if the Model is evaluated with
	// explanations, and only for tabular Models.
	ModelExplanation *GoogleCloudAiplatformV1ModelExplanation `json:"modelExplanation,omitempty"`

	// Name: Output only. The resource name of the ModelEvaluationSlice.
	Name string `json:"name,omitempty"`

	// Slice: Output only. The slice of the test data that is used to
	// evaluate the Model.
	Slice *GoogleCloudAiplatformV1ModelEvaluationSliceSlice `json:"slice,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelEvaluationSlice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluationSlice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelEvaluationSliceSlice: Definition of a
// slice.
type GoogleCloudAiplatformV1ModelEvaluationSliceSlice struct {
	// Dimension: Output only. The dimension of the slice. Well-known
	// dimensions are: * `annotationSpec`: This slice is on the test data
	// that has either ground truth or prediction with
	// AnnotationSpec.display_name equals to value. * `slice`: This slice is
	// a user customized slice defined by its SliceSpec.
	Dimension string `json:"dimension,omitempty"`

	// SliceSpec: Output only. Specification for how the data was sliced.
	SliceSpec *GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpec `json:"sliceSpec,omitempty"`

	// Value: Output only. The value of the dimension in this slice.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimension") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimension") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelEvaluationSliceSlice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluationSliceSlice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpec:
// Specification for how the data should be sliced.
type GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpec struct {
	// Configs: Mapping configuration for this SliceSpec. The key is the
	// name of the feature. By default, the key will be prefixed by
	// "instance" as a dictionary prefix for Vertex Batch Predictions output
	// format.
	Configs map[string]GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig `json:"configs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Configs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Configs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange: A
// range of values for slice(s). `low` is inclusive, `high` is
// exclusive.
type GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange struct {
	// High: Exclusive high value for the range.
	High float64 `json:"high,omitempty"`

	// Low: Inclusive low value for the range.
	Low float64 `json:"low,omitempty"`

	// ForceSendFields is a list of field names (e.g. "High") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "High") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange
	var s1 struct {
		High gensupport.JSONFloat64 `json:"high"`
		Low  gensupport.JSONFloat64 `json:"low"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.High = float64(s1.High)
	s.Low = float64(s1.Low)
	return nil
}

// GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig:
// Specification message containing the config for this SliceSpec. When
// `kind` is selected as `value` and/or `range`, only a single slice
// will be computed. When `all_values` is present, a separate slice will
// be computed for each possible label/value for the corresponding key
// in `config`. Examples, with feature zip_code with values 12345,
// 23334, 88888 and feature country with values "US", "Canada", "Mexico"
// in the dataset: Example 1: { "zip_code": { "value": { "float_value":
// 12345.0 } } } A single slice for any data with zip_code 12345 in the
// dataset. Example 2: { "zip_code": { "range": { "low": 12345, "high":
// 20000 } } } A single slice containing data where the zip_codes
// between 12345 and 20000 For this example, data with the zip_code of
// 12345 will be in this slice. Example 3: { "zip_code": { "range": {
// "low": 10000, "high": 20000 } }, "country": { "value": {
// "string_value": "US" } } } A single slice containing data where the
// zip_codes between 10000 and 20000 has the country "US". For this
// example, data with the zip_code of 12345 and country "US" will be in
// this slice. Example 4: { "country": {"all_values": { "value": true }
// } } Three slices are computed, one for each unique country in the
// dataset. Example 5: { "country": { "all_values": { "value": true } },
// "zip_code": { "value": { "float_value": 12345.0 } } } Three slices
// are computed, one for each unique country in the dataset where the
// zip_code is also 12345. For this example, data with zip_code 12345
// and country "US" will be in one slice, zip_code 12345 and country
// "Canada" in another slice, and zip_code 12345 and country "Mexico" in
// another slice, totaling 3 slices.
type GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig struct {
	// AllValues: If all_values is set to true, then all possible labels of
	// the keyed feature will have another slice computed. Example:
	// `{"all_values":{"value":true}}`
	AllValues bool `json:"allValues,omitempty"`

	// Range: A range of values for a numerical feature. Example:
	// `{"range":{"low":10000.0,"high":50000.0}}` will capture 12345 and
	// 23334 in the slice.
	Range *GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange `json:"range,omitempty"`

	// Value: A unique specific value for a given feature. Example: `{
	// "value": { "string_value": "12345" } }`
	Value *GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllValues") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllValues") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue:
// Single value that supports strings and floats.
type GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue struct {
	// FloatValue: Float type.
	FloatValue float64 `json:"floatValue,omitempty"`

	// StringValue: String type.
	StringValue string `json:"stringValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FloatValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FloatValue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleCloudAiplatformV1ModelExplanation: Aggregated explanation
// metrics for a Model over a set of instances.
type GoogleCloudAiplatformV1ModelExplanation struct {
	// MeanAttributions: Output only. Aggregated attributions explaining the
	// Model's prediction outputs over the set of instances. The
	// attributions are grouped by outputs. For Models that predict only one
	// output, such as regression Models that predict only one score, there
	// is only one attibution that explains the predicted output. For Models
	// that predict multiple outputs, such as multiclass Models that predict
	// multiple classes, each element explains one specific item.
	// Attribution.output_index can be used to identify which output this
	// attribution is explaining. The baselineOutputValue,
	// instanceOutputValue and featureAttributions fields are averaged over
	// the test data. NOTE: Currently AutoML tabular classification Models
	// produce only one attribution, which averages attributions over all
	// the classes it predicts. Attribution.approximation_error is not
	// populated.
	MeanAttributions []*GoogleCloudAiplatformV1Attribution `json:"meanAttributions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MeanAttributions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MeanAttributions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelExplanation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelExportFormat: Represents export format
// supported by the Model. All formats export to Google Cloud Storage.
type GoogleCloudAiplatformV1ModelExportFormat struct {
	// ExportableContents: Output only. The content of this Model that may
	// be exported.
	//
	// Possible values:
	//   "EXPORTABLE_CONTENT_UNSPECIFIED" - Should not be used.
	//   "ARTIFACT" - Model artifact and any of its supported files. Will be
	// exported to the location specified by the `artifactDestination` field
	// of the ExportModelRequest.output_config object.
	//   "IMAGE" - The container image that is to be used when deploying
	// this Model. Will be exported to the location specified by the
	// `imageDestination` field of the ExportModelRequest.output_config
	// object.
	ExportableContents []string `json:"exportableContents,omitempty"`

	// Id: Output only. The ID of the export format. The possible format IDs
	// are: * `tflite` Used for Android mobile devices. * `edgetpu-tflite`
	// Used for Edge TPU (https://cloud.google.com/edge-tpu/) devices. *
	// `tf-saved-model` A tensorflow model in SavedModel format. * `tf-js` A
	// TensorFlow.js (https://www.tensorflow.org/js) model that can be used
	// in the browser and in Node.js using JavaScript. * `core-ml` Used for
	// iOS mobile devices. * `custom-trained` A Model that was uploaded or
	// trained by custom code.
	Id string `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExportableContents")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExportableContents") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelExportFormat) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelExportFormat
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelGardenSource: Contains information about
// the source of the models generated from Model Garden.
type GoogleCloudAiplatformV1ModelGardenSource struct {
	// PublicModelName: Required. The model garden source model resource
	// name.
	PublicModelName string `json:"publicModelName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PublicModelName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PublicModelName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelGardenSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelGardenSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringAlertConfig: The alert config
// for model monitoring.
type GoogleCloudAiplatformV1ModelMonitoringAlertConfig struct {
	// EmailAlertConfig: Email alert config.
	EmailAlertConfig *GoogleCloudAiplatformV1ModelMonitoringAlertConfigEmailAlertConfig `json:"emailAlertConfig,omitempty"`

	// EnableLogging: Dump the anomalies to Cloud Logging. The anomalies
	// will be put to json payload encoded from proto
	// google.cloud.aiplatform.logging.ModelMonitoringAnomaliesLogEntry.
	// This can be further sinked to Pub/Sub or any other services supported
	// by Cloud Logging.
	EnableLogging bool `json:"enableLogging,omitempty"`

	// NotificationChannels: Resource names of the NotificationChannels to
	// send alert. Must be of the format `projects//notificationChannels/`
	NotificationChannels []string `json:"notificationChannels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EmailAlertConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EmailAlertConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringAlertConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringAlertConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringAlertConfigEmailAlertConfig:
// The config for email alert.
type GoogleCloudAiplatformV1ModelMonitoringAlertConfigEmailAlertConfig struct {
	// UserEmails: The email addresses to send the alert.
	UserEmails []string `json:"userEmails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserEmails") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserEmails") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringAlertConfigEmailAlertConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringAlertConfigEmailAlertConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringObjectiveConfig: The objective
// configuration for model monitoring, including the information needed
// to detect anomalies for one particular model.
type GoogleCloudAiplatformV1ModelMonitoringObjectiveConfig struct {
	// ExplanationConfig: The config for integrating with Vertex Explainable
	// AI.
	ExplanationConfig *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig `json:"explanationConfig,omitempty"`

	// PredictionDriftDetectionConfig: The config for drift of prediction
	// data.
	PredictionDriftDetectionConfig *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig `json:"predictionDriftDetectionConfig,omitempty"`

	// TrainingDataset: Training dataset for models. This field has to be
	// set only if TrainingPredictionSkewDetectionConfig is specified.
	TrainingDataset *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingDataset `json:"trainingDataset,omitempty"`

	// TrainingPredictionSkewDetectionConfig: The config for skew between
	// training data and prediction data.
	TrainingPredictionSkewDetectionConfig *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingPredictionSkewDetectionConfig `json:"trainingPredictionSkewDetectionConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExplanationConfig")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExplanationConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringObjectiveConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig
// : The config for integrating with Vertex Explainable AI. Only
// applicable if the Model has explanation_spec populated.
type GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig struct {
	// EnableFeatureAttributes: If want to analyze the Vertex Explainable AI
	// feature attribute scores or not. If set to true, Vertex AI will log
	// the feature attributions from explain response and do the skew/drift
	// detection for them.
	EnableFeatureAttributes bool `json:"enableFeatureAttributes,omitempty"`

	// ExplanationBaseline: Predictions generated by the BatchPredictionJob
	// using baseline dataset.
	ExplanationBaseline *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfigExplanationBaseline `json:"explanationBaseline,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableFeatureAttributes") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableFeatureAttributes")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig
// ExplanationBaseline: Output from BatchPredictionJob for Model
// Monitoring baseline dataset, which can be used to generate baseline
// attribution scores.
type GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfigExplanationBaseline struct {
	// Bigquery: BigQuery location for BatchExplain output.
	Bigquery *GoogleCloudAiplatformV1BigQueryDestination `json:"bigquery,omitempty"`

	// Gcs: Cloud Storage location for BatchExplain output.
	Gcs *GoogleCloudAiplatformV1GcsDestination `json:"gcs,omitempty"`

	// PredictionFormat: The storage format of the predictions generated
	// BatchPrediction job.
	//
	// Possible values:
	//   "PREDICTION_FORMAT_UNSPECIFIED" - Should not be set.
	//   "JSONL" - Predictions are in JSONL files.
	//   "BIGQUERY" - Predictions are in BigQuery.
	PredictionFormat string `json:"predictionFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bigquery") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bigquery") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfigExplanationBaseline) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfigExplanationBaseline
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDe
// tectionConfig: The config for Prediction data drift detection.
type GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig struct {
	// AttributionScoreDriftThresholds: Key is the feature name and value is
	// the threshold. The threshold here is against attribution score
	// distance between different time windows.
	AttributionScoreDriftThresholds map[string]GoogleCloudAiplatformV1ThresholdConfig `json:"attributionScoreDriftThresholds,omitempty"`

	// DefaultDriftThreshold: Drift anomaly detection threshold used by all
	// features. When the per-feature thresholds are not set, this field can
	// be used to specify a threshold for all features.
	DefaultDriftThreshold *GoogleCloudAiplatformV1ThresholdConfig `json:"defaultDriftThreshold,omitempty"`

	// DriftThresholds: Key is the feature name and value is the threshold.
	// If a feature needs to be monitored for drift, a value threshold must
	// be configured for that feature. The threshold here is against feature
	// distribution distance between different time windws.
	DriftThresholds map[string]GoogleCloudAiplatformV1ThresholdConfig `json:"driftThresholds,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AttributionScoreDriftThresholds") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AttributionScoreDriftThresholds") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingDataset:
// Training Dataset information.
type GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingDataset struct {
	// BigquerySource: The BigQuery table of the unmanaged Dataset used to
	// train this Model.
	BigquerySource *GoogleCloudAiplatformV1BigQuerySource `json:"bigquerySource,omitempty"`

	// DataFormat: Data format of the dataset, only applicable if the input
	// is from Google Cloud Storage. The possible formats are: "tf-record"
	// The source file is a TFRecord file. "csv" The source file is a CSV
	// file. "jsonl" The source file is a JSONL file.
	DataFormat string `json:"dataFormat,omitempty"`

	// Dataset: The resource name of the Dataset used to train this Model.
	Dataset string `json:"dataset,omitempty"`

	// GcsSource: The Google Cloud Storage uri of the unmanaged Dataset used
	// to train this Model.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`

	// LoggingSamplingStrategy: Strategy to sample data from Training
	// Dataset. If not set, we process the whole dataset.
	LoggingSamplingStrategy *GoogleCloudAiplatformV1SamplingStrategy `json:"loggingSamplingStrategy,omitempty"`

	// TargetField: The target field name the model is to predict. This
	// field will be excluded when doing Predict and (or) Explain for the
	// training data.
	TargetField string `json:"targetField,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigquerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingDataset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingPredictio
// nSkewDetectionConfig: The config for Training & Prediction data skew
// detection. It specifies the training dataset sources and the skew
// detection parameters.
type GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingPredictionSkewDetectionConfig struct {
	// AttributionScoreSkewThresholds: Key is the feature name and value is
	// the threshold. The threshold here is against attribution score
	// distance between the training and prediction feature.
	AttributionScoreSkewThresholds map[string]GoogleCloudAiplatformV1ThresholdConfig `json:"attributionScoreSkewThresholds,omitempty"`

	// DefaultSkewThreshold: Skew anomaly detection threshold used by all
	// features. When the per-feature thresholds are not set, this field can
	// be used to specify a threshold for all features.
	DefaultSkewThreshold *GoogleCloudAiplatformV1ThresholdConfig `json:"defaultSkewThreshold,omitempty"`

	// SkewThresholds: Key is the feature name and value is the threshold.
	// If a feature needs to be monitored for skew, a value threshold must
	// be configured for that feature. The threshold here is against feature
	// distribution distance between the training and prediction feature.
	SkewThresholds map[string]GoogleCloudAiplatformV1ThresholdConfig `json:"skewThresholds,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AttributionScoreSkewThresholds") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AttributionScoreSkewThresholds") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingPredictionSkewDetectionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingPredictionSkewDetectionConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringStatsAnomalies: Statistics and
// anomalies generated by Model Monitoring.
type GoogleCloudAiplatformV1ModelMonitoringStatsAnomalies struct {
	// AnomalyCount: Number of anomalies within all stats.
	AnomalyCount int64 `json:"anomalyCount,omitempty"`

	// DeployedModelId: Deployed Model ID.
	DeployedModelId string `json:"deployedModelId,omitempty"`

	// FeatureStats: A list of historical Stats and Anomalies generated for
	// all Features.
	FeatureStats []*GoogleCloudAiplatformV1ModelMonitoringStatsAnomaliesFeatureHistoricStatsAnomalies `json:"featureStats,omitempty"`

	// Objective: Model Monitoring Objective those stats and anomalies
	// belonging to.
	//
	// Possible values:
	//   "MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED" - Default
	// value, should not be set.
	//   "RAW_FEATURE_SKEW" - Raw feature values' stats to detect skew
	// between Training-Prediction datasets.
	//   "RAW_FEATURE_DRIFT" - Raw feature values' stats to detect drift
	// between Serving-Prediction datasets.
	//   "FEATURE_ATTRIBUTION_SKEW" - Feature attribution scores to detect
	// skew between Training-Prediction datasets.
	//   "FEATURE_ATTRIBUTION_DRIFT" - Feature attribution scores to detect
	// skew between Prediction datasets collected within different time
	// windows.
	Objective string `json:"objective,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnomalyCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnomalyCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringStatsAnomalies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringStatsAnomalies
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelMonitoringStatsAnomaliesFeatureHistoricSta
// tsAnomalies: Historical Stats (and Anomalies) for a specific Feature.
type GoogleCloudAiplatformV1ModelMonitoringStatsAnomaliesFeatureHistoricStatsAnomalies struct {
	// FeatureDisplayName: Display Name of the Feature.
	FeatureDisplayName string `json:"featureDisplayName,omitempty"`

	// PredictionStats: A list of historical stats generated by different
	// time window's Prediction Dataset.
	PredictionStats []*GoogleCloudAiplatformV1FeatureStatsAnomaly `json:"predictionStats,omitempty"`

	// Threshold: Threshold for anomaly detection.
	Threshold *GoogleCloudAiplatformV1ThresholdConfig `json:"threshold,omitempty"`

	// TrainingStats: Stats calculated for the Training Dataset.
	TrainingStats *GoogleCloudAiplatformV1FeatureStatsAnomaly `json:"trainingStats,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FeatureDisplayName")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureDisplayName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelMonitoringStatsAnomaliesFeatureHistoricStatsAnomalies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelMonitoringStatsAnomaliesFeatureHistoricStatsAnomalies
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelOriginalModelInfo: Contains information
// about the original Model if this Model is a copy.
type GoogleCloudAiplatformV1ModelOriginalModelInfo struct {
	// Model: Output only. The resource name of the Model this Model is a
	// copy of, including the revision. Format:
	// `projects/{project}/locations/{location}/models/{model_id}@{version_id
	// }`
	Model string `json:"model,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Model") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelOriginalModelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelOriginalModelInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ModelSourceInfo: Detail description of the
// source information of the model.
type GoogleCloudAiplatformV1ModelSourceInfo struct {
	// Copy: If this Model is copy of another Model. If true then
	// source_type pertains to the original.
	Copy bool `json:"copy,omitempty"`

	// SourceType: Type of the model source.
	//
	// Possible values:
	//   "MODEL_SOURCE_TYPE_UNSPECIFIED" - Should not be used.
	//   "AUTOML" - The Model is uploaded by automl training pipeline.
	//   "CUSTOM" - The Model is uploaded by user or custom training
	// pipeline.
	//   "BQML" - The Model is registered and sync'ed from BigQuery ML.
	//   "MODEL_GARDEN" - The Model is saved or tuned from Model Garden.
	//   "GENIE" - The Model is saved or tuned from Genie.
	//   "CUSTOM_TEXT_EMBEDDING" - The Model is uploaded by text embedding
	// finetuning pipeline.
	//   "MARKETPLACE" - The Model is saved or tuned from Marketplace.
	SourceType string `json:"sourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Copy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Copy") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1ModelSourceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ModelSourceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MutateDeployedIndexOperationMetadata: Runtime
// operation information for IndexEndpointService.MutateDeployedIndex.
type GoogleCloudAiplatformV1MutateDeployedIndexOperationMetadata struct {
	// DeployedIndexId: The unique index id specified by user
	DeployedIndexId string `json:"deployedIndexId,omitempty"`

	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedIndexId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MutateDeployedIndexOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MutateDeployedIndexOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MutateDeployedIndexResponse: Response message
// for IndexEndpointService.MutateDeployedIndex.
type GoogleCloudAiplatformV1MutateDeployedIndexResponse struct {
	// DeployedIndex: The DeployedIndex that had been updated in the
	// IndexEndpoint.
	DeployedIndex *GoogleCloudAiplatformV1DeployedIndex `json:"deployedIndex,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedIndex") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MutateDeployedIndexResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MutateDeployedIndexResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MutateDeployedModelOperationMetadata: Runtime
// operation information for EndpointService.MutateDeployedModel.
type GoogleCloudAiplatformV1MutateDeployedModelOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MutateDeployedModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MutateDeployedModelOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MutateDeployedModelRequest: Request message
// for EndpointService.MutateDeployedModel.
type GoogleCloudAiplatformV1MutateDeployedModelRequest struct {
	// DeployedModel: Required. The DeployedModel to be mutated within the
	// Endpoint. Only the following fields can be mutated: *
	// `min_replica_count` in either DedicatedResources or
	// AutomaticResources * `max_replica_count` in either DedicatedResources
	// or AutomaticResources * autoscaling_metric_specs *
	// `disable_container_logging` (v1 only) * `enable_container_logging`
	// (v1beta1 only)
	DeployedModel *GoogleCloudAiplatformV1DeployedModel `json:"deployedModel,omitempty"`

	// UpdateMask: Required. The update mask applies to the resource. See
	// google.protobuf.FieldMask.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedModel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MutateDeployedModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MutateDeployedModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1MutateDeployedModelResponse: Response message
// for EndpointService.MutateDeployedModel.
type GoogleCloudAiplatformV1MutateDeployedModelResponse struct {
	// DeployedModel: The DeployedModel that's being mutated.
	DeployedModel *GoogleCloudAiplatformV1DeployedModel `json:"deployedModel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedModel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1MutateDeployedModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1MutateDeployedModelResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasJob: Represents a Neural Architecture
// Search (NAS) job.
type GoogleCloudAiplatformV1NasJob struct {
	// CreateTime: Output only. Time when the NasJob was created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Required. The display name of the NasJob. The name can
	// be up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`

	// EnableRestrictedImageTraining: Optional. Enable a separation of
	// Custom model training and restricted image training for tenant
	// project.
	EnableRestrictedImageTraining bool `json:"enableRestrictedImageTraining,omitempty"`

	// EncryptionSpec: Customer-managed encryption key options for a NasJob.
	// If this is set, then all resources created by the NasJob will be
	// encrypted with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`

	// EndTime: Output only. Time when the NasJob entered any of the
	// following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
	// `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`

	// Error: Output only. Only populated when job's state is
	// JOB_STATE_FAILED or JOB_STATE_CANCELLED.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Labels: The labels with user-defined metadata to organize NasJobs.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. See
	// https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. Resource name of the NasJob.
	Name string `json:"name,omitempty"`

	// NasJobOutput: Output only. Output of the NasJob.
	NasJobOutput *GoogleCloudAiplatformV1NasJobOutput `json:"nasJobOutput,omitempty"`

	// NasJobSpec: Required. The specification of a NasJob.
	NasJobSpec *GoogleCloudAiplatformV1NasJobSpec `json:"nasJobSpec,omitempty"`

	// StartTime: Output only. Time when the NasJob for the first time
	// entered the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this
	// state the job may only go to either `JOB_STATE_SUCCEEDED`,
	// `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to
	// the `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded,
	// some results may be missing due to errors.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. Time when the NasJob was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasJob
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasJobOutput: Represents a uCAIP NasJob
// output.
type GoogleCloudAiplatformV1NasJobOutput struct {
	// MultiTrialJobOutput: Output only. The output of this multi-trial
	// Neural Architecture Search (NAS) job.
	MultiTrialJobOutput *GoogleCloudAiplatformV1NasJobOutputMultiTrialJobOutput `json:"multiTrialJobOutput,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MultiTrialJobOutput")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MultiTrialJobOutput") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasJobOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasJobOutput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasJobOutputMultiTrialJobOutput: The output of
// a multi-trial Neural Architecture Search (NAS) jobs.
type GoogleCloudAiplatformV1NasJobOutputMultiTrialJobOutput struct {
	// SearchTrials: Output only. List of NasTrials that were started as
	// part of search stage.
	SearchTrials []*GoogleCloudAiplatformV1NasTrial `json:"searchTrials,omitempty"`

	// TrainTrials: Output only. List of NasTrials that were started as part
	// of train stage.
	TrainTrials []*GoogleCloudAiplatformV1NasTrial `json:"trainTrials,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SearchTrials") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SearchTrials") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasJobOutputMultiTrialJobOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasJobOutputMultiTrialJobOutput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasJobSpec: Represents the spec of a NasJob.
type GoogleCloudAiplatformV1NasJobSpec struct {
	// MultiTrialAlgorithmSpec: The spec of multi-trial algorithms.
	MultiTrialAlgorithmSpec *GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpec `json:"multiTrialAlgorithmSpec,omitempty"`

	// ResumeNasJobId: The ID of the existing NasJob in the same Project and
	// Location which will be used to resume search. search_space_spec and
	// nas_algorithm_spec are obtained from previous NasJob hence should not
	// provide them again for this NasJob.
	ResumeNasJobId string `json:"resumeNasJobId,omitempty"`

	// SearchSpaceSpec: It defines the search space for Neural Architecture
	// Search (NAS).
	SearchSpaceSpec string `json:"searchSpaceSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MultiTrialAlgorithmSpec") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MultiTrialAlgorithmSpec")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasJobSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasJobSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpec: The spec of
// multi-trial Neural Architecture Search (NAS).
type GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpec struct {
	// Metric: Metric specs for the NAS job. Validation for this field is
	// done at `multi_trial_algorithm_spec` field.
	Metric *GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecMetricSpec `json:"metric,omitempty"`

	// MultiTrialAlgorithm: The multi-trial Neural Architecture Search (NAS)
	// algorithm type. Defaults to `REINFORCEMENT_LEARNING`.
	//
	// Possible values:
	//   "MULTI_TRIAL_ALGORITHM_UNSPECIFIED" - Defaults to
	// `REINFORCEMENT_LEARNING`.
	//   "REINFORCEMENT_LEARNING" - The Reinforcement Learning Algorithm for
	// Multi-trial Neural Architecture Search (NAS).
	//   "GRID_SEARCH" - The Grid Search Algorithm for Multi-trial Neural
	// Architecture Search (NAS).
	MultiTrialAlgorithm string `json:"multiTrialAlgorithm,omitempty"`

	// SearchTrialSpec: Required. Spec for search trials.
	SearchTrialSpec *GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecSearchTrialSpec `json:"searchTrialSpec,omitempty"`

	// TrainTrialSpec: Spec for train trials. Top N
	// [TrainTrialSpec.max_parallel_trial_count] search trials will be
	// trained for every M [TrainTrialSpec.frequency] trials searched.
	TrainTrialSpec *GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecTrainTrialSpec `json:"trainTrialSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metric") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metric") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecMetricSpec:
// Represents a metric to optimize.
type GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecMetricSpec struct {
	// Goal: Required. The optimization goal of the metric.
	//
	// Possible values:
	//   "GOAL_TYPE_UNSPECIFIED" - Goal Type will default to maximize.
	//   "MAXIMIZE" - Maximize the goal metric.
	//   "MINIMIZE" - Minimize the goal metric.
	Goal string `json:"goal,omitempty"`

	// MetricId: Required. The ID of the metric. Must not contain
	// whitespaces.
	MetricId string `json:"metricId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Goal") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Goal") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecMetricSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecMetricSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecSearchTrialSpe
// c: Represent spec for search trials.
type GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecSearchTrialSpec struct {
	// MaxFailedTrialCount: The number of failed trials that need to be seen
	// before failing the NasJob. If set to 0, Vertex AI decides how many
	// trials must fail before the whole job fails.
	MaxFailedTrialCount int64 `json:"maxFailedTrialCount,omitempty"`

	// MaxParallelTrialCount: Required. The maximum number of trials to run
	// in parallel.
	MaxParallelTrialCount int64 `json:"maxParallelTrialCount,omitempty"`

	// MaxTrialCount: Required. The maximum number of Neural Architecture
	// Search (NAS) trials to run.
	MaxTrialCount int64 `json:"maxTrialCount,omitempty"`

	// SearchTrialJobSpec: Required. The spec of a search trial job. The
	// same spec applies to all search trials.
	SearchTrialJobSpec *GoogleCloudAiplatformV1CustomJobSpec `json:"searchTrialJobSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxFailedTrialCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxFailedTrialCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecSearchTrialSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecSearchTrialSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecTrainTrialSpec
// : Represent spec for train trials.
type GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecTrainTrialSpec struct {
	// Frequency: Required. Frequency of search trials to start train stage.
	// Top N [TrainTrialSpec.max_parallel_trial_count] search trials will be
	// trained for every M [TrainTrialSpec.frequency] trials searched.
	Frequency int64 `json:"frequency,omitempty"`

	// MaxParallelTrialCount: Required. The maximum number of trials to run
	// in parallel.
	MaxParallelTrialCount int64 `json:"maxParallelTrialCount,omitempty"`

	// TrainTrialJobSpec: Required. The spec of a train trial job. The same
	// spec applies to all train trials.
	TrainTrialJobSpec *GoogleCloudAiplatformV1CustomJobSpec `json:"trainTrialJobSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Frequency") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Frequency") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecTrainTrialSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecTrainTrialSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasTrial: Represents a uCAIP NasJob trial.
type GoogleCloudAiplatformV1NasTrial struct {
	// EndTime: Output only. Time when the NasTrial's status changed to
	// `SUCCEEDED` or `INFEASIBLE`.
	EndTime string `json:"endTime,omitempty"`

	// FinalMeasurement: Output only. The final measurement containing the
	// objective value.
	FinalMeasurement *GoogleCloudAiplatformV1Measurement `json:"finalMeasurement,omitempty"`

	// Id: Output only. The identifier of the NasTrial assigned by the
	// service.
	Id string `json:"id,omitempty"`

	// StartTime: Output only. Time when the NasTrial was started.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. The detailed state of the NasTrial.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The NasTrial state is unspecified.
	//   "REQUESTED" - Indicates that a specific NasTrial has been
	// requested, but it has not yet been suggested by the service.
	//   "ACTIVE" - Indicates that the NasTrial has been suggested.
	//   "STOPPING" - Indicates that the NasTrial should stop according to
	// the service.
	//   "SUCCEEDED" - Indicates that the NasTrial is completed
	// successfully.
	//   "INFEASIBLE" - Indicates that the NasTrial should not be attempted
	// again. The service will set a NasTrial to INFEASIBLE when it's done
	// but missing the final_measurement.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasTrial) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasTrial
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NasTrialDetail: Represents a NasTrial details
// along with its parameters. If there is a corresponding train
// NasTrial, the train NasTrial is also returned.
type GoogleCloudAiplatformV1NasTrialDetail struct {
	// Name: Output only. Resource name of the NasTrialDetail.
	Name string `json:"name,omitempty"`

	// Parameters: The parameters for the NasJob NasTrial.
	Parameters string `json:"parameters,omitempty"`

	// SearchTrial: The requested search NasTrial.
	SearchTrial *GoogleCloudAiplatformV1NasTrial `json:"searchTrial,omitempty"`

	// TrainTrial: The train NasTrial corresponding to search_trial. Only
	// populated if search_trial is used for training.
	TrainTrial *GoogleCloudAiplatformV1NasTrial `json:"trainTrial,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NasTrialDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NasTrialDetail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NearestNeighborQuery: A query to find a number
// of similar entities.
type GoogleCloudAiplatformV1NearestNeighborQuery struct {
	// Embedding: Optional. The embedding vector that be used for similar
	// search.
	Embedding *GoogleCloudAiplatformV1NearestNeighborQueryEmbedding `json:"embedding,omitempty"`

	// EntityId: Optional. The entity id whose similar entities should be
	// searched for. If embedding is set, search will use embedding instead
	// of entity_id.
	EntityId string `json:"entityId,omitempty"`

	// NeighborCount: Optional. The number of similar entities to be
	// retrieved from feature view for each query.
	NeighborCount int64 `json:"neighborCount,omitempty"`

	// Parameters: Optional. Parameters that can be set to tune query on the
	// fly.
	Parameters *GoogleCloudAiplatformV1NearestNeighborQueryParameters `json:"parameters,omitempty"`

	// PerCrowdingAttributeNeighborCount: Optional. Crowding is a constraint
	// on a neighbor list produced by nearest neighbor search requiring that
	// no more than sper_crowding_attribute_neighbor_count of the k
	// neighbors returned have the same value of crowding_attribute. It's
	// used for improving result diversity.
	PerCrowdingAttributeNeighborCount int64 `json:"perCrowdingAttributeNeighborCount,omitempty"`

	// StringFilters: Optional. The list of string filters.
	StringFilters []*GoogleCloudAiplatformV1NearestNeighborQueryStringFilter `json:"stringFilters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Embedding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Embedding") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NearestNeighborQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NearestNeighborQueryEmbedding: The embedding
// vector.
type GoogleCloudAiplatformV1NearestNeighborQueryEmbedding struct {
	// Value: Optional. Individual value in the embedding.
	Value []float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NearestNeighborQueryEmbedding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborQueryEmbedding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1NearestNeighborQueryEmbedding) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborQueryEmbedding
	var s1 struct {
		Value []gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = make([]float64, len(s1.Value))
	for i := range s1.Value {
		s.Value[i] = float64(s1.Value[i])
	}
	return nil
}

// GoogleCloudAiplatformV1NearestNeighborQueryParameters: Parameters
// that can be overrided in each query to tune query latency and recall.
type GoogleCloudAiplatformV1NearestNeighborQueryParameters struct {
	// ApproximateNeighborCandidates: Optional. The number of neighbors to
	// find via approximate search before exact reordering is performed; if
	// set, this value must be > neighbor_count.
	ApproximateNeighborCandidates int64 `json:"approximateNeighborCandidates,omitempty"`

	// LeafNodesSearchFraction: Optional. The fraction of the number of
	// leaves to search, set at query time allows user to tune search
	// performance. This value increase result in both search accuracy and
	// latency increase. The value should be between 0.0 and 1.0.
	LeafNodesSearchFraction float64 `json:"leafNodesSearchFraction,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ApproximateNeighborCandidates") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ApproximateNeighborCandidates") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NearestNeighborQueryParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborQueryParameters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1NearestNeighborQueryParameters) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborQueryParameters
	var s1 struct {
		LeafNodesSearchFraction gensupport.JSONFloat64 `json:"leafNodesSearchFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LeafNodesSearchFraction = float64(s1.LeafNodesSearchFraction)
	return nil
}

// GoogleCloudAiplatformV1NearestNeighborQueryStringFilter: String
// filter is used to search a subset of the entities by using boolean
// rules on string columns. For example: if a query specifies string
// filter with 'name = color, allow_tokens = {red, blue}, deny_tokens =
// {purple}',' then that query will match entities that are red or blue,
// but if those points are also purple, then they will be excluded even
// if they are red/blue. Only string filter is supported for now,
// numeric filter will be supported in the near future.
type GoogleCloudAiplatformV1NearestNeighborQueryStringFilter struct {
	// AllowTokens: Optional. The allowed tokens.
	AllowTokens []string `json:"allowTokens,omitempty"`

	// DenyTokens: Optional. The denied tokens.
	DenyTokens []string `json:"denyTokens,omitempty"`

	// Name: Required. Column names in BigQuery that used as filters.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowTokens") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowTokens") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NearestNeighborQueryStringFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborQueryStringFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata:
// Runtime operation metadata with regard to Matching Engine Index.
type GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata struct {
	// ContentValidationStats: The validation stats of the content (per
	// file) to be inserted or updated on the Matching Engine Index
	// resource. Populated if contentsDeltaUri is provided as part of
	// Index.metadata. Please note that, currently for those files that are
	// broken or has unsupported file format, we will not have the stats for
	// those files.
	ContentValidationStats []*GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataContentValidationStats `json:"contentValidationStats,omitempty"`

	// DataBytesCount: The ingested data size in bytes.
	DataBytesCount int64 `json:"dataBytesCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "ContentValidationStats") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentValidationStats")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataContentValidationStats struct {
	// InvalidRecordCount: Number of records in this file we skipped due to
	// validate errors.
	InvalidRecordCount int64 `json:"invalidRecordCount,omitempty,string"`

	// PartialErrors: The detail information of the partial failures
	// encountered for those invalid records that couldn't be parsed. Up to
	// 50 partial errors will be reported.
	PartialErrors []*GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataRecordError `json:"partialErrors,omitempty"`

	// SourceGcsUri: Cloud Storage URI pointing to the original file in
	// user's bucket.
	SourceGcsUri string `json:"sourceGcsUri,omitempty"`

	// ValidRecordCount: Number of records in this file that were
	// successfully processed.
	ValidRecordCount int64 `json:"validRecordCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "InvalidRecordCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InvalidRecordCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataContentValidationStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataContentValidationStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataRecordError struct {
	// EmbeddingId: Empty if the embedding id is failed to parse.
	EmbeddingId string `json:"embeddingId,omitempty"`

	// ErrorMessage: A human-readable message that is shown to the user to
	// help them fix the error. Note that this message may change from time
	// to time, your code should check against error_type as the source of
	// truth.
	ErrorMessage string `json:"errorMessage,omitempty"`

	// ErrorType: The error type of this record.
	//
	// Possible values:
	//   "ERROR_TYPE_UNSPECIFIED" - Default, shall not be used.
	//   "EMPTY_LINE" - The record is empty.
	//   "INVALID_JSON_SYNTAX" - Invalid json format.
	//   "INVALID_CSV_SYNTAX" - Invalid csv format.
	//   "INVALID_AVRO_SYNTAX" - Invalid avro format.
	//   "INVALID_EMBEDDING_ID" - The embedding id is not valid.
	//   "EMBEDDING_SIZE_MISMATCH" - The size of the embedding vectors does
	// not match with the specified dimension.
	//   "NAMESPACE_MISSING" - The `namespace` field is missing.
	//   "PARSING_ERROR" - Generic catch-all error. Only used for validation
	// failure where the root cause cannot be easily retrieved
	// programmatically.
	//   "DUPLICATE_NAMESPACE" - There are multiple restricts with the same
	// `namespace` value.
	//   "OP_IN_DATAPOINT" - Numeric restrict has operator specified in
	// datapoint.
	//   "MULTIPLE_VALUES" - Numeric restrict has multiple values specified.
	//   "INVALID_NUMERIC_VALUE" - Numeric restrict has invalid numeric
	// value specified.
	//   "INVALID_ENCODING" - File is not in UTF_8 format.
	ErrorType string `json:"errorType,omitempty"`

	// RawRecord: The original content of this record.
	RawRecord string `json:"rawRecord,omitempty"`

	// SourceGcsUri: Cloud Storage URI pointing to the original file in
	// user's bucket.
	SourceGcsUri string `json:"sourceGcsUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EmbeddingId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EmbeddingId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataRecordError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataRecordError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NearestNeighbors: Nearest neighbors for one
// query.
type GoogleCloudAiplatformV1NearestNeighbors struct {
	// Neighbors: All its neighbors.
	Neighbors []*GoogleCloudAiplatformV1NearestNeighborsNeighbor `json:"neighbors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Neighbors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Neighbors") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NearestNeighbors) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NearestNeighbors
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NearestNeighborsNeighbor: A neighbor of the
// query vector.
type GoogleCloudAiplatformV1NearestNeighborsNeighbor struct {
	// Distance: The distance between the neighbor and the query vector.
	Distance float64 `json:"distance,omitempty"`

	// EntityId: The id of the similar entity.
	EntityId string `json:"entityId,omitempty"`

	// EntityKeyValues: The attributes of the neighbor, e.g. filters,
	// crowding and metadata Note that full entities are returned only when
	// "return_full_entity" is set to true. Otherwise, only the "entity_id"
	// and "distance" fields are populated.
	EntityKeyValues *GoogleCloudAiplatformV1FetchFeatureValuesResponse `json:"entityKeyValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Distance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Distance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NearestNeighborsNeighbor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborsNeighbor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1NearestNeighborsNeighbor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1NearestNeighborsNeighbor
	var s1 struct {
		Distance gensupport.JSONFloat64 `json:"distance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Distance = float64(s1.Distance)
	return nil
}

// GoogleCloudAiplatformV1Neighbor: Neighbors for example-based
// explanations.
type GoogleCloudAiplatformV1Neighbor struct {
	// NeighborDistance: Output only. The neighbor distance.
	NeighborDistance float64 `json:"neighborDistance,omitempty"`

	// NeighborId: Output only. The neighbor id.
	NeighborId string `json:"neighborId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NeighborDistance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NeighborDistance") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1Neighbor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Neighbor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1Neighbor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1Neighbor
	var s1 struct {
		NeighborDistance gensupport.JSONFloat64 `json:"neighborDistance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NeighborDistance = float64(s1.NeighborDistance)
	return nil
}

// GoogleCloudAiplatformV1NetworkSpec: Network spec.
type GoogleCloudAiplatformV1NetworkSpec struct {
	// EnableInternetAccess: Whether to enable public internet access.
	// Default false.
	EnableInternetAccess bool `json:"enableInternetAccess,omitempty"`

	// Network: The full name of the Google Compute Engine network
	// (https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
	Network string `json:"network,omitempty"`

	// Subnetwork: The name of the subnet that this instance is in. Format:
	// `projects/{project_id_or_number}/regions/{region}/subnetworks/{subnetw
	// ork_id}`
	Subnetwork string `json:"subnetwork,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableInternetAccess") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableInternetAccess") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NetworkSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NetworkSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NfsMount: Represents a mount configuration for
// Network File System (NFS) to mount.
type GoogleCloudAiplatformV1NfsMount struct {
	// MountPoint: Required. Destination mount path. The NFS will be mounted
	// for the user under /mnt/nfs/
	MountPoint string `json:"mountPoint,omitempty"`

	// Path: Required. Source path exported from NFS server. Has to start
	// with '/', and combined with the ip address, it indicates the source
	// mount path in the form of `server:path`
	Path string `json:"path,omitempty"`

	// Server: Required. IP address of the NFS server.
	Server string `json:"server,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MountPoint") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MountPoint") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NfsMount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NfsMount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NotebookEucConfig: The euc configuration of
// NotebookRuntimeTemplate.
type GoogleCloudAiplatformV1NotebookEucConfig struct {
	// BypassActasCheck: Output only. Whether ActAs check is bypassed for
	// service account attached to the VM. If false, we need ActAs check for
	// the default Compute Engine Service account. When a Runtime is
	// created, a VM is allocated using Default Compute Engine Service
	// Account. Any user requesting to use this Runtime requires Service
	// Account User (ActAs) permission over this SA. If true, Runtime owner
	// is using EUC and does not require the above permission as VM no
	// longer use default Compute Engine SA, but a P4SA.
	BypassActasCheck bool `json:"bypassActasCheck,omitempty"`

	// EucDisabled: Input only. Whether EUC is disabled in this
	// NotebookRuntimeTemplate. In proto3, the default value of a boolean is
	// false. In this way, by default EUC will be enabled for
	// NotebookRuntimeTemplate.
	EucDisabled bool `json:"eucDisabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BypassActasCheck") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BypassActasCheck") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NotebookEucConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NotebookEucConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NotebookIdleShutdownConfig: The idle shutdown
// configuration of NotebookRuntimeTemplate, which contains the
// idle_timeout as required field.
type GoogleCloudAiplatformV1NotebookIdleShutdownConfig struct {
	// IdleShutdownDisabled: Whether Idle Shutdown is disabled in this
	// NotebookRuntimeTemplate.
	IdleShutdownDisabled bool `json:"idleShutdownDisabled,omitempty"`

	// IdleTimeout: Required. Duration is accurate to the second. In
	// Notebook, Idle Timeout is accurate to minute so the range of
	// idle_timeout (second) is: 10 * 60 ~ 1440 * 60.
	IdleTimeout string `json:"idleTimeout,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IdleShutdownDisabled") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IdleShutdownDisabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NotebookIdleShutdownConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NotebookIdleShutdownConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NotebookReservationAffinity: Notebook
// Reservation Affinity for consuming Zonal reservation.
type GoogleCloudAiplatformV1NotebookReservationAffinity struct {
	// ConsumeReservationType: Required. Specifies the type of reservation
	// from which this instance can consume resources: RESERVATION_ANY
	// (default), RESERVATION_SPECIFIC, or RESERVATION_NONE. See Consuming
	// reserved instances for examples.
	//
	// Possible values:
	//   "RESERVATION_AFFINITY_TYPE_UNSPECIFIED" - Default type.
	//   "RESERVATION_NONE" - Do not consume from any allocated capacity.
	//   "RESERVATION_ANY" - Consume any reservation available.
	//   "RESERVATION_SPECIFIC" - Must consume from a specific reservation.
	// Must specify key value fields for specifying the reservations.
	ConsumeReservationType string `json:"consumeReservationType,omitempty"`

	// Key: Optional. Corresponds to the label key of a reservation
	// resource. To target a RESERVATION_SPECIFIC by name, use
	// compute.googleapis.com/reservation-name as the key and specify the
	// name of your reservation as its value.
	Key string `json:"key,omitempty"`

	// Values: Optional. Corresponds to the label values of a reservation
	// resource. This must be the full path name of Reservation.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConsumeReservationType") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsumeReservationType")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAiplatformV1NotebookReservationAffinity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1NotebookReservationAffinity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1NotebookRuntime: A runtime is a virtual
// machine allocated to a particular user for a particular Notebook file
// on temporary basis with lifetime limited to 24 hours.
type GoogleCloudAiplatformV1NotebookRuntime struct {
	// CreateTime: Output only. Timestamp when this NotebookRuntime was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: The description of the NotebookRuntime.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The display name of the NotebookRuntime. The
	// name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `json:"displayName,omitempty"`

	// ExpirationTime: Output only. Timestamp when this NotebookRuntime will
	// be expired: 1. System Predefined NotebookRuntime: 24 hours after
	// creation. After expiration, system predifined runtime will be
	// deleted. 2. User created NotebookRuntime: 6 months after last
	// upgrade. After expiration, user created runtime will be stopped and
	// allowed for upgrade.
	ExpirationTime string `json:"expirationTime,omitempty"`

	// HealthState: Output only. The health state of the NotebookRuntime.
	//
	// Possible values:
	//   "HEALTH_STATE_UNSPECIFIED" - Unspecified health state.
	//   "HEALTHY" - NotebookRuntime is in healthy state. Applies to ACTIVE
	// state.
	//   "UNHEALTHY" - NotebookRuntime is in unhealthy state. Applies to
	// ACTIVE state.
	HealthState string `json:"healthState,omitempty"`

	// IsUpgradable: Output only. Whether NotebookRuntime is upgradable.
	IsUpgradable bool `json:"isUpgradable,omitempty"`

	// Labels: The labels with user-defined metadata to organize your
	// NotebookRuntime. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters,
	// numeric characters, underscores and dashes. International characters
	// are allowed. No more than 64 user labels can be associated with one
	// NotebookRuntime (System labels are excluded). See
	// https://goo.gl/xmQnxf for more information and examples of labels.
	// System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable. Following system
	// labels exist for NotebookRuntime: *
	// "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
	// only, its value is the Compute Engine instance id. *
	// "aiplatform.googleapis.com/colab_enterprise_entry_service": its value
	// is either "bigquery" or "vertex"; if absent, it should be "vertex".
	// This is to describe the entry service, either BigQuery or Vertex.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The resource name of the NotebookRuntime.
	Name string `json:"name,omitempty"`

	// NetworkTags: Optional. The Compute Engine tags to add to runtime (see
	// Tagging instances
	// (https://cloud.google.com/vpc/docs/add-remove-network-tags)).
	NetworkTags []string `json:"networkTags,omitempty"`

	// NotebookRuntimeTemplateRef: Output only. The pointer to
	// NotebookRuntimeTemplate this NotebookRuntime is created from.
	NotebookRuntimeTemplateRef *GoogleCloudAiplatformV1NotebookRuntimeTemplateRef `json:"notebookRuntimeTemplateRef,omitempty"`

	// NotebookRuntimeType: Output only. The type of the notebook runtime.
	//
	// Possible values:
	//   "NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED" - Unspecified notebook runtime
	// type, NotebookRuntimeType will default to USER_DEFINED.
	//   "USER_DEFINED" - runtime or template with coustomized
	// configurations from user.
	//   "ONE_CLICK" - runtime or template with system defined
	// configurations.
	NotebookRuntimeType string `json:"notebookRuntimeType,omitempty"`

	// ProxyUri: Output only. The proxy endpoint used to access the
	// NotebookRuntime.
	ProxyUri string `json:"proxyUri,omitempty"`

	// ReservationAffinity: Output only. Reservation Affinity of the
	// notebook runtime.
	ReservationAffinity *GoogleCloudAiplatformV1NotebookReservationAffinity `json:"reservationAffinity,omitempty"`

	// RuntimeState: Output only. The runtime (instance) state of the
	// NotebookRuntime.
	//
	// Possible values:
	//   "RUNTIME_STATE_UNSPECIFIED" - Unspecified runtime state.
	//   "RUNNING" - NotebookRuntime is in running state.
	//   "BEING_STARTED" - NotebookRuntime is in starting state.
	//   "BEING_STOPPED" - NotebookRuntime is in stopping state.
	//   "STOPPED" - NotebookRuntime is in stopped state.
	//   "BEING_UPGRADED" - NotebookRuntime is in upgrading state. It is in
	// the middle of upgrading process.
	RuntimeState string `json:"runtimeState,omitempty"`

	// RuntimeUser: Required. The user email of the NotebookRuntime.
	RuntimeUser string `json:"runtimeUser,omitempty"`

	// ServiceAccount: Output only. The service account that the
	// NotebookRuntime workload runs as.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// UpdateTime: Output only. Timestamp when this NotebookRuntime was most
	// recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// Version: Output only. The VM os image version of NotebookRuntime.
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleC