// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakerfeaturestoreruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use for OnlineStore serving from a FeatureStore . Only the latest records stored
// in the OnlineStore can be retrieved. If no Record with RecordIdentifierValue is
// found, then an empty result is returned.
func (c *Client) GetRecord(ctx context.Context, params *GetRecordInput, optFns ...func(*Options)) (*GetRecordOutput, error) {
	if params == nil {
		params = &GetRecordInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRecord", params, optFns, c.addOperationGetRecordMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRecordOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetRecordInput struct {

	// The name or Amazon Resource Name (ARN) of the feature group from which you want
	// to retrieve a record.
	//
	// This member is required.
	FeatureGroupName *string

	// The value that corresponds to RecordIdentifier type and uniquely identifies the
	// record in the FeatureGroup .
	//
	// This member is required.
	RecordIdentifierValueAsString *string

	// Parameter to request ExpiresAt in response. If Enabled , GetRecord will return
	// the value of ExpiresAt , if it is not null. If Disabled and null, GetRecord
	// will return null.
	ExpirationTimeResponse types.ExpirationTimeResponse

	// List of names of Features to be retrieved. If not specified, the latest value
	// for all the Features are returned.
	FeatureNames []string

	noSmithyDocumentSerde
}

type GetRecordOutput struct {

	// The ExpiresAt ISO string of the requested record.
	ExpiresAt *string

	// The record you requested. A list of FeatureValues .
	Record []types.FeatureValue

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRecordMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetRecord{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetRecord{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRecord"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetRecordValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRecord(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetRecord(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRecord",
	}
}
