// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new DB instance.
//
// The new DB instance can be an RDS DB instance, or it can be a DB instance in an
// Aurora DB cluster. For an Aurora DB cluster, you can call this operation
// multiple times to add more than one DB instance to the cluster.
//
// For more information about creating an RDS DB instance, see [Creating an Amazon RDS DB instance] in the Amazon RDS
// User Guide.
//
// For more information about creating a DB instance in an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster]
// in the Amazon Aurora User Guide.
//
// [Creating an Amazon Aurora DB cluster]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html
// [Creating an Amazon RDS DB instance]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html
func (c *Client) CreateDBInstance(ctx context.Context, params *CreateDBInstanceInput, optFns ...func(*Options)) (*CreateDBInstanceOutput, error) {
	if params == nil {
		params = &CreateDBInstanceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDBInstance", params, optFns, c.addOperationCreateDBInstanceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDBInstanceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDBInstanceInput struct {

	// The compute and memory capacity of the DB instance, for example db.m5.large .
	// Not all DB instance classes are available in all Amazon Web Services Regions, or
	// for all database engines. For the full list of DB instance classes, and
	// availability for your engine, see [DB instance classes]in the Amazon RDS User Guide or [Aurora DB instance classes] in the
	// Amazon Aurora User Guide.
	//
	// [Aurora DB instance classes]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html
	// [DB instance classes]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html
	//
	// This member is required.
	DBInstanceClass *string

	// The identifier for this DB instance. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//   - Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//   - First character must be a letter.
	//
	//   - Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: mydbinstance
	//
	// This member is required.
	DBInstanceIdentifier *string

	// The database engine to use for this DB instance.
	//
	// Not every database engine is available in every Amazon Web Services Region.
	//
	// Valid Values:
	//
	//   - aurora-mysql (for Aurora MySQL DB instances)
	//
	//   - aurora-postgresql (for Aurora PostgreSQL DB instances)
	//
	//   - custom-oracle-ee (for RDS Custom for Oracle DB instances)
	//
	//   - custom-oracle-ee-cdb (for RDS Custom for Oracle DB instances)
	//
	//   - custom-oracle-se2 (for RDS Custom for Oracle DB instances)
	//
	//   - custom-oracle-se2-cdb (for RDS Custom for Oracle DB instances)
	//
	//   - custom-sqlserver-ee (for RDS Custom for SQL Server DB instances)
	//
	//   - custom-sqlserver-se (for RDS Custom for SQL Server DB instances)
	//
	//   - custom-sqlserver-web (for RDS Custom for SQL Server DB instances)
	//
	//   - db2-ae
	//
	//   - db2-se
	//
	//   - mariadb
	//
	//   - mysql
	//
	//   - oracle-ee
	//
	//   - oracle-ee-cdb
	//
	//   - oracle-se2
	//
	//   - oracle-se2-cdb
	//
	//   - postgres
	//
	//   - sqlserver-ee
	//
	//   - sqlserver-se
	//
	//   - sqlserver-ex
	//
	//   - sqlserver-web
	//
	// This member is required.
	Engine *string

	// The amount of storage in gibibytes (GiB) to allocate for the DB instance.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. Aurora cluster
	// volumes automatically grow as the amount of data in your database increases,
	// though you are only charged for the space that you use in an Aurora cluster
	// volume.
	//
	// Amazon RDS Custom Constraints to the amount of storage for each storage type
	// are the following:
	//
	//   - General Purpose (SSD) storage (gp2, gp3): Must be an integer from 40 to
	//   65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.
	//
	//   - Provisioned IOPS storage (io1, io2): Must be an integer from 40 to 65536
	//   for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.
	//
	// RDS for Db2 Constraints to the amount of storage for each storage type are the
	// following:
	//
	//   - General Purpose (SSD) storage (gp3): Must be an integer from 20 to 65536.
	//
	//   - Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
	//
	// RDS for MariaDB Constraints to the amount of storage for each storage type are
	// the following:
	//
	//   - General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to
	//   65536.
	//
	//   - Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
	//
	//   - Magnetic storage (standard): Must be an integer from 5 to 3072.
	//
	// RDS for MySQL Constraints to the amount of storage for each storage type are
	// the following:
	//
	//   - General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to
	//   65536.
	//
	//   - Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
	//
	//   - Magnetic storage (standard): Must be an integer from 5 to 3072.
	//
	// RDS for Oracle Constraints to the amount of storage for each storage type are
	// the following:
	//
	//   - General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to
	//   65536.
	//
	//   - Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
	//
	//   - Magnetic storage (standard): Must be an integer from 10 to 3072.
	//
	// RDS for PostgreSQL Constraints to the amount of storage for each storage type
	// are the following:
	//
	//   - General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to
	//   65536.
	//
	//   - Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
	//
	//   - Magnetic storage (standard): Must be an integer from 5 to 3072.
	//
	// RDS for SQL Server Constraints to the amount of storage for each storage type
	// are the following:
	//
	//   - General Purpose (SSD) storage (gp2, gp3):
	//
	//   - Enterprise and Standard editions: Must be an integer from 20 to 16384.
	//
	//   - Web and Express editions: Must be an integer from 20 to 16384.
	//
	//   - Provisioned IOPS storage (io1, io2):
	//
	//   - Enterprise and Standard editions: Must be an integer from 100 to 16384.
	//
	//   - Web and Express editions: Must be an integer from 100 to 16384.
	//
	//   - Magnetic storage (standard):
	//
	//   - Enterprise and Standard editions: Must be an integer from 20 to 1024.
	//
	//   - Web and Express editions: Must be an integer from 20 to 1024.
	AllocatedStorage *int32

	// Specifies whether minor engine upgrades are applied automatically to the DB
	// instance during the maintenance window. By default, minor engine upgrades are
	// applied automatically.
	//
	// If you create an RDS Custom DB instance, you must set AutoMinorVersionUpgrade
	// to false .
	AutoMinorVersionUpgrade *bool

	// The Availability Zone (AZ) where the database will be created. For information
	// on Amazon Web Services Regions and Availability Zones, see [Regions and Availability Zones].
	//
	// For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three
	// separate Availability Zones. Specify one of these Availability Zones. Aurora
	// automatically chooses an appropriate Availability Zone if you don't specify one.
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web
	// Services Region.
	//
	// Constraints:
	//
	//   - The AvailabilityZone parameter can't be specified if the DB instance is a
	//   Multi-AZ deployment.
	//
	//   - The specified Availability Zone must be in the same Amazon Web Services
	//   Region as the current endpoint.
	//
	// Example: us-east-1d
	//
	// [Regions and Availability Zones]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html
	AvailabilityZone *string

	// The number of days for which automated backups are retained. Setting this
	// parameter to a positive number enables backups. Setting this parameter to 0
	// disables automated backups.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. The retention period
	// for automated backups is managed by the DB cluster.
	//
	// Default: 1
	//
	// Constraints:
	//
	//   - Must be a value from 0 to 35.
	//
	//   - Can't be set to 0 if the DB instance is a source to read replicas.
	//
	//   - Can't be set to 0 for an RDS Custom for Oracle DB instance.
	BackupRetentionPeriod *int32

	// The location for storing automated backups and manual snapshots.
	//
	// Valid Values:
	//
	//   - outposts (Amazon Web Services Outposts)
	//
	//   - region (Amazon Web Services Region)
	//
	// Default: region
	//
	// For more information, see [Working with Amazon RDS on Amazon Web Services Outposts] in the Amazon RDS User Guide.
	//
	// [Working with Amazon RDS on Amazon Web Services Outposts]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html
	BackupTarget *string

	// The CA certificate identifier to use for the DB instance's server certificate.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	//
	// For more information, see [Using SSL/TLS to encrypt a connection to a DB instance] in the Amazon RDS User Guide and [Using SSL/TLS to encrypt a connection to a DB cluster] in the Amazon
	// Aurora User Guide.
	//
	// [Using SSL/TLS to encrypt a connection to a DB cluster]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html
	// [Using SSL/TLS to encrypt a connection to a DB instance]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html
	CACertificateIdentifier *string

	// For supported engines, the character set ( CharacterSet ) to associate the DB
	// instance with.
	//
	// This setting doesn't apply to the following DB instances:
	//
	//   - Amazon Aurora - The character set is managed by the DB cluster. For more
	//   information, see CreateDBCluster .
	//
	//   - RDS Custom - However, if you need to change the character set, you can
	//   change it on the database itself.
	CharacterSetName *string

	// Specifies whether to copy tags from the DB instance to snapshots of the DB
	// instance. By default, tags are not copied.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. Copying tags to
	// snapshots is managed by the DB cluster. Setting this value for an Aurora DB
	// instance has no effect on the DB cluster setting.
	CopyTagsToSnapshot *bool

	// The instance profile associated with the underlying Amazon EC2 instance of an
	// RDS Custom DB instance.
	//
	// This setting is required for RDS Custom.
	//
	// Constraints:
	//
	//   - The profile must exist in your account.
	//
	//   - The profile must have an IAM role that Amazon EC2 has permissions to assume.
	//
	//   - The instance profile name and the associated IAM role name must start with
	//   the prefix AWSRDSCustom .
	//
	// For the list of permissions required for the IAM role, see [Configure IAM and your VPC] in the Amazon RDS
	// User Guide.
	//
	// [Configure IAM and your VPC]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc
	CustomIamInstanceProfile *string

	// The identifier of the DB cluster that this DB instance will belong to.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	DBClusterIdentifier *string

	// The meaning of this parameter differs according to the database engine you use.
	//
	// Amazon Aurora MySQL The name of the database to create when the primary DB
	// instance of the Aurora MySQL DB cluster is created. If this parameter isn't
	// specified for an Aurora MySQL DB cluster, no database is created in the DB
	// cluster.
	//
	// Constraints:
	//
	//   - Must contain 1 to 64 alphanumeric characters.
	//
	//   - Can't be a word reserved by the database engine.
	//
	// Amazon Aurora PostgreSQL The name of the database to create when the primary DB
	// instance of the Aurora PostgreSQL DB cluster is created. If this parameter isn't
	// specified for an Aurora PostgreSQL DB cluster, a database named postgres is
	// created in the DB cluster.
	//
	// Constraints:
	//
	//   - It must contain 1 to 63 alphanumeric characters.
	//
	//   - Must begin with a letter. Subsequent characters can be letters,
	//   underscores, or digits (0 to 9).
	//
	//   - Can't be a word reserved by the database engine.
	//
	// Amazon RDS Custom for Oracle The Oracle System ID (SID) of the created RDS
	// Custom DB instance. If you don't specify a value, the default value is ORCL for
	// non-CDBs and RDSCDB for CDBs.
	//
	// Default: ORCL
	//
	// Constraints:
	//
	//   - Must contain 1 to 8 alphanumeric characters.
	//
	//   - Must contain a letter.
	//
	//   - Can't be a word reserved by the database engine.
	//
	// Amazon RDS Custom for SQL Server Not applicable. Must be null.
	//
	// RDS for Db2 The name of the database to create when the DB instance is created.
	// If this parameter isn't specified, no database is created in the DB instance. In
	// some cases, we recommend that you don't add a database name. For more
	// information, see [Additional considerations]in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//   - Must contain 1 to 64 letters or numbers.
	//
	//   - Must begin with a letter. Subsequent characters can be letters,
	//   underscores, or digits (0-9).
	//
	//   - Can't be a word reserved by the specified database engine.
	//
	// RDS for MariaDB The name of the database to create when the DB instance is
	// created. If this parameter isn't specified, no database is created in the DB
	// instance.
	//
	// Constraints:
	//
	//   - Must contain 1 to 64 letters or numbers.
	//
	//   - Must begin with a letter. Subsequent characters can be letters,
	//   underscores, or digits (0-9).
	//
	//   - Can't be a word reserved by the specified database engine.
	//
	// RDS for MySQL The name of the database to create when the DB instance is
	// created. If this parameter isn't specified, no database is created in the DB
	// instance.
	//
	// Constraints:
	//
	//   - Must contain 1 to 64 letters or numbers.
	//
	//   - Must begin with a letter. Subsequent characters can be letters,
	//   underscores, or digits (0-9).
	//
	//   - Can't be a word reserved by the specified database engine.
	//
	// RDS for Oracle The Oracle System ID (SID) of the created DB instance. If you
	// don't specify a value, the default value is ORCL . You can't specify the string
	// null , or any other reserved word, for DBName .
	//
	// Default: ORCL
	//
	// Constraints:
	//
	//   - Can't be longer than 8 characters.
	//
	// RDS for PostgreSQL The name of the database to create when the DB instance is
	// created. If this parameter isn't specified, a database named postgres is
	// created in the DB instance.
	//
	// Constraints:
	//
	//   - Must contain 1 to 63 letters, numbers, or underscores.
	//
	//   - Must begin with a letter. Subsequent characters can be letters,
	//   underscores, or digits (0-9).
	//
	//   - Can't be a word reserved by the specified database engine.
	//
	// RDS for SQL Server Not applicable. Must be null.
	//
	// [Additional considerations]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-db-instance-prereqs.html#db2-prereqs-additional-considerations
	DBName *string

	// The name of the DB parameter group to associate with this DB instance. If you
	// don't specify a value, then Amazon RDS uses the default DB parameter group for
	// the specified DB engine and version.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	//
	// Constraints:
	//
	//   - Must be 1 to 255 letters, numbers, or hyphens.
	//
	//   - The first character must be a letter.
	//
	//   - Can't end with a hyphen or contain two consecutive hyphens.
	DBParameterGroupName *string

	// A list of DB security groups to associate with this DB instance.
	//
	// This setting applies to the legacy EC2-Classic platform, which is no longer
	// used to create new DB instances. Use the VpcSecurityGroupIds setting instead.
	DBSecurityGroups []string

	// A DB subnet group to associate with this DB instance.
	//
	// Constraints:
	//
	//   - Must match the name of an existing DB subnet group.
	//
	//   - Must not be default .
	//
	// Example: mydbsubnetgroup
	DBSubnetGroupName *string

	// The Oracle system identifier (SID), which is the name of the Oracle database
	// instance that manages your database files. In this context, the term "Oracle
	// database instance" refers exclusively to the system global area (SGA) and Oracle
	// background processes. If you don't specify a SID, the value defaults to RDSCDB .
	// The Oracle SID is also the name of your CDB.
	DBSystemId *string

	// Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
	DedicatedLogVolume *bool

	// Specifies whether the DB instance has deletion protection enabled. The database
	// can't be deleted when deletion protection is enabled. By default, deletion
	// protection isn't enabled. For more information, see [Deleting a DB Instance].
	//
	// This setting doesn't apply to Amazon Aurora DB instances. You can enable or
	// disable deletion protection for the DB cluster. For more information, see
	// CreateDBCluster . DB instances in a DB cluster can be deleted even when deletion
	// protection is enabled for the DB cluster.
	//
	// [Deleting a DB Instance]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html
	DeletionProtection *bool

	// The Active Directory directory ID to create the DB instance in. Currently, you
	// can create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB
	// instances in an Active Directory Domain.
	//
	// For more information, see [Kerberos Authentication] in the Amazon RDS User Guide.
	//
	// This setting doesn't apply to the following DB instances:
	//
	//   - Amazon Aurora (The domain is managed by the DB cluster.)
	//
	//   - RDS Custom
	//
	// [Kerberos Authentication]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html
	Domain *string

	// The ARN for the Secrets Manager secret with the credentials for the user
	// joining the domain.
	//
	// Example:
	// arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456
	DomainAuthSecretArn *string

	// The IPv4 DNS IP addresses of your primary and secondary Active Directory domain
	// controllers.
	//
	// Constraints:
	//
	//   - Two IP addresses must be provided. If there isn't a secondary domain
	//   controller, use the IP address of the primary domain controller for both entries
	//   in the list.
	//
	// Example: 123.124.125.126,234.235.236.237
	DomainDnsIps []string

	// The fully qualified domain name (FQDN) of an Active Directory domain.
	//
	// Constraints:
	//
	//   - Can't be longer than 64 characters.
	//
	// Example: mymanagedADtest.mymanagedAD.mydomain
	DomainFqdn *string

	// The name of the IAM role to use when making API calls to the Directory Service.
	//
	// This setting doesn't apply to the following DB instances:
	//
	//   - Amazon Aurora (The domain is managed by the DB cluster.)
	//
	//   - RDS Custom
	DomainIAMRoleName *string

	// The Active Directory organizational unit for your DB instance to join.
	//
	// Constraints:
	//
	//   - Must be in the distinguished name format.
	//
	//   - Can't be longer than 64 characters.
	//
	// Example: OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain
	DomainOu *string

	// The list of log types to enable for exporting to CloudWatch Logs. For more
	// information, see [Publishing Database Logs to Amazon CloudWatch Logs]in the Amazon RDS User Guide.
	//
	// This setting doesn't apply to the following DB instances:
	//
	//   - Amazon Aurora (CloudWatch Logs exports are managed by the DB cluster.)
	//
	//   - RDS Custom
	//
	// The following values are valid for each DB engine:
	//
	//   - RDS for Db2 - diag.log | notify.log
	//
	//   - RDS for MariaDB - audit | error | general | slowquery
	//
	//   - RDS for Microsoft SQL Server - agent | error
	//
	//   - RDS for MySQL - audit | error | general | slowquery
	//
	//   - RDS for Oracle - alert | audit | listener | trace | oemagent
	//
	//   - RDS for PostgreSQL - postgresql | upgrade
	//
	// [Publishing Database Logs to Amazon CloudWatch Logs]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch
	EnableCloudwatchLogsExports []string

	// Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on
	// Outposts DB instance.
	//
	// A CoIP provides local or external connectivity to resources in your Outpost
	// subnets through your on-premises network. For some use cases, a CoIP can provide
	// lower latency for connections to the DB instance from outside of its virtual
	// private cloud (VPC) on your local network.
	//
	// For more information about RDS on Outposts, see [Working with Amazon RDS on Amazon Web Services Outposts] in the Amazon RDS User Guide.
	//
	// For more information about CoIPs, see [Customer-owned IP addresses] in the Amazon Web Services Outposts User
	// Guide.
	//
	// [Working with Amazon RDS on Amazon Web Services Outposts]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html
	// [Customer-owned IP addresses]: https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing
	EnableCustomerOwnedIp *bool

	// Specifies whether to enable mapping of Amazon Web Services Identity and Access
	// Management (IAM) accounts to database accounts. By default, mapping isn't
	// enabled.
	//
	// For more information, see [IAM Database Authentication for MySQL and PostgreSQL] in the Amazon RDS User Guide.
	//
	// This setting doesn't apply to the following DB instances:
	//
	//   - Amazon Aurora (Mapping Amazon Web Services IAM accounts to database
	//   accounts is managed by the DB cluster.)
	//
	//   - RDS Custom
	//
	// [IAM Database Authentication for MySQL and PostgreSQL]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html
	EnableIAMDatabaseAuthentication *bool

	// Specifies whether to enable Performance Insights for the DB instance. For more
	// information, see [Using Amazon Performance Insights]in the Amazon RDS User Guide.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	//
	// [Using Amazon Performance Insights]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html
	EnablePerformanceInsights *bool

	// The life cycle type for this DB instance.
	//
	// By default, this value is set to open-source-rds-extended-support , which
	// enrolls your DB instance into Amazon RDS Extended Support. At the end of
	// standard support, you can avoid charges for Extended Support by setting the
	// value to open-source-rds-extended-support-disabled . In this case, creating the
	// DB instance will fail if the DB major version is past its end of standard
	// support date.
	//
	// This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon
	// Aurora DB instances, the life cycle type is managed by the DB cluster.
	//
	// You can use this setting to enroll your DB instance into Amazon RDS Extended
	// Support. With RDS Extended Support, you can run the selected major engine
	// version on your DB instance past the end of standard support for that engine
	// version. For more information, see [Using Amazon RDS Extended Support]in the Amazon RDS User Guide.
	//
	// Valid Values: open-source-rds-extended-support |
	// open-source-rds-extended-support-disabled
	//
	// Default: open-source-rds-extended-support
	//
	// [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
	EngineLifecycleSupport *string

	// The version number of the database engine to use.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. The version number of
	// the database engine the DB instance uses is managed by the DB cluster.
	//
	// For a list of valid engine versions, use the DescribeDBEngineVersions operation.
	//
	// The following are the database engines and links to information about the major
	// and minor versions that are available with Amazon RDS. Not every database engine
	// is available for every Amazon Web Services Region.
	//
	// Amazon RDS Custom for Oracle A custom engine version (CEV) that you have
	// previously created. This setting is required for RDS Custom for Oracle. The CEV
	// name has the following format: 19.customized_string. A valid CEV name is
	// 19.my_cev1 . For more information, see [Creating an RDS Custom for Oracle DB instance] in the Amazon RDS User Guide.
	//
	// Amazon RDS Custom for SQL Server See [RDS Custom for SQL Server general requirements] in the Amazon RDS User Guide.
	//
	// RDS for Db2 For information, see [Db2 on Amazon RDS versions] in the Amazon RDS User Guide.
	//
	// RDS for MariaDB For information, see [MariaDB on Amazon RDS versions] in the Amazon RDS User Guide.
	//
	// RDS for Microsoft SQL Server For information, see [Microsoft SQL Server versions on Amazon RDS] in the Amazon RDS User Guide.
	//
	// RDS for MySQL For information, see [MySQL on Amazon RDS versions] in the Amazon RDS User Guide.
	//
	// RDS for Oracle For information, see [Oracle Database Engine release notes] in the Amazon RDS User Guide.
	//
	// RDS for PostgreSQL For information, see [Amazon RDS for PostgreSQL versions and extensions] in the Amazon RDS User Guide.
	//
	// [RDS Custom for SQL Server general requirements]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html
	// [MariaDB on Amazon RDS versions]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt
	// [Amazon RDS for PostgreSQL versions and extensions]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts
	// [Oracle Database Engine release notes]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html
	// [Creating an RDS Custom for Oracle DB instance]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create
	// [Db2 on Amazon RDS versions]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt
	// [Microsoft SQL Server versions on Amazon RDS]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport
	// [MySQL on Amazon RDS versions]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt
	EngineVersion *string

	// The amount of Provisioned IOPS (input/output operations per second) to
	// initially allocate for the DB instance. For information about valid IOPS values,
	// see [Amazon RDS DB instance storage]in the Amazon RDS User Guide.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by
	// the DB cluster.
	//
	// Constraints:
	//
	//   - For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a
	//   multiple between .5 and 50 of the storage amount for the DB instance.
	//
	//   - For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage
	//   amount for the DB instance.
	//
	// [Amazon RDS DB instance storage]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html
	Iops *int32

	// The Amazon Web Services KMS key identifier for an encrypted DB instance.
	//
	// The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN,
	// or alias name for the KMS key. To use a KMS key in a different Amazon Web
	// Services account, specify the key ARN or alias ARN.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. The Amazon Web
	// Services KMS key identifier is managed by the DB cluster. For more information,
	// see CreateDBCluster .
	//
	// If StorageEncrypted is enabled, and you do not specify a value for the KmsKeyId
	// parameter, then Amazon RDS uses your default KMS key. There is a default KMS key
	// for your Amazon Web Services account. Your Amazon Web Services account has a
	// different default KMS key for each Amazon Web Services Region.
	//
	// For Amazon RDS Custom, a KMS key is required for DB instances. For most RDS
	// engines, if you leave this parameter empty while enabling StorageEncrypted , the
	// engine uses the default KMS key. However, RDS Custom doesn't use the default key
	// when this parameter is empty. You must explicitly specify a key.
	KmsKeyId *string

	// The license model information for this DB instance.
	//
	// License models for RDS for Db2 require additional configuration. The Bring Your
	// Own License (BYOL) model requires a custom parameter group. The Db2 license
	// through Amazon Web Services Marketplace model requires an Amazon Web Services
	// Marketplace subscription. For more information, see [RDS for Db2 licensing options]in the Amazon RDS User
	// Guide.
	//
	// The default for RDS for Db2 is bring-your-own-license .
	//
	// This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
	//
	// Valid Values:
	//
	//   - RDS for Db2 - bring-your-own-license | marketplace-license
	//
	//   - RDS for MariaDB - general-public-license
	//
	//   - RDS for Microsoft SQL Server - license-included
	//
	//   - RDS for MySQL - general-public-license
	//
	//   - RDS for Oracle - bring-your-own-license | license-included
	//
	//   - RDS for PostgreSQL - postgresql-license
	//
	// [RDS for Db2 licensing options]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html
	LicenseModel *string

	// Specifies whether to manage the master user password with Amazon Web Services
	// Secrets Manager.
	//
	// For more information, see [Password management with Amazon Web Services Secrets Manager] in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//   - Can't manage the master user password with Amazon Web Services Secrets
	//   Manager if MasterUserPassword is specified.
	//
	// [Password management with Amazon Web Services Secrets Manager]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html
	ManageMasterUserPassword *bool

	// The password for the master user.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. The password for the
	// master user is managed by the DB cluster.
	//
	// Constraints:
	//
	//   - Can't be specified if ManageMasterUserPassword is turned on.
	//
	//   - Can include any printable ASCII character except "/", """, or "@". For RDS
	//   for Oracle, can't include the "&" (ampersand) or the "'" (single quotes)
	//   character.
	//
	// Length Constraints:
	//
	//   - RDS for Db2 - Must contain from 8 to 255 characters.
	//
	//   - RDS for MariaDB - Must contain from 8 to 41 characters.
	//
	//   - RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
	//
	//   - RDS for MySQL - Must contain from 8 to 41 characters.
	//
	//   - RDS for Oracle - Must contain from 8 to 30 characters.
	//
	//   - RDS for PostgreSQL - Must contain from 8 to 128 characters.
	MasterUserPassword *string

	// The Amazon Web Services KMS key identifier to encrypt a secret that is
	// automatically generated and managed in Amazon Web Services Secrets Manager.
	//
	// This setting is valid only if the master user password is managed by RDS in
	// Amazon Web Services Secrets Manager for the DB instance.
	//
	// The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN,
	// or alias name for the KMS key. To use a KMS key in a different Amazon Web
	// Services account, specify the key ARN or alias ARN.
	//
	// If you don't specify MasterUserSecretKmsKeyId , then the aws/secretsmanager KMS
	// key is used to encrypt the secret. If the secret is in a different Amazon Web
	// Services account, then you can't use the aws/secretsmanager KMS key to encrypt
	// the secret, and you must use a customer managed KMS key.
	//
	// There is a default KMS key for your Amazon Web Services account. Your Amazon
	// Web Services account has a different default KMS key for each Amazon Web
	// Services Region.
	MasterUserSecretKmsKeyId *string

	// The name for the master user.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. The name for the
	// master user is managed by the DB cluster.
	//
	// This setting is required for RDS DB instances.
	//
	// Constraints:
	//
	//   - Must be 1 to 16 letters, numbers, or underscores.
	//
	//   - First character must be a letter.
	//
	//   - Can't be a reserved word for the chosen database engine.
	MasterUsername *string

	// The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale
	// the storage of the DB instance.
	//
	// For more information about this setting, including limitations that apply to
	// it, see [Managing capacity automatically with Amazon RDS storage autoscaling]in the Amazon RDS User Guide.
	//
	// This setting doesn't apply to the following DB instances:
	//
	//   - Amazon Aurora (Storage is managed by the DB cluster.)
	//
	//   - RDS Custom
	//
	// [Managing capacity automatically with Amazon RDS storage autoscaling]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling
	MaxAllocatedStorage *int32

	// The interval, in seconds, between points when Enhanced Monitoring metrics are
	// collected for the DB instance. To disable collection of Enhanced Monitoring
	// metrics, specify 0 .
	//
	// If MonitoringRoleArn is specified, then you must set MonitoringInterval to a
	// value other than 0 .
	//
	// This setting doesn't apply to RDS Custom DB instances.
	//
	// Valid Values: 0 | 1 | 5 | 10 | 15 | 30 | 60
	//
	// Default: 0
	MonitoringInterval *int32

	// The ARN for the IAM role that permits RDS to send enhanced monitoring metrics
	// to Amazon CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess .
	// For information on creating a monitoring role, see [Setting Up and Enabling Enhanced Monitoring]in the Amazon RDS User Guide.
	//
	// If MonitoringInterval is set to a value other than 0 , then you must supply a
	// MonitoringRoleArn value.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	//
	// [Setting Up and Enabling Enhanced Monitoring]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling
	MonitoringRoleArn *string

	// Specifies whether the DB instance is a Multi-AZ deployment. You can't set the
	// AvailabilityZone parameter if the DB instance is a Multi-AZ deployment.
	//
	// This setting doesn't apply to the following DB instances:
	//
	//   - Amazon Aurora (DB instance Availability Zones (AZs) are managed by the DB
	//   cluster.)
	//
	//   - RDS Custom
	MultiAZ *bool

	// Specifies whether to use the multi-tenant configuration or the single-tenant
	// configuration (default). This parameter only applies to RDS for Oracle container
	// database (CDB) engines.
	//
	// Note the following restrictions:
	//
	//   - The DB engine that you specify in the request must support the multi-tenant
	//   configuration. If you attempt to enable the multi-tenant configuration on a DB
	//   engine that doesn't support it, the request fails.
	//
	//   - If you specify the multi-tenant configuration when you create your DB
	//   instance, you can't later modify this DB instance to use the single-tenant
	//   configuration.
	MultiTenant *bool

	// The name of the NCHAR character set for the Oracle DB instance.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	NcharCharacterSetName *string

	// The network type of the DB instance.
	//
	// The network type is determined by the DBSubnetGroup specified for the DB
	// instance. A DBSubnetGroup can support only the IPv4 protocol or the IPv4 and
	// the IPv6 protocols ( DUAL ).
	//
	// For more information, see [Working with a DB instance in a VPC] in the Amazon RDS User Guide.
	//
	// Valid Values: IPV4 | DUAL
	//
	// [Working with a DB instance in a VPC]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html
	NetworkType *string

	// The option group to associate the DB instance with.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// can't be removed from an option group. Also, that option group can't be removed
	// from a DB instance after it is associated with a DB instance.
	//
	// This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
	OptionGroupName *string

	// The Amazon Web Services KMS key identifier for encryption of Performance
	// Insights data.
	//
	// The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN,
	// or alias name for the KMS key.
	//
	// If you don't specify a value for PerformanceInsightsKMSKeyId , then Amazon RDS
	// uses your default KMS key. There is a default KMS key for your Amazon Web
	// Services account. Your Amazon Web Services account has a different default KMS
	// key for each Amazon Web Services Region.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	PerformanceInsightsKMSKeyId *string

	// The number of days to retain Performance Insights data.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	//
	// Valid Values:
	//
	//   - 7
	//
	//   - month * 31, where month is a number of months from 1-23. Examples: 93 (3
	//   months * 31), 341 (11 months * 31), 589 (19 months * 31)
	//
	//   - 731
	//
	// Default: 7 days
	//
	// If you specify a retention period that isn't valid, such as 94 , Amazon RDS
	// returns an error.
	PerformanceInsightsRetentionPeriod *int32

	// The port number on which the database accepts connections.
	//
	// This setting doesn't apply to Aurora DB instances. The port number is managed
	// by the cluster.
	//
	// Valid Values: 1150-65535
	//
	// Default:
	//
	//   - RDS for Db2 - 50000
	//
	//   - RDS for MariaDB - 3306
	//
	//   - RDS for Microsoft SQL Server - 1433
	//
	//   - RDS for MySQL - 3306
	//
	//   - RDS for Oracle - 1521
	//
	//   - RDS for PostgreSQL - 5432
	//
	// Constraints:
	//
	//   - For RDS for Microsoft SQL Server, the value can't be 1234 , 1434 , 3260 ,
	//   3343 , 3389 , 47001 , or 49152-49156 .
	Port *int32

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter. The default is
	// a 30-minute window selected at random from an 8-hour block of time for each
	// Amazon Web Services Region. For more information, see [Backup window]in the Amazon RDS User
	// Guide.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. The daily time range
	// for creating automated backups is managed by the DB cluster.
	//
	// Constraints:
	//
	//   - Must be in the format hh24:mi-hh24:mi .
	//
	//   - Must be in Universal Coordinated Time (UTC).
	//
	//   - Must not conflict with the preferred maintenance window.
	//
	//   - Must be at least 30 minutes.
	//
	// [Backup window]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
	PreferredBackupWindow *string

	// The time range each week during which system maintenance can occur. For more
	// information, see [Amazon RDS Maintenance Window]in the Amazon RDS User Guide.
	//
	// The default is a 30-minute window selected at random from an 8-hour block of
	// time for each Amazon Web Services Region, occurring on a random day of the week.
	//
	// Constraints:
	//
	//   - Must be in the format ddd:hh24:mi-ddd:hh24:mi .
	//
	//   - The day values must be mon | tue | wed | thu | fri | sat | sun .
	//
	//   - Must be in Universal Coordinated Time (UTC).
	//
	//   - Must not conflict with the preferred backup window.
	//
	//   - Must be at least 30 minutes.
	//
	// [Amazon RDS Maintenance Window]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance
	PreferredMaintenanceWindow *string

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	//
	// This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
	ProcessorFeatures []types.ProcessorFeature

	// The order of priority in which an Aurora Replica is promoted to the primary
	// instance after a failure of the existing primary instance. For more information,
	// see [Fault Tolerance for an Aurora DB Cluster]in the Amazon Aurora User Guide.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	//
	// Default: 1
	//
	// Valid Values: 0 - 15
	//
	// [Fault Tolerance for an Aurora DB Cluster]: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance
	PromotionTier *int32

	// Specifies whether the DB instance is publicly accessible.
	//
	// When the DB instance is publicly accessible, its Domain Name System (DNS)
	// endpoint resolves to the private IP address from within the DB instance's
	// virtual private cloud (VPC). It resolves to the public IP address from outside
	// of the DB instance's VPC. Access to the DB instance is ultimately controlled by
	// the security group it uses. That public access is not permitted if the security
	// group assigned to the DB instance doesn't permit it.
	//
	// When the DB instance isn't publicly accessible, it is an internal DB instance
	// with a DNS name that resolves to a private IP address.
	//
	// Default: The default behavior varies depending on whether DBSubnetGroupName is
	// specified.
	//
	// If DBSubnetGroupName isn't specified, and PubliclyAccessible isn't specified,
	// the following applies:
	//
	//   - If the default VPC in the target Region doesn’t have an internet gateway
	//   attached to it, the DB instance is private.
	//
	//   - If the default VPC in the target Region has an internet gateway attached to
	//   it, the DB instance is public.
	//
	// If DBSubnetGroupName is specified, and PubliclyAccessible isn't specified, the
	// following applies:
	//
	//   - If the subnets are part of a VPC that doesn’t have an internet gateway
	//   attached to it, the DB instance is private.
	//
	//   - If the subnets are part of a VPC that has an internet gateway attached to
	//   it, the DB instance is public.
	PubliclyAccessible *bool

	// Specifes whether the DB instance is encrypted. By default, it isn't encrypted.
	//
	// For RDS Custom DB instances, either enable this setting or leave it unset.
	// Otherwise, Amazon RDS reports an error.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. The encryption for DB
	// instances is managed by the DB cluster.
	StorageEncrypted *bool

	// The storage throughput value for the DB instance.
	//
	// This setting applies only to the gp3 storage type.
	//
	// This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
	StorageThroughput *int32

	// The storage type to associate with the DB instance.
	//
	// If you specify io1 , io2 , or gp3 , you must also include a value for the Iops
	// parameter.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by
	// the DB cluster.
	//
	// Valid Values: gp2 | gp3 | io1 | io2 | standard
	//
	// Default: io1 , if the Iops parameter is specified. Otherwise, gp2 .
	StorageType *string

	// Tags to assign to the DB instance.
	Tags []types.Tag

	// The ARN from the key store with which to associate the instance for TDE
	// encryption.
	//
	// This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
	TdeCredentialArn *string

	// The password for the given ARN from the key store in order to access the device.
	//
	// This setting doesn't apply to RDS Custom DB instances.
	TdeCredentialPassword *string

	// The time zone of the DB instance. The time zone parameter is currently
	// supported only by [RDS for Db2]and [RDS for SQL Server].
	//
	// [RDS for Db2]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone
	// [RDS for SQL Server]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone
	Timezone *string

	// A list of Amazon EC2 VPC security groups to associate with this DB instance.
	//
	// This setting doesn't apply to Amazon Aurora DB instances. The associated list
	// of EC2 VPC security groups is managed by the DB cluster.
	//
	// Default: The default EC2 VPC security group for the DB subnet group's VPC.
	VpcSecurityGroupIds []string

	noSmithyDocumentSerde
}

type CreateDBInstanceOutput struct {

	// Contains the details of an Amazon RDS DB instance.
	//
	// This data type is used as a response element in the operations CreateDBInstance
	// , CreateDBInstanceReadReplica , DeleteDBInstance , DescribeDBInstances ,
	// ModifyDBInstance , PromoteReadReplica , RebootDBInstance ,
	// RestoreDBInstanceFromDBSnapshot , RestoreDBInstanceFromS3 ,
	// RestoreDBInstanceToPointInTime , StartDBInstance , and StopDBInstance .
	DBInstance *types.DBInstance

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDBInstanceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateDBInstance{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateDBInstance{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDBInstance"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateDBInstanceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDBInstance(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDBInstance(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDBInstance",
	}
}
