// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"time"
)

type awsRestjson1_serializeOpCancelIngestion struct {
}

func (*awsRestjson1_serializeOpCancelIngestion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelIngestion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelIngestionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelIngestionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelIngestionInput(v *CancelIngestionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.IngestionId == nil || len(*v.IngestionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IngestionId must not be empty")}
	}
	if v.IngestionId != nil {
		if err := encoder.SetURI("IngestionId").String(*v.IngestionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAccountCustomization struct {
}

func (*awsRestjson1_serializeOpCreateAccountCustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAccountCustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAccountCustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/customizations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAccountCustomizationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAccountCustomizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAccountCustomizationInput(v *CreateAccountCustomizationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAccountCustomizationInput(v *CreateAccountCustomizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountCustomization != nil {
		ok := object.Key("AccountCustomization")
		if err := awsRestjson1_serializeDocumentAccountCustomization(v.AccountCustomization, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAccountSubscription struct {
}

func (*awsRestjson1_serializeOpCreateAccountSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAccountSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAccountSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/account/{AwsAccountId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAccountSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAccountSubscriptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAccountSubscriptionInput(v *CreateAccountSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAccountSubscriptionInput(v *CreateAccountSubscriptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountName != nil {
		ok := object.Key("AccountName")
		ok.String(*v.AccountName)
	}

	if v.ActiveDirectoryName != nil {
		ok := object.Key("ActiveDirectoryName")
		ok.String(*v.ActiveDirectoryName)
	}

	if v.AdminGroup != nil {
		ok := object.Key("AdminGroup")
		if err := awsRestjson1_serializeDocumentGroupsList(v.AdminGroup, ok); err != nil {
			return err
		}
	}

	if v.AdminProGroup != nil {
		ok := object.Key("AdminProGroup")
		if err := awsRestjson1_serializeDocumentGroupsList(v.AdminProGroup, ok); err != nil {
			return err
		}
	}

	if len(v.AuthenticationMethod) > 0 {
		ok := object.Key("AuthenticationMethod")
		ok.String(string(v.AuthenticationMethod))
	}

	if v.AuthorGroup != nil {
		ok := object.Key("AuthorGroup")
		if err := awsRestjson1_serializeDocumentGroupsList(v.AuthorGroup, ok); err != nil {
			return err
		}
	}

	if v.AuthorProGroup != nil {
		ok := object.Key("AuthorProGroup")
		if err := awsRestjson1_serializeDocumentGroupsList(v.AuthorProGroup, ok); err != nil {
			return err
		}
	}

	if v.ContactNumber != nil {
		ok := object.Key("ContactNumber")
		ok.String(*v.ContactNumber)
	}

	if v.DirectoryId != nil {
		ok := object.Key("DirectoryId")
		ok.String(*v.DirectoryId)
	}

	if len(v.Edition) > 0 {
		ok := object.Key("Edition")
		ok.String(string(v.Edition))
	}

	if v.EmailAddress != nil {
		ok := object.Key("EmailAddress")
		ok.String(*v.EmailAddress)
	}

	if v.FirstName != nil {
		ok := object.Key("FirstName")
		ok.String(*v.FirstName)
	}

	if v.IAMIdentityCenterInstanceArn != nil {
		ok := object.Key("IAMIdentityCenterInstanceArn")
		ok.String(*v.IAMIdentityCenterInstanceArn)
	}

	if v.LastName != nil {
		ok := object.Key("LastName")
		ok.String(*v.LastName)
	}

	if v.NotificationEmail != nil {
		ok := object.Key("NotificationEmail")
		ok.String(*v.NotificationEmail)
	}

	if v.ReaderGroup != nil {
		ok := object.Key("ReaderGroup")
		if err := awsRestjson1_serializeDocumentGroupsList(v.ReaderGroup, ok); err != nil {
			return err
		}
	}

	if v.ReaderProGroup != nil {
		ok := object.Key("ReaderProGroup")
		if err := awsRestjson1_serializeDocumentGroupsList(v.ReaderProGroup, ok); err != nil {
			return err
		}
	}

	if v.Realm != nil {
		ok := object.Key("Realm")
		ok.String(*v.Realm)
	}

	return nil
}

type awsRestjson1_serializeOpCreateAnalysis struct {
}

func (*awsRestjson1_serializeOpCreateAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAnalysisInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAnalysisInput(v *CreateAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAnalysisInput(v *CreateAnalysisInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsRestjson1_serializeDocumentAnalysisDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.FolderArns != nil {
		ok := object.Key("FolderArns")
		if err := awsRestjson1_serializeDocumentFolderArnList(v.FolderArns, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentAnalysisSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ThemeArn != nil {
		ok := object.Key("ThemeArn")
		ok.String(*v.ThemeArn)
	}

	if v.ValidationStrategy != nil {
		ok := object.Key("ValidationStrategy")
		if err := awsRestjson1_serializeDocumentValidationStrategy(v.ValidationStrategy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDashboard struct {
}

func (*awsRestjson1_serializeOpCreateDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDashboardInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDashboardInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDashboardInput(v *CreateDashboardInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDashboardInput(v *CreateDashboardInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashboardPublishOptions != nil {
		ok := object.Key("DashboardPublishOptions")
		if err := awsRestjson1_serializeDocumentDashboardPublishOptions(v.DashboardPublishOptions, ok); err != nil {
			return err
		}
	}

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsRestjson1_serializeDocumentDashboardVersionDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.FolderArns != nil {
		ok := object.Key("FolderArns")
		if err := awsRestjson1_serializeDocumentFolderArnList(v.FolderArns, ok); err != nil {
			return err
		}
	}

	if v.LinkEntities != nil {
		ok := object.Key("LinkEntities")
		if err := awsRestjson1_serializeDocumentLinkEntityArnList(v.LinkEntities, ok); err != nil {
			return err
		}
	}

	if v.LinkSharingConfiguration != nil {
		ok := object.Key("LinkSharingConfiguration")
		if err := awsRestjson1_serializeDocumentLinkSharingConfiguration(v.LinkSharingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentDashboardSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ThemeArn != nil {
		ok := object.Key("ThemeArn")
		ok.String(*v.ThemeArn)
	}

	if v.ValidationStrategy != nil {
		ok := object.Key("ValidationStrategy")
		if err := awsRestjson1_serializeDocumentValidationStrategy(v.ValidationStrategy, ok); err != nil {
			return err
		}
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataSet struct {
}

func (*awsRestjson1_serializeOpCreateDataSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDataSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataSetInput(v *CreateDataSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataSetInput(v *CreateDataSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnGroups != nil {
		ok := object.Key("ColumnGroups")
		if err := awsRestjson1_serializeDocumentColumnGroupList(v.ColumnGroups, ok); err != nil {
			return err
		}
	}

	if v.ColumnLevelPermissionRules != nil {
		ok := object.Key("ColumnLevelPermissionRules")
		if err := awsRestjson1_serializeDocumentColumnLevelPermissionRuleList(v.ColumnLevelPermissionRules, ok); err != nil {
			return err
		}
	}

	if v.DataSetId != nil {
		ok := object.Key("DataSetId")
		ok.String(*v.DataSetId)
	}

	if v.DatasetParameters != nil {
		ok := object.Key("DatasetParameters")
		if err := awsRestjson1_serializeDocumentDatasetParameterList(v.DatasetParameters, ok); err != nil {
			return err
		}
	}

	if v.DataSetUsageConfiguration != nil {
		ok := object.Key("DataSetUsageConfiguration")
		if err := awsRestjson1_serializeDocumentDataSetUsageConfiguration(v.DataSetUsageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FieldFolders != nil {
		ok := object.Key("FieldFolders")
		if err := awsRestjson1_serializeDocumentFieldFolderMap(v.FieldFolders, ok); err != nil {
			return err
		}
	}

	if v.FolderArns != nil {
		ok := object.Key("FolderArns")
		if err := awsRestjson1_serializeDocumentFolderArnList(v.FolderArns, ok); err != nil {
			return err
		}
	}

	if len(v.ImportMode) > 0 {
		ok := object.Key("ImportMode")
		ok.String(string(v.ImportMode))
	}

	if v.LogicalTableMap != nil {
		ok := object.Key("LogicalTableMap")
		if err := awsRestjson1_serializeDocumentLogicalTableMap(v.LogicalTableMap, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.PhysicalTableMap != nil {
		ok := object.Key("PhysicalTableMap")
		if err := awsRestjson1_serializeDocumentPhysicalTableMap(v.PhysicalTableMap, ok); err != nil {
			return err
		}
	}

	if v.RowLevelPermissionDataSet != nil {
		ok := object.Key("RowLevelPermissionDataSet")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionDataSet(v.RowLevelPermissionDataSet, ok); err != nil {
			return err
		}
	}

	if v.RowLevelPermissionTagConfiguration != nil {
		ok := object.Key("RowLevelPermissionTagConfiguration")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagConfiguration(v.RowLevelPermissionTagConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataSource struct {
}

func (*awsRestjson1_serializeOpCreateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(v *CreateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataSourceInput(v *CreateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentDataSourceCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		ok := object.Key("DataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.DataSourceParameters != nil {
		ok := object.Key("DataSourceParameters")
		if err := awsRestjson1_serializeDocumentDataSourceParameters(v.DataSourceParameters, ok); err != nil {
			return err
		}
	}

	if v.FolderArns != nil {
		ok := object.Key("FolderArns")
		if err := awsRestjson1_serializeDocumentFolderArnList(v.FolderArns, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.SslProperties != nil {
		ok := object.Key("SslProperties")
		if err := awsRestjson1_serializeDocumentSslProperties(v.SslProperties, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.VpcConnectionProperties != nil {
		ok := object.Key("VpcConnectionProperties")
		if err := awsRestjson1_serializeDocumentVpcConnectionProperties(v.VpcConnectionProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFolder struct {
}

func (*awsRestjson1_serializeOpCreateFolder) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFolder) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFolderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFolderInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFolderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFolderInput(v *CreateFolderInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFolderInput(v *CreateFolderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FolderType) > 0 {
		ok := object.Key("FolderType")
		ok.String(string(v.FolderType))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ParentFolderArn != nil {
		ok := object.Key("ParentFolderArn")
		ok.String(*v.ParentFolderArn)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if len(v.SharingModel) > 0 {
		ok := object.Key("SharingModel")
		ok.String(string(v.SharingModel))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFolderMembership struct {
}

func (*awsRestjson1_serializeOpCreateFolderMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFolderMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFolderMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFolderMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFolderMembershipInput(v *CreateFolderMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	if v.MemberId == nil || len(*v.MemberId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberId must not be empty")}
	}
	if v.MemberId != nil {
		if err := encoder.SetURI("MemberId").String(*v.MemberId); err != nil {
			return err
		}
	}

	if len(v.MemberType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberType must not be empty")}
	}
	if len(v.MemberType) > 0 {
		if err := encoder.SetURI("MemberType").String(string(v.MemberType)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateGroup struct {
}

func (*awsRestjson1_serializeOpCreateGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGroupInput(v *CreateGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGroupInput(v *CreateGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateGroupMembership struct {
}

func (*awsRestjson1_serializeOpCreateGroupMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGroupMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGroupMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateGroupMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGroupMembershipInput(v *CreateGroupMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.MemberName == nil || len(*v.MemberName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberName must not be empty")}
	}
	if v.MemberName != nil {
		if err := encoder.SetURI("MemberName").String(*v.MemberName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateIAMPolicyAssignment struct {
}

func (*awsRestjson1_serializeOpCreateIAMPolicyAssignment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIAMPolicyAssignment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIAMPolicyAssignmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIAMPolicyAssignmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIAMPolicyAssignmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIAMPolicyAssignmentInput(v *CreateIAMPolicyAssignmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIAMPolicyAssignmentInput(v *CreateIAMPolicyAssignmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssignmentName != nil {
		ok := object.Key("AssignmentName")
		ok.String(*v.AssignmentName)
	}

	if len(v.AssignmentStatus) > 0 {
		ok := object.Key("AssignmentStatus")
		ok.String(string(v.AssignmentStatus))
	}

	if v.Identities != nil {
		ok := object.Key("Identities")
		if err := awsRestjson1_serializeDocumentIdentityMap(v.Identities, ok); err != nil {
			return err
		}
	}

	if v.PolicyArn != nil {
		ok := object.Key("PolicyArn")
		ok.String(*v.PolicyArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateIngestion struct {
}

func (*awsRestjson1_serializeOpCreateIngestion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIngestion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIngestionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIngestionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIngestionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIngestionInput(v *CreateIngestionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.IngestionId == nil || len(*v.IngestionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IngestionId must not be empty")}
	}
	if v.IngestionId != nil {
		if err := encoder.SetURI("IngestionId").String(*v.IngestionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIngestionInput(v *CreateIngestionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IngestionType) > 0 {
		ok := object.Key("IngestionType")
		ok.String(string(v.IngestionType))
	}

	return nil
}

type awsRestjson1_serializeOpCreateNamespace struct {
}

func (*awsRestjson1_serializeOpCreateNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateNamespaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateNamespaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateNamespaceInput(v *CreateNamespaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateNamespaceInput(v *CreateNamespaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IdentityStore) > 0 {
		ok := object.Key("IdentityStore")
		ok.String(string(v.IdentityStore))
	}

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateRefreshSchedule struct {
}

func (*awsRestjson1_serializeOpCreateRefreshSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRefreshSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRefreshScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateRefreshScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRefreshScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRefreshScheduleInput(v *CreateRefreshScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRefreshScheduleInput(v *CreateRefreshScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		if err := awsRestjson1_serializeDocumentRefreshSchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateRoleMembership struct {
}

func (*awsRestjson1_serializeOpCreateRoleMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRoleMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRoleMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/members/{MemberName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateRoleMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRoleMembershipInput(v *CreateRoleMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MemberName == nil || len(*v.MemberName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberName must not be empty")}
	}
	if v.MemberName != nil {
		if err := encoder.SetURI("MemberName").String(*v.MemberName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if len(v.Role) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Role must not be empty")}
	}
	if len(v.Role) > 0 {
		if err := encoder.SetURI("Role").String(string(v.Role)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTemplate struct {
}

func (*awsRestjson1_serializeOpCreateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTemplateInput(v *CreateTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTemplateInput(v *CreateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsRestjson1_serializeDocumentTemplateVersionDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentTemplateSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ValidationStrategy != nil {
		ok := object.Key("ValidationStrategy")
		if err := awsRestjson1_serializeDocumentValidationStrategy(v.ValidationStrategy, ok); err != nil {
			return err
		}
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpCreateTemplateAlias struct {
}

func (*awsRestjson1_serializeOpCreateTemplateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTemplateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTemplateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTemplateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTemplateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTemplateAliasInput(v *CreateTemplateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTemplateAliasInput(v *CreateTemplateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TemplateVersionNumber != nil {
		ok := object.Key("TemplateVersionNumber")
		ok.Long(*v.TemplateVersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpCreateTheme struct {
}

func (*awsRestjson1_serializeOpCreateTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateThemeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateThemeInput(v *CreateThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateThemeInput(v *CreateThemeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseThemeId != nil {
		ok := object.Key("BaseThemeId")
		ok.String(*v.BaseThemeId)
	}

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsRestjson1_serializeDocumentThemeConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpCreateThemeAlias struct {
}

func (*awsRestjson1_serializeOpCreateThemeAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateThemeAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateThemeAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateThemeAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateThemeAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateThemeAliasInput(v *CreateThemeAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateThemeAliasInput(v *CreateThemeAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThemeVersionNumber != nil {
		ok := object.Key("ThemeVersionNumber")
		ok.Long(*v.ThemeVersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpCreateTopic struct {
}

func (*awsRestjson1_serializeOpCreateTopic) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTopic) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTopicInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTopicInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTopicInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTopicInput(v *CreateTopicInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTopicInput(v *CreateTopicInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Topic != nil {
		ok := object.Key("Topic")
		if err := awsRestjson1_serializeDocumentTopicDetails(v.Topic, ok); err != nil {
			return err
		}
	}

	if v.TopicId != nil {
		ok := object.Key("TopicId")
		ok.String(*v.TopicId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateTopicRefreshSchedule struct {
}

func (*awsRestjson1_serializeOpCreateTopicRefreshSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTopicRefreshSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTopicRefreshScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}/schedules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTopicRefreshScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTopicRefreshScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTopicRefreshScheduleInput(v *CreateTopicRefreshScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTopicRefreshScheduleInput(v *CreateTopicRefreshScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetArn != nil {
		ok := object.Key("DatasetArn")
		ok.String(*v.DatasetArn)
	}

	if v.DatasetName != nil {
		ok := object.Key("DatasetName")
		ok.String(*v.DatasetName)
	}

	if v.RefreshSchedule != nil {
		ok := object.Key("RefreshSchedule")
		if err := awsRestjson1_serializeDocumentTopicRefreshSchedule(v.RefreshSchedule, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateVPCConnection struct {
}

func (*awsRestjson1_serializeOpCreateVPCConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateVPCConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVPCConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/vpc-connections")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateVPCConnectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateVPCConnectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateVPCConnectionInput(v *CreateVPCConnectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateVPCConnectionInput(v *CreateVPCConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DnsResolvers != nil {
		ok := object.Key("DnsResolvers")
		if err := awsRestjson1_serializeDocumentDnsResolverList(v.DnsResolvers, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIdList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIdList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VPCConnectionId != nil {
		ok := object.Key("VPCConnectionId")
		ok.String(*v.VPCConnectionId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAccountCustomization struct {
}

func (*awsRestjson1_serializeOpDeleteAccountCustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAccountCustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccountCustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/customizations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAccountCustomizationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAccountCustomizationInput(v *DeleteAccountCustomizationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAccountSubscription struct {
}

func (*awsRestjson1_serializeOpDeleteAccountSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAccountSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccountSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/account/{AwsAccountId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAccountSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAccountSubscriptionInput(v *DeleteAccountSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAnalysis struct {
}

func (*awsRestjson1_serializeOpDeleteAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAnalysisInput(v *DeleteAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ForceDeleteWithoutRecovery {
		encoder.SetQuery("force-delete-without-recovery").Boolean(v.ForceDeleteWithoutRecovery)
	}

	if v.RecoveryWindowInDays != nil {
		encoder.SetQuery("recovery-window-in-days").Long(*v.RecoveryWindowInDays)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDashboard struct {
}

func (*awsRestjson1_serializeOpDeleteDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDashboardInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDashboardInput(v *DeleteDashboardInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataSet struct {
}

func (*awsRestjson1_serializeOpDeleteDataSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataSetInput(v *DeleteDataSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataSetRefreshProperties struct {
}

func (*awsRestjson1_serializeOpDeleteDataSetRefreshProperties) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataSetRefreshProperties) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataSetRefreshPropertiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-properties")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataSetRefreshPropertiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataSetRefreshPropertiesInput(v *DeleteDataSetRefreshPropertiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataSource struct {
}

func (*awsRestjson1_serializeOpDeleteDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(v *DeleteDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFolder struct {
}

func (*awsRestjson1_serializeOpDeleteFolder) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFolder) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFolderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFolderInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFolderInput(v *DeleteFolderInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFolderMembership struct {
}

func (*awsRestjson1_serializeOpDeleteFolderMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFolderMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFolderMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFolderMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFolderMembershipInput(v *DeleteFolderMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	if v.MemberId == nil || len(*v.MemberId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberId must not be empty")}
	}
	if v.MemberId != nil {
		if err := encoder.SetURI("MemberId").String(*v.MemberId); err != nil {
			return err
		}
	}

	if len(v.MemberType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberType must not be empty")}
	}
	if len(v.MemberType) > 0 {
		if err := encoder.SetURI("MemberType").String(string(v.MemberType)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGroup struct {
}

func (*awsRestjson1_serializeOpDeleteGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGroupInput(v *DeleteGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGroupMembership struct {
}

func (*awsRestjson1_serializeOpDeleteGroupMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGroupMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGroupMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGroupMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGroupMembershipInput(v *DeleteGroupMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.MemberName == nil || len(*v.MemberName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberName must not be empty")}
	}
	if v.MemberName != nil {
		if err := encoder.SetURI("MemberName").String(*v.MemberName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIAMPolicyAssignment struct {
}

func (*awsRestjson1_serializeOpDeleteIAMPolicyAssignment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIAMPolicyAssignment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIAMPolicyAssignmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespace/{Namespace}/iam-policy-assignments/{AssignmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIAMPolicyAssignmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIAMPolicyAssignmentInput(v *DeleteIAMPolicyAssignmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssignmentName == nil || len(*v.AssignmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssignmentName must not be empty")}
	}
	if v.AssignmentName != nil {
		if err := encoder.SetURI("AssignmentName").String(*v.AssignmentName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIdentityPropagationConfig struct {
}

func (*awsRestjson1_serializeOpDeleteIdentityPropagationConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIdentityPropagationConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIdentityPropagationConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/identity-propagation-config/{Service}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIdentityPropagationConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIdentityPropagationConfigInput(v *DeleteIdentityPropagationConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if len(v.Service) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Service must not be empty")}
	}
	if len(v.Service) > 0 {
		if err := encoder.SetURI("Service").String(string(v.Service)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteNamespace struct {
}

func (*awsRestjson1_serializeOpDeleteNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteNamespaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteNamespaceInput(v *DeleteNamespaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRefreshSchedule struct {
}

func (*awsRestjson1_serializeOpDeleteRefreshSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRefreshSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRefreshScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules/{ScheduleId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRefreshScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRefreshScheduleInput(v *DeleteRefreshScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.ScheduleId == nil || len(*v.ScheduleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ScheduleId must not be empty")}
	}
	if v.ScheduleId != nil {
		if err := encoder.SetURI("ScheduleId").String(*v.ScheduleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRoleCustomPermission struct {
}

func (*awsRestjson1_serializeOpDeleteRoleCustomPermission) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRoleCustomPermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRoleCustomPermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/custom-permission")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRoleCustomPermissionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRoleCustomPermissionInput(v *DeleteRoleCustomPermissionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if len(v.Role) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Role must not be empty")}
	}
	if len(v.Role) > 0 {
		if err := encoder.SetURI("Role").String(string(v.Role)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRoleMembership struct {
}

func (*awsRestjson1_serializeOpDeleteRoleMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRoleMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRoleMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/members/{MemberName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRoleMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRoleMembershipInput(v *DeleteRoleMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MemberName == nil || len(*v.MemberName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberName must not be empty")}
	}
	if v.MemberName != nil {
		if err := encoder.SetURI("MemberName").String(*v.MemberName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if len(v.Role) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Role must not be empty")}
	}
	if len(v.Role) > 0 {
		if err := encoder.SetURI("Role").String(string(v.Role)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTemplateInput(v *DeleteTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTemplateAlias struct {
}

func (*awsRestjson1_serializeOpDeleteTemplateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTemplateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTemplateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTemplateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTemplateAliasInput(v *DeleteTemplateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTheme struct {
}

func (*awsRestjson1_serializeOpDeleteTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteThemeInput(v *DeleteThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteThemeAlias struct {
}

func (*awsRestjson1_serializeOpDeleteThemeAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteThemeAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteThemeAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteThemeAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteThemeAliasInput(v *DeleteThemeAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTopic struct {
}

func (*awsRestjson1_serializeOpDeleteTopic) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTopic) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTopicInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTopicInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTopicInput(v *DeleteTopicInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTopicRefreshSchedule struct {
}

func (*awsRestjson1_serializeOpDeleteTopicRefreshSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTopicRefreshSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTopicRefreshScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}/schedules/{DatasetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTopicRefreshScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTopicRefreshScheduleInput(v *DeleteTopicRefreshScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DatasetId == nil || len(*v.DatasetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DatasetId must not be empty")}
	}
	if v.DatasetId != nil {
		if err := encoder.SetURI("DatasetId").String(*v.DatasetId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUser struct {
}

func (*awsRestjson1_serializeOpDeleteUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUserInput(v *DeleteUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUserByPrincipalId struct {
}

func (*awsRestjson1_serializeOpDeleteUserByPrincipalId) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUserByPrincipalId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserByPrincipalIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUserByPrincipalIdInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUserByPrincipalIdInput(v *DeleteUserByPrincipalIdInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PrincipalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("PrincipalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVPCConnection struct {
}

func (*awsRestjson1_serializeOpDeleteVPCConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVPCConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVPCConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/vpc-connections/{VPCConnectionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVPCConnectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVPCConnectionInput(v *DeleteVPCConnectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.VPCConnectionId == nil || len(*v.VPCConnectionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VPCConnectionId must not be empty")}
	}
	if v.VPCConnectionId != nil {
		if err := encoder.SetURI("VPCConnectionId").String(*v.VPCConnectionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAccountCustomization struct {
}

func (*awsRestjson1_serializeOpDescribeAccountCustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAccountCustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountCustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/customizations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAccountCustomizationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAccountCustomizationInput(v *DescribeAccountCustomizationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	if v.Resolved {
		encoder.SetQuery("resolved").Boolean(v.Resolved)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAccountSettings struct {
}

func (*awsRestjson1_serializeOpDescribeAccountSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAccountSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAccountSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAccountSettingsInput(v *DescribeAccountSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAccountSubscription struct {
}

func (*awsRestjson1_serializeOpDescribeAccountSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAccountSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/account/{AwsAccountId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAccountSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAccountSubscriptionInput(v *DescribeAccountSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAnalysis struct {
}

func (*awsRestjson1_serializeOpDescribeAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAnalysisInput(v *DescribeAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAnalysisDefinition struct {
}

func (*awsRestjson1_serializeOpDescribeAnalysisDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAnalysisDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAnalysisDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}/definition")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAnalysisDefinitionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAnalysisDefinitionInput(v *DescribeAnalysisDefinitionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAnalysisPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeAnalysisPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAnalysisPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAnalysisPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAnalysisPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAnalysisPermissionsInput(v *DescribeAnalysisPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAssetBundleExportJob struct {
}

func (*awsRestjson1_serializeOpDescribeAssetBundleExportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAssetBundleExportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAssetBundleExportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/asset-bundle-export-jobs/{AssetBundleExportJobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAssetBundleExportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAssetBundleExportJobInput(v *DescribeAssetBundleExportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssetBundleExportJobId == nil || len(*v.AssetBundleExportJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssetBundleExportJobId must not be empty")}
	}
	if v.AssetBundleExportJobId != nil {
		if err := encoder.SetURI("AssetBundleExportJobId").String(*v.AssetBundleExportJobId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAssetBundleImportJob struct {
}

func (*awsRestjson1_serializeOpDescribeAssetBundleImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAssetBundleImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAssetBundleImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/asset-bundle-import-jobs/{AssetBundleImportJobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAssetBundleImportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAssetBundleImportJobInput(v *DescribeAssetBundleImportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssetBundleImportJobId == nil || len(*v.AssetBundleImportJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssetBundleImportJobId must not be empty")}
	}
	if v.AssetBundleImportJobId != nil {
		if err := encoder.SetURI("AssetBundleImportJobId").String(*v.AssetBundleImportJobId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDashboard struct {
}

func (*awsRestjson1_serializeOpDescribeDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDashboardInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDashboardInput(v *DescribeDashboardInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName != nil {
		encoder.SetQuery("alias-name").String(*v.AliasName)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDashboardDefinition struct {
}

func (*awsRestjson1_serializeOpDescribeDashboardDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDashboardDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDashboardDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/definition")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDashboardDefinitionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDashboardDefinitionInput(v *DescribeDashboardDefinitionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName != nil {
		encoder.SetQuery("alias-name").String(*v.AliasName)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDashboardPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeDashboardPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDashboardPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDashboardPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDashboardPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDashboardPermissionsInput(v *DescribeDashboardPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDashboardSnapshotJob struct {
}

func (*awsRestjson1_serializeOpDescribeDashboardSnapshotJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDashboardSnapshotJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDashboardSnapshotJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/snapshot-jobs/{SnapshotJobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDashboardSnapshotJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDashboardSnapshotJobInput(v *DescribeDashboardSnapshotJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.SnapshotJobId == nil || len(*v.SnapshotJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SnapshotJobId must not be empty")}
	}
	if v.SnapshotJobId != nil {
		if err := encoder.SetURI("SnapshotJobId").String(*v.SnapshotJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDashboardSnapshotJobResult struct {
}

func (*awsRestjson1_serializeOpDescribeDashboardSnapshotJobResult) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDashboardSnapshotJobResult) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDashboardSnapshotJobResultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/snapshot-jobs/{SnapshotJobId}/result")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDashboardSnapshotJobResultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDashboardSnapshotJobResultInput(v *DescribeDashboardSnapshotJobResultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.SnapshotJobId == nil || len(*v.SnapshotJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SnapshotJobId must not be empty")}
	}
	if v.SnapshotJobId != nil {
		if err := encoder.SetURI("SnapshotJobId").String(*v.SnapshotJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataSet struct {
}

func (*awsRestjson1_serializeOpDescribeDataSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDataSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDataSetInput(v *DescribeDataSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataSetPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeDataSetPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataSetPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSetPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDataSetPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDataSetPermissionsInput(v *DescribeDataSetPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataSetRefreshProperties struct {
}

func (*awsRestjson1_serializeOpDescribeDataSetRefreshProperties) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataSetRefreshProperties) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSetRefreshPropertiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-properties")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDataSetRefreshPropertiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDataSetRefreshPropertiesInput(v *DescribeDataSetRefreshPropertiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataSource struct {
}

func (*awsRestjson1_serializeOpDescribeDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDataSourceInput(v *DescribeDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataSourcePermissions struct {
}

func (*awsRestjson1_serializeOpDescribeDataSourcePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataSourcePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSourcePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDataSourcePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDataSourcePermissionsInput(v *DescribeDataSourcePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFolder struct {
}

func (*awsRestjson1_serializeOpDescribeFolder) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFolder) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFolderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFolderInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFolderInput(v *DescribeFolderInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFolderPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeFolderPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFolderPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFolderPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFolderPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFolderPermissionsInput(v *DescribeFolderPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFolderResolvedPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeFolderResolvedPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFolderResolvedPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFolderResolvedPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/resolved-permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFolderResolvedPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFolderResolvedPermissionsInput(v *DescribeFolderResolvedPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGroup struct {
}

func (*awsRestjson1_serializeOpDescribeGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGroupInput(v *DescribeGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGroupMembership struct {
}

func (*awsRestjson1_serializeOpDescribeGroupMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGroupMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGroupMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGroupMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGroupMembershipInput(v *DescribeGroupMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.MemberName == nil || len(*v.MemberName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberName must not be empty")}
	}
	if v.MemberName != nil {
		if err := encoder.SetURI("MemberName").String(*v.MemberName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIAMPolicyAssignment struct {
}

func (*awsRestjson1_serializeOpDescribeIAMPolicyAssignment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIAMPolicyAssignment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIAMPolicyAssignmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIAMPolicyAssignmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIAMPolicyAssignmentInput(v *DescribeIAMPolicyAssignmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssignmentName == nil || len(*v.AssignmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssignmentName must not be empty")}
	}
	if v.AssignmentName != nil {
		if err := encoder.SetURI("AssignmentName").String(*v.AssignmentName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIngestion struct {
}

func (*awsRestjson1_serializeOpDescribeIngestion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIngestion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIngestionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIngestionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIngestionInput(v *DescribeIngestionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.IngestionId == nil || len(*v.IngestionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IngestionId must not be empty")}
	}
	if v.IngestionId != nil {
		if err := encoder.SetURI("IngestionId").String(*v.IngestionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIpRestriction struct {
}

func (*awsRestjson1_serializeOpDescribeIpRestriction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIpRestriction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIpRestrictionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/ip-restriction")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIpRestrictionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIpRestrictionInput(v *DescribeIpRestrictionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeKeyRegistration struct {
}

func (*awsRestjson1_serializeOpDescribeKeyRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeKeyRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeKeyRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/key-registration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeKeyRegistrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeKeyRegistrationInput(v *DescribeKeyRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DefaultKeyOnly {
		encoder.SetQuery("default-key-only").Boolean(v.DefaultKeyOnly)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeNamespace struct {
}

func (*awsRestjson1_serializeOpDescribeNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeNamespaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeNamespaceInput(v *DescribeNamespaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRefreshSchedule struct {
}

func (*awsRestjson1_serializeOpDescribeRefreshSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRefreshSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRefreshScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules/{ScheduleId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRefreshScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRefreshScheduleInput(v *DescribeRefreshScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.ScheduleId == nil || len(*v.ScheduleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ScheduleId must not be empty")}
	}
	if v.ScheduleId != nil {
		if err := encoder.SetURI("ScheduleId").String(*v.ScheduleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRoleCustomPermission struct {
}

func (*awsRestjson1_serializeOpDescribeRoleCustomPermission) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRoleCustomPermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRoleCustomPermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/custom-permission")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRoleCustomPermissionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRoleCustomPermissionInput(v *DescribeRoleCustomPermissionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if len(v.Role) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Role must not be empty")}
	}
	if len(v.Role) > 0 {
		if err := encoder.SetURI("Role").String(string(v.Role)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTemplate struct {
}

func (*awsRestjson1_serializeOpDescribeTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTemplateInput(v *DescribeTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName != nil {
		encoder.SetQuery("alias-name").String(*v.AliasName)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTemplateAlias struct {
}

func (*awsRestjson1_serializeOpDescribeTemplateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTemplateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTemplateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTemplateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTemplateAliasInput(v *DescribeTemplateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTemplateDefinition struct {
}

func (*awsRestjson1_serializeOpDescribeTemplateDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTemplateDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTemplateDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/definition")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTemplateDefinitionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTemplateDefinitionInput(v *DescribeTemplateDefinitionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName != nil {
		encoder.SetQuery("alias-name").String(*v.AliasName)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTemplatePermissions struct {
}

func (*awsRestjson1_serializeOpDescribeTemplatePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTemplatePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTemplatePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTemplatePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTemplatePermissionsInput(v *DescribeTemplatePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTheme struct {
}

func (*awsRestjson1_serializeOpDescribeTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThemeInput(v *DescribeThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName != nil {
		encoder.SetQuery("alias-name").String(*v.AliasName)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeThemeAlias struct {
}

func (*awsRestjson1_serializeOpDescribeThemeAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeThemeAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThemeAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThemeAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThemeAliasInput(v *DescribeThemeAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeThemePermissions struct {
}

func (*awsRestjson1_serializeOpDescribeThemePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeThemePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThemePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThemePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThemePermissionsInput(v *DescribeThemePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTopic struct {
}

func (*awsRestjson1_serializeOpDescribeTopic) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTopic) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTopicInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTopicInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTopicInput(v *DescribeTopicInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTopicPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeTopicPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTopicPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTopicPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTopicPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTopicPermissionsInput(v *DescribeTopicPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTopicRefresh struct {
}

func (*awsRestjson1_serializeOpDescribeTopicRefresh) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTopicRefresh) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTopicRefreshInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}/refresh/{RefreshId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTopicRefreshInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTopicRefreshInput(v *DescribeTopicRefreshInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.RefreshId == nil || len(*v.RefreshId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RefreshId must not be empty")}
	}
	if v.RefreshId != nil {
		if err := encoder.SetURI("RefreshId").String(*v.RefreshId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTopicRefreshSchedule struct {
}

func (*awsRestjson1_serializeOpDescribeTopicRefreshSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTopicRefreshSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTopicRefreshScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}/schedules/{DatasetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTopicRefreshScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTopicRefreshScheduleInput(v *DescribeTopicRefreshScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DatasetId == nil || len(*v.DatasetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DatasetId must not be empty")}
	}
	if v.DatasetId != nil {
		if err := encoder.SetURI("DatasetId").String(*v.DatasetId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeUser struct {
}

func (*awsRestjson1_serializeOpDescribeUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeUserInput(v *DescribeUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeVPCConnection struct {
}

func (*awsRestjson1_serializeOpDescribeVPCConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeVPCConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVPCConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/vpc-connections/{VPCConnectionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeVPCConnectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeVPCConnectionInput(v *DescribeVPCConnectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.VPCConnectionId == nil || len(*v.VPCConnectionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VPCConnectionId must not be empty")}
	}
	if v.VPCConnectionId != nil {
		if err := encoder.SetURI("VPCConnectionId").String(*v.VPCConnectionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGenerateEmbedUrlForAnonymousUser struct {
}

func (*awsRestjson1_serializeOpGenerateEmbedUrlForAnonymousUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGenerateEmbedUrlForAnonymousUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GenerateEmbedUrlForAnonymousUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/embed-url/anonymous-user")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGenerateEmbedUrlForAnonymousUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGenerateEmbedUrlForAnonymousUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGenerateEmbedUrlForAnonymousUserInput(v *GenerateEmbedUrlForAnonymousUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGenerateEmbedUrlForAnonymousUserInput(v *GenerateEmbedUrlForAnonymousUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedDomains != nil {
		ok := object.Key("AllowedDomains")
		if err := awsRestjson1_serializeDocumentStringList(v.AllowedDomains, ok); err != nil {
			return err
		}
	}

	if v.AuthorizedResourceArns != nil {
		ok := object.Key("AuthorizedResourceArns")
		if err := awsRestjson1_serializeDocumentArnList(v.AuthorizedResourceArns, ok); err != nil {
			return err
		}
	}

	if v.ExperienceConfiguration != nil {
		ok := object.Key("ExperienceConfiguration")
		if err := awsRestjson1_serializeDocumentAnonymousUserEmbeddingExperienceConfiguration(v.ExperienceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	if v.SessionLifetimeInMinutes != nil {
		ok := object.Key("SessionLifetimeInMinutes")
		ok.Long(*v.SessionLifetimeInMinutes)
	}

	if v.SessionTags != nil {
		ok := object.Key("SessionTags")
		if err := awsRestjson1_serializeDocumentSessionTagList(v.SessionTags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGenerateEmbedUrlForRegisteredUser struct {
}

func (*awsRestjson1_serializeOpGenerateEmbedUrlForRegisteredUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGenerateEmbedUrlForRegisteredUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GenerateEmbedUrlForRegisteredUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/embed-url/registered-user")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGenerateEmbedUrlForRegisteredUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGenerateEmbedUrlForRegisteredUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGenerateEmbedUrlForRegisteredUserInput(v *GenerateEmbedUrlForRegisteredUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGenerateEmbedUrlForRegisteredUserInput(v *GenerateEmbedUrlForRegisteredUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedDomains != nil {
		ok := object.Key("AllowedDomains")
		if err := awsRestjson1_serializeDocumentStringList(v.AllowedDomains, ok); err != nil {
			return err
		}
	}

	if v.ExperienceConfiguration != nil {
		ok := object.Key("ExperienceConfiguration")
		if err := awsRestjson1_serializeDocumentRegisteredUserEmbeddingExperienceConfiguration(v.ExperienceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SessionLifetimeInMinutes != nil {
		ok := object.Key("SessionLifetimeInMinutes")
		ok.Long(*v.SessionLifetimeInMinutes)
	}

	if v.UserArn != nil {
		ok := object.Key("UserArn")
		ok.String(*v.UserArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetDashboardEmbedUrl struct {
}

func (*awsRestjson1_serializeOpGetDashboardEmbedUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDashboardEmbedUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDashboardEmbedUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDashboardEmbedUrlInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDashboardEmbedUrlInput(v *GetDashboardEmbedUrlInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AdditionalDashboardIds != nil {
		for i := range v.AdditionalDashboardIds {
			encoder.AddQuery("additional-dashboard-ids").String(v.AdditionalDashboardIds[i])
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if len(v.IdentityType) > 0 {
		encoder.SetQuery("creds-type").String(string(v.IdentityType))
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	if v.ResetDisabled {
		encoder.SetQuery("reset-disabled").Boolean(v.ResetDisabled)
	}

	if v.SessionLifetimeInMinutes != nil {
		encoder.SetQuery("session-lifetime").Long(*v.SessionLifetimeInMinutes)
	}

	if v.StatePersistenceEnabled {
		encoder.SetQuery("state-persistence-enabled").Boolean(v.StatePersistenceEnabled)
	}

	if v.UndoRedoDisabled {
		encoder.SetQuery("undo-redo-disabled").Boolean(v.UndoRedoDisabled)
	}

	if v.UserArn != nil {
		encoder.SetQuery("user-arn").String(*v.UserArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetSessionEmbedUrl struct {
}

func (*awsRestjson1_serializeOpGetSessionEmbedUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSessionEmbedUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSessionEmbedUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/session-embed-url")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSessionEmbedUrlInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSessionEmbedUrlInput(v *GetSessionEmbedUrlInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.EntryPoint != nil {
		encoder.SetQuery("entry-point").String(*v.EntryPoint)
	}

	if v.SessionLifetimeInMinutes != nil {
		encoder.SetQuery("session-lifetime").Long(*v.SessionLifetimeInMinutes)
	}

	if v.UserArn != nil {
		encoder.SetQuery("user-arn").String(*v.UserArn)
	}

	return nil
}

type awsRestjson1_serializeOpListAnalyses struct {
}

func (*awsRestjson1_serializeOpListAnalyses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAnalyses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAnalysesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAnalysesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAnalysesInput(v *ListAnalysesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAssetBundleExportJobs struct {
}

func (*awsRestjson1_serializeOpListAssetBundleExportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAssetBundleExportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAssetBundleExportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/asset-bundle-export-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAssetBundleExportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAssetBundleExportJobsInput(v *ListAssetBundleExportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAssetBundleImportJobs struct {
}

func (*awsRestjson1_serializeOpListAssetBundleImportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAssetBundleImportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAssetBundleImportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/asset-bundle-import-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAssetBundleImportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAssetBundleImportJobsInput(v *ListAssetBundleImportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDashboards struct {
}

func (*awsRestjson1_serializeOpListDashboards) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDashboards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDashboardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDashboardsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDashboardsInput(v *ListDashboardsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDashboardVersions struct {
}

func (*awsRestjson1_serializeOpListDashboardVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDashboardVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDashboardVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDashboardVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDashboardVersionsInput(v *ListDashboardVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDataSets struct {
}

func (*awsRestjson1_serializeOpListDataSets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataSetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataSetsInput(v *ListDataSetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDataSources struct {
}

func (*awsRestjson1_serializeOpListDataSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(v *ListDataSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFolderMembers struct {
}

func (*awsRestjson1_serializeOpListFolderMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFolderMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFolderMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFolderMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFolderMembersInput(v *ListFolderMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFolders struct {
}

func (*awsRestjson1_serializeOpListFolders) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFolders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFoldersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFoldersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFoldersInput(v *ListFoldersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGroupMemberships struct {
}

func (*awsRestjson1_serializeOpListGroupMemberships) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGroupMemberships) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGroupMembershipsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGroupMembershipsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGroupMembershipsInput(v *ListGroupMembershipsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGroups struct {
}

func (*awsRestjson1_serializeOpListGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGroupsInput(v *ListGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListIAMPolicyAssignments struct {
}

func (*awsRestjson1_serializeOpListIAMPolicyAssignments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIAMPolicyAssignments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIAMPolicyAssignmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/v2/iam-policy-assignments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIAMPolicyAssignmentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIAMPolicyAssignmentsInput(v *ListIAMPolicyAssignmentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.AssignmentStatus) > 0 {
		encoder.SetQuery("assignment-status").String(string(v.AssignmentStatus))
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListIAMPolicyAssignmentsForUser struct {
}

func (*awsRestjson1_serializeOpListIAMPolicyAssignmentsForUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIAMPolicyAssignmentsForUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIAMPolicyAssignmentsForUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/iam-policy-assignments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIAMPolicyAssignmentsForUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIAMPolicyAssignmentsForUserInput(v *ListIAMPolicyAssignmentsForUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListIdentityPropagationConfigs struct {
}

func (*awsRestjson1_serializeOpListIdentityPropagationConfigs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIdentityPropagationConfigs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIdentityPropagationConfigsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/identity-propagation-config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIdentityPropagationConfigsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIdentityPropagationConfigsInput(v *ListIdentityPropagationConfigsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListIngestions struct {
}

func (*awsRestjson1_serializeOpListIngestions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIngestions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIngestionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIngestionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIngestionsInput(v *ListIngestionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListNamespaces struct {
}

func (*awsRestjson1_serializeOpListNamespaces) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListNamespaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListNamespacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListNamespacesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListNamespacesInput(v *ListNamespacesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRefreshSchedules struct {
}

func (*awsRestjson1_serializeOpListRefreshSchedules) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRefreshSchedules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRefreshSchedulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRefreshSchedulesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRefreshSchedulesInput(v *ListRefreshSchedulesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListRoleMemberships struct {
}

func (*awsRestjson1_serializeOpListRoleMemberships) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRoleMemberships) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRoleMembershipsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRoleMembershipsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRoleMembershipsInput(v *ListRoleMembershipsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if len(v.Role) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Role must not be empty")}
	}
	if len(v.Role) > 0 {
		if err := encoder.SetURI("Role").String(string(v.Role)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/resources/{ResourceArn}/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTemplateAliases struct {
}

func (*awsRestjson1_serializeOpListTemplateAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplateAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplateAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplateAliasesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplateAliasesInput(v *ListTemplateAliasesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-result").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTemplates struct {
}

func (*awsRestjson1_serializeOpListTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplatesInput(v *ListTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-result").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTemplateVersions struct {
}

func (*awsRestjson1_serializeOpListTemplateVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplateVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplateVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplateVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplateVersionsInput(v *ListTemplateVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThemeAliases struct {
}

func (*awsRestjson1_serializeOpListThemeAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThemeAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThemeAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThemeAliasesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThemeAliasesInput(v *ListThemeAliasesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-result").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThemes struct {
}

func (*awsRestjson1_serializeOpListThemes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThemes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThemesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThemesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThemesInput(v *ListThemesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if len(v.Type) > 0 {
		encoder.SetQuery("type").String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpListThemeVersions struct {
}

func (*awsRestjson1_serializeOpListThemeVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThemeVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThemeVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThemeVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThemeVersionsInput(v *ListThemeVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTopicRefreshSchedules struct {
}

func (*awsRestjson1_serializeOpListTopicRefreshSchedules) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTopicRefreshSchedules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTopicRefreshSchedulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}/schedules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTopicRefreshSchedulesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTopicRefreshSchedulesInput(v *ListTopicRefreshSchedulesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTopics struct {
}

func (*awsRestjson1_serializeOpListTopics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTopics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTopicsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTopicsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTopicsInput(v *ListTopicsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListUserGroups struct {
}

func (*awsRestjson1_serializeOpListUserGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUserGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUserGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListUserGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUserGroupsInput(v *ListUserGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListUsers struct {
}

func (*awsRestjson1_serializeOpListUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListUsersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUsersInput(v *ListUsersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListVPCConnections struct {
}

func (*awsRestjson1_serializeOpListVPCConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListVPCConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVPCConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/vpc-connections")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListVPCConnectionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListVPCConnectionsInput(v *ListVPCConnectionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutDataSetRefreshProperties struct {
}

func (*awsRestjson1_serializeOpPutDataSetRefreshProperties) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutDataSetRefreshProperties) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutDataSetRefreshPropertiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-properties")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutDataSetRefreshPropertiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutDataSetRefreshPropertiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutDataSetRefreshPropertiesInput(v *PutDataSetRefreshPropertiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutDataSetRefreshPropertiesInput(v *PutDataSetRefreshPropertiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetRefreshProperties != nil {
		ok := object.Key("DataSetRefreshProperties")
		if err := awsRestjson1_serializeDocumentDataSetRefreshProperties(v.DataSetRefreshProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRegisterUser struct {
}

func (*awsRestjson1_serializeOpRegisterUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRegisterUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterUserInput(v *RegisterUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterUserInput(v *RegisterUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomFederationProviderUrl != nil {
		ok := object.Key("CustomFederationProviderUrl")
		ok.String(*v.CustomFederationProviderUrl)
	}

	if v.CustomPermissionsName != nil {
		ok := object.Key("CustomPermissionsName")
		ok.String(*v.CustomPermissionsName)
	}

	if v.Email != nil {
		ok := object.Key("Email")
		ok.String(*v.Email)
	}

	if v.ExternalLoginFederationProviderType != nil {
		ok := object.Key("ExternalLoginFederationProviderType")
		ok.String(*v.ExternalLoginFederationProviderType)
	}

	if v.ExternalLoginId != nil {
		ok := object.Key("ExternalLoginId")
		ok.String(*v.ExternalLoginId)
	}

	if v.IamArn != nil {
		ok := object.Key("IamArn")
		ok.String(*v.IamArn)
	}

	if len(v.IdentityType) > 0 {
		ok := object.Key("IdentityType")
		ok.String(string(v.IdentityType))
	}

	if v.SessionName != nil {
		ok := object.Key("SessionName")
		ok.String(*v.SessionName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.UserName != nil {
		ok := object.Key("UserName")
		ok.String(*v.UserName)
	}

	if len(v.UserRole) > 0 {
		ok := object.Key("UserRole")
		ok.String(string(v.UserRole))
	}

	return nil
}

type awsRestjson1_serializeOpRestoreAnalysis struct {
}

func (*awsRestjson1_serializeOpRestoreAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRestoreAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/restore/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRestoreAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRestoreAnalysisInput(v *RestoreAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSearchAnalyses struct {
}

func (*awsRestjson1_serializeOpSearchAnalyses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchAnalyses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchAnalysesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/search/analyses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchAnalysesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchAnalysesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchAnalysesInput(v *SearchAnalysesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchAnalysesInput(v *SearchAnalysesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentAnalysisSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpSearchDashboards struct {
}

func (*awsRestjson1_serializeOpSearchDashboards) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchDashboards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchDashboardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/search/dashboards")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchDashboardsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchDashboardsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchDashboardsInput(v *SearchDashboardsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchDashboardsInput(v *SearchDashboardsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentDashboardSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpSearchDataSets struct {
}

func (*awsRestjson1_serializeOpSearchDataSets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchDataSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchDataSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/search/data-sets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchDataSetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchDataSetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchDataSetsInput(v *SearchDataSetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchDataSetsInput(v *SearchDataSetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentDataSetSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpSearchDataSources struct {
}

func (*awsRestjson1_serializeOpSearchDataSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchDataSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchDataSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/search/data-sources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchDataSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchDataSourcesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchDataSourcesInput(v *SearchDataSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchDataSourcesInput(v *SearchDataSourcesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentDataSourceSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpSearchFolders struct {
}

func (*awsRestjson1_serializeOpSearchFolders) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchFolders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchFoldersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/search/folders")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchFoldersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchFoldersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchFoldersInput(v *SearchFoldersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchFoldersInput(v *SearchFoldersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentFolderSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpSearchGroups struct {
}

func (*awsRestjson1_serializeOpSearchGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups-search")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchGroupsInput(v *SearchGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchGroupsInput(v *SearchGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentGroupSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartAssetBundleExportJob struct {
}

func (*awsRestjson1_serializeOpStartAssetBundleExportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartAssetBundleExportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartAssetBundleExportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/asset-bundle-export-jobs/export")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartAssetBundleExportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartAssetBundleExportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartAssetBundleExportJobInput(v *StartAssetBundleExportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartAssetBundleExportJobInput(v *StartAssetBundleExportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssetBundleExportJobId != nil {
		ok := object.Key("AssetBundleExportJobId")
		ok.String(*v.AssetBundleExportJobId)
	}

	if v.CloudFormationOverridePropertyConfiguration != nil {
		ok := object.Key("CloudFormationOverridePropertyConfiguration")
		if err := awsRestjson1_serializeDocumentAssetBundleCloudFormationOverridePropertyConfiguration(v.CloudFormationOverridePropertyConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.ExportFormat) > 0 {
		ok := object.Key("ExportFormat")
		ok.String(string(v.ExportFormat))
	}

	if v.IncludeAllDependencies {
		ok := object.Key("IncludeAllDependencies")
		ok.Boolean(v.IncludeAllDependencies)
	}

	if v.IncludePermissions {
		ok := object.Key("IncludePermissions")
		ok.Boolean(v.IncludePermissions)
	}

	if v.IncludeTags {
		ok := object.Key("IncludeTags")
		ok.Boolean(v.IncludeTags)
	}

	if v.ResourceArns != nil {
		ok := object.Key("ResourceArns")
		if err := awsRestjson1_serializeDocumentAssetBundleResourceArns(v.ResourceArns, ok); err != nil {
			return err
		}
	}

	if v.ValidationStrategy != nil {
		ok := object.Key("ValidationStrategy")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobValidationStrategy(v.ValidationStrategy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartAssetBundleImportJob struct {
}

func (*awsRestjson1_serializeOpStartAssetBundleImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartAssetBundleImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartAssetBundleImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/asset-bundle-import-jobs/import")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartAssetBundleImportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartAssetBundleImportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartAssetBundleImportJobInput(v *StartAssetBundleImportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartAssetBundleImportJobInput(v *StartAssetBundleImportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssetBundleImportJobId != nil {
		ok := object.Key("AssetBundleImportJobId")
		ok.String(*v.AssetBundleImportJobId)
	}

	if v.AssetBundleImportSource != nil {
		ok := object.Key("AssetBundleImportSource")
		if err := awsRestjson1_serializeDocumentAssetBundleImportSource(v.AssetBundleImportSource, ok); err != nil {
			return err
		}
	}

	if len(v.FailureAction) > 0 {
		ok := object.Key("FailureAction")
		ok.String(string(v.FailureAction))
	}

	if v.OverrideParameters != nil {
		ok := object.Key("OverrideParameters")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobOverrideParameters(v.OverrideParameters, ok); err != nil {
			return err
		}
	}

	if v.OverridePermissions != nil {
		ok := object.Key("OverridePermissions")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobOverridePermissions(v.OverridePermissions, ok); err != nil {
			return err
		}
	}

	if v.OverrideTags != nil {
		ok := object.Key("OverrideTags")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobOverrideTags(v.OverrideTags, ok); err != nil {
			return err
		}
	}

	if v.OverrideValidationStrategy != nil {
		ok := object.Key("OverrideValidationStrategy")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobOverrideValidationStrategy(v.OverrideValidationStrategy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartDashboardSnapshotJob struct {
}

func (*awsRestjson1_serializeOpStartDashboardSnapshotJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartDashboardSnapshotJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartDashboardSnapshotJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/snapshot-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartDashboardSnapshotJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartDashboardSnapshotJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartDashboardSnapshotJobInput(v *StartDashboardSnapshotJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartDashboardSnapshotJobInput(v *StartDashboardSnapshotJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SnapshotConfiguration != nil {
		ok := object.Key("SnapshotConfiguration")
		if err := awsRestjson1_serializeDocumentSnapshotConfiguration(v.SnapshotConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SnapshotJobId != nil {
		ok := object.Key("SnapshotJobId")
		ok.String(*v.SnapshotJobId)
	}

	if v.UserConfiguration != nil {
		ok := object.Key("UserConfiguration")
		if err := awsRestjson1_serializeDocumentSnapshotUserConfiguration(v.UserConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/resources/{ResourceArn}/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/resources/{ResourceArn}/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("keys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAccountCustomization struct {
}

func (*awsRestjson1_serializeOpUpdateAccountCustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAccountCustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAccountCustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/customizations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAccountCustomizationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAccountCustomizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAccountCustomizationInput(v *UpdateAccountCustomizationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAccountCustomizationInput(v *UpdateAccountCustomizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountCustomization != nil {
		ok := object.Key("AccountCustomization")
		if err := awsRestjson1_serializeDocumentAccountCustomization(v.AccountCustomization, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAccountSettings struct {
}

func (*awsRestjson1_serializeOpUpdateAccountSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAccountSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAccountSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAccountSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAccountSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAccountSettingsInput(v *UpdateAccountSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAccountSettingsInput(v *UpdateAccountSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultNamespace != nil {
		ok := object.Key("DefaultNamespace")
		ok.String(*v.DefaultNamespace)
	}

	if v.NotificationEmail != nil {
		ok := object.Key("NotificationEmail")
		ok.String(*v.NotificationEmail)
	}

	if v.TerminationProtectionEnabled {
		ok := object.Key("TerminationProtectionEnabled")
		ok.Boolean(v.TerminationProtectionEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAnalysis struct {
}

func (*awsRestjson1_serializeOpUpdateAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAnalysisInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAnalysisInput(v *UpdateAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAnalysisInput(v *UpdateAnalysisInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsRestjson1_serializeDocumentAnalysisDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentAnalysisSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.ThemeArn != nil {
		ok := object.Key("ThemeArn")
		ok.String(*v.ThemeArn)
	}

	if v.ValidationStrategy != nil {
		ok := object.Key("ValidationStrategy")
		if err := awsRestjson1_serializeDocumentValidationStrategy(v.ValidationStrategy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAnalysisPermissions struct {
}

func (*awsRestjson1_serializeOpUpdateAnalysisPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAnalysisPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAnalysisPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAnalysisPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAnalysisPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAnalysisPermissionsInput(v *UpdateAnalysisPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAnalysisPermissionsInput(v *UpdateAnalysisPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDashboard struct {
}

func (*awsRestjson1_serializeOpUpdateDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDashboardInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDashboardInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDashboardInput(v *UpdateDashboardInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDashboardInput(v *UpdateDashboardInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashboardPublishOptions != nil {
		ok := object.Key("DashboardPublishOptions")
		if err := awsRestjson1_serializeDocumentDashboardPublishOptions(v.DashboardPublishOptions, ok); err != nil {
			return err
		}
	}

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsRestjson1_serializeDocumentDashboardVersionDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentDashboardSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.ThemeArn != nil {
		ok := object.Key("ThemeArn")
		ok.String(*v.ThemeArn)
	}

	if v.ValidationStrategy != nil {
		ok := object.Key("ValidationStrategy")
		if err := awsRestjson1_serializeDocumentValidationStrategy(v.ValidationStrategy, ok); err != nil {
			return err
		}
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDashboardLinks struct {
}

func (*awsRestjson1_serializeOpUpdateDashboardLinks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDashboardLinks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDashboardLinksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/linked-entities")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDashboardLinksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDashboardLinksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDashboardLinksInput(v *UpdateDashboardLinksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDashboardLinksInput(v *UpdateDashboardLinksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LinkEntities != nil {
		ok := object.Key("LinkEntities")
		if err := awsRestjson1_serializeDocumentLinkEntityArnList(v.LinkEntities, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDashboardPermissions struct {
}

func (*awsRestjson1_serializeOpUpdateDashboardPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDashboardPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDashboardPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDashboardPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDashboardPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDashboardPermissionsInput(v *UpdateDashboardPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDashboardPermissionsInput(v *UpdateDashboardPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantLinkPermissions != nil {
		ok := object.Key("GrantLinkPermissions")
		if err := awsRestjson1_serializeDocumentUpdateLinkPermissionList(v.GrantLinkPermissions, ok); err != nil {
			return err
		}
	}

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokeLinkPermissions != nil {
		ok := object.Key("RevokeLinkPermissions")
		if err := awsRestjson1_serializeDocumentUpdateLinkPermissionList(v.RevokeLinkPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDashboardPublishedVersion struct {
}

func (*awsRestjson1_serializeOpUpdateDashboardPublishedVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDashboardPublishedVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDashboardPublishedVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions/{VersionNumber}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDashboardPublishedVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDashboardPublishedVersionInput(v *UpdateDashboardPublishedVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.VersionNumber == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VersionNumber must not be empty")}
	}
	if v.VersionNumber != nil {
		if err := encoder.SetURI("VersionNumber").Long(*v.VersionNumber); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSet struct {
}

func (*awsRestjson1_serializeOpUpdateDataSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSetInput(v *UpdateDataSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSetInput(v *UpdateDataSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnGroups != nil {
		ok := object.Key("ColumnGroups")
		if err := awsRestjson1_serializeDocumentColumnGroupList(v.ColumnGroups, ok); err != nil {
			return err
		}
	}

	if v.ColumnLevelPermissionRules != nil {
		ok := object.Key("ColumnLevelPermissionRules")
		if err := awsRestjson1_serializeDocumentColumnLevelPermissionRuleList(v.ColumnLevelPermissionRules, ok); err != nil {
			return err
		}
	}

	if v.DatasetParameters != nil {
		ok := object.Key("DatasetParameters")
		if err := awsRestjson1_serializeDocumentDatasetParameterList(v.DatasetParameters, ok); err != nil {
			return err
		}
	}

	if v.DataSetUsageConfiguration != nil {
		ok := object.Key("DataSetUsageConfiguration")
		if err := awsRestjson1_serializeDocumentDataSetUsageConfiguration(v.DataSetUsageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FieldFolders != nil {
		ok := object.Key("FieldFolders")
		if err := awsRestjson1_serializeDocumentFieldFolderMap(v.FieldFolders, ok); err != nil {
			return err
		}
	}

	if len(v.ImportMode) > 0 {
		ok := object.Key("ImportMode")
		ok.String(string(v.ImportMode))
	}

	if v.LogicalTableMap != nil {
		ok := object.Key("LogicalTableMap")
		if err := awsRestjson1_serializeDocumentLogicalTableMap(v.LogicalTableMap, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PhysicalTableMap != nil {
		ok := object.Key("PhysicalTableMap")
		if err := awsRestjson1_serializeDocumentPhysicalTableMap(v.PhysicalTableMap, ok); err != nil {
			return err
		}
	}

	if v.RowLevelPermissionDataSet != nil {
		ok := object.Key("RowLevelPermissionDataSet")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionDataSet(v.RowLevelPermissionDataSet, ok); err != nil {
			return err
		}
	}

	if v.RowLevelPermissionTagConfiguration != nil {
		ok := object.Key("RowLevelPermissionTagConfiguration")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagConfiguration(v.RowLevelPermissionTagConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSetPermissions struct {
}

func (*awsRestjson1_serializeOpUpdateDataSetPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSetPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSetPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSetPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSetPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSetPermissionsInput(v *UpdateDataSetPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSetPermissionsInput(v *UpdateDataSetPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSource struct {
}

func (*awsRestjson1_serializeOpUpdateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(v *UpdateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSourceInput(v *UpdateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentDataSourceCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.DataSourceParameters != nil {
		ok := object.Key("DataSourceParameters")
		if err := awsRestjson1_serializeDocumentDataSourceParameters(v.DataSourceParameters, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SslProperties != nil {
		ok := object.Key("SslProperties")
		if err := awsRestjson1_serializeDocumentSslProperties(v.SslProperties, ok); err != nil {
			return err
		}
	}

	if v.VpcConnectionProperties != nil {
		ok := object.Key("VpcConnectionProperties")
		if err := awsRestjson1_serializeDocumentVpcConnectionProperties(v.VpcConnectionProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSourcePermissions struct {
}

func (*awsRestjson1_serializeOpUpdateDataSourcePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSourcePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSourcePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSourcePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSourcePermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSourcePermissionsInput(v *UpdateDataSourcePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSourcePermissionsInput(v *UpdateDataSourcePermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFolder struct {
}

func (*awsRestjson1_serializeOpUpdateFolder) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFolder) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFolderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFolderInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFolderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFolderInput(v *UpdateFolderInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFolderInput(v *UpdateFolderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFolderPermissions struct {
}

func (*awsRestjson1_serializeOpUpdateFolderPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFolderPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFolderPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFolderPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFolderPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFolderPermissionsInput(v *UpdateFolderPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFolderPermissionsInput(v *UpdateFolderPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGroup struct {
}

func (*awsRestjson1_serializeOpUpdateGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGroupInput(v *UpdateGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGroupInput(v *UpdateGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIAMPolicyAssignment struct {
}

func (*awsRestjson1_serializeOpUpdateIAMPolicyAssignment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIAMPolicyAssignment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIAMPolicyAssignmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIAMPolicyAssignmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIAMPolicyAssignmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIAMPolicyAssignmentInput(v *UpdateIAMPolicyAssignmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssignmentName == nil || len(*v.AssignmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssignmentName must not be empty")}
	}
	if v.AssignmentName != nil {
		if err := encoder.SetURI("AssignmentName").String(*v.AssignmentName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIAMPolicyAssignmentInput(v *UpdateIAMPolicyAssignmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AssignmentStatus) > 0 {
		ok := object.Key("AssignmentStatus")
		ok.String(string(v.AssignmentStatus))
	}

	if v.Identities != nil {
		ok := object.Key("Identities")
		if err := awsRestjson1_serializeDocumentIdentityMap(v.Identities, ok); err != nil {
			return err
		}
	}

	if v.PolicyArn != nil {
		ok := object.Key("PolicyArn")
		ok.String(*v.PolicyArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIdentityPropagationConfig struct {
}

func (*awsRestjson1_serializeOpUpdateIdentityPropagationConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIdentityPropagationConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIdentityPropagationConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/identity-propagation-config/{Service}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIdentityPropagationConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIdentityPropagationConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIdentityPropagationConfigInput(v *UpdateIdentityPropagationConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if len(v.Service) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Service must not be empty")}
	}
	if len(v.Service) > 0 {
		if err := encoder.SetURI("Service").String(string(v.Service)); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIdentityPropagationConfigInput(v *UpdateIdentityPropagationConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizedTargets != nil {
		ok := object.Key("AuthorizedTargets")
		if err := awsRestjson1_serializeDocumentAuthorizedTargetsList(v.AuthorizedTargets, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIpRestriction struct {
}

func (*awsRestjson1_serializeOpUpdateIpRestriction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIpRestriction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIpRestrictionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/ip-restriction")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIpRestrictionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIpRestrictionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIpRestrictionInput(v *UpdateIpRestrictionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIpRestrictionInput(v *UpdateIpRestrictionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.IpRestrictionRuleMap != nil {
		ok := object.Key("IpRestrictionRuleMap")
		if err := awsRestjson1_serializeDocumentIpRestrictionRuleMap(v.IpRestrictionRuleMap, ok); err != nil {
			return err
		}
	}

	if v.VpcEndpointIdRestrictionRuleMap != nil {
		ok := object.Key("VpcEndpointIdRestrictionRuleMap")
		if err := awsRestjson1_serializeDocumentVpcEndpointIdRestrictionRuleMap(v.VpcEndpointIdRestrictionRuleMap, ok); err != nil {
			return err
		}
	}

	if v.VpcIdRestrictionRuleMap != nil {
		ok := object.Key("VpcIdRestrictionRuleMap")
		if err := awsRestjson1_serializeDocumentVpcIdRestrictionRuleMap(v.VpcIdRestrictionRuleMap, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateKeyRegistration struct {
}

func (*awsRestjson1_serializeOpUpdateKeyRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateKeyRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateKeyRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/key-registration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateKeyRegistrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateKeyRegistrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateKeyRegistrationInput(v *UpdateKeyRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateKeyRegistrationInput(v *UpdateKeyRegistrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyRegistration != nil {
		ok := object.Key("KeyRegistration")
		if err := awsRestjson1_serializeDocumentKeyRegistration(v.KeyRegistration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePublicSharingSettings struct {
}

func (*awsRestjson1_serializeOpUpdatePublicSharingSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePublicSharingSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePublicSharingSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/public-sharing-settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePublicSharingSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePublicSharingSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePublicSharingSettingsInput(v *UpdatePublicSharingSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePublicSharingSettingsInput(v *UpdatePublicSharingSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PublicSharingEnabled {
		ok := object.Key("PublicSharingEnabled")
		ok.Boolean(v.PublicSharingEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRefreshSchedule struct {
}

func (*awsRestjson1_serializeOpUpdateRefreshSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRefreshSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRefreshScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRefreshScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRefreshScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRefreshScheduleInput(v *UpdateRefreshScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRefreshScheduleInput(v *UpdateRefreshScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		if err := awsRestjson1_serializeDocumentRefreshSchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRoleCustomPermission struct {
}

func (*awsRestjson1_serializeOpUpdateRoleCustomPermission) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRoleCustomPermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRoleCustomPermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/roles/{Role}/custom-permission")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRoleCustomPermissionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRoleCustomPermissionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRoleCustomPermissionInput(v *UpdateRoleCustomPermissionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if len(v.Role) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Role must not be empty")}
	}
	if len(v.Role) > 0 {
		if err := encoder.SetURI("Role").String(string(v.Role)); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRoleCustomPermissionInput(v *UpdateRoleCustomPermissionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomPermissionsName != nil {
		ok := object.Key("CustomPermissionsName")
		ok.String(*v.CustomPermissionsName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSPICECapacityConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateSPICECapacityConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSPICECapacityConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSPICECapacityConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/spice-capacity-configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSPICECapacityConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSPICECapacityConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSPICECapacityConfigurationInput(v *UpdateSPICECapacityConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSPICECapacityConfigurationInput(v *UpdateSPICECapacityConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PurchaseMode) > 0 {
		ok := object.Key("PurchaseMode")
		ok.String(string(v.PurchaseMode))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTemplate struct {
}

func (*awsRestjson1_serializeOpUpdateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTemplateInput(v *UpdateTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTemplateInput(v *UpdateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsRestjson1_serializeDocumentTemplateVersionDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentTemplateSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.ValidationStrategy != nil {
		ok := object.Key("ValidationStrategy")
		if err := awsRestjson1_serializeDocumentValidationStrategy(v.ValidationStrategy, ok); err != nil {
			return err
		}
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTemplateAlias struct {
}

func (*awsRestjson1_serializeOpUpdateTemplateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTemplateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTemplateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTemplateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTemplateAliasInput(v *UpdateTemplateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTemplateAliasInput(v *UpdateTemplateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TemplateVersionNumber != nil {
		ok := object.Key("TemplateVersionNumber")
		ok.Long(*v.TemplateVersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTemplatePermissions struct {
}

func (*awsRestjson1_serializeOpUpdateTemplatePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTemplatePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplatePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTemplatePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTemplatePermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTemplatePermissionsInput(v *UpdateTemplatePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTemplatePermissionsInput(v *UpdateTemplatePermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTheme struct {
}

func (*awsRestjson1_serializeOpUpdateTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateThemeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThemeInput(v *UpdateThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateThemeInput(v *UpdateThemeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseThemeId != nil {
		ok := object.Key("BaseThemeId")
		ok.String(*v.BaseThemeId)
	}

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsRestjson1_serializeDocumentThemeConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateThemeAlias struct {
}

func (*awsRestjson1_serializeOpUpdateThemeAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateThemeAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThemeAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThemeAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateThemeAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThemeAliasInput(v *UpdateThemeAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateThemeAliasInput(v *UpdateThemeAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThemeVersionNumber != nil {
		ok := object.Key("ThemeVersionNumber")
		ok.Long(*v.ThemeVersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateThemePermissions struct {
}

func (*awsRestjson1_serializeOpUpdateThemePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateThemePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThemePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThemePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateThemePermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThemePermissionsInput(v *UpdateThemePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateThemePermissionsInput(v *UpdateThemePermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTopic struct {
}

func (*awsRestjson1_serializeOpUpdateTopic) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTopic) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTopicInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTopicInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTopicInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTopicInput(v *UpdateTopicInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTopicInput(v *UpdateTopicInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Topic != nil {
		ok := object.Key("Topic")
		if err := awsRestjson1_serializeDocumentTopicDetails(v.Topic, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTopicPermissions struct {
}

func (*awsRestjson1_serializeOpUpdateTopicPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTopicPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTopicPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTopicPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTopicPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTopicPermissionsInput(v *UpdateTopicPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTopicPermissionsInput(v *UpdateTopicPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTopicRefreshSchedule struct {
}

func (*awsRestjson1_serializeOpUpdateTopicRefreshSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTopicRefreshSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTopicRefreshScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/topics/{TopicId}/schedules/{DatasetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTopicRefreshScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTopicRefreshScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTopicRefreshScheduleInput(v *UpdateTopicRefreshScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DatasetId == nil || len(*v.DatasetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DatasetId must not be empty")}
	}
	if v.DatasetId != nil {
		if err := encoder.SetURI("DatasetId").String(*v.DatasetId); err != nil {
			return err
		}
	}

	if v.TopicId == nil || len(*v.TopicId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TopicId must not be empty")}
	}
	if v.TopicId != nil {
		if err := encoder.SetURI("TopicId").String(*v.TopicId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTopicRefreshScheduleInput(v *UpdateTopicRefreshScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RefreshSchedule != nil {
		ok := object.Key("RefreshSchedule")
		if err := awsRestjson1_serializeDocumentTopicRefreshSchedule(v.RefreshSchedule, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUser struct {
}

func (*awsRestjson1_serializeOpUpdateUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserInput(v *UpdateUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserInput(v *UpdateUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomFederationProviderUrl != nil {
		ok := object.Key("CustomFederationProviderUrl")
		ok.String(*v.CustomFederationProviderUrl)
	}

	if v.CustomPermissionsName != nil {
		ok := object.Key("CustomPermissionsName")
		ok.String(*v.CustomPermissionsName)
	}

	if v.Email != nil {
		ok := object.Key("Email")
		ok.String(*v.Email)
	}

	if v.ExternalLoginFederationProviderType != nil {
		ok := object.Key("ExternalLoginFederationProviderType")
		ok.String(*v.ExternalLoginFederationProviderType)
	}

	if v.ExternalLoginId != nil {
		ok := object.Key("ExternalLoginId")
		ok.String(*v.ExternalLoginId)
	}

	if len(v.Role) > 0 {
		ok := object.Key("Role")
		ok.String(string(v.Role))
	}

	if v.UnapplyCustomPermissions {
		ok := object.Key("UnapplyCustomPermissions")
		ok.Boolean(v.UnapplyCustomPermissions)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateVPCConnection struct {
}

func (*awsRestjson1_serializeOpUpdateVPCConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateVPCConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVPCConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/vpc-connections/{VPCConnectionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateVPCConnectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateVPCConnectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateVPCConnectionInput(v *UpdateVPCConnectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.VPCConnectionId == nil || len(*v.VPCConnectionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VPCConnectionId must not be empty")}
	}
	if v.VPCConnectionId != nil {
		if err := encoder.SetURI("VPCConnectionId").String(*v.VPCConnectionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateVPCConnectionInput(v *UpdateVPCConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DnsResolvers != nil {
		ok := object.Key("DnsResolvers")
		if err := awsRestjson1_serializeDocumentDnsResolverList(v.DnsResolvers, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIdList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIdList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAccountCustomization(v *types.AccountCustomization, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultEmailCustomizationTemplate != nil {
		ok := object.Key("DefaultEmailCustomizationTemplate")
		ok.String(*v.DefaultEmailCustomizationTemplate)
	}

	if v.DefaultTheme != nil {
		ok := object.Key("DefaultTheme")
		ok.String(*v.DefaultTheme)
	}

	return nil
}

func awsRestjson1_serializeDocumentActionList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAdHocFilteringOption(v *types.AdHocFilteringOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentAggregationFunction(v *types.AggregationFunction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeAggregationFunction != nil {
		ok := object.Key("AttributeAggregationFunction")
		if err := awsRestjson1_serializeDocumentAttributeAggregationFunction(v.AttributeAggregationFunction, ok); err != nil {
			return err
		}
	}

	if len(v.CategoricalAggregationFunction) > 0 {
		ok := object.Key("CategoricalAggregationFunction")
		ok.String(string(v.CategoricalAggregationFunction))
	}

	if len(v.DateAggregationFunction) > 0 {
		ok := object.Key("DateAggregationFunction")
		ok.String(string(v.DateAggregationFunction))
	}

	if v.NumericalAggregationFunction != nil {
		ok := object.Key("NumericalAggregationFunction")
		if err := awsRestjson1_serializeDocumentNumericalAggregationFunction(v.NumericalAggregationFunction, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAggregationFunctionParameters(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAggregationSortConfiguration(v *types.AggregationSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationFunction != nil {
		ok := object.Key("AggregationFunction")
		if err := awsRestjson1_serializeDocumentAggregationFunction(v.AggregationFunction, ok); err != nil {
			return err
		}
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if len(v.SortDirection) > 0 {
		ok := object.Key("SortDirection")
		ok.String(string(v.SortDirection))
	}

	return nil
}

func awsRestjson1_serializeDocumentAggregationSortConfigurationList(v []types.AggregationSortConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAggregationSortConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAllSheetsFilterScopeConfiguration(v *types.AllSheetsFilterScopeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentAmazonElasticsearchParameters(v *types.AmazonElasticsearchParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	return nil
}

func awsRestjson1_serializeDocumentAmazonOpenSearchParameters(v *types.AmazonOpenSearchParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalysisDefaults(v *types.AnalysisDefaults, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultNewSheetConfiguration != nil {
		ok := object.Key("DefaultNewSheetConfiguration")
		if err := awsRestjson1_serializeDocumentDefaultNewSheetConfiguration(v.DefaultNewSheetConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalysisDefinition(v *types.AnalysisDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalysisDefaults != nil {
		ok := object.Key("AnalysisDefaults")
		if err := awsRestjson1_serializeDocumentAnalysisDefaults(v.AnalysisDefaults, ok); err != nil {
			return err
		}
	}

	if v.CalculatedFields != nil {
		ok := object.Key("CalculatedFields")
		if err := awsRestjson1_serializeDocumentCalculatedFields(v.CalculatedFields, ok); err != nil {
			return err
		}
	}

	if v.ColumnConfigurations != nil {
		ok := object.Key("ColumnConfigurations")
		if err := awsRestjson1_serializeDocumentColumnConfigurationList(v.ColumnConfigurations, ok); err != nil {
			return err
		}
	}

	if v.DataSetIdentifierDeclarations != nil {
		ok := object.Key("DataSetIdentifierDeclarations")
		if err := awsRestjson1_serializeDocumentDataSetIdentifierDeclarationList(v.DataSetIdentifierDeclarations, ok); err != nil {
			return err
		}
	}

	if v.FilterGroups != nil {
		ok := object.Key("FilterGroups")
		if err := awsRestjson1_serializeDocumentFilterGroupList(v.FilterGroups, ok); err != nil {
			return err
		}
	}

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsRestjson1_serializeDocumentAssetOptions(v.Options, ok); err != nil {
			return err
		}
	}

	if v.ParameterDeclarations != nil {
		ok := object.Key("ParameterDeclarations")
		if err := awsRestjson1_serializeDocumentParameterDeclarationList(v.ParameterDeclarations, ok); err != nil {
			return err
		}
	}

	if v.Sheets != nil {
		ok := object.Key("Sheets")
		if err := awsRestjson1_serializeDocumentSheetDefinitionList(v.Sheets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalysisSearchFilter(v *types.AnalysisSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalysisSearchFilterList(v []types.AnalysisSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalysisSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalysisSourceEntity(v *types.AnalysisSourceEntity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceTemplate != nil {
		ok := object.Key("SourceTemplate")
		if err := awsRestjson1_serializeDocumentAnalysisSourceTemplate(v.SourceTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalysisSourceTemplate(v *types.AnalysisSourceTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.DataSetReferences != nil {
		ok := object.Key("DataSetReferences")
		if err := awsRestjson1_serializeDocumentDataSetReferenceList(v.DataSetReferences, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnchorDateConfiguration(v *types.AnchorDateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AnchorOption) > 0 {
		ok := object.Key("AnchorOption")
		ok.String(string(v.AnchorOption))
	}

	if v.ParameterName != nil {
		ok := object.Key("ParameterName")
		ok.String(*v.ParameterName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnonymousUserDashboardEmbeddingConfiguration(v *types.AnonymousUserDashboardEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialDashboardId != nil {
		ok := object.Key("InitialDashboardId")
		ok.String(*v.InitialDashboardId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnonymousUserDashboardVisualEmbeddingConfiguration(v *types.AnonymousUserDashboardVisualEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialDashboardVisualId != nil {
		ok := object.Key("InitialDashboardVisualId")
		if err := awsRestjson1_serializeDocumentDashboardVisualId(v.InitialDashboardVisualId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnonymousUserEmbeddingExperienceConfiguration(v *types.AnonymousUserEmbeddingExperienceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dashboard != nil {
		ok := object.Key("Dashboard")
		if err := awsRestjson1_serializeDocumentAnonymousUserDashboardEmbeddingConfiguration(v.Dashboard, ok); err != nil {
			return err
		}
	}

	if v.DashboardVisual != nil {
		ok := object.Key("DashboardVisual")
		if err := awsRestjson1_serializeDocumentAnonymousUserDashboardVisualEmbeddingConfiguration(v.DashboardVisual, ok); err != nil {
			return err
		}
	}

	if v.GenerativeQnA != nil {
		ok := object.Key("GenerativeQnA")
		if err := awsRestjson1_serializeDocumentAnonymousUserGenerativeQnAEmbeddingConfiguration(v.GenerativeQnA, ok); err != nil {
			return err
		}
	}

	if v.QSearchBar != nil {
		ok := object.Key("QSearchBar")
		if err := awsRestjson1_serializeDocumentAnonymousUserQSearchBarEmbeddingConfiguration(v.QSearchBar, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnonymousUserGenerativeQnAEmbeddingConfiguration(v *types.AnonymousUserGenerativeQnAEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialTopicId != nil {
		ok := object.Key("InitialTopicId")
		ok.String(*v.InitialTopicId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnonymousUserQSearchBarEmbeddingConfiguration(v *types.AnonymousUserQSearchBarEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialTopicId != nil {
		ok := object.Key("InitialTopicId")
		ok.String(*v.InitialTopicId)
	}

	return nil
}

func awsRestjson1_serializeDocumentArcAxisConfiguration(v *types.ArcAxisConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Range != nil {
		ok := object.Key("Range")
		if err := awsRestjson1_serializeDocumentArcAxisDisplayRange(v.Range, ok); err != nil {
			return err
		}
	}

	if v.ReserveRange != 0 {
		ok := object.Key("ReserveRange")
		ok.Integer(v.ReserveRange)
	}

	return nil
}

func awsRestjson1_serializeDocumentArcAxisDisplayRange(v *types.ArcAxisDisplayRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Max != nil {
		ok := object.Key("Max")
		switch {
		case math.IsNaN(*v.Max):
			ok.String("NaN")

		case math.IsInf(*v.Max, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Max, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Max)

		}
	}

	if v.Min != nil {
		ok := object.Key("Min")
		switch {
		case math.IsNaN(*v.Min):
			ok.String("NaN")

		case math.IsInf(*v.Min, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Min, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Min)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentArcConfiguration(v *types.ArcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArcAngle != nil {
		ok := object.Key("ArcAngle")
		switch {
		case math.IsNaN(*v.ArcAngle):
			ok.String("NaN")

		case math.IsInf(*v.ArcAngle, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ArcAngle, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ArcAngle)

		}
	}

	if len(v.ArcThickness) > 0 {
		ok := object.Key("ArcThickness")
		ok.String(string(v.ArcThickness))
	}

	return nil
}

func awsRestjson1_serializeDocumentArcOptions(v *types.ArcOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ArcThickness) > 0 {
		ok := object.Key("ArcThickness")
		ok.String(string(v.ArcThickness))
	}

	return nil
}

func awsRestjson1_serializeDocumentArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleCloudFormationOverridePropertyConfiguration(v *types.AssetBundleCloudFormationOverridePropertyConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Analyses != nil {
		ok := object.Key("Analyses")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobAnalysisOverridePropertiesList(v.Analyses, ok); err != nil {
			return err
		}
	}

	if v.Dashboards != nil {
		ok := object.Key("Dashboards")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobDashboardOverridePropertiesList(v.Dashboards, ok); err != nil {
			return err
		}
	}

	if v.DataSets != nil {
		ok := object.Key("DataSets")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobDataSetOverridePropertiesList(v.DataSets, ok); err != nil {
			return err
		}
	}

	if v.DataSources != nil {
		ok := object.Key("DataSources")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobDataSourceOverridePropertiesList(v.DataSources, ok); err != nil {
			return err
		}
	}

	if v.RefreshSchedules != nil {
		ok := object.Key("RefreshSchedules")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobRefreshScheduleOverridePropertiesList(v.RefreshSchedules, ok); err != nil {
			return err
		}
	}

	if v.ResourceIdOverrideConfiguration != nil {
		ok := object.Key("ResourceIdOverrideConfiguration")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobResourceIdOverrideConfiguration(v.ResourceIdOverrideConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Themes != nil {
		ok := object.Key("Themes")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobThemeOverridePropertiesList(v.Themes, ok); err != nil {
			return err
		}
	}

	if v.VPCConnections != nil {
		ok := object.Key("VPCConnections")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobVPCConnectionOverridePropertiesList(v.VPCConnections, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobAnalysisOverrideProperties(v *types.AssetBundleExportJobAnalysisOverrideProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobAnalysisPropertyToOverrideList(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobAnalysisOverridePropertiesList(v []types.AssetBundleExportJobAnalysisOverrideProperties, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobAnalysisOverrideProperties(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobAnalysisPropertyToOverrideList(v []types.AssetBundleExportJobAnalysisPropertyToOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobDashboardOverrideProperties(v *types.AssetBundleExportJobDashboardOverrideProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobDashboardPropertyToOverrideList(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobDashboardOverridePropertiesList(v []types.AssetBundleExportJobDashboardOverrideProperties, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobDashboardOverrideProperties(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobDashboardPropertyToOverrideList(v []types.AssetBundleExportJobDashboardPropertyToOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobDataSetOverrideProperties(v *types.AssetBundleExportJobDataSetOverrideProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobDataSetPropertyToOverrideList(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobDataSetOverridePropertiesList(v []types.AssetBundleExportJobDataSetOverrideProperties, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobDataSetOverrideProperties(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobDataSetPropertyToOverrideList(v []types.AssetBundleExportJobDataSetPropertyToOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobDataSourceOverrideProperties(v *types.AssetBundleExportJobDataSourceOverrideProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobDataSourcePropertyToOverrideList(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobDataSourceOverridePropertiesList(v []types.AssetBundleExportJobDataSourceOverrideProperties, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobDataSourceOverrideProperties(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobDataSourcePropertyToOverrideList(v []types.AssetBundleExportJobDataSourcePropertyToOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobRefreshScheduleOverrideProperties(v *types.AssetBundleExportJobRefreshScheduleOverrideProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobRefreshSchedulePropertyToOverrideList(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobRefreshScheduleOverridePropertiesList(v []types.AssetBundleExportJobRefreshScheduleOverrideProperties, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobRefreshScheduleOverrideProperties(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobRefreshSchedulePropertyToOverrideList(v []types.AssetBundleExportJobRefreshSchedulePropertyToOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobResourceIdOverrideConfiguration(v *types.AssetBundleExportJobResourceIdOverrideConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PrefixForAllResources {
		ok := object.Key("PrefixForAllResources")
		ok.Boolean(v.PrefixForAllResources)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobThemeOverrideProperties(v *types.AssetBundleExportJobThemeOverrideProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobThemePropertyToOverrideList(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobThemeOverridePropertiesList(v []types.AssetBundleExportJobThemeOverrideProperties, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobThemeOverrideProperties(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobThemePropertyToOverrideList(v []types.AssetBundleExportJobThemePropertyToOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobValidationStrategy(v *types.AssetBundleExportJobValidationStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StrictModeForAllResources {
		ok := object.Key("StrictModeForAllResources")
		ok.Boolean(v.StrictModeForAllResources)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobVPCConnectionOverrideProperties(v *types.AssetBundleExportJobVPCConnectionOverrideProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobVPCConnectionPropertyToOverrideList(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobVPCConnectionOverridePropertiesList(v []types.AssetBundleExportJobVPCConnectionOverrideProperties, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleExportJobVPCConnectionOverrideProperties(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleExportJobVPCConnectionPropertyToOverrideList(v []types.AssetBundleExportJobVPCConnectionPropertyToOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverrideParameters(v *types.AssetBundleImportJobAnalysisOverrideParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalysisId != nil {
		ok := object.Key("AnalysisId")
		ok.String(*v.AnalysisId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverrideParametersList(v []types.AssetBundleImportJobAnalysisOverrideParameters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverrideParameters(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverridePermissions(v *types.AssetBundleImportJobAnalysisOverridePermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalysisIds != nil {
		ok := object.Key("AnalysisIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.AnalysisIds, ok); err != nil {
			return err
		}
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentAssetBundleResourcePermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverridePermissionsList(v []types.AssetBundleImportJobAnalysisOverridePermissions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverridePermissions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverrideTags(v *types.AssetBundleImportJobAnalysisOverrideTags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalysisIds != nil {
		ok := object.Key("AnalysisIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.AnalysisIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverrideTagsList(v []types.AssetBundleImportJobAnalysisOverrideTags, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverrideTags(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverrideParameters(v *types.AssetBundleImportJobDashboardOverrideParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashboardId != nil {
		ok := object.Key("DashboardId")
		ok.String(*v.DashboardId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverrideParametersList(v []types.AssetBundleImportJobDashboardOverrideParameters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverrideParameters(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverridePermissions(v *types.AssetBundleImportJobDashboardOverridePermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashboardIds != nil {
		ok := object.Key("DashboardIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.DashboardIds, ok); err != nil {
			return err
		}
	}

	if v.LinkSharingConfiguration != nil {
		ok := object.Key("LinkSharingConfiguration")
		if err := awsRestjson1_serializeDocumentAssetBundleResourceLinkSharingConfiguration(v.LinkSharingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentAssetBundleResourcePermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverridePermissionsList(v []types.AssetBundleImportJobDashboardOverridePermissions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverridePermissions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverrideTags(v *types.AssetBundleImportJobDashboardOverrideTags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashboardIds != nil {
		ok := object.Key("DashboardIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.DashboardIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverrideTagsList(v []types.AssetBundleImportJobDashboardOverrideTags, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverrideTags(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverrideParameters(v *types.AssetBundleImportJobDataSetOverrideParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetId != nil {
		ok := object.Key("DataSetId")
		ok.String(*v.DataSetId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverrideParametersList(v []types.AssetBundleImportJobDataSetOverrideParameters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverrideParameters(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverridePermissions(v *types.AssetBundleImportJobDataSetOverridePermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetIds != nil {
		ok := object.Key("DataSetIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.DataSetIds, ok); err != nil {
			return err
		}
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentAssetBundleResourcePermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverridePermissionsList(v []types.AssetBundleImportJobDataSetOverridePermissions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverridePermissions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverrideTags(v *types.AssetBundleImportJobDataSetOverrideTags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetIds != nil {
		ok := object.Key("DataSetIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.DataSetIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverrideTagsList(v []types.AssetBundleImportJobDataSetOverrideTags, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverrideTags(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceCredentialPair(v *types.AssetBundleImportJobDataSourceCredentialPair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceCredentials(v *types.AssetBundleImportJobDataSourceCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CredentialPair != nil {
		ok := object.Key("CredentialPair")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceCredentialPair(v.CredentialPair, ok); err != nil {
			return err
		}
	}

	if v.SecretArn != nil {
		ok := object.Key("SecretArn")
		ok.String(*v.SecretArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverrideParameters(v *types.AssetBundleImportJobDataSourceOverrideParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		ok := object.Key("DataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.DataSourceParameters != nil {
		ok := object.Key("DataSourceParameters")
		if err := awsRestjson1_serializeDocumentDataSourceParameters(v.DataSourceParameters, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SslProperties != nil {
		ok := object.Key("SslProperties")
		if err := awsRestjson1_serializeDocumentSslProperties(v.SslProperties, ok); err != nil {
			return err
		}
	}

	if v.VpcConnectionProperties != nil {
		ok := object.Key("VpcConnectionProperties")
		if err := awsRestjson1_serializeDocumentVpcConnectionProperties(v.VpcConnectionProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverrideParametersList(v []types.AssetBundleImportJobDataSourceOverrideParameters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverrideParameters(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverridePermissions(v *types.AssetBundleImportJobDataSourceOverridePermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceIds != nil {
		ok := object.Key("DataSourceIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.DataSourceIds, ok); err != nil {
			return err
		}
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentAssetBundleResourcePermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverridePermissionsList(v []types.AssetBundleImportJobDataSourceOverridePermissions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverridePermissions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverrideTags(v *types.AssetBundleImportJobDataSourceOverrideTags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceIds != nil {
		ok := object.Key("DataSourceIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.DataSourceIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverrideTagsList(v []types.AssetBundleImportJobDataSourceOverrideTags, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverrideTags(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobOverrideParameters(v *types.AssetBundleImportJobOverrideParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Analyses != nil {
		ok := object.Key("Analyses")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverrideParametersList(v.Analyses, ok); err != nil {
			return err
		}
	}

	if v.Dashboards != nil {
		ok := object.Key("Dashboards")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverrideParametersList(v.Dashboards, ok); err != nil {
			return err
		}
	}

	if v.DataSets != nil {
		ok := object.Key("DataSets")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverrideParametersList(v.DataSets, ok); err != nil {
			return err
		}
	}

	if v.DataSources != nil {
		ok := object.Key("DataSources")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverrideParametersList(v.DataSources, ok); err != nil {
			return err
		}
	}

	if v.RefreshSchedules != nil {
		ok := object.Key("RefreshSchedules")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobRefreshScheduleOverrideParametersList(v.RefreshSchedules, ok); err != nil {
			return err
		}
	}

	if v.ResourceIdOverrideConfiguration != nil {
		ok := object.Key("ResourceIdOverrideConfiguration")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobResourceIdOverrideConfiguration(v.ResourceIdOverrideConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Themes != nil {
		ok := object.Key("Themes")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverrideParametersList(v.Themes, ok); err != nil {
			return err
		}
	}

	if v.VPCConnections != nil {
		ok := object.Key("VPCConnections")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobVPCConnectionOverrideParametersList(v.VPCConnections, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobOverridePermissions(v *types.AssetBundleImportJobOverridePermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Analyses != nil {
		ok := object.Key("Analyses")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverridePermissionsList(v.Analyses, ok); err != nil {
			return err
		}
	}

	if v.Dashboards != nil {
		ok := object.Key("Dashboards")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverridePermissionsList(v.Dashboards, ok); err != nil {
			return err
		}
	}

	if v.DataSets != nil {
		ok := object.Key("DataSets")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverridePermissionsList(v.DataSets, ok); err != nil {
			return err
		}
	}

	if v.DataSources != nil {
		ok := object.Key("DataSources")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverridePermissionsList(v.DataSources, ok); err != nil {
			return err
		}
	}

	if v.Themes != nil {
		ok := object.Key("Themes")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverridePermissionsList(v.Themes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobOverrideTags(v *types.AssetBundleImportJobOverrideTags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Analyses != nil {
		ok := object.Key("Analyses")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobAnalysisOverrideTagsList(v.Analyses, ok); err != nil {
			return err
		}
	}

	if v.Dashboards != nil {
		ok := object.Key("Dashboards")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDashboardOverrideTagsList(v.Dashboards, ok); err != nil {
			return err
		}
	}

	if v.DataSets != nil {
		ok := object.Key("DataSets")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSetOverrideTagsList(v.DataSets, ok); err != nil {
			return err
		}
	}

	if v.DataSources != nil {
		ok := object.Key("DataSources")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobDataSourceOverrideTagsList(v.DataSources, ok); err != nil {
			return err
		}
	}

	if v.Themes != nil {
		ok := object.Key("Themes")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverrideTagsList(v.Themes, ok); err != nil {
			return err
		}
	}

	if v.VPCConnections != nil {
		ok := object.Key("VPCConnections")
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobVPCConnectionOverrideTagsList(v.VPCConnections, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobOverrideValidationStrategy(v *types.AssetBundleImportJobOverrideValidationStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StrictModeForAllResources {
		ok := object.Key("StrictModeForAllResources")
		ok.Boolean(v.StrictModeForAllResources)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobRefreshScheduleOverrideParameters(v *types.AssetBundleImportJobRefreshScheduleOverrideParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetId != nil {
		ok := object.Key("DataSetId")
		ok.String(*v.DataSetId)
	}

	if v.ScheduleId != nil {
		ok := object.Key("ScheduleId")
		ok.String(*v.ScheduleId)
	}

	if v.StartAfterDateTime != nil {
		ok := object.Key("StartAfterDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartAfterDateTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobRefreshScheduleOverrideParametersList(v []types.AssetBundleImportJobRefreshScheduleOverrideParameters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobRefreshScheduleOverrideParameters(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobResourceIdOverrideConfiguration(v *types.AssetBundleImportJobResourceIdOverrideConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PrefixForAllResources != nil {
		ok := object.Key("PrefixForAllResources")
		ok.String(*v.PrefixForAllResources)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverrideParameters(v *types.AssetBundleImportJobThemeOverrideParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ThemeId != nil {
		ok := object.Key("ThemeId")
		ok.String(*v.ThemeId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverrideParametersList(v []types.AssetBundleImportJobThemeOverrideParameters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverrideParameters(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverridePermissions(v *types.AssetBundleImportJobThemeOverridePermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentAssetBundleResourcePermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.ThemeIds != nil {
		ok := object.Key("ThemeIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.ThemeIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverridePermissionsList(v []types.AssetBundleImportJobThemeOverridePermissions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverridePermissions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverrideTags(v *types.AssetBundleImportJobThemeOverrideTags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ThemeIds != nil {
		ok := object.Key("ThemeIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.ThemeIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverrideTagsList(v []types.AssetBundleImportJobThemeOverrideTags, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobThemeOverrideTags(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobVPCConnectionOverrideParameters(v *types.AssetBundleImportJobVPCConnectionOverrideParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DnsResolvers != nil {
		ok := object.Key("DnsResolvers")
		if err := awsRestjson1_serializeDocumentDnsResolverList(v.DnsResolvers, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIdList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIdList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.VPCConnectionId != nil {
		ok := object.Key("VPCConnectionId")
		ok.String(*v.VPCConnectionId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobVPCConnectionOverrideParametersList(v []types.AssetBundleImportJobVPCConnectionOverrideParameters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobVPCConnectionOverrideParameters(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobVPCConnectionOverrideTags(v *types.AssetBundleImportJobVPCConnectionOverrideTags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VPCConnectionIds != nil {
		ok := object.Key("VPCConnectionIds")
		if err := awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v.VPCConnectionIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportJobVPCConnectionOverrideTagsList(v []types.AssetBundleImportJobVPCConnectionOverrideTags, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetBundleImportJobVPCConnectionOverrideTags(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleImportSource(v *types.AssetBundleImportSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.Base64EncodeBytes(v.Body)
	}

	if v.S3Uri != nil {
		ok := object.Key("S3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundlePrincipalList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleResourceArns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetBundleResourceLinkSharingConfiguration(v *types.AssetBundleResourceLinkSharingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentAssetBundleResourcePermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleResourcePermissions(v *types.AssetBundleResourcePermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.Principals != nil {
		ok := object.Key("Principals")
		if err := awsRestjson1_serializeDocumentAssetBundlePrincipalList(v.Principals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetBundleRestrictiveResourceIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetOptions(v *types.AssetOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Timezone != nil {
		ok := object.Key("Timezone")
		ok.String(*v.Timezone)
	}

	if len(v.WeekStart) > 0 {
		ok := object.Key("WeekStart")
		ok.String(string(v.WeekStart))
	}

	return nil
}

func awsRestjson1_serializeDocumentAthenaParameters(v *types.AthenaParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.WorkGroup != nil {
		ok := object.Key("WorkGroup")
		ok.String(*v.WorkGroup)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeAggregationFunction(v *types.AttributeAggregationFunction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SimpleAttributeAggregation) > 0 {
		ok := object.Key("SimpleAttributeAggregation")
		ok.String(string(v.SimpleAttributeAggregation))
	}

	if v.ValueForMultipleValues != nil {
		ok := object.Key("ValueForMultipleValues")
		ok.String(*v.ValueForMultipleValues)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuroraParameters(v *types.AuroraParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != nil {
		ok := object.Key("Port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuroraPostgreSqlParameters(v *types.AuroraPostgreSqlParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != nil {
		ok := object.Key("Port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuthorizedTargetsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAuthorSpecifiedAggregations(v []types.AuthorSpecifiedAggregation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsIotAnalyticsParameters(v *types.AwsIotAnalyticsParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetName != nil {
		ok := object.Key("DataSetName")
		ok.String(*v.DataSetName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisDataOptions(v *types.AxisDataOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateAxisOptions != nil {
		ok := object.Key("DateAxisOptions")
		if err := awsRestjson1_serializeDocumentDateAxisOptions(v.DateAxisOptions, ok); err != nil {
			return err
		}
	}

	if v.NumericAxisOptions != nil {
		ok := object.Key("NumericAxisOptions")
		if err := awsRestjson1_serializeDocumentNumericAxisOptions(v.NumericAxisOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisDisplayDataDrivenRange(v *types.AxisDisplayDataDrivenRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentAxisDisplayMinMaxRange(v *types.AxisDisplayMinMaxRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Maximum != nil {
		ok := object.Key("Maximum")
		switch {
		case math.IsNaN(*v.Maximum):
			ok.String("NaN")

		case math.IsInf(*v.Maximum, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Maximum, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Maximum)

		}
	}

	if v.Minimum != nil {
		ok := object.Key("Minimum")
		switch {
		case math.IsNaN(*v.Minimum):
			ok.String("NaN")

		case math.IsInf(*v.Minimum, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Minimum, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Minimum)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisDisplayOptions(v *types.AxisDisplayOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AxisLineVisibility) > 0 {
		ok := object.Key("AxisLineVisibility")
		ok.String(string(v.AxisLineVisibility))
	}

	if v.AxisOffset != nil {
		ok := object.Key("AxisOffset")
		ok.String(*v.AxisOffset)
	}

	if v.DataOptions != nil {
		ok := object.Key("DataOptions")
		if err := awsRestjson1_serializeDocumentAxisDataOptions(v.DataOptions, ok); err != nil {
			return err
		}
	}

	if len(v.GridLineVisibility) > 0 {
		ok := object.Key("GridLineVisibility")
		ok.String(string(v.GridLineVisibility))
	}

	if v.ScrollbarOptions != nil {
		ok := object.Key("ScrollbarOptions")
		if err := awsRestjson1_serializeDocumentScrollBarOptions(v.ScrollbarOptions, ok); err != nil {
			return err
		}
	}

	if v.TickLabelOptions != nil {
		ok := object.Key("TickLabelOptions")
		if err := awsRestjson1_serializeDocumentAxisTickLabelOptions(v.TickLabelOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisDisplayRange(v *types.AxisDisplayRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataDriven != nil {
		ok := object.Key("DataDriven")
		if err := awsRestjson1_serializeDocumentAxisDisplayDataDrivenRange(v.DataDriven, ok); err != nil {
			return err
		}
	}

	if v.MinMax != nil {
		ok := object.Key("MinMax")
		if err := awsRestjson1_serializeDocumentAxisDisplayMinMaxRange(v.MinMax, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisLabelOptions(v *types.AxisLabelOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplyTo != nil {
		ok := object.Key("ApplyTo")
		if err := awsRestjson1_serializeDocumentAxisLabelReferenceOptions(v.ApplyTo, ok); err != nil {
			return err
		}
	}

	if v.CustomLabel != nil {
		ok := object.Key("CustomLabel")
		ok.String(*v.CustomLabel)
	}

	if v.FontConfiguration != nil {
		ok := object.Key("FontConfiguration")
		if err := awsRestjson1_serializeDocumentFontConfiguration(v.FontConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisLabelOptionsList(v []types.AxisLabelOptions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAxisLabelOptions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAxisLabelReferenceOptions(v *types.AxisLabelReferenceOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisLinearScale(v *types.AxisLinearScale, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StepCount != nil {
		ok := object.Key("StepCount")
		ok.Integer(*v.StepCount)
	}

	if v.StepSize != nil {
		ok := object.Key("StepSize")
		switch {
		case math.IsNaN(*v.StepSize):
			ok.String("NaN")

		case math.IsInf(*v.StepSize, 1):
			ok.String("Infinity")

		case math.IsInf(*v.StepSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.StepSize)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisLogarithmicScale(v *types.AxisLogarithmicScale, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Base != nil {
		ok := object.Key("Base")
		switch {
		case math.IsNaN(*v.Base):
			ok.String("NaN")

		case math.IsInf(*v.Base, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Base, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Base)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisScale(v *types.AxisScale, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Linear != nil {
		ok := object.Key("Linear")
		if err := awsRestjson1_serializeDocumentAxisLinearScale(v.Linear, ok); err != nil {
			return err
		}
	}

	if v.Logarithmic != nil {
		ok := object.Key("Logarithmic")
		if err := awsRestjson1_serializeDocumentAxisLogarithmicScale(v.Logarithmic, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAxisTickLabelOptions(v *types.AxisTickLabelOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LabelOptions != nil {
		ok := object.Key("LabelOptions")
		if err := awsRestjson1_serializeDocumentLabelOptions(v.LabelOptions, ok); err != nil {
			return err
		}
	}

	if v.RotationAngle != nil {
		ok := object.Key("RotationAngle")
		switch {
		case math.IsNaN(*v.RotationAngle):
			ok.String("NaN")

		case math.IsInf(*v.RotationAngle, 1):
			ok.String("Infinity")

		case math.IsInf(*v.RotationAngle, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.RotationAngle)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBarChartAggregatedFieldWells(v *types.BarChartAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("Category")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Category, ok); err != nil {
			return err
		}
	}

	if v.Colors != nil {
		ok := object.Key("Colors")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Colors, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiples != nil {
		ok := object.Key("SmallMultiples")
		if err := awsRestjson1_serializeDocumentSmallMultiplesDimensionFieldList(v.SmallMultiples, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBarChartConfiguration(v *types.BarChartConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BarsArrangement) > 0 {
		ok := object.Key("BarsArrangement")
		ok.String(string(v.BarsArrangement))
	}

	if v.CategoryAxis != nil {
		ok := object.Key("CategoryAxis")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.CategoryAxis, ok); err != nil {
			return err
		}
	}

	if v.CategoryLabelOptions != nil {
		ok := object.Key("CategoryLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.CategoryLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.ColorLabelOptions != nil {
		ok := object.Key("ColorLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.ColorLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.ContributionAnalysisDefaults != nil {
		ok := object.Key("ContributionAnalysisDefaults")
		if err := awsRestjson1_serializeDocumentContributionAnalysisDefaultList(v.ContributionAnalysisDefaults, ok); err != nil {
			return err
		}
	}

	if v.DataLabels != nil {
		ok := object.Key("DataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.DataLabels, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentBarChartFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if len(v.Orientation) > 0 {
		ok := object.Key("Orientation")
		ok.String(string(v.Orientation))
	}

	if v.ReferenceLines != nil {
		ok := object.Key("ReferenceLines")
		if err := awsRestjson1_serializeDocumentReferenceLineList(v.ReferenceLines, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiplesOptions != nil {
		ok := object.Key("SmallMultiplesOptions")
		if err := awsRestjson1_serializeDocumentSmallMultiplesOptions(v.SmallMultiplesOptions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentBarChartSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if v.ValueAxis != nil {
		ok := object.Key("ValueAxis")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.ValueAxis, ok); err != nil {
			return err
		}
	}

	if v.ValueLabelOptions != nil {
		ok := object.Key("ValueLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.ValueLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBarChartFieldWells(v *types.BarChartFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BarChartAggregatedFieldWells != nil {
		ok := object.Key("BarChartAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentBarChartAggregatedFieldWells(v.BarChartAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBarChartSortConfiguration(v *types.BarChartSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryItemsLimit != nil {
		ok := object.Key("CategoryItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.CategoryItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.CategorySort != nil {
		ok := object.Key("CategorySort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.CategorySort, ok); err != nil {
			return err
		}
	}

	if v.ColorItemsLimit != nil {
		ok := object.Key("ColorItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.ColorItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.ColorSort != nil {
		ok := object.Key("ColorSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.ColorSort, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiplesLimitConfiguration != nil {
		ok := object.Key("SmallMultiplesLimitConfiguration")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.SmallMultiplesLimitConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiplesSort != nil {
		ok := object.Key("SmallMultiplesSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.SmallMultiplesSort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBarChartVisual(v *types.BarChartVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentBarChartConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentBigQueryParameters(v *types.BigQueryParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetRegion != nil {
		ok := object.Key("DataSetRegion")
		ok.String(*v.DataSetRegion)
	}

	if v.ProjectId != nil {
		ok := object.Key("ProjectId")
		ok.String(*v.ProjectId)
	}

	return nil
}

func awsRestjson1_serializeDocumentBinCountOptions(v *types.BinCountOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("Value")
		ok.Integer(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentBinWidthOptions(v *types.BinWidthOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BinCountLimit != nil {
		ok := object.Key("BinCountLimit")
		ok.Long(*v.BinCountLimit)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		switch {
		case math.IsNaN(*v.Value):
			ok.String("NaN")

		case math.IsInf(*v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBodySectionConfiguration(v *types.BodySectionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		if err := awsRestjson1_serializeDocumentBodySectionContent(v.Content, ok); err != nil {
			return err
		}
	}

	if v.PageBreakConfiguration != nil {
		ok := object.Key("PageBreakConfiguration")
		if err := awsRestjson1_serializeDocumentSectionPageBreakConfiguration(v.PageBreakConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SectionId != nil {
		ok := object.Key("SectionId")
		ok.String(*v.SectionId)
	}

	if v.Style != nil {
		ok := object.Key("Style")
		if err := awsRestjson1_serializeDocumentSectionStyle(v.Style, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBodySectionConfigurationList(v []types.BodySectionConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBodySectionConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBodySectionContent(v *types.BodySectionContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Layout != nil {
		ok := object.Key("Layout")
		if err := awsRestjson1_serializeDocumentSectionLayoutConfiguration(v.Layout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBookmarksConfigurations(v *types.BookmarksConfigurations, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentBorderStyle(v *types.BorderStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Show != nil {
		ok := object.Key("Show")
		ok.Boolean(*v.Show)
	}

	return nil
}

func awsRestjson1_serializeDocumentBoxPlotAggregatedFieldWells(v *types.BoxPlotAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupBy != nil {
		ok := object.Key("GroupBy")
		if err := awsRestjson1_serializeDocumentBoxPlotDimensionFieldList(v.GroupBy, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentBoxPlotMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBoxPlotChartConfiguration(v *types.BoxPlotChartConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoxPlotOptions != nil {
		ok := object.Key("BoxPlotOptions")
		if err := awsRestjson1_serializeDocumentBoxPlotOptions(v.BoxPlotOptions, ok); err != nil {
			return err
		}
	}

	if v.CategoryAxis != nil {
		ok := object.Key("CategoryAxis")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.CategoryAxis, ok); err != nil {
			return err
		}
	}

	if v.CategoryLabelOptions != nil {
		ok := object.Key("CategoryLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.CategoryLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentBoxPlotFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if v.PrimaryYAxisDisplayOptions != nil {
		ok := object.Key("PrimaryYAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.PrimaryYAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.PrimaryYAxisLabelOptions != nil {
		ok := object.Key("PrimaryYAxisLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.PrimaryYAxisLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.ReferenceLines != nil {
		ok := object.Key("ReferenceLines")
		if err := awsRestjson1_serializeDocumentReferenceLineList(v.ReferenceLines, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentBoxPlotSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBoxPlotDimensionFieldList(v []types.DimensionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBoxPlotFieldWells(v *types.BoxPlotFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoxPlotAggregatedFieldWells != nil {
		ok := object.Key("BoxPlotAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentBoxPlotAggregatedFieldWells(v.BoxPlotAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBoxPlotMeasureFieldList(v []types.MeasureField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMeasureField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBoxPlotOptions(v *types.BoxPlotOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AllDataPointsVisibility) > 0 {
		ok := object.Key("AllDataPointsVisibility")
		ok.String(string(v.AllDataPointsVisibility))
	}

	if len(v.OutlierVisibility) > 0 {
		ok := object.Key("OutlierVisibility")
		ok.String(string(v.OutlierVisibility))
	}

	if v.StyleOptions != nil {
		ok := object.Key("StyleOptions")
		if err := awsRestjson1_serializeDocumentBoxPlotStyleOptions(v.StyleOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBoxPlotSortConfiguration(v *types.BoxPlotSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategorySort != nil {
		ok := object.Key("CategorySort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.CategorySort, ok); err != nil {
			return err
		}
	}

	if v.PaginationConfiguration != nil {
		ok := object.Key("PaginationConfiguration")
		if err := awsRestjson1_serializeDocumentPaginationConfiguration(v.PaginationConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBoxPlotStyleOptions(v *types.BoxPlotStyleOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FillStyle) > 0 {
		ok := object.Key("FillStyle")
		ok.String(string(v.FillStyle))
	}

	return nil
}

func awsRestjson1_serializeDocumentBoxPlotVisual(v *types.BoxPlotVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentBoxPlotChartConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCalculatedColumn(v *types.CalculatedColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnId != nil {
		ok := object.Key("ColumnId")
		ok.String(*v.ColumnId)
	}

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	return nil
}

func awsRestjson1_serializeDocumentCalculatedColumnList(v []types.CalculatedColumn, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCalculatedColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCalculatedField(v *types.CalculatedField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetIdentifier != nil {
		ok := object.Key("DataSetIdentifier")
		ok.String(*v.DataSetIdentifier)
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentCalculatedFields(v []types.CalculatedField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCalculatedField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCalculatedMeasureField(v *types.CalculatedMeasureField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCascadingControlConfiguration(v *types.CascadingControlConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceControls != nil {
		ok := object.Key("SourceControls")
		if err := awsRestjson1_serializeDocumentCascadingControlSourceList(v.SourceControls, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCascadingControlSource(v *types.CascadingControlSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnToMatch != nil {
		ok := object.Key("ColumnToMatch")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.ColumnToMatch, ok); err != nil {
			return err
		}
	}

	if v.SourceSheetControlId != nil {
		ok := object.Key("SourceSheetControlId")
		ok.String(*v.SourceSheetControlId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCascadingControlSourceList(v []types.CascadingControlSource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCascadingControlSource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCastColumnTypeOperation(v *types.CastColumnTypeOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.Format != nil {
		ok := object.Key("Format")
		ok.String(*v.Format)
	}

	if len(v.NewColumnType) > 0 {
		ok := object.Key("NewColumnType")
		ok.String(string(v.NewColumnType))
	}

	if len(v.SubType) > 0 {
		ok := object.Key("SubType")
		ok.String(string(v.SubType))
	}

	return nil
}

func awsRestjson1_serializeDocumentCategoricalDimensionField(v *types.CategoricalDimensionField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.FormatConfiguration != nil {
		ok := object.Key("FormatConfiguration")
		if err := awsRestjson1_serializeDocumentStringFormatConfiguration(v.FormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HierarchyId != nil {
		ok := object.Key("HierarchyId")
		ok.String(*v.HierarchyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCategoricalMeasureField(v *types.CategoricalMeasureField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AggregationFunction) > 0 {
		ok := object.Key("AggregationFunction")
		ok.String(string(v.AggregationFunction))
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.FormatConfiguration != nil {
		ok := object.Key("FormatConfiguration")
		if err := awsRestjson1_serializeDocumentStringFormatConfiguration(v.FormatConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCategoryDrillDownFilter(v *types.CategoryDrillDownFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryValues != nil {
		ok := object.Key("CategoryValues")
		if err := awsRestjson1_serializeDocumentCategoryValueList(v.CategoryValues, ok); err != nil {
			return err
		}
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCategoryFilter(v *types.CategoryFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsRestjson1_serializeDocumentCategoryFilterConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.DefaultFilterControlConfiguration != nil {
		ok := object.Key("DefaultFilterControlConfiguration")
		if err := awsRestjson1_serializeDocumentDefaultFilterControlConfiguration(v.DefaultFilterControlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FilterId != nil {
		ok := object.Key("FilterId")
		ok.String(*v.FilterId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCategoryFilterConfiguration(v *types.CategoryFilterConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomFilterConfiguration != nil {
		ok := object.Key("CustomFilterConfiguration")
		if err := awsRestjson1_serializeDocumentCustomFilterConfiguration(v.CustomFilterConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CustomFilterListConfiguration != nil {
		ok := object.Key("CustomFilterListConfiguration")
		if err := awsRestjson1_serializeDocumentCustomFilterListConfiguration(v.CustomFilterListConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FilterListConfiguration != nil {
		ok := object.Key("FilterListConfiguration")
		if err := awsRestjson1_serializeDocumentFilterListConfiguration(v.FilterListConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCategoryValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCellValueSynonym(v *types.CellValueSynonym, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CellValue != nil {
		ok := object.Key("CellValue")
		ok.String(*v.CellValue)
	}

	if v.Synonyms != nil {
		ok := object.Key("Synonyms")
		if err := awsRestjson1_serializeDocumentStringList(v.Synonyms, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCellValueSynonyms(v []types.CellValueSynonym, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCellValueSynonym(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentChartAxisLabelOptions(v *types.ChartAxisLabelOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AxisLabelOptions != nil {
		ok := object.Key("AxisLabelOptions")
		if err := awsRestjson1_serializeDocumentAxisLabelOptionsList(v.AxisLabelOptions, ok); err != nil {
			return err
		}
	}

	if len(v.SortIconVisibility) > 0 {
		ok := object.Key("SortIconVisibility")
		ok.String(string(v.SortIconVisibility))
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentClusterMarker(v *types.ClusterMarker, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SimpleClusterMarker != nil {
		ok := object.Key("SimpleClusterMarker")
		if err := awsRestjson1_serializeDocumentSimpleClusterMarker(v.SimpleClusterMarker, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentClusterMarkerConfiguration(v *types.ClusterMarkerConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterMarker != nil {
		ok := object.Key("ClusterMarker")
		if err := awsRestjson1_serializeDocumentClusterMarker(v.ClusterMarker, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCollectiveConstant(v *types.CollectiveConstant, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentStringList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColorList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentColorScale(v *types.ColorScale, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ColorFillType) > 0 {
		ok := object.Key("ColorFillType")
		ok.String(string(v.ColorFillType))
	}

	if v.Colors != nil {
		ok := object.Key("Colors")
		if err := awsRestjson1_serializeDocumentColorScaleColorList(v.Colors, ok); err != nil {
			return err
		}
	}

	if v.NullValueColor != nil {
		ok := object.Key("NullValueColor")
		if err := awsRestjson1_serializeDocumentDataColor(v.NullValueColor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColorScaleColorList(v []types.DataColor, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataColor(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColorsConfiguration(v *types.ColorsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomColors != nil {
		ok := object.Key("CustomColors")
		if err := awsRestjson1_serializeDocumentCustomColorsList(v.CustomColors, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnConfiguration(v *types.ColumnConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColorsConfiguration != nil {
		ok := object.Key("ColorsConfiguration")
		if err := awsRestjson1_serializeDocumentColorsConfiguration(v.ColorsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.FormatConfiguration != nil {
		ok := object.Key("FormatConfiguration")
		if err := awsRestjson1_serializeDocumentFormatConfiguration(v.FormatConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.Role) > 0 {
		ok := object.Key("Role")
		ok.String(string(v.Role))
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnConfigurationList(v []types.ColumnConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnDescription(v *types.ColumnDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnGroup(v *types.ColumnGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GeoSpatialColumnGroup != nil {
		ok := object.Key("GeoSpatialColumnGroup")
		if err := awsRestjson1_serializeDocumentGeoSpatialColumnGroup(v.GeoSpatialColumnGroup, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnGroupColumnSchema(v *types.ColumnGroupColumnSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnGroupColumnSchemaList(v []types.ColumnGroupColumnSchema, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnGroupColumnSchema(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnGroupList(v []types.ColumnGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnGroupSchema(v *types.ColumnGroupSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnGroupColumnSchemaList != nil {
		ok := object.Key("ColumnGroupColumnSchemaList")
		if err := awsRestjson1_serializeDocumentColumnGroupColumnSchemaList(v.ColumnGroupColumnSchemaList, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnGroupSchemaList(v []types.ColumnGroupSchema, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnGroupSchema(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnHierarchy(v *types.ColumnHierarchy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeHierarchy != nil {
		ok := object.Key("DateTimeHierarchy")
		if err := awsRestjson1_serializeDocumentDateTimeHierarchy(v.DateTimeHierarchy, ok); err != nil {
			return err
		}
	}

	if v.ExplicitHierarchy != nil {
		ok := object.Key("ExplicitHierarchy")
		if err := awsRestjson1_serializeDocumentExplicitHierarchy(v.ExplicitHierarchy, ok); err != nil {
			return err
		}
	}

	if v.PredefinedHierarchy != nil {
		ok := object.Key("PredefinedHierarchy")
		if err := awsRestjson1_serializeDocumentPredefinedHierarchy(v.PredefinedHierarchy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnHierarchyList(v []types.ColumnHierarchy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnHierarchy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnIdentifier(v *types.ColumnIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.DataSetIdentifier != nil {
		ok := object.Key("DataSetIdentifier")
		ok.String(*v.DataSetIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnLevelPermissionRule(v *types.ColumnLevelPermissionRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnNames != nil {
		ok := object.Key("ColumnNames")
		if err := awsRestjson1_serializeDocumentColumnNameList(v.ColumnNames, ok); err != nil {
			return err
		}
	}

	if v.Principals != nil {
		ok := object.Key("Principals")
		if err := awsRestjson1_serializeDocumentPrincipalList(v.Principals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnLevelPermissionRuleList(v []types.ColumnLevelPermissionRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnLevelPermissionRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnSchema(v *types.ColumnSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataType != nil {
		ok := object.Key("DataType")
		ok.String(*v.DataType)
	}

	if v.GeographicRole != nil {
		ok := object.Key("GeographicRole")
		ok.String(*v.GeographicRole)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnSchemaList(v []types.ColumnSchema, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnSchema(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnSort(v *types.ColumnSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationFunction != nil {
		ok := object.Key("AggregationFunction")
		if err := awsRestjson1_serializeDocumentAggregationFunction(v.AggregationFunction, ok); err != nil {
			return err
		}
	}

	if len(v.Direction) > 0 {
		ok := object.Key("Direction")
		ok.String(string(v.Direction))
	}

	if v.SortBy != nil {
		ok := object.Key("SortBy")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnTag(v *types.ColumnTag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnDescription != nil {
		ok := object.Key("ColumnDescription")
		if err := awsRestjson1_serializeDocumentColumnDescription(v.ColumnDescription, ok); err != nil {
			return err
		}
	}

	if len(v.ColumnGeographicRole) > 0 {
		ok := object.Key("ColumnGeographicRole")
		ok.String(string(v.ColumnGeographicRole))
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnTagList(v []types.ColumnTag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnTagNames(v []types.ColumnTagName, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnTooltipItem(v *types.ColumnTooltipItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Aggregation != nil {
		ok := object.Key("Aggregation")
		if err := awsRestjson1_serializeDocumentAggregationFunction(v.Aggregation, ok); err != nil {
			return err
		}
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.Label != nil {
		ok := object.Key("Label")
		ok.String(*v.Label)
	}

	if len(v.TooltipTarget) > 0 {
		ok := object.Key("TooltipTarget")
		ok.String(string(v.TooltipTarget))
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentComboChartAggregatedFieldWells(v *types.ComboChartAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BarValues != nil {
		ok := object.Key("BarValues")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.BarValues, ok); err != nil {
			return err
		}
	}

	if v.Category != nil {
		ok := object.Key("Category")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Category, ok); err != nil {
			return err
		}
	}

	if v.Colors != nil {
		ok := object.Key("Colors")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Colors, ok); err != nil {
			return err
		}
	}

	if v.LineValues != nil {
		ok := object.Key("LineValues")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.LineValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComboChartConfiguration(v *types.ComboChartConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BarDataLabels != nil {
		ok := object.Key("BarDataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.BarDataLabels, ok); err != nil {
			return err
		}
	}

	if len(v.BarsArrangement) > 0 {
		ok := object.Key("BarsArrangement")
		ok.String(string(v.BarsArrangement))
	}

	if v.CategoryAxis != nil {
		ok := object.Key("CategoryAxis")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.CategoryAxis, ok); err != nil {
			return err
		}
	}

	if v.CategoryLabelOptions != nil {
		ok := object.Key("CategoryLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.CategoryLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.ColorLabelOptions != nil {
		ok := object.Key("ColorLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.ColorLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentComboChartFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if v.LineDataLabels != nil {
		ok := object.Key("LineDataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.LineDataLabels, ok); err != nil {
			return err
		}
	}

	if v.PrimaryYAxisDisplayOptions != nil {
		ok := object.Key("PrimaryYAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.PrimaryYAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.PrimaryYAxisLabelOptions != nil {
		ok := object.Key("PrimaryYAxisLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.PrimaryYAxisLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.ReferenceLines != nil {
		ok := object.Key("ReferenceLines")
		if err := awsRestjson1_serializeDocumentReferenceLineList(v.ReferenceLines, ok); err != nil {
			return err
		}
	}

	if v.SecondaryYAxisDisplayOptions != nil {
		ok := object.Key("SecondaryYAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.SecondaryYAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.SecondaryYAxisLabelOptions != nil {
		ok := object.Key("SecondaryYAxisLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.SecondaryYAxisLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.SingleAxisOptions != nil {
		ok := object.Key("SingleAxisOptions")
		if err := awsRestjson1_serializeDocumentSingleAxisOptions(v.SingleAxisOptions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentComboChartSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComboChartFieldWells(v *types.ComboChartFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComboChartAggregatedFieldWells != nil {
		ok := object.Key("ComboChartAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentComboChartAggregatedFieldWells(v.ComboChartAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComboChartSortConfiguration(v *types.ComboChartSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryItemsLimit != nil {
		ok := object.Key("CategoryItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.CategoryItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.CategorySort != nil {
		ok := object.Key("CategorySort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.CategorySort, ok); err != nil {
			return err
		}
	}

	if v.ColorItemsLimit != nil {
		ok := object.Key("ColorItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.ColorItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.ColorSort != nil {
		ok := object.Key("ColorSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.ColorSort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComboChartVisual(v *types.ComboChartVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentComboChartConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentComparativeOrder(v *types.ComparativeOrder, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SpecifedOrder != nil {
		ok := object.Key("SpecifedOrder")
		if err := awsRestjson1_serializeDocumentStringList(v.SpecifedOrder, ok); err != nil {
			return err
		}
	}

	if len(v.TreatUndefinedSpecifiedValues) > 0 {
		ok := object.Key("TreatUndefinedSpecifiedValues")
		ok.String(string(v.TreatUndefinedSpecifiedValues))
	}

	if len(v.UseOrdering) > 0 {
		ok := object.Key("UseOrdering")
		ok.String(string(v.UseOrdering))
	}

	return nil
}

func awsRestjson1_serializeDocumentComparisonConfiguration(v *types.ComparisonConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComparisonFormat != nil {
		ok := object.Key("ComparisonFormat")
		if err := awsRestjson1_serializeDocumentComparisonFormatConfiguration(v.ComparisonFormat, ok); err != nil {
			return err
		}
	}

	if len(v.ComparisonMethod) > 0 {
		ok := object.Key("ComparisonMethod")
		ok.String(string(v.ComparisonMethod))
	}

	return nil
}

func awsRestjson1_serializeDocumentComparisonFormatConfiguration(v *types.ComparisonFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NumberDisplayFormatConfiguration != nil {
		ok := object.Key("NumberDisplayFormatConfiguration")
		if err := awsRestjson1_serializeDocumentNumberDisplayFormatConfiguration(v.NumberDisplayFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PercentageDisplayFormatConfiguration != nil {
		ok := object.Key("PercentageDisplayFormatConfiguration")
		if err := awsRestjson1_serializeDocumentPercentageDisplayFormatConfiguration(v.PercentageDisplayFormatConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComputation(v *types.Computation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Forecast != nil {
		ok := object.Key("Forecast")
		if err := awsRestjson1_serializeDocumentForecastComputation(v.Forecast, ok); err != nil {
			return err
		}
	}

	if v.GrowthRate != nil {
		ok := object.Key("GrowthRate")
		if err := awsRestjson1_serializeDocumentGrowthRateComputation(v.GrowthRate, ok); err != nil {
			return err
		}
	}

	if v.MaximumMinimum != nil {
		ok := object.Key("MaximumMinimum")
		if err := awsRestjson1_serializeDocumentMaximumMinimumComputation(v.MaximumMinimum, ok); err != nil {
			return err
		}
	}

	if v.MetricComparison != nil {
		ok := object.Key("MetricComparison")
		if err := awsRestjson1_serializeDocumentMetricComparisonComputation(v.MetricComparison, ok); err != nil {
			return err
		}
	}

	if v.PeriodOverPeriod != nil {
		ok := object.Key("PeriodOverPeriod")
		if err := awsRestjson1_serializeDocumentPeriodOverPeriodComputation(v.PeriodOverPeriod, ok); err != nil {
			return err
		}
	}

	if v.PeriodToDate != nil {
		ok := object.Key("PeriodToDate")
		if err := awsRestjson1_serializeDocumentPeriodToDateComputation(v.PeriodToDate, ok); err != nil {
			return err
		}
	}

	if v.TopBottomMovers != nil {
		ok := object.Key("TopBottomMovers")
		if err := awsRestjson1_serializeDocumentTopBottomMoversComputation(v.TopBottomMovers, ok); err != nil {
			return err
		}
	}

	if v.TopBottomRanked != nil {
		ok := object.Key("TopBottomRanked")
		if err := awsRestjson1_serializeDocumentTopBottomRankedComputation(v.TopBottomRanked, ok); err != nil {
			return err
		}
	}

	if v.TotalAggregation != nil {
		ok := object.Key("TotalAggregation")
		if err := awsRestjson1_serializeDocumentTotalAggregationComputation(v.TotalAggregation, ok); err != nil {
			return err
		}
	}

	if v.UniqueValues != nil {
		ok := object.Key("UniqueValues")
		if err := awsRestjson1_serializeDocumentUniqueValuesComputation(v.UniqueValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComputationList(v []types.Computation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComputation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConditionalFormattingColor(v *types.ConditionalFormattingColor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Gradient != nil {
		ok := object.Key("Gradient")
		if err := awsRestjson1_serializeDocumentConditionalFormattingGradientColor(v.Gradient, ok); err != nil {
			return err
		}
	}

	if v.Solid != nil {
		ok := object.Key("Solid")
		if err := awsRestjson1_serializeDocumentConditionalFormattingSolidColor(v.Solid, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalFormattingCustomIconCondition(v *types.ConditionalFormattingCustomIconCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if v.DisplayConfiguration != nil {
		ok := object.Key("DisplayConfiguration")
		if err := awsRestjson1_serializeDocumentConditionalFormattingIconDisplayConfiguration(v.DisplayConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if v.IconOptions != nil {
		ok := object.Key("IconOptions")
		if err := awsRestjson1_serializeDocumentConditionalFormattingCustomIconOptions(v.IconOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalFormattingCustomIconOptions(v *types.ConditionalFormattingCustomIconOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Icon) > 0 {
		ok := object.Key("Icon")
		ok.String(string(v.Icon))
	}

	if v.UnicodeIcon != nil {
		ok := object.Key("UnicodeIcon")
		ok.String(*v.UnicodeIcon)
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalFormattingGradientColor(v *types.ConditionalFormattingGradientColor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		if err := awsRestjson1_serializeDocumentGradientColor(v.Color, ok); err != nil {
			return err
		}
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalFormattingIcon(v *types.ConditionalFormattingIcon, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomCondition != nil {
		ok := object.Key("CustomCondition")
		if err := awsRestjson1_serializeDocumentConditionalFormattingCustomIconCondition(v.CustomCondition, ok); err != nil {
			return err
		}
	}

	if v.IconSet != nil {
		ok := object.Key("IconSet")
		if err := awsRestjson1_serializeDocumentConditionalFormattingIconSet(v.IconSet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalFormattingIconDisplayConfiguration(v *types.ConditionalFormattingIconDisplayConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IconDisplayOption) > 0 {
		ok := object.Key("IconDisplayOption")
		ok.String(string(v.IconDisplayOption))
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalFormattingIconSet(v *types.ConditionalFormattingIconSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if len(v.IconSetType) > 0 {
		ok := object.Key("IconSetType")
		ok.String(string(v.IconSetType))
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalFormattingSolidColor(v *types.ConditionalFormattingSolidColor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	return nil
}

func awsRestjson1_serializeDocumentContextMenuOption(v *types.ContextMenuOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentContributionAnalysisDefault(v *types.ContributionAnalysisDefault, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContributorDimensions != nil {
		ok := object.Key("ContributorDimensions")
		if err := awsRestjson1_serializeDocumentContributorDimensionList(v.ContributorDimensions, ok); err != nil {
			return err
		}
	}

	if v.MeasureFieldId != nil {
		ok := object.Key("MeasureFieldId")
		ok.String(*v.MeasureFieldId)
	}

	return nil
}

func awsRestjson1_serializeDocumentContributionAnalysisDefaultList(v []types.ContributionAnalysisDefault, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentContributionAnalysisDefault(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentContributorDimensionList(v []types.ColumnIdentifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnIdentifier(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCreateColumnsOperation(v *types.CreateColumnsOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentCalculatedColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCredentialPair(v *types.CredentialPair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlternateDataSourceParameters != nil {
		ok := object.Key("AlternateDataSourceParameters")
		if err := awsRestjson1_serializeDocumentDataSourceParametersList(v.AlternateDataSourceParameters, ok); err != nil {
			return err
		}
	}

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentCurrencyDisplayFormatConfiguration(v *types.CurrencyDisplayFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecimalPlacesConfiguration != nil {
		ok := object.Key("DecimalPlacesConfiguration")
		if err := awsRestjson1_serializeDocumentDecimalPlacesConfiguration(v.DecimalPlacesConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NegativeValueConfiguration != nil {
		ok := object.Key("NegativeValueConfiguration")
		if err := awsRestjson1_serializeDocumentNegativeValueConfiguration(v.NegativeValueConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NullValueFormatConfiguration != nil {
		ok := object.Key("NullValueFormatConfiguration")
		if err := awsRestjson1_serializeDocumentNullValueFormatConfiguration(v.NullValueFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.NumberScale) > 0 {
		ok := object.Key("NumberScale")
		ok.String(string(v.NumberScale))
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.SeparatorConfiguration != nil {
		ok := object.Key("SeparatorConfiguration")
		if err := awsRestjson1_serializeDocumentNumericSeparatorConfiguration(v.SeparatorConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Suffix != nil {
		ok := object.Key("Suffix")
		ok.String(*v.Suffix)
	}

	if v.Symbol != nil {
		ok := object.Key("Symbol")
		ok.String(*v.Symbol)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomActionColumnList(v []types.ColumnIdentifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnIdentifier(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCustomActionFilterOperation(v *types.CustomActionFilterOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SelectedFieldsConfiguration != nil {
		ok := object.Key("SelectedFieldsConfiguration")
		if err := awsRestjson1_serializeDocumentFilterOperationSelectedFieldsConfiguration(v.SelectedFieldsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TargetVisualsConfiguration != nil {
		ok := object.Key("TargetVisualsConfiguration")
		if err := awsRestjson1_serializeDocumentFilterOperationTargetVisualsConfiguration(v.TargetVisualsConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomActionNavigationOperation(v *types.CustomActionNavigationOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LocalNavigationConfiguration != nil {
		ok := object.Key("LocalNavigationConfiguration")
		if err := awsRestjson1_serializeDocumentLocalNavigationConfiguration(v.LocalNavigationConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomActionSetParametersOperation(v *types.CustomActionSetParametersOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ParameterValueConfigurations != nil {
		ok := object.Key("ParameterValueConfigurations")
		if err := awsRestjson1_serializeDocumentSetParameterValueConfigurationList(v.ParameterValueConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomActionURLOperation(v *types.CustomActionURLOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.URLTarget) > 0 {
		ok := object.Key("URLTarget")
		ok.String(string(v.URLTarget))
	}

	if v.URLTemplate != nil {
		ok := object.Key("URLTemplate")
		ok.String(*v.URLTemplate)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomColor(v *types.CustomColor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if v.FieldValue != nil {
		ok := object.Key("FieldValue")
		ok.String(*v.FieldValue)
	}

	if len(v.SpecialValue) > 0 {
		ok := object.Key("SpecialValue")
		ok.String(string(v.SpecialValue))
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomColorsList(v []types.CustomColor, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCustomColor(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCustomContentConfiguration(v *types.CustomContentConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContentType) > 0 {
		ok := object.Key("ContentType")
		ok.String(string(v.ContentType))
	}

	if v.ContentUrl != nil {
		ok := object.Key("ContentUrl")
		ok.String(*v.ContentUrl)
	}

	if len(v.ImageScaling) > 0 {
		ok := object.Key("ImageScaling")
		ok.String(string(v.ImageScaling))
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomContentVisual(v *types.CustomContentVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentCustomContentConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DataSetIdentifier != nil {
		ok := object.Key("DataSetIdentifier")
		ok.String(*v.DataSetIdentifier)
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomFilterConfiguration(v *types.CustomFilterConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryValue != nil {
		ok := object.Key("CategoryValue")
		ok.String(*v.CategoryValue)
	}

	if len(v.MatchOperator) > 0 {
		ok := object.Key("MatchOperator")
		ok.String(string(v.MatchOperator))
	}

	if len(v.NullOption) > 0 {
		ok := object.Key("NullOption")
		ok.String(string(v.NullOption))
	}

	if v.ParameterName != nil {
		ok := object.Key("ParameterName")
		ok.String(*v.ParameterName)
	}

	if len(v.SelectAllOptions) > 0 {
		ok := object.Key("SelectAllOptions")
		ok.String(string(v.SelectAllOptions))
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomFilterListConfiguration(v *types.CustomFilterListConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryValues != nil {
		ok := object.Key("CategoryValues")
		if err := awsRestjson1_serializeDocumentCategoryValueList(v.CategoryValues, ok); err != nil {
			return err
		}
	}

	if len(v.MatchOperator) > 0 {
		ok := object.Key("MatchOperator")
		ok.String(string(v.MatchOperator))
	}

	if len(v.NullOption) > 0 {
		ok := object.Key("NullOption")
		ok.String(string(v.NullOption))
	}

	if len(v.SelectAllOptions) > 0 {
		ok := object.Key("SelectAllOptions")
		ok.String(string(v.SelectAllOptions))
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomNarrativeOptions(v *types.CustomNarrativeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Narrative != nil {
		ok := object.Key("Narrative")
		ok.String(*v.Narrative)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomParameterValues(v *types.CustomParameterValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeValues != nil {
		ok := object.Key("DateTimeValues")
		if err := awsRestjson1_serializeDocumentDateTimeDefaultValueList(v.DateTimeValues, ok); err != nil {
			return err
		}
	}

	if v.DecimalValues != nil {
		ok := object.Key("DecimalValues")
		if err := awsRestjson1_serializeDocumentDecimalDefaultValueList(v.DecimalValues, ok); err != nil {
			return err
		}
	}

	if v.IntegerValues != nil {
		ok := object.Key("IntegerValues")
		if err := awsRestjson1_serializeDocumentIntegerDefaultValueList(v.IntegerValues, ok); err != nil {
			return err
		}
	}

	if v.StringValues != nil {
		ok := object.Key("StringValues")
		if err := awsRestjson1_serializeDocumentStringDefaultValueList(v.StringValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomSql(v *types.CustomSql, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentInputColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.DataSourceArn != nil {
		ok := object.Key("DataSourceArn")
		ok.String(*v.DataSourceArn)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SqlQuery != nil {
		ok := object.Key("SqlQuery")
		ok.String(*v.SqlQuery)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomValuesConfiguration(v *types.CustomValuesConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomValues != nil {
		ok := object.Key("CustomValues")
		if err := awsRestjson1_serializeDocumentCustomParameterValues(v.CustomValues, ok); err != nil {
			return err
		}
	}

	if v.IncludeNullValue != nil {
		ok := object.Key("IncludeNullValue")
		ok.Boolean(*v.IncludeNullValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardPublishOptions(v *types.DashboardPublishOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdHocFilteringOption != nil {
		ok := object.Key("AdHocFilteringOption")
		if err := awsRestjson1_serializeDocumentAdHocFilteringOption(v.AdHocFilteringOption, ok); err != nil {
			return err
		}
	}

	if v.DataPointDrillUpDownOption != nil {
		ok := object.Key("DataPointDrillUpDownOption")
		if err := awsRestjson1_serializeDocumentDataPointDrillUpDownOption(v.DataPointDrillUpDownOption, ok); err != nil {
			return err
		}
	}

	if v.DataPointMenuLabelOption != nil {
		ok := object.Key("DataPointMenuLabelOption")
		if err := awsRestjson1_serializeDocumentDataPointMenuLabelOption(v.DataPointMenuLabelOption, ok); err != nil {
			return err
		}
	}

	if v.DataPointTooltipOption != nil {
		ok := object.Key("DataPointTooltipOption")
		if err := awsRestjson1_serializeDocumentDataPointTooltipOption(v.DataPointTooltipOption, ok); err != nil {
			return err
		}
	}

	if v.ExportToCSVOption != nil {
		ok := object.Key("ExportToCSVOption")
		if err := awsRestjson1_serializeDocumentExportToCSVOption(v.ExportToCSVOption, ok); err != nil {
			return err
		}
	}

	if v.ExportWithHiddenFieldsOption != nil {
		ok := object.Key("ExportWithHiddenFieldsOption")
		if err := awsRestjson1_serializeDocumentExportWithHiddenFieldsOption(v.ExportWithHiddenFieldsOption, ok); err != nil {
			return err
		}
	}

	if v.SheetControlsOption != nil {
		ok := object.Key("SheetControlsOption")
		if err := awsRestjson1_serializeDocumentSheetControlsOption(v.SheetControlsOption, ok); err != nil {
			return err
		}
	}

	if v.SheetLayoutElementMaximizationOption != nil {
		ok := object.Key("SheetLayoutElementMaximizationOption")
		if err := awsRestjson1_serializeDocumentSheetLayoutElementMaximizationOption(v.SheetLayoutElementMaximizationOption, ok); err != nil {
			return err
		}
	}

	if v.VisualAxisSortOption != nil {
		ok := object.Key("VisualAxisSortOption")
		if err := awsRestjson1_serializeDocumentVisualAxisSortOption(v.VisualAxisSortOption, ok); err != nil {
			return err
		}
	}

	if v.VisualMenuOption != nil {
		ok := object.Key("VisualMenuOption")
		if err := awsRestjson1_serializeDocumentVisualMenuOption(v.VisualMenuOption, ok); err != nil {
			return err
		}
	}

	if v.VisualPublishOptions != nil {
		ok := object.Key("VisualPublishOptions")
		if err := awsRestjson1_serializeDocumentDashboardVisualPublishOptions(v.VisualPublishOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardSearchFilter(v *types.DashboardSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardSearchFilterList(v []types.DashboardSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDashboardSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDashboardSourceEntity(v *types.DashboardSourceEntity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceTemplate != nil {
		ok := object.Key("SourceTemplate")
		if err := awsRestjson1_serializeDocumentDashboardSourceTemplate(v.SourceTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardSourceTemplate(v *types.DashboardSourceTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.DataSetReferences != nil {
		ok := object.Key("DataSetReferences")
		if err := awsRestjson1_serializeDocumentDataSetReferenceList(v.DataSetReferences, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardVersionDefinition(v *types.DashboardVersionDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalysisDefaults != nil {
		ok := object.Key("AnalysisDefaults")
		if err := awsRestjson1_serializeDocumentAnalysisDefaults(v.AnalysisDefaults, ok); err != nil {
			return err
		}
	}

	if v.CalculatedFields != nil {
		ok := object.Key("CalculatedFields")
		if err := awsRestjson1_serializeDocumentCalculatedFields(v.CalculatedFields, ok); err != nil {
			return err
		}
	}

	if v.ColumnConfigurations != nil {
		ok := object.Key("ColumnConfigurations")
		if err := awsRestjson1_serializeDocumentColumnConfigurationList(v.ColumnConfigurations, ok); err != nil {
			return err
		}
	}

	if v.DataSetIdentifierDeclarations != nil {
		ok := object.Key("DataSetIdentifierDeclarations")
		if err := awsRestjson1_serializeDocumentDataSetIdentifierDeclarationList(v.DataSetIdentifierDeclarations, ok); err != nil {
			return err
		}
	}

	if v.FilterGroups != nil {
		ok := object.Key("FilterGroups")
		if err := awsRestjson1_serializeDocumentFilterGroupList(v.FilterGroups, ok); err != nil {
			return err
		}
	}

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsRestjson1_serializeDocumentAssetOptions(v.Options, ok); err != nil {
			return err
		}
	}

	if v.ParameterDeclarations != nil {
		ok := object.Key("ParameterDeclarations")
		if err := awsRestjson1_serializeDocumentParameterDeclarationList(v.ParameterDeclarations, ok); err != nil {
			return err
		}
	}

	if v.Sheets != nil {
		ok := object.Key("Sheets")
		if err := awsRestjson1_serializeDocumentSheetDefinitionList(v.Sheets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardVisualId(v *types.DashboardVisualId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashboardId != nil {
		ok := object.Key("DashboardId")
		ok.String(*v.DashboardId)
	}

	if v.SheetId != nil {
		ok := object.Key("SheetId")
		ok.String(*v.SheetId)
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardVisualPublishOptions(v *types.DashboardVisualPublishOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExportHiddenFieldsOption != nil {
		ok := object.Key("ExportHiddenFieldsOption")
		if err := awsRestjson1_serializeDocumentExportHiddenFieldsOption(v.ExportHiddenFieldsOption, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataAggregation(v *types.DataAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DatasetRowDateGranularity) > 0 {
		ok := object.Key("DatasetRowDateGranularity")
		ok.String(string(v.DatasetRowDateGranularity))
	}

	if v.DefaultDateColumnName != nil {
		ok := object.Key("DefaultDateColumnName")
		ok.String(*v.DefaultDateColumnName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataBarsOptions(v *types.DataBarsOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.NegativeColor != nil {
		ok := object.Key("NegativeColor")
		ok.String(*v.NegativeColor)
	}

	if v.PositiveColor != nil {
		ok := object.Key("PositiveColor")
		ok.String(*v.PositiveColor)
	}

	return nil
}

func awsRestjson1_serializeDocumentDatabaseGroupList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDatabricksParameters(v *types.DatabricksParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != nil {
		ok := object.Key("Port")
		ok.Integer(*v.Port)
	}

	if v.SqlEndpointPath != nil {
		ok := object.Key("SqlEndpointPath")
		ok.String(*v.SqlEndpointPath)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataColor(v *types.DataColor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if v.DataValue != nil {
		ok := object.Key("DataValue")
		switch {
		case math.IsNaN(*v.DataValue):
			ok.String("NaN")

		case math.IsInf(*v.DataValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.DataValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.DataValue)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataColorPalette(v *types.DataColorPalette, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Colors != nil {
		ok := object.Key("Colors")
		if err := awsRestjson1_serializeDocumentColorList(v.Colors, ok); err != nil {
			return err
		}
	}

	if v.EmptyFillColor != nil {
		ok := object.Key("EmptyFillColor")
		ok.String(*v.EmptyFillColor)
	}

	if v.MinMaxGradient != nil {
		ok := object.Key("MinMaxGradient")
		if err := awsRestjson1_serializeDocumentColorList(v.MinMaxGradient, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataFieldSeriesItem(v *types.DataFieldSeriesItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AxisBinding) > 0 {
		ok := object.Key("AxisBinding")
		ok.String(string(v.AxisBinding))
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.FieldValue != nil {
		ok := object.Key("FieldValue")
		ok.String(*v.FieldValue)
	}

	if v.Settings != nil {
		ok := object.Key("Settings")
		if err := awsRestjson1_serializeDocumentLineChartSeriesSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataLabelOptions(v *types.DataLabelOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CategoryLabelVisibility) > 0 {
		ok := object.Key("CategoryLabelVisibility")
		ok.String(string(v.CategoryLabelVisibility))
	}

	if v.DataLabelTypes != nil {
		ok := object.Key("DataLabelTypes")
		if err := awsRestjson1_serializeDocumentDataLabelTypes(v.DataLabelTypes, ok); err != nil {
			return err
		}
	}

	if v.LabelColor != nil {
		ok := object.Key("LabelColor")
		ok.String(*v.LabelColor)
	}

	if len(v.LabelContent) > 0 {
		ok := object.Key("LabelContent")
		ok.String(string(v.LabelContent))
	}

	if v.LabelFontConfiguration != nil {
		ok := object.Key("LabelFontConfiguration")
		if err := awsRestjson1_serializeDocumentFontConfiguration(v.LabelFontConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.MeasureLabelVisibility) > 0 {
		ok := object.Key("MeasureLabelVisibility")
		ok.String(string(v.MeasureLabelVisibility))
	}

	if len(v.Overlap) > 0 {
		ok := object.Key("Overlap")
		ok.String(string(v.Overlap))
	}

	if len(v.Position) > 0 {
		ok := object.Key("Position")
		ok.String(string(v.Position))
	}

	if len(v.TotalsVisibility) > 0 {
		ok := object.Key("TotalsVisibility")
		ok.String(string(v.TotalsVisibility))
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentDataLabelType(v *types.DataLabelType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataPathLabelType != nil {
		ok := object.Key("DataPathLabelType")
		if err := awsRestjson1_serializeDocumentDataPathLabelType(v.DataPathLabelType, ok); err != nil {
			return err
		}
	}

	if v.FieldLabelType != nil {
		ok := object.Key("FieldLabelType")
		if err := awsRestjson1_serializeDocumentFieldLabelType(v.FieldLabelType, ok); err != nil {
			return err
		}
	}

	if v.MaximumLabelType != nil {
		ok := object.Key("MaximumLabelType")
		if err := awsRestjson1_serializeDocumentMaximumLabelType(v.MaximumLabelType, ok); err != nil {
			return err
		}
	}

	if v.MinimumLabelType != nil {
		ok := object.Key("MinimumLabelType")
		if err := awsRestjson1_serializeDocumentMinimumLabelType(v.MinimumLabelType, ok); err != nil {
			return err
		}
	}

	if v.RangeEndsLabelType != nil {
		ok := object.Key("RangeEndsLabelType")
		if err := awsRestjson1_serializeDocumentRangeEndsLabelType(v.RangeEndsLabelType, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataLabelTypes(v []types.DataLabelType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataLabelType(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataPathColor(v *types.DataPathColor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if v.Element != nil {
		ok := object.Key("Element")
		if err := awsRestjson1_serializeDocumentDataPathValue(v.Element, ok); err != nil {
			return err
		}
	}

	if len(v.TimeGranularity) > 0 {
		ok := object.Key("TimeGranularity")
		ok.String(string(v.TimeGranularity))
	}

	return nil
}

func awsRestjson1_serializeDocumentDataPathColorList(v []types.DataPathColor, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataPathColor(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataPathLabelType(v *types.DataPathLabelType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.FieldValue != nil {
		ok := object.Key("FieldValue")
		ok.String(*v.FieldValue)
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentDataPathSort(v *types.DataPathSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Direction) > 0 {
		ok := object.Key("Direction")
		ok.String(string(v.Direction))
	}

	if v.SortPaths != nil {
		ok := object.Key("SortPaths")
		if err := awsRestjson1_serializeDocumentDataPathValueList(v.SortPaths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataPathType(v *types.DataPathType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PivotTableDataPathType) > 0 {
		ok := object.Key("PivotTableDataPathType")
		ok.String(string(v.PivotTableDataPathType))
	}

	return nil
}

func awsRestjson1_serializeDocumentDataPathValue(v *types.DataPathValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataPathType != nil {
		ok := object.Key("DataPathType")
		if err := awsRestjson1_serializeDocumentDataPathType(v.DataPathType, ok); err != nil {
			return err
		}
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.FieldValue != nil {
		ok := object.Key("FieldValue")
		ok.String(*v.FieldValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataPathValueList(v []types.DataPathValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataPathValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataPointDrillUpDownOption(v *types.DataPointDrillUpDownOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentDataPointMenuLabelOption(v *types.DataPointMenuLabelOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentDataPointTooltipOption(v *types.DataPointTooltipOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSetConfiguration(v *types.DataSetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnGroupSchemaList != nil {
		ok := object.Key("ColumnGroupSchemaList")
		if err := awsRestjson1_serializeDocumentColumnGroupSchemaList(v.ColumnGroupSchemaList, ok); err != nil {
			return err
		}
	}

	if v.DataSetSchema != nil {
		ok := object.Key("DataSetSchema")
		if err := awsRestjson1_serializeDocumentDataSetSchema(v.DataSetSchema, ok); err != nil {
			return err
		}
	}

	if v.Placeholder != nil {
		ok := object.Key("Placeholder")
		ok.String(*v.Placeholder)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSetConfigurationList(v []types.DataSetConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataSetConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSetIdentifierDeclaration(v *types.DataSetIdentifierDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetArn != nil {
		ok := object.Key("DataSetArn")
		ok.String(*v.DataSetArn)
	}

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSetIdentifierDeclarationList(v []types.DataSetIdentifierDeclaration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataSetIdentifierDeclaration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDatasetMetadata(v *types.DatasetMetadata, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CalculatedFields != nil {
		ok := object.Key("CalculatedFields")
		if err := awsRestjson1_serializeDocumentTopicCalculatedFields(v.CalculatedFields, ok); err != nil {
			return err
		}
	}

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentTopicColumns(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.DataAggregation != nil {
		ok := object.Key("DataAggregation")
		if err := awsRestjson1_serializeDocumentDataAggregation(v.DataAggregation, ok); err != nil {
			return err
		}
	}

	if v.DatasetArn != nil {
		ok := object.Key("DatasetArn")
		ok.String(*v.DatasetArn)
	}

	if v.DatasetDescription != nil {
		ok := object.Key("DatasetDescription")
		ok.String(*v.DatasetDescription)
	}

	if v.DatasetName != nil {
		ok := object.Key("DatasetName")
		ok.String(*v.DatasetName)
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentTopicFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.NamedEntities != nil {
		ok := object.Key("NamedEntities")
		if err := awsRestjson1_serializeDocumentTopicNamedEntities(v.NamedEntities, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetParameter(v *types.DatasetParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeDatasetParameter != nil {
		ok := object.Key("DateTimeDatasetParameter")
		if err := awsRestjson1_serializeDocumentDateTimeDatasetParameter(v.DateTimeDatasetParameter, ok); err != nil {
			return err
		}
	}

	if v.DecimalDatasetParameter != nil {
		ok := object.Key("DecimalDatasetParameter")
		if err := awsRestjson1_serializeDocumentDecimalDatasetParameter(v.DecimalDatasetParameter, ok); err != nil {
			return err
		}
	}

	if v.IntegerDatasetParameter != nil {
		ok := object.Key("IntegerDatasetParameter")
		if err := awsRestjson1_serializeDocumentIntegerDatasetParameter(v.IntegerDatasetParameter, ok); err != nil {
			return err
		}
	}

	if v.StringDatasetParameter != nil {
		ok := object.Key("StringDatasetParameter")
		if err := awsRestjson1_serializeDocumentStringDatasetParameter(v.StringDatasetParameter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetParameterList(v []types.DatasetParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDatasetParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSetReference(v *types.DataSetReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetArn != nil {
		ok := object.Key("DataSetArn")
		ok.String(*v.DataSetArn)
	}

	if v.DataSetPlaceholder != nil {
		ok := object.Key("DataSetPlaceholder")
		ok.String(*v.DataSetPlaceholder)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSetReferenceList(v []types.DataSetReference, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataSetReference(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSetRefreshProperties(v *types.DataSetRefreshProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RefreshConfiguration != nil {
		ok := object.Key("RefreshConfiguration")
		if err := awsRestjson1_serializeDocumentRefreshConfiguration(v.RefreshConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasets(v []types.DatasetMetadata, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDatasetMetadata(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSetSchema(v *types.DataSetSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnSchemaList != nil {
		ok := object.Key("ColumnSchemaList")
		if err := awsRestjson1_serializeDocumentColumnSchemaList(v.ColumnSchemaList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSetSearchFilter(v *types.DataSetSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSetSearchFilterList(v []types.DataSetSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataSetSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSetUsageConfiguration(v *types.DataSetUsageConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisableUseAsDirectQuerySource {
		ok := object.Key("DisableUseAsDirectQuerySource")
		ok.Boolean(v.DisableUseAsDirectQuerySource)
	}

	if v.DisableUseAsImportedSource {
		ok := object.Key("DisableUseAsImportedSource")
		ok.Boolean(v.DisableUseAsImportedSource)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSourceCredentials(v *types.DataSourceCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CopySourceArn != nil {
		ok := object.Key("CopySourceArn")
		ok.String(*v.CopySourceArn)
	}

	if v.CredentialPair != nil {
		ok := object.Key("CredentialPair")
		if err := awsRestjson1_serializeDocumentCredentialPair(v.CredentialPair, ok); err != nil {
			return err
		}
	}

	if v.SecretArn != nil {
		ok := object.Key("SecretArn")
		ok.String(*v.SecretArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSourceParameters(v types.DataSourceParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DataSourceParametersMemberAmazonElasticsearchParameters:
		av := object.Key("AmazonElasticsearchParameters")
		if err := awsRestjson1_serializeDocumentAmazonElasticsearchParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAmazonOpenSearchParameters:
		av := object.Key("AmazonOpenSearchParameters")
		if err := awsRestjson1_serializeDocumentAmazonOpenSearchParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAthenaParameters:
		av := object.Key("AthenaParameters")
		if err := awsRestjson1_serializeDocumentAthenaParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAuroraParameters:
		av := object.Key("AuroraParameters")
		if err := awsRestjson1_serializeDocumentAuroraParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAuroraPostgreSqlParameters:
		av := object.Key("AuroraPostgreSqlParameters")
		if err := awsRestjson1_serializeDocumentAuroraPostgreSqlParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAwsIotAnalyticsParameters:
		av := object.Key("AwsIotAnalyticsParameters")
		if err := awsRestjson1_serializeDocumentAwsIotAnalyticsParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberBigQueryParameters:
		av := object.Key("BigQueryParameters")
		if err := awsRestjson1_serializeDocumentBigQueryParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberDatabricksParameters:
		av := object.Key("DatabricksParameters")
		if err := awsRestjson1_serializeDocumentDatabricksParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberExasolParameters:
		av := object.Key("ExasolParameters")
		if err := awsRestjson1_serializeDocumentExasolParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberJiraParameters:
		av := object.Key("JiraParameters")
		if err := awsRestjson1_serializeDocumentJiraParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberMariaDbParameters:
		av := object.Key("MariaDbParameters")
		if err := awsRestjson1_serializeDocumentMariaDbParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberMySqlParameters:
		av := object.Key("MySqlParameters")
		if err := awsRestjson1_serializeDocumentMySqlParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberOracleParameters:
		av := object.Key("OracleParameters")
		if err := awsRestjson1_serializeDocumentOracleParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberPostgreSqlParameters:
		av := object.Key("PostgreSqlParameters")
		if err := awsRestjson1_serializeDocumentPostgreSqlParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberPrestoParameters:
		av := object.Key("PrestoParameters")
		if err := awsRestjson1_serializeDocumentPrestoParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberRdsParameters:
		av := object.Key("RdsParameters")
		if err := awsRestjson1_serializeDocumentRdsParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberRedshiftParameters:
		av := object.Key("RedshiftParameters")
		if err := awsRestjson1_serializeDocumentRedshiftParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberS3Parameters:
		av := object.Key("S3Parameters")
		if err := awsRestjson1_serializeDocumentS3Parameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberServiceNowParameters:
		av := object.Key("ServiceNowParameters")
		if err := awsRestjson1_serializeDocumentServiceNowParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberSnowflakeParameters:
		av := object.Key("SnowflakeParameters")
		if err := awsRestjson1_serializeDocumentSnowflakeParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberSparkParameters:
		av := object.Key("SparkParameters")
		if err := awsRestjson1_serializeDocumentSparkParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberSqlServerParameters:
		av := object.Key("SqlServerParameters")
		if err := awsRestjson1_serializeDocumentSqlServerParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberStarburstParameters:
		av := object.Key("StarburstParameters")
		if err := awsRestjson1_serializeDocumentStarburstParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberTeradataParameters:
		av := object.Key("TeradataParameters")
		if err := awsRestjson1_serializeDocumentTeradataParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberTrinoParameters:
		av := object.Key("TrinoParameters")
		if err := awsRestjson1_serializeDocumentTrinoParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberTwitterParameters:
		av := object.Key("TwitterParameters")
		if err := awsRestjson1_serializeDocumentTwitterParameters(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDataSourceParametersList(v []types.DataSourceParameters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentDataSourceParameters(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSourceSearchFilter(v *types.DataSourceSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSourceSearchFilterList(v []types.DataSourceSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataSourceSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDateAxisOptions(v *types.DateAxisOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MissingDateVisibility) > 0 {
		ok := object.Key("MissingDateVisibility")
		ok.String(string(v.MissingDateVisibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentDateDimensionField(v *types.DateDimensionField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if len(v.DateGranularity) > 0 {
		ok := object.Key("DateGranularity")
		ok.String(string(v.DateGranularity))
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.FormatConfiguration != nil {
		ok := object.Key("FormatConfiguration")
		if err := awsRestjson1_serializeDocumentDateTimeFormatConfiguration(v.FormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HierarchyId != nil {
		ok := object.Key("HierarchyId")
		ok.String(*v.HierarchyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentDateMeasureField(v *types.DateMeasureField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AggregationFunction) > 0 {
		ok := object.Key("AggregationFunction")
		ok.String(string(v.AggregationFunction))
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.FormatConfiguration != nil {
		ok := object.Key("FormatConfiguration")
		if err := awsRestjson1_serializeDocumentDateTimeFormatConfiguration(v.FormatConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeDatasetParameter(v *types.DateTimeDatasetParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValues != nil {
		ok := object.Key("DefaultValues")
		if err := awsRestjson1_serializeDocumentDateTimeDatasetParameterDefaultValues(v.DefaultValues, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.TimeGranularity) > 0 {
		ok := object.Key("TimeGranularity")
		ok.String(string(v.TimeGranularity))
	}

	if len(v.ValueType) > 0 {
		ok := object.Key("ValueType")
		ok.String(string(v.ValueType))
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeDatasetParameterDefaultValues(v *types.DateTimeDatasetParameterDefaultValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StaticValues != nil {
		ok := object.Key("StaticValues")
		if err := awsRestjson1_serializeDocumentDateTimeDatasetParameterValueList(v.StaticValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeDatasetParameterValueList(v []time.Time, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Double(smithytime.FormatEpochSeconds(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentDateTimeDefaultValueList(v []time.Time, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Double(smithytime.FormatEpochSeconds(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentDateTimeDefaultValues(v *types.DateTimeDefaultValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DynamicValue != nil {
		ok := object.Key("DynamicValue")
		if err := awsRestjson1_serializeDocumentDynamicDefaultValue(v.DynamicValue, ok); err != nil {
			return err
		}
	}

	if v.RollingDate != nil {
		ok := object.Key("RollingDate")
		if err := awsRestjson1_serializeDocumentRollingDateConfiguration(v.RollingDate, ok); err != nil {
			return err
		}
	}

	if v.StaticValues != nil {
		ok := object.Key("StaticValues")
		if err := awsRestjson1_serializeDocumentDateTimeDefaultValueList(v.StaticValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeFormatConfiguration(v *types.DateTimeFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeFormat != nil {
		ok := object.Key("DateTimeFormat")
		ok.String(*v.DateTimeFormat)
	}

	if v.NullValueFormatConfiguration != nil {
		ok := object.Key("NullValueFormatConfiguration")
		if err := awsRestjson1_serializeDocumentNullValueFormatConfiguration(v.NullValueFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NumericFormatConfiguration != nil {
		ok := object.Key("NumericFormatConfiguration")
		if err := awsRestjson1_serializeDocumentNumericFormatConfiguration(v.NumericFormatConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeHierarchy(v *types.DateTimeHierarchy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DrillDownFilters != nil {
		ok := object.Key("DrillDownFilters")
		if err := awsRestjson1_serializeDocumentDrillDownFilterList(v.DrillDownFilters, ok); err != nil {
			return err
		}
	}

	if v.HierarchyId != nil {
		ok := object.Key("HierarchyId")
		ok.String(*v.HierarchyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeParameter(v *types.DateTimeParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentSensitiveTimestampList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeParameterDeclaration(v *types.DateTimeParameterDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValues != nil {
		ok := object.Key("DefaultValues")
		if err := awsRestjson1_serializeDocumentDateTimeDefaultValues(v.DefaultValues, ok); err != nil {
			return err
		}
	}

	if v.MappedDataSetParameters != nil {
		ok := object.Key("MappedDataSetParameters")
		if err := awsRestjson1_serializeDocumentMappedDataSetParameters(v.MappedDataSetParameters, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.TimeGranularity) > 0 {
		ok := object.Key("TimeGranularity")
		ok.String(string(v.TimeGranularity))
	}

	if v.ValueWhenUnset != nil {
		ok := object.Key("ValueWhenUnset")
		if err := awsRestjson1_serializeDocumentDateTimeValueWhenUnsetConfiguration(v.ValueWhenUnset, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeParameterList(v []types.DateTimeParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDateTimeParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDateTimePickerControlDisplayOptions(v *types.DateTimePickerControlDisplayOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeFormat != nil {
		ok := object.Key("DateTimeFormat")
		ok.String(*v.DateTimeFormat)
	}

	if v.InfoIconLabelOptions != nil {
		ok := object.Key("InfoIconLabelOptions")
		if err := awsRestjson1_serializeDocumentSheetControlInfoIconLabelOptions(v.InfoIconLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.TitleOptions != nil {
		ok := object.Key("TitleOptions")
		if err := awsRestjson1_serializeDocumentLabelOptions(v.TitleOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeValueWhenUnsetConfiguration(v *types.DateTimeValueWhenUnsetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomValue != nil {
		ok := object.Key("CustomValue")
		ok.Double(smithytime.FormatEpochSeconds(*v.CustomValue))
	}

	if len(v.ValueWhenUnsetOption) > 0 {
		ok := object.Key("ValueWhenUnsetOption")
		ok.String(string(v.ValueWhenUnsetOption))
	}

	return nil
}

func awsRestjson1_serializeDocumentDecimalDatasetParameter(v *types.DecimalDatasetParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValues != nil {
		ok := object.Key("DefaultValues")
		if err := awsRestjson1_serializeDocumentDecimalDatasetParameterDefaultValues(v.DefaultValues, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.ValueType) > 0 {
		ok := object.Key("ValueType")
		ok.String(string(v.ValueType))
	}

	return nil
}

func awsRestjson1_serializeDocumentDecimalDatasetParameterDefaultValues(v *types.DecimalDatasetParameterDefaultValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StaticValues != nil {
		ok := object.Key("StaticValues")
		if err := awsRestjson1_serializeDocumentDecimalDatasetParameterValueList(v.StaticValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDecimalDatasetParameterValueList(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDecimalDefaultValueList(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDecimalDefaultValues(v *types.DecimalDefaultValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DynamicValue != nil {
		ok := object.Key("DynamicValue")
		if err := awsRestjson1_serializeDocumentDynamicDefaultValue(v.DynamicValue, ok); err != nil {
			return err
		}
	}

	if v.StaticValues != nil {
		ok := object.Key("StaticValues")
		if err := awsRestjson1_serializeDocumentDecimalDefaultValueList(v.StaticValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDecimalParameter(v *types.DecimalParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentSensitiveDoubleList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDecimalParameterDeclaration(v *types.DecimalParameterDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValues != nil {
		ok := object.Key("DefaultValues")
		if err := awsRestjson1_serializeDocumentDecimalDefaultValues(v.DefaultValues, ok); err != nil {
			return err
		}
	}

	if v.MappedDataSetParameters != nil {
		ok := object.Key("MappedDataSetParameters")
		if err := awsRestjson1_serializeDocumentMappedDataSetParameters(v.MappedDataSetParameters, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.ParameterValueType) > 0 {
		ok := object.Key("ParameterValueType")
		ok.String(string(v.ParameterValueType))
	}

	if v.ValueWhenUnset != nil {
		ok := object.Key("ValueWhenUnset")
		if err := awsRestjson1_serializeDocumentDecimalValueWhenUnsetConfiguration(v.ValueWhenUnset, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDecimalParameterList(v []types.DecimalParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDecimalParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDecimalPlacesConfiguration(v *types.DecimalPlacesConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecimalPlaces != nil {
		ok := object.Key("DecimalPlaces")
		ok.Long(*v.DecimalPlaces)
	}

	return nil
}

func awsRestjson1_serializeDocumentDecimalValueWhenUnsetConfiguration(v *types.DecimalValueWhenUnsetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomValue != nil {
		ok := object.Key("CustomValue")
		switch {
		case math.IsNaN(*v.CustomValue):
			ok.String("NaN")

		case math.IsInf(*v.CustomValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.CustomValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.CustomValue)

		}
	}

	if len(v.ValueWhenUnsetOption) > 0 {
		ok := object.Key("ValueWhenUnsetOption")
		ok.String(string(v.ValueWhenUnsetOption))
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultDateTimePickerControlOptions(v *types.DefaultDateTimePickerControlOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentDateTimePickerControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultFilterControlConfiguration(v *types.DefaultFilterControlConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ControlOptions != nil {
		ok := object.Key("ControlOptions")
		if err := awsRestjson1_serializeDocumentDefaultFilterControlOptions(v.ControlOptions, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultFilterControlOptions(v *types.DefaultFilterControlOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultDateTimePickerOptions != nil {
		ok := object.Key("DefaultDateTimePickerOptions")
		if err := awsRestjson1_serializeDocumentDefaultDateTimePickerControlOptions(v.DefaultDateTimePickerOptions, ok); err != nil {
			return err
		}
	}

	if v.DefaultDropdownOptions != nil {
		ok := object.Key("DefaultDropdownOptions")
		if err := awsRestjson1_serializeDocumentDefaultFilterDropDownControlOptions(v.DefaultDropdownOptions, ok); err != nil {
			return err
		}
	}

	if v.DefaultListOptions != nil {
		ok := object.Key("DefaultListOptions")
		if err := awsRestjson1_serializeDocumentDefaultFilterListControlOptions(v.DefaultListOptions, ok); err != nil {
			return err
		}
	}

	if v.DefaultRelativeDateTimeOptions != nil {
		ok := object.Key("DefaultRelativeDateTimeOptions")
		if err := awsRestjson1_serializeDocumentDefaultRelativeDateTimeControlOptions(v.DefaultRelativeDateTimeOptions, ok); err != nil {
			return err
		}
	}

	if v.DefaultSliderOptions != nil {
		ok := object.Key("DefaultSliderOptions")
		if err := awsRestjson1_serializeDocumentDefaultSliderControlOptions(v.DefaultSliderOptions, ok); err != nil {
			return err
		}
	}

	if v.DefaultTextAreaOptions != nil {
		ok := object.Key("DefaultTextAreaOptions")
		if err := awsRestjson1_serializeDocumentDefaultTextAreaControlOptions(v.DefaultTextAreaOptions, ok); err != nil {
			return err
		}
	}

	if v.DefaultTextFieldOptions != nil {
		ok := object.Key("DefaultTextFieldOptions")
		if err := awsRestjson1_serializeDocumentDefaultTextFieldControlOptions(v.DefaultTextFieldOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultFilterDropDownControlOptions(v *types.DefaultFilterDropDownControlOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentDropDownControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.SelectableValues != nil {
		ok := object.Key("SelectableValues")
		if err := awsRestjson1_serializeDocumentFilterSelectableValues(v.SelectableValues, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultFilterListControlOptions(v *types.DefaultFilterListControlOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentListControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.SelectableValues != nil {
		ok := object.Key("SelectableValues")
		if err := awsRestjson1_serializeDocumentFilterSelectableValues(v.SelectableValues, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultFormatting(v *types.DefaultFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DisplayFormat) > 0 {
		ok := object.Key("DisplayFormat")
		ok.String(string(v.DisplayFormat))
	}

	if v.DisplayFormatOptions != nil {
		ok := object.Key("DisplayFormatOptions")
		if err := awsRestjson1_serializeDocumentDisplayFormatOptions(v.DisplayFormatOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultFreeFormLayoutConfiguration(v *types.DefaultFreeFormLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanvasSizeOptions != nil {
		ok := object.Key("CanvasSizeOptions")
		if err := awsRestjson1_serializeDocumentFreeFormLayoutCanvasSizeOptions(v.CanvasSizeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultGridLayoutConfiguration(v *types.DefaultGridLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanvasSizeOptions != nil {
		ok := object.Key("CanvasSizeOptions")
		if err := awsRestjson1_serializeDocumentGridLayoutCanvasSizeOptions(v.CanvasSizeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultInteractiveLayoutConfiguration(v *types.DefaultInteractiveLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FreeForm != nil {
		ok := object.Key("FreeForm")
		if err := awsRestjson1_serializeDocumentDefaultFreeFormLayoutConfiguration(v.FreeForm, ok); err != nil {
			return err
		}
	}

	if v.Grid != nil {
		ok := object.Key("Grid")
		if err := awsRestjson1_serializeDocumentDefaultGridLayoutConfiguration(v.Grid, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultNewSheetConfiguration(v *types.DefaultNewSheetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InteractiveLayoutConfiguration != nil {
		ok := object.Key("InteractiveLayoutConfiguration")
		if err := awsRestjson1_serializeDocumentDefaultInteractiveLayoutConfiguration(v.InteractiveLayoutConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PaginatedLayoutConfiguration != nil {
		ok := object.Key("PaginatedLayoutConfiguration")
		if err := awsRestjson1_serializeDocumentDefaultPaginatedLayoutConfiguration(v.PaginatedLayoutConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.SheetContentType) > 0 {
		ok := object.Key("SheetContentType")
		ok.String(string(v.SheetContentType))
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultPaginatedLayoutConfiguration(v *types.DefaultPaginatedLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SectionBased != nil {
		ok := object.Key("SectionBased")
		if err := awsRestjson1_serializeDocumentDefaultSectionBasedLayoutConfiguration(v.SectionBased, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultRelativeDateTimeControlOptions(v *types.DefaultRelativeDateTimeControlOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentRelativeDateTimeControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultSectionBasedLayoutConfiguration(v *types.DefaultSectionBasedLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanvasSizeOptions != nil {
		ok := object.Key("CanvasSizeOptions")
		if err := awsRestjson1_serializeDocumentSectionBasedLayoutCanvasSizeOptions(v.CanvasSizeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultSliderControlOptions(v *types.DefaultSliderControlOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentSliderControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("MaximumValue")
		switch {
		case math.IsNaN(v.MaximumValue):
			ok.String("NaN")

		case math.IsInf(v.MaximumValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.MaximumValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.MaximumValue)

		}
	}

	{
		ok := object.Key("MinimumValue")
		switch {
		case math.IsNaN(v.MinimumValue):
			ok.String("NaN")

		case math.IsInf(v.MinimumValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.MinimumValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.MinimumValue)

		}
	}

	{
		ok := object.Key("StepSize")
		switch {
		case math.IsNaN(v.StepSize):
			ok.String("NaN")

		case math.IsInf(v.StepSize, 1):
			ok.String("Infinity")

		case math.IsInf(v.StepSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.StepSize)

		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultTextAreaControlOptions(v *types.DefaultTextAreaControlOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Delimiter != nil {
		ok := object.Key("Delimiter")
		ok.String(*v.Delimiter)
	}

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentTextAreaControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultTextFieldControlOptions(v *types.DefaultTextFieldControlOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentTextFieldControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDestinationParameterValueConfiguration(v *types.DestinationParameterValueConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomValuesConfiguration != nil {
		ok := object.Key("CustomValuesConfiguration")
		if err := awsRestjson1_serializeDocumentCustomValuesConfiguration(v.CustomValuesConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.SelectAllValueOptions) > 0 {
		ok := object.Key("SelectAllValueOptions")
		ok.String(string(v.SelectAllValueOptions))
	}

	if v.SourceColumn != nil {
		ok := object.Key("SourceColumn")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.SourceColumn, ok); err != nil {
			return err
		}
	}

	if v.SourceField != nil {
		ok := object.Key("SourceField")
		ok.String(*v.SourceField)
	}

	if v.SourceParameterName != nil {
		ok := object.Key("SourceParameterName")
		ok.String(*v.SourceParameterName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDimensionField(v *types.DimensionField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoricalDimensionField != nil {
		ok := object.Key("CategoricalDimensionField")
		if err := awsRestjson1_serializeDocumentCategoricalDimensionField(v.CategoricalDimensionField, ok); err != nil {
			return err
		}
	}

	if v.DateDimensionField != nil {
		ok := object.Key("DateDimensionField")
		if err := awsRestjson1_serializeDocumentDateDimensionField(v.DateDimensionField, ok); err != nil {
			return err
		}
	}

	if v.NumericalDimensionField != nil {
		ok := object.Key("NumericalDimensionField")
		if err := awsRestjson1_serializeDocumentNumericalDimensionField(v.NumericalDimensionField, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDimensionFieldList(v []types.DimensionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDisplayFormatOptions(v *types.DisplayFormatOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlankCellFormat != nil {
		ok := object.Key("BlankCellFormat")
		ok.String(*v.BlankCellFormat)
	}

	if v.CurrencySymbol != nil {
		ok := object.Key("CurrencySymbol")
		ok.String(*v.CurrencySymbol)
	}

	if v.DateFormat != nil {
		ok := object.Key("DateFormat")
		ok.String(*v.DateFormat)
	}

	if len(v.DecimalSeparator) > 0 {
		ok := object.Key("DecimalSeparator")
		ok.String(string(v.DecimalSeparator))
	}

	if v.FractionDigits != 0 {
		ok := object.Key("FractionDigits")
		ok.Integer(v.FractionDigits)
	}

	if v.GroupingSeparator != nil {
		ok := object.Key("GroupingSeparator")
		ok.String(*v.GroupingSeparator)
	}

	if v.NegativeFormat != nil {
		ok := object.Key("NegativeFormat")
		if err := awsRestjson1_serializeDocumentNegativeFormat(v.NegativeFormat, ok); err != nil {
			return err
		}
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.Suffix != nil {
		ok := object.Key("Suffix")
		ok.String(*v.Suffix)
	}

	if len(v.UnitScaler) > 0 {
		ok := object.Key("UnitScaler")
		ok.String(string(v.UnitScaler))
	}

	if v.UseBlankCellFormat {
		ok := object.Key("UseBlankCellFormat")
		ok.Boolean(v.UseBlankCellFormat)
	}

	if v.UseGrouping {
		ok := object.Key("UseGrouping")
		ok.Boolean(v.UseGrouping)
	}

	return nil
}

func awsRestjson1_serializeDocumentDnsResolverList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDonutCenterOptions(v *types.DonutCenterOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LabelVisibility) > 0 {
		ok := object.Key("LabelVisibility")
		ok.String(string(v.LabelVisibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentDonutOptions(v *types.DonutOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArcOptions != nil {
		ok := object.Key("ArcOptions")
		if err := awsRestjson1_serializeDocumentArcOptions(v.ArcOptions, ok); err != nil {
			return err
		}
	}

	if v.DonutCenterOptions != nil {
		ok := object.Key("DonutCenterOptions")
		if err := awsRestjson1_serializeDocumentDonutCenterOptions(v.DonutCenterOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDrillDownFilter(v *types.DrillDownFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryFilter != nil {
		ok := object.Key("CategoryFilter")
		if err := awsRestjson1_serializeDocumentCategoryDrillDownFilter(v.CategoryFilter, ok); err != nil {
			return err
		}
	}

	if v.NumericEqualityFilter != nil {
		ok := object.Key("NumericEqualityFilter")
		if err := awsRestjson1_serializeDocumentNumericEqualityDrillDownFilter(v.NumericEqualityFilter, ok); err != nil {
			return err
		}
	}

	if v.TimeRangeFilter != nil {
		ok := object.Key("TimeRangeFilter")
		if err := awsRestjson1_serializeDocumentTimeRangeDrillDownFilter(v.TimeRangeFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDrillDownFilterList(v []types.DrillDownFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDrillDownFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDropDownControlDisplayOptions(v *types.DropDownControlDisplayOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InfoIconLabelOptions != nil {
		ok := object.Key("InfoIconLabelOptions")
		if err := awsRestjson1_serializeDocumentSheetControlInfoIconLabelOptions(v.InfoIconLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.SelectAllOptions != nil {
		ok := object.Key("SelectAllOptions")
		if err := awsRestjson1_serializeDocumentListControlSelectAllOptions(v.SelectAllOptions, ok); err != nil {
			return err
		}
	}

	if v.TitleOptions != nil {
		ok := object.Key("TitleOptions")
		if err := awsRestjson1_serializeDocumentLabelOptions(v.TitleOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDynamicDefaultValue(v *types.DynamicDefaultValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValueColumn != nil {
		ok := object.Key("DefaultValueColumn")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.DefaultValueColumn, ok); err != nil {
			return err
		}
	}

	if v.GroupNameColumn != nil {
		ok := object.Key("GroupNameColumn")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.GroupNameColumn, ok); err != nil {
			return err
		}
	}

	if v.UserNameColumn != nil {
		ok := object.Key("UserNameColumn")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.UserNameColumn, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEmptyVisual(v *types.EmptyVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.DataSetIdentifier != nil {
		ok := object.Key("DataSetIdentifier")
		ok.String(*v.DataSetIdentifier)
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentExasolParameters(v *types.ExasolParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != nil {
		ok := object.Key("Port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentExcludePeriodConfiguration(v *types.ExcludePeriodConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Amount != nil {
		ok := object.Key("Amount")
		ok.Integer(*v.Amount)
	}

	if len(v.Granularity) > 0 {
		ok := object.Key("Granularity")
		ok.String(string(v.Granularity))
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentExplicitHierarchy(v *types.ExplicitHierarchy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentExplicitHierarchyColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.DrillDownFilters != nil {
		ok := object.Key("DrillDownFilters")
		if err := awsRestjson1_serializeDocumentDrillDownFilterList(v.DrillDownFilters, ok); err != nil {
			return err
		}
	}

	if v.HierarchyId != nil {
		ok := object.Key("HierarchyId")
		ok.String(*v.HierarchyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentExplicitHierarchyColumnList(v []types.ColumnIdentifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnIdentifier(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentExportHiddenFieldsOption(v *types.ExportHiddenFieldsOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentExportToCSVOption(v *types.ExportToCSVOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentExportWithHiddenFieldsOption(v *types.ExportWithHiddenFieldsOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldBasedTooltip(v *types.FieldBasedTooltip, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AggregationVisibility) > 0 {
		ok := object.Key("AggregationVisibility")
		ok.String(string(v.AggregationVisibility))
	}

	if v.TooltipFields != nil {
		ok := object.Key("TooltipFields")
		if err := awsRestjson1_serializeDocumentTooltipItemList(v.TooltipFields, ok); err != nil {
			return err
		}
	}

	if len(v.TooltipTitleType) > 0 {
		ok := object.Key("TooltipTitleType")
		ok.String(string(v.TooltipTitleType))
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldFolder(v *types.FieldFolder, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("columns")
		if err := awsRestjson1_serializeDocumentFolderColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldFolderMap(v map[string]types.FieldFolder, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentFieldFolder(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFieldLabelType(v *types.FieldLabelType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldOrderList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFieldSeriesItem(v *types.FieldSeriesItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AxisBinding) > 0 {
		ok := object.Key("AxisBinding")
		ok.String(string(v.AxisBinding))
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.Settings != nil {
		ok := object.Key("Settings")
		if err := awsRestjson1_serializeDocumentLineChartSeriesSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldSort(v *types.FieldSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Direction) > 0 {
		ok := object.Key("Direction")
		ok.String(string(v.Direction))
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldSortOptions(v *types.FieldSortOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnSort != nil {
		ok := object.Key("ColumnSort")
		if err := awsRestjson1_serializeDocumentColumnSort(v.ColumnSort, ok); err != nil {
			return err
		}
	}

	if v.FieldSort != nil {
		ok := object.Key("FieldSort")
		if err := awsRestjson1_serializeDocumentFieldSort(v.FieldSort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldSortOptionsList(v []types.FieldSortOptions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFieldSortOptions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFieldTooltipItem(v *types.FieldTooltipItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.Label != nil {
		ok := object.Key("Label")
		ok.String(*v.Label)
	}

	if len(v.TooltipTarget) > 0 {
		ok := object.Key("TooltipTarget")
		ok.String(string(v.TooltipTarget))
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentFilledMapAggregatedFieldWells(v *types.FilledMapAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Geospatial != nil {
		ok := object.Key("Geospatial")
		if err := awsRestjson1_serializeDocumentFilledMapDimensionFieldList(v.Geospatial, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentFilledMapMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilledMapConditionalFormatting(v *types.FilledMapConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionalFormattingOptions != nil {
		ok := object.Key("ConditionalFormattingOptions")
		if err := awsRestjson1_serializeDocumentFilledMapConditionalFormattingOptionList(v.ConditionalFormattingOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilledMapConditionalFormattingOption(v *types.FilledMapConditionalFormattingOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Shape != nil {
		ok := object.Key("Shape")
		if err := awsRestjson1_serializeDocumentFilledMapShapeConditionalFormatting(v.Shape, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilledMapConditionalFormattingOptionList(v []types.FilledMapConditionalFormattingOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFilledMapConditionalFormattingOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFilledMapConfiguration(v *types.FilledMapConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentFilledMapFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if v.MapStyleOptions != nil {
		ok := object.Key("MapStyleOptions")
		if err := awsRestjson1_serializeDocumentGeospatialMapStyleOptions(v.MapStyleOptions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentFilledMapSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if v.WindowOptions != nil {
		ok := object.Key("WindowOptions")
		if err := awsRestjson1_serializeDocumentGeospatialWindowOptions(v.WindowOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilledMapDimensionFieldList(v []types.DimensionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFilledMapFieldWells(v *types.FilledMapFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilledMapAggregatedFieldWells != nil {
		ok := object.Key("FilledMapAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentFilledMapAggregatedFieldWells(v.FilledMapAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilledMapMeasureFieldList(v []types.MeasureField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMeasureField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFilledMapShapeConditionalFormatting(v *types.FilledMapShapeConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.Format != nil {
		ok := object.Key("Format")
		if err := awsRestjson1_serializeDocumentShapeConditionalFormat(v.Format, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilledMapSortConfiguration(v *types.FilledMapSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategorySort != nil {
		ok := object.Key("CategorySort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.CategorySort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilledMapVisual(v *types.FilledMapVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentFilledMapConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.ConditionalFormatting != nil {
		ok := object.Key("ConditionalFormatting")
		if err := awsRestjson1_serializeDocumentFilledMapConditionalFormatting(v.ConditionalFormatting, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentFilter(v *types.Filter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryFilter != nil {
		ok := object.Key("CategoryFilter")
		if err := awsRestjson1_serializeDocumentCategoryFilter(v.CategoryFilter, ok); err != nil {
			return err
		}
	}

	if v.NumericEqualityFilter != nil {
		ok := object.Key("NumericEqualityFilter")
		if err := awsRestjson1_serializeDocumentNumericEqualityFilter(v.NumericEqualityFilter, ok); err != nil {
			return err
		}
	}

	if v.NumericRangeFilter != nil {
		ok := object.Key("NumericRangeFilter")
		if err := awsRestjson1_serializeDocumentNumericRangeFilter(v.NumericRangeFilter, ok); err != nil {
			return err
		}
	}

	if v.RelativeDatesFilter != nil {
		ok := object.Key("RelativeDatesFilter")
		if err := awsRestjson1_serializeDocumentRelativeDatesFilter(v.RelativeDatesFilter, ok); err != nil {
			return err
		}
	}

	if v.TimeEqualityFilter != nil {
		ok := object.Key("TimeEqualityFilter")
		if err := awsRestjson1_serializeDocumentTimeEqualityFilter(v.TimeEqualityFilter, ok); err != nil {
			return err
		}
	}

	if v.TimeRangeFilter != nil {
		ok := object.Key("TimeRangeFilter")
		if err := awsRestjson1_serializeDocumentTimeRangeFilter(v.TimeRangeFilter, ok); err != nil {
			return err
		}
	}

	if v.TopBottomFilter != nil {
		ok := object.Key("TopBottomFilter")
		if err := awsRestjson1_serializeDocumentTopBottomFilter(v.TopBottomFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterControl(v *types.FilterControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CrossSheet != nil {
		ok := object.Key("CrossSheet")
		if err := awsRestjson1_serializeDocumentFilterCrossSheetControl(v.CrossSheet, ok); err != nil {
			return err
		}
	}

	if v.DateTimePicker != nil {
		ok := object.Key("DateTimePicker")
		if err := awsRestjson1_serializeDocumentFilterDateTimePickerControl(v.DateTimePicker, ok); err != nil {
			return err
		}
	}

	if v.Dropdown != nil {
		ok := object.Key("Dropdown")
		if err := awsRestjson1_serializeDocumentFilterDropDownControl(v.Dropdown, ok); err != nil {
			return err
		}
	}

	if v.List != nil {
		ok := object.Key("List")
		if err := awsRestjson1_serializeDocumentFilterListControl(v.List, ok); err != nil {
			return err
		}
	}

	if v.RelativeDateTime != nil {
		ok := object.Key("RelativeDateTime")
		if err := awsRestjson1_serializeDocumentFilterRelativeDateTimeControl(v.RelativeDateTime, ok); err != nil {
			return err
		}
	}

	if v.Slider != nil {
		ok := object.Key("Slider")
		if err := awsRestjson1_serializeDocumentFilterSliderControl(v.Slider, ok); err != nil {
			return err
		}
	}

	if v.TextArea != nil {
		ok := object.Key("TextArea")
		if err := awsRestjson1_serializeDocumentFilterTextAreaControl(v.TextArea, ok); err != nil {
			return err
		}
	}

	if v.TextField != nil {
		ok := object.Key("TextField")
		if err := awsRestjson1_serializeDocumentFilterTextFieldControl(v.TextField, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterControlList(v []types.FilterControl, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFilterControl(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterCrossSheetControl(v *types.FilterCrossSheetControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CascadingControlConfiguration != nil {
		ok := object.Key("CascadingControlConfiguration")
		if err := awsRestjson1_serializeDocumentCascadingControlConfiguration(v.CascadingControlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FilterControlId != nil {
		ok := object.Key("FilterControlId")
		ok.String(*v.FilterControlId)
	}

	if v.SourceFilterId != nil {
		ok := object.Key("SourceFilterId")
		ok.String(*v.SourceFilterId)
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterDateTimePickerControl(v *types.FilterDateTimePickerControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentDateTimePickerControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.FilterControlId != nil {
		ok := object.Key("FilterControlId")
		ok.String(*v.FilterControlId)
	}

	if v.SourceFilterId != nil {
		ok := object.Key("SourceFilterId")
		ok.String(*v.SourceFilterId)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterDropDownControl(v *types.FilterDropDownControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CascadingControlConfiguration != nil {
		ok := object.Key("CascadingControlConfiguration")
		if err := awsRestjson1_serializeDocumentCascadingControlConfiguration(v.CascadingControlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentDropDownControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.FilterControlId != nil {
		ok := object.Key("FilterControlId")
		ok.String(*v.FilterControlId)
	}

	if v.SelectableValues != nil {
		ok := object.Key("SelectableValues")
		if err := awsRestjson1_serializeDocumentFilterSelectableValues(v.SelectableValues, ok); err != nil {
			return err
		}
	}

	if v.SourceFilterId != nil {
		ok := object.Key("SourceFilterId")
		ok.String(*v.SourceFilterId)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentFilteredVisualsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterGroup(v *types.FilterGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CrossDataset) > 0 {
		ok := object.Key("CrossDataset")
		ok.String(string(v.CrossDataset))
	}

	if v.FilterGroupId != nil {
		ok := object.Key("FilterGroupId")
		ok.String(*v.FilterGroupId)
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.ScopeConfiguration != nil {
		ok := object.Key("ScopeConfiguration")
		if err := awsRestjson1_serializeDocumentFilterScopeConfiguration(v.ScopeConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterGroupList(v []types.FilterGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFilterGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterList(v []types.Filter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterListConfiguration(v *types.FilterListConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryValues != nil {
		ok := object.Key("CategoryValues")
		if err := awsRestjson1_serializeDocumentCategoryValueList(v.CategoryValues, ok); err != nil {
			return err
		}
	}

	if len(v.MatchOperator) > 0 {
		ok := object.Key("MatchOperator")
		ok.String(string(v.MatchOperator))
	}

	if len(v.NullOption) > 0 {
		ok := object.Key("NullOption")
		ok.String(string(v.NullOption))
	}

	if len(v.SelectAllOptions) > 0 {
		ok := object.Key("SelectAllOptions")
		ok.String(string(v.SelectAllOptions))
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterListControl(v *types.FilterListControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CascadingControlConfiguration != nil {
		ok := object.Key("CascadingControlConfiguration")
		if err := awsRestjson1_serializeDocumentCascadingControlConfiguration(v.CascadingControlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentListControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.FilterControlId != nil {
		ok := object.Key("FilterControlId")
		ok.String(*v.FilterControlId)
	}

	if v.SelectableValues != nil {
		ok := object.Key("SelectableValues")
		if err := awsRestjson1_serializeDocumentFilterSelectableValues(v.SelectableValues, ok); err != nil {
			return err
		}
	}

	if v.SourceFilterId != nil {
		ok := object.Key("SourceFilterId")
		ok.String(*v.SourceFilterId)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterOperation(v *types.FilterOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionExpression != nil {
		ok := object.Key("ConditionExpression")
		ok.String(*v.ConditionExpression)
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterOperationSelectedFieldsConfiguration(v *types.FilterOperationSelectedFieldsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SelectedColumns != nil {
		ok := object.Key("SelectedColumns")
		if err := awsRestjson1_serializeDocumentCustomActionColumnList(v.SelectedColumns, ok); err != nil {
			return err
		}
	}

	if len(v.SelectedFieldOptions) > 0 {
		ok := object.Key("SelectedFieldOptions")
		ok.String(string(v.SelectedFieldOptions))
	}

	if v.SelectedFields != nil {
		ok := object.Key("SelectedFields")
		if err := awsRestjson1_serializeDocumentSelectedFieldList(v.SelectedFields, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterOperationTargetVisualsConfiguration(v *types.FilterOperationTargetVisualsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SameSheetTargetVisualConfiguration != nil {
		ok := object.Key("SameSheetTargetVisualConfiguration")
		if err := awsRestjson1_serializeDocumentSameSheetTargetVisualConfiguration(v.SameSheetTargetVisualConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterRelativeDateTimeControl(v *types.FilterRelativeDateTimeControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentRelativeDateTimeControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.FilterControlId != nil {
		ok := object.Key("FilterControlId")
		ok.String(*v.FilterControlId)
	}

	if v.SourceFilterId != nil {
		ok := object.Key("SourceFilterId")
		ok.String(*v.SourceFilterId)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterScopeConfiguration(v *types.FilterScopeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllSheets != nil {
		ok := object.Key("AllSheets")
		if err := awsRestjson1_serializeDocumentAllSheetsFilterScopeConfiguration(v.AllSheets, ok); err != nil {
			return err
		}
	}

	if v.SelectedSheets != nil {
		ok := object.Key("SelectedSheets")
		if err := awsRestjson1_serializeDocumentSelectedSheetsFilterScopeConfiguration(v.SelectedSheets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterSelectableValues(v *types.FilterSelectableValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentParameterSelectableValueList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterSliderControl(v *types.FilterSliderControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentSliderControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.FilterControlId != nil {
		ok := object.Key("FilterControlId")
		ok.String(*v.FilterControlId)
	}

	{
		ok := object.Key("MaximumValue")
		switch {
		case math.IsNaN(v.MaximumValue):
			ok.String("NaN")

		case math.IsInf(v.MaximumValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.MaximumValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.MaximumValue)

		}
	}

	{
		ok := object.Key("MinimumValue")
		switch {
		case math.IsNaN(v.MinimumValue):
			ok.String("NaN")

		case math.IsInf(v.MinimumValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.MinimumValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.MinimumValue)

		}
	}

	if v.SourceFilterId != nil {
		ok := object.Key("SourceFilterId")
		ok.String(*v.SourceFilterId)
	}

	{
		ok := object.Key("StepSize")
		switch {
		case math.IsNaN(v.StepSize):
			ok.String("NaN")

		case math.IsInf(v.StepSize, 1):
			ok.String("Infinity")

		case math.IsInf(v.StepSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.StepSize)

		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterTextAreaControl(v *types.FilterTextAreaControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Delimiter != nil {
		ok := object.Key("Delimiter")
		ok.String(*v.Delimiter)
	}

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentTextAreaControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.FilterControlId != nil {
		ok := object.Key("FilterControlId")
		ok.String(*v.FilterControlId)
	}

	if v.SourceFilterId != nil {
		ok := object.Key("SourceFilterId")
		ok.String(*v.SourceFilterId)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterTextFieldControl(v *types.FilterTextFieldControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentTextFieldControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.FilterControlId != nil {
		ok := object.Key("FilterControlId")
		ok.String(*v.FilterControlId)
	}

	if v.SourceFilterId != nil {
		ok := object.Key("SourceFilterId")
		ok.String(*v.SourceFilterId)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentFolderArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFolderColumnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFolderSearchFilter(v *types.FolderSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentFolderSearchFilterList(v []types.FolderSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFolderSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFont(v *types.Font, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FontFamily != nil {
		ok := object.Key("FontFamily")
		ok.String(*v.FontFamily)
	}

	return nil
}

func awsRestjson1_serializeDocumentFontConfiguration(v *types.FontConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FontColor != nil {
		ok := object.Key("FontColor")
		ok.String(*v.FontColor)
	}

	if len(v.FontDecoration) > 0 {
		ok := object.Key("FontDecoration")
		ok.String(string(v.FontDecoration))
	}

	if v.FontSize != nil {
		ok := object.Key("FontSize")
		if err := awsRestjson1_serializeDocumentFontSize(v.FontSize, ok); err != nil {
			return err
		}
	}

	if len(v.FontStyle) > 0 {
		ok := object.Key("FontStyle")
		ok.String(string(v.FontStyle))
	}

	if v.FontWeight != nil {
		ok := object.Key("FontWeight")
		if err := awsRestjson1_serializeDocumentFontWeight(v.FontWeight, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFontList(v []types.Font, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFont(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFontSize(v *types.FontSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Relative) > 0 {
		ok := object.Key("Relative")
		ok.String(string(v.Relative))
	}

	return nil
}

func awsRestjson1_serializeDocumentFontWeight(v *types.FontWeight, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	return nil
}

func awsRestjson1_serializeDocumentForecastComputation(v *types.ForecastComputation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputationId != nil {
		ok := object.Key("ComputationId")
		ok.String(*v.ComputationId)
	}

	if v.CustomSeasonalityValue != nil {
		ok := object.Key("CustomSeasonalityValue")
		ok.Integer(*v.CustomSeasonalityValue)
	}

	if v.LowerBoundary != nil {
		ok := object.Key("LowerBoundary")
		switch {
		case math.IsNaN(*v.LowerBoundary):
			ok.String("NaN")

		case math.IsInf(*v.LowerBoundary, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LowerBoundary, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LowerBoundary)

		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PeriodsBackward != nil {
		ok := object.Key("PeriodsBackward")
		ok.Integer(*v.PeriodsBackward)
	}

	if v.PeriodsForward != nil {
		ok := object.Key("PeriodsForward")
		ok.Integer(*v.PeriodsForward)
	}

	if v.PredictionInterval != nil {
		ok := object.Key("PredictionInterval")
		ok.Integer(*v.PredictionInterval)
	}

	if len(v.Seasonality) > 0 {
		ok := object.Key("Seasonality")
		ok.String(string(v.Seasonality))
	}

	if v.Time != nil {
		ok := object.Key("Time")
		if err := awsRestjson1_serializeDocumentDimensionField(v.Time, ok); err != nil {
			return err
		}
	}

	if v.UpperBoundary != nil {
		ok := object.Key("UpperBoundary")
		switch {
		case math.IsNaN(*v.UpperBoundary):
			ok.String("NaN")

		case math.IsInf(*v.UpperBoundary, 1):
			ok.String("Infinity")

		case math.IsInf(*v.UpperBoundary, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.UpperBoundary)

		}
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsRestjson1_serializeDocumentMeasureField(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentForecastConfiguration(v *types.ForecastConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ForecastProperties != nil {
		ok := object.Key("ForecastProperties")
		if err := awsRestjson1_serializeDocumentTimeBasedForecastProperties(v.ForecastProperties, ok); err != nil {
			return err
		}
	}

	if v.Scenario != nil {
		ok := object.Key("Scenario")
		if err := awsRestjson1_serializeDocumentForecastScenario(v.Scenario, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentForecastConfigurationList(v []types.ForecastConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentForecastConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentForecastScenario(v *types.ForecastScenario, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WhatIfPointScenario != nil {
		ok := object.Key("WhatIfPointScenario")
		if err := awsRestjson1_serializeDocumentWhatIfPointScenario(v.WhatIfPointScenario, ok); err != nil {
			return err
		}
	}

	if v.WhatIfRangeScenario != nil {
		ok := object.Key("WhatIfRangeScenario")
		if err := awsRestjson1_serializeDocumentWhatIfRangeScenario(v.WhatIfRangeScenario, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFormatConfiguration(v *types.FormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeFormatConfiguration != nil {
		ok := object.Key("DateTimeFormatConfiguration")
		if err := awsRestjson1_serializeDocumentDateTimeFormatConfiguration(v.DateTimeFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NumberFormatConfiguration != nil {
		ok := object.Key("NumberFormatConfiguration")
		if err := awsRestjson1_serializeDocumentNumberFormatConfiguration(v.NumberFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.StringFormatConfiguration != nil {
		ok := object.Key("StringFormatConfiguration")
		if err := awsRestjson1_serializeDocumentStringFormatConfiguration(v.StringFormatConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFreeFormLayoutCanvasSizeOptions(v *types.FreeFormLayoutCanvasSizeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScreenCanvasSizeOptions != nil {
		ok := object.Key("ScreenCanvasSizeOptions")
		if err := awsRestjson1_serializeDocumentFreeFormLayoutScreenCanvasSizeOptions(v.ScreenCanvasSizeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFreeFormLayoutConfiguration(v *types.FreeFormLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanvasSizeOptions != nil {
		ok := object.Key("CanvasSizeOptions")
		if err := awsRestjson1_serializeDocumentFreeFormLayoutCanvasSizeOptions(v.CanvasSizeOptions, ok); err != nil {
			return err
		}
	}

	if v.Elements != nil {
		ok := object.Key("Elements")
		if err := awsRestjson1_serializeDocumentFreeFromLayoutElementList(v.Elements, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFreeFormLayoutElement(v *types.FreeFormLayoutElement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackgroundStyle != nil {
		ok := object.Key("BackgroundStyle")
		if err := awsRestjson1_serializeDocumentFreeFormLayoutElementBackgroundStyle(v.BackgroundStyle, ok); err != nil {
			return err
		}
	}

	if v.BorderStyle != nil {
		ok := object.Key("BorderStyle")
		if err := awsRestjson1_serializeDocumentFreeFormLayoutElementBorderStyle(v.BorderStyle, ok); err != nil {
			return err
		}
	}

	if v.ElementId != nil {
		ok := object.Key("ElementId")
		ok.String(*v.ElementId)
	}

	if len(v.ElementType) > 0 {
		ok := object.Key("ElementType")
		ok.String(string(v.ElementType))
	}

	if v.Height != nil {
		ok := object.Key("Height")
		ok.String(*v.Height)
	}

	if v.LoadingAnimation != nil {
		ok := object.Key("LoadingAnimation")
		if err := awsRestjson1_serializeDocumentLoadingAnimation(v.LoadingAnimation, ok); err != nil {
			return err
		}
	}

	if v.RenderingRules != nil {
		ok := object.Key("RenderingRules")
		if err := awsRestjson1_serializeDocumentSheetElementRenderingRuleList(v.RenderingRules, ok); err != nil {
			return err
		}
	}

	if v.SelectedBorderStyle != nil {
		ok := object.Key("SelectedBorderStyle")
		if err := awsRestjson1_serializeDocumentFreeFormLayoutElementBorderStyle(v.SelectedBorderStyle, ok); err != nil {
			return err
		}
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	if v.Width != nil {
		ok := object.Key("Width")
		ok.String(*v.Width)
	}

	if v.XAxisLocation != nil {
		ok := object.Key("XAxisLocation")
		ok.String(*v.XAxisLocation)
	}

	if v.YAxisLocation != nil {
		ok := object.Key("YAxisLocation")
		ok.String(*v.YAxisLocation)
	}

	return nil
}

func awsRestjson1_serializeDocumentFreeFormLayoutElementBackgroundStyle(v *types.FreeFormLayoutElementBackgroundStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentFreeFormLayoutElementBorderStyle(v *types.FreeFormLayoutElementBorderStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentFreeFormLayoutScreenCanvasSizeOptions(v *types.FreeFormLayoutScreenCanvasSizeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OptimizedViewPortWidth != nil {
		ok := object.Key("OptimizedViewPortWidth")
		ok.String(*v.OptimizedViewPortWidth)
	}

	return nil
}

func awsRestjson1_serializeDocumentFreeFormSectionLayoutConfiguration(v *types.FreeFormSectionLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Elements != nil {
		ok := object.Key("Elements")
		if err := awsRestjson1_serializeDocumentFreeFromLayoutElementList(v.Elements, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFreeFromLayoutElementList(v []types.FreeFormLayoutElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFreeFormLayoutElement(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFunnelChartAggregatedFieldWells(v *types.FunnelChartAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("Category")
		if err := awsRestjson1_serializeDocumentFunnelChartDimensionFieldList(v.Category, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentFunnelChartMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFunnelChartConfiguration(v *types.FunnelChartConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryLabelOptions != nil {
		ok := object.Key("CategoryLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.CategoryLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.DataLabelOptions != nil {
		ok := object.Key("DataLabelOptions")
		if err := awsRestjson1_serializeDocumentFunnelChartDataLabelOptions(v.DataLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentFunnelChartFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentFunnelChartSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if v.ValueLabelOptions != nil {
		ok := object.Key("ValueLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.ValueLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFunnelChartDataLabelOptions(v *types.FunnelChartDataLabelOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CategoryLabelVisibility) > 0 {
		ok := object.Key("CategoryLabelVisibility")
		ok.String(string(v.CategoryLabelVisibility))
	}

	if v.LabelColor != nil {
		ok := object.Key("LabelColor")
		ok.String(*v.LabelColor)
	}

	if v.LabelFontConfiguration != nil {
		ok := object.Key("LabelFontConfiguration")
		if err := awsRestjson1_serializeDocumentFontConfiguration(v.LabelFontConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.MeasureDataLabelStyle) > 0 {
		ok := object.Key("MeasureDataLabelStyle")
		ok.String(string(v.MeasureDataLabelStyle))
	}

	if len(v.MeasureLabelVisibility) > 0 {
		ok := object.Key("MeasureLabelVisibility")
		ok.String(string(v.MeasureLabelVisibility))
	}

	if len(v.Position) > 0 {
		ok := object.Key("Position")
		ok.String(string(v.Position))
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentFunnelChartDimensionFieldList(v []types.DimensionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFunnelChartFieldWells(v *types.FunnelChartFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FunnelChartAggregatedFieldWells != nil {
		ok := object.Key("FunnelChartAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentFunnelChartAggregatedFieldWells(v.FunnelChartAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFunnelChartMeasureFieldList(v []types.MeasureField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMeasureField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFunnelChartSortConfiguration(v *types.FunnelChartSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryItemsLimit != nil {
		ok := object.Key("CategoryItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.CategoryItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.CategorySort != nil {
		ok := object.Key("CategorySort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.CategorySort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFunnelChartVisual(v *types.FunnelChartVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentFunnelChartConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentGaugeChartArcConditionalFormatting(v *types.GaugeChartArcConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ForegroundColor != nil {
		ok := object.Key("ForegroundColor")
		if err := awsRestjson1_serializeDocumentConditionalFormattingColor(v.ForegroundColor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGaugeChartColorConfiguration(v *types.GaugeChartColorConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackgroundColor != nil {
		ok := object.Key("BackgroundColor")
		ok.String(*v.BackgroundColor)
	}

	if v.ForegroundColor != nil {
		ok := object.Key("ForegroundColor")
		ok.String(*v.ForegroundColor)
	}

	return nil
}

func awsRestjson1_serializeDocumentGaugeChartConditionalFormatting(v *types.GaugeChartConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionalFormattingOptions != nil {
		ok := object.Key("ConditionalFormattingOptions")
		if err := awsRestjson1_serializeDocumentGaugeChartConditionalFormattingOptionList(v.ConditionalFormattingOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGaugeChartConditionalFormattingOption(v *types.GaugeChartConditionalFormattingOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arc != nil {
		ok := object.Key("Arc")
		if err := awsRestjson1_serializeDocumentGaugeChartArcConditionalFormatting(v.Arc, ok); err != nil {
			return err
		}
	}

	if v.PrimaryValue != nil {
		ok := object.Key("PrimaryValue")
		if err := awsRestjson1_serializeDocumentGaugeChartPrimaryValueConditionalFormatting(v.PrimaryValue, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGaugeChartConditionalFormattingOptionList(v []types.GaugeChartConditionalFormattingOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGaugeChartConditionalFormattingOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGaugeChartConfiguration(v *types.GaugeChartConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColorConfiguration != nil {
		ok := object.Key("ColorConfiguration")
		if err := awsRestjson1_serializeDocumentGaugeChartColorConfiguration(v.ColorConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DataLabels != nil {
		ok := object.Key("DataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.DataLabels, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentGaugeChartFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.GaugeChartOptions != nil {
		ok := object.Key("GaugeChartOptions")
		if err := awsRestjson1_serializeDocumentGaugeChartOptions(v.GaugeChartOptions, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.TooltipOptions != nil {
		ok := object.Key("TooltipOptions")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.TooltipOptions, ok); err != nil {
			return err
		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGaugeChartFieldWells(v *types.GaugeChartFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetValues != nil {
		ok := object.Key("TargetValues")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.TargetValues, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGaugeChartOptions(v *types.GaugeChartOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arc != nil {
		ok := object.Key("Arc")
		if err := awsRestjson1_serializeDocumentArcConfiguration(v.Arc, ok); err != nil {
			return err
		}
	}

	if v.ArcAxis != nil {
		ok := object.Key("ArcAxis")
		if err := awsRestjson1_serializeDocumentArcAxisConfiguration(v.ArcAxis, ok); err != nil {
			return err
		}
	}

	if v.Comparison != nil {
		ok := object.Key("Comparison")
		if err := awsRestjson1_serializeDocumentComparisonConfiguration(v.Comparison, ok); err != nil {
			return err
		}
	}

	if len(v.PrimaryValueDisplayType) > 0 {
		ok := object.Key("PrimaryValueDisplayType")
		ok.String(string(v.PrimaryValueDisplayType))
	}

	if v.PrimaryValueFontConfiguration != nil {
		ok := object.Key("PrimaryValueFontConfiguration")
		if err := awsRestjson1_serializeDocumentFontConfiguration(v.PrimaryValueFontConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGaugeChartPrimaryValueConditionalFormatting(v *types.GaugeChartPrimaryValueConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Icon != nil {
		ok := object.Key("Icon")
		if err := awsRestjson1_serializeDocumentConditionalFormattingIcon(v.Icon, ok); err != nil {
			return err
		}
	}

	if v.TextColor != nil {
		ok := object.Key("TextColor")
		if err := awsRestjson1_serializeDocumentConditionalFormattingColor(v.TextColor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGaugeChartVisual(v *types.GaugeChartVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentGaugeChartConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ConditionalFormatting != nil {
		ok := object.Key("ConditionalFormatting")
		if err := awsRestjson1_serializeDocumentGaugeChartConditionalFormatting(v.ConditionalFormatting, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentGeoSpatialColumnGroup(v *types.GeoSpatialColumnGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	if len(v.CountryCode) > 0 {
		ok := object.Key("CountryCode")
		ok.String(string(v.CountryCode))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialCoordinateBounds(v *types.GeospatialCoordinateBounds, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.East != nil {
		ok := object.Key("East")
		switch {
		case math.IsNaN(*v.East):
			ok.String("NaN")

		case math.IsInf(*v.East, 1):
			ok.String("Infinity")

		case math.IsInf(*v.East, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.East)

		}
	}

	if v.North != nil {
		ok := object.Key("North")
		switch {
		case math.IsNaN(*v.North):
			ok.String("NaN")

		case math.IsInf(*v.North, 1):
			ok.String("Infinity")

		case math.IsInf(*v.North, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.North)

		}
	}

	if v.South != nil {
		ok := object.Key("South")
		switch {
		case math.IsNaN(*v.South):
			ok.String("NaN")

		case math.IsInf(*v.South, 1):
			ok.String("Infinity")

		case math.IsInf(*v.South, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.South)

		}
	}

	if v.West != nil {
		ok := object.Key("West")
		switch {
		case math.IsNaN(*v.West):
			ok.String("NaN")

		case math.IsInf(*v.West, 1):
			ok.String("Infinity")

		case math.IsInf(*v.West, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.West)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialHeatmapColorScale(v *types.GeospatialHeatmapColorScale, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Colors != nil {
		ok := object.Key("Colors")
		if err := awsRestjson1_serializeDocumentGeospatialHeatmapDataColorList(v.Colors, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialHeatmapConfiguration(v *types.GeospatialHeatmapConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HeatmapColor != nil {
		ok := object.Key("HeatmapColor")
		if err := awsRestjson1_serializeDocumentGeospatialHeatmapColorScale(v.HeatmapColor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialHeatmapDataColor(v *types.GeospatialHeatmapDataColor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialHeatmapDataColorList(v []types.GeospatialHeatmapDataColor, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGeospatialHeatmapDataColor(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGeospatialMapAggregatedFieldWells(v *types.GeospatialMapAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Colors != nil {
		ok := object.Key("Colors")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Colors, ok); err != nil {
			return err
		}
	}

	if v.Geospatial != nil {
		ok := object.Key("Geospatial")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Geospatial, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialMapConfiguration(v *types.GeospatialMapConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentGeospatialMapFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if v.MapStyleOptions != nil {
		ok := object.Key("MapStyleOptions")
		if err := awsRestjson1_serializeDocumentGeospatialMapStyleOptions(v.MapStyleOptions, ok); err != nil {
			return err
		}
	}

	if v.PointStyleOptions != nil {
		ok := object.Key("PointStyleOptions")
		if err := awsRestjson1_serializeDocumentGeospatialPointStyleOptions(v.PointStyleOptions, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	if v.WindowOptions != nil {
		ok := object.Key("WindowOptions")
		if err := awsRestjson1_serializeDocumentGeospatialWindowOptions(v.WindowOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialMapFieldWells(v *types.GeospatialMapFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GeospatialMapAggregatedFieldWells != nil {
		ok := object.Key("GeospatialMapAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentGeospatialMapAggregatedFieldWells(v.GeospatialMapAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialMapStyleOptions(v *types.GeospatialMapStyleOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BaseMapStyle) > 0 {
		ok := object.Key("BaseMapStyle")
		ok.String(string(v.BaseMapStyle))
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialMapVisual(v *types.GeospatialMapVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentGeospatialMapConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialPointStyleOptions(v *types.GeospatialPointStyleOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterMarkerConfiguration != nil {
		ok := object.Key("ClusterMarkerConfiguration")
		if err := awsRestjson1_serializeDocumentClusterMarkerConfiguration(v.ClusterMarkerConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HeatmapConfiguration != nil {
		ok := object.Key("HeatmapConfiguration")
		if err := awsRestjson1_serializeDocumentGeospatialHeatmapConfiguration(v.HeatmapConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.SelectedPointStyle) > 0 {
		ok := object.Key("SelectedPointStyle")
		ok.String(string(v.SelectedPointStyle))
	}

	return nil
}

func awsRestjson1_serializeDocumentGeospatialWindowOptions(v *types.GeospatialWindowOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bounds != nil {
		ok := object.Key("Bounds")
		if err := awsRestjson1_serializeDocumentGeospatialCoordinateBounds(v.Bounds, ok); err != nil {
			return err
		}
	}

	if len(v.MapZoomMode) > 0 {
		ok := object.Key("MapZoomMode")
		ok.String(string(v.MapZoomMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentGlobalTableBorderOptions(v *types.GlobalTableBorderOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SideSpecificBorder != nil {
		ok := object.Key("SideSpecificBorder")
		if err := awsRestjson1_serializeDocumentTableSideBorderOptions(v.SideSpecificBorder, ok); err != nil {
			return err
		}
	}

	if v.UniformBorder != nil {
		ok := object.Key("UniformBorder")
		if err := awsRestjson1_serializeDocumentTableBorderOptions(v.UniformBorder, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGradientColor(v *types.GradientColor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Stops != nil {
		ok := object.Key("Stops")
		if err := awsRestjson1_serializeDocumentGradientStopList(v.Stops, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGradientStop(v *types.GradientStop, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if v.DataValue != nil {
		ok := object.Key("DataValue")
		switch {
		case math.IsNaN(*v.DataValue):
			ok.String("NaN")

		case math.IsInf(*v.DataValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.DataValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.DataValue)

		}
	}

	{
		ok := object.Key("GradientOffset")
		switch {
		case math.IsNaN(v.GradientOffset):
			ok.String("NaN")

		case math.IsInf(v.GradientOffset, 1):
			ok.String("Infinity")

		case math.IsInf(v.GradientOffset, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.GradientOffset)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGradientStopList(v []types.GradientStop, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGradientStop(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGridLayoutCanvasSizeOptions(v *types.GridLayoutCanvasSizeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScreenCanvasSizeOptions != nil {
		ok := object.Key("ScreenCanvasSizeOptions")
		if err := awsRestjson1_serializeDocumentGridLayoutScreenCanvasSizeOptions(v.ScreenCanvasSizeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGridLayoutConfiguration(v *types.GridLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanvasSizeOptions != nil {
		ok := object.Key("CanvasSizeOptions")
		if err := awsRestjson1_serializeDocumentGridLayoutCanvasSizeOptions(v.CanvasSizeOptions, ok); err != nil {
			return err
		}
	}

	if v.Elements != nil {
		ok := object.Key("Elements")
		if err := awsRestjson1_serializeDocumentGridLayoutElementList(v.Elements, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGridLayoutElement(v *types.GridLayoutElement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnIndex != nil {
		ok := object.Key("ColumnIndex")
		ok.Integer(*v.ColumnIndex)
	}

	if v.ColumnSpan != nil {
		ok := object.Key("ColumnSpan")
		ok.Integer(*v.ColumnSpan)
	}

	if v.ElementId != nil {
		ok := object.Key("ElementId")
		ok.String(*v.ElementId)
	}

	if len(v.ElementType) > 0 {
		ok := object.Key("ElementType")
		ok.String(string(v.ElementType))
	}

	if v.RowIndex != nil {
		ok := object.Key("RowIndex")
		ok.Integer(*v.RowIndex)
	}

	if v.RowSpan != nil {
		ok := object.Key("RowSpan")
		ok.Integer(*v.RowSpan)
	}

	return nil
}

func awsRestjson1_serializeDocumentGridLayoutElementList(v []types.GridLayoutElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGridLayoutElement(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGridLayoutScreenCanvasSizeOptions(v *types.GridLayoutScreenCanvasSizeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OptimizedViewPortWidth != nil {
		ok := object.Key("OptimizedViewPortWidth")
		ok.String(*v.OptimizedViewPortWidth)
	}

	if len(v.ResizeOption) > 0 {
		ok := object.Key("ResizeOption")
		ok.String(string(v.ResizeOption))
	}

	return nil
}

func awsRestjson1_serializeDocumentGroupSearchFilter(v *types.GroupSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentGroupSearchFilterList(v []types.GroupSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGroupSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGroupsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentGrowthRateComputation(v *types.GrowthRateComputation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputationId != nil {
		ok := object.Key("ComputationId")
		ok.String(*v.ComputationId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PeriodSize != nil {
		ok := object.Key("PeriodSize")
		ok.Integer(*v.PeriodSize)
	}

	if v.Time != nil {
		ok := object.Key("Time")
		if err := awsRestjson1_serializeDocumentDimensionField(v.Time, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsRestjson1_serializeDocumentMeasureField(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGutterStyle(v *types.GutterStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Show != nil {
		ok := object.Key("Show")
		ok.Boolean(*v.Show)
	}

	return nil
}

func awsRestjson1_serializeDocumentHeaderFooterSectionConfiguration(v *types.HeaderFooterSectionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Layout != nil {
		ok := object.Key("Layout")
		if err := awsRestjson1_serializeDocumentSectionLayoutConfiguration(v.Layout, ok); err != nil {
			return err
		}
	}

	if v.SectionId != nil {
		ok := object.Key("SectionId")
		ok.String(*v.SectionId)
	}

	if v.Style != nil {
		ok := object.Key("Style")
		if err := awsRestjson1_serializeDocumentSectionStyle(v.Style, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHeaderFooterSectionConfigurationList(v []types.HeaderFooterSectionConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHeaderFooterSectionConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHeatMapAggregatedFieldWells(v *types.HeatMapAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentHeatMapDimensionFieldList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.Rows != nil {
		ok := object.Key("Rows")
		if err := awsRestjson1_serializeDocumentHeatMapDimensionFieldList(v.Rows, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentHeatMapMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHeatMapConfiguration(v *types.HeatMapConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColorScale != nil {
		ok := object.Key("ColorScale")
		if err := awsRestjson1_serializeDocumentColorScale(v.ColorScale, ok); err != nil {
			return err
		}
	}

	if v.ColumnLabelOptions != nil {
		ok := object.Key("ColumnLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.ColumnLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.DataLabels != nil {
		ok := object.Key("DataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.DataLabels, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentHeatMapFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if v.RowLabelOptions != nil {
		ok := object.Key("RowLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.RowLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentHeatMapSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHeatMapDimensionFieldList(v []types.DimensionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHeatMapFieldWells(v *types.HeatMapFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HeatMapAggregatedFieldWells != nil {
		ok := object.Key("HeatMapAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentHeatMapAggregatedFieldWells(v.HeatMapAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHeatMapMeasureFieldList(v []types.MeasureField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMeasureField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHeatMapSortConfiguration(v *types.HeatMapSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HeatMapColumnItemsLimitConfiguration != nil {
		ok := object.Key("HeatMapColumnItemsLimitConfiguration")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.HeatMapColumnItemsLimitConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HeatMapColumnSort != nil {
		ok := object.Key("HeatMapColumnSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.HeatMapColumnSort, ok); err != nil {
			return err
		}
	}

	if v.HeatMapRowItemsLimitConfiguration != nil {
		ok := object.Key("HeatMapRowItemsLimitConfiguration")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.HeatMapRowItemsLimitConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HeatMapRowSort != nil {
		ok := object.Key("HeatMapRowSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.HeatMapRowSort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHeatMapVisual(v *types.HeatMapVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentHeatMapConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentHistogramAggregatedFieldWells(v *types.HistogramAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentHistogramMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHistogramBinOptions(v *types.HistogramBinOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BinCount != nil {
		ok := object.Key("BinCount")
		if err := awsRestjson1_serializeDocumentBinCountOptions(v.BinCount, ok); err != nil {
			return err
		}
	}

	if v.BinWidth != nil {
		ok := object.Key("BinWidth")
		if err := awsRestjson1_serializeDocumentBinWidthOptions(v.BinWidth, ok); err != nil {
			return err
		}
	}

	if len(v.SelectedBinType) > 0 {
		ok := object.Key("SelectedBinType")
		ok.String(string(v.SelectedBinType))
	}

	if v.StartValue != nil {
		ok := object.Key("StartValue")
		switch {
		case math.IsNaN(*v.StartValue):
			ok.String("NaN")

		case math.IsInf(*v.StartValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.StartValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.StartValue)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHistogramConfiguration(v *types.HistogramConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BinOptions != nil {
		ok := object.Key("BinOptions")
		if err := awsRestjson1_serializeDocumentHistogramBinOptions(v.BinOptions, ok); err != nil {
			return err
		}
	}

	if v.DataLabels != nil {
		ok := object.Key("DataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.DataLabels, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentHistogramFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	if v.XAxisDisplayOptions != nil {
		ok := object.Key("XAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.XAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.XAxisLabelOptions != nil {
		ok := object.Key("XAxisLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.XAxisLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.YAxisDisplayOptions != nil {
		ok := object.Key("YAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.YAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHistogramFieldWells(v *types.HistogramFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HistogramAggregatedFieldWells != nil {
		ok := object.Key("HistogramAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentHistogramAggregatedFieldWells(v.HistogramAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHistogramMeasureFieldList(v []types.MeasureField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMeasureField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHistogramVisual(v *types.HistogramVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentHistogramConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentIdentityCenterConfiguration(v *types.IdentityCenterConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableIdentityPropagation != nil {
		ok := object.Key("EnableIdentityPropagation")
		ok.Boolean(*v.EnableIdentityPropagation)
	}

	return nil
}

func awsRestjson1_serializeDocumentIdentityMap(v map[string][]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentIdentityNameList(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIdentityNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentIncrementalRefresh(v *types.IncrementalRefresh, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LookbackWindow != nil {
		ok := object.Key("LookbackWindow")
		if err := awsRestjson1_serializeDocumentLookbackWindow(v.LookbackWindow, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputColumn(v *types.InputColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.SubType) > 0 {
		ok := object.Key("SubType")
		ok.String(string(v.SubType))
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentInputColumnList(v []types.InputColumn, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentInsightConfiguration(v *types.InsightConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Computations != nil {
		ok := object.Key("Computations")
		if err := awsRestjson1_serializeDocumentComputationList(v.Computations, ok); err != nil {
			return err
		}
	}

	if v.CustomNarrative != nil {
		ok := object.Key("CustomNarrative")
		if err := awsRestjson1_serializeDocumentCustomNarrativeOptions(v.CustomNarrative, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInsightVisual(v *types.InsightVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.DataSetIdentifier != nil {
		ok := object.Key("DataSetIdentifier")
		ok.String(*v.DataSetIdentifier)
	}

	if v.InsightConfiguration != nil {
		ok := object.Key("InsightConfiguration")
		if err := awsRestjson1_serializeDocumentInsightConfiguration(v.InsightConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegerDatasetParameter(v *types.IntegerDatasetParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValues != nil {
		ok := object.Key("DefaultValues")
		if err := awsRestjson1_serializeDocumentIntegerDatasetParameterDefaultValues(v.DefaultValues, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.ValueType) > 0 {
		ok := object.Key("ValueType")
		ok.String(string(v.ValueType))
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegerDatasetParameterDefaultValues(v *types.IntegerDatasetParameterDefaultValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StaticValues != nil {
		ok := object.Key("StaticValues")
		if err := awsRestjson1_serializeDocumentIntegerDatasetParameterValueList(v.StaticValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegerDatasetParameterValueList(v []int64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Long(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentIntegerDefaultValueList(v []int64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Long(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentIntegerDefaultValues(v *types.IntegerDefaultValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DynamicValue != nil {
		ok := object.Key("DynamicValue")
		if err := awsRestjson1_serializeDocumentDynamicDefaultValue(v.DynamicValue, ok); err != nil {
			return err
		}
	}

	if v.StaticValues != nil {
		ok := object.Key("StaticValues")
		if err := awsRestjson1_serializeDocumentIntegerDefaultValueList(v.StaticValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegerParameter(v *types.IntegerParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentSensitiveLongList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegerParameterDeclaration(v *types.IntegerParameterDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValues != nil {
		ok := object.Key("DefaultValues")
		if err := awsRestjson1_serializeDocumentIntegerDefaultValues(v.DefaultValues, ok); err != nil {
			return err
		}
	}

	if v.MappedDataSetParameters != nil {
		ok := object.Key("MappedDataSetParameters")
		if err := awsRestjson1_serializeDocumentMappedDataSetParameters(v.MappedDataSetParameters, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.ParameterValueType) > 0 {
		ok := object.Key("ParameterValueType")
		ok.String(string(v.ParameterValueType))
	}

	if v.ValueWhenUnset != nil {
		ok := object.Key("ValueWhenUnset")
		if err := awsRestjson1_serializeDocumentIntegerValueWhenUnsetConfiguration(v.ValueWhenUnset, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegerParameterList(v []types.IntegerParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIntegerParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIntegerValueWhenUnsetConfiguration(v *types.IntegerValueWhenUnsetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomValue != nil {
		ok := object.Key("CustomValue")
		ok.Long(*v.CustomValue)
	}

	if len(v.ValueWhenUnsetOption) > 0 {
		ok := object.Key("ValueWhenUnsetOption")
		ok.String(string(v.ValueWhenUnsetOption))
	}

	return nil
}

func awsRestjson1_serializeDocumentIpRestrictionRuleMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentItemsLimitConfiguration(v *types.ItemsLimitConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ItemsLimit != nil {
		ok := object.Key("ItemsLimit")
		ok.Long(*v.ItemsLimit)
	}

	if len(v.OtherCategories) > 0 {
		ok := object.Key("OtherCategories")
		ok.String(string(v.OtherCategories))
	}

	return nil
}

func awsRestjson1_serializeDocumentJiraParameters(v *types.JiraParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SiteBaseUrl != nil {
		ok := object.Key("SiteBaseUrl")
		ok.String(*v.SiteBaseUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentJoinInstruction(v *types.JoinInstruction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LeftJoinKeyProperties != nil {
		ok := object.Key("LeftJoinKeyProperties")
		if err := awsRestjson1_serializeDocumentJoinKeyProperties(v.LeftJoinKeyProperties, ok); err != nil {
			return err
		}
	}

	if v.LeftOperand != nil {
		ok := object.Key("LeftOperand")
		ok.String(*v.LeftOperand)
	}

	if v.OnClause != nil {
		ok := object.Key("OnClause")
		ok.String(*v.OnClause)
	}

	if v.RightJoinKeyProperties != nil {
		ok := object.Key("RightJoinKeyProperties")
		if err := awsRestjson1_serializeDocumentJoinKeyProperties(v.RightJoinKeyProperties, ok); err != nil {
			return err
		}
	}

	if v.RightOperand != nil {
		ok := object.Key("RightOperand")
		ok.String(*v.RightOperand)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentJoinKeyProperties(v *types.JoinKeyProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UniqueKey != nil {
		ok := object.Key("UniqueKey")
		ok.Boolean(*v.UniqueKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentKeyRegistration(v []types.RegisteredCustomerManagedKey, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRegisteredCustomerManagedKey(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentKPIActualValueConditionalFormatting(v *types.KPIActualValueConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Icon != nil {
		ok := object.Key("Icon")
		if err := awsRestjson1_serializeDocumentConditionalFormattingIcon(v.Icon, ok); err != nil {
			return err
		}
	}

	if v.TextColor != nil {
		ok := object.Key("TextColor")
		if err := awsRestjson1_serializeDocumentConditionalFormattingColor(v.TextColor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIComparisonValueConditionalFormatting(v *types.KPIComparisonValueConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Icon != nil {
		ok := object.Key("Icon")
		if err := awsRestjson1_serializeDocumentConditionalFormattingIcon(v.Icon, ok); err != nil {
			return err
		}
	}

	if v.TextColor != nil {
		ok := object.Key("TextColor")
		if err := awsRestjson1_serializeDocumentConditionalFormattingColor(v.TextColor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIConditionalFormatting(v *types.KPIConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionalFormattingOptions != nil {
		ok := object.Key("ConditionalFormattingOptions")
		if err := awsRestjson1_serializeDocumentKPIConditionalFormattingOptionList(v.ConditionalFormattingOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIConditionalFormattingOption(v *types.KPIConditionalFormattingOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActualValue != nil {
		ok := object.Key("ActualValue")
		if err := awsRestjson1_serializeDocumentKPIActualValueConditionalFormatting(v.ActualValue, ok); err != nil {
			return err
		}
	}

	if v.ComparisonValue != nil {
		ok := object.Key("ComparisonValue")
		if err := awsRestjson1_serializeDocumentKPIComparisonValueConditionalFormatting(v.ComparisonValue, ok); err != nil {
			return err
		}
	}

	if v.PrimaryValue != nil {
		ok := object.Key("PrimaryValue")
		if err := awsRestjson1_serializeDocumentKPIPrimaryValueConditionalFormatting(v.PrimaryValue, ok); err != nil {
			return err
		}
	}

	if v.ProgressBar != nil {
		ok := object.Key("ProgressBar")
		if err := awsRestjson1_serializeDocumentKPIProgressBarConditionalFormatting(v.ProgressBar, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIConditionalFormattingOptionList(v []types.KPIConditionalFormattingOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentKPIConditionalFormattingOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentKPIConfiguration(v *types.KPIConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentKPIFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.KPIOptions != nil {
		ok := object.Key("KPIOptions")
		if err := awsRestjson1_serializeDocumentKPIOptions(v.KPIOptions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentKPISortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIFieldWells(v *types.KPIFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetValues != nil {
		ok := object.Key("TargetValues")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.TargetValues, ok); err != nil {
			return err
		}
	}

	if v.TrendGroups != nil {
		ok := object.Key("TrendGroups")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.TrendGroups, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIOptions(v *types.KPIOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comparison != nil {
		ok := object.Key("Comparison")
		if err := awsRestjson1_serializeDocumentComparisonConfiguration(v.Comparison, ok); err != nil {
			return err
		}
	}

	if len(v.PrimaryValueDisplayType) > 0 {
		ok := object.Key("PrimaryValueDisplayType")
		ok.String(string(v.PrimaryValueDisplayType))
	}

	if v.PrimaryValueFontConfiguration != nil {
		ok := object.Key("PrimaryValueFontConfiguration")
		if err := awsRestjson1_serializeDocumentFontConfiguration(v.PrimaryValueFontConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ProgressBar != nil {
		ok := object.Key("ProgressBar")
		if err := awsRestjson1_serializeDocumentProgressBarOptions(v.ProgressBar, ok); err != nil {
			return err
		}
	}

	if v.SecondaryValue != nil {
		ok := object.Key("SecondaryValue")
		if err := awsRestjson1_serializeDocumentSecondaryValueOptions(v.SecondaryValue, ok); err != nil {
			return err
		}
	}

	if v.SecondaryValueFontConfiguration != nil {
		ok := object.Key("SecondaryValueFontConfiguration")
		if err := awsRestjson1_serializeDocumentFontConfiguration(v.SecondaryValueFontConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Sparkline != nil {
		ok := object.Key("Sparkline")
		if err := awsRestjson1_serializeDocumentKPISparklineOptions(v.Sparkline, ok); err != nil {
			return err
		}
	}

	if v.TrendArrows != nil {
		ok := object.Key("TrendArrows")
		if err := awsRestjson1_serializeDocumentTrendArrowOptions(v.TrendArrows, ok); err != nil {
			return err
		}
	}

	if v.VisualLayoutOptions != nil {
		ok := object.Key("VisualLayoutOptions")
		if err := awsRestjson1_serializeDocumentKPIVisualLayoutOptions(v.VisualLayoutOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIPrimaryValueConditionalFormatting(v *types.KPIPrimaryValueConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Icon != nil {
		ok := object.Key("Icon")
		if err := awsRestjson1_serializeDocumentConditionalFormattingIcon(v.Icon, ok); err != nil {
			return err
		}
	}

	if v.TextColor != nil {
		ok := object.Key("TextColor")
		if err := awsRestjson1_serializeDocumentConditionalFormattingColor(v.TextColor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIProgressBarConditionalFormatting(v *types.KPIProgressBarConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ForegroundColor != nil {
		ok := object.Key("ForegroundColor")
		if err := awsRestjson1_serializeDocumentConditionalFormattingColor(v.ForegroundColor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPISortConfiguration(v *types.KPISortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TrendGroupSort != nil {
		ok := object.Key("TrendGroupSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.TrendGroupSort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPISparklineOptions(v *types.KPISparklineOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if len(v.TooltipVisibility) > 0 {
		ok := object.Key("TooltipVisibility")
		ok.String(string(v.TooltipVisibility))
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIVisual(v *types.KPIVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentKPIConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.ConditionalFormatting != nil {
		ok := object.Key("ConditionalFormatting")
		if err := awsRestjson1_serializeDocumentKPIConditionalFormatting(v.ConditionalFormatting, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIVisualLayoutOptions(v *types.KPIVisualLayoutOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StandardLayout != nil {
		ok := object.Key("StandardLayout")
		if err := awsRestjson1_serializeDocumentKPIVisualStandardLayout(v.StandardLayout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKPIVisualStandardLayout(v *types.KPIVisualStandardLayout, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentLabelOptions(v *types.LabelOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLabel != nil {
		ok := object.Key("CustomLabel")
		ok.String(*v.CustomLabel)
	}

	if v.FontConfiguration != nil {
		ok := object.Key("FontConfiguration")
		if err := awsRestjson1_serializeDocumentFontConfiguration(v.FontConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentLayout(v *types.Layout, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsRestjson1_serializeDocumentLayoutConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLayoutConfiguration(v *types.LayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FreeFormLayout != nil {
		ok := object.Key("FreeFormLayout")
		if err := awsRestjson1_serializeDocumentFreeFormLayoutConfiguration(v.FreeFormLayout, ok); err != nil {
			return err
		}
	}

	if v.GridLayout != nil {
		ok := object.Key("GridLayout")
		if err := awsRestjson1_serializeDocumentGridLayoutConfiguration(v.GridLayout, ok); err != nil {
			return err
		}
	}

	if v.SectionBasedLayout != nil {
		ok := object.Key("SectionBasedLayout")
		if err := awsRestjson1_serializeDocumentSectionBasedLayoutConfiguration(v.SectionBasedLayout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLayoutList(v []types.Layout, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentLayout(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLegendOptions(v *types.LegendOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Height != nil {
		ok := object.Key("Height")
		ok.String(*v.Height)
	}

	if len(v.Position) > 0 {
		ok := object.Key("Position")
		ok.String(string(v.Position))
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	if v.Width != nil {
		ok := object.Key("Width")
		ok.String(*v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentLineChartAggregatedFieldWells(v *types.LineChartAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("Category")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Category, ok); err != nil {
			return err
		}
	}

	if v.Colors != nil {
		ok := object.Key("Colors")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Colors, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiples != nil {
		ok := object.Key("SmallMultiples")
		if err := awsRestjson1_serializeDocumentSmallMultiplesDimensionFieldList(v.SmallMultiples, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLineChartConfiguration(v *types.LineChartConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContributionAnalysisDefaults != nil {
		ok := object.Key("ContributionAnalysisDefaults")
		if err := awsRestjson1_serializeDocumentContributionAnalysisDefaultList(v.ContributionAnalysisDefaults, ok); err != nil {
			return err
		}
	}

	if v.DataLabels != nil {
		ok := object.Key("DataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.DataLabels, ok); err != nil {
			return err
		}
	}

	if v.DefaultSeriesSettings != nil {
		ok := object.Key("DefaultSeriesSettings")
		if err := awsRestjson1_serializeDocumentLineChartDefaultSeriesSettings(v.DefaultSeriesSettings, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentLineChartFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.ForecastConfigurations != nil {
		ok := object.Key("ForecastConfigurations")
		if err := awsRestjson1_serializeDocumentForecastConfigurationList(v.ForecastConfigurations, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if v.PrimaryYAxisDisplayOptions != nil {
		ok := object.Key("PrimaryYAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentLineSeriesAxisDisplayOptions(v.PrimaryYAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.PrimaryYAxisLabelOptions != nil {
		ok := object.Key("PrimaryYAxisLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.PrimaryYAxisLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.ReferenceLines != nil {
		ok := object.Key("ReferenceLines")
		if err := awsRestjson1_serializeDocumentReferenceLineList(v.ReferenceLines, ok); err != nil {
			return err
		}
	}

	if v.SecondaryYAxisDisplayOptions != nil {
		ok := object.Key("SecondaryYAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentLineSeriesAxisDisplayOptions(v.SecondaryYAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.SecondaryYAxisLabelOptions != nil {
		ok := object.Key("SecondaryYAxisLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.SecondaryYAxisLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.Series != nil {
		ok := object.Key("Series")
		if err := awsRestjson1_serializeDocumentSeriesItemList(v.Series, ok); err != nil {
			return err
		}
	}

	if v.SingleAxisOptions != nil {
		ok := object.Key("SingleAxisOptions")
		if err := awsRestjson1_serializeDocumentSingleAxisOptions(v.SingleAxisOptions, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiplesOptions != nil {
		ok := object.Key("SmallMultiplesOptions")
		if err := awsRestjson1_serializeDocumentSmallMultiplesOptions(v.SmallMultiplesOptions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentLineChartSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	if v.XAxisDisplayOptions != nil {
		ok := object.Key("XAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.XAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.XAxisLabelOptions != nil {
		ok := object.Key("XAxisLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.XAxisLabelOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLineChartDefaultSeriesSettings(v *types.LineChartDefaultSeriesSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AxisBinding) > 0 {
		ok := object.Key("AxisBinding")
		ok.String(string(v.AxisBinding))
	}

	if v.LineStyleSettings != nil {
		ok := object.Key("LineStyleSettings")
		if err := awsRestjson1_serializeDocumentLineChartLineStyleSettings(v.LineStyleSettings, ok); err != nil {
			return err
		}
	}

	if v.MarkerStyleSettings != nil {
		ok := object.Key("MarkerStyleSettings")
		if err := awsRestjson1_serializeDocumentLineChartMarkerStyleSettings(v.MarkerStyleSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLineChartFieldWells(v *types.LineChartFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LineChartAggregatedFieldWells != nil {
		ok := object.Key("LineChartAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentLineChartAggregatedFieldWells(v.LineChartAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLineChartLineStyleSettings(v *types.LineChartLineStyleSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LineInterpolation) > 0 {
		ok := object.Key("LineInterpolation")
		ok.String(string(v.LineInterpolation))
	}

	if len(v.LineStyle) > 0 {
		ok := object.Key("LineStyle")
		ok.String(string(v.LineStyle))
	}

	if len(v.LineVisibility) > 0 {
		ok := object.Key("LineVisibility")
		ok.String(string(v.LineVisibility))
	}

	if v.LineWidth != nil {
		ok := object.Key("LineWidth")
		ok.String(*v.LineWidth)
	}

	return nil
}

func awsRestjson1_serializeDocumentLineChartMarkerStyleSettings(v *types.LineChartMarkerStyleSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MarkerColor != nil {
		ok := object.Key("MarkerColor")
		ok.String(*v.MarkerColor)
	}

	if len(v.MarkerShape) > 0 {
		ok := object.Key("MarkerShape")
		ok.String(string(v.MarkerShape))
	}

	if v.MarkerSize != nil {
		ok := object.Key("MarkerSize")
		ok.String(*v.MarkerSize)
	}

	if len(v.MarkerVisibility) > 0 {
		ok := object.Key("MarkerVisibility")
		ok.String(string(v.MarkerVisibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentLineChartSeriesSettings(v *types.LineChartSeriesSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LineStyleSettings != nil {
		ok := object.Key("LineStyleSettings")
		if err := awsRestjson1_serializeDocumentLineChartLineStyleSettings(v.LineStyleSettings, ok); err != nil {
			return err
		}
	}

	if v.MarkerStyleSettings != nil {
		ok := object.Key("MarkerStyleSettings")
		if err := awsRestjson1_serializeDocumentLineChartMarkerStyleSettings(v.MarkerStyleSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLineChartSortConfiguration(v *types.LineChartSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryItemsLimitConfiguration != nil {
		ok := object.Key("CategoryItemsLimitConfiguration")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.CategoryItemsLimitConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CategorySort != nil {
		ok := object.Key("CategorySort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.CategorySort, ok); err != nil {
			return err
		}
	}

	if v.ColorItemsLimitConfiguration != nil {
		ok := object.Key("ColorItemsLimitConfiguration")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.ColorItemsLimitConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiplesLimitConfiguration != nil {
		ok := object.Key("SmallMultiplesLimitConfiguration")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.SmallMultiplesLimitConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiplesSort != nil {
		ok := object.Key("SmallMultiplesSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.SmallMultiplesSort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLineChartVisual(v *types.LineChartVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentLineChartConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentLineSeriesAxisDisplayOptions(v *types.LineSeriesAxisDisplayOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AxisOptions != nil {
		ok := object.Key("AxisOptions")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.AxisOptions, ok); err != nil {
			return err
		}
	}

	if v.MissingDataConfigurations != nil {
		ok := object.Key("MissingDataConfigurations")
		if err := awsRestjson1_serializeDocumentMissingDataConfigurationList(v.MissingDataConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLinkEntityArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentLinkSharingConfiguration(v *types.LinkSharingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentListControlDisplayOptions(v *types.ListControlDisplayOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InfoIconLabelOptions != nil {
		ok := object.Key("InfoIconLabelOptions")
		if err := awsRestjson1_serializeDocumentSheetControlInfoIconLabelOptions(v.InfoIconLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.SearchOptions != nil {
		ok := object.Key("SearchOptions")
		if err := awsRestjson1_serializeDocumentListControlSearchOptions(v.SearchOptions, ok); err != nil {
			return err
		}
	}

	if v.SelectAllOptions != nil {
		ok := object.Key("SelectAllOptions")
		if err := awsRestjson1_serializeDocumentListControlSelectAllOptions(v.SelectAllOptions, ok); err != nil {
			return err
		}
	}

	if v.TitleOptions != nil {
		ok := object.Key("TitleOptions")
		if err := awsRestjson1_serializeDocumentLabelOptions(v.TitleOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentListControlSearchOptions(v *types.ListControlSearchOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentListControlSelectAllOptions(v *types.ListControlSelectAllOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentLoadingAnimation(v *types.LoadingAnimation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentLocalNavigationConfiguration(v *types.LocalNavigationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetSheetId != nil {
		ok := object.Key("TargetSheetId")
		ok.String(*v.TargetSheetId)
	}

	return nil
}

func awsRestjson1_serializeDocumentLogicalTable(v *types.LogicalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Alias != nil {
		ok := object.Key("Alias")
		ok.String(*v.Alias)
	}

	if v.DataTransforms != nil {
		ok := object.Key("DataTransforms")
		if err := awsRestjson1_serializeDocumentTransformOperationList(v.DataTransforms, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("Source")
		if err := awsRestjson1_serializeDocumentLogicalTableSource(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLogicalTableMap(v map[string]types.LogicalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentLogicalTable(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLogicalTableSource(v *types.LogicalTableSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetArn != nil {
		ok := object.Key("DataSetArn")
		ok.String(*v.DataSetArn)
	}

	if v.JoinInstruction != nil {
		ok := object.Key("JoinInstruction")
		if err := awsRestjson1_serializeDocumentJoinInstruction(v.JoinInstruction, ok); err != nil {
			return err
		}
	}

	if v.PhysicalTableId != nil {
		ok := object.Key("PhysicalTableId")
		ok.String(*v.PhysicalTableId)
	}

	return nil
}

func awsRestjson1_serializeDocumentLongFormatText(v *types.LongFormatText, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PlainText != nil {
		ok := object.Key("PlainText")
		ok.String(*v.PlainText)
	}

	if v.RichText != nil {
		ok := object.Key("RichText")
		ok.String(*v.RichText)
	}

	return nil
}

func awsRestjson1_serializeDocumentLookbackWindow(v *types.LookbackWindow, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.Size != nil {
		ok := object.Key("Size")
		ok.Long(*v.Size)
	}

	if len(v.SizeUnit) > 0 {
		ok := object.Key("SizeUnit")
		ok.String(string(v.SizeUnit))
	}

	return nil
}

func awsRestjson1_serializeDocumentManifestFileLocation(v *types.ManifestFileLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("Bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeDocumentMappedDataSetParameter(v *types.MappedDataSetParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetIdentifier != nil {
		ok := object.Key("DataSetIdentifier")
		ok.String(*v.DataSetIdentifier)
	}

	if v.DataSetParameterName != nil {
		ok := object.Key("DataSetParameterName")
		ok.String(*v.DataSetParameterName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMappedDataSetParameters(v []types.MappedDataSetParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMappedDataSetParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMarginStyle(v *types.MarginStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Show != nil {
		ok := object.Key("Show")
		ok.Boolean(*v.Show)
	}

	return nil
}

func awsRestjson1_serializeDocumentMariaDbParameters(v *types.MariaDbParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != nil {
		ok := object.Key("Port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentMaximumLabelType(v *types.MaximumLabelType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentMaximumMinimumComputation(v *types.MaximumMinimumComputation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputationId != nil {
		ok := object.Key("ComputationId")
		ok.String(*v.ComputationId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Time != nil {
		ok := object.Key("Time")
		if err := awsRestjson1_serializeDocumentDimensionField(v.Time, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsRestjson1_serializeDocumentMeasureField(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMeasureField(v *types.MeasureField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CalculatedMeasureField != nil {
		ok := object.Key("CalculatedMeasureField")
		if err := awsRestjson1_serializeDocumentCalculatedMeasureField(v.CalculatedMeasureField, ok); err != nil {
			return err
		}
	}

	if v.CategoricalMeasureField != nil {
		ok := object.Key("CategoricalMeasureField")
		if err := awsRestjson1_serializeDocumentCategoricalMeasureField(v.CategoricalMeasureField, ok); err != nil {
			return err
		}
	}

	if v.DateMeasureField != nil {
		ok := object.Key("DateMeasureField")
		if err := awsRestjson1_serializeDocumentDateMeasureField(v.DateMeasureField, ok); err != nil {
			return err
		}
	}

	if v.NumericalMeasureField != nil {
		ok := object.Key("NumericalMeasureField")
		if err := awsRestjson1_serializeDocumentNumericalMeasureField(v.NumericalMeasureField, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMeasureFieldList(v []types.MeasureField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMeasureField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMetricComparisonComputation(v *types.MetricComparisonComputation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputationId != nil {
		ok := object.Key("ComputationId")
		ok.String(*v.ComputationId)
	}

	if v.FromValue != nil {
		ok := object.Key("FromValue")
		if err := awsRestjson1_serializeDocumentMeasureField(v.FromValue, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.TargetValue != nil {
		ok := object.Key("TargetValue")
		if err := awsRestjson1_serializeDocumentMeasureField(v.TargetValue, ok); err != nil {
			return err
		}
	}

	if v.Time != nil {
		ok := object.Key("Time")
		if err := awsRestjson1_serializeDocumentDimensionField(v.Time, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMinimumLabelType(v *types.MinimumLabelType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentMissingDataConfiguration(v *types.MissingDataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.TreatmentOption) > 0 {
		ok := object.Key("TreatmentOption")
		ok.String(string(v.TreatmentOption))
	}

	return nil
}

func awsRestjson1_serializeDocumentMissingDataConfigurationList(v []types.MissingDataConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMissingDataConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMySqlParameters(v *types.MySqlParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != nil {
		ok := object.Key("Port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentNamedEntityDefinition(v *types.NamedEntityDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldName != nil {
		ok := object.Key("FieldName")
		ok.String(*v.FieldName)
	}

	if v.Metric != nil {
		ok := object.Key("Metric")
		if err := awsRestjson1_serializeDocumentNamedEntityDefinitionMetric(v.Metric, ok); err != nil {
			return err
		}
	}

	if v.PropertyName != nil {
		ok := object.Key("PropertyName")
		ok.String(*v.PropertyName)
	}

	if len(v.PropertyRole) > 0 {
		ok := object.Key("PropertyRole")
		ok.String(string(v.PropertyRole))
	}

	if len(v.PropertyUsage) > 0 {
		ok := object.Key("PropertyUsage")
		ok.String(string(v.PropertyUsage))
	}

	return nil
}

func awsRestjson1_serializeDocumentNamedEntityDefinitionMetric(v *types.NamedEntityDefinitionMetric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Aggregation) > 0 {
		ok := object.Key("Aggregation")
		ok.String(string(v.Aggregation))
	}

	if v.AggregationFunctionParameters != nil {
		ok := object.Key("AggregationFunctionParameters")
		if err := awsRestjson1_serializeDocumentAggregationFunctionParameters(v.AggregationFunctionParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNamedEntityDefinitions(v []types.NamedEntityDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNamedEntityDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNegativeFormat(v *types.NegativeFormat, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.Suffix != nil {
		ok := object.Key("Suffix")
		ok.String(*v.Suffix)
	}

	return nil
}

func awsRestjson1_serializeDocumentNegativeValueConfiguration(v *types.NegativeValueConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DisplayMode) > 0 {
		ok := object.Key("DisplayMode")
		ok.String(string(v.DisplayMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentNewDefaultValues(v *types.NewDefaultValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeStaticValues != nil {
		ok := object.Key("DateTimeStaticValues")
		if err := awsRestjson1_serializeDocumentDateTimeDatasetParameterValueList(v.DateTimeStaticValues, ok); err != nil {
			return err
		}
	}

	if v.DecimalStaticValues != nil {
		ok := object.Key("DecimalStaticValues")
		if err := awsRestjson1_serializeDocumentDecimalDatasetParameterValueList(v.DecimalStaticValues, ok); err != nil {
			return err
		}
	}

	if v.IntegerStaticValues != nil {
		ok := object.Key("IntegerStaticValues")
		if err := awsRestjson1_serializeDocumentIntegerDatasetParameterValueList(v.IntegerStaticValues, ok); err != nil {
			return err
		}
	}

	if v.StringStaticValues != nil {
		ok := object.Key("StringStaticValues")
		if err := awsRestjson1_serializeDocumentStringDatasetParameterValueList(v.StringStaticValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNullValueFormatConfiguration(v *types.NullValueFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NullString != nil {
		ok := object.Key("NullString")
		ok.String(*v.NullString)
	}

	return nil
}

func awsRestjson1_serializeDocumentNumberDisplayFormatConfiguration(v *types.NumberDisplayFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecimalPlacesConfiguration != nil {
		ok := object.Key("DecimalPlacesConfiguration")
		if err := awsRestjson1_serializeDocumentDecimalPlacesConfiguration(v.DecimalPlacesConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NegativeValueConfiguration != nil {
		ok := object.Key("NegativeValueConfiguration")
		if err := awsRestjson1_serializeDocumentNegativeValueConfiguration(v.NegativeValueConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NullValueFormatConfiguration != nil {
		ok := object.Key("NullValueFormatConfiguration")
		if err := awsRestjson1_serializeDocumentNullValueFormatConfiguration(v.NullValueFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.NumberScale) > 0 {
		ok := object.Key("NumberScale")
		ok.String(string(v.NumberScale))
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.SeparatorConfiguration != nil {
		ok := object.Key("SeparatorConfiguration")
		if err := awsRestjson1_serializeDocumentNumericSeparatorConfiguration(v.SeparatorConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Suffix != nil {
		ok := object.Key("Suffix")
		ok.String(*v.Suffix)
	}

	return nil
}

func awsRestjson1_serializeDocumentNumberFormatConfiguration(v *types.NumberFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FormatConfiguration != nil {
		ok := object.Key("FormatConfiguration")
		if err := awsRestjson1_serializeDocumentNumericFormatConfiguration(v.FormatConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericalAggregationFunction(v *types.NumericalAggregationFunction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PercentileAggregation != nil {
		ok := object.Key("PercentileAggregation")
		if err := awsRestjson1_serializeDocumentPercentileAggregation(v.PercentileAggregation, ok); err != nil {
			return err
		}
	}

	if len(v.SimpleNumericalAggregation) > 0 {
		ok := object.Key("SimpleNumericalAggregation")
		ok.String(string(v.SimpleNumericalAggregation))
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericalDimensionField(v *types.NumericalDimensionField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.FormatConfiguration != nil {
		ok := object.Key("FormatConfiguration")
		if err := awsRestjson1_serializeDocumentNumberFormatConfiguration(v.FormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HierarchyId != nil {
		ok := object.Key("HierarchyId")
		ok.String(*v.HierarchyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericalMeasureField(v *types.NumericalMeasureField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationFunction != nil {
		ok := object.Key("AggregationFunction")
		if err := awsRestjson1_serializeDocumentNumericalAggregationFunction(v.AggregationFunction, ok); err != nil {
			return err
		}
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.FormatConfiguration != nil {
		ok := object.Key("FormatConfiguration")
		if err := awsRestjson1_serializeDocumentNumberFormatConfiguration(v.FormatConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericAxisOptions(v *types.NumericAxisOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Range != nil {
		ok := object.Key("Range")
		if err := awsRestjson1_serializeDocumentAxisDisplayRange(v.Range, ok); err != nil {
			return err
		}
	}

	if v.Scale != nil {
		ok := object.Key("Scale")
		if err := awsRestjson1_serializeDocumentAxisScale(v.Scale, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericEqualityDrillDownFilter(v *types.NumericEqualityDrillDownFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("Value")
		switch {
		case math.IsNaN(v.Value):
			ok.String("NaN")

		case math.IsInf(v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericEqualityFilter(v *types.NumericEqualityFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationFunction != nil {
		ok := object.Key("AggregationFunction")
		if err := awsRestjson1_serializeDocumentAggregationFunction(v.AggregationFunction, ok); err != nil {
			return err
		}
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.DefaultFilterControlConfiguration != nil {
		ok := object.Key("DefaultFilterControlConfiguration")
		if err := awsRestjson1_serializeDocumentDefaultFilterControlConfiguration(v.DefaultFilterControlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FilterId != nil {
		ok := object.Key("FilterId")
		ok.String(*v.FilterId)
	}

	if len(v.MatchOperator) > 0 {
		ok := object.Key("MatchOperator")
		ok.String(string(v.MatchOperator))
	}

	if len(v.NullOption) > 0 {
		ok := object.Key("NullOption")
		ok.String(string(v.NullOption))
	}

	if v.ParameterName != nil {
		ok := object.Key("ParameterName")
		ok.String(*v.ParameterName)
	}

	if len(v.SelectAllOptions) > 0 {
		ok := object.Key("SelectAllOptions")
		ok.String(string(v.SelectAllOptions))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		switch {
		case math.IsNaN(*v.Value):
			ok.String("NaN")

		case math.IsInf(*v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericFormatConfiguration(v *types.NumericFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CurrencyDisplayFormatConfiguration != nil {
		ok := object.Key("CurrencyDisplayFormatConfiguration")
		if err := awsRestjson1_serializeDocumentCurrencyDisplayFormatConfiguration(v.CurrencyDisplayFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NumberDisplayFormatConfiguration != nil {
		ok := object.Key("NumberDisplayFormatConfiguration")
		if err := awsRestjson1_serializeDocumentNumberDisplayFormatConfiguration(v.NumberDisplayFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PercentageDisplayFormatConfiguration != nil {
		ok := object.Key("PercentageDisplayFormatConfiguration")
		if err := awsRestjson1_serializeDocumentPercentageDisplayFormatConfiguration(v.PercentageDisplayFormatConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericRangeFilter(v *types.NumericRangeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationFunction != nil {
		ok := object.Key("AggregationFunction")
		if err := awsRestjson1_serializeDocumentAggregationFunction(v.AggregationFunction, ok); err != nil {
			return err
		}
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.DefaultFilterControlConfiguration != nil {
		ok := object.Key("DefaultFilterControlConfiguration")
		if err := awsRestjson1_serializeDocumentDefaultFilterControlConfiguration(v.DefaultFilterControlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FilterId != nil {
		ok := object.Key("FilterId")
		ok.String(*v.FilterId)
	}

	if v.IncludeMaximum != nil {
		ok := object.Key("IncludeMaximum")
		ok.Boolean(*v.IncludeMaximum)
	}

	if v.IncludeMinimum != nil {
		ok := object.Key("IncludeMinimum")
		ok.Boolean(*v.IncludeMinimum)
	}

	if len(v.NullOption) > 0 {
		ok := object.Key("NullOption")
		ok.String(string(v.NullOption))
	}

	if v.RangeMaximum != nil {
		ok := object.Key("RangeMaximum")
		if err := awsRestjson1_serializeDocumentNumericRangeFilterValue(v.RangeMaximum, ok); err != nil {
			return err
		}
	}

	if v.RangeMinimum != nil {
		ok := object.Key("RangeMinimum")
		if err := awsRestjson1_serializeDocumentNumericRangeFilterValue(v.RangeMinimum, ok); err != nil {
			return err
		}
	}

	if len(v.SelectAllOptions) > 0 {
		ok := object.Key("SelectAllOptions")
		ok.String(string(v.SelectAllOptions))
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericRangeFilterValue(v *types.NumericRangeFilterValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Parameter != nil {
		ok := object.Key("Parameter")
		ok.String(*v.Parameter)
	}

	if v.StaticValue != nil {
		ok := object.Key("StaticValue")
		switch {
		case math.IsNaN(*v.StaticValue):
			ok.String("NaN")

		case math.IsInf(*v.StaticValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.StaticValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.StaticValue)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumericSeparatorConfiguration(v *types.NumericSeparatorConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DecimalSeparator) > 0 {
		ok := object.Key("DecimalSeparator")
		ok.String(string(v.DecimalSeparator))
	}

	if v.ThousandsSeparator != nil {
		ok := object.Key("ThousandsSeparator")
		if err := awsRestjson1_serializeDocumentThousandSeparatorOptions(v.ThousandsSeparator, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOracleParameters(v *types.OracleParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != nil {
		ok := object.Key("Port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentOverrideDatasetParameterOperation(v *types.OverrideDatasetParameterOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NewDefaultValues != nil {
		ok := object.Key("NewDefaultValues")
		if err := awsRestjson1_serializeDocumentNewDefaultValues(v.NewDefaultValues, ok); err != nil {
			return err
		}
	}

	if v.NewParameterName != nil {
		ok := object.Key("NewParameterName")
		ok.String(*v.NewParameterName)
	}

	if v.ParameterName != nil {
		ok := object.Key("ParameterName")
		ok.String(*v.ParameterName)
	}

	return nil
}

func awsRestjson1_serializeDocumentPaginationConfiguration(v *types.PaginationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PageNumber != nil {
		ok := object.Key("PageNumber")
		ok.Long(*v.PageNumber)
	}

	if v.PageSize != nil {
		ok := object.Key("PageSize")
		ok.Long(*v.PageSize)
	}

	return nil
}

func awsRestjson1_serializeDocumentPanelConfiguration(v *types.PanelConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackgroundColor != nil {
		ok := object.Key("BackgroundColor")
		ok.String(*v.BackgroundColor)
	}

	if len(v.BackgroundVisibility) > 0 {
		ok := object.Key("BackgroundVisibility")
		ok.String(string(v.BackgroundVisibility))
	}

	if v.BorderColor != nil {
		ok := object.Key("BorderColor")
		ok.String(*v.BorderColor)
	}

	if len(v.BorderStyle) > 0 {
		ok := object.Key("BorderStyle")
		ok.String(string(v.BorderStyle))
	}

	if v.BorderThickness != nil {
		ok := object.Key("BorderThickness")
		ok.String(*v.BorderThickness)
	}

	if len(v.BorderVisibility) > 0 {
		ok := object.Key("BorderVisibility")
		ok.String(string(v.BorderVisibility))
	}

	if v.GutterSpacing != nil {
		ok := object.Key("GutterSpacing")
		ok.String(*v.GutterSpacing)
	}

	if len(v.GutterVisibility) > 0 {
		ok := object.Key("GutterVisibility")
		ok.String(string(v.GutterVisibility))
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentPanelTitleOptions(v.Title, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPanelTitleOptions(v *types.PanelTitleOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FontConfiguration != nil {
		ok := object.Key("FontConfiguration")
		if err := awsRestjson1_serializeDocumentFontConfiguration(v.FontConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.HorizontalTextAlignment) > 0 {
		ok := object.Key("HorizontalTextAlignment")
		ok.String(string(v.HorizontalTextAlignment))
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterControl(v *types.ParameterControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimePicker != nil {
		ok := object.Key("DateTimePicker")
		if err := awsRestjson1_serializeDocumentParameterDateTimePickerControl(v.DateTimePicker, ok); err != nil {
			return err
		}
	}

	if v.Dropdown != nil {
		ok := object.Key("Dropdown")
		if err := awsRestjson1_serializeDocumentParameterDropDownControl(v.Dropdown, ok); err != nil {
			return err
		}
	}

	if v.List != nil {
		ok := object.Key("List")
		if err := awsRestjson1_serializeDocumentParameterListControl(v.List, ok); err != nil {
			return err
		}
	}

	if v.Slider != nil {
		ok := object.Key("Slider")
		if err := awsRestjson1_serializeDocumentParameterSliderControl(v.Slider, ok); err != nil {
			return err
		}
	}

	if v.TextArea != nil {
		ok := object.Key("TextArea")
		if err := awsRestjson1_serializeDocumentParameterTextAreaControl(v.TextArea, ok); err != nil {
			return err
		}
	}

	if v.TextField != nil {
		ok := object.Key("TextField")
		if err := awsRestjson1_serializeDocumentParameterTextFieldControl(v.TextField, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterControlList(v []types.ParameterControl, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentParameterControl(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentParameterDateTimePickerControl(v *types.ParameterDateTimePickerControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentDateTimePickerControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.ParameterControlId != nil {
		ok := object.Key("ParameterControlId")
		ok.String(*v.ParameterControlId)
	}

	if v.SourceParameterName != nil {
		ok := object.Key("SourceParameterName")
		ok.String(*v.SourceParameterName)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterDeclaration(v *types.ParameterDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeParameterDeclaration != nil {
		ok := object.Key("DateTimeParameterDeclaration")
		if err := awsRestjson1_serializeDocumentDateTimeParameterDeclaration(v.DateTimeParameterDeclaration, ok); err != nil {
			return err
		}
	}

	if v.DecimalParameterDeclaration != nil {
		ok := object.Key("DecimalParameterDeclaration")
		if err := awsRestjson1_serializeDocumentDecimalParameterDeclaration(v.DecimalParameterDeclaration, ok); err != nil {
			return err
		}
	}

	if v.IntegerParameterDeclaration != nil {
		ok := object.Key("IntegerParameterDeclaration")
		if err := awsRestjson1_serializeDocumentIntegerParameterDeclaration(v.IntegerParameterDeclaration, ok); err != nil {
			return err
		}
	}

	if v.StringParameterDeclaration != nil {
		ok := object.Key("StringParameterDeclaration")
		if err := awsRestjson1_serializeDocumentStringParameterDeclaration(v.StringParameterDeclaration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterDeclarationList(v []types.ParameterDeclaration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentParameterDeclaration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentParameterDropDownControl(v *types.ParameterDropDownControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CascadingControlConfiguration != nil {
		ok := object.Key("CascadingControlConfiguration")
		if err := awsRestjson1_serializeDocumentCascadingControlConfiguration(v.CascadingControlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentDropDownControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.ParameterControlId != nil {
		ok := object.Key("ParameterControlId")
		ok.String(*v.ParameterControlId)
	}

	if v.SelectableValues != nil {
		ok := object.Key("SelectableValues")
		if err := awsRestjson1_serializeDocumentParameterSelectableValues(v.SelectableValues, ok); err != nil {
			return err
		}
	}

	if v.SourceParameterName != nil {
		ok := object.Key("SourceParameterName")
		ok.String(*v.SourceParameterName)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterListControl(v *types.ParameterListControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CascadingControlConfiguration != nil {
		ok := object.Key("CascadingControlConfiguration")
		if err := awsRestjson1_serializeDocumentCascadingControlConfiguration(v.CascadingControlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentListControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.ParameterControlId != nil {
		ok := object.Key("ParameterControlId")
		ok.String(*v.ParameterControlId)
	}

	if v.SelectableValues != nil {
		ok := object.Key("SelectableValues")
		if err := awsRestjson1_serializeDocumentParameterSelectableValues(v.SelectableValues, ok); err != nil {
			return err
		}
	}

	if v.SourceParameterName != nil {
		ok := object.Key("SourceParameterName")
		ok.String(*v.SourceParameterName)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentParameters(v *types.Parameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeParameters != nil {
		ok := object.Key("DateTimeParameters")
		if err := awsRestjson1_serializeDocumentDateTimeParameterList(v.DateTimeParameters, ok); err != nil {
			return err
		}
	}

	if v.DecimalParameters != nil {
		ok := object.Key("DecimalParameters")
		if err := awsRestjson1_serializeDocumentDecimalParameterList(v.DecimalParameters, ok); err != nil {
			return err
		}
	}

	if v.IntegerParameters != nil {
		ok := object.Key("IntegerParameters")
		if err := awsRestjson1_serializeDocumentIntegerParameterList(v.IntegerParameters, ok); err != nil {
			return err
		}
	}

	if v.StringParameters != nil {
		ok := object.Key("StringParameters")
		if err := awsRestjson1_serializeDocumentStringParameterList(v.StringParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterSelectableValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentParameterSelectableValues(v *types.ParameterSelectableValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LinkToDataSetColumn != nil {
		ok := object.Key("LinkToDataSetColumn")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.LinkToDataSetColumn, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentParameterSelectableValueList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterSliderControl(v *types.ParameterSliderControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentSliderControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("MaximumValue")
		switch {
		case math.IsNaN(v.MaximumValue):
			ok.String("NaN")

		case math.IsInf(v.MaximumValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.MaximumValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.MaximumValue)

		}
	}

	{
		ok := object.Key("MinimumValue")
		switch {
		case math.IsNaN(v.MinimumValue):
			ok.String("NaN")

		case math.IsInf(v.MinimumValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.MinimumValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.MinimumValue)

		}
	}

	if v.ParameterControlId != nil {
		ok := object.Key("ParameterControlId")
		ok.String(*v.ParameterControlId)
	}

	if v.SourceParameterName != nil {
		ok := object.Key("SourceParameterName")
		ok.String(*v.SourceParameterName)
	}

	{
		ok := object.Key("StepSize")
		switch {
		case math.IsNaN(v.StepSize):
			ok.String("NaN")

		case math.IsInf(v.StepSize, 1):
			ok.String("Infinity")

		case math.IsInf(v.StepSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.StepSize)

		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterTextAreaControl(v *types.ParameterTextAreaControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Delimiter != nil {
		ok := object.Key("Delimiter")
		ok.String(*v.Delimiter)
	}

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentTextAreaControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.ParameterControlId != nil {
		ok := object.Key("ParameterControlId")
		ok.String(*v.ParameterControlId)
	}

	if v.SourceParameterName != nil {
		ok := object.Key("SourceParameterName")
		ok.String(*v.SourceParameterName)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterTextFieldControl(v *types.ParameterTextFieldControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayOptions != nil {
		ok := object.Key("DisplayOptions")
		if err := awsRestjson1_serializeDocumentTextFieldControlDisplayOptions(v.DisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.ParameterControlId != nil {
		ok := object.Key("ParameterControlId")
		ok.String(*v.ParameterControlId)
	}

	if v.SourceParameterName != nil {
		ok := object.Key("SourceParameterName")
		ok.String(*v.SourceParameterName)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentPercentageDisplayFormatConfiguration(v *types.PercentageDisplayFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecimalPlacesConfiguration != nil {
		ok := object.Key("DecimalPlacesConfiguration")
		if err := awsRestjson1_serializeDocumentDecimalPlacesConfiguration(v.DecimalPlacesConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NegativeValueConfiguration != nil {
		ok := object.Key("NegativeValueConfiguration")
		if err := awsRestjson1_serializeDocumentNegativeValueConfiguration(v.NegativeValueConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NullValueFormatConfiguration != nil {
		ok := object.Key("NullValueFormatConfiguration")
		if err := awsRestjson1_serializeDocumentNullValueFormatConfiguration(v.NullValueFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.SeparatorConfiguration != nil {
		ok := object.Key("SeparatorConfiguration")
		if err := awsRestjson1_serializeDocumentNumericSeparatorConfiguration(v.SeparatorConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Suffix != nil {
		ok := object.Key("Suffix")
		ok.String(*v.Suffix)
	}

	return nil
}

func awsRestjson1_serializeDocumentPercentileAggregation(v *types.PercentileAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PercentileValue != nil {
		ok := object.Key("PercentileValue")
		switch {
		case math.IsNaN(*v.PercentileValue):
			ok.String("NaN")

		case math.IsInf(*v.PercentileValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.PercentileValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.PercentileValue)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPercentVisibleRange(v *types.PercentVisibleRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.From != nil {
		ok := object.Key("From")
		switch {
		case math.IsNaN(*v.From):
			ok.String("NaN")

		case math.IsInf(*v.From, 1):
			ok.String("Infinity")

		case math.IsInf(*v.From, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.From)

		}
	}

	if v.To != nil {
		ok := object.Key("To")
		switch {
		case math.IsNaN(*v.To):
			ok.String("NaN")

		case math.IsInf(*v.To, 1):
			ok.String("Infinity")

		case math.IsInf(*v.To, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.To)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPeriodOverPeriodComputation(v *types.PeriodOverPeriodComputation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputationId != nil {
		ok := object.Key("ComputationId")
		ok.String(*v.ComputationId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Time != nil {
		ok := object.Key("Time")
		if err := awsRestjson1_serializeDocumentDimensionField(v.Time, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsRestjson1_serializeDocumentMeasureField(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPeriodToDateComputation(v *types.PeriodToDateComputation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputationId != nil {
		ok := object.Key("ComputationId")
		ok.String(*v.ComputationId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.PeriodTimeGranularity) > 0 {
		ok := object.Key("PeriodTimeGranularity")
		ok.String(string(v.PeriodTimeGranularity))
	}

	if v.Time != nil {
		ok := object.Key("Time")
		if err := awsRestjson1_serializeDocumentDimensionField(v.Time, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsRestjson1_serializeDocumentMeasureField(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPhysicalTable(v types.PhysicalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PhysicalTableMemberCustomSql:
		av := object.Key("CustomSql")
		if err := awsRestjson1_serializeDocumentCustomSql(&uv.Value, av); err != nil {
			return err
		}

	case *types.PhysicalTableMemberRelationalTable:
		av := object.Key("RelationalTable")
		if err := awsRestjson1_serializeDocumentRelationalTable(&uv.Value, av); err != nil {
			return err
		}

	case *types.PhysicalTableMemberS3Source:
		av := object.Key("S3Source")
		if err := awsRestjson1_serializeDocumentS3Source(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentPhysicalTableMap(v map[string]types.PhysicalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPhysicalTable(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPieChartAggregatedFieldWells(v *types.PieChartAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("Category")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Category, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiples != nil {
		ok := object.Key("SmallMultiples")
		if err := awsRestjson1_serializeDocumentSmallMultiplesDimensionFieldList(v.SmallMultiples, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPieChartConfiguration(v *types.PieChartConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryLabelOptions != nil {
		ok := object.Key("CategoryLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.CategoryLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.ContributionAnalysisDefaults != nil {
		ok := object.Key("ContributionAnalysisDefaults")
		if err := awsRestjson1_serializeDocumentContributionAnalysisDefaultList(v.ContributionAnalysisDefaults, ok); err != nil {
			return err
		}
	}

	if v.DataLabels != nil {
		ok := object.Key("DataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.DataLabels, ok); err != nil {
			return err
		}
	}

	if v.DonutOptions != nil {
		ok := object.Key("DonutOptions")
		if err := awsRestjson1_serializeDocumentDonutOptions(v.DonutOptions, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentPieChartFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiplesOptions != nil {
		ok := object.Key("SmallMultiplesOptions")
		if err := awsRestjson1_serializeDocumentSmallMultiplesOptions(v.SmallMultiplesOptions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentPieChartSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if v.ValueLabelOptions != nil {
		ok := object.Key("ValueLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.ValueLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPieChartFieldWells(v *types.PieChartFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PieChartAggregatedFieldWells != nil {
		ok := object.Key("PieChartAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentPieChartAggregatedFieldWells(v.PieChartAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPieChartSortConfiguration(v *types.PieChartSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryItemsLimit != nil {
		ok := object.Key("CategoryItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.CategoryItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.CategorySort != nil {
		ok := object.Key("CategorySort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.CategorySort, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiplesLimitConfiguration != nil {
		ok := object.Key("SmallMultiplesLimitConfiguration")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.SmallMultiplesLimitConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SmallMultiplesSort != nil {
		ok := object.Key("SmallMultiplesSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.SmallMultiplesSort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPieChartVisual(v *types.PieChartVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentPieChartConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotFieldSortOptions(v *types.PivotFieldSortOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.SortBy != nil {
		ok := object.Key("SortBy")
		if err := awsRestjson1_serializeDocumentPivotTableSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotFieldSortOptionsList(v []types.PivotFieldSortOptions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPivotFieldSortOptions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPivotMeasureFieldList(v []types.MeasureField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMeasureField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPivotTableAggregatedFieldWells(v *types.PivotTableAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentPivotTableDimensionList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.Rows != nil {
		ok := object.Key("Rows")
		if err := awsRestjson1_serializeDocumentPivotTableDimensionList(v.Rows, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentPivotMeasureFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableCellConditionalFormatting(v *types.PivotTableCellConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if v.Scope != nil {
		ok := object.Key("Scope")
		if err := awsRestjson1_serializeDocumentPivotTableConditionalFormattingScope(v.Scope, ok); err != nil {
			return err
		}
	}

	if v.Scopes != nil {
		ok := object.Key("Scopes")
		if err := awsRestjson1_serializeDocumentPivotTableConditionalFormattingScopeList(v.Scopes, ok); err != nil {
			return err
		}
	}

	if v.TextFormat != nil {
		ok := object.Key("TextFormat")
		if err := awsRestjson1_serializeDocumentTextConditionalFormat(v.TextFormat, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableConditionalFormatting(v *types.PivotTableConditionalFormatting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionalFormattingOptions != nil {
		ok := object.Key("ConditionalFormattingOptions")
		if err := awsRestjson1_serializeDocumentPivotTableConditionalFormattingOptionList(v.ConditionalFormattingOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableConditionalFormattingOption(v *types.PivotTableConditionalFormattingOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cell != nil {
		ok := object.Key("Cell")
		if err := awsRestjson1_serializeDocumentPivotTableCellConditionalFormatting(v.Cell, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableConditionalFormattingOptionList(v []types.PivotTableConditionalFormattingOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPivotTableConditionalFormattingOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPivotTableConditionalFormattingScope(v *types.PivotTableConditionalFormattingScope, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Role) > 0 {
		ok := object.Key("Role")
		ok.String(string(v.Role))
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableConditionalFormattingScopeList(v []types.PivotTableConditionalFormattingScope, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPivotTableConditionalFormattingScope(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPivotTableConfiguration(v *types.PivotTableConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldOptions != nil {
		ok := object.Key("FieldOptions")
		if err := awsRestjson1_serializeDocumentPivotTableFieldOptions(v.FieldOptions, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentPivotTableFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.PaginatedReportOptions != nil {
		ok := object.Key("PaginatedReportOptions")
		if err := awsRestjson1_serializeDocumentPivotTablePaginatedReportOptions(v.PaginatedReportOptions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentPivotTableSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TableOptions != nil {
		ok := object.Key("TableOptions")
		if err := awsRestjson1_serializeDocumentPivotTableOptions(v.TableOptions, ok); err != nil {
			return err
		}
	}

	if v.TotalOptions != nil {
		ok := object.Key("TotalOptions")
		if err := awsRestjson1_serializeDocumentPivotTableTotalOptions(v.TotalOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableDataPathOption(v *types.PivotTableDataPathOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataPathList != nil {
		ok := object.Key("DataPathList")
		if err := awsRestjson1_serializeDocumentDataPathValueList(v.DataPathList, ok); err != nil {
			return err
		}
	}

	if v.Width != nil {
		ok := object.Key("Width")
		ok.String(*v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableDataPathOptionList(v []types.PivotTableDataPathOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPivotTableDataPathOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPivotTableDimensionList(v []types.DimensionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPivotTableFieldCollapseStateOption(v *types.PivotTableFieldCollapseStateOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("State")
		ok.String(string(v.State))
	}

	if v.Target != nil {
		ok := object.Key("Target")
		if err := awsRestjson1_serializeDocumentPivotTableFieldCollapseStateTarget(v.Target, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableFieldCollapseStateOptionList(v []types.PivotTableFieldCollapseStateOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPivotTableFieldCollapseStateOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPivotTableFieldCollapseStateTarget(v *types.PivotTableFieldCollapseStateTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldDataPathValues != nil {
		ok := object.Key("FieldDataPathValues")
		if err := awsRestjson1_serializeDocumentDataPathValueList(v.FieldDataPathValues, ok); err != nil {
			return err
		}
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableFieldOption(v *types.PivotTableFieldOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLabel != nil {
		ok := object.Key("CustomLabel")
		ok.String(*v.CustomLabel)
	}

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableFieldOptionList(v []types.PivotTableFieldOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPivotTableFieldOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPivotTableFieldOptions(v *types.PivotTableFieldOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollapseStateOptions != nil {
		ok := object.Key("CollapseStateOptions")
		if err := awsRestjson1_serializeDocumentPivotTableFieldCollapseStateOptionList(v.CollapseStateOptions, ok); err != nil {
			return err
		}
	}

	if v.DataPathOptions != nil {
		ok := object.Key("DataPathOptions")
		if err := awsRestjson1_serializeDocumentPivotTableDataPathOptionList(v.DataPathOptions, ok); err != nil {
			return err
		}
	}

	if v.SelectedFieldOptions != nil {
		ok := object.Key("SelectedFieldOptions")
		if err := awsRestjson1_serializeDocumentPivotTableFieldOptionList(v.SelectedFieldOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableFieldSubtotalOptions(v *types.PivotTableFieldSubtotalOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldId != nil {
		ok := object.Key("FieldId")
		ok.String(*v.FieldId)
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableFieldSubtotalOptionsList(v []types.PivotTableFieldSubtotalOptions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPivotTableFieldSubtotalOptions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPivotTableFieldWells(v *types.PivotTableFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PivotTableAggregatedFieldWells != nil {
		ok := object.Key("PivotTableAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentPivotTableAggregatedFieldWells(v.PivotTableAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableOptions(v *types.PivotTableOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CellStyle != nil {
		ok := object.Key("CellStyle")
		if err := awsRestjson1_serializeDocumentTableCellStyle(v.CellStyle, ok); err != nil {
			return err
		}
	}

	if len(v.CollapsedRowDimensionsVisibility) > 0 {
		ok := object.Key("CollapsedRowDimensionsVisibility")
		ok.String(string(v.CollapsedRowDimensionsVisibility))
	}

	if v.ColumnHeaderStyle != nil {
		ok := object.Key("ColumnHeaderStyle")
		if err := awsRestjson1_serializeDocumentTableCellStyle(v.ColumnHeaderStyle, ok); err != nil {
			return err
		}
	}

	if len(v.ColumnNamesVisibility) > 0 {
		ok := object.Key("ColumnNamesVisibility")
		ok.String(string(v.ColumnNamesVisibility))
	}

	if v.DefaultCellWidth != nil {
		ok := object.Key("DefaultCellWidth")
		ok.String(*v.DefaultCellWidth)
	}

	if len(v.MetricPlacement) > 0 {
		ok := object.Key("MetricPlacement")
		ok.String(string(v.MetricPlacement))
	}

	if v.RowAlternateColorOptions != nil {
		ok := object.Key("RowAlternateColorOptions")
		if err := awsRestjson1_serializeDocumentRowAlternateColorOptions(v.RowAlternateColorOptions, ok); err != nil {
			return err
		}
	}

	if v.RowFieldNamesStyle != nil {
		ok := object.Key("RowFieldNamesStyle")
		if err := awsRestjson1_serializeDocumentTableCellStyle(v.RowFieldNamesStyle, ok); err != nil {
			return err
		}
	}

	if v.RowHeaderStyle != nil {
		ok := object.Key("RowHeaderStyle")
		if err := awsRestjson1_serializeDocumentTableCellStyle(v.RowHeaderStyle, ok); err != nil {
			return err
		}
	}

	if v.RowsLabelOptions != nil {
		ok := object.Key("RowsLabelOptions")
		if err := awsRestjson1_serializeDocumentPivotTableRowsLabelOptions(v.RowsLabelOptions, ok); err != nil {
			return err
		}
	}

	if len(v.RowsLayout) > 0 {
		ok := object.Key("RowsLayout")
		ok.String(string(v.RowsLayout))
	}

	if len(v.SingleMetricVisibility) > 0 {
		ok := object.Key("SingleMetricVisibility")
		ok.String(string(v.SingleMetricVisibility))
	}

	if len(v.ToggleButtonsVisibility) > 0 {
		ok := object.Key("ToggleButtonsVisibility")
		ok.String(string(v.ToggleButtonsVisibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTablePaginatedReportOptions(v *types.PivotTablePaginatedReportOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.OverflowColumnHeaderVisibility) > 0 {
		ok := object.Key("OverflowColumnHeaderVisibility")
		ok.String(string(v.OverflowColumnHeaderVisibility))
	}

	if len(v.VerticalOverflowVisibility) > 0 {
		ok := object.Key("VerticalOverflowVisibility")
		ok.String(string(v.VerticalOverflowVisibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableRowsLabelOptions(v *types.PivotTableRowsLabelOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLabel != nil {
		ok := object.Key("CustomLabel")
		ok.String(*v.CustomLabel)
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableSortBy(v *types.PivotTableSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnSort(v.Column, ok); err != nil {
			return err
		}
	}

	if v.DataPath != nil {
		ok := object.Key("DataPath")
		if err := awsRestjson1_serializeDocumentDataPathSort(v.DataPath, ok); err != nil {
			return err
		}
	}

	if v.Field != nil {
		ok := object.Key("Field")
		if err := awsRestjson1_serializeDocumentFieldSort(v.Field, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableSortConfiguration(v *types.PivotTableSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldSortOptions != nil {
		ok := object.Key("FieldSortOptions")
		if err := awsRestjson1_serializeDocumentPivotFieldSortOptionsList(v.FieldSortOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableTotalOptions(v *types.PivotTableTotalOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnSubtotalOptions != nil {
		ok := object.Key("ColumnSubtotalOptions")
		if err := awsRestjson1_serializeDocumentSubtotalOptions(v.ColumnSubtotalOptions, ok); err != nil {
			return err
		}
	}

	if v.ColumnTotalOptions != nil {
		ok := object.Key("ColumnTotalOptions")
		if err := awsRestjson1_serializeDocumentPivotTotalOptions(v.ColumnTotalOptions, ok); err != nil {
			return err
		}
	}

	if v.RowSubtotalOptions != nil {
		ok := object.Key("RowSubtotalOptions")
		if err := awsRestjson1_serializeDocumentSubtotalOptions(v.RowSubtotalOptions, ok); err != nil {
			return err
		}
	}

	if v.RowTotalOptions != nil {
		ok := object.Key("RowTotalOptions")
		if err := awsRestjson1_serializeDocumentPivotTotalOptions(v.RowTotalOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTableVisual(v *types.PivotTableVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentPivotTableConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ConditionalFormatting != nil {
		ok := object.Key("ConditionalFormatting")
		if err := awsRestjson1_serializeDocumentPivotTableConditionalFormatting(v.ConditionalFormatting, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentPivotTotalOptions(v *types.PivotTotalOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLabel != nil {
		ok := object.Key("CustomLabel")
		ok.String(*v.CustomLabel)
	}

	if v.MetricHeaderCellStyle != nil {
		ok := object.Key("MetricHeaderCellStyle")
		if err := awsRestjson1_serializeDocumentTableCellStyle(v.MetricHeaderCellStyle, ok); err != nil {
			return err
		}
	}

	if len(v.Placement) > 0 {
		ok := object.Key("Placement")
		ok.String(string(v.Placement))
	}

	if len(v.ScrollStatus) > 0 {
		ok := object.Key("ScrollStatus")
		ok.String(string(v.ScrollStatus))
	}

	if v.TotalAggregationOptions != nil {
		ok := object.Key("TotalAggregationOptions")
		if err := awsRestjson1_serializeDocumentTotalAggregationOptionList(v.TotalAggregationOptions, ok); err != nil {
			return err
		}
	}

	if v.TotalCellStyle != nil {
		ok := object.Key("TotalCellStyle")
		if err := awsRestjson1_serializeDocumentTableCellStyle(v.TotalCellStyle, ok); err != nil {
			return err
		}
	}

	if len(v.TotalsVisibility) > 0 {
		ok := object.Key("TotalsVisibility")
		ok.String(string(v.TotalsVisibility))
	}

	if v.ValueCellStyle != nil {
		ok := object.Key("ValueCellStyle")
		if err := awsRestjson1_serializeDocumentTableCellStyle(v.ValueCellStyle, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPostgreSqlParameters(v *types.PostgreSqlParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != nil {
		ok := object.Key("Port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentPredefinedHierarchy(v *types.PredefinedHierarchy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentPredefinedHierarchyColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.DrillDownFilters != nil {
		ok := object.Key("DrillDownFilters")
		if err := awsRestjson1_serializeDocumentDrillDownFilterList(v.DrillDownFilters, ok); err != nil {
			return err
		}
	}

	if v.HierarchyId != nil {
		ok := object.Key("HierarchyId")
		ok.String(*v.HierarchyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentPredefinedHierarchyColumnList(v []types.ColumnIdentifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnIdentifier(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPrestoParameters(v *types.PrestoParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Catalog != nil {
		ok := object.Key("Catalog")
		ok.String(*v.Catalog)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != nil {
		ok := object.Key("Port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrincipalList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentProgressBarOptions(v *types.ProgressBarOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentProjectedColumnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentProjectOperation(v *types.ProjectOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProjectedColumns != nil {
		ok := object.Key("ProjectedColumns")
		if err := awsRestjson1_serializeDocumentProjectedColumnList(v.ProjectedColumns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRadarChartAggregatedFieldWells(v *types.RadarChartAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("Category")
		if err := awsRestjson1_serializeDocumentRadarChartCategoryFieldList(v.Category, ok); err != nil {
			return err
		}
	}

	if v.Color != nil {
		ok := object.Key("Color")
		if err := awsRestjson1_serializeDocumentRadarChartColorFieldList(v.Color, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentRadarChartValuesFieldList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRadarChartAreaStyleSettings(v *types.RadarChartAreaStyleSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentRadarChartCategoryFieldList(v []types.DimensionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRadarChartColorFieldList(v []types.DimensionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRadarChartConfiguration(v *types.RadarChartConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AlternateBandColorsVisibility) > 0 {
		ok := object.Key("AlternateBandColorsVisibility")
		ok.String(string(v.AlternateBandColorsVisibility))
	}

	if v.AlternateBandEvenColor != nil {
		ok := object.Key("AlternateBandEvenColor")
		ok.String(*v.AlternateBandEvenColor)
	}

	if v.AlternateBandOddColor != nil {
		ok := object.Key("AlternateBandOddColor")
		ok.String(*v.AlternateBandOddColor)
	}

	if len(v.AxesRangeScale) > 0 {
		ok := object.Key("AxesRangeScale")
		ok.String(string(v.AxesRangeScale))
	}

	if v.BaseSeriesSettings != nil {
		ok := object.Key("BaseSeriesSettings")
		if err := awsRestjson1_serializeDocumentRadarChartSeriesSettings(v.BaseSeriesSettings, ok); err != nil {
			return err
		}
	}

	if v.CategoryAxis != nil {
		ok := object.Key("CategoryAxis")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.CategoryAxis, ok); err != nil {
			return err
		}
	}

	if v.CategoryLabelOptions != nil {
		ok := object.Key("CategoryLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.CategoryLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.ColorAxis != nil {
		ok := object.Key("ColorAxis")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.ColorAxis, ok); err != nil {
			return err
		}
	}

	if v.ColorLabelOptions != nil {
		ok := object.Key("ColorLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.ColorLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentRadarChartFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if len(v.Shape) > 0 {
		ok := object.Key("Shape")
		ok.String(string(v.Shape))
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentRadarChartSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.StartAngle != nil {
		ok := object.Key("StartAngle")
		switch {
		case math.IsNaN(*v.StartAngle):
			ok.String("NaN")

		case math.IsInf(*v.StartAngle, 1):
			ok.String("Infinity")

		case math.IsInf(*v.StartAngle, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.StartAngle)

		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRadarChartFieldWells(v *types.RadarChartFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RadarChartAggregatedFieldWells != nil {
		ok := object.Key("RadarChartAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentRadarChartAggregatedFieldWells(v.RadarChartAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRadarChartSeriesSettings(v *types.RadarChartSeriesSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AreaStyleSettings != nil {
		ok := object.Key("AreaStyleSettings")
		if err := awsRestjson1_serializeDocumentRadarChartAreaStyleSettings(v.AreaStyleSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRadarChartSortConfiguration(v *types.RadarChartSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryItemsLimit != nil {
		ok := object.Key("CategoryItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.CategoryItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.CategorySort != nil {
		ok := object.Key("CategorySort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.CategorySort, ok); err != nil {
			return err
		}
	}

	if v.ColorItemsLimit != nil {
		ok := object.Key("ColorItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.ColorItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.ColorSort != nil {
		ok := object.Key("ColorSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.ColorSort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRadarChartValuesFieldList(v []types.MeasureField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMeasureField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRadarChartVisual(v *types.RadarChartVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentRadarChartConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRangeConstant(v *types.RangeConstant, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Maximum != nil {
		ok := object.Key("Maximum")
		ok.String(*v.Maximum)
	}

	if v.Minimum != nil {
		ok := object.Key("Minimum")
		ok.String(*v.Minimum)
	}

	return nil
}

func awsRestjson1_serializeDocumentRangeEndsLabelType(v *types.RangeEndsLabelType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentRdsParameters(v *types.RdsParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRedshiftIAMParameters(v *types.RedshiftIAMParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoCreateDatabaseUser {
		ok := object.Key("AutoCreateDatabaseUser")
		ok.Boolean(v.AutoCreateDatabaseUser)
	}

	if v.DatabaseGroups != nil {
		ok := object.Key("DatabaseGroups")
		if err := awsRestjson1_serializeDocumentDatabaseGroupList(v.DatabaseGroups, ok); err != nil {
			return err
		}
	}

	if v.DatabaseUser != nil {
		ok := object.Key("DatabaseUser")
		ok.String(*v.DatabaseUser)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentRedshiftParameters(v *types.RedshiftParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.IAMParameters != nil {
		ok := object.Key("IAMParameters")
		if err := awsRestjson1_serializeDocumentRedshiftIAMParameters(v.IAMParameters, ok); err != nil {
			return err
		}
	}

	if v.IdentityCenterConfiguration != nil {
		ok := object.Key("IdentityCenterConfiguration")
		if err := awsRestjson1_serializeDocumentIdentityCenterConfiguration(v.IdentityCenterConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentReferenceLine(v *types.ReferenceLine, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataConfiguration != nil {
		ok := object.Key("DataConfiguration")
		if err := awsRestjson1_serializeDocumentReferenceLineDataConfiguration(v.DataConfiguration, ok); err != nil {
			return err
		}
	}

	if v.LabelConfiguration != nil {
		ok := object.Key("LabelConfiguration")
		if err := awsRestjson1_serializeDocumentReferenceLineLabelConfiguration(v.LabelConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if v.StyleConfiguration != nil {
		ok := object.Key("StyleConfiguration")
		if err := awsRestjson1_serializeDocumentReferenceLineStyleConfiguration(v.StyleConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentReferenceLineCustomLabelConfiguration(v *types.ReferenceLineCustomLabelConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLabel != nil {
		ok := object.Key("CustomLabel")
		ok.String(*v.CustomLabel)
	}

	return nil
}

func awsRestjson1_serializeDocumentReferenceLineDataConfiguration(v *types.ReferenceLineDataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AxisBinding) > 0 {
		ok := object.Key("AxisBinding")
		ok.String(string(v.AxisBinding))
	}

	if v.DynamicConfiguration != nil {
		ok := object.Key("DynamicConfiguration")
		if err := awsRestjson1_serializeDocumentReferenceLineDynamicDataConfiguration(v.DynamicConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.SeriesType) > 0 {
		ok := object.Key("SeriesType")
		ok.String(string(v.SeriesType))
	}

	if v.StaticConfiguration != nil {
		ok := object.Key("StaticConfiguration")
		if err := awsRestjson1_serializeDocumentReferenceLineStaticDataConfiguration(v.StaticConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentReferenceLineDynamicDataConfiguration(v *types.ReferenceLineDynamicDataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Calculation != nil {
		ok := object.Key("Calculation")
		if err := awsRestjson1_serializeDocumentNumericalAggregationFunction(v.Calculation, ok); err != nil {
			return err
		}
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.MeasureAggregationFunction != nil {
		ok := object.Key("MeasureAggregationFunction")
		if err := awsRestjson1_serializeDocumentAggregationFunction(v.MeasureAggregationFunction, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentReferenceLineLabelConfiguration(v *types.ReferenceLineLabelConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLabelConfiguration != nil {
		ok := object.Key("CustomLabelConfiguration")
		if err := awsRestjson1_serializeDocumentReferenceLineCustomLabelConfiguration(v.CustomLabelConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FontColor != nil {
		ok := object.Key("FontColor")
		ok.String(*v.FontColor)
	}

	if v.FontConfiguration != nil {
		ok := object.Key("FontConfiguration")
		if err := awsRestjson1_serializeDocumentFontConfiguration(v.FontConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.HorizontalPosition) > 0 {
		ok := object.Key("HorizontalPosition")
		ok.String(string(v.HorizontalPosition))
	}

	if v.ValueLabelConfiguration != nil {
		ok := object.Key("ValueLabelConfiguration")
		if err := awsRestjson1_serializeDocumentReferenceLineValueLabelConfiguration(v.ValueLabelConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.VerticalPosition) > 0 {
		ok := object.Key("VerticalPosition")
		ok.String(string(v.VerticalPosition))
	}

	return nil
}

func awsRestjson1_serializeDocumentReferenceLineList(v []types.ReferenceLine, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentReferenceLine(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentReferenceLineStaticDataConfiguration(v *types.ReferenceLineStaticDataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Value")
		switch {
		case math.IsNaN(v.Value):
			ok.String("NaN")

		case math.IsInf(v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentReferenceLineStyleConfiguration(v *types.ReferenceLineStyleConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	if len(v.Pattern) > 0 {
		ok := object.Key("Pattern")
		ok.String(string(v.Pattern))
	}

	return nil
}

func awsRestjson1_serializeDocumentReferenceLineValueLabelConfiguration(v *types.ReferenceLineValueLabelConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FormatConfiguration != nil {
		ok := object.Key("FormatConfiguration")
		if err := awsRestjson1_serializeDocumentNumericFormatConfiguration(v.FormatConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.RelativePosition) > 0 {
		ok := object.Key("RelativePosition")
		ok.String(string(v.RelativePosition))
	}

	return nil
}

func awsRestjson1_serializeDocumentRefreshConfiguration(v *types.RefreshConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncrementalRefresh != nil {
		ok := object.Key("IncrementalRefresh")
		if err := awsRestjson1_serializeDocumentIncrementalRefresh(v.IncrementalRefresh, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRefreshFrequency(v *types.RefreshFrequency, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Interval) > 0 {
		ok := object.Key("Interval")
		ok.String(string(v.Interval))
	}

	if v.RefreshOnDay != nil {
		ok := object.Key("RefreshOnDay")
		if err := awsRestjson1_serializeDocumentScheduleRefreshOnEntity(v.RefreshOnDay, ok); err != nil {
			return err
		}
	}

	if v.TimeOfTheDay != nil {
		ok := object.Key("TimeOfTheDay")
		ok.String(*v.TimeOfTheDay)
	}

	if v.Timezone != nil {
		ok := object.Key("Timezone")
		ok.String(*v.Timezone)
	}

	return nil
}

func awsRestjson1_serializeDocumentRefreshSchedule(v *types.RefreshSchedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if len(v.RefreshType) > 0 {
		ok := object.Key("RefreshType")
		ok.String(string(v.RefreshType))
	}

	if v.ScheduleFrequency != nil {
		ok := object.Key("ScheduleFrequency")
		if err := awsRestjson1_serializeDocumentRefreshFrequency(v.ScheduleFrequency, ok); err != nil {
			return err
		}
	}

	if v.ScheduleId != nil {
		ok := object.Key("ScheduleId")
		ok.String(*v.ScheduleId)
	}

	if v.StartAfterDateTime != nil {
		ok := object.Key("StartAfterDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartAfterDateTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredCustomerManagedKey(v *types.RegisteredCustomerManagedKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultKey {
		ok := object.Key("DefaultKey")
		ok.Boolean(v.DefaultKey)
	}

	if v.KeyArn != nil {
		ok := object.Key("KeyArn")
		ok.String(*v.KeyArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserConsoleFeatureConfigurations(v *types.RegisteredUserConsoleFeatureConfigurations, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StatePersistence != nil {
		ok := object.Key("StatePersistence")
		if err := awsRestjson1_serializeDocumentStatePersistenceConfigurations(v.StatePersistence, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserDashboardEmbeddingConfiguration(v *types.RegisteredUserDashboardEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FeatureConfigurations != nil {
		ok := object.Key("FeatureConfigurations")
		if err := awsRestjson1_serializeDocumentRegisteredUserDashboardFeatureConfigurations(v.FeatureConfigurations, ok); err != nil {
			return err
		}
	}

	if v.InitialDashboardId != nil {
		ok := object.Key("InitialDashboardId")
		ok.String(*v.InitialDashboardId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserDashboardFeatureConfigurations(v *types.RegisteredUserDashboardFeatureConfigurations, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bookmarks != nil {
		ok := object.Key("Bookmarks")
		if err := awsRestjson1_serializeDocumentBookmarksConfigurations(v.Bookmarks, ok); err != nil {
			return err
		}
	}

	if v.StatePersistence != nil {
		ok := object.Key("StatePersistence")
		if err := awsRestjson1_serializeDocumentStatePersistenceConfigurations(v.StatePersistence, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserDashboardVisualEmbeddingConfiguration(v *types.RegisteredUserDashboardVisualEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialDashboardVisualId != nil {
		ok := object.Key("InitialDashboardVisualId")
		if err := awsRestjson1_serializeDocumentDashboardVisualId(v.InitialDashboardVisualId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserEmbeddingExperienceConfiguration(v *types.RegisteredUserEmbeddingExperienceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dashboard != nil {
		ok := object.Key("Dashboard")
		if err := awsRestjson1_serializeDocumentRegisteredUserDashboardEmbeddingConfiguration(v.Dashboard, ok); err != nil {
			return err
		}
	}

	if v.DashboardVisual != nil {
		ok := object.Key("DashboardVisual")
		if err := awsRestjson1_serializeDocumentRegisteredUserDashboardVisualEmbeddingConfiguration(v.DashboardVisual, ok); err != nil {
			return err
		}
	}

	if v.GenerativeQnA != nil {
		ok := object.Key("GenerativeQnA")
		if err := awsRestjson1_serializeDocumentRegisteredUserGenerativeQnAEmbeddingConfiguration(v.GenerativeQnA, ok); err != nil {
			return err
		}
	}

	if v.QSearchBar != nil {
		ok := object.Key("QSearchBar")
		if err := awsRestjson1_serializeDocumentRegisteredUserQSearchBarEmbeddingConfiguration(v.QSearchBar, ok); err != nil {
			return err
		}
	}

	if v.QuickSightConsole != nil {
		ok := object.Key("QuickSightConsole")
		if err := awsRestjson1_serializeDocumentRegisteredUserQuickSightConsoleEmbeddingConfiguration(v.QuickSightConsole, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserGenerativeQnAEmbeddingConfiguration(v *types.RegisteredUserGenerativeQnAEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialTopicId != nil {
		ok := object.Key("InitialTopicId")
		ok.String(*v.InitialTopicId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserQSearchBarEmbeddingConfiguration(v *types.RegisteredUserQSearchBarEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialTopicId != nil {
		ok := object.Key("InitialTopicId")
		ok.String(*v.InitialTopicId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserQuickSightConsoleEmbeddingConfiguration(v *types.RegisteredUserQuickSightConsoleEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FeatureConfigurations != nil {
		ok := object.Key("FeatureConfigurations")
		if err := awsRestjson1_serializeDocumentRegisteredUserConsoleFeatureConfigurations(v.FeatureConfigurations, ok); err != nil {
			return err
		}
	}

	if v.InitialPath != nil {
		ok := object.Key("InitialPath")
		ok.String(*v.InitialPath)
	}

	return nil
}

func awsRestjson1_serializeDocumentRelationalTable(v *types.RelationalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Catalog != nil {
		ok := object.Key("Catalog")
		ok.String(*v.Catalog)
	}

	if v.DataSourceArn != nil {
		ok := object.Key("DataSourceArn")
		ok.String(*v.DataSourceArn)
	}

	if v.InputColumns != nil {
		ok := object.Key("InputColumns")
		if err := awsRestjson1_serializeDocumentInputColumnList(v.InputColumns, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Schema != nil {
		ok := object.Key("Schema")
		ok.String(*v.Schema)
	}

	return nil
}

func awsRestjson1_serializeDocumentRelativeDatesFilter(v *types.RelativeDatesFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnchorDateConfiguration != nil {
		ok := object.Key("AnchorDateConfiguration")
		if err := awsRestjson1_serializeDocumentAnchorDateConfiguration(v.AnchorDateConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Column != nil {
		ok := object.Key("Column")
		if err := awsRestjson1_serializeDocumentColumnIdentifier(v.Column, ok); err != nil {
			return err
		}
	}

	if v.DefaultFilterControlConfiguration != nil {
		ok := object.Key("DefaultFilterControlConfiguration")
		if err := awsRestjson1_serializeDocumentDefaultFilterControlConfiguration(v.DefaultFilterControlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ExcludePeriodConfiguration != nil {
		ok := object.Key("ExcludePeriodConfiguration")
		if err := awsRestjson1_serializeDocumentExcludePeriodConfiguration(v.ExcludePeriodConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FilterId != nil {
		ok := object.Key("FilterId")
		ok.String(*v.FilterId)
	}

	if len(v.MinimumGranularity) > 0 {
		ok := object.Key("MinimumGranularity")
		ok.String(string(v.MinimumGranularity))
	}

	if len(v.NullOption) > 0 {
		ok := object.Key("NullOption")
		ok.String(string(v.NullOption))
	}

	if v.ParameterName != nil {
		ok := object.Key("ParameterName")
		ok.String(*v.ParameterName)
	}

	if len(v.RelativeDateType) > 0 {
		ok := object.Key("RelativeDateType")
		ok.String(string(v.RelativeDateType))
	}

	if v.RelativeDateValue != nil {
		ok := object.Key("RelativeDateValue")
		ok.Integer(*v.RelativeDateValue)
	}

	if len(v.TimeGranularity) > 0 {
		ok := object.Key("TimeGranularity")
		ok.String(string(v.TimeGranularity))
	}

	return nil
}

func awsRestjson1_serializeDocumentRelativeDateTimeControlDisplayOptions(v *types.RelativeDateTimeControlDisplayOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeFormat != nil {
		ok := object.Key("DateTimeFormat")
		ok.String(*v.DateTimeFormat)
	}

	if v.InfoIconLabelOptions != nil {
		ok := object.Key("InfoIconLabelOptions")
		if err := awsRestjson1_serializeDocumentSheetControlInfoIconLabelOptions(v.InfoIconLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.TitleOptions != nil {
		ok := object.Key("TitleOptions")
		if err := awsRestjson1_serializeDocumentLabelOptions(v.TitleOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRenameColumnOperation(v *types.RenameColumnOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.NewColumnName != nil {
		ok := object.Key("NewColumnName")
		ok.String(*v.NewColumnName)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourcePermission(v *types.ResourcePermission, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.Principal != nil {
		ok := object.Key("Principal")
		ok.String(*v.Principal)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourcePermissionList(v []types.ResourcePermission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentResourcePermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRollingDateConfiguration(v *types.RollingDateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetIdentifier != nil {
		ok := object.Key("DataSetIdentifier")
		ok.String(*v.DataSetIdentifier)
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	return nil
}

func awsRestjson1_serializeDocumentRowAlternateColorList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRowAlternateColorOptions(v *types.RowAlternateColorOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RowAlternateColors != nil {
		ok := object.Key("RowAlternateColors")
		if err := awsRestjson1_serializeDocumentRowAlternateColorList(v.RowAlternateColors, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if len(v.UsePrimaryBackgroundColor) > 0 {
		ok := object.Key("UsePrimaryBackgroundColor")
		ok.String(string(v.UsePrimaryBackgroundColor))
	}

	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionDataSet(v *types.RowLevelPermissionDataSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if len(v.FormatVersion) > 0 {
		ok := object.Key("FormatVersion")
		ok.String(string(v.FormatVersion))
	}

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	if len(v.PermissionPolicy) > 0 {
		ok := object.Key("PermissionPolicy")
		ok.String(string(v.PermissionPolicy))
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionTagConfiguration(v *types.RowLevelPermissionTagConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if v.TagRuleConfigurations != nil {
		ok := object.Key("TagRuleConfigurations")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagRuleConfigurationList(v.TagRuleConfigurations, ok); err != nil {
			return err
		}
	}

	if v.TagRules != nil {
		ok := object.Key("TagRules")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagRuleList(v.TagRules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionTagRule(v *types.RowLevelPermissionTagRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.MatchAllValue != nil {
		ok := object.Key("MatchAllValue")
		ok.String(*v.MatchAllValue)
	}

	if v.TagKey != nil {
		ok := object.Key("TagKey")
		ok.String(*v.TagKey)
	}

	if v.TagMultiValueDelimiter != nil {
		ok := object.Key("TagMultiValueDelimiter")
		ok.String(*v.TagMultiValueDelimiter)
	}

	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionTagRuleConfiguration(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionTagRuleConfigurationList(v [][]string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagRuleConfiguration(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionTagRuleList(v []types.RowLevelPermissionTagRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRowSortList(v []types.FieldSortOptions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFieldSortOptions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentS3BucketConfiguration(v *types.S3BucketConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("BucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("BucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	if v.BucketRegion != nil {
		ok := object.Key("BucketRegion")
		ok.String(*v.BucketRegion)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Parameters(v *types.S3Parameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManifestFileLocation != nil {
		ok := object.Key("ManifestFileLocation")
		if err := awsRestjson1_serializeDocumentManifestFileLocation(v.ManifestFileLocation, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Source(v *types.S3Source, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceArn != nil {
		ok := object.Key("DataSourceArn")
		ok.String(*v.DataSourceArn)
	}

	if v.InputColumns != nil {
		ok := object.Key("InputColumns")
		if err := awsRestjson1_serializeDocumentInputColumnList(v.InputColumns, ok); err != nil {
			return err
		}
	}

	if v.UploadSettings != nil {
		ok := object.Key("UploadSettings")
		if err := awsRestjson1_serializeDocumentUploadSettings(v.UploadSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSameSheetTargetVisualConfiguration(v *types.SameSheetTargetVisualConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.TargetVisualOptions) > 0 {
		ok := object.Key("TargetVisualOptions")
		ok.String(string(v.TargetVisualOptions))
	}

	if v.TargetVisuals != nil {
		ok := object.Key("TargetVisuals")
		if err := awsRestjson1_serializeDocumentTargetVisualList(v.TargetVisuals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSankeyDiagramAggregatedFieldWells(v *types.SankeyDiagramAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("Destination")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("Source")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Source, ok); err != nil {
			return err
		}
	}

	if v.Weight != nil {
		ok := object.Key("Weight")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.Weight, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSankeyDiagramChartConfiguration(v *types.SankeyDiagramChartConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataLabels != nil {
		ok := object.Key("DataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.DataLabels, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentSankeyDiagramFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentSankeyDiagramSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSankeyDiagramFieldWells(v *types.SankeyDiagramFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SankeyDiagramAggregatedFieldWells != nil {
		ok := object.Key("SankeyDiagramAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentSankeyDiagramAggregatedFieldWells(v.SankeyDiagramAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSankeyDiagramSortConfiguration(v *types.SankeyDiagramSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationItemsLimit != nil {
		ok := object.Key("DestinationItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.DestinationItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.SourceItemsLimit != nil {
		ok := object.Key("SourceItemsLimit")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.SourceItemsLimit, ok); err != nil {
			return err
		}
	}

	if v.WeightSort != nil {
		ok := object.Key("WeightSort")
		if err := awsRestjson1_serializeDocumentFieldSortOptionsList(v.WeightSort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSankeyDiagramVisual(v *types.SankeyDiagramVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentSankeyDiagramChartConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentScatterPlotCategoricallyAggregatedFieldWells(v *types.ScatterPlotCategoricallyAggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("Category")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Category, ok); err != nil {
			return err
		}
	}

	if v.Label != nil {
		ok := object.Key("Label")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Label, ok); err != nil {
			return err
		}
	}

	if v.Size != nil {
		ok := object.Key("Size")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.Size, ok); err != nil {
			return err
		}
	}

	if v.XAxis != nil {
		ok := object.Key("XAxis")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.XAxis, ok); err != nil {
			return err
		}
	}

	if v.YAxis != nil {
		ok := object.Key("YAxis")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.YAxis, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScatterPlotConfiguration(v *types.ScatterPlotConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataLabels != nil {
		ok := object.Key("DataLabels")
		if err := awsRestjson1_serializeDocumentDataLabelOptions(v.DataLabels, ok); err != nil {
			return err
		}
	}

	if v.FieldWells != nil {
		ok := object.Key("FieldWells")
		if err := awsRestjson1_serializeDocumentScatterPlotFieldWells(v.FieldWells, ok); err != nil {
			return err
		}
	}

	if v.Interactions != nil {
		ok := object.Key("Interactions")
		if err := awsRestjson1_serializeDocumentVisualInteractionOptions(v.Interactions, ok); err != nil {
			return err
		}
	}

	if v.Legend != nil {
		ok := object.Key("Legend")
		if err := awsRestjson1_serializeDocumentLegendOptions(v.Legend, ok); err != nil {
			return err
		}
	}

	if v.SortConfiguration != nil {
		ok := object.Key("SortConfiguration")
		if err := awsRestjson1_serializeDocumentScatterPlotSortConfiguration(v.SortConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tooltip != nil {
		ok := object.Key("Tooltip")
		if err := awsRestjson1_serializeDocumentTooltipOptions(v.Tooltip, ok); err != nil {
			return err
		}
	}

	if v.VisualPalette != nil {
		ok := object.Key("VisualPalette")
		if err := awsRestjson1_serializeDocumentVisualPalette(v.VisualPalette, ok); err != nil {
			return err
		}
	}

	if v.XAxisDisplayOptions != nil {
		ok := object.Key("XAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.XAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.XAxisLabelOptions != nil {
		ok := object.Key("XAxisLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.XAxisLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.YAxisDisplayOptions != nil {
		ok := object.Key("YAxisDisplayOptions")
		if err := awsRestjson1_serializeDocumentAxisDisplayOptions(v.YAxisDisplayOptions, ok); err != nil {
			return err
		}
	}

	if v.YAxisLabelOptions != nil {
		ok := object.Key("YAxisLabelOptions")
		if err := awsRestjson1_serializeDocumentChartAxisLabelOptions(v.YAxisLabelOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScatterPlotFieldWells(v *types.ScatterPlotFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScatterPlotCategoricallyAggregatedFieldWells != nil {
		ok := object.Key("ScatterPlotCategoricallyAggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentScatterPlotCategoricallyAggregatedFieldWells(v.ScatterPlotCategoricallyAggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	if v.ScatterPlotUnaggregatedFieldWells != nil {
		ok := object.Key("ScatterPlotUnaggregatedFieldWells")
		if err := awsRestjson1_serializeDocumentScatterPlotUnaggregatedFieldWells(v.ScatterPlotUnaggregatedFieldWells, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScatterPlotSortConfiguration(v *types.ScatterPlotSortConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScatterPlotLimitConfiguration != nil {
		ok := object.Key("ScatterPlotLimitConfiguration")
		if err := awsRestjson1_serializeDocumentItemsLimitConfiguration(v.ScatterPlotLimitConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScatterPlotUnaggregatedFieldWells(v *types.ScatterPlotUnaggregatedFieldWells, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("Category")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Category, ok); err != nil {
			return err
		}
	}

	if v.Label != nil {
		ok := object.Key("Label")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.Label, ok); err != nil {
			return err
		}
	}

	if v.Size != nil {
		ok := object.Key("Size")
		if err := awsRestjson1_serializeDocumentMeasureFieldList(v.Size, ok); err != nil {
			return err
		}
	}

	if v.XAxis != nil {
		ok := object.Key("XAxis")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.XAxis, ok); err != nil {
			return err
		}
	}

	if v.YAxis != nil {
		ok := object.Key("YAxis")
		if err := awsRestjson1_serializeDocumentDimensionFieldList(v.YAxis, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScatterPlotVisual(v *types.ScatterPlotVisual, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentVisualCustomActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ChartConfiguration != nil {
		ok := object.Key("ChartConfiguration")
		if err := awsRestjson1_serializeDocumentScatterPlotConfiguration(v.ChartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ColumnHierarchies != nil {
		ok := object.Key("ColumnHierarchies")
		if err := awsRestjson1_serializeDocumentColumnHierarchyList(v.ColumnHierarchies, ok); err != nil {
			return err
		}
	}

	if v.Subtitle != nil {
		ok := object.Key("Subtitle")
		if err := awsRestjson1_serializeDocumentVisualSubtitleLabelOptions(v.Subtitle, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentVisualTitleLabelOptions(v.Title, ok); err != nil {
			return err
		}
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentScheduleRefreshOnEntity(v *types.ScheduleRefreshOnEntity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DayOfMonth != nil {
		ok := object.Key("DayOfMonth")
		ok.String(*v.DayOfMonth)
	}

	if len(v.DayOfWeek) > 0 {
		ok := object.Key("DayOfWeek")
		ok.String(string(v.DayOfWeek))
	}

	return nil
}

func awsRestjson1_serializeDocumentScrollBarOptions(v *types.ScrollBarOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	if v.VisibleRange != nil {
		ok := object.Key("VisibleRange")
		if err := awsRestjson1_serializeDocumentVisibleRangeOptions(v.VisibleRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSecondaryValueOptions(v *types.SecondaryValueOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentSectionAfterPageBreak(v *types.SectionAfterPageBreak, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentSectionBasedLayoutCanvasSizeOptions(v *types.SectionBasedLayoutCanvasSizeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PaperCanvasSizeOptions != nil {
		ok := object.Key("PaperCanvasSizeOptions")
		if err := awsRestjson1_serializeDocumentSectionBasedLayoutPaperCanvasSizeOptions(v.PaperCanvasSizeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSectionBasedLayoutConfiguration(v *types.SectionBasedLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BodySections != nil {
		ok := object.Key("BodySections")
		if err := awsRestjson1_serializeDocumentBodySectionConfigurationList(v.BodySections, ok); err != nil {
			return err
		}
	}

	if v.CanvasSizeOptions != nil {
		ok := object.Key("CanvasSizeOptions")
		if err := awsRestjson1_serializeDocumentSectionBasedLayoutCanvasSizeOptions(v.CanvasSizeOptions, ok); err != nil {
			return err
		}
	}

	if v.FooterSections != nil {
		ok := object.Key("FooterSections")
		if err := awsRestjson1_serializeDocumentHeaderFooterSectionConfigurationList(v.FooterSections, ok); err != nil {
			return err
		}
	}

	if v.HeaderSections != nil {
		ok := object.Key("HeaderSections")
		if err := awsRestjson1_serializeDocumentHeaderFooterSectionConfigurationList(v.HeaderSections, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSectionBasedLayoutPaperCanvasSizeOptions(v *types.SectionBasedLayoutPaperCanvasSizeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PaperMargin != nil {
		ok := object.Key("PaperMargin")
		if err := awsRestjson1_serializeDocumentSpacing(v.PaperMargin, ok); err != nil {
			return err
		}
	}

	if len(v.PaperOrientation) > 0 {
		ok := object.Key("PaperOrientation")
		ok.String(string(v.PaperOrientation))
	}

	if len(v.PaperSize) > 0 {
		ok := object.Key("PaperSize")
		ok.String(string(v.PaperSize))
	}

	return nil
}

func awsRestjson1_serializeDocumentSectionLayoutConfiguration(v *types.SectionLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FreeFormLayout != nil {
		ok := object.Key("FreeFormLayout")
		if err := awsRestjson1_serializeDocumentFreeFormSectionLayoutConfiguration(v.FreeFormLayout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSectionPageBreakConfiguration(v *types.SectionPageBreakConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.After != nil {
		ok := object.Key("After")
		if err := awsRestjson1_serializeDocumentSectionAfterPageBreak(v.After, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSectionStyle(v *types.SectionStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Height != nil {
		ok := object.Key("Height")
		ok.String(*v.Height)
	}

	if v.Padding != nil {
		ok := object.Key("Padding")
		if err := awsRestjson1_serializeDocumentSpacing(v.Padding, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSelectedFieldList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSelectedSheetsFilterScopeConfiguration(v *types.SelectedSheetsFilterScopeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SheetVisualScopingConfigurations != nil {
		ok := object.Key("SheetVisualScopingConfigurations")
		if err := awsRestjson1_serializeDocumentSheetVisualScopingConfigurations(v.SheetVisualScopingConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSemanticEntityType(v *types.SemanticEntityType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SubTypeName != nil {
		ok := object.Key("SubTypeName")
		ok.String(*v.SubTypeName)
	}

	if v.TypeName != nil {
		ok := object.Key("TypeName")
		ok.String(*v.TypeName)
	}

	if v.TypeParameters != nil {
		ok := object.Key("TypeParameters")
		if err := awsRestjson1_serializeDocumentTypeParameters(v.TypeParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSemanticType(v *types.SemanticType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FalseyCellValue != nil {
		ok := object.Key("FalseyCellValue")
		ok.String(*v.FalseyCellValue)
	}

	if v.FalseyCellValueSynonyms != nil {
		ok := object.Key("FalseyCellValueSynonyms")
		if err := awsRestjson1_serializeDocumentSensitiveStringList(v.FalseyCellValueSynonyms, ok); err != nil {
			return err
		}
	}

	if v.SubTypeName != nil {
		ok := object.Key("SubTypeName")
		ok.String(*v.SubTypeName)
	}

	if v.TruthyCellValue != nil {
		ok := object.Key("TruthyCellValue")
		ok.String(*v.TruthyCellValue)
	}

	if v.TruthyCellValueSynonyms != nil {
		ok := object.Key("TruthyCellValueSynonyms")
		if err := awsRestjson1_serializeDocumentSensitiveStringList(v.TruthyCellValueSynonyms, ok); err != nil {
			return err
		}
	}

	if v.TypeName != nil {
		ok := object.Key("TypeName")
		ok.String(*v.TypeName)
	}

	if v.TypeParameters != nil {
		ok := object.Key("TypeParameters")
		if err := awsRestjson1_serializeDocumentTypeParameters(v.TypeParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSensitiveDoubleList(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSensitiveLongList(v []int64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Long(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSensitiveStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSensitiveTimestampList(v []time.Time, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Double(smithytime.FormatEpochSeconds(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSeriesItem(v *types.SeriesItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataFieldSeriesItem != nil {
		ok := object.Key("DataFieldSeriesItem")
		if err := awsRestjson1_serializeDocumentDataFieldSeriesItem(v.DataFieldSeriesItem, ok); err != nil {
			return err
		}
	}

	if v.FieldSeriesItem != nil {
		ok := object.Key("FieldSeriesItem")
		if err := awsRestjson1_serializeDocumentFieldSeriesItem(v.FieldSeriesItem, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSeriesItemList(v []types.SeriesItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSeriesItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentServiceNowParameters(v *types.ServiceNowParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SiteBaseUrl != nil {
		ok := object.Key("SiteBaseUrl")
		ok.String(*v.SiteBaseUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionTag(v *types.SessionTag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionTagList(v []types.SessionTag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSessionTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSetParameterValueConfiguration(v *types.SetParameterValueConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationParameterName != nil {
		ok := object.Key("DestinationParameterName")
		ok.String(*v.DestinationParameterName)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		if err := awsRestjson1_serializeDocumentDestinationParameterValueConfiguration(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSetParameterValueConfigurationList(v []types.SetParameterValueConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSetParameterValueConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentShapeConditionalFormat(v *types.ShapeConditionalFormat, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackgroundColor != nil {
		ok := object.Key("BackgroundColor")
		if err := awsRestjson1_serializeDocumentConditionalFormattingColor(v.BackgroundColor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetControlInfoIconLabelOptions(v *types.SheetControlInfoIconLabelOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InfoIconText != nil {
		ok := object.Key("InfoIconText")
		ok.String(*v.InfoIconText)
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetControlLayout(v *types.SheetControlLayout, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsRestjson1_serializeDocumentSheetControlLayoutConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetControlLayoutConfiguration(v *types.SheetControlLayoutConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GridLayout != nil {
		ok := object.Key("GridLayout")
		if err := awsRestjson1_serializeDocumentGridLayoutConfiguration(v.GridLayout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetControlLayoutList(v []types.SheetControlLayout, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSheetControlLayout(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSheetControlsOption(v *types.SheetControlsOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.VisibilityState) > 0 {
		ok := object.Key("VisibilityState")
		ok.String(string(v.VisibilityState))
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetDefinition(v *types.SheetDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContentType) > 0 {
		ok := object.Key("ContentType")
		ok.String(string(v.ContentType))
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.FilterControls != nil {
		ok := object.Key("FilterControls")
		if err := awsRestjson1_serializeDocumentFilterControlList(v.FilterControls, ok); err != nil {
			return err
		}
	}

	if v.Layouts != nil {
		ok := object.Key("Layouts")
		if err := awsRestjson1_serializeDocumentLayoutList(v.Layouts, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ParameterControls != nil {
		ok := object.Key("ParameterControls")
		if err := awsRestjson1_serializeDocumentParameterControlList(v.ParameterControls, ok); err != nil {
			return err
		}
	}

	if v.SheetControlLayouts != nil {
		ok := object.Key("SheetControlLayouts")
		if err := awsRestjson1_serializeDocumentSheetControlLayoutList(v.SheetControlLayouts, ok); err != nil {
			return err
		}
	}

	if v.SheetId != nil {
		ok := object.Key("SheetId")
		ok.String(*v.SheetId)
	}

	if v.TextBoxes != nil {
		ok := object.Key("TextBoxes")
		if err := awsRestjson1_serializeDocumentSheetTextBoxList(v.TextBoxes, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Visuals != nil {
		ok := object.Key("Visuals")
		if err := awsRestjson1_serializeDocumentVisualList(v.Visuals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetDefinitionList(v []types.SheetDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSheetDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSheetElementConfigurationOverrides(v *types.SheetElementConfigurationOverrides, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Visibility) > 0 {
		ok := object.Key("Visibility")
		ok.String(string(v.Visibility))
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetElementRenderingRule(v *types.SheetElementRenderingRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationOverrides != nil {
		ok := object.Key("ConfigurationOverrides")
		if err := awsRestjson1_serializeDocumentSheetElementConfigurationOverrides(v.ConfigurationOverrides, ok); err != nil {
			return err
		}
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetElementRenderingRuleList(v []types.SheetElementRenderingRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSheetElementRenderingRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSheetLayoutElementMaximizationOption(v *types.SheetLayoutElementMaximizationOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetStyle(v *types.SheetStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tile != nil {
		ok := object.Key("Tile")
		if err := awsRestjson1_serializeDocumentTileStyle(v.Tile, ok); err != nil {
			return err
		}
	}

	if v.TileLayout != nil {
		ok := object.Key("TileLayout")
		if err := awsRestjson1_serializeDocumentTileLayoutStyle(v.TileLayout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetTextBox(v *types.SheetTextBox, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		ok.String(*v.Content)
	}

	if v.SheetTextBoxId != nil {
		ok := object.Key("SheetTextBoxId")
		ok.String(*v.SheetTextBoxId)
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetTextBoxList(v []types.SheetTextBox, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSheetTextBox(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSheetVisualScopingConfiguration(v *types.SheetVisualScopingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.SheetId != nil {
		ok := object.Key("SheetId")
		ok.String(*v.SheetId)
	}

	if v.VisualIds != nil {
		ok := object.Key("VisualIds")
		if err := awsRestjson1_serializeDocumentFilteredVisualsList(v.VisualIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetVisualScopingConfigurations(v []types.SheetVisualScopingConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSheetVisualScopingConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentShortFormatText(v *types.ShortFormatText, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PlainText != nil {
		ok := object.Key("PlainText")
		ok.String(*v.PlainText)
	}

	if v.RichText != nil {
		ok := object.Key("RichText")
		ok.String(*v.RichText)
	}

	return nil
}

func awsRestjson1_serializeDocumentSimpleClusterMarker(v *types.SimpleClusterMarker, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Color != nil {
		ok := object.Key("Color")
		ok.String(*v.Color)
	}

	return nil
}

func awsRestjson1_serializeDocumentSingleAxisOptions(v *types.SingleAxisOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.YAxisOptions != nil {
		ok := object.Key("YAxisOptions")
		if err := awsRestjson1_serializeDocumentYAxisOptions(v.YAxisOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSliderControlDisplayOptions(v *types.SliderControlDisplayOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InfoIconLabelOptions != nil {
		ok := object.Key("InfoIconLabelOptions")
		if err := awsRestjson1_serializeDocumentSheetControlInfoIconLabelOptions(v.InfoIconLabelOptions, ok); err != nil {
			return err
		}
	}

	if v.TitleOptions != nil {
		ok := object.Key("TitleOptions")
		if err := awsRestjson1_serializeDocumentLabelOptions(v.TitleOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSmallMultiplesAxisProperties(v *types.SmallMultiplesAxisProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Placement) > 0 {
		ok := object.Key("Placement")
		ok.String(string(v.Placement))
	}

	if len(v.Scale) > 0 {
		ok := object.Key("Scale")
		ok.String(string(v.Scale))
	}

	return nil
}

func awsRestjson1_serializeDocumentSmallMultiplesDimensionFieldList(v []types.DimensionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSmallMultiplesOptions(v *types.SmallMultiplesOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxVisibleColumns != nil {
		ok := object.Key("MaxVisibleColumns")
		ok.Long(*v.MaxVisibleColumns)
	}

	if v.MaxVisibleRows != nil {
		ok := object.Key("MaxVisibleRows")
		ok.Long(*v.MaxVisibleRows)
	}

	if v.PanelConfiguration != nil {
		ok := object.Key("PanelConfiguration")
		if err := awsRestjson1_serializeDocumentPanelConfiguration(v.PanelConfiguration, ok); err != nil {
			return err
		}
	}

	if v.XAxis != nil {
		ok := object.Key("XAxis")
		if err := awsRestjson1_serializeDocumentSmallMultiplesAxisProperties(v.XAxis, ok); err != nil {
			return err
		}
	}

	if v.YAxis != nil {
		ok := object.Key("YAxis")
		if err := awsRestjson1_serializeDocumentSmallMultiplesAxisProperties(v.YAxis, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSnapshotAnonymousUser(v *types.SnapshotAnonymousUser, value smithyjson.Value) error {
	object := value.Object()
	defer object