// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates or updates a field value for a registration.
func (c *Client) PutRegistrationFieldValue(ctx context.Context, params *PutRegistrationFieldValueInput, optFns ...func(*Options)) (*PutRegistrationFieldValueOutput, error) {
	if params == nil {
		params = &PutRegistrationFieldValueInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutRegistrationFieldValue", params, optFns, c.addOperationPutRegistrationFieldValueMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutRegistrationFieldValueOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutRegistrationFieldValueInput struct {

	// The path to the registration form field. You can use DescribeRegistrationFieldDefinitions for a list of FieldPaths.
	//
	// This member is required.
	FieldPath *string

	// The unique identifier for the registration.
	//
	// This member is required.
	RegistrationId *string

	// The unique identifier for the registration attachment.
	RegistrationAttachmentId *string

	// An array of values for the form field.
	SelectChoices []string

	// The text data for a free form field.
	TextValue *string

	noSmithyDocumentSerde
}

type PutRegistrationFieldValueOutput struct {

	// The path to the registration form field. You can use DescribeRegistrationFieldDefinitions for a list of FieldPaths.
	//
	// This member is required.
	FieldPath *string

	// The Amazon Resource Name (ARN) for the registration.
	//
	// This member is required.
	RegistrationArn *string

	// The unique identifier for the registration.
	//
	// This member is required.
	RegistrationId *string

	// The version number of the registration.
	//
	// This member is required.
	VersionNumber *int64

	// The unique identifier for the registration attachment.
	RegistrationAttachmentId *string

	// An array of values for the form field.
	SelectChoices []string

	// The text data for a free form field.
	TextValue *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutRegistrationFieldValueMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpPutRegistrationFieldValue{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpPutRegistrationFieldValue{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutRegistrationFieldValue"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutRegistrationFieldValueValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutRegistrationFieldValue(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutRegistrationFieldValue(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutRegistrationFieldValue",
	}
}
