// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// [Calculates a route matrix] given the following required parameters: DeparturePositions and
// DestinationPositions . CalculateRouteMatrix calculates routes and returns the
// travel time and travel distance from each departure position to each destination
// position in the request. For example, given departure positions A and B, and
// destination positions X and Y, CalculateRouteMatrix will return time and
// distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The
// number of results returned (and routes calculated) will be the number of
// DeparturePositions times the number of DestinationPositions .
//
// Your account is charged for each route calculated, not the number of requests.
//
// Requires that you first [create a route calculator resource].
//
// By default, a request that doesn't specify a departure time uses the best time
// of day to travel with the best traffic conditions when calculating routes.
//
// Additional options include:
//
// [Specifying a departure time]
//   - using either DepartureTime or DepartNow . This calculates routes based on
//     predictive traffic data at the given time.
//
// You can't specify both DepartureTime and DepartNow in a single request.
//
//	Specifying both parameters returns a validation error.
//
// [Specifying a travel mode]
//   - using TravelMode sets the transportation mode used to calculate the routes.
//     This also lets you specify additional route preferences in CarModeOptions if
//     traveling by Car , or TruckModeOptions if traveling by Truck .
//
// [Specifying a departure time]: https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html
// [Specifying a travel mode]: https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html
// [Calculates a route matrix]: https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html
// [create a route calculator resource]: https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html
func (c *Client) CalculateRouteMatrix(ctx context.Context, params *CalculateRouteMatrixInput, optFns ...func(*Options)) (*CalculateRouteMatrixOutput, error) {
	if params == nil {
		params = &CalculateRouteMatrixInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CalculateRouteMatrix", params, optFns, c.addOperationCalculateRouteMatrixMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CalculateRouteMatrixOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CalculateRouteMatrixInput struct {

	// The name of the route calculator resource that you want to use to calculate the
	// route matrix.
	//
	// This member is required.
	CalculatorName *string

	// The list of departure (origin) positions for the route matrix. An array of
	// points, each of which is itself a 2-value array defined in [WGS 84]format: [longitude,
	// latitude] . For example, [-123.115, 49.285] .
	//
	// Depending on the data provider selected in the route calculator resource there
	// may be additional restrictions on the inputs you can choose. See [Position restrictions]in the Amazon
	// Location Service Developer Guide.
	//
	// For route calculators that use Esri as the data provider, if you specify a
	// departure that's not located on a road, Amazon Location [moves the position to the nearest road]. The snapped value is
	// available in the result in SnappedDeparturePositions .
	//
	// Valid Values: [-180 to 180,-90 to 90]
	//
	// [moves the position to the nearest road]: https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html
	// [WGS 84]: https://earth-info.nga.mil/GandG/wgs84/index.html
	// [Position restrictions]: https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits
	//
	// This member is required.
	DeparturePositions [][]float64

	// The list of destination positions for the route matrix. An array of points,
	// each of which is itself a 2-value array defined in [WGS 84]format: [longitude, latitude]
	// . For example, [-122.339, 47.615]
	//
	// Depending on the data provider selected in the route calculator resource there
	// may be additional restrictions on the inputs you can choose. See [Position restrictions]in the Amazon
	// Location Service Developer Guide.
	//
	// For route calculators that use Esri as the data provider, if you specify a
	// destination that's not located on a road, Amazon Location [moves the position to the nearest road]. The snapped value
	// is available in the result in SnappedDestinationPositions .
	//
	// Valid Values: [-180 to 180,-90 to 90]
	//
	// [moves the position to the nearest road]: https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html
	// [WGS 84]: https://earth-info.nga.mil/GandG/wgs84/index.html
	// [Position restrictions]: https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits
	//
	// This member is required.
	DestinationPositions [][]float64

	// Specifies route preferences when traveling by Car , such as avoiding routes that
	// use ferries or tolls.
	//
	// Requirements: TravelMode must be specified as Car .
	CarModeOptions *types.CalculateRouteCarModeOptions

	// Sets the time of departure as the current time. Uses the current time to
	// calculate the route matrix. You can't set both DepartureTime and DepartNow . If
	// neither is set, the best time of day to travel with the best traffic conditions
	// is used to calculate the route matrix.
	//
	// Default Value: false
	//
	// Valid Values: false | true
	DepartNow *bool

	// Specifies the desired time of departure. Uses the given time to calculate the
	// route matrix. You can't set both DepartureTime and DepartNow . If neither is
	// set, the best time of day to travel with the best traffic conditions is used to
	// calculate the route matrix.
	//
	// Setting a departure time in the past returns a 400 ValidationException error.
	//
	//   - In [ISO 8601]format: YYYY-MM-DDThh:mm:ss.sssZ . For example,
	//   2020–07-2T12:15:20.000Z+01:00
	//
	// [ISO 8601]: https://www.iso.org/iso-8601-date-and-time-format.html
	DepartureTime *time.Time

	// Set the unit system to specify the distance.
	//
	// Default Value: Kilometers
	DistanceUnit types.DistanceUnit

	// The optional [API key] to authorize the request.
	//
	// [API key]: https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html
	Key *string

	// Specifies the mode of transport when calculating a route. Used in estimating
	// the speed of travel and road compatibility.
	//
	// The TravelMode you specify also determines how you specify route preferences:
	//
	//   - If traveling by Car use the CarModeOptions parameter.
	//
	//   - If traveling by Truck use the TruckModeOptions parameter.
	//
	// Bicycle or Motorcycle are only valid when using Grab as a data provider, and
	// only within Southeast Asia.
	//
	// Truck is not available for Grab.
	//
	// For more information about using Grab as a data provider, see [GrabMaps] in the Amazon
	// Location Service Developer Guide.
	//
	// Default Value: Car
	//
	// [GrabMaps]: https://docs.aws.amazon.com/location/latest/developerguide/grab.html
	TravelMode types.TravelMode

	// Specifies route preferences when traveling by Truck , such as avoiding routes
	// that use ferries or tolls, and truck specifications to consider when choosing an
	// optimal road.
	//
	// Requirements: TravelMode must be specified as Truck .
	TruckModeOptions *types.CalculateRouteTruckModeOptions

	noSmithyDocumentSerde
}

// Returns the result of the route matrix calculation.
type CalculateRouteMatrixOutput struct {

	// The calculated route matrix containing the results for all pairs of
	// DeparturePositions to DestinationPositions . Each row corresponds to one entry
	// in DeparturePositions . Each entry in the row corresponds to the route from that
	// entry in DeparturePositions to an entry in DestinationPositions .
	//
	// This member is required.
	RouteMatrix [][]types.RouteMatrixEntry

	// Contains information about the route matrix, DataSource , DistanceUnit ,
	// RouteCount and ErrorCount .
	//
	// This member is required.
	Summary *types.CalculateRouteMatrixSummary

	// For routes calculated using an Esri route calculator resource, departure
	// positions are snapped to the closest road. For Esri route calculator resources,
	// this returns the list of departure/origin positions used for calculation of the
	// RouteMatrix .
	SnappedDeparturePositions [][]float64

	// The list of destination positions for the route matrix used for calculation of
	// the RouteMatrix .
	SnappedDestinationPositions [][]float64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCalculateRouteMatrixMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCalculateRouteMatrix{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCalculateRouteMatrix{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CalculateRouteMatrix"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCalculateRouteMatrixMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCalculateRouteMatrixValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCalculateRouteMatrix(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCalculateRouteMatrixMiddleware struct {
}

func (*endpointPrefix_opCalculateRouteMatrixMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCalculateRouteMatrixMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "routes." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCalculateRouteMatrixMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCalculateRouteMatrixMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opCalculateRouteMatrix(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CalculateRouteMatrix",
	}
}
