// Code generated by smithy-go-codegen DO NOT EDIT.

package entityresolution

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/entityresolution/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a schema mapping.
//
// A schema is immutable if it is being used by a workflow. Therefore, you can't
// update a schema mapping if it's associated with a workflow.
func (c *Client) UpdateSchemaMapping(ctx context.Context, params *UpdateSchemaMappingInput, optFns ...func(*Options)) (*UpdateSchemaMappingOutput, error) {
	if params == nil {
		params = &UpdateSchemaMappingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSchemaMapping", params, optFns, c.addOperationUpdateSchemaMappingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSchemaMappingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSchemaMappingInput struct {

	// A list of MappedInputFields . Each MappedInputField corresponds to a column the
	// source data table, and contains column name plus additional information that
	// Entity Resolution uses for matching.
	//
	// This member is required.
	MappedInputFields []types.SchemaInputAttribute

	// The name of the schema. There can't be multiple SchemaMappings with the same
	// name.
	//
	// This member is required.
	SchemaName *string

	// A description of the schema.
	Description *string

	noSmithyDocumentSerde
}

type UpdateSchemaMappingOutput struct {

	// A list of MappedInputFields . Each MappedInputField corresponds to a column the
	// source data table, and contains column name plus additional information that
	// Entity Resolution uses for matching.
	//
	// This member is required.
	MappedInputFields []types.SchemaInputAttribute

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the
	// SchemaMapping .
	//
	// This member is required.
	SchemaArn *string

	// The name of the schema.
	//
	// This member is required.
	SchemaName *string

	// A description of the schema.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSchemaMappingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateSchemaMapping{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateSchemaMapping{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateSchemaMapping"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateSchemaMappingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSchemaMapping(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSchemaMapping(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateSchemaMapping",
	}
}
