// Code generated by smithy-go-codegen DO NOT EDIT.

package controlcatalog

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/controlcatalog/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a paginated list of common controls from the Amazon Web Services
// Control Catalog.
//
// You can apply an optional filter to see common controls that have a specific
// objective. If you don’t provide a filter, the operation returns all common
// controls.
func (c *Client) ListCommonControls(ctx context.Context, params *ListCommonControlsInput, optFns ...func(*Options)) (*ListCommonControlsOutput, error) {
	if params == nil {
		params = &ListCommonControlsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCommonControls", params, optFns, c.addOperationListCommonControlsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCommonControlsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCommonControlsInput struct {

	// An optional filter that narrows the results to a specific objective.
	//
	// This filter allows you to specify one objective ARN at a time. Passing multiple
	// ARNs in the CommonControlFilter isn’t currently supported.
	CommonControlFilter *types.CommonControlFilter

	// The maximum number of results on a page or for an API request call.
	MaxResults *int32

	// The pagination token that's used to fetch the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCommonControlsOutput struct {

	// The list of common controls that the ListCommonControls API returns.
	//
	// This member is required.
	CommonControls []types.CommonControlSummary

	// The pagination token that's used to fetch the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCommonControlsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCommonControls{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCommonControls{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCommonControls"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCommonControls(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCommonControlsAPIClient is a client that implements the ListCommonControls
// operation.
type ListCommonControlsAPIClient interface {
	ListCommonControls(context.Context, *ListCommonControlsInput, ...func(*Options)) (*ListCommonControlsOutput, error)
}

var _ ListCommonControlsAPIClient = (*Client)(nil)

// ListCommonControlsPaginatorOptions is the paginator options for
// ListCommonControls
type ListCommonControlsPaginatorOptions struct {
	// The maximum number of results on a page or for an API request call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCommonControlsPaginator is a paginator for ListCommonControls
type ListCommonControlsPaginator struct {
	options   ListCommonControlsPaginatorOptions
	client    ListCommonControlsAPIClient
	params    *ListCommonControlsInput
	nextToken *string
	firstPage bool
}

// NewListCommonControlsPaginator returns a new ListCommonControlsPaginator
func NewListCommonControlsPaginator(client ListCommonControlsAPIClient, params *ListCommonControlsInput, optFns ...func(*ListCommonControlsPaginatorOptions)) *ListCommonControlsPaginator {
	if params == nil {
		params = &ListCommonControlsInput{}
	}

	options := ListCommonControlsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCommonControlsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCommonControlsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCommonControls page.
func (p *ListCommonControlsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCommonControlsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListCommonControls(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListCommonControls(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCommonControls",
	}
}
