// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateEvaluationJob struct {
}

func (*awsRestjson1_serializeOpCreateEvaluationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateEvaluationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEvaluationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/evaluation-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateEvaluationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateEvaluationJobInput(v *CreateEvaluationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateEvaluationJobInput(v *CreateEvaluationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.CustomerEncryptionKeyId != nil {
		ok := object.Key("customerEncryptionKeyId")
		ok.String(*v.CustomerEncryptionKeyId)
	}

	if v.EvaluationConfig != nil {
		ok := object.Key("evaluationConfig")
		if err := awsRestjson1_serializeDocumentEvaluationConfig(v.EvaluationConfig, ok); err != nil {
			return err
		}
	}

	if v.InferenceConfig != nil {
		ok := object.Key("inferenceConfig")
		if err := awsRestjson1_serializeDocumentEvaluationInferenceConfig(v.InferenceConfig, ok); err != nil {
			return err
		}
	}

	if v.JobDescription != nil {
		ok := object.Key("jobDescription")
		ok.String(*v.JobDescription)
	}

	if v.JobName != nil {
		ok := object.Key("jobName")
		ok.String(*v.JobName)
	}

	if v.JobTags != nil {
		ok := object.Key("jobTags")
		if err := awsRestjson1_serializeDocumentTagList(v.JobTags, ok); err != nil {
			return err
		}
	}

	if v.OutputDataConfig != nil {
		ok := object.Key("outputDataConfig")
		if err := awsRestjson1_serializeDocumentEvaluationOutputDataConfig(v.OutputDataConfig, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateGuardrail struct {
}

func (*awsRestjson1_serializeOpCreateGuardrail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGuardrail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGuardrailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGuardrailInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGuardrailInput(v *CreateGuardrailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGuardrailInput(v *CreateGuardrailInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockedInputMessaging != nil {
		ok := object.Key("blockedInputMessaging")
		ok.String(*v.BlockedInputMessaging)
	}

	if v.BlockedOutputsMessaging != nil {
		ok := object.Key("blockedOutputsMessaging")
		ok.String(*v.BlockedOutputsMessaging)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.ContentPolicyConfig != nil {
		ok := object.Key("contentPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailContentPolicyConfig(v.ContentPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SensitiveInformationPolicyConfig != nil {
		ok := object.Key("sensitiveInformationPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailSensitiveInformationPolicyConfig(v.SensitiveInformationPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TopicPolicyConfig != nil {
		ok := object.Key("topicPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailTopicPolicyConfig(v.TopicPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.WordPolicyConfig != nil {
		ok := object.Key("wordPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailWordPolicyConfig(v.WordPolicyConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateGuardrailVersion struct {
}

func (*awsRestjson1_serializeOpCreateGuardrailVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGuardrailVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGuardrailVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails/{guardrailIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateGuardrailVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGuardrailVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGuardrailVersionInput(v *CreateGuardrailVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier == nil || len(*v.GuardrailIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailIdentifier must not be empty")}
	}
	if v.GuardrailIdentifier != nil {
		if err := encoder.SetURI("guardrailIdentifier").String(*v.GuardrailIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGuardrailVersionInput(v *CreateGuardrailVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpCreateModelCustomizationJob struct {
}

func (*awsRestjson1_serializeOpCreateModelCustomizationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateModelCustomizationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateModelCustomizationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-customization-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateModelCustomizationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateModelCustomizationJobInput(v *CreateModelCustomizationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateModelCustomizationJobInput(v *CreateModelCustomizationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseModelIdentifier != nil {
		ok := object.Key("baseModelIdentifier")
		ok.String(*v.BaseModelIdentifier)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if len(v.CustomizationType) > 0 {
		ok := object.Key("customizationType")
		ok.String(string(v.CustomizationType))
	}

	if v.CustomModelKmsKeyId != nil {
		ok := object.Key("customModelKmsKeyId")
		ok.String(*v.CustomModelKmsKeyId)
	}

	if v.CustomModelName != nil {
		ok := object.Key("customModelName")
		ok.String(*v.CustomModelName)
	}

	if v.CustomModelTags != nil {
		ok := object.Key("customModelTags")
		if err := awsRestjson1_serializeDocumentTagList(v.CustomModelTags, ok); err != nil {
			return err
		}
	}

	if v.HyperParameters != nil {
		ok := object.Key("hyperParameters")
		if err := awsRestjson1_serializeDocumentModelCustomizationHyperParameters(v.HyperParameters, ok); err != nil {
			return err
		}
	}

	if v.JobName != nil {
		ok := object.Key("jobName")
		ok.String(*v.JobName)
	}

	if v.JobTags != nil {
		ok := object.Key("jobTags")
		if err := awsRestjson1_serializeDocumentTagList(v.JobTags, ok); err != nil {
			return err
		}
	}

	if v.OutputDataConfig != nil {
		ok := object.Key("outputDataConfig")
		if err := awsRestjson1_serializeDocumentOutputDataConfig(v.OutputDataConfig, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TrainingDataConfig != nil {
		ok := object.Key("trainingDataConfig")
		if err := awsRestjson1_serializeDocumentTrainingDataConfig(v.TrainingDataConfig, ok); err != nil {
			return err
		}
	}

	if v.ValidationDataConfig != nil {
		ok := object.Key("validationDataConfig")
		if err := awsRestjson1_serializeDocumentValidationDataConfig(v.ValidationDataConfig, ok); err != nil {
			return err
		}
	}

	if v.VpcConfig != nil {
		ok := object.Key("vpcConfig")
		if err := awsRestjson1_serializeDocumentVpcConfig(v.VpcConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateProvisionedModelThroughput struct {
}

func (*awsRestjson1_serializeOpCreateProvisionedModelThroughput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateProvisionedModelThroughput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProvisionedModelThroughputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughput")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateProvisionedModelThroughputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateProvisionedModelThroughputInput(v *CreateProvisionedModelThroughputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateProvisionedModelThroughputInput(v *CreateProvisionedModelThroughputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if len(v.CommitmentDuration) > 0 {
		ok := object.Key("commitmentDuration")
		ok.String(string(v.CommitmentDuration))
	}

	if v.ModelId != nil {
		ok := object.Key("modelId")
		ok.String(*v.ModelId)
	}

	if v.ModelUnits != nil {
		ok := object.Key("modelUnits")
		ok.Integer(*v.ModelUnits)
	}

	if v.ProvisionedModelName != nil {
		ok := object.Key("provisionedModelName")
		ok.String(*v.ProvisionedModelName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCustomModel struct {
}

func (*awsRestjson1_serializeOpDeleteCustomModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCustomModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-models/{modelIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCustomModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCustomModelInput(v *DeleteCustomModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelIdentifier == nil || len(*v.ModelIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelIdentifier must not be empty")}
	}
	if v.ModelIdentifier != nil {
		if err := encoder.SetURI("modelIdentifier").String(*v.ModelIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGuardrail struct {
}

func (*awsRestjson1_serializeOpDeleteGuardrail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGuardrail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGuardrailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails/{guardrailIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGuardrailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGuardrailInput(v *DeleteGuardrailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier == nil || len(*v.GuardrailIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailIdentifier must not be empty")}
	}
	if v.GuardrailIdentifier != nil {
		if err := encoder.SetURI("guardrailIdentifier").String(*v.GuardrailIdentifier); err != nil {
			return err
		}
	}

	if v.GuardrailVersion != nil {
		encoder.SetQuery("guardrailVersion").String(*v.GuardrailVersion)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteModelInvocationLoggingConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteModelInvocationLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteModelInvocationLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteModelInvocationLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging/modelinvocations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteModelInvocationLoggingConfigurationInput(v *DeleteModelInvocationLoggingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProvisionedModelThroughput struct {
}

func (*awsRestjson1_serializeOpDeleteProvisionedModelThroughput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProvisionedModelThroughput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProvisionedModelThroughputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughput/{provisionedModelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProvisionedModelThroughputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProvisionedModelThroughputInput(v *DeleteProvisionedModelThroughputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProvisionedModelId == nil || len(*v.ProvisionedModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provisionedModelId must not be empty")}
	}
	if v.ProvisionedModelId != nil {
		if err := encoder.SetURI("provisionedModelId").String(*v.ProvisionedModelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCustomModel struct {
}

func (*awsRestjson1_serializeOpGetCustomModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCustomModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCustomModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-models/{modelIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCustomModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCustomModelInput(v *GetCustomModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelIdentifier == nil || len(*v.ModelIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelIdentifier must not be empty")}
	}
	if v.ModelIdentifier != nil {
		if err := encoder.SetURI("modelIdentifier").String(*v.ModelIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEvaluationJob struct {
}

func (*awsRestjson1_serializeOpGetEvaluationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEvaluationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEvaluationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/evaluation-jobs/{jobIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEvaluationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEvaluationJobInput(v *GetEvaluationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFoundationModel struct {
}

func (*awsRestjson1_serializeOpGetFoundationModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFoundationModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFoundationModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/foundation-models/{modelIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFoundationModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFoundationModelInput(v *GetFoundationModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelIdentifier == nil || len(*v.ModelIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelIdentifier must not be empty")}
	}
	if v.ModelIdentifier != nil {
		if err := encoder.SetURI("modelIdentifier").String(*v.ModelIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetGuardrail struct {
}

func (*awsRestjson1_serializeOpGetGuardrail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetGuardrail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGuardrailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails/{guardrailIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetGuardrailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetGuardrailInput(v *GetGuardrailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier == nil || len(*v.GuardrailIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailIdentifier must not be empty")}
	}
	if v.GuardrailIdentifier != nil {
		if err := encoder.SetURI("guardrailIdentifier").String(*v.GuardrailIdentifier); err != nil {
			return err
		}
	}

	if v.GuardrailVersion != nil {
		encoder.SetQuery("guardrailVersion").String(*v.GuardrailVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetModelCustomizationJob struct {
}

func (*awsRestjson1_serializeOpGetModelCustomizationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModelCustomizationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelCustomizationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-customization-jobs/{jobIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetModelCustomizationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelCustomizationJobInput(v *GetModelCustomizationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetModelInvocationLoggingConfiguration struct {
}

func (*awsRestjson1_serializeOpGetModelInvocationLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModelInvocationLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelInvocationLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging/modelinvocations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelInvocationLoggingConfigurationInput(v *GetModelInvocationLoggingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetProvisionedModelThroughput struct {
}

func (*awsRestjson1_serializeOpGetProvisionedModelThroughput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetProvisionedModelThroughput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetProvisionedModelThroughputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughput/{provisionedModelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetProvisionedModelThroughputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetProvisionedModelThroughputInput(v *GetProvisionedModelThroughputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProvisionedModelId == nil || len(*v.ProvisionedModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provisionedModelId must not be empty")}
	}
	if v.ProvisionedModelId != nil {
		if err := encoder.SetURI("provisionedModelId").String(*v.ProvisionedModelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListCustomModels struct {
}

func (*awsRestjson1_serializeOpListCustomModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCustomModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCustomModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCustomModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCustomModelsInput(v *ListCustomModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BaseModelArnEquals != nil {
		encoder.SetQuery("baseModelArnEquals").String(*v.BaseModelArnEquals)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.FoundationModelArnEquals != nil {
		encoder.SetQuery("foundationModelArnEquals").String(*v.FoundationModelArnEquals)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListEvaluationJobs struct {
}

func (*awsRestjson1_serializeOpListEvaluationJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEvaluationJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEvaluationJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/evaluation-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEvaluationJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEvaluationJobsInput(v *ListEvaluationJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	return nil
}

type awsRestjson1_serializeOpListFoundationModels struct {
}

func (*awsRestjson1_serializeOpListFoundationModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFoundationModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFoundationModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/foundation-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFoundationModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFoundationModelsInput(v *ListFoundationModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ByCustomizationType) > 0 {
		encoder.SetQuery("byCustomizationType").String(string(v.ByCustomizationType))
	}

	if len(v.ByInferenceType) > 0 {
		encoder.SetQuery("byInferenceType").String(string(v.ByInferenceType))
	}

	if len(v.ByOutputModality) > 0 {
		encoder.SetQuery("byOutputModality").String(string(v.ByOutputModality))
	}

	if v.ByProvider != nil {
		encoder.SetQuery("byProvider").String(*v.ByProvider)
	}

	return nil
}

type awsRestjson1_serializeOpListGuardrails struct {
}

func (*awsRestjson1_serializeOpListGuardrails) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGuardrails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGuardrailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGuardrailsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGuardrailsInput(v *ListGuardrailsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier != nil {
		encoder.SetQuery("guardrailIdentifier").String(*v.GuardrailIdentifier)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListModelCustomizationJobs struct {
}

func (*awsRestjson1_serializeOpListModelCustomizationJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListModelCustomizationJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListModelCustomizationJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-customization-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListModelCustomizationJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListModelCustomizationJobsInput(v *ListModelCustomizationJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	return nil
}

type awsRestjson1_serializeOpListProvisionedModelThroughputs struct {
}

func (*awsRestjson1_serializeOpListProvisionedModelThroughputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProvisionedModelThroughputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProvisionedModelThroughputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProvisionedModelThroughputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProvisionedModelThroughputsInput(v *ListProvisionedModelThroughputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.ModelArnEquals != nil {
		encoder.SetQuery("modelArnEquals").String(*v.ModelArnEquals)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/listTagsForResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

type awsRestjson1_serializeOpPutModelInvocationLoggingConfiguration struct {
}

func (*awsRestjson1_serializeOpPutModelInvocationLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutModelInvocationLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutModelInvocationLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging/modelinvocations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutModelInvocationLoggingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutModelInvocationLoggingConfigurationInput(v *PutModelInvocationLoggingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutModelInvocationLoggingConfigurationInput(v *PutModelInvocationLoggingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LoggingConfig != nil {
		ok := object.Key("loggingConfig")
		if err := awsRestjson1_serializeDocumentLoggingConfig(v.LoggingConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopEvaluationJob struct {
}

func (*awsRestjson1_serializeOpStopEvaluationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopEvaluationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopEvaluationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/evaluation-job/{jobIdentifier}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopEvaluationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopEvaluationJobInput(v *StopEvaluationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopModelCustomizationJob struct {
}

func (*awsRestjson1_serializeOpStopModelCustomizationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopModelCustomizationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopModelCustomizationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-customization-jobs/{jobIdentifier}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopModelCustomizationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopModelCustomizationJobInput(v *StopModelCustomizationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tagResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/untagResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsRestjson1_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGuardrail struct {
}

func (*awsRestjson1_serializeOpUpdateGuardrail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGuardrail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGuardrailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails/{guardrailIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGuardrailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGuardrailInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGuardrailInput(v *UpdateGuardrailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier == nil || len(*v.GuardrailIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailIdentifier must not be empty")}
	}
	if v.GuardrailIdentifier != nil {
		if err := encoder.SetURI("guardrailIdentifier").String(*v.GuardrailIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGuardrailInput(v *UpdateGuardrailInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockedInputMessaging != nil {
		ok := object.Key("blockedInputMessaging")
		ok.String(*v.BlockedInputMessaging)
	}

	if v.BlockedOutputsMessaging != nil {
		ok := object.Key("blockedOutputsMessaging")
		ok.String(*v.BlockedOutputsMessaging)
	}

	if v.ContentPolicyConfig != nil {
		ok := object.Key("contentPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailContentPolicyConfig(v.ContentPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SensitiveInformationPolicyConfig != nil {
		ok := object.Key("sensitiveInformationPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailSensitiveInformationPolicyConfig(v.SensitiveInformationPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.TopicPolicyConfig != nil {
		ok := object.Key("topicPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailTopicPolicyConfig(v.TopicPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.WordPolicyConfig != nil {
		ok := object.Key("wordPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailWordPolicyConfig(v.WordPolicyConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateProvisionedModelThroughput struct {
}

func (*awsRestjson1_serializeOpUpdateProvisionedModelThroughput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateProvisionedModelThroughput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateProvisionedModelThroughputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughput/{provisionedModelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateProvisionedModelThroughputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateProvisionedModelThroughputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateProvisionedModelThroughputInput(v *UpdateProvisionedModelThroughputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProvisionedModelId == nil || len(*v.ProvisionedModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provisionedModelId must not be empty")}
	}
	if v.ProvisionedModelId != nil {
		if err := encoder.SetURI("provisionedModelId").String(*v.ProvisionedModelId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateProvisionedModelThroughputInput(v *UpdateProvisionedModelThroughputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DesiredModelId != nil {
		ok := object.Key("desiredModelId")
		ok.String(*v.DesiredModelId)
	}

	if v.DesiredProvisionedModelName != nil {
		ok := object.Key("desiredProvisionedModelName")
		ok.String(*v.DesiredProvisionedModelName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAutomatedEvaluationConfig(v *types.AutomatedEvaluationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetMetricConfigs != nil {
		ok := object.Key("datasetMetricConfigs")
		if err := awsRestjson1_serializeDocumentEvaluationDatasetMetricConfigs(v.DatasetMetricConfigs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudWatchConfig(v *types.CloudWatchConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LargeDataDeliveryS3Config != nil {
		ok := object.Key("largeDataDeliveryS3Config")
		if err := awsRestjson1_serializeDocumentS3Config(v.LargeDataDeliveryS3Config, ok); err != nil {
			return err
		}
	}

	if v.LogGroupName != nil {
		ok := object.Key("logGroupName")
		ok.String(*v.LogGroupName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationBedrockModel(v *types.EvaluationBedrockModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InferenceParams != nil {
		ok := object.Key("inferenceParams")
		ok.String(*v.InferenceParams)
	}

	if v.ModelIdentifier != nil {
		ok := object.Key("modelIdentifier")
		ok.String(*v.ModelIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationConfig(v types.EvaluationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluationConfigMemberAutomated:
		av := object.Key("automated")
		if err := awsRestjson1_serializeDocumentAutomatedEvaluationConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.EvaluationConfigMemberHuman:
		av := object.Key("human")
		if err := awsRestjson1_serializeDocumentHumanEvaluationConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationDataset(v *types.EvaluationDataset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetLocation != nil {
		ok := object.Key("datasetLocation")
		if err := awsRestjson1_serializeDocumentEvaluationDatasetLocation(v.DatasetLocation, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationDatasetLocation(v types.EvaluationDatasetLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluationDatasetLocationMemberS3Uri:
		av := object.Key("s3Uri")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationDatasetMetricConfig(v *types.EvaluationDatasetMetricConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dataset != nil {
		ok := object.Key("dataset")
		if err := awsRestjson1_serializeDocumentEvaluationDataset(v.Dataset, ok); err != nil {
			return err
		}
	}

	if v.MetricNames != nil {
		ok := object.Key("metricNames")
		if err := awsRestjson1_serializeDocumentEvaluationMetricNames(v.MetricNames, ok); err != nil {
			return err
		}
	}

	if len(v.TaskType) > 0 {
		ok := object.Key("taskType")
		ok.String(string(v.TaskType))
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationDatasetMetricConfigs(v []types.EvaluationDatasetMetricConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEvaluationDatasetMetricConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationInferenceConfig(v types.EvaluationInferenceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluationInferenceConfigMemberModels:
		av := object.Key("models")
		if err := awsRestjson1_serializeDocumentEvaluationModelConfigs(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationMetricNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationModelConfig(v types.EvaluationModelConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluationModelConfigMemberBedrockModel:
		av := object.Key("bedrockModel")
		if err := awsRestjson1_serializeDocumentEvaluationBedrockModel(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationModelConfigs(v []types.EvaluationModelConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentEvaluationModelConfig(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationOutputDataConfig(v *types.EvaluationOutputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailContentFilterConfig(v *types.GuardrailContentFilterConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InputStrength) > 0 {
		ok := object.Key("inputStrength")
		ok.String(string(v.InputStrength))
	}

	if len(v.OutputStrength) > 0 {
		ok := object.Key("outputStrength")
		ok.String(string(v.OutputStrength))
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailContentFiltersConfig(v []types.GuardrailContentFilterConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailContentFilterConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailContentPolicyConfig(v *types.GuardrailContentPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FiltersConfig != nil {
		ok := object.Key("filtersConfig")
		if err := awsRestjson1_serializeDocumentGuardrailContentFiltersConfig(v.FiltersConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailManagedWordListsConfig(v []types.GuardrailManagedWordsConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailManagedWordsConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailManagedWordsConfig(v *types.GuardrailManagedWordsConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailPiiEntitiesConfig(v []types.GuardrailPiiEntityConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailPiiEntityConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailPiiEntityConfig(v *types.GuardrailPiiEntityConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailRegexConfig(v *types.GuardrailRegexConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Pattern != nil {
		ok := object.Key("pattern")
		ok.String(*v.Pattern)
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailRegexesConfig(v []types.GuardrailRegexConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailRegexConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailSensitiveInformationPolicyConfig(v *types.GuardrailSensitiveInformationPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PiiEntitiesConfig != nil {
		ok := object.Key("piiEntitiesConfig")
		if err := awsRestjson1_serializeDocumentGuardrailPiiEntitiesConfig(v.PiiEntitiesConfig, ok); err != nil {
			return err
		}
	}

	if v.RegexesConfig != nil {
		ok := object.Key("regexesConfig")
		if err := awsRestjson1_serializeDocumentGuardrailRegexesConfig(v.RegexesConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailTopicConfig(v *types.GuardrailTopicConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("definition")
		ok.String(*v.Definition)
	}

	if v.Examples != nil {
		ok := object.Key("examples")
		if err := awsRestjson1_serializeDocumentGuardrailTopicExamples(v.Examples, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailTopicExamples(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailTopicPolicyConfig(v *types.GuardrailTopicPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TopicsConfig != nil {
		ok := object.Key("topicsConfig")
		if err := awsRestjson1_serializeDocumentGuardrailTopicsConfig(v.TopicsConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailTopicsConfig(v []types.GuardrailTopicConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailTopicConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailWordConfig(v *types.GuardrailWordConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailWordPolicyConfig(v *types.GuardrailWordPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManagedWordListsConfig != nil {
		ok := object.Key("managedWordListsConfig")
		if err := awsRestjson1_serializeDocumentGuardrailManagedWordListsConfig(v.ManagedWordListsConfig, ok); err != nil {
			return err
		}
	}

	if v.WordsConfig != nil {
		ok := object.Key("wordsConfig")
		if err := awsRestjson1_serializeDocumentGuardrailWordsConfig(v.WordsConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailWordsConfig(v []types.GuardrailWordConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailWordConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHumanEvaluationConfig(v *types.HumanEvaluationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomMetrics != nil {
		ok := object.Key("customMetrics")
		if err := awsRestjson1_serializeDocumentHumanEvaluationCustomMetrics(v.CustomMetrics, ok); err != nil {
			return err
		}
	}

	if v.DatasetMetricConfigs != nil {
		ok := object.Key("datasetMetricConfigs")
		if err := awsRestjson1_serializeDocumentEvaluationDatasetMetricConfigs(v.DatasetMetricConfigs, ok); err != nil {
			return err
		}
	}

	if v.HumanWorkflowConfig != nil {
		ok := object.Key("humanWorkflowConfig")
		if err := awsRestjson1_serializeDocumentHumanWorkflowConfig(v.HumanWorkflowConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHumanEvaluationCustomMetric(v *types.HumanEvaluationCustomMetric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RatingMethod != nil {
		ok := object.Key("ratingMethod")
		ok.String(*v.RatingMethod)
	}

	return nil
}

func awsRestjson1_serializeDocumentHumanEvaluationCustomMetrics(v []types.HumanEvaluationCustomMetric, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHumanEvaluationCustomMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHumanWorkflowConfig(v *types.HumanWorkflowConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowDefinitionArn != nil {
		ok := object.Key("flowDefinitionArn")
		ok.String(*v.FlowDefinitionArn)
	}

	if v.Instructions != nil {
		ok := object.Key("instructions")
		ok.String(*v.Instructions)
	}

	return nil
}

func awsRestjson1_serializeDocumentLoggingConfig(v *types.LoggingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchConfig != nil {
		ok := object.Key("cloudWatchConfig")
		if err := awsRestjson1_serializeDocumentCloudWatchConfig(v.CloudWatchConfig, ok); err != nil {
			return err
		}
	}

	if v.EmbeddingDataDeliveryEnabled != nil {
		ok := object.Key("embeddingDataDeliveryEnabled")
		ok.Boolean(*v.EmbeddingDataDeliveryEnabled)
	}

	if v.ImageDataDeliveryEnabled != nil {
		ok := object.Key("imageDataDeliveryEnabled")
		ok.Boolean(*v.ImageDataDeliveryEnabled)
	}

	if v.S3Config != nil {
		ok := object.Key("s3Config")
		if err := awsRestjson1_serializeDocumentS3Config(v.S3Config, ok); err != nil {
			return err
		}
	}

	if v.TextDataDeliveryEnabled != nil {
		ok := object.Key("textDataDeliveryEnabled")
		ok.Boolean(*v.TextDataDeliveryEnabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentModelCustomizationHyperParameters(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentOutputDataConfig(v *types.OutputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Config(v *types.S3Config, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.KeyPrefix != nil {
		ok := object.Key("keyPrefix")
		ok.String(*v.KeyPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubnetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTrainingDataConfig(v *types.TrainingDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentValidationDataConfig(v *types.ValidationDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Validators != nil {
		ok := object.Key("validators")
		if err := awsRestjson1_serializeDocumentValidators(v.Validators, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentValidator(v *types.Validator, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentValidators(v []types.Validator, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentValidator(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentVpcConfig(v *types.VpcConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}
