// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationcostprofiler

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/applicationcostprofiler/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of all reports and their configurations for your AWS account.
//
// The maximum number of reports is one.
func (c *Client) ListReportDefinitions(ctx context.Context, params *ListReportDefinitionsInput, optFns ...func(*Options)) (*ListReportDefinitionsOutput, error) {
	if params == nil {
		params = &ListReportDefinitionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListReportDefinitions", params, optFns, c.addOperationListReportDefinitionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListReportDefinitionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListReportDefinitionsInput struct {

	// The maximum number of results to return.
	MaxResults *int32

	// The token value from a previous call to access the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListReportDefinitionsOutput struct {

	// The value of the next token, if it exists. Null if there are no more results.
	NextToken *string

	// The retrieved reports.
	ReportDefinitions []types.ReportDefinition

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListReportDefinitionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListReportDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListReportDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListReportDefinitions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListReportDefinitions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListReportDefinitionsAPIClient is a client that implements the
// ListReportDefinitions operation.
type ListReportDefinitionsAPIClient interface {
	ListReportDefinitions(context.Context, *ListReportDefinitionsInput, ...func(*Options)) (*ListReportDefinitionsOutput, error)
}

var _ ListReportDefinitionsAPIClient = (*Client)(nil)

// ListReportDefinitionsPaginatorOptions is the paginator options for
// ListReportDefinitions
type ListReportDefinitionsPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListReportDefinitionsPaginator is a paginator for ListReportDefinitions
type ListReportDefinitionsPaginator struct {
	options   ListReportDefinitionsPaginatorOptions
	client    ListReportDefinitionsAPIClient
	params    *ListReportDefinitionsInput
	nextToken *string
	firstPage bool
}

// NewListReportDefinitionsPaginator returns a new ListReportDefinitionsPaginator
func NewListReportDefinitionsPaginator(client ListReportDefinitionsAPIClient, params *ListReportDefinitionsInput, optFns ...func(*ListReportDefinitionsPaginatorOptions)) *ListReportDefinitionsPaginator {
	if params == nil {
		params = &ListReportDefinitionsInput{}
	}

	options := ListReportDefinitionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListReportDefinitionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListReportDefinitionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListReportDefinitions page.
func (p *ListReportDefinitionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListReportDefinitionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListReportDefinitions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListReportDefinitions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListReportDefinitions",
	}
}
