//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// KustoPoolsClient contains the methods for the KustoPools group.
// Don't use this type directly, use NewKustoPoolsClient() instead.
type KustoPoolsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewKustoPoolsClient creates a new instance of KustoPoolsClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewKustoPoolsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*KustoPoolsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &KustoPoolsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginAddLanguageExtensions - Add a list of language extensions that can run within KQL queries.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// kustoPoolName - The name of the Kusto pool.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// languageExtensionsToAdd - The language extensions to add.
// options - KustoPoolsClientBeginAddLanguageExtensionsOptions contains the optional parameters for the KustoPoolsClient.BeginAddLanguageExtensions
// method.
func (client *KustoPoolsClient) BeginAddLanguageExtensions(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToAdd LanguageExtensionsList, options *KustoPoolsClientBeginAddLanguageExtensionsOptions) (*runtime.Poller[KustoPoolsClientAddLanguageExtensionsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.addLanguageExtensions(ctx, workspaceName, kustoPoolName, resourceGroupName, languageExtensionsToAdd, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KustoPoolsClientAddLanguageExtensionsResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KustoPoolsClientAddLanguageExtensionsResponse](options.ResumeToken, client.pl, nil)
	}
}

// AddLanguageExtensions - Add a list of language extensions that can run within KQL queries.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
func (client *KustoPoolsClient) addLanguageExtensions(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToAdd LanguageExtensionsList, options *KustoPoolsClientBeginAddLanguageExtensionsOptions) (*http.Response, error) {
	req, err := client.addLanguageExtensionsCreateRequest(ctx, workspaceName, kustoPoolName, resourceGroupName, languageExtensionsToAdd, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// addLanguageExtensionsCreateRequest creates the AddLanguageExtensions request.
func (client *KustoPoolsClient) addLanguageExtensionsCreateRequest(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToAdd LanguageExtensionsList, options *KustoPoolsClientBeginAddLanguageExtensionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/addLanguageExtensions"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, languageExtensionsToAdd)
}

// CheckNameAvailability - Checks that the kusto pool name is valid and is not already in use.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// location - The name of Azure region.
// kustoPoolName - The name of the cluster.
// options - KustoPoolsClientCheckNameAvailabilityOptions contains the optional parameters for the KustoPoolsClient.CheckNameAvailability
// method.
func (client *KustoPoolsClient) CheckNameAvailability(ctx context.Context, location string, kustoPoolName KustoPoolCheckNameRequest, options *KustoPoolsClientCheckNameAvailabilityOptions) (KustoPoolsClientCheckNameAvailabilityResponse, error) {
	req, err := client.checkNameAvailabilityCreateRequest(ctx, location, kustoPoolName, options)
	if err != nil {
		return KustoPoolsClientCheckNameAvailabilityResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return KustoPoolsClientCheckNameAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KustoPoolsClientCheckNameAvailabilityResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkNameAvailabilityHandleResponse(resp)
}

// checkNameAvailabilityCreateRequest creates the CheckNameAvailability request.
func (client *KustoPoolsClient) checkNameAvailabilityCreateRequest(ctx context.Context, location string, kustoPoolName KustoPoolCheckNameRequest, options *KustoPoolsClientCheckNameAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/locations/{location}/kustoPoolCheckNameAvailability"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, kustoPoolName)
}

// checkNameAvailabilityHandleResponse handles the CheckNameAvailability response.
func (client *KustoPoolsClient) checkNameAvailabilityHandleResponse(resp *http.Response) (KustoPoolsClientCheckNameAvailabilityResponse, error) {
	result := KustoPoolsClientCheckNameAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckNameResult); err != nil {
		return KustoPoolsClientCheckNameAvailabilityResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdate - Create or update a Kusto pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// kustoPoolName - The name of the Kusto pool.
// parameters - The Kusto pool parameters supplied to the CreateOrUpdate operation.
// options - KustoPoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the KustoPoolsClient.BeginCreateOrUpdate
// method.
func (client *KustoPoolsClient) BeginCreateOrUpdate(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPool, options *KustoPoolsClientBeginCreateOrUpdateOptions) (*runtime.Poller[KustoPoolsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, workspaceName, resourceGroupName, kustoPoolName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KustoPoolsClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KustoPoolsClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Create or update a Kusto pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
func (client *KustoPoolsClient) createOrUpdate(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPool, options *KustoPoolsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, workspaceName, resourceGroupName, kustoPoolName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *KustoPoolsClient) createOrUpdateCreateRequest(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPool, options *KustoPoolsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginDelete - Deletes a Kusto pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// kustoPoolName - The name of the Kusto pool.
// options - KustoPoolsClientBeginDeleteOptions contains the optional parameters for the KustoPoolsClient.BeginDelete method.
func (client *KustoPoolsClient) BeginDelete(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, options *KustoPoolsClientBeginDeleteOptions) (*runtime.Poller[KustoPoolsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, workspaceName, resourceGroupName, kustoPoolName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KustoPoolsClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KustoPoolsClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes a Kusto pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
func (client *KustoPoolsClient) deleteOperation(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, options *KustoPoolsClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, workspaceName, resourceGroupName, kustoPoolName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *KustoPoolsClient) deleteCreateRequest(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, options *KustoPoolsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDetachFollowerDatabases - Detaches all followers of a database owned by this Kusto Pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// kustoPoolName - The name of the Kusto pool.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// followerDatabaseToRemove - The follower databases properties to remove.
// options - KustoPoolsClientBeginDetachFollowerDatabasesOptions contains the optional parameters for the KustoPoolsClient.BeginDetachFollowerDatabases
// method.
func (client *KustoPoolsClient) BeginDetachFollowerDatabases(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, followerDatabaseToRemove FollowerDatabaseDefinition, options *KustoPoolsClientBeginDetachFollowerDatabasesOptions) (*runtime.Poller[KustoPoolsClientDetachFollowerDatabasesResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.detachFollowerDatabases(ctx, workspaceName, kustoPoolName, resourceGroupName, followerDatabaseToRemove, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KustoPoolsClientDetachFollowerDatabasesResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KustoPoolsClientDetachFollowerDatabasesResponse](options.ResumeToken, client.pl, nil)
	}
}

// DetachFollowerDatabases - Detaches all followers of a database owned by this Kusto Pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
func (client *KustoPoolsClient) detachFollowerDatabases(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, followerDatabaseToRemove FollowerDatabaseDefinition, options *KustoPoolsClientBeginDetachFollowerDatabasesOptions) (*http.Response, error) {
	req, err := client.detachFollowerDatabasesCreateRequest(ctx, workspaceName, kustoPoolName, resourceGroupName, followerDatabaseToRemove, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// detachFollowerDatabasesCreateRequest creates the DetachFollowerDatabases request.
func (client *KustoPoolsClient) detachFollowerDatabasesCreateRequest(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, followerDatabaseToRemove FollowerDatabaseDefinition, options *KustoPoolsClientBeginDetachFollowerDatabasesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/detachFollowerDatabases"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, followerDatabaseToRemove)
}

// Get - Gets a Kusto pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// kustoPoolName - The name of the Kusto pool.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - KustoPoolsClientGetOptions contains the optional parameters for the KustoPoolsClient.Get method.
func (client *KustoPoolsClient) Get(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientGetOptions) (KustoPoolsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, workspaceName, kustoPoolName, resourceGroupName, options)
	if err != nil {
		return KustoPoolsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return KustoPoolsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KustoPoolsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *KustoPoolsClient) getCreateRequest(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *KustoPoolsClient) getHandleResponse(resp *http.Response) (KustoPoolsClientGetResponse, error) {
	result := KustoPoolsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KustoPool); err != nil {
		return KustoPoolsClientGetResponse{}, err
	}
	return result, nil
}

// ListByWorkspace - List all Kusto pools
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// workspaceName - The name of the workspace.
// options - KustoPoolsClientListByWorkspaceOptions contains the optional parameters for the KustoPoolsClient.ListByWorkspace
// method.
func (client *KustoPoolsClient) ListByWorkspace(ctx context.Context, resourceGroupName string, workspaceName string, options *KustoPoolsClientListByWorkspaceOptions) (KustoPoolsClientListByWorkspaceResponse, error) {
	req, err := client.listByWorkspaceCreateRequest(ctx, resourceGroupName, workspaceName, options)
	if err != nil {
		return KustoPoolsClientListByWorkspaceResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return KustoPoolsClientListByWorkspaceResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KustoPoolsClientListByWorkspaceResponse{}, runtime.NewResponseError(resp)
	}
	return client.listByWorkspaceHandleResponse(resp)
}

// listByWorkspaceCreateRequest creates the ListByWorkspace request.
func (client *KustoPoolsClient) listByWorkspaceCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, options *KustoPoolsClientListByWorkspaceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByWorkspaceHandleResponse handles the ListByWorkspace response.
func (client *KustoPoolsClient) listByWorkspaceHandleResponse(resp *http.Response) (KustoPoolsClientListByWorkspaceResponse, error) {
	result := KustoPoolsClientListByWorkspaceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KustoPoolListResult); err != nil {
		return KustoPoolsClientListByWorkspaceResponse{}, err
	}
	return result, nil
}

// NewListFollowerDatabasesPager - Returns a list of databases that are owned by this Kusto Pool and were followed by another
// Kusto Pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// kustoPoolName - The name of the Kusto pool.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - KustoPoolsClientListFollowerDatabasesOptions contains the optional parameters for the KustoPoolsClient.ListFollowerDatabases
// method.
func (client *KustoPoolsClient) NewListFollowerDatabasesPager(workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientListFollowerDatabasesOptions) *runtime.Pager[KustoPoolsClientListFollowerDatabasesResponse] {
	return runtime.NewPager(runtime.PagingHandler[KustoPoolsClientListFollowerDatabasesResponse]{
		More: func(page KustoPoolsClientListFollowerDatabasesResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *KustoPoolsClientListFollowerDatabasesResponse) (KustoPoolsClientListFollowerDatabasesResponse, error) {
			req, err := client.listFollowerDatabasesCreateRequest(ctx, workspaceName, kustoPoolName, resourceGroupName, options)
			if err != nil {
				return KustoPoolsClientListFollowerDatabasesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return KustoPoolsClientListFollowerDatabasesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return KustoPoolsClientListFollowerDatabasesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listFollowerDatabasesHandleResponse(resp)
		},
	})
}

// listFollowerDatabasesCreateRequest creates the ListFollowerDatabases request.
func (client *KustoPoolsClient) listFollowerDatabasesCreateRequest(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientListFollowerDatabasesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/listFollowerDatabases"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFollowerDatabasesHandleResponse handles the ListFollowerDatabases response.
func (client *KustoPoolsClient) listFollowerDatabasesHandleResponse(resp *http.Response) (KustoPoolsClientListFollowerDatabasesResponse, error) {
	result := KustoPoolsClientListFollowerDatabasesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FollowerDatabaseListResult); err != nil {
		return KustoPoolsClientListFollowerDatabasesResponse{}, err
	}
	return result, nil
}

// NewListLanguageExtensionsPager - Returns a list of language extensions that can run within KQL queries.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// kustoPoolName - The name of the Kusto pool.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - KustoPoolsClientListLanguageExtensionsOptions contains the optional parameters for the KustoPoolsClient.ListLanguageExtensions
// method.
func (client *KustoPoolsClient) NewListLanguageExtensionsPager(workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientListLanguageExtensionsOptions) *runtime.Pager[KustoPoolsClientListLanguageExtensionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[KustoPoolsClientListLanguageExtensionsResponse]{
		More: func(page KustoPoolsClientListLanguageExtensionsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *KustoPoolsClientListLanguageExtensionsResponse) (KustoPoolsClientListLanguageExtensionsResponse, error) {
			req, err := client.listLanguageExtensionsCreateRequest(ctx, workspaceName, kustoPoolName, resourceGroupName, options)
			if err != nil {
				return KustoPoolsClientListLanguageExtensionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return KustoPoolsClientListLanguageExtensionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return KustoPoolsClientListLanguageExtensionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listLanguageExtensionsHandleResponse(resp)
		},
	})
}

// listLanguageExtensionsCreateRequest creates the ListLanguageExtensions request.
func (client *KustoPoolsClient) listLanguageExtensionsCreateRequest(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientListLanguageExtensionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/listLanguageExtensions"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listLanguageExtensionsHandleResponse handles the ListLanguageExtensions response.
func (client *KustoPoolsClient) listLanguageExtensionsHandleResponse(resp *http.Response) (KustoPoolsClientListLanguageExtensionsResponse, error) {
	result := KustoPoolsClientListLanguageExtensionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LanguageExtensionsList); err != nil {
		return KustoPoolsClientListLanguageExtensionsResponse{}, err
	}
	return result, nil
}

// NewListSKUsPager - Lists eligible SKUs for Kusto Pool resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// options - KustoPoolsClientListSKUsOptions contains the optional parameters for the KustoPoolsClient.ListSKUs method.
func (client *KustoPoolsClient) NewListSKUsPager(options *KustoPoolsClientListSKUsOptions) *runtime.Pager[KustoPoolsClientListSKUsResponse] {
	return runtime.NewPager(runtime.PagingHandler[KustoPoolsClientListSKUsResponse]{
		More: func(page KustoPoolsClientListSKUsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *KustoPoolsClientListSKUsResponse) (KustoPoolsClientListSKUsResponse, error) {
			req, err := client.listSKUsCreateRequest(ctx, options)
			if err != nil {
				return KustoPoolsClientListSKUsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return KustoPoolsClientListSKUsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return KustoPoolsClientListSKUsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSKUsHandleResponse(resp)
		},
	})
}

// listSKUsCreateRequest creates the ListSKUs request.
func (client *KustoPoolsClient) listSKUsCreateRequest(ctx context.Context, options *KustoPoolsClientListSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/skus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSKUsHandleResponse handles the ListSKUs response.
func (client *KustoPoolsClient) listSKUsHandleResponse(resp *http.Response) (KustoPoolsClientListSKUsResponse, error) {
	result := KustoPoolsClientListSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUDescriptionList); err != nil {
		return KustoPoolsClientListSKUsResponse{}, err
	}
	return result, nil
}

// NewListSKUsByResourcePager - Returns the SKUs available for the provided resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// kustoPoolName - The name of the Kusto pool.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - KustoPoolsClientListSKUsByResourceOptions contains the optional parameters for the KustoPoolsClient.ListSKUsByResource
// method.
func (client *KustoPoolsClient) NewListSKUsByResourcePager(workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientListSKUsByResourceOptions) *runtime.Pager[KustoPoolsClientListSKUsByResourceResponse] {
	return runtime.NewPager(runtime.PagingHandler[KustoPoolsClientListSKUsByResourceResponse]{
		More: func(page KustoPoolsClientListSKUsByResourceResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *KustoPoolsClientListSKUsByResourceResponse) (KustoPoolsClientListSKUsByResourceResponse, error) {
			req, err := client.listSKUsByResourceCreateRequest(ctx, workspaceName, kustoPoolName, resourceGroupName, options)
			if err != nil {
				return KustoPoolsClientListSKUsByResourceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return KustoPoolsClientListSKUsByResourceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return KustoPoolsClientListSKUsByResourceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSKUsByResourceHandleResponse(resp)
		},
	})
}

// listSKUsByResourceCreateRequest creates the ListSKUsByResource request.
func (client *KustoPoolsClient) listSKUsByResourceCreateRequest(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientListSKUsByResourceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/skus"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSKUsByResourceHandleResponse handles the ListSKUsByResource response.
func (client *KustoPoolsClient) listSKUsByResourceHandleResponse(resp *http.Response) (KustoPoolsClientListSKUsByResourceResponse, error) {
	result := KustoPoolsClientListSKUsByResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ListResourceSKUsResult); err != nil {
		return KustoPoolsClientListSKUsByResourceResponse{}, err
	}
	return result, nil
}

// BeginRemoveLanguageExtensions - Remove a list of language extensions that can run within KQL queries.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// kustoPoolName - The name of the Kusto pool.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// languageExtensionsToRemove - The language extensions to remove.
// options - KustoPoolsClientBeginRemoveLanguageExtensionsOptions contains the optional parameters for the KustoPoolsClient.BeginRemoveLanguageExtensions
// method.
func (client *KustoPoolsClient) BeginRemoveLanguageExtensions(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToRemove LanguageExtensionsList, options *KustoPoolsClientBeginRemoveLanguageExtensionsOptions) (*runtime.Poller[KustoPoolsClientRemoveLanguageExtensionsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.removeLanguageExtensions(ctx, workspaceName, kustoPoolName, resourceGroupName, languageExtensionsToRemove, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KustoPoolsClientRemoveLanguageExtensionsResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KustoPoolsClientRemoveLanguageExtensionsResponse](options.ResumeToken, client.pl, nil)
	}
}

// RemoveLanguageExtensions - Remove a list of language extensions that can run within KQL queries.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
func (client *KustoPoolsClient) removeLanguageExtensions(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToRemove LanguageExtensionsList, options *KustoPoolsClientBeginRemoveLanguageExtensionsOptions) (*http.Response, error) {
	req, err := client.removeLanguageExtensionsCreateRequest(ctx, workspaceName, kustoPoolName, resourceGroupName, languageExtensionsToRemove, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// removeLanguageExtensionsCreateRequest creates the RemoveLanguageExtensions request.
func (client *KustoPoolsClient) removeLanguageExtensionsCreateRequest(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToRemove LanguageExtensionsList, options *KustoPoolsClientBeginRemoveLanguageExtensionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/removeLanguageExtensions"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, languageExtensionsToRemove)
}

// BeginStart - Starts a Kusto pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// kustoPoolName - The name of the Kusto pool.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - KustoPoolsClientBeginStartOptions contains the optional parameters for the KustoPoolsClient.BeginStart method.
func (client *KustoPoolsClient) BeginStart(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientBeginStartOptions) (*runtime.Poller[KustoPoolsClientStartResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.start(ctx, workspaceName, kustoPoolName, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KustoPoolsClientStartResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KustoPoolsClientStartResponse](options.ResumeToken, client.pl, nil)
	}
}

// Start - Starts a Kusto pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
func (client *KustoPoolsClient) start(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientBeginStartOptions) (*http.Response, error) {
	req, err := client.startCreateRequest(ctx, workspaceName, kustoPoolName, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// startCreateRequest creates the Start request.
func (client *KustoPoolsClient) startCreateRequest(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientBeginStartOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/start"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginStop - Stops a Kusto pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// kustoPoolName - The name of the Kusto pool.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - KustoPoolsClientBeginStopOptions contains the optional parameters for the KustoPoolsClient.BeginStop method.
func (client *KustoPoolsClient) BeginStop(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientBeginStopOptions) (*runtime.Poller[KustoPoolsClientStopResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.stop(ctx, workspaceName, kustoPoolName, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KustoPoolsClientStopResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KustoPoolsClientStopResponse](options.ResumeToken, client.pl, nil)
	}
}

// Stop - Stops a Kusto pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
func (client *KustoPoolsClient) stop(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientBeginStopOptions) (*http.Response, error) {
	req, err := client.stopCreateRequest(ctx, workspaceName, kustoPoolName, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// stopCreateRequest creates the Stop request.
func (client *KustoPoolsClient) stopCreateRequest(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *KustoPoolsClientBeginStopOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/stop"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginUpdate - Update a Kusto Kusto Pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
// workspaceName - The name of the workspace.
// resourceGroupName - The name of the resource group. The name is case insensitive.
// kustoPoolName - The name of the Kusto pool.
// parameters - The Kusto pool parameters supplied to the Update operation.
// options - KustoPoolsClientBeginUpdateOptions contains the optional parameters for the KustoPoolsClient.BeginUpdate method.
func (client *KustoPoolsClient) BeginUpdate(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPoolUpdate, options *KustoPoolsClientBeginUpdateOptions) (*runtime.Poller[KustoPoolsClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, workspaceName, resourceGroupName, kustoPoolName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KustoPoolsClientUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KustoPoolsClientUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Update - Update a Kusto Kusto Pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01-preview
func (client *KustoPoolsClient) update(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPoolUpdate, options *KustoPoolsClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, workspaceName, resourceGroupName, kustoPoolName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *KustoPoolsClient) updateCreateRequest(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPoolUpdate, options *KustoPoolsClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}"
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if kustoPoolName == "" {
		return nil, errors.New("parameter kustoPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kustoPoolName}", url.PathEscape(kustoPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}
