//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient contains the methods for the ManagedDatabaseVulnerabilityAssessmentRuleBaselines group.
// Don't use this type directly, use NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient() instead.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient creates a new instance of ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient with the specified values.
// subscriptionID - The subscription ID that identifies an Azure subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates a database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance.
// databaseName - The name of the database for which the vulnerability assessment rule baseline is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// ruleID - The vulnerability assessment rule ID.
// baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule
// and master for server level rule).
// parameters - The requested rule baseline resource.
// options - ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions contains the optional parameters
// for the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate method.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters DatabaseVulnerabilityAssessmentRuleBaseline, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleID, baselineName, parameters, options)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters DatabaseVulnerabilityAssessmentRuleBaseline, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateHandleResponse(resp *http.Response) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	result := ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseVulnerabilityAssessmentRuleBaseline); err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Removes the database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance.
// databaseName - The name of the database for which the vulnerability assessment rule baseline is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// ruleID - The vulnerability assessment rule ID.
// baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule
// and master for server level rule).
// options - ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions contains the optional parameters for the
// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Delete method.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleID, baselineName, options)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets a database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance.
// databaseName - The name of the database for which the vulnerability assessment rule baseline is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// ruleID - The vulnerability assessment rule ID.
// baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule
// and master for server level rule).
// options - ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions contains the optional parameters for the
// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Get method.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleID, baselineName, options)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) getCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) getHandleResponse(resp *http.Response) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	result := ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseVulnerabilityAssessmentRuleBaseline); err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	return result, nil
}
