//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrate

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VMwareCollectorsClient contains the methods for the VMwareCollectors group.
// Don't use this type directly, use NewVMwareCollectorsClient() instead.
type VMwareCollectorsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewVMwareCollectorsClient creates a new instance of VMwareCollectorsClient with the specified values.
// subscriptionID - Azure Subscription Id in which project was created.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewVMwareCollectorsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VMwareCollectorsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &VMwareCollectorsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Create - Create or Update VMware collector
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-10-01
// resourceGroupName - Name of the Azure Resource Group that project is part of.
// projectName - Name of the Azure Migrate project.
// vmWareCollectorName - Unique name of a VMware collector within a project.
// options - VMwareCollectorsClientCreateOptions contains the optional parameters for the VMwareCollectorsClient.Create method.
func (client *VMwareCollectorsClient) Create(ctx context.Context, resourceGroupName string, projectName string, vmWareCollectorName string, options *VMwareCollectorsClientCreateOptions) (VMwareCollectorsClientCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, projectName, vmWareCollectorName, options)
	if err != nil {
		return VMwareCollectorsClientCreateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VMwareCollectorsClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return VMwareCollectorsClientCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *VMwareCollectorsClient) createCreateRequest(ctx context.Context, resourceGroupName string, projectName string, vmWareCollectorName string, options *VMwareCollectorsClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/vmwarecollectors/{vmWareCollectorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	if vmWareCollectorName == "" {
		return nil, errors.New("parameter vmWareCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vmWareCollectorName}", url.PathEscape(vmWareCollectorName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.CollectorBody != nil {
		return req, runtime.MarshalAsJSON(req, *options.CollectorBody)
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *VMwareCollectorsClient) createHandleResponse(resp *http.Response) (VMwareCollectorsClientCreateResponse, error) {
	result := VMwareCollectorsClientCreateResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMwareCollector); err != nil {
		return VMwareCollectorsClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a VMware collector from the project.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-10-01
// resourceGroupName - Name of the Azure Resource Group that project is part of.
// projectName - Name of the Azure Migrate project.
// vmWareCollectorName - Unique name of a VMware collector within a project.
// options - VMwareCollectorsClientDeleteOptions contains the optional parameters for the VMwareCollectorsClient.Delete method.
func (client *VMwareCollectorsClient) Delete(ctx context.Context, resourceGroupName string, projectName string, vmWareCollectorName string, options *VMwareCollectorsClientDeleteOptions) (VMwareCollectorsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, projectName, vmWareCollectorName, options)
	if err != nil {
		return VMwareCollectorsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VMwareCollectorsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return VMwareCollectorsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteHandleResponse(resp)
}

// deleteCreateRequest creates the Delete request.
func (client *VMwareCollectorsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, projectName string, vmWareCollectorName string, options *VMwareCollectorsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/vmwarecollectors/{vmWareCollectorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	if vmWareCollectorName == "" {
		return nil, errors.New("parameter vmWareCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vmWareCollectorName}", url.PathEscape(vmWareCollectorName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *VMwareCollectorsClient) deleteHandleResponse(resp *http.Response) (VMwareCollectorsClientDeleteResponse, error) {
	result := VMwareCollectorsClientDeleteResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	return result, nil
}

// Get - Get a VMware collector.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-10-01
// resourceGroupName - Name of the Azure Resource Group that project is part of.
// projectName - Name of the Azure Migrate project.
// vmWareCollectorName - Unique name of a VMware collector within a project.
// options - VMwareCollectorsClientGetOptions contains the optional parameters for the VMwareCollectorsClient.Get method.
func (client *VMwareCollectorsClient) Get(ctx context.Context, resourceGroupName string, projectName string, vmWareCollectorName string, options *VMwareCollectorsClientGetOptions) (VMwareCollectorsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, projectName, vmWareCollectorName, options)
	if err != nil {
		return VMwareCollectorsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VMwareCollectorsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return VMwareCollectorsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *VMwareCollectorsClient) getCreateRequest(ctx context.Context, resourceGroupName string, projectName string, vmWareCollectorName string, options *VMwareCollectorsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/vmwarecollectors/{vmWareCollectorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	if vmWareCollectorName == "" {
		return nil, errors.New("parameter vmWareCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vmWareCollectorName}", url.PathEscape(vmWareCollectorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VMwareCollectorsClient) getHandleResponse(resp *http.Response) (VMwareCollectorsClientGetResponse, error) {
	result := VMwareCollectorsClientGetResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMwareCollector); err != nil {
		return VMwareCollectorsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByProjectPager - Get a list of VMware collector.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-10-01
// resourceGroupName - Name of the Azure Resource Group that project is part of.
// projectName - Name of the Azure Migrate project.
// options - VMwareCollectorsClientListByProjectOptions contains the optional parameters for the VMwareCollectorsClient.ListByProject
// method.
func (client *VMwareCollectorsClient) NewListByProjectPager(resourceGroupName string, projectName string, options *VMwareCollectorsClientListByProjectOptions) *runtime.Pager[VMwareCollectorsClientListByProjectResponse] {
	return runtime.NewPager(runtime.PagingHandler[VMwareCollectorsClientListByProjectResponse]{
		More: func(page VMwareCollectorsClientListByProjectResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *VMwareCollectorsClientListByProjectResponse) (VMwareCollectorsClientListByProjectResponse, error) {
			req, err := client.listByProjectCreateRequest(ctx, resourceGroupName, projectName, options)
			if err != nil {
				return VMwareCollectorsClientListByProjectResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VMwareCollectorsClientListByProjectResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VMwareCollectorsClientListByProjectResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByProjectHandleResponse(resp)
		},
	})
}

// listByProjectCreateRequest creates the ListByProject request.
func (client *VMwareCollectorsClient) listByProjectCreateRequest(ctx context.Context, resourceGroupName string, projectName string, options *VMwareCollectorsClientListByProjectOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/vmwarecollectors"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByProjectHandleResponse handles the ListByProject response.
func (client *VMwareCollectorsClient) listByProjectHandleResponse(resp *http.Response) (VMwareCollectorsClientListByProjectResponse, error) {
	result := VMwareCollectorsClientListByProjectResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMwareCollectorList); err != nil {
		return VMwareCollectorsClientListByProjectResponse{}, err
	}
	return result, nil
}
