//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmediaservices

const (
	moduleName    = "armmediaservices"
	moduleVersion = "v3.1.0"
)

// AacAudioProfile - The encoding profile to be used when encoding audio with AAC.
type AacAudioProfile string

const (
	// AacAudioProfileAacLc - Specifies that the output audio is to be encoded into AAC Low Complexity profile (AAC-LC).
	AacAudioProfileAacLc AacAudioProfile = "AacLc"
	// AacAudioProfileHeAacV1 - Specifies that the output audio is to be encoded into HE-AAC v1 profile.
	AacAudioProfileHeAacV1 AacAudioProfile = "HeAacV1"
	// AacAudioProfileHeAacV2 - Specifies that the output audio is to be encoded into HE-AAC v2 profile.
	AacAudioProfileHeAacV2 AacAudioProfile = "HeAacV2"
)

// PossibleAacAudioProfileValues returns the possible values for the AacAudioProfile const type.
func PossibleAacAudioProfileValues() []AacAudioProfile {
	return []AacAudioProfile{
		AacAudioProfileAacLc,
		AacAudioProfileHeAacV1,
		AacAudioProfileHeAacV2,
	}
}

// AccountEncryptionKeyType - The type of key used to encrypt the Account Key.
type AccountEncryptionKeyType string

const (
	// AccountEncryptionKeyTypeCustomerKey - The Account Key is encrypted with a Customer Key.
	AccountEncryptionKeyTypeCustomerKey AccountEncryptionKeyType = "CustomerKey"
	// AccountEncryptionKeyTypeSystemKey - The Account Key is encrypted with a System Key.
	AccountEncryptionKeyTypeSystemKey AccountEncryptionKeyType = "SystemKey"
)

// PossibleAccountEncryptionKeyTypeValues returns the possible values for the AccountEncryptionKeyType const type.
func PossibleAccountEncryptionKeyTypeValues() []AccountEncryptionKeyType {
	return []AccountEncryptionKeyType{
		AccountEncryptionKeyTypeCustomerKey,
		AccountEncryptionKeyTypeSystemKey,
	}
}

// ActionType - Indicates the action type.
type ActionType string

const (
	// ActionTypeInternal - An internal action.
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AnalysisResolution - Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution,"
// which will keep the input video at its original resolution when analyzed. Using
// "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It
// will only resize if the video is of higher resolution. For example, a 1920x1080
// input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to
// process high resolution video. It may also reduce the cost of using this
// component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces
// that end up being too small in the resized video may not be detected.
type AnalysisResolution string

const (
	AnalysisResolutionSourceResolution   AnalysisResolution = "SourceResolution"
	AnalysisResolutionStandardDefinition AnalysisResolution = "StandardDefinition"
)

// PossibleAnalysisResolutionValues returns the possible values for the AnalysisResolution const type.
func PossibleAnalysisResolutionValues() []AnalysisResolution {
	return []AnalysisResolution{
		AnalysisResolutionSourceResolution,
		AnalysisResolutionStandardDefinition,
	}
}

// AssetContainerPermission - The permissions to set on the SAS URL.
type AssetContainerPermission string

const (
	// AssetContainerPermissionRead - The SAS URL will allow read access to the container.
	AssetContainerPermissionRead AssetContainerPermission = "Read"
	// AssetContainerPermissionReadWrite - The SAS URL will allow read and write access to the container.
	AssetContainerPermissionReadWrite AssetContainerPermission = "ReadWrite"
	// AssetContainerPermissionReadWriteDelete - The SAS URL will allow read, write and delete access to the container.
	AssetContainerPermissionReadWriteDelete AssetContainerPermission = "ReadWriteDelete"
)

// PossibleAssetContainerPermissionValues returns the possible values for the AssetContainerPermission const type.
func PossibleAssetContainerPermissionValues() []AssetContainerPermission {
	return []AssetContainerPermission{
		AssetContainerPermissionRead,
		AssetContainerPermissionReadWrite,
		AssetContainerPermissionReadWriteDelete,
	}
}

// AssetStorageEncryptionFormat - The Asset encryption format. One of None or MediaStorageEncryption.
type AssetStorageEncryptionFormat string

const (
	// AssetStorageEncryptionFormatMediaStorageClientEncryption - The Asset is encrypted with Media Services client-side encryption.
	AssetStorageEncryptionFormatMediaStorageClientEncryption AssetStorageEncryptionFormat = "MediaStorageClientEncryption"
	// AssetStorageEncryptionFormatNone - The Asset does not use client-side storage encryption (this is the only allowed value
	// for new Assets).
	AssetStorageEncryptionFormatNone AssetStorageEncryptionFormat = "None"
)

// PossibleAssetStorageEncryptionFormatValues returns the possible values for the AssetStorageEncryptionFormat const type.
func PossibleAssetStorageEncryptionFormatValues() []AssetStorageEncryptionFormat {
	return []AssetStorageEncryptionFormat{
		AssetStorageEncryptionFormatMediaStorageClientEncryption,
		AssetStorageEncryptionFormatNone,
	}
}

// AsyncOperationStatus - Operation status of the async operation.
type AsyncOperationStatus string

const (
	AsyncOperationStatusFailed     AsyncOperationStatus = "Failed"
	AsyncOperationStatusInProgress AsyncOperationStatus = "InProgress"
	AsyncOperationStatusSucceeded  AsyncOperationStatus = "Succeeded"
)

// PossibleAsyncOperationStatusValues returns the possible values for the AsyncOperationStatus const type.
func PossibleAsyncOperationStatusValues() []AsyncOperationStatus {
	return []AsyncOperationStatus{
		AsyncOperationStatusFailed,
		AsyncOperationStatusInProgress,
		AsyncOperationStatusSucceeded,
	}
}

// AttributeFilter - The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
type AttributeFilter string

const (
	// AttributeFilterAll - All tracks will be included.
	AttributeFilterAll AttributeFilter = "All"
	// AttributeFilterBottom - The first track will be included when the attribute is sorted in ascending order. Generally used
	// to select the smallest bitrate.
	AttributeFilterBottom AttributeFilter = "Bottom"
	// AttributeFilterTop - The first track will be included when the attribute is sorted in descending order. Generally used
	// to select the largest bitrate.
	AttributeFilterTop AttributeFilter = "Top"
	// AttributeFilterValueEquals - Any tracks that have an attribute equal to the value given will be included.
	AttributeFilterValueEquals AttributeFilter = "ValueEquals"
)

// PossibleAttributeFilterValues returns the possible values for the AttributeFilter const type.
func PossibleAttributeFilterValues() []AttributeFilter {
	return []AttributeFilter{
		AttributeFilterAll,
		AttributeFilterBottom,
		AttributeFilterTop,
		AttributeFilterValueEquals,
	}
}

// AudioAnalysisMode - Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode
// would be chosen.
type AudioAnalysisMode string

const (
	// AudioAnalysisModeBasic - This mode performs speech-to-text transcription and generation of a VTT subtitle/caption file.
	// The output of this mode includes an Insights JSON file including only the keywords, transcription,and timing information.
	// Automatic language detection and speaker diarization are not included in this mode.
	AudioAnalysisModeBasic AudioAnalysisMode = "Basic"
	// AudioAnalysisModeStandard - Performs all operations included in the Basic mode, additionally performing language detection
	// and speaker diarization.
	AudioAnalysisModeStandard AudioAnalysisMode = "Standard"
)

// PossibleAudioAnalysisModeValues returns the possible values for the AudioAnalysisMode const type.
func PossibleAudioAnalysisModeValues() []AudioAnalysisMode {
	return []AudioAnalysisMode{
		AudioAnalysisModeBasic,
		AudioAnalysisModeStandard,
	}
}

// BlurType - Blur type
type BlurType string

const (
	// BlurTypeBlack - Black: Black out filter
	BlurTypeBlack BlurType = "Black"
	// BlurTypeBox - Box: debug filter, bounding box only
	BlurTypeBox BlurType = "Box"
	// BlurTypeHigh - High: Confuse blur filter
	BlurTypeHigh BlurType = "High"
	// BlurTypeLow - Low: box-car blur filter
	BlurTypeLow BlurType = "Low"
	// BlurTypeMed - Med: Gaussian blur filter
	BlurTypeMed BlurType = "Med"
)

// PossibleBlurTypeValues returns the possible values for the BlurType const type.
func PossibleBlurTypeValues() []BlurType {
	return []BlurType{
		BlurTypeBlack,
		BlurTypeBox,
		BlurTypeHigh,
		BlurTypeLow,
		BlurTypeMed,
	}
}

// ChannelMapping - Optional designation for single channel audio tracks. Can be used to combine the tracks into stereo or
// multi-channel audio tracks.
type ChannelMapping string

const (
	// ChannelMappingBackLeft - The Back Left Channel. Sometimes referred to as the Left Surround Channel.
	ChannelMappingBackLeft ChannelMapping = "BackLeft"
	// ChannelMappingBackRight - The Back Right Channel. Sometimes referred to as the Right Surround Channel.
	ChannelMappingBackRight ChannelMapping = "BackRight"
	// ChannelMappingCenter - The Center Channel.
	ChannelMappingCenter ChannelMapping = "Center"
	// ChannelMappingFrontLeft - The Front Left Channel.
	ChannelMappingFrontLeft ChannelMapping = "FrontLeft"
	// ChannelMappingFrontRight - The Front Right Channel.
	ChannelMappingFrontRight ChannelMapping = "FrontRight"
	// ChannelMappingLowFrequencyEffects - Low Frequency Effects Channel. Sometimes referred to as the Subwoofer.
	ChannelMappingLowFrequencyEffects ChannelMapping = "LowFrequencyEffects"
	// ChannelMappingStereoLeft - The Left Stereo channel. Sometimes referred to as Down Mix Left.
	ChannelMappingStereoLeft ChannelMapping = "StereoLeft"
	// ChannelMappingStereoRight - The Right Stereo channel. Sometimes referred to as Down Mix Right.
	ChannelMappingStereoRight ChannelMapping = "StereoRight"
)

// PossibleChannelMappingValues returns the possible values for the ChannelMapping const type.
func PossibleChannelMappingValues() []ChannelMapping {
	return []ChannelMapping{
		ChannelMappingBackLeft,
		ChannelMappingBackRight,
		ChannelMappingCenter,
		ChannelMappingFrontLeft,
		ChannelMappingFrontRight,
		ChannelMappingLowFrequencyEffects,
		ChannelMappingStereoLeft,
		ChannelMappingStereoRight,
	}
}

// Complexity - Allows you to configure the encoder settings to control the balance between speed and quality. Example: set
// Complexity as Speed for faster encoding but less compression efficiency.
type Complexity string

const (
	// ComplexityBalanced - Configures the encoder to use settings that achieve a balance between speed and quality.
	ComplexityBalanced Complexity = "Balanced"
	// ComplexityQuality - Configures the encoder to use settings optimized to produce higher quality output at the expense of
	// slower overall encode time.
	ComplexityQuality Complexity = "Quality"
	// ComplexitySpeed - Configures the encoder to use settings optimized for faster encoding. Quality is sacrificed to decrease
	// encoding time.
	ComplexitySpeed Complexity = "Speed"
)

// PossibleComplexityValues returns the possible values for the Complexity const type.
func PossibleComplexityValues() []Complexity {
	return []Complexity{
		ComplexityBalanced,
		ComplexityQuality,
		ComplexitySpeed,
	}
}

// ContentKeyPolicyFairPlayRentalAndLeaseKeyType - The rental and lease key type.
type ContentKeyPolicyFairPlayRentalAndLeaseKeyType string

const (
	// ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeDualExpiry - Dual expiry for offline rental.
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeDualExpiry ContentKeyPolicyFairPlayRentalAndLeaseKeyType = "DualExpiry"
	// ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentLimited - Content key can be persisted and the valid duration is
	// limited by the Rental Duration value
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentLimited ContentKeyPolicyFairPlayRentalAndLeaseKeyType = "PersistentLimited"
	// ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentUnlimited - Content key can be persisted with an unlimited duration
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentUnlimited ContentKeyPolicyFairPlayRentalAndLeaseKeyType = "PersistentUnlimited"
	// ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUndefined - Key duration is not specified.
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUndefined ContentKeyPolicyFairPlayRentalAndLeaseKeyType = "Undefined"
	// ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUnknown - Represents a ContentKeyPolicyFairPlayRentalAndLeaseKeyType that
	// is unavailable in current API version.
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUnknown ContentKeyPolicyFairPlayRentalAndLeaseKeyType = "Unknown"
)

// PossibleContentKeyPolicyFairPlayRentalAndLeaseKeyTypeValues returns the possible values for the ContentKeyPolicyFairPlayRentalAndLeaseKeyType const type.
func PossibleContentKeyPolicyFairPlayRentalAndLeaseKeyTypeValues() []ContentKeyPolicyFairPlayRentalAndLeaseKeyType {
	return []ContentKeyPolicyFairPlayRentalAndLeaseKeyType{
		ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeDualExpiry,
		ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentLimited,
		ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentUnlimited,
		ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUndefined,
		ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUnknown,
	}
}

// ContentKeyPolicyPlayReadyContentType - The PlayReady content type.
type ContentKeyPolicyPlayReadyContentType string

const (
	// ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload - Ultraviolet download content type.
	ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload ContentKeyPolicyPlayReadyContentType = "UltraVioletDownload"
	// ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming - Ultraviolet streaming content type.
	ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming ContentKeyPolicyPlayReadyContentType = "UltraVioletStreaming"
	// ContentKeyPolicyPlayReadyContentTypeUnknown - Represents a ContentKeyPolicyPlayReadyContentType that is unavailable in
	// current API version.
	ContentKeyPolicyPlayReadyContentTypeUnknown ContentKeyPolicyPlayReadyContentType = "Unknown"
	// ContentKeyPolicyPlayReadyContentTypeUnspecified - Unspecified content type.
	ContentKeyPolicyPlayReadyContentTypeUnspecified ContentKeyPolicyPlayReadyContentType = "Unspecified"
)

// PossibleContentKeyPolicyPlayReadyContentTypeValues returns the possible values for the ContentKeyPolicyPlayReadyContentType const type.
func PossibleContentKeyPolicyPlayReadyContentTypeValues() []ContentKeyPolicyPlayReadyContentType {
	return []ContentKeyPolicyPlayReadyContentType{
		ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload,
		ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming,
		ContentKeyPolicyPlayReadyContentTypeUnknown,
		ContentKeyPolicyPlayReadyContentTypeUnspecified,
	}
}

// ContentKeyPolicyPlayReadyLicenseType - The license type.
type ContentKeyPolicyPlayReadyLicenseType string

const (
	// ContentKeyPolicyPlayReadyLicenseTypeNonPersistent - Non persistent license.
	ContentKeyPolicyPlayReadyLicenseTypeNonPersistent ContentKeyPolicyPlayReadyLicenseType = "NonPersistent"
	// ContentKeyPolicyPlayReadyLicenseTypePersistent - Persistent license. Allows offline playback.
	ContentKeyPolicyPlayReadyLicenseTypePersistent ContentKeyPolicyPlayReadyLicenseType = "Persistent"
	// ContentKeyPolicyPlayReadyLicenseTypeUnknown - Represents a ContentKeyPolicyPlayReadyLicenseType that is unavailable in
	// current API version.
	ContentKeyPolicyPlayReadyLicenseTypeUnknown ContentKeyPolicyPlayReadyLicenseType = "Unknown"
)

// PossibleContentKeyPolicyPlayReadyLicenseTypeValues returns the possible values for the ContentKeyPolicyPlayReadyLicenseType const type.
func PossibleContentKeyPolicyPlayReadyLicenseTypeValues() []ContentKeyPolicyPlayReadyLicenseType {
	return []ContentKeyPolicyPlayReadyLicenseType{
		ContentKeyPolicyPlayReadyLicenseTypeNonPersistent,
		ContentKeyPolicyPlayReadyLicenseTypePersistent,
		ContentKeyPolicyPlayReadyLicenseTypeUnknown,
	}
}

// ContentKeyPolicyPlayReadyUnknownOutputPassingOption - Configures Unknown output handling settings of the license.
type ContentKeyPolicyPlayReadyUnknownOutputPassingOption string

const (
	// ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed - Passing the video portion of protected content to an Unknown
	// Output is allowed.
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed ContentKeyPolicyPlayReadyUnknownOutputPassingOption = "Allowed"
	// ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction - Passing the video portion of protected
	// content to an Unknown Output is allowed but with constrained resolution.
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction ContentKeyPolicyPlayReadyUnknownOutputPassingOption = "AllowedWithVideoConstriction"
	// ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed - Passing the video portion of protected content to an Unknown
	// Output is not allowed.
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed ContentKeyPolicyPlayReadyUnknownOutputPassingOption = "NotAllowed"
	// ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown - Represents a ContentKeyPolicyPlayReadyUnknownOutputPassingOption
	// that is unavailable in current API version.
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown ContentKeyPolicyPlayReadyUnknownOutputPassingOption = "Unknown"
)

// PossibleContentKeyPolicyPlayReadyUnknownOutputPassingOptionValues returns the possible values for the ContentKeyPolicyPlayReadyUnknownOutputPassingOption const type.
func PossibleContentKeyPolicyPlayReadyUnknownOutputPassingOptionValues() []ContentKeyPolicyPlayReadyUnknownOutputPassingOption {
	return []ContentKeyPolicyPlayReadyUnknownOutputPassingOption{
		ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed,
		ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction,
		ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed,
		ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown,
	}
}

// ContentKeyPolicyRestrictionTokenType - The type of token.
type ContentKeyPolicyRestrictionTokenType string

const (
	// ContentKeyPolicyRestrictionTokenTypeJwt - JSON Web Token.
	ContentKeyPolicyRestrictionTokenTypeJwt ContentKeyPolicyRestrictionTokenType = "Jwt"
	// ContentKeyPolicyRestrictionTokenTypeSwt - Simple Web Token.
	ContentKeyPolicyRestrictionTokenTypeSwt ContentKeyPolicyRestrictionTokenType = "Swt"
	// ContentKeyPolicyRestrictionTokenTypeUnknown - Represents a ContentKeyPolicyRestrictionTokenType that is unavailable in
	// current API version.
	ContentKeyPolicyRestrictionTokenTypeUnknown ContentKeyPolicyRestrictionTokenType = "Unknown"
)

// PossibleContentKeyPolicyRestrictionTokenTypeValues returns the possible values for the ContentKeyPolicyRestrictionTokenType const type.
func PossibleContentKeyPolicyRestrictionTokenTypeValues() []ContentKeyPolicyRestrictionTokenType {
	return []ContentKeyPolicyRestrictionTokenType{
		ContentKeyPolicyRestrictionTokenTypeJwt,
		ContentKeyPolicyRestrictionTokenTypeSwt,
		ContentKeyPolicyRestrictionTokenTypeUnknown,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DefaultAction - The behavior for IP access control in Key Delivery.
type DefaultAction string

const (
	// DefaultActionAllow - All public IP addresses are allowed.
	DefaultActionAllow DefaultAction = "Allow"
	// DefaultActionDeny - Public IP addresses are blocked.
	DefaultActionDeny DefaultAction = "Deny"
)

// PossibleDefaultActionValues returns the possible values for the DefaultAction const type.
func PossibleDefaultActionValues() []DefaultAction {
	return []DefaultAction{
		DefaultActionAllow,
		DefaultActionDeny,
	}
}

// DeinterlaceMode - The deinterlacing mode. Defaults to AutoPixelAdaptive.
type DeinterlaceMode string

const (
	// DeinterlaceModeAutoPixelAdaptive - Apply automatic pixel adaptive de-interlacing on each frame in the input video.
	DeinterlaceModeAutoPixelAdaptive DeinterlaceMode = "AutoPixelAdaptive"
	// DeinterlaceModeOff - Disables de-interlacing of the source video.
	DeinterlaceModeOff DeinterlaceMode = "Off"
)

// PossibleDeinterlaceModeValues returns the possible values for the DeinterlaceMode const type.
func PossibleDeinterlaceModeValues() []DeinterlaceMode {
	return []DeinterlaceMode{
		DeinterlaceModeAutoPixelAdaptive,
		DeinterlaceModeOff,
	}
}

// DeinterlaceParity - The field parity for de-interlacing, defaults to Auto.
type DeinterlaceParity string

const (
	// DeinterlaceParityAuto - Automatically detect the order of fields
	DeinterlaceParityAuto DeinterlaceParity = "Auto"
	// DeinterlaceParityBottomFieldFirst - Apply bottom field first processing of input video.
	DeinterlaceParityBottomFieldFirst DeinterlaceParity = "BottomFieldFirst"
	// DeinterlaceParityTopFieldFirst - Apply top field first processing of input video.
	DeinterlaceParityTopFieldFirst DeinterlaceParity = "TopFieldFirst"
)

// PossibleDeinterlaceParityValues returns the possible values for the DeinterlaceParity const type.
func PossibleDeinterlaceParityValues() []DeinterlaceParity {
	return []DeinterlaceParity{
		DeinterlaceParityAuto,
		DeinterlaceParityBottomFieldFirst,
		DeinterlaceParityTopFieldFirst,
	}
}

// EncoderNamedPreset - The built-in preset to be used for encoding videos.
type EncoderNamedPreset string

const (
	// EncoderNamedPresetAACGoodQualityAudio - Produces a single MP4 file containing only stereo audio encoded at 192 kbps.
	EncoderNamedPresetAACGoodQualityAudio EncoderNamedPreset = "AACGoodQualityAudio"
	// EncoderNamedPresetAdaptiveStreaming - Produces a set of GOP aligned MP4 files with H.264 video and stereo AAC audio. Auto-generates
	// a bitrate ladder based on the input resolution, bitrate and frame rate. The auto-generated preset will never exceed the
	// input resolution. For example, if the input is 720p, output will remain 720p at best.
	EncoderNamedPresetAdaptiveStreaming EncoderNamedPreset = "AdaptiveStreaming"
	// EncoderNamedPresetContentAwareEncoding - Produces a set of GOP-aligned MP4s by using content-aware encoding. Given any
	// input content, the service performs an initial lightweight analysis of the input content, and uses the results to determine
	// the optimal number of layers, appropriate bitrate and resolution settings for delivery by adaptive streaming. This preset
	// is particularly effective for low and medium complexity videos, where the output files will be at lower bitrates but at
	// a quality that still delivers a good experience to viewers. The output will contain MP4 files with video and audio interleaved.
	EncoderNamedPresetContentAwareEncoding EncoderNamedPreset = "ContentAwareEncoding"
	// EncoderNamedPresetContentAwareEncodingExperimental - Exposes an experimental preset for content-aware encoding. Given any
	// input content, the service attempts to automatically determine the optimal number of layers, appropriate bitrate and resolution
	// settings for delivery by adaptive streaming. The underlying algorithms will continue to evolve over time. The output will
	// contain MP4 files with video and audio interleaved.
	EncoderNamedPresetContentAwareEncodingExperimental EncoderNamedPreset = "ContentAwareEncodingExperimental"
	// EncoderNamedPresetCopyAllBitrateNonInterleaved - Copy all video and audio streams from the input asset as non-interleaved
	// video and audio output files. This preset can be used to clip an existing asset or convert a group of key frame (GOP) aligned
	// MP4 files as an asset that can be streamed.
	EncoderNamedPresetCopyAllBitrateNonInterleaved EncoderNamedPreset = "CopyAllBitrateNonInterleaved"
	// EncoderNamedPresetH264MultipleBitrate1080P - Produces a set of 8 GOP-aligned MP4 files, ranging from 6000 kbps to 400 kbps,
	// and stereo AAC audio. Resolution starts at 1080p and goes down to 180p.
	EncoderNamedPresetH264MultipleBitrate1080P EncoderNamedPreset = "H264MultipleBitrate1080p"
	// EncoderNamedPresetH264MultipleBitrate720P - Produces a set of 6 GOP-aligned MP4 files, ranging from 3400 kbps to 400 kbps,
	// and stereo AAC audio. Resolution starts at 720p and goes down to 180p.
	EncoderNamedPresetH264MultipleBitrate720P EncoderNamedPreset = "H264MultipleBitrate720p"
	// EncoderNamedPresetH264MultipleBitrateSD - Produces a set of 5 GOP-aligned MP4 files, ranging from 1900kbps to 400 kbps,
	// and stereo AAC audio. Resolution starts at 480p and goes down to 240p.
	EncoderNamedPresetH264MultipleBitrateSD EncoderNamedPreset = "H264MultipleBitrateSD"
	// EncoderNamedPresetH264SingleBitrate1080P - Produces an MP4 file where the video is encoded with H.264 codec at 6750 kbps
	// and a picture height of 1080 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps.
	EncoderNamedPresetH264SingleBitrate1080P EncoderNamedPreset = "H264SingleBitrate1080p"
	// EncoderNamedPresetH264SingleBitrate720P - Produces an MP4 file where the video is encoded with H.264 codec at 4500 kbps
	// and a picture height of 720 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps.
	EncoderNamedPresetH264SingleBitrate720P EncoderNamedPreset = "H264SingleBitrate720p"
	// EncoderNamedPresetH264SingleBitrateSD - Produces an MP4 file where the video is encoded with H.264 codec at 2200 kbps and
	// a picture height of 480 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps.
	EncoderNamedPresetH264SingleBitrateSD EncoderNamedPreset = "H264SingleBitrateSD"
	// EncoderNamedPresetH265AdaptiveStreaming - Produces a set of GOP aligned MP4 files with H.265 video and stereo AAC audio.
	// Auto-generates a bitrate ladder based on the input resolution, bitrate and frame rate. The auto-generated preset will never
	// exceed the input resolution. For example, if the input is 720p, output will remain 720p at best.
	EncoderNamedPresetH265AdaptiveStreaming EncoderNamedPreset = "H265AdaptiveStreaming"
	// EncoderNamedPresetH265ContentAwareEncoding - Produces a set of GOP-aligned MP4s by using content-aware encoding. Given
	// any input content, the service performs an initial lightweight analysis of the input content, and uses the results to determine
	// the optimal number of layers, appropriate bitrate and resolution settings for delivery by adaptive streaming. This preset
	// is particularly effective for low and medium complexity videos, where the output files will be at lower bitrates but at
	// a quality that still delivers a good experience to viewers. The output will contain MP4 files with video and audio interleaved.
	EncoderNamedPresetH265ContentAwareEncoding EncoderNamedPreset = "H265ContentAwareEncoding"
	// EncoderNamedPresetH265SingleBitrate1080P - Produces an MP4 file where the video is encoded with H.265 codec at 3500 kbps
	// and a picture height of 1080 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps.
	EncoderNamedPresetH265SingleBitrate1080P EncoderNamedPreset = "H265SingleBitrate1080p"
	// EncoderNamedPresetH265SingleBitrate4K - Produces an MP4 file where the video is encoded with H.265 codec at 9500 kbps and
	// a picture height of 2160 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps.
	EncoderNamedPresetH265SingleBitrate4K EncoderNamedPreset = "H265SingleBitrate4K"
	// EncoderNamedPresetH265SingleBitrate720P - Produces an MP4 file where the video is encoded with H.265 codec at 1800 kbps
	// and a picture height of 720 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps.
	EncoderNamedPresetH265SingleBitrate720P EncoderNamedPreset = "H265SingleBitrate720p"
)

// PossibleEncoderNamedPresetValues returns the possible values for the EncoderNamedPreset const type.
func PossibleEncoderNamedPresetValues() []EncoderNamedPreset {
	return []EncoderNamedPreset{
		EncoderNamedPresetAACGoodQualityAudio,
		EncoderNamedPresetAdaptiveStreaming,
		EncoderNamedPresetContentAwareEncoding,
		EncoderNamedPresetContentAwareEncodingExperimental,
		EncoderNamedPresetCopyAllBitrateNonInterleaved,
		EncoderNamedPresetH264MultipleBitrate1080P,
		EncoderNamedPresetH264MultipleBitrate720P,
		EncoderNamedPresetH264MultipleBitrateSD,
		EncoderNamedPresetH264SingleBitrate1080P,
		EncoderNamedPresetH264SingleBitrate720P,
		EncoderNamedPresetH264SingleBitrateSD,
		EncoderNamedPresetH265AdaptiveStreaming,
		EncoderNamedPresetH265ContentAwareEncoding,
		EncoderNamedPresetH265SingleBitrate1080P,
		EncoderNamedPresetH265SingleBitrate4K,
		EncoderNamedPresetH265SingleBitrate720P,
	}
}

// EncryptionScheme - Encryption scheme
type EncryptionScheme string

const (
	// EncryptionSchemeCommonEncryptionCbcs - CommonEncryptionCbcs scheme
	EncryptionSchemeCommonEncryptionCbcs EncryptionScheme = "CommonEncryptionCbcs"
	// EncryptionSchemeCommonEncryptionCenc - CommonEncryptionCenc scheme
	EncryptionSchemeCommonEncryptionCenc EncryptionScheme = "CommonEncryptionCenc"
	// EncryptionSchemeEnvelopeEncryption - EnvelopeEncryption scheme
	EncryptionSchemeEnvelopeEncryption EncryptionScheme = "EnvelopeEncryption"
	// EncryptionSchemeNoEncryption - NoEncryption scheme
	EncryptionSchemeNoEncryption EncryptionScheme = "NoEncryption"
)

// PossibleEncryptionSchemeValues returns the possible values for the EncryptionScheme const type.
func PossibleEncryptionSchemeValues() []EncryptionScheme {
	return []EncryptionScheme{
		EncryptionSchemeCommonEncryptionCbcs,
		EncryptionSchemeCommonEncryptionCenc,
		EncryptionSchemeEnvelopeEncryption,
		EncryptionSchemeNoEncryption,
	}
}

// EntropyMode - The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate
// for the profile and level.
type EntropyMode string

const (
	// EntropyModeCabac - Context Adaptive Binary Arithmetic Coder (CABAC) entropy encoding.
	EntropyModeCabac EntropyMode = "Cabac"
	// EntropyModeCavlc - Context Adaptive Variable Length Coder (CAVLC) entropy encoding.
	EntropyModeCavlc EntropyMode = "Cavlc"
)

// PossibleEntropyModeValues returns the possible values for the EntropyMode const type.
func PossibleEntropyModeValues() []EntropyMode {
	return []EntropyMode{
		EntropyModeCabac,
		EntropyModeCavlc,
	}
}

// FaceRedactorMode - This mode provides the ability to choose between the following settings: 1) Analyze - For detection
// only.This mode generates a metadata JSON file marking appearances of faces throughout the
// video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs)
// detected faces. 3) Redact - This enables a 2-pass process, allowing for
// selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the
// source video, and a user-selected subset of IDs that require redaction.
type FaceRedactorMode string

const (
	// FaceRedactorModeAnalyze - Analyze mode detects faces and outputs a metadata file with the results. Allows editing of the
	// metadata file before faces are blurred with Redact mode.
	FaceRedactorModeAnalyze FaceRedactorMode = "Analyze"
	// FaceRedactorModeCombined - Combined mode does the Analyze and Redact steps in one pass when editing the analyzed faces
	// is not desired.
	FaceRedactorModeCombined FaceRedactorMode = "Combined"
	// FaceRedactorModeRedact - Redact mode consumes the metadata file from Analyze mode and redacts the faces found.
	FaceRedactorModeRedact FaceRedactorMode = "Redact"
)

// PossibleFaceRedactorModeValues returns the possible values for the FaceRedactorMode const type.
func PossibleFaceRedactorModeValues() []FaceRedactorMode {
	return []FaceRedactorMode{
		FaceRedactorModeAnalyze,
		FaceRedactorModeCombined,
		FaceRedactorModeRedact,
	}
}

// FilterTrackPropertyCompareOperation - The track property condition operation.
type FilterTrackPropertyCompareOperation string

const (
	// FilterTrackPropertyCompareOperationEqual - The equal operation.
	FilterTrackPropertyCompareOperationEqual FilterTrackPropertyCompareOperation = "Equal"
	// FilterTrackPropertyCompareOperationNotEqual - The not equal operation.
	FilterTrackPropertyCompareOperationNotEqual FilterTrackPropertyCompareOperation = "NotEqual"
)

// PossibleFilterTrackPropertyCompareOperationValues returns the possible values for the FilterTrackPropertyCompareOperation const type.
func PossibleFilterTrackPropertyCompareOperationValues() []FilterTrackPropertyCompareOperation {
	return []FilterTrackPropertyCompareOperation{
		FilterTrackPropertyCompareOperationEqual,
		FilterTrackPropertyCompareOperationNotEqual,
	}
}

// FilterTrackPropertyType - The track property type.
type FilterTrackPropertyType string

const (
	// FilterTrackPropertyTypeBitrate - The bitrate.
	FilterTrackPropertyTypeBitrate FilterTrackPropertyType = "Bitrate"
	// FilterTrackPropertyTypeFourCC - The fourCC.
	FilterTrackPropertyTypeFourCC FilterTrackPropertyType = "FourCC"
	// FilterTrackPropertyTypeLanguage - The language.
	FilterTrackPropertyTypeLanguage FilterTrackPropertyType = "Language"
	// FilterTrackPropertyTypeName - The name.
	FilterTrackPropertyTypeName FilterTrackPropertyType = "Name"
	// FilterTrackPropertyTypeType - The type.
	FilterTrackPropertyTypeType FilterTrackPropertyType = "Type"
	// FilterTrackPropertyTypeUnknown - The unknown track property type.
	FilterTrackPropertyTypeUnknown FilterTrackPropertyType = "Unknown"
)

// PossibleFilterTrackPropertyTypeValues returns the possible values for the FilterTrackPropertyType const type.
func PossibleFilterTrackPropertyTypeValues() []FilterTrackPropertyType {
	return []FilterTrackPropertyType{
		FilterTrackPropertyTypeBitrate,
		FilterTrackPropertyTypeFourCC,
		FilterTrackPropertyTypeLanguage,
		FilterTrackPropertyTypeName,
		FilterTrackPropertyTypeType,
		FilterTrackPropertyTypeUnknown,
	}
}

// H264Complexity - Tells the encoder how to choose its encoding settings. The default value is Balanced.
type H264Complexity string

const (
	// H264ComplexityBalanced - Tells the encoder to use settings that achieve a balance between speed and quality.
	H264ComplexityBalanced H264Complexity = "Balanced"
	// H264ComplexityQuality - Tells the encoder to use settings that are optimized to produce higher quality output at the expense
	// of slower overall encode time.
	H264ComplexityQuality H264Complexity = "Quality"
	// H264ComplexitySpeed - Tells the encoder to use settings that are optimized for faster encoding. Quality is sacrificed to
	// decrease encoding time.
	H264ComplexitySpeed H264Complexity = "Speed"
)

// PossibleH264ComplexityValues returns the possible values for the H264Complexity const type.
func PossibleH264ComplexityValues() []H264Complexity {
	return []H264Complexity{
		H264ComplexityBalanced,
		H264ComplexityQuality,
		H264ComplexitySpeed,
	}
}

// H264RateControlMode - The video rate control mode
type H264RateControlMode string

const (
	// H264RateControlModeABR - Average Bitrate (ABR) mode that hits the target bitrate: Default mode.
	H264RateControlModeABR H264RateControlMode = "ABR"
	// H264RateControlModeCBR - Constant Bitrate (CBR) mode that tightens bitrate variations around target bitrate.
	H264RateControlModeCBR H264RateControlMode = "CBR"
	// H264RateControlModeCRF - Constant Rate Factor (CRF) mode that targets at constant subjective quality.
	H264RateControlModeCRF H264RateControlMode = "CRF"
)

// PossibleH264RateControlModeValues returns the possible values for the H264RateControlMode const type.
func PossibleH264RateControlModeValues() []H264RateControlMode {
	return []H264RateControlMode{
		H264RateControlModeABR,
		H264RateControlModeCBR,
		H264RateControlModeCRF,
	}
}

// H264VideoProfile - We currently support Baseline, Main, High, High422, High444. Default is Auto.
type H264VideoProfile string

const (
	// H264VideoProfileAuto - Tells the encoder to automatically determine the appropriate H.264 profile.
	H264VideoProfileAuto H264VideoProfile = "Auto"
	// H264VideoProfileBaseline - Baseline profile
	H264VideoProfileBaseline H264VideoProfile = "Baseline"
	// H264VideoProfileHigh - High profile.
	H264VideoProfileHigh H264VideoProfile = "High"
	// H264VideoProfileHigh422 - High 4:2:2 profile.
	H264VideoProfileHigh422 H264VideoProfile = "High422"
	// H264VideoProfileHigh444 - High 4:4:4 predictive profile.
	H264VideoProfileHigh444 H264VideoProfile = "High444"
	// H264VideoProfileMain - Main profile
	H264VideoProfileMain H264VideoProfile = "Main"
)

// PossibleH264VideoProfileValues returns the possible values for the H264VideoProfile const type.
func PossibleH264VideoProfileValues() []H264VideoProfile {
	return []H264VideoProfile{
		H264VideoProfileAuto,
		H264VideoProfileBaseline,
		H264VideoProfileHigh,
		H264VideoProfileHigh422,
		H264VideoProfileHigh444,
		H264VideoProfileMain,
	}
}

// H265Complexity - Tells the encoder how to choose its encoding settings. Quality will provide for a higher compression ratio
// but at a higher cost and longer compute time. Speed will produce a relatively larger file but
// is faster and more economical. The default value is Balanced.
type H265Complexity string

const (
	// H265ComplexityBalanced - Tells the encoder to use settings that achieve a balance between speed and quality.
	H265ComplexityBalanced H265Complexity = "Balanced"
	// H265ComplexityQuality - Tells the encoder to use settings that are optimized to produce higher quality output at the expense
	// of slower overall encode time.
	H265ComplexityQuality H265Complexity = "Quality"
	// H265ComplexitySpeed - Tells the encoder to use settings that are optimized for faster encoding. Quality is sacrificed to
	// decrease encoding time.
	H265ComplexitySpeed H265Complexity = "Speed"
)

// PossibleH265ComplexityValues returns the possible values for the H265Complexity const type.
func PossibleH265ComplexityValues() []H265Complexity {
	return []H265Complexity{
		H265ComplexityBalanced,
		H265ComplexityQuality,
		H265ComplexitySpeed,
	}
}

// H265VideoProfile - We currently support Main. Default is Auto.
type H265VideoProfile string

const (
	// H265VideoProfileAuto - Tells the encoder to automatically determine the appropriate H.265 profile.
	H265VideoProfileAuto H265VideoProfile = "Auto"
	// H265VideoProfileMain - Main profile (https://x265.readthedocs.io/en/default/cli.html?highlight=profile#profile-level-tier)
	H265VideoProfileMain H265VideoProfile = "Main"
	// H265VideoProfileMain10 - Main 10 profile (https://en.wikipedia.org/wiki/High_Efficiency_Video_Coding#Main_10)
	H265VideoProfileMain10 H265VideoProfile = "Main10"
)

// PossibleH265VideoProfileValues returns the possible values for the H265VideoProfile const type.
func PossibleH265VideoProfileValues() []H265VideoProfile {
	return []H265VideoProfile{
		H265VideoProfileAuto,
		H265VideoProfileMain,
		H265VideoProfileMain10,
	}
}

// InsightsType - Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly',
// 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to
// AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only,
// then only video insights are generated. It is recommended that you not use
// AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your
// inputs to be audio only. Your Jobs in such conditions would error out.
type InsightsType string

const (
	// InsightsTypeAllInsights - Generate both audio and video insights. Fails if either audio or video Insights fail.
	InsightsTypeAllInsights InsightsType = "AllInsights"
	// InsightsTypeAudioInsightsOnly - Generate audio only insights. Ignore video even if present. Fails if no audio is present.
	InsightsTypeAudioInsightsOnly InsightsType = "AudioInsightsOnly"
	// InsightsTypeVideoInsightsOnly - Generate video only insights. Ignore audio if present. Fails if no video is present.
	InsightsTypeVideoInsightsOnly InsightsType = "VideoInsightsOnly"
)

// PossibleInsightsTypeValues returns the possible values for the InsightsType const type.
func PossibleInsightsTypeValues() []InsightsType {
	return []InsightsType{
		InsightsTypeAllInsights,
		InsightsTypeAudioInsightsOnly,
		InsightsTypeVideoInsightsOnly,
	}
}

// InterleaveOutput - Sets the interleave mode of the output to control how audio and video are stored in the container format.
// Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only
// outputs in separate MP4 files.
type InterleaveOutput string

const (
	// InterleaveOutputInterleavedOutput - The output includes both audio and video.
	InterleaveOutputInterleavedOutput InterleaveOutput = "InterleavedOutput"
	// InterleaveOutputNonInterleavedOutput - The output is video-only or audio-only.
	InterleaveOutputNonInterleavedOutput InterleaveOutput = "NonInterleavedOutput"
)

// PossibleInterleaveOutputValues returns the possible values for the InterleaveOutput const type.
func PossibleInterleaveOutputValues() []InterleaveOutput {
	return []InterleaveOutput{
		InterleaveOutputInterleavedOutput,
		InterleaveOutputNonInterleavedOutput,
	}
}

// JobErrorCategory - Helps with categorization of errors.
type JobErrorCategory string

const (
	// JobErrorCategoryConfiguration - The error is configuration related.
	JobErrorCategoryConfiguration JobErrorCategory = "Configuration"
	// JobErrorCategoryContent - The error is related to data in the input files.
	JobErrorCategoryContent JobErrorCategory = "Content"
	// JobErrorCategoryDownload - The error is download related.
	JobErrorCategoryDownload JobErrorCategory = "Download"
	// JobErrorCategoryService - The error is service related.
	JobErrorCategoryService JobErrorCategory = "Service"
	// JobErrorCategoryUpload - The error is upload related.
	JobErrorCategoryUpload JobErrorCategory = "Upload"
)

// PossibleJobErrorCategoryValues returns the possible values for the JobErrorCategory const type.
func PossibleJobErrorCategoryValues() []JobErrorCategory {
	return []JobErrorCategory{
		JobErrorCategoryConfiguration,
		JobErrorCategoryContent,
		JobErrorCategoryDownload,
		JobErrorCategoryService,
		JobErrorCategoryUpload,
	}
}

// JobErrorCode - Error code describing the error.
type JobErrorCode string

const (
	// JobErrorCodeConfigurationUnsupported - There was a problem with the combination of input files and the configuration settings
	// applied, fix the configuration settings and retry with the same input, or change input to match the configuration.
	JobErrorCodeConfigurationUnsupported JobErrorCode = "ConfigurationUnsupported"
	// JobErrorCodeContentMalformed - There was a problem with the input content (for example: zero byte files, or corrupt/non-decodable
	// files), check the input files.
	JobErrorCodeContentMalformed JobErrorCode = "ContentMalformed"
	// JobErrorCodeContentUnsupported - There was a problem with the format of the input (not valid media file, or an unsupported
	// file/codec), check the validity of the input files.
	JobErrorCodeContentUnsupported JobErrorCode = "ContentUnsupported"
	// JobErrorCodeDownloadNotAccessible - While trying to download the input files, the files were not accessible, please check
	// the availability of the source.
	JobErrorCodeDownloadNotAccessible JobErrorCode = "DownloadNotAccessible"
	// JobErrorCodeDownloadTransientError - While trying to download the input files, there was an issue during transfer (storage
	// service, network errors), see details and check your source.
	JobErrorCodeDownloadTransientError JobErrorCode = "DownloadTransientError"
	// JobErrorCodeServiceError - Fatal service error, please contact support.
	JobErrorCodeServiceError JobErrorCode = "ServiceError"
	// JobErrorCodeServiceTransientError - Transient error, please retry, if retry is unsuccessful, please contact support.
	JobErrorCodeServiceTransientError JobErrorCode = "ServiceTransientError"
	// JobErrorCodeUploadNotAccessible - While trying to upload the output files, the destination was not reachable, please check
	// the availability of the destination.
	JobErrorCodeUploadNotAccessible JobErrorCode = "UploadNotAccessible"
	// JobErrorCodeUploadTransientError - While trying to upload the output files, there was an issue during transfer (storage
	// service, network errors), see details and check your destination.
	JobErrorCodeUploadTransientError JobErrorCode = "UploadTransientError"
)

// PossibleJobErrorCodeValues returns the possible values for the JobErrorCode const type.
func PossibleJobErrorCodeValues() []JobErrorCode {
	return []JobErrorCode{
		JobErrorCodeConfigurationUnsupported,
		JobErrorCodeContentMalformed,
		JobErrorCodeContentUnsupported,
		JobErrorCodeDownloadNotAccessible,
		JobErrorCodeDownloadTransientError,
		JobErrorCodeServiceError,
		JobErrorCodeServiceTransientError,
		JobErrorCodeUploadNotAccessible,
		JobErrorCodeUploadTransientError,
	}
}

// JobRetry - Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via
// Azure Portal.
type JobRetry string

const (
	// JobRetryDoNotRetry - Issue needs to be investigated and then the job resubmitted with corrections or retried once the underlying
	// issue has been corrected.
	JobRetryDoNotRetry JobRetry = "DoNotRetry"
	// JobRetryMayRetry - Issue may be resolved after waiting for a period of time and resubmitting the same Job.
	JobRetryMayRetry JobRetry = "MayRetry"
)

// PossibleJobRetryValues returns the possible values for the JobRetry const type.
func PossibleJobRetryValues() []JobRetry {
	return []JobRetry{
		JobRetryDoNotRetry,
		JobRetryMayRetry,
	}
}

// JobState - Describes the state of the JobOutput.
type JobState string

const (
	// JobStateCanceled - The job was canceled. This is a final state for the job.
	JobStateCanceled JobState = "Canceled"
	// JobStateCanceling - The job is in the process of being canceled. This is a transient state for the job.
	JobStateCanceling JobState = "Canceling"
	// JobStateError - The job has encountered an error. This is a final state for the job.
	JobStateError JobState = "Error"
	// JobStateFinished - The job is finished. This is a final state for the job.
	JobStateFinished JobState = "Finished"
	// JobStateProcessing - The job is processing. This is a transient state for the job.
	JobStateProcessing JobState = "Processing"
	// JobStateQueued - The job is in a queued state, waiting for resources to become available. This is a transient state.
	JobStateQueued JobState = "Queued"
	// JobStateScheduled - The job is being scheduled to run on an available resource. This is a transient state, between queued
	// and processing states.
	JobStateScheduled JobState = "Scheduled"
)

// PossibleJobStateValues returns the possible values for the JobState const type.
func PossibleJobStateValues() []JobState {
	return []JobState{
		JobStateCanceled,
		JobStateCanceling,
		JobStateError,
		JobStateFinished,
		JobStateProcessing,
		JobStateQueued,
		JobStateScheduled,
	}
}

// LiveEventEncodingType - Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service
// simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to
// Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101
// for more information. This property cannot
// be modified after the live event is created.
type LiveEventEncodingType string

const (
	// LiveEventEncodingTypeNone - This is the same as PassthroughStandard, please see description below. This enumeration value
	// is being deprecated.
	LiveEventEncodingTypeNone LiveEventEncodingType = "None"
	// LiveEventEncodingTypePassthroughBasic - The ingested stream passes through the live event from the contribution encoder
	// without any further processing. In the PassthroughBasic mode, ingestion is limited to up to 5Mbps and only 1 concurrent
	// live output is allowed. Live transcription is not available.
	LiveEventEncodingTypePassthroughBasic LiveEventEncodingType = "PassthroughBasic"
	// LiveEventEncodingTypePassthroughStandard - The ingested stream passes through the live event from the contribution encoder
	// without any further processing. Live transcription is available. Ingestion bitrate limits are much higher and up to 3 concurrent
	// live outputs are allowed.
	LiveEventEncodingTypePassthroughStandard LiveEventEncodingType = "PassthroughStandard"
	// LiveEventEncodingTypePremium1080P - A contribution live encoder sends a single bitrate stream to the live event and Media
	// Services creates multiple bitrate streams. The output cannot exceed 1080p in resolution.
	LiveEventEncodingTypePremium1080P LiveEventEncodingType = "Premium1080p"
	// LiveEventEncodingTypeStandard - A contribution live encoder sends a single bitrate stream to the live event and Media Services
	// creates multiple bitrate streams. The output cannot exceed 720p in resolution.
	LiveEventEncodingTypeStandard LiveEventEncodingType = "Standard"
)

// PossibleLiveEventEncodingTypeValues returns the possible values for the LiveEventEncodingType const type.
func PossibleLiveEventEncodingTypeValues() []LiveEventEncodingType {
	return []LiveEventEncodingType{
		LiveEventEncodingTypeNone,
		LiveEventEncodingTypePassthroughBasic,
		LiveEventEncodingTypePassthroughStandard,
		LiveEventEncodingTypePremium1080P,
		LiveEventEncodingTypeStandard,
	}
}

// LiveEventInputProtocol - The input protocol for the live event. This is specified at creation time and cannot be updated.
type LiveEventInputProtocol string

const (
	// LiveEventInputProtocolFragmentedMP4 - Smooth Streaming input will be sent by the contribution encoder to the live event.
	LiveEventInputProtocolFragmentedMP4 LiveEventInputProtocol = "FragmentedMP4"
	// LiveEventInputProtocolRTMP - RTMP input will be sent by the contribution encoder to the live event.
	LiveEventInputProtocolRTMP LiveEventInputProtocol = "RTMP"
)

// PossibleLiveEventInputProtocolValues returns the possible values for the LiveEventInputProtocol const type.
func PossibleLiveEventInputProtocolValues() []LiveEventInputProtocol {
	return []LiveEventInputProtocol{
		LiveEventInputProtocolFragmentedMP4,
		LiveEventInputProtocolRTMP,
	}
}

// LiveEventResourceState - The resource state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for
// more information.
type LiveEventResourceState string

const (
	// LiveEventResourceStateAllocating - Allocate action was called on the live event and resources are being provisioned for
	// this live event. Once allocation completes successfully, the live event will transition to StandBy state.
	LiveEventResourceStateAllocating LiveEventResourceState = "Allocating"
	// LiveEventResourceStateDeleting - The live event is being deleted. No billing occurs in this transient state. Updates or
	// streaming are not allowed during this state.
	LiveEventResourceStateDeleting LiveEventResourceState = "Deleting"
	// LiveEventResourceStateRunning - The live event resources have been allocated, ingest and preview URLs have been generated,
	// and it is capable of receiving live streams. At this point, billing is active. You must explicitly call Stop on the live
	// event resource to halt further billing.
	LiveEventResourceStateRunning LiveEventResourceState = "Running"
	// LiveEventResourceStateStandBy - Live event resources have been provisioned and is ready to start. Billing occurs in this
	// state. Most properties can still be updated, however ingest or streaming is not allowed during this state.
	LiveEventResourceStateStandBy LiveEventResourceState = "StandBy"
	// LiveEventResourceStateStarting - The live event is being started and resources are being allocated. No billing occurs in
	// this state. Updates or streaming are not allowed during this state. If an error occurs, the live event returns to the Stopped
	// state.
	LiveEventResourceStateStarting LiveEventResourceState = "Starting"
	// LiveEventResourceStateStopped - This is the initial state of the live event after creation (unless autostart was set to
	// true.) No billing occurs in this state. In this state, the live event properties can be updated but streaming is not allowed.
	LiveEventResourceStateStopped LiveEventResourceState = "Stopped"
	// LiveEventResourceStateStopping - The live event is being stopped and resources are being de-provisioned. No billing occurs
	// in this transient state. Updates or streaming are not allowed during this state.
	LiveEventResourceStateStopping LiveEventResourceState = "Stopping"
)

// PossibleLiveEventResourceStateValues returns the possible values for the LiveEventResourceState const type.
func PossibleLiveEventResourceStateValues() []LiveEventResourceState {
	return []LiveEventResourceState{
		LiveEventResourceStateAllocating,
		LiveEventResourceStateDeleting,
		LiveEventResourceStateRunning,
		LiveEventResourceStateStandBy,
		LiveEventResourceStateStarting,
		LiveEventResourceStateStopped,
		LiveEventResourceStateStopping,
	}
}

// LiveOutputResourceState - The resource state of the live output.
type LiveOutputResourceState string

const (
	// LiveOutputResourceStateCreating - Live output is being created. No content is archived in the asset until the live output
	// is in running state.
	LiveOutputResourceStateCreating LiveOutputResourceState = "Creating"
	// LiveOutputResourceStateDeleting - Live output is being deleted. The live asset is being converted from live to on-demand
	// asset. Any streaming URLs created on the live output asset continue to work.
	LiveOutputResourceStateDeleting LiveOutputResourceState = "Deleting"
	// LiveOutputResourceStateRunning - Live output is running and archiving live streaming content to the asset if there is valid
	// input from a contribution encoder.
	LiveOutputResourceStateRunning LiveOutputResourceState = "Running"
)

// PossibleLiveOutputResourceStateValues returns the possible values for the LiveOutputResourceState const type.
func PossibleLiveOutputResourceStateValues() []LiveOutputResourceState {
	return []LiveOutputResourceState{
		LiveOutputResourceStateCreating,
		LiveOutputResourceStateDeleting,
		LiveOutputResourceStateRunning,
	}
}

// MetricAggregationType - The metric aggregation type
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage - The average.
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeCount - The count of a number of items, usually requests.
	MetricAggregationTypeCount MetricAggregationType = "Count"
	// MetricAggregationTypeTotal - The sum.
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns the possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{
		MetricAggregationTypeAverage,
		MetricAggregationTypeCount,
		MetricAggregationTypeTotal,
	}
}

// MetricUnit - The metric unit
type MetricUnit string

const (
	// MetricUnitBytes - The number of bytes.
	MetricUnitBytes MetricUnit = "Bytes"
	// MetricUnitCount - The count.
	MetricUnitCount MetricUnit = "Count"
	// MetricUnitMilliseconds - The number of milliseconds.
	MetricUnitMilliseconds MetricUnit = "Milliseconds"
)

// PossibleMetricUnitValues returns the possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{
		MetricUnitBytes,
		MetricUnitCount,
		MetricUnitMilliseconds,
	}
}

// OnErrorType - A Transform can define more than one outputs. This property defines what the service should do when one output
// fails - either continue to produce other outputs, or, stop the other outputs. The overall
// Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
type OnErrorType string

const (
	// OnErrorTypeContinueJob - Tells the service that if this TransformOutput fails, then allow any other TransformOutput to
	// continue.
	OnErrorTypeContinueJob OnErrorType = "ContinueJob"
	// OnErrorTypeStopProcessingJob - Tells the service that if this TransformOutput fails, then any other incomplete TransformOutputs
	// can be stopped.
	OnErrorTypeStopProcessingJob OnErrorType = "StopProcessingJob"
)

// PossibleOnErrorTypeValues returns the possible values for the OnErrorType const type.
func PossibleOnErrorTypeValues() []OnErrorType {
	return []OnErrorType{
		OnErrorTypeContinueJob,
		OnErrorTypeStopProcessingJob,
	}
}

// Priority - Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service
// uses for processing TransformOutputs. The default priority is Normal.
type Priority string

const (
	// PriorityHigh - Used for TransformOutputs that should take precedence over others.
	PriorityHigh Priority = "High"
	// PriorityLow - Used for TransformOutputs that can be generated after Normal and High priority TransformOutputs.
	PriorityLow Priority = "Low"
	// PriorityNormal - Used for TransformOutputs that can be generated at Normal priority.
	PriorityNormal Priority = "Normal"
)

// PossiblePriorityValues returns the possible values for the Priority const type.
func PossiblePriorityValues() []Priority {
	return []Priority{
		PriorityHigh,
		PriorityLow,
		PriorityNormal,
	}
}

// PrivateEndpointConnectionProvisioningState - The current provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = "Creating"
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = "Deleting"
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = "Failed"
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns the possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{
		PrivateEndpointConnectionProvisioningStateCreating,
		PrivateEndpointConnectionProvisioningStateDeleting,
		PrivateEndpointConnectionProvisioningStateFailed,
		PrivateEndpointConnectionProvisioningStateSucceeded,
	}
}

// PrivateEndpointServiceConnectionStatus - The private endpoint connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	PrivateEndpointServiceConnectionStatusPending  PrivateEndpointServiceConnectionStatus = "Pending"
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns the possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{
		PrivateEndpointServiceConnectionStatusApproved,
		PrivateEndpointServiceConnectionStatusPending,
		PrivateEndpointServiceConnectionStatusRejected,
	}
}

// ProvisioningState - Provisioning state of the Media Services account.
type ProvisioningState string

const (
	// ProvisioningStateFailed - Provisioning state failed.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress - Provisioning state in progress.
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded - Provisioning state succeeded.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateFailed,
		ProvisioningStateInProgress,
		ProvisioningStateSucceeded,
	}
}

// PublicNetworkAccess - Whether or not public network access is allowed for resources under the Media Services account.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled - Public network access is disabled.
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled - Public network access is enabled.
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
	}
}

// Rotation - The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
type Rotation string

const (
	// RotationAuto - Automatically detect and rotate as needed.
	RotationAuto Rotation = "Auto"
	// RotationNone - Do not rotate the video. If the output format supports it, any metadata about rotation is kept intact.
	RotationNone Rotation = "None"
	// RotationRotate0 - Do not rotate the video but remove any metadata about the rotation.
	RotationRotate0 Rotation = "Rotate0"
	// RotationRotate180 - Rotate 180 degrees clockwise.
	RotationRotate180 Rotation = "Rotate180"
	// RotationRotate270 - Rotate 270 degrees clockwise.
	RotationRotate270 Rotation = "Rotate270"
	// RotationRotate90 - Rotate 90 degrees clockwise.
	RotationRotate90 Rotation = "Rotate90"
)

// PossibleRotationValues returns the possible values for the Rotation const type.
func PossibleRotationValues() []Rotation {
	return []Rotation{
		RotationAuto,
		RotationNone,
		RotationRotate0,
		RotationRotate180,
		RotationRotate270,
		RotationRotate90,
	}
}

// SecurityLevel - The security level.
type SecurityLevel string

const (
	// SecurityLevelSL150 - For clients under development or test. No protection against unauthorized use.
	SecurityLevelSL150 SecurityLevel = "SL150"
	// SecurityLevelSL2000 - For hardened devices and applications consuming commercial content. Software or hardware protection.
	SecurityLevelSL2000 SecurityLevel = "SL2000"
	// SecurityLevelSL3000 - For hardened devices only. Hardware protection.
	SecurityLevelSL3000 SecurityLevel = "SL3000"
	// SecurityLevelUnknown - Represents a SecurityLevel that is unavailable in current API version.
	SecurityLevelUnknown SecurityLevel = "Unknown"
)

// PossibleSecurityLevelValues returns the possible values for the SecurityLevel const type.
func PossibleSecurityLevelValues() []SecurityLevel {
	return []SecurityLevel{
		SecurityLevelSL150,
		SecurityLevelSL2000,
		SecurityLevelSL3000,
		SecurityLevelUnknown,
	}
}

// StorageAccountType - The type of the storage account.
type StorageAccountType string

const (
	// StorageAccountTypePrimary - The primary storage account for the Media Services account.
	StorageAccountTypePrimary StorageAccountType = "Primary"
	// StorageAccountTypeSecondary - A secondary storage account for the Media Services account.
	StorageAccountTypeSecondary StorageAccountType = "Secondary"
)

// PossibleStorageAccountTypeValues returns the possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{
		StorageAccountTypePrimary,
		StorageAccountTypeSecondary,
	}
}

type StorageAuthentication string

const (
	// StorageAuthenticationManagedIdentity - Managed Identity authentication.
	StorageAuthenticationManagedIdentity StorageAuthentication = "ManagedIdentity"
	// StorageAuthenticationSystem - System authentication.
	StorageAuthenticationSystem StorageAuthentication = "System"
)

// PossibleStorageAuthenticationValues returns the possible values for the StorageAuthentication const type.
func PossibleStorageAuthenticationValues() []StorageAuthentication {
	return []StorageAuthentication{
		StorageAuthenticationManagedIdentity,
		StorageAuthenticationSystem,
	}
}

type StreamOptionsFlag string

const (
	// StreamOptionsFlagDefault - Live streaming with no special latency optimizations.
	StreamOptionsFlagDefault StreamOptionsFlag = "Default"
	// StreamOptionsFlagLowLatency - The live event provides lower end to end latency by reducing its internal buffers.
	StreamOptionsFlagLowLatency StreamOptionsFlag = "LowLatency"
	// StreamOptionsFlagLowLatencyV2 - The live event is optimized for end to end latency. This option is only available for encoding
	// live events with RTMP input. The outputs can be streamed using HLS or DASH formats. The outputs' archive or DVR rewind
	// length is limited to 6 hours. Use "LowLatency" stream option for all other scenarios.
	StreamOptionsFlagLowLatencyV2 StreamOptionsFlag = "LowLatencyV2"
)

// PossibleStreamOptionsFlagValues returns the possible values for the StreamOptionsFlag const type.
func PossibleStreamOptionsFlagValues() []StreamOptionsFlag {
	return []StreamOptionsFlag{
		StreamOptionsFlagDefault,
		StreamOptionsFlagLowLatency,
		StreamOptionsFlagLowLatencyV2,
	}
}

// StreamingEndpointResourceState - The resource state of the streaming endpoint.
type StreamingEndpointResourceState string

const (
	// StreamingEndpointResourceStateDeleting - The streaming endpoint is being deleted.
	StreamingEndpointResourceStateDeleting StreamingEndpointResourceState = "Deleting"
	// StreamingEndpointResourceStateRunning - The streaming endpoint is running. It is able to stream content to clients
	StreamingEndpointResourceStateRunning StreamingEndpointResourceState = "Running"
	// StreamingEndpointResourceStateScaling - The streaming endpoint is increasing or decreasing scale units.
	StreamingEndpointResourceStateScaling StreamingEndpointResourceState = "Scaling"
	// StreamingEndpointResourceStateStarting - The streaming endpoint is transitioning to the running state.
	StreamingEndpointResourceStateStarting StreamingEndpointResourceState = "Starting"
	// StreamingEndpointResourceStateStopped - The initial state of a streaming endpoint after creation. Content is not ready
	// to be streamed from this endpoint.
	StreamingEndpointResourceStateStopped StreamingEndpointResourceState = "Stopped"
	// StreamingEndpointResourceStateStopping - The streaming endpoint is transitioning to the stopped state.
	StreamingEndpointResourceStateStopping StreamingEndpointResourceState = "Stopping"
)

// PossibleStreamingEndpointResourceStateValues returns the possible values for the StreamingEndpointResourceState const type.
func PossibleStreamingEndpointResourceStateValues() []StreamingEndpointResourceState {
	return []StreamingEndpointResourceState{
		StreamingEndpointResourceStateDeleting,
		StreamingEndpointResourceStateRunning,
		StreamingEndpointResourceStateScaling,
		StreamingEndpointResourceStateStarting,
		StreamingEndpointResourceStateStopped,
		StreamingEndpointResourceStateStopping,
	}
}

// StreamingLocatorContentKeyType - Encryption type of Content Key
type StreamingLocatorContentKeyType string

const (
	// StreamingLocatorContentKeyTypeCommonEncryptionCbcs - Common Encryption using CBCS
	StreamingLocatorContentKeyTypeCommonEncryptionCbcs StreamingLocatorContentKeyType = "CommonEncryptionCbcs"
	// StreamingLocatorContentKeyTypeCommonEncryptionCenc - Common Encryption using CENC
	StreamingLocatorContentKeyTypeCommonEncryptionCenc StreamingLocatorContentKeyType = "CommonEncryptionCenc"
	// StreamingLocatorContentKeyTypeEnvelopeEncryption - Envelope Encryption
	StreamingLocatorContentKeyTypeEnvelopeEncryption StreamingLocatorContentKeyType = "EnvelopeEncryption"
)

// PossibleStreamingLocatorContentKeyTypeValues returns the possible values for the StreamingLocatorContentKeyType const type.
func PossibleStreamingLocatorContentKeyTypeValues() []StreamingLocatorContentKeyType {
	return []StreamingLocatorContentKeyType{
		StreamingLocatorContentKeyTypeCommonEncryptionCbcs,
		StreamingLocatorContentKeyTypeCommonEncryptionCenc,
		StreamingLocatorContentKeyTypeEnvelopeEncryption,
	}
}

// StreamingPolicyStreamingProtocol - Streaming protocol
type StreamingPolicyStreamingProtocol string

const (
	// StreamingPolicyStreamingProtocolDash - DASH protocol
	StreamingPolicyStreamingProtocolDash StreamingPolicyStreamingProtocol = "Dash"
	// StreamingPolicyStreamingProtocolDownload - Download protocol
	StreamingPolicyStreamingProtocolDownload StreamingPolicyStreamingProtocol = "Download"
	// StreamingPolicyStreamingProtocolHls - HLS protocol
	StreamingPolicyStreamingProtocolHls StreamingPolicyStreamingProtocol = "Hls"
	// StreamingPolicyStreamingProtocolSmoothStreaming - SmoothStreaming protocol
	StreamingPolicyStreamingProtocolSmoothStreaming StreamingPolicyStreamingProtocol = "SmoothStreaming"
)

// PossibleStreamingPolicyStreamingProtocolValues returns the possible values for the StreamingPolicyStreamingProtocol const type.
func PossibleStreamingPolicyStreamingProtocolValues() []StreamingPolicyStreamingProtocol {
	return []StreamingPolicyStreamingProtocol{
		StreamingPolicyStreamingProtocolDash,
		StreamingPolicyStreamingProtocolDownload,
		StreamingPolicyStreamingProtocolHls,
		StreamingPolicyStreamingProtocolSmoothStreaming,
	}
}

// StretchMode - The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default
// is AutoSize
type StretchMode string

const (
	// StretchModeAutoFit - Pad the output (with either letterbox or pillar box) to honor the output resolution, while ensuring
	// that the active video region in the output has the same aspect ratio as the input. For example, if the input is 1920x1080
	// and the encoding preset asks for 1280x1280, then the output will be at 1280x1280, which contains an inner rectangle of
	// 1280x720 at aspect ratio of 16:9, and pillar box regions 280 pixels wide at the left and right.
	StretchModeAutoFit StretchMode = "AutoFit"
	// StretchModeAutoSize - Override the output resolution, and change it to match the display aspect ratio of the input, without
	// padding. For example, if the input is 1920x1080 and the encoding preset asks for 1280x1280, then the value in the preset
	// is overridden, and the output will be at 1280x720, which maintains the input aspect ratio of 16:9.
	StretchModeAutoSize StretchMode = "AutoSize"
	// StretchModeNone - Strictly respect the output resolution without considering the pixel aspect ratio or display aspect ratio
	// of the input video.
	StretchModeNone StretchMode = "None"
)

// PossibleStretchModeValues returns the possible values for the StretchMode const type.
func PossibleStretchModeValues() []StretchMode {
	return []StretchMode{
		StretchModeAutoFit,
		StretchModeAutoSize,
		StretchModeNone,
	}
}

// TrackAttribute - The TrackAttribute to filter the tracks by.
type TrackAttribute string

const (
	// TrackAttributeBitrate - The bitrate of the track.
	TrackAttributeBitrate TrackAttribute = "Bitrate"
	// TrackAttributeLanguage - The language of the track.
	TrackAttributeLanguage TrackAttribute = "Language"
)

// PossibleTrackAttributeValues returns the possible values for the TrackAttribute const type.
func PossibleTrackAttributeValues() []TrackAttribute {
	return []TrackAttribute{
		TrackAttributeBitrate,
		TrackAttributeLanguage,
	}
}

// TrackPropertyCompareOperation - Track property condition operation
type TrackPropertyCompareOperation string

const (
	// TrackPropertyCompareOperationEqual - Equal operation
	TrackPropertyCompareOperationEqual TrackPropertyCompareOperation = "Equal"
	// TrackPropertyCompareOperationUnknown - Unknown track property compare operation
	TrackPropertyCompareOperationUnknown TrackPropertyCompareOperation = "Unknown"
)

// PossibleTrackPropertyCompareOperationValues returns the possible values for the TrackPropertyCompareOperation const type.
func PossibleTrackPropertyCompareOperationValues() []TrackPropertyCompareOperation {
	return []TrackPropertyCompareOperation{
		TrackPropertyCompareOperationEqual,
		TrackPropertyCompareOperationUnknown,
	}
}

// TrackPropertyType - Track property type
type TrackPropertyType string

const (
	// TrackPropertyTypeFourCC - Track FourCC
	TrackPropertyTypeFourCC TrackPropertyType = "FourCC"
	// TrackPropertyTypeUnknown - Unknown track property
	TrackPropertyTypeUnknown TrackPropertyType = "Unknown"
)

// PossibleTrackPropertyTypeValues returns the possible values for the TrackPropertyType const type.
func PossibleTrackPropertyTypeValues() []TrackPropertyType {
	return []TrackPropertyType{
		TrackPropertyTypeFourCC,
		TrackPropertyTypeUnknown,
	}
}

// VideoSyncMode - The Video Sync Mode
type VideoSyncMode string

const (
	// VideoSyncModeAuto - This is the default method. Chooses between Cfr and Vfr depending on muxer capabilities. For output
	// format MP4, the default mode is Cfr.
	VideoSyncModeAuto VideoSyncMode = "Auto"
	// VideoSyncModeCfr - Input frames will be repeated and/or dropped as needed to achieve exactly the requested constant frame
	// rate. Recommended when the output frame rate is explicitly set at a specified value
	VideoSyncModeCfr VideoSyncMode = "Cfr"
	// VideoSyncModePassthrough - The presentation timestamps on frames are passed through from the input file to the output file
	// writer. Recommended when the input source has variable frame rate, and are attempting to produce multiple layers for adaptive
	// streaming in the output which have aligned GOP boundaries. Note: if two or more frames in the input have duplicate timestamps,
	// then the output will also have the same behavior
	VideoSyncModePassthrough VideoSyncMode = "Passthrough"
	// VideoSyncModeVfr - Similar to the Passthrough mode, but if the input has frames that have duplicate timestamps, then only
	// one frame is passed through to the output, and others are dropped. Recommended when the number of output frames is expected
	// to be equal to the number of input frames. For example, the output is used to calculate a quality metric like PSNR against
	// the input
	VideoSyncModeVfr VideoSyncMode = "Vfr"
)

// PossibleVideoSyncModeValues returns the possible values for the VideoSyncMode const type.
func PossibleVideoSyncModeValues() []VideoSyncMode {
	return []VideoSyncMode{
		VideoSyncModeAuto,
		VideoSyncModeCfr,
		VideoSyncModePassthrough,
		VideoSyncModeVfr,
	}
}

// Visibility - When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist
// when requested by a client. When the PlayerVisibility is set to "Hidden", the text will
// not be available to the client. The default value is "Visible".
type Visibility string

const (
	// VisibilityHidden - The track is hidden to video player.
	VisibilityHidden Visibility = "Hidden"
	// VisibilityVisible - The track is visible to video player.
	VisibilityVisible Visibility = "Visible"
)

// PossibleVisibilityValues returns the possible values for the Visibility const type.
func PossibleVisibilityValues() []Visibility {
	return []Visibility{
		VisibilityHidden,
		VisibilityVisible,
	}
}
