//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentmanager

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIKeyAuthentication.
func (a APIKeyAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "in", a.In)
	populate(objectMap, "name", a.Name)
	objectMap["type"] = RestAuthTypeAPIKey
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIKeyAuthentication.
func (a *APIKeyAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "in":
			err = unpopulate(val, "In", &a.In)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSource.
func (a ArtifactSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSourceProperties.
func (a ArtifactSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "artifactRoot", a.ArtifactRoot)
	populate(objectMap, "authentication", a.Authentication)
	populate(objectMap, "sourceType", a.SourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSourceProperties.
func (a *ArtifactSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactRoot":
			err = unpopulate(val, "ArtifactRoot", &a.ArtifactRoot)
			delete(rawMsg, key)
		case "authentication":
			a.Authentication, err = unmarshalAuthenticationClassification(val)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &a.SourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSourcePropertiesAutoGenerated.
func (a ArtifactSourcePropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "artifactRoot", a.ArtifactRoot)
	populate(objectMap, "authentication", a.Authentication)
	populate(objectMap, "sourceType", a.SourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSourcePropertiesAutoGenerated.
func (a *ArtifactSourcePropertiesAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactRoot":
			err = unpopulate(val, "ArtifactRoot", &a.ArtifactRoot)
			delete(rawMsg, key)
		case "authentication":
			a.Authentication, err = unmarshalAuthenticationClassification(val)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &a.SourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudErrorBody.
func (c CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", c.Code)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type HealthCheckStepProperties.
func (h HealthCheckStepProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", h.Attributes)
	objectMap["stepType"] = StepTypeHealthCheck
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthCheckStepProperties.
func (h *HealthCheckStepProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			h.Attributes, err = unmarshalHealthCheckStepAttributesClassification(val)
			delete(rawMsg, key)
		case "stepType":
			err = unpopulate(val, "StepType", &h.StepType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identityIds", i.IdentityIDs)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Message.
func (m Message) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "message", m.Message)
	populateTimeRFC3339(objectMap, "timeStamp", m.TimeStamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Message.
func (m *Message) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateTimeRFC3339(val, "TimeStamp", &m.TimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestHealthCheckStepAttributes.
func (r RestHealthCheckStepAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "healthyStateDuration", r.HealthyStateDuration)
	populate(objectMap, "maxElasticDuration", r.MaxElasticDuration)
	populate(objectMap, "properties", r.Properties)
	objectMap["type"] = "REST"
	populate(objectMap, "waitDuration", r.WaitDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestHealthCheckStepAttributes.
func (r *RestHealthCheckStepAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthyStateDuration":
			err = unpopulate(val, "HealthyStateDuration", &r.HealthyStateDuration)
			delete(rawMsg, key)
		case "maxElasticDuration":
			err = unpopulate(val, "MaxElasticDuration", &r.MaxElasticDuration)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "waitDuration":
			err = unpopulate(val, "WaitDuration", &r.WaitDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestParameters.
func (r RestParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "healthChecks", r.HealthChecks)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestRequest.
func (r RestRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authentication", r.Authentication)
	populate(objectMap, "method", r.Method)
	populate(objectMap, "uri", r.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestRequest.
func (r *RestRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			r.Authentication, err = unmarshalRestRequestAuthenticationClassification(val)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &r.Method)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &r.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestResponse.
func (r RestResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "regex", r.Regex)
	populate(objectMap, "successStatusCodes", r.SuccessStatusCodes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestResponseRegex.
func (r RestResponseRegex) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "matchQuantifier", r.MatchQuantifier)
	populate(objectMap, "matches", r.Matches)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Rollout.
func (r Rollout) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RolloutIdentityAuthentication.
func (r RolloutIdentityAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["type"] = RestAuthTypeRolloutIdentity
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutIdentityAuthentication.
func (r *RolloutIdentityAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutOperationInfo.
func (r RolloutOperationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "retryAttempt", r.RetryAttempt)
	populate(objectMap, "skipSucceededOnRetry", r.SkipSucceededOnRetry)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutOperationInfo.
func (r *RolloutOperationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "retryAttempt":
			err = unpopulate(val, "RetryAttempt", &r.RetryAttempt)
			delete(rawMsg, key)
		case "skipSucceededOnRetry":
			err = unpopulate(val, "SkipSucceededOnRetry", &r.SkipSucceededOnRetry)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutProperties.
func (r RolloutProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "artifactSourceId", r.ArtifactSourceID)
	populate(objectMap, "buildVersion", r.BuildVersion)
	populate(objectMap, "operationInfo", r.OperationInfo)
	populate(objectMap, "services", r.Services)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "stepGroups", r.StepGroups)
	populate(objectMap, "targetServiceTopologyId", r.TargetServiceTopologyID)
	populate(objectMap, "totalRetryAttempts", r.TotalRetryAttempts)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RolloutPropertiesAutoGenerated.
func (r RolloutPropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operationInfo", r.OperationInfo)
	populate(objectMap, "services", r.Services)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "totalRetryAttempts", r.TotalRetryAttempts)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RolloutRequest.
func (r RolloutRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RolloutRequestProperties.
func (r RolloutRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "artifactSourceId", r.ArtifactSourceID)
	populate(objectMap, "buildVersion", r.BuildVersion)
	populate(objectMap, "stepGroups", r.StepGroups)
	populate(objectMap, "targetServiceTopologyId", r.TargetServiceTopologyID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RolloutStep.
func (r RolloutStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "messages", r.Messages)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "operationInfo", r.OperationInfo)
	populate(objectMap, "resourceOperations", r.ResourceOperations)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "stepGroup", r.StepGroup)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SasAuthentication.
func (s SasAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	objectMap["type"] = "Sas"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SasAuthentication.
func (s *SasAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "serviceUnits", s.ServiceUnits)
	populate(objectMap, "targetLocation", s.TargetLocation)
	populate(objectMap, "targetSubscriptionId", s.TargetSubscriptionID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResource.
func (s ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTopologyResource.
func (s ServiceTopologyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUnit.
func (s ServiceUnit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "artifacts", s.Artifacts)
	populate(objectMap, "deploymentMode", s.DeploymentMode)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "steps", s.Steps)
	populate(objectMap, "targetResourceGroup", s.TargetResourceGroup)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUnitResource.
func (s ServiceUnitResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type StepGroup.
func (s StepGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dependsOnStepGroups", s.DependsOnStepGroups)
	populate(objectMap, "deploymentTargetId", s.DeploymentTargetID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "postDeploymentSteps", s.PostDeploymentSteps)
	populate(objectMap, "preDeploymentSteps", s.PreDeploymentSteps)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type StepOperationInfo.
func (s StepOperationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationId", s.CorrelationID)
	populate(objectMap, "deploymentName", s.DeploymentName)
	populateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "error", s.Error)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", s.LastUpdatedTime)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StepOperationInfo.
func (s *StepOperationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &s.CorrelationID)
			delete(rawMsg, key)
		case "deploymentName":
			err = unpopulate(val, "DeploymentName", &s.DeploymentName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTime", &s.LastUpdatedTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StepResource.
func (s StepResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StepResource.
func (s *StepResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			s.Properties, err = unmarshalStepPropertiesClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WaitStepProperties.
func (w WaitStepProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", w.Attributes)
	objectMap["stepType"] = StepTypeWait
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WaitStepProperties.
func (w *WaitStepProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &w.Attributes)
			delete(rawMsg, key)
		case "stepType":
			err = unpopulate(val, "StepType", &w.StepType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
