//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armaddons

// CanonicalSupportPlanInfoDefinition - Definition object with the properties of a canonical plan
type CanonicalSupportPlanInfoDefinition struct {
	// Flag to indicate if this support plan type is currently enabled for the subscription.
	Enabled *bool `json:"enabled,omitempty"`

	// The one time charge status for the subscription.
	OneTimeCharge *OneTimeCharge `json:"oneTimeCharge,omitempty"`

	// Support plan type.
	SupportPlanType *SupportPlanType `json:"supportPlanType,omitempty"`
}

// CanonicalSupportPlanProperties - The properties of the Canonical support plan.
type CanonicalSupportPlanProperties struct {
	// The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`
}

// CanonicalSupportPlanResponseEnvelope - The status of the Canonical support plan.
type CanonicalSupportPlanResponseEnvelope struct {
	// REQUIRED; Describes Canonical support plan type and status.
	Properties *CanonicalSupportPlanProperties `json:"properties,omitempty"`

	// READ-ONLY; The id of the ARM resource, e.g. "/subscriptions/{id}/providers/Microsoft.Addons/supportProvider/{supportProviderName}/supportPlanTypes/{planTypeName}".
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the Canonical support plan, i.e. "essential", "standard" or "advanced".
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Microsoft.Addons/supportProvider
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDefinition - Error description and code explaining why an operation failed.
type ErrorDefinition struct {
	// REQUIRED; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty"`

	// REQUIRED; Description of the error.
	Message *string `json:"message,omitempty"`
}

// OperationListValue - List of supported operations.
type OperationListValue struct {
	// List of supported operations.
	Value []*OperationsDefinition `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsDefinition - Definition object with the name and properties of an operation.
type OperationsDefinition struct {
	// Display object with properties of the operation.
	Display *OperationsDisplayDefinition `json:"display,omitempty"`

	// Name of the operation.
	Name *string `json:"name,omitempty"`
}

// OperationsDisplayDefinition - Display object with properties of the operation.
type OperationsDisplayDefinition struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Short description of the operation.
	Operation *string `json:"operation,omitempty"`

	// Resource provider of the operation.
	Provider *string `json:"provider,omitempty"`

	// Resource for the operation.
	Resource *string `json:"resource,omitempty"`
}

// SupportPlanTypesClientBeginCreateOrUpdateOptions contains the optional parameters for the SupportPlanTypesClient.BeginCreateOrUpdate
// method.
type SupportPlanTypesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SupportPlanTypesClientBeginDeleteOptions contains the optional parameters for the SupportPlanTypesClient.BeginDelete method.
type SupportPlanTypesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SupportPlanTypesClientGetOptions contains the optional parameters for the SupportPlanTypesClient.Get method.
type SupportPlanTypesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SupportPlanTypesClientListInfoOptions contains the optional parameters for the SupportPlanTypesClient.ListInfo method.
type SupportPlanTypesClientListInfoOptions struct {
	// placeholder for future optional parameters
}
