//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package generated

import (
	"context"
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AzureAppConfigurationClient contains the methods for the AzureAppConfiguration group.
// Don't use this type directly, use NewAzureAppConfigurationClient() instead.
type AzureAppConfigurationClient struct {
	endpoint  string
	syncToken *string
	pl        runtime.Pipeline
}

// NewAzureAppConfigurationClient creates a new instance of AzureAppConfigurationClient with the specified values.
// endpoint - The endpoint of the App Configuration instance to send requests to.
// syncToken - Used to guarantee real-time consistency between requests.
// pl - the pipeline used for sending requests and handling responses.
func NewAzureAppConfigurationClient(endpoint string, syncToken *string, pl runtime.Pipeline) *AzureAppConfigurationClient {
	client := &AzureAppConfigurationClient{
		endpoint:  endpoint,
		syncToken: syncToken,
		pl:        pl,
	}
	return client
}

// CheckKeyValue - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// key - The key of the key-value to retrieve.
// options - AzureAppConfigurationClientCheckKeyValueOptions contains the optional parameters for the AzureAppConfigurationClient.CheckKeyValue
// method.
func (client *AzureAppConfigurationClient) CheckKeyValue(ctx context.Context, key string, options *AzureAppConfigurationClientCheckKeyValueOptions) (AzureAppConfigurationClientCheckKeyValueResponse, error) {
	req, err := client.checkKeyValueCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientCheckKeyValueResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckKeyValueResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureAppConfigurationClientCheckKeyValueResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkKeyValueHandleResponse(resp)
}

// checkKeyValueCreateRequest creates the CheckKeyValue request.
func (client *AzureAppConfigurationClient) checkKeyValueCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientCheckKeyValueOptions) (*policy.Request, error) {
	urlPath := "/kv/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	return req, nil
}

// checkKeyValueHandleResponse handles the CheckKeyValue response.
func (client *AzureAppConfigurationClient) checkKeyValueHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckKeyValueResponse, error) {
	result := AzureAppConfigurationClientCheckKeyValueResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		result.LastModified = &val
	}
	return result, nil
}

// CheckKeyValues - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// options - AzureAppConfigurationClientCheckKeyValuesOptions contains the optional parameters for the AzureAppConfigurationClient.CheckKeyValues
// method.
func (client *AzureAppConfigurationClient) CheckKeyValues(ctx context.Context, options *AzureAppConfigurationClientCheckKeyValuesOptions) (AzureAppConfigurationClientCheckKeyValuesResponse, error) {
	req, err := client.checkKeyValuesCreateRequest(ctx, options)
	if err != nil {
		return AzureAppConfigurationClientCheckKeyValuesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckKeyValuesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureAppConfigurationClientCheckKeyValuesResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkKeyValuesHandleResponse(resp)
}

// checkKeyValuesCreateRequest creates the CheckKeyValues request.
func (client *AzureAppConfigurationClient) checkKeyValuesCreateRequest(ctx context.Context, options *AzureAppConfigurationClientCheckKeyValuesOptions) (*policy.Request, error) {
	urlPath := "/kv"
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Key != nil {
		reqQP.Set("key", *options.Key)
	}
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	return req, nil
}

// checkKeyValuesHandleResponse handles the CheckKeyValues response.
func (client *AzureAppConfigurationClient) checkKeyValuesHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckKeyValuesResponse, error) {
	result := AzureAppConfigurationClientCheckKeyValuesResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// CheckKeys - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// options - AzureAppConfigurationClientCheckKeysOptions contains the optional parameters for the AzureAppConfigurationClient.CheckKeys
// method.
func (client *AzureAppConfigurationClient) CheckKeys(ctx context.Context, options *AzureAppConfigurationClientCheckKeysOptions) (AzureAppConfigurationClientCheckKeysResponse, error) {
	req, err := client.checkKeysCreateRequest(ctx, options)
	if err != nil {
		return AzureAppConfigurationClientCheckKeysResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckKeysResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureAppConfigurationClientCheckKeysResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkKeysHandleResponse(resp)
}

// checkKeysCreateRequest creates the CheckKeys request.
func (client *AzureAppConfigurationClient) checkKeysCreateRequest(ctx context.Context, options *AzureAppConfigurationClientCheckKeysOptions) (*policy.Request, error) {
	urlPath := "/keys"
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Name != nil {
		reqQP.Set("name", *options.Name)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	return req, nil
}

// checkKeysHandleResponse handles the CheckKeys response.
func (client *AzureAppConfigurationClient) checkKeysHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckKeysResponse, error) {
	result := AzureAppConfigurationClientCheckKeysResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// CheckLabels - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// options - AzureAppConfigurationClientCheckLabelsOptions contains the optional parameters for the AzureAppConfigurationClient.CheckLabels
// method.
func (client *AzureAppConfigurationClient) CheckLabels(ctx context.Context, options *AzureAppConfigurationClientCheckLabelsOptions) (AzureAppConfigurationClientCheckLabelsResponse, error) {
	req, err := client.checkLabelsCreateRequest(ctx, options)
	if err != nil {
		return AzureAppConfigurationClientCheckLabelsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckLabelsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureAppConfigurationClientCheckLabelsResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkLabelsHandleResponse(resp)
}

// checkLabelsCreateRequest creates the CheckLabels request.
func (client *AzureAppConfigurationClient) checkLabelsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientCheckLabelsOptions) (*policy.Request, error) {
	urlPath := "/labels"
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Name != nil {
		reqQP.Set("name", *options.Name)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	return req, nil
}

// checkLabelsHandleResponse handles the CheckLabels response.
func (client *AzureAppConfigurationClient) checkLabelsHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckLabelsResponse, error) {
	result := AzureAppConfigurationClientCheckLabelsResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// CheckRevisions - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// options - AzureAppConfigurationClientCheckRevisionsOptions contains the optional parameters for the AzureAppConfigurationClient.CheckRevisions
// method.
func (client *AzureAppConfigurationClient) CheckRevisions(ctx context.Context, options *AzureAppConfigurationClientCheckRevisionsOptions) (AzureAppConfigurationClientCheckRevisionsResponse, error) {
	req, err := client.checkRevisionsCreateRequest(ctx, options)
	if err != nil {
		return AzureAppConfigurationClientCheckRevisionsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckRevisionsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureAppConfigurationClientCheckRevisionsResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkRevisionsHandleResponse(resp)
}

// checkRevisionsCreateRequest creates the CheckRevisions request.
func (client *AzureAppConfigurationClient) checkRevisionsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientCheckRevisionsOptions) (*policy.Request, error) {
	urlPath := "/revisions"
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Key != nil {
		reqQP.Set("key", *options.Key)
	}
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	return req, nil
}

// checkRevisionsHandleResponse handles the CheckRevisions response.
func (client *AzureAppConfigurationClient) checkRevisionsHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckRevisionsResponse, error) {
	result := AzureAppConfigurationClientCheckRevisionsResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// DeleteKeyValue - Deletes a key-value.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// key - The key of the key-value to delete.
// options - AzureAppConfigurationClientDeleteKeyValueOptions contains the optional parameters for the AzureAppConfigurationClient.DeleteKeyValue
// method.
func (client *AzureAppConfigurationClient) DeleteKeyValue(ctx context.Context, key string, options *AzureAppConfigurationClientDeleteKeyValueOptions) (AzureAppConfigurationClientDeleteKeyValueResponse, error) {
	req, err := client.deleteKeyValueCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientDeleteKeyValueResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientDeleteKeyValueResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return AzureAppConfigurationClientDeleteKeyValueResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteKeyValueHandleResponse(resp)
}

// deleteKeyValueCreateRequest creates the DeleteKeyValue request.
func (client *AzureAppConfigurationClient) deleteKeyValueCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientDeleteKeyValueOptions) (*policy.Request, error) {
	urlPath := "/kv/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"}
	return req, nil
}

// deleteKeyValueHandleResponse handles the DeleteKeyValue response.
func (client *AzureAppConfigurationClient) deleteKeyValueHandleResponse(resp *http.Response) (AzureAppConfigurationClientDeleteKeyValueResponse, error) {
	result := AzureAppConfigurationClientDeleteKeyValueResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientDeleteKeyValueResponse{}, err
	}
	return result, nil
}

// DeleteLock - Unlocks a key-value.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// key - The key of the key-value to unlock.
// options - AzureAppConfigurationClientDeleteLockOptions contains the optional parameters for the AzureAppConfigurationClient.DeleteLock
// method.
func (client *AzureAppConfigurationClient) DeleteLock(ctx context.Context, key string, options *AzureAppConfigurationClientDeleteLockOptions) (AzureAppConfigurationClientDeleteLockResponse, error) {
	req, err := client.deleteLockCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientDeleteLockResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientDeleteLockResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureAppConfigurationClientDeleteLockResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteLockHandleResponse(resp)
}

// deleteLockCreateRequest creates the DeleteLock request.
func (client *AzureAppConfigurationClient) deleteLockCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientDeleteLockOptions) (*policy.Request, error) {
	urlPath := "/locks/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"}
	return req, nil
}

// deleteLockHandleResponse handles the DeleteLock response.
func (client *AzureAppConfigurationClient) deleteLockHandleResponse(resp *http.Response) (AzureAppConfigurationClientDeleteLockResponse, error) {
	result := AzureAppConfigurationClientDeleteLockResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientDeleteLockResponse{}, err
	}
	return result, nil
}

// GetKeyValue - Gets a single key-value.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// key - The key of the key-value to retrieve.
// options - AzureAppConfigurationClientGetKeyValueOptions contains the optional parameters for the AzureAppConfigurationClient.GetKeyValue
// method.
func (client *AzureAppConfigurationClient) GetKeyValue(ctx context.Context, key string, options *AzureAppConfigurationClientGetKeyValueOptions) (AzureAppConfigurationClientGetKeyValueResponse, error) {
	req, err := client.getKeyValueCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientGetKeyValueResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientGetKeyValueResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureAppConfigurationClientGetKeyValueResponse{}, runtime.NewResponseError(resp)
	}
	return client.getKeyValueHandleResponse(resp)
}

// getKeyValueCreateRequest creates the GetKeyValue request.
func (client *AzureAppConfigurationClient) getKeyValueCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientGetKeyValueOptions) (*policy.Request, error) {
	urlPath := "/kv/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"}
	return req, nil
}

// getKeyValueHandleResponse handles the GetKeyValue response.
func (client *AzureAppConfigurationClient) getKeyValueHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetKeyValueResponse, error) {
	result := AzureAppConfigurationClientGetKeyValueResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		result.LastModified = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientGetKeyValueResponse{}, err
	}
	return result, nil
}

// NewGetKeyValuesPager - Gets a list of key-values.
// Generated from API version 1.0
// options - AzureAppConfigurationClientGetKeyValuesOptions contains the optional parameters for the AzureAppConfigurationClient.GetKeyValues
// method.
func (client *AzureAppConfigurationClient) NewGetKeyValuesPager(options *AzureAppConfigurationClientGetKeyValuesOptions) *runtime.Pager[AzureAppConfigurationClientGetKeyValuesResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureAppConfigurationClientGetKeyValuesResponse]{
		More: func(page AzureAppConfigurationClientGetKeyValuesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureAppConfigurationClientGetKeyValuesResponse) (AzureAppConfigurationClientGetKeyValuesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getKeyValuesCreateRequest(ctx, options)
			} else {
				req, err = client.getNextPageCreateRequest(ctx, *page.NextLink)
			}
			if err != nil {
				return AzureAppConfigurationClientGetKeyValuesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AzureAppConfigurationClientGetKeyValuesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AzureAppConfigurationClientGetKeyValuesResponse{}, runtime.NewResponseError(resp)
			}
			return client.getKeyValuesHandleResponse(resp)
		},
	})
}

// getKeyValuesCreateRequest creates the GetKeyValues request.
func (client *AzureAppConfigurationClient) getKeyValuesCreateRequest(ctx context.Context, options *AzureAppConfigurationClientGetKeyValuesOptions) (*policy.Request, error) {
	urlPath := "/kv"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Key != nil {
		reqQP.Set("key", *options.Key)
	}
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kvset+json, application/json, application/problem+json"}
	return req, nil
}

// getKeyValuesHandleResponse handles the GetKeyValues response.
func (client *AzureAppConfigurationClient) getKeyValuesHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetKeyValuesResponse, error) {
	result := AzureAppConfigurationClientGetKeyValuesResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValueListResult); err != nil {
		return AzureAppConfigurationClientGetKeyValuesResponse{}, err
	}
	return result, nil
}

// NewGetKeysPager - Gets a list of keys.
// Generated from API version 1.0
// options - AzureAppConfigurationClientGetKeysOptions contains the optional parameters for the AzureAppConfigurationClient.GetKeys
// method.
func (client *AzureAppConfigurationClient) NewGetKeysPager(options *AzureAppConfigurationClientGetKeysOptions) *runtime.Pager[AzureAppConfigurationClientGetKeysResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureAppConfigurationClientGetKeysResponse]{
		More: func(page AzureAppConfigurationClientGetKeysResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureAppConfigurationClientGetKeysResponse) (AzureAppConfigurationClientGetKeysResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getKeysCreateRequest(ctx, options)
			} else {
				req, err = client.getNextPageCreateRequest(ctx, *page.NextLink)
			}
			if err != nil {
				return AzureAppConfigurationClientGetKeysResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AzureAppConfigurationClientGetKeysResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AzureAppConfigurationClientGetKeysResponse{}, runtime.NewResponseError(resp)
			}
			return client.getKeysHandleResponse(resp)
		},
	})
}

// getKeysCreateRequest creates the GetKeys request.
func (client *AzureAppConfigurationClient) getKeysCreateRequest(ctx context.Context, options *AzureAppConfigurationClientGetKeysOptions) (*policy.Request, error) {
	urlPath := "/keys"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Name != nil {
		reqQP.Set("name", *options.Name)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.keyset+json, application/json, application/problem+json"}
	return req, nil
}

// getKeysHandleResponse handles the GetKeys response.
func (client *AzureAppConfigurationClient) getKeysHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetKeysResponse, error) {
	result := AzureAppConfigurationClientGetKeysResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyListResult); err != nil {
		return AzureAppConfigurationClientGetKeysResponse{}, err
	}
	return result, nil
}

// NewGetLabelsPager - Gets a list of labels.
// Generated from API version 1.0
// options - AzureAppConfigurationClientGetLabelsOptions contains the optional parameters for the AzureAppConfigurationClient.GetLabels
// method.
func (client *AzureAppConfigurationClient) NewGetLabelsPager(options *AzureAppConfigurationClientGetLabelsOptions) *runtime.Pager[AzureAppConfigurationClientGetLabelsResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureAppConfigurationClientGetLabelsResponse]{
		More: func(page AzureAppConfigurationClientGetLabelsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureAppConfigurationClientGetLabelsResponse) (AzureAppConfigurationClientGetLabelsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getLabelsCreateRequest(ctx, options)
			} else {
				req, err = client.getNextPageCreateRequest(ctx, *page.NextLink)
			}
			if err != nil {
				return AzureAppConfigurationClientGetLabelsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AzureAppConfigurationClientGetLabelsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AzureAppConfigurationClientGetLabelsResponse{}, runtime.NewResponseError(resp)
			}
			return client.getLabelsHandleResponse(resp)
		},
	})
}

// getLabelsCreateRequest creates the GetLabels request.
func (client *AzureAppConfigurationClient) getLabelsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientGetLabelsOptions) (*policy.Request, error) {
	urlPath := "/labels"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Name != nil {
		reqQP.Set("name", *options.Name)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.labelset+json, application/json, application/problem+json"}
	return req, nil
}

// getLabelsHandleResponse handles the GetLabels response.
func (client *AzureAppConfigurationClient) getLabelsHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetLabelsResponse, error) {
	result := AzureAppConfigurationClientGetLabelsResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.LabelListResult); err != nil {
		return AzureAppConfigurationClientGetLabelsResponse{}, err
	}
	return result, nil
}

// getNextPageCreateRequest creates the GetNextPage request.
func (client *AzureAppConfigurationClient) getNextPageCreateRequest(ctx context.Context, nextLink string) (*policy.Request, error) {
	urlPath := nextLink
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNextPageHandleResponse handles the GetNextPage response.
func (client *AzureAppConfigurationClient) getNextPageHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetNextPageResponse, error) {
	result := AzureAppConfigurationClientGetNextPageResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyListResult); err != nil {
		return AzureAppConfigurationClientGetNextPageResponse{}, err
	}
	return result, nil
}

// NewGetRevisionsPager - Gets a list of key-value revisions.
// Generated from API version 1.0
// options - AzureAppConfigurationClientGetRevisionsOptions contains the optional parameters for the AzureAppConfigurationClient.GetRevisions
// method.
func (client *AzureAppConfigurationClient) NewGetRevisionsPager(options *AzureAppConfigurationClientGetRevisionsOptions) *runtime.Pager[AzureAppConfigurationClientGetRevisionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureAppConfigurationClientGetRevisionsResponse]{
		More: func(page AzureAppConfigurationClientGetRevisionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureAppConfigurationClientGetRevisionsResponse) (AzureAppConfigurationClientGetRevisionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getRevisionsCreateRequest(ctx, options)
			} else {
				req, err = client.getNextPageCreateRequest(ctx, *page.NextLink)
			}
			if err != nil {
				return AzureAppConfigurationClientGetRevisionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AzureAppConfigurationClientGetRevisionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AzureAppConfigurationClientGetRevisionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.getRevisionsHandleResponse(resp)
		},
	})
}

// getRevisionsCreateRequest creates the GetRevisions request.
func (client *AzureAppConfigurationClient) getRevisionsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientGetRevisionsOptions) (*policy.Request, error) {
	urlPath := "/revisions"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Key != nil {
		reqQP.Set("key", *options.Key)
	}
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kvset+json, application/json, application/problem+json"}
	return req, nil
}

// getRevisionsHandleResponse handles the GetRevisions response.
func (client *AzureAppConfigurationClient) getRevisionsHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetRevisionsResponse, error) {
	result := AzureAppConfigurationClientGetRevisionsResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValueListResult); err != nil {
		return AzureAppConfigurationClientGetRevisionsResponse{}, err
	}
	return result, nil
}

// PutKeyValue - Creates a key-value.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// key - The key of the key-value to create.
// entity - The key-value to create.
// options - AzureAppConfigurationClientPutKeyValueOptions contains the optional parameters for the AzureAppConfigurationClient.PutKeyValue
// method.
func (client *AzureAppConfigurationClient) PutKeyValue(ctx context.Context, key string, entity KeyValue, options *AzureAppConfigurationClientPutKeyValueOptions) (AzureAppConfigurationClientPutKeyValueResponse, error) {
	req, err := client.putKeyValueCreateRequest(ctx, key, entity, options)
	if err != nil {
		return AzureAppConfigurationClientPutKeyValueResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientPutKeyValueResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureAppConfigurationClientPutKeyValueResponse{}, runtime.NewResponseError(resp)
	}
	return client.putKeyValueHandleResponse(resp)
}

// putKeyValueCreateRequest creates the PutKeyValue request.
func (client *AzureAppConfigurationClient) putKeyValueCreateRequest(ctx context.Context, key string, entity KeyValue, options *AzureAppConfigurationClientPutKeyValueOptions) (*policy.Request, error) {
	urlPath := "/kv/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"}
	return req, runtime.MarshalAsJSON(req, entity)
}

// putKeyValueHandleResponse handles the PutKeyValue response.
func (client *AzureAppConfigurationClient) putKeyValueHandleResponse(resp *http.Response) (AzureAppConfigurationClientPutKeyValueResponse, error) {
	result := AzureAppConfigurationClientPutKeyValueResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientPutKeyValueResponse{}, err
	}
	return result, nil
}

// PutLock - Locks a key-value.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 1.0
// key - The key of the key-value to lock.
// options - AzureAppConfigurationClientPutLockOptions contains the optional parameters for the AzureAppConfigurationClient.PutLock
// method.
func (client *AzureAppConfigurationClient) PutLock(ctx context.Context, key string, options *AzureAppConfigurationClientPutLockOptions) (AzureAppConfigurationClientPutLockResponse, error) {
	req, err := client.putLockCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientPutLockResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureAppConfigurationClientPutLockResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureAppConfigurationClientPutLockResponse{}, runtime.NewResponseError(resp)
	}
	return client.putLockHandleResponse(resp)
}

// putLockCreateRequest creates the PutLock request.
func (client *AzureAppConfigurationClient) putLockCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientPutLockOptions) (*policy.Request, error) {
	urlPath := "/locks/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "1.0")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"}
	return req, nil
}

// putLockHandleResponse handles the PutLock response.
func (client *AzureAppConfigurationClient) putLockHandleResponse(resp *http.Response) (AzureAppConfigurationClientPutLockResponse, error) {
	result := AzureAppConfigurationClientPutLockResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientPutLockResponse{}, err
	}
	return result, nil
}
