// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/security/privateca/v1/resources.proto

package privatecapb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	expr "google.golang.org/genproto/googleapis/type/expr"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A [RevocationReason][google.cloud.security.privateca.v1.RevocationReason]
// indicates whether a
// [Certificate][google.cloud.security.privateca.v1.Certificate] has been
// revoked, and the reason for revocation. These correspond to standard
// revocation reasons from RFC 5280. Note that the enum labels and values in
// this definition are not the same ASN.1 values defined in RFC 5280. These
// values will be translated to the correct ASN.1 values when a CRL is created.
type RevocationReason int32

const (
	// Default unspecified value. This value does indicate that a
	// [Certificate][google.cloud.security.privateca.v1.Certificate] has been
	// revoked, but that a reason has not been recorded.
	RevocationReason_REVOCATION_REASON_UNSPECIFIED RevocationReason = 0
	// Key material for this
	// [Certificate][google.cloud.security.privateca.v1.Certificate] may have
	// leaked.
	RevocationReason_KEY_COMPROMISE RevocationReason = 1
	// The key material for a certificate authority in the issuing path may have
	// leaked.
	RevocationReason_CERTIFICATE_AUTHORITY_COMPROMISE RevocationReason = 2
	// The subject or other attributes in this
	// [Certificate][google.cloud.security.privateca.v1.Certificate] have changed.
	RevocationReason_AFFILIATION_CHANGED RevocationReason = 3
	// This [Certificate][google.cloud.security.privateca.v1.Certificate] has been
	// superseded.
	RevocationReason_SUPERSEDED RevocationReason = 4
	// This [Certificate][google.cloud.security.privateca.v1.Certificate] or
	// entities in the issuing path have ceased to operate.
	RevocationReason_CESSATION_OF_OPERATION RevocationReason = 5
	// This [Certificate][google.cloud.security.privateca.v1.Certificate] should
	// not be considered valid, it is expected that it may become valid in the
	// future.
	RevocationReason_CERTIFICATE_HOLD RevocationReason = 6
	// This [Certificate][google.cloud.security.privateca.v1.Certificate] no
	// longer has permission to assert the listed attributes.
	RevocationReason_PRIVILEGE_WITHDRAWN RevocationReason = 7
	// The authority which determines appropriate attributes for a
	// [Certificate][google.cloud.security.privateca.v1.Certificate] may have been
	// compromised.
	RevocationReason_ATTRIBUTE_AUTHORITY_COMPROMISE RevocationReason = 8
)

// Enum value maps for RevocationReason.
var (
	RevocationReason_name = map[int32]string{
		0: "REVOCATION_REASON_UNSPECIFIED",
		1: "KEY_COMPROMISE",
		2: "CERTIFICATE_AUTHORITY_COMPROMISE",
		3: "AFFILIATION_CHANGED",
		4: "SUPERSEDED",
		5: "CESSATION_OF_OPERATION",
		6: "CERTIFICATE_HOLD",
		7: "PRIVILEGE_WITHDRAWN",
		8: "ATTRIBUTE_AUTHORITY_COMPROMISE",
	}
	RevocationReason_value = map[string]int32{
		"REVOCATION_REASON_UNSPECIFIED":    0,
		"KEY_COMPROMISE":                   1,
		"CERTIFICATE_AUTHORITY_COMPROMISE": 2,
		"AFFILIATION_CHANGED":              3,
		"SUPERSEDED":                       4,
		"CESSATION_OF_OPERATION":           5,
		"CERTIFICATE_HOLD":                 6,
		"PRIVILEGE_WITHDRAWN":              7,
		"ATTRIBUTE_AUTHORITY_COMPROMISE":   8,
	}
)

func (x RevocationReason) Enum() *RevocationReason {
	p := new(RevocationReason)
	*p = x
	return p
}

func (x RevocationReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RevocationReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[0].Descriptor()
}

func (RevocationReason) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[0]
}

func (x RevocationReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RevocationReason.Descriptor instead.
func (RevocationReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{0}
}

// Describes the way in which a
// [Certificate][google.cloud.security.privateca.v1.Certificate]'s
// [Subject][google.cloud.security.privateca.v1.Subject] and/or
// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames] will be
// resolved.
type SubjectRequestMode int32

const (
	// Not specified.
	SubjectRequestMode_SUBJECT_REQUEST_MODE_UNSPECIFIED SubjectRequestMode = 0
	// The default mode used in most cases. Indicates that the certificate's
	// [Subject][google.cloud.security.privateca.v1.Subject] and/or
	// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames] are
	// specified in the certificate request. This mode requires the caller to have
	// the `privateca.certificates.create` permission.
	SubjectRequestMode_DEFAULT SubjectRequestMode = 1
	// A mode reserved for special cases. Indicates that the certificate should
	// have one SPIFFE
	// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames] set
	// by the service based on the caller's identity. This mode will ignore any
	// explicitly specified [Subject][google.cloud.security.privateca.v1.Subject]
	// and/or
	// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames] in
	// the certificate request. This mode requires the caller to have the
	// `privateca.certificates.createForSelf` permission.
	SubjectRequestMode_REFLECTED_SPIFFE SubjectRequestMode = 2
)

// Enum value maps for SubjectRequestMode.
var (
	SubjectRequestMode_name = map[int32]string{
		0: "SUBJECT_REQUEST_MODE_UNSPECIFIED",
		1: "DEFAULT",
		2: "REFLECTED_SPIFFE",
	}
	SubjectRequestMode_value = map[string]int32{
		"SUBJECT_REQUEST_MODE_UNSPECIFIED": 0,
		"DEFAULT":                          1,
		"REFLECTED_SPIFFE":                 2,
	}
)

func (x SubjectRequestMode) Enum() *SubjectRequestMode {
	p := new(SubjectRequestMode)
	*p = x
	return p
}

func (x SubjectRequestMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubjectRequestMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[1].Descriptor()
}

func (SubjectRequestMode) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[1]
}

func (x SubjectRequestMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubjectRequestMode.Descriptor instead.
func (SubjectRequestMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1}
}

// The type of a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority],
// indicating its issuing chain.
type CertificateAuthority_Type int32

const (
	// Not specified.
	CertificateAuthority_TYPE_UNSPECIFIED CertificateAuthority_Type = 0
	// Self-signed CA.
	CertificateAuthority_SELF_SIGNED CertificateAuthority_Type = 1
	// Subordinate CA. Could be issued by a Private CA
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// or an unmanaged CA.
	CertificateAuthority_SUBORDINATE CertificateAuthority_Type = 2
)

// Enum value maps for CertificateAuthority_Type.
var (
	CertificateAuthority_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SELF_SIGNED",
		2: "SUBORDINATE",
	}
	CertificateAuthority_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SELF_SIGNED":      1,
		"SUBORDINATE":      2,
	}
)

func (x CertificateAuthority_Type) Enum() *CertificateAuthority_Type {
	p := new(CertificateAuthority_Type)
	*p = x
	return p
}

func (x CertificateAuthority_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateAuthority_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[2].Descriptor()
}

func (CertificateAuthority_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[2]
}

func (x CertificateAuthority_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateAuthority_Type.Descriptor instead.
func (CertificateAuthority_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

// The state of a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority],
// indicating if it can be used.
type CertificateAuthority_State int32

const (
	// Not specified.
	CertificateAuthority_STATE_UNSPECIFIED CertificateAuthority_State = 0
	// Certificates can be issued from this CA. CRLs will be generated for this
	// CA. The CA will be part of the
	// [CaPool][google.cloud.security.privateca.v1.CaPool]'s trust anchor, and
	// will be used to issue certificates from the
	// [CaPool][google.cloud.security.privateca.v1.CaPool].
	CertificateAuthority_ENABLED CertificateAuthority_State = 1
	// Certificates cannot be issued from this CA. CRLs will still be generated.
	// The CA will be part of the
	// [CaPool][google.cloud.security.privateca.v1.CaPool]'s trust anchor, but
	// will not be used to issue certificates from the
	// [CaPool][google.cloud.security.privateca.v1.CaPool].
	CertificateAuthority_DISABLED CertificateAuthority_State = 2
	// Certificates can be issued from this CA. CRLs will be generated for this
	// CA. The CA will be part of the
	// [CaPool][google.cloud.security.privateca.v1.CaPool]'s trust anchor, but
	// will not be used to issue certificates from the
	// [CaPool][google.cloud.security.privateca.v1.CaPool].
	CertificateAuthority_STAGED CertificateAuthority_State = 3
	// Certificates cannot be issued from this CA. CRLs will not be generated.
	// The CA will not be part of the
	// [CaPool][google.cloud.security.privateca.v1.CaPool]'s trust anchor, and
	// will not be used to issue certificates from the
	// [CaPool][google.cloud.security.privateca.v1.CaPool].
	CertificateAuthority_AWAITING_USER_ACTIVATION CertificateAuthority_State = 4
	// Certificates cannot be issued from this CA. CRLs will not be generated.
	// The CA may still be recovered by calling
	// [CertificateAuthorityService.UndeleteCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.UndeleteCertificateAuthority]
	// before
	// [expire_time][google.cloud.security.privateca.v1.CertificateAuthority.expire_time].
	// The CA will not be part of the
	// [CaPool][google.cloud.security.privateca.v1.CaPool]'s trust anchor, and
	// will not be used to issue certificates from the
	// [CaPool][google.cloud.security.privateca.v1.CaPool].
	CertificateAuthority_DELETED CertificateAuthority_State = 5
)

// Enum value maps for CertificateAuthority_State.
var (
	CertificateAuthority_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "STAGED",
		4: "AWAITING_USER_ACTIVATION",
		5: "DELETED",
	}
	CertificateAuthority_State_value = map[string]int32{
		"STATE_UNSPECIFIED":        0,
		"ENABLED":                  1,
		"DISABLED":                 2,
		"STAGED":                   3,
		"AWAITING_USER_ACTIVATION": 4,
		"DELETED":                  5,
	}
)

func (x CertificateAuthority_State) Enum() *CertificateAuthority_State {
	p := new(CertificateAuthority_State)
	*p = x
	return p
}

func (x CertificateAuthority_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateAuthority_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[3].Descriptor()
}

func (CertificateAuthority_State) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[3]
}

func (x CertificateAuthority_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateAuthority_State.Descriptor instead.
func (CertificateAuthority_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{0, 1}
}

// The algorithm of a Cloud KMS CryptoKeyVersion of a
// [CryptoKey][google.cloud.kms.v1.CryptoKey] with the
// [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose] value
// `ASYMMETRIC_SIGN`. These values correspond to the
// [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
// values. For RSA signing algorithms, the PSS algorithms should be preferred,
// use PKCS1 algorithms if required for compatibility. For further
// recommendations, see
// https://cloud.google.com/kms/docs/algorithms#algorithm_recommendations.
type CertificateAuthority_SignHashAlgorithm int32

const (
	// Not specified.
	CertificateAuthority_SIGN_HASH_ALGORITHM_UNSPECIFIED CertificateAuthority_SignHashAlgorithm = 0
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256
	CertificateAuthority_RSA_PSS_2048_SHA256 CertificateAuthority_SignHashAlgorithm = 1
	// maps to CryptoKeyVersionAlgorithm. RSA_SIGN_PSS_3072_SHA256
	CertificateAuthority_RSA_PSS_3072_SHA256 CertificateAuthority_SignHashAlgorithm = 2
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_4096_SHA256
	CertificateAuthority_RSA_PSS_4096_SHA256 CertificateAuthority_SignHashAlgorithm = 3
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_2048_SHA256
	CertificateAuthority_RSA_PKCS1_2048_SHA256 CertificateAuthority_SignHashAlgorithm = 6
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_3072_SHA256
	CertificateAuthority_RSA_PKCS1_3072_SHA256 CertificateAuthority_SignHashAlgorithm = 7
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_4096_SHA256
	CertificateAuthority_RSA_PKCS1_4096_SHA256 CertificateAuthority_SignHashAlgorithm = 8
	// maps to CryptoKeyVersionAlgorithm.EC_SIGN_P256_SHA256
	CertificateAuthority_EC_P256_SHA256 CertificateAuthority_SignHashAlgorithm = 4
	// maps to CryptoKeyVersionAlgorithm.EC_SIGN_P384_SHA384
	CertificateAuthority_EC_P384_SHA384 CertificateAuthority_SignHashAlgorithm = 5
)

// Enum value maps for CertificateAuthority_SignHashAlgorithm.
var (
	CertificateAuthority_SignHashAlgorithm_name = map[int32]string{
		0: "SIGN_HASH_ALGORITHM_UNSPECIFIED",
		1: "RSA_PSS_2048_SHA256",
		2: "RSA_PSS_3072_SHA256",
		3: "RSA_PSS_4096_SHA256",
		6: "RSA_PKCS1_2048_SHA256",
		7: "RSA_PKCS1_3072_SHA256",
		8: "RSA_PKCS1_4096_SHA256",
		4: "EC_P256_SHA256",
		5: "EC_P384_SHA384",
	}
	CertificateAuthority_SignHashAlgorithm_value = map[string]int32{
		"SIGN_HASH_ALGORITHM_UNSPECIFIED": 0,
		"RSA_PSS_2048_SHA256":             1,
		"RSA_PSS_3072_SHA256":             2,
		"RSA_PSS_4096_SHA256":             3,
		"RSA_PKCS1_2048_SHA256":           6,
		"RSA_PKCS1_3072_SHA256":           7,
		"RSA_PKCS1_4096_SHA256":           8,
		"EC_P256_SHA256":                  4,
		"EC_P384_SHA384":                  5,
	}
)

func (x CertificateAuthority_SignHashAlgorithm) Enum() *CertificateAuthority_SignHashAlgorithm {
	p := new(CertificateAuthority_SignHashAlgorithm)
	*p = x
	return p
}

func (x CertificateAuthority_SignHashAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateAuthority_SignHashAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[4].Descriptor()
}

func (CertificateAuthority_SignHashAlgorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[4]
}

func (x CertificateAuthority_SignHashAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateAuthority_SignHashAlgorithm.Descriptor instead.
func (CertificateAuthority_SignHashAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{0, 2}
}

// The tier of a [CaPool][google.cloud.security.privateca.v1.CaPool],
// indicating its supported functionality and/or billing SKU.
type CaPool_Tier int32

const (
	// Not specified.
	CaPool_TIER_UNSPECIFIED CaPool_Tier = 0
	// Enterprise tier.
	CaPool_ENTERPRISE CaPool_Tier = 1
	// DevOps tier.
	CaPool_DEVOPS CaPool_Tier = 2
)

// Enum value maps for CaPool_Tier.
var (
	CaPool_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "ENTERPRISE",
		2: "DEVOPS",
	}
	CaPool_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED": 0,
		"ENTERPRISE":       1,
		"DEVOPS":           2,
	}
)

func (x CaPool_Tier) Enum() *CaPool_Tier {
	p := new(CaPool_Tier)
	*p = x
	return p
}

func (x CaPool_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CaPool_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[5].Descriptor()
}

func (CaPool_Tier) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[5]
}

func (x CaPool_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CaPool_Tier.Descriptor instead.
func (CaPool_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

// Describes an elliptic curve-based signature algorithm that may be
// used in a
// [Certificate][google.cloud.security.privateca.v1.Certificate] issued
// from a [CaPool][google.cloud.security.privateca.v1.CaPool].
type CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm int32

const (
	// Not specified. Signifies that any signature algorithm may be used.
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EC_SIGNATURE_ALGORITHM_UNSPECIFIED CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm = 0
	// Refers to the Elliptic Curve Digital Signature Algorithm over the
	// NIST P-256 curve.
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_ECDSA_P256 CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm = 1
	// Refers to the Elliptic Curve Digital Signature Algorithm over the
	// NIST P-384 curve.
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_ECDSA_P384 CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm = 2
	// Refers to the Edwards-curve Digital Signature Algorithm over curve
	// 25519, as described in RFC 8410.
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EDDSA_25519 CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm = 3
)

// Enum value maps for CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm.
var (
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm_name = map[int32]string{
		0: "EC_SIGNATURE_ALGORITHM_UNSPECIFIED",
		1: "ECDSA_P256",
		2: "ECDSA_P384",
		3: "EDDSA_25519",
	}
	CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm_value = map[string]int32{
		"EC_SIGNATURE_ALGORITHM_UNSPECIFIED": 0,
		"ECDSA_P256":                         1,
		"ECDSA_P384":                         2,
		"EDDSA_25519":                        3,
	}
)

func (x CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm) Enum() *CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm {
	p := new(CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm)
	*p = x
	return p
}

func (x CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[6].Descriptor()
}

func (CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[6]
}

func (x CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm.Descriptor instead.
func (CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1, 1, 0, 1, 0}
}

// The state of a
// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList],
// indicating if it is current.
type CertificateRevocationList_State int32

const (
	// Not specified.
	CertificateRevocationList_STATE_UNSPECIFIED CertificateRevocationList_State = 0
	// The
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList]
	// is up to date.
	CertificateRevocationList_ACTIVE CertificateRevocationList_State = 1
	// The
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList]
	// is no longer current.
	CertificateRevocationList_SUPERSEDED CertificateRevocationList_State = 2
)

// Enum value maps for CertificateRevocationList_State.
var (
	CertificateRevocationList_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "SUPERSEDED",
	}
	CertificateRevocationList_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"SUPERSEDED":        2,
	}
)

func (x CertificateRevocationList_State) Enum() *CertificateRevocationList_State {
	p := new(CertificateRevocationList_State)
	*p = x
	return p
}

func (x CertificateRevocationList_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateRevocationList_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[7].Descriptor()
}

func (CertificateRevocationList_State) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[7]
}

func (x CertificateRevocationList_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateRevocationList_State.Descriptor instead.
func (CertificateRevocationList_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{2, 0}
}

// Types of public keys formats that are supported. Currently, only `PEM`
// format is supported.
type PublicKey_KeyFormat int32

const (
	// Default unspecified value.
	PublicKey_KEY_FORMAT_UNSPECIFIED PublicKey_KeyFormat = 0
	// The key is PEM-encoded as defined in [RFC
	// 7468](https://tools.ietf.org/html/rfc7468). It can be any of the
	// following: a PEM-encoded PKCS#1/RFC 3447 RSAPublicKey
	// structure, an RFC 5280
	// [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1)
	// or a PEM-encoded X.509 certificate signing request (CSR). If a
	// [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1)
	// is specified, it can contain a A PEM-encoded PKCS#1/RFC 3447 RSAPublicKey
	// or a NIST P-256/secp256r1/prime256v1 or P-384 key. If a CSR is specified,
	// it will used solely for the purpose of extracting the public key. When
	// generated by the service, it will always be an RFC 5280
	// [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1)
	// structure containing an algorithm identifier and a key.
	PublicKey_PEM PublicKey_KeyFormat = 1
)

// Enum value maps for PublicKey_KeyFormat.
var (
	PublicKey_KeyFormat_name = map[int32]string{
		0: "KEY_FORMAT_UNSPECIFIED",
		1: "PEM",
	}
	PublicKey_KeyFormat_value = map[string]int32{
		"KEY_FORMAT_UNSPECIFIED": 0,
		"PEM":                    1,
	}
)

func (x PublicKey_KeyFormat) Enum() *PublicKey_KeyFormat {
	p := new(PublicKey_KeyFormat)
	*p = x
	return p
}

func (x PublicKey_KeyFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicKey_KeyFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[8].Descriptor()
}

func (PublicKey_KeyFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[8]
}

func (x PublicKey_KeyFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicKey_KeyFormat.Descriptor instead.
func (PublicKey_KeyFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{7, 0}
}

// Describes well-known X.509 extensions that can appear in a
// [Certificate][google.cloud.security.privateca.v1.Certificate], not
// including the
// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames]
// extension.
type CertificateExtensionConstraints_KnownCertificateExtension int32

const (
	// Not specified.
	CertificateExtensionConstraints_KNOWN_CERTIFICATE_EXTENSION_UNSPECIFIED CertificateExtensionConstraints_KnownCertificateExtension = 0
	// Refers to a certificate's Key Usage extension, as described in [RFC 5280
	// section 4.2.1.3](https://tools.ietf.org/html/rfc5280#section-4.2.1.3).
	// This corresponds to the
	// [KeyUsage.base_key_usage][google.cloud.security.privateca.v1.KeyUsage.base_key_usage]
	// field.
	CertificateExtensionConstraints_BASE_KEY_USAGE CertificateExtensionConstraints_KnownCertificateExtension = 1
	// Refers to a certificate's Extended Key Usage extension, as described in
	// [RFC 5280
	// section 4.2.1.12](https://tools.ietf.org/html/rfc5280#section-4.2.1.12).
	// This corresponds to the
	// [KeyUsage.extended_key_usage][google.cloud.security.privateca.v1.KeyUsage.extended_key_usage]
	// message.
	CertificateExtensionConstraints_EXTENDED_KEY_USAGE CertificateExtensionConstraints_KnownCertificateExtension = 2
	// Refers to a certificate's Basic Constraints extension, as described in
	// [RFC 5280
	// section 4.2.1.9](https://tools.ietf.org/html/rfc5280#section-4.2.1.9).
	// This corresponds to the
	// [X509Parameters.ca_options][google.cloud.security.privateca.v1.X509Parameters.ca_options]
	// field.
	CertificateExtensionConstraints_CA_OPTIONS CertificateExtensionConstraints_KnownCertificateExtension = 3
	// Refers to a certificate's Policy object identifiers, as described in
	// [RFC 5280
	// section 4.2.1.4](https://tools.ietf.org/html/rfc5280#section-4.2.1.4).
	// This corresponds to the
	// [X509Parameters.policy_ids][google.cloud.security.privateca.v1.X509Parameters.policy_ids]
	// field.
	CertificateExtensionConstraints_POLICY_IDS CertificateExtensionConstraints_KnownCertificateExtension = 4
	// Refers to OCSP servers in a certificate's Authority Information Access
	// extension, as described in
	// [RFC 5280
	// section 4.2.2.1](https://tools.ietf.org/html/rfc5280#section-4.2.2.1),
	// This corresponds to the
	// [X509Parameters.aia_ocsp_servers][google.cloud.security.privateca.v1.X509Parameters.aia_ocsp_servers]
	// field.
	CertificateExtensionConstraints_AIA_OCSP_SERVERS CertificateExtensionConstraints_KnownCertificateExtension = 5
	// Refers to Name Constraints extension as described in
	// [RFC 5280
	// section 4.2.1.10](https://tools.ietf.org/html/rfc5280#section-4.2.1.10)
	CertificateExtensionConstraints_NAME_CONSTRAINTS CertificateExtensionConstraints_KnownCertificateExtension = 6
)

// Enum value maps for CertificateExtensionConstraints_KnownCertificateExtension.
var (
	CertificateExtensionConstraints_KnownCertificateExtension_name = map[int32]string{
		0: "KNOWN_CERTIFICATE_EXTENSION_UNSPECIFIED",
		1: "BASE_KEY_USAGE",
		2: "EXTENDED_KEY_USAGE",
		3: "CA_OPTIONS",
		4: "POLICY_IDS",
		5: "AIA_OCSP_SERVERS",
		6: "NAME_CONSTRAINTS",
	}
	CertificateExtensionConstraints_KnownCertificateExtension_value = map[string]int32{
		"KNOWN_CERTIFICATE_EXTENSION_UNSPECIFIED": 0,
		"BASE_KEY_USAGE":     1,
		"EXTENDED_KEY_USAGE": 2,
		"CA_OPTIONS":         3,
		"POLICY_IDS":         4,
		"AIA_OCSP_SERVERS":   5,
		"NAME_CONSTRAINTS":   6,
	}
)

func (x CertificateExtensionConstraints_KnownCertificateExtension) Enum() *CertificateExtensionConstraints_KnownCertificateExtension {
	p := new(CertificateExtensionConstraints_KnownCertificateExtension)
	*p = x
	return p
}

func (x CertificateExtensionConstraints_KnownCertificateExtension) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateExtensionConstraints_KnownCertificateExtension) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1_resources_proto_enumTypes[9].Descriptor()
}

func (CertificateExtensionConstraints_KnownCertificateExtension) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1_resources_proto_enumTypes[9]
}

func (x CertificateExtensionConstraints_KnownCertificateExtension) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateExtensionConstraints_KnownCertificateExtension.Descriptor instead.
func (CertificateExtensionConstraints_KnownCertificateExtension) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{16, 0}
}

// A
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// represents an individual Certificate Authority. A
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// can be used to create
// [Certificates][google.cloud.security.privateca.v1.Certificate].
type CertificateAuthority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The
	// [Type][google.cloud.security.privateca.v1.CertificateAuthority.Type] of
	// this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	Type CertificateAuthority_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.security.privateca.v1.CertificateAuthority_Type" json:"type,omitempty"`
	// Required. Immutable. The config used to create a self-signed X.509
	// certificate or CSR.
	Config *CertificateConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	// Required. Immutable. The desired lifetime of the CA certificate. Used to
	// create the "not_before_time" and "not_after_time" fields inside an X.509
	// certificate.
	Lifetime *durationpb.Duration `protobuf:"bytes,4,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// Required. Immutable. Used when issuing certificates for this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	// If this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// is a self-signed CertificateAuthority, this key is also used to sign the
	// self-signed CA certificate. Otherwise, it is used to sign a CSR.
	KeySpec *CertificateAuthority_KeyVersionSpec `protobuf:"bytes,5,opt,name=key_spec,json=keySpec,proto3" json:"key_spec,omitempty"`
	// Optional. If this is a subordinate
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority],
	// this field will be set with the subordinate configuration, which describes
	// its issuers. This may be updated, but this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// must continue to validate.
	SubordinateConfig *SubordinateConfig `protobuf:"bytes,6,opt,name=subordinate_config,json=subordinateConfig,proto3" json:"subordinate_config,omitempty"`
	// Output only. The
	// [CaPool.Tier][google.cloud.security.privateca.v1.CaPool.Tier] of the
	// [CaPool][google.cloud.security.privateca.v1.CaPool] that includes this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	Tier CaPool_Tier `protobuf:"varint,7,opt,name=tier,proto3,enum=google.cloud.security.privateca.v1.CaPool_Tier" json:"tier,omitempty"`
	// Output only. The
	// [State][google.cloud.security.privateca.v1.CertificateAuthority.State] for
	// this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	State CertificateAuthority_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.security.privateca.v1.CertificateAuthority_State" json:"state,omitempty"`
	// Output only. This
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
	// certificate chain, including the current
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
	// certificate. Ordered such that the root issuer is the final element
	// (consistent with RFC 5246). For a self-signed CA, this will only list the
	// current
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
	// certificate.
	PemCaCertificates []string `protobuf:"bytes,9,rep,name=pem_ca_certificates,json=pemCaCertificates,proto3" json:"pem_ca_certificates,omitempty"`
	// Output only. A structured description of this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
	// CA certificate and its issuers. Ordered as self-to-root.
	CaCertificateDescriptions []*CertificateDescription `protobuf:"bytes,10,rep,name=ca_certificate_descriptions,json=caCertificateDescriptions,proto3" json:"ca_certificate_descriptions,omitempty"`
	// Immutable. The name of a Cloud Storage bucket where this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// will publish content, such as the CA certificate and CRLs. This must be a
	// bucket name, without any prefixes (such as `gs://`) or suffixes (such as
	// `.googleapis.com`). For example, to use a bucket named `my-bucket`, you
	// would simply specify `my-bucket`. If not specified, a managed bucket will
	// be created.
	GcsBucket string `protobuf:"bytes,11,opt,name=gcs_bucket,json=gcsBucket,proto3" json:"gcs_bucket,omitempty"`
	// Output only. URLs for accessing content published by this CA, such as the
	// CA certificate and CRLs.
	AccessUrls *CertificateAuthority_AccessUrls `protobuf:"bytes,12,opt,name=access_urls,json=accessUrls,proto3" json:"access_urls,omitempty"`
	// Output only. The time at which this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The time at which this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// was soft deleted, if it is in the
	// [DELETED][google.cloud.security.privateca.v1.CertificateAuthority.State.DELETED]
	// state.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. The time at which this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// will be permanently purged, if it is in the
	// [DELETED][google.cloud.security.privateca.v1.CertificateAuthority.State.DELETED]
	// state.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Optional. Labels with user-defined metadata.
	Labels map[string]string `protobuf:"bytes,17,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CertificateAuthority) Reset() {
	*x = CertificateAuthority{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority) ProtoMessage() {}

func (x *CertificateAuthority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority.ProtoReflect.Descriptor instead.
func (*CertificateAuthority) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *CertificateAuthority) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CertificateAuthority) GetType() CertificateAuthority_Type {
	if x != nil {
		return x.Type
	}
	return CertificateAuthority_TYPE_UNSPECIFIED
}

func (x *CertificateAuthority) GetConfig() *CertificateConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *CertificateAuthority) GetLifetime() *durationpb.Duration {
	if x != nil {
		return x.Lifetime
	}
	return nil
}

func (x *CertificateAuthority) GetKeySpec() *CertificateAuthority_KeyVersionSpec {
	if x != nil {
		return x.KeySpec
	}
	return nil
}

func (x *CertificateAuthority) GetSubordinateConfig() *SubordinateConfig {
	if x != nil {
		return x.SubordinateConfig
	}
	return nil
}

func (x *CertificateAuthority) GetTier() CaPool_Tier {
	if x != nil {
		return x.Tier
	}
	return CaPool_TIER_UNSPECIFIED
}

func (x *CertificateAuthority) GetState() CertificateAuthority_State {
	if x != nil {
		return x.State
	}
	return CertificateAuthority_STATE_UNSPECIFIED
}

func (x *CertificateAuthority) GetPemCaCertificates() []string {
	if x != nil {
		return x.PemCaCertificates
	}
	return nil
}

func (x *CertificateAuthority) GetCaCertificateDescriptions() []*CertificateDescription {
	if x != nil {
		return x.CaCertificateDescriptions
	}
	return nil
}

func (x *CertificateAuthority) GetGcsBucket() string {
	if x != nil {
		return x.GcsBucket
	}
	return ""
}

func (x *CertificateAuthority) GetAccessUrls() *CertificateAuthority_AccessUrls {
	if x != nil {
		return x.AccessUrls
	}
	return nil
}

func (x *CertificateAuthority) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CertificateAuthority) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CertificateAuthority) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *CertificateAuthority) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *CertificateAuthority) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// A [CaPool][google.cloud.security.privateca.v1.CaPool] represents a group of
// [CertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthority]
// that form a trust anchor. A
// [CaPool][google.cloud.security.privateca.v1.CaPool] can be used to manage
// issuance policies for one or more
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// resources and to rotate CA certificates in and out of the trust anchor.
type CaPool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this
	// [CaPool][google.cloud.security.privateca.v1.CaPool] in the format
	// `projects/*/locations/*/caPools/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The
	// [Tier][google.cloud.security.privateca.v1.CaPool.Tier] of this
	// [CaPool][google.cloud.security.privateca.v1.CaPool].
	Tier CaPool_Tier `protobuf:"varint,2,opt,name=tier,proto3,enum=google.cloud.security.privateca.v1.CaPool_Tier" json:"tier,omitempty"`
	// Optional. The
	// [IssuancePolicy][google.cloud.security.privateca.v1.CaPool.IssuancePolicy]
	// to control how
	// [Certificates][google.cloud.security.privateca.v1.Certificate] will be
	// issued from this [CaPool][google.cloud.security.privateca.v1.CaPool].
	IssuancePolicy *CaPool_IssuancePolicy `protobuf:"bytes,3,opt,name=issuance_policy,json=issuancePolicy,proto3" json:"issuance_policy,omitempty"`
	// Optional. The
	// [PublishingOptions][google.cloud.security.privateca.v1.CaPool.PublishingOptions]
	// to follow when issuing
	// [Certificates][google.cloud.security.privateca.v1.Certificate] from any
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// in this [CaPool][google.cloud.security.privateca.v1.CaPool].
	PublishingOptions *CaPool_PublishingOptions `protobuf:"bytes,4,opt,name=publishing_options,json=publishingOptions,proto3" json:"publishing_options,omitempty"`
	// Optional. Labels with user-defined metadata.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CaPool) Reset() {
	*x = CaPool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CaPool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CaPool) ProtoMessage() {}

func (x *CaPool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CaPool.ProtoReflect.Descriptor instead.
func (*CaPool) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *CaPool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CaPool) GetTier() CaPool_Tier {
	if x != nil {
		return x.Tier
	}
	return CaPool_TIER_UNSPECIFIED
}

func (x *CaPool) GetIssuancePolicy() *CaPool_IssuancePolicy {
	if x != nil {
		return x.IssuancePolicy
	}
	return nil
}

func (x *CaPool) GetPublishingOptions() *CaPool_PublishingOptions {
	if x != nil {
		return x.PublishingOptions
	}
	return nil
}

func (x *CaPool) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// A
// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList]
// corresponds to a signed X.509 certificate Revocation List (CRL). A CRL
// contains the serial numbers of certificates that should no longer be trusted.
type CertificateRevocationList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList]
	// in the format `projects/*/locations/*/caPools/*certificateAuthorities/*/
	//
	//	certificateRevocationLists/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The CRL sequence number that appears in pem_crl.
	SequenceNumber int64 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
	// Output only. The revoked serial numbers that appear in pem_crl.
	RevokedCertificates []*CertificateRevocationList_RevokedCertificate `protobuf:"bytes,3,rep,name=revoked_certificates,json=revokedCertificates,proto3" json:"revoked_certificates,omitempty"`
	// Output only. The PEM-encoded X.509 CRL.
	PemCrl string `protobuf:"bytes,4,opt,name=pem_crl,json=pemCrl,proto3" json:"pem_crl,omitempty"`
	// Output only. The location where 'pem_crl' can be accessed.
	AccessUrl string `protobuf:"bytes,5,opt,name=access_url,json=accessUrl,proto3" json:"access_url,omitempty"`
	// Output only. The
	// [State][google.cloud.security.privateca.v1.CertificateRevocationList.State]
	// for this
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
	State CertificateRevocationList_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.security.privateca.v1.CertificateRevocationList_State" json:"state,omitempty"`
	// Output only. The time at which this
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList]
	// was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList]
	// was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The revision ID of this
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
	// A new revision is committed whenever a new CRL is published. The format is
	// an 8-character hexadecimal string.
	RevisionId string `protobuf:"bytes,9,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// Optional. Labels with user-defined metadata.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CertificateRevocationList) Reset() {
	*x = CertificateRevocationList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateRevocationList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateRevocationList) ProtoMessage() {}

func (x *CertificateRevocationList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateRevocationList.ProtoReflect.Descriptor instead.
func (*CertificateRevocationList) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *CertificateRevocationList) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CertificateRevocationList) GetSequenceNumber() int64 {
	if x != nil {
		return x.SequenceNumber
	}
	return 0
}

func (x *CertificateRevocationList) GetRevokedCertificates() []*CertificateRevocationList_RevokedCertificate {
	if x != nil {
		return x.RevokedCertificates
	}
	return nil
}

func (x *CertificateRevocationList) GetPemCrl() string {
	if x != nil {
		return x.PemCrl
	}
	return ""
}

func (x *CertificateRevocationList) GetAccessUrl() string {
	if x != nil {
		return x.AccessUrl
	}
	return ""
}

func (x *CertificateRevocationList) GetState() CertificateRevocationList_State {
	if x != nil {
		return x.State
	}
	return CertificateRevocationList_STATE_UNSPECIFIED
}

func (x *CertificateRevocationList) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CertificateRevocationList) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CertificateRevocationList) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *CertificateRevocationList) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// A [Certificate][google.cloud.security.privateca.v1.Certificate] corresponds
// to a signed X.509 certificate issued by a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
type Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this
	// [Certificate][google.cloud.security.privateca.v1.Certificate] in the format
	// `projects/*/locations/*/caPools/*/certificates/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The config used to create a signed X.509 certificate.
	//
	// Types that are assignable to CertificateConfig:
	//
	//	*Certificate_PemCsr
	//	*Certificate_Config
	CertificateConfig isCertificate_CertificateConfig `protobuf_oneof:"certificate_config"`
	// Output only. The resource name of the issuing
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
	IssuerCertificateAuthority string `protobuf:"bytes,4,opt,name=issuer_certificate_authority,json=issuerCertificateAuthority,proto3" json:"issuer_certificate_authority,omitempty"`
	// Required. Immutable. The desired lifetime of a certificate. Used to create
	// the "not_before_time" and "not_after_time" fields inside an X.509
	// certificate. Note that the lifetime may be truncated if it would extend
	// past the life of any certificate authority in the issuing chain.
	Lifetime *durationpb.Duration `protobuf:"bytes,5,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// Immutable. The resource name for a
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
	// used to issue this certificate, in the format
	// `projects/*/locations/*/certificateTemplates/*`.
	// If this is specified, the caller must have the necessary permission to
	// use this template. If this is omitted, no template will be used.
	// This template must be in the same location as the
	// [Certificate][google.cloud.security.privateca.v1.Certificate].
	CertificateTemplate string `protobuf:"bytes,6,opt,name=certificate_template,json=certificateTemplate,proto3" json:"certificate_template,omitempty"`
	// Immutable. Specifies how the
	// [Certificate][google.cloud.security.privateca.v1.Certificate]'s identity
	// fields are to be decided. If this is omitted, the `DEFAULT` subject mode
	// will be used.
	SubjectMode SubjectRequestMode `protobuf:"varint,7,opt,name=subject_mode,json=subjectMode,proto3,enum=google.cloud.security.privateca.v1.SubjectRequestMode" json:"subject_mode,omitempty"`
	// Output only. Details regarding the revocation of this
	// [Certificate][google.cloud.security.privateca.v1.Certificate]. This
	// [Certificate][google.cloud.security.privateca.v1.Certificate] is considered
	// revoked if and only if this field is present.
	RevocationDetails *Certificate_RevocationDetails `protobuf:"bytes,8,opt,name=revocation_details,json=revocationDetails,proto3" json:"revocation_details,omitempty"`
	// Output only. The pem-encoded, signed X.509 certificate.
	PemCertificate string `protobuf:"bytes,9,opt,name=pem_certificate,json=pemCertificate,proto3" json:"pem_certificate,omitempty"`
	// Output only. A structured description of the issued X.509 certificate.
	CertificateDescription *CertificateDescription `protobuf:"bytes,10,opt,name=certificate_description,json=certificateDescription,proto3" json:"certificate_description,omitempty"`
	// Output only. The chain that may be used to verify the X.509 certificate.
	// Expected to be in issuer-to-root order according to RFC 5246.
	PemCertificateChain []string `protobuf:"bytes,11,rep,name=pem_certificate_chain,json=pemCertificateChain,proto3" json:"pem_certificate_chain,omitempty"`
	// Output only. The time at which this
	// [Certificate][google.cloud.security.privateca.v1.Certificate] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this
	// [Certificate][google.cloud.security.privateca.v1.Certificate] was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Labels with user-defined metadata.
	Labels map[string]string `protobuf:"bytes,14,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Certificate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Certificate) GetCertificateConfig() isCertificate_CertificateConfig {
	if m != nil {
		return m.CertificateConfig
	}
	return nil
}

func (x *Certificate) GetPemCsr() string {
	if x, ok := x.GetCertificateConfig().(*Certificate_PemCsr); ok {
		return x.PemCsr
	}
	return ""
}

func (x *Certificate) GetConfig() *CertificateConfig {
	if x, ok := x.GetCertificateConfig().(*Certificate_Config); ok {
		return x.Config
	}
	return nil
}

func (x *Certificate) GetIssuerCertificateAuthority() string {
	if x != nil {
		return x.IssuerCertificateAuthority
	}
	return ""
}

func (x *Certificate) GetLifetime() *durationpb.Duration {
	if x != nil {
		return x.Lifetime
	}
	return nil
}

func (x *Certificate) GetCertificateTemplate() string {
	if x != nil {
		return x.CertificateTemplate
	}
	return ""
}

func (x *Certificate) GetSubjectMode() SubjectRequestMode {
	if x != nil {
		return x.SubjectMode
	}
	return SubjectRequestMode_SUBJECT_REQUEST_MODE_UNSPECIFIED
}

func (x *Certificate) GetRevocationDetails() *Certificate_RevocationDetails {
	if x != nil {
		return x.RevocationDetails
	}
	return nil
}

func (x *Certificate) GetPemCertificate() string {
	if x != nil {
		return x.PemCertificate
	}
	return ""
}

func (x *Certificate) GetCertificateDescription() *CertificateDescription {
	if x != nil {
		return x.CertificateDescription
	}
	return nil
}

func (x *Certificate) GetPemCertificateChain() []string {
	if x != nil {
		return x.PemCertificateChain
	}
	return nil
}

func (x *Certificate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Certificate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Certificate) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isCertificate_CertificateConfig interface {
	isCertificate_CertificateConfig()
}

type Certificate_PemCsr struct {
	// Immutable. A pem-encoded X.509 certificate signing request (CSR).
	PemCsr string `protobuf:"bytes,2,opt,name=pem_csr,json=pemCsr,proto3,oneof"`
}

type Certificate_Config struct {
	// Immutable. A description of the certificate and key that does not require
	// X.509 or ASN.1.
	Config *CertificateConfig `protobuf:"bytes,3,opt,name=config,proto3,oneof"`
}

func (*Certificate_PemCsr) isCertificate_CertificateConfig() {}

func (*Certificate_Config) isCertificate_CertificateConfig() {}

// A
// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
// refers to a managed template for certificate issuance.
type CertificateTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
	// in the format `projects/*/locations/*/certificateTemplates/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The maximum lifetime allowed for issued
	// [Certificates][google.cloud.security.privateca.v1.Certificate] that use
	// this template. If the issuing
	// [CaPool][google.cloud.security.privateca.v1.CaPool]'s
	// [IssuancePolicy][google.cloud.security.privateca.v1.CaPool.IssuancePolicy]
	// specifies a
	// [maximum_lifetime][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.maximum_lifetime]
	// the minimum of the two durations will be the maximum lifetime for issued
	// [Certificates][google.cloud.security.privateca.v1.Certificate]. Note that
	// if the issuing
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// expires before a
	// [Certificate][google.cloud.security.privateca.v1.Certificate]'s requested
	// maximum_lifetime, the effective lifetime will be explicitly truncated
	//
	//	to match it.
	MaximumLifetime *durationpb.Duration `protobuf:"bytes,9,opt,name=maximum_lifetime,json=maximumLifetime,proto3" json:"maximum_lifetime,omitempty"`
	// Optional. A set of X.509 values that will be applied to all issued
	// certificates that use this template. If the certificate request includes
	// conflicting values for the same properties, they will be overwritten by the
	// values defined here. If the issuing
	// [CaPool][google.cloud.security.privateca.v1.CaPool]'s
	// [IssuancePolicy][google.cloud.security.privateca.v1.CaPool.IssuancePolicy]
	// defines conflicting
	// [baseline_values][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.baseline_values]
	// for the same properties, the certificate issuance request will fail.
	PredefinedValues *X509Parameters `protobuf:"bytes,2,opt,name=predefined_values,json=predefinedValues,proto3" json:"predefined_values,omitempty"`
	// Optional. Describes constraints on identities that may be appear in
	// [Certificates][google.cloud.security.privateca.v1.Certificate] issued using
	// this template. If this is omitted, then this template will not add
	// restrictions on a certificate's identity.
	IdentityConstraints *CertificateIdentityConstraints `protobuf:"bytes,3,opt,name=identity_constraints,json=identityConstraints,proto3" json:"identity_constraints,omitempty"`
	// Optional. Describes the set of X.509 extensions that may appear in a
	// [Certificate][google.cloud.security.privateca.v1.Certificate] issued using
	// this
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
	// If a certificate request sets extensions that don't appear in the
	// [passthrough_extensions][google.cloud.security.privateca.v1.CertificateTemplate.passthrough_extensions],
	// those extensions will be dropped. If the issuing
	// [CaPool][google.cloud.security.privateca.v1.CaPool]'s
	// [IssuancePolicy][google.cloud.security.privateca.v1.CaPool.IssuancePolicy]
	// defines
	// [baseline_values][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.baseline_values]
	// that don't appear here, the certificate issuance request will fail. If this
	// is omitted, then this template will not add restrictions on a certificate's
	// X.509 extensions. These constraints do not apply to X.509 extensions set in
	// this
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]'s
	// [predefined_values][google.cloud.security.privateca.v1.CertificateTemplate.predefined_values].
	PassthroughExtensions *CertificateExtensionConstraints `protobuf:"bytes,4,opt,name=passthrough_extensions,json=passthroughExtensions,proto3" json:"passthrough_extensions,omitempty"`
	// Optional. A human-readable description of scenarios this template is
	// intended for.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time at which this
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
	// was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
	// was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Labels with user-defined metadata.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CertificateTemplate) Reset() {
	*x = CertificateTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateTemplate) ProtoMessage() {}

func (x *CertificateTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateTemplate.ProtoReflect.Descriptor instead.
func (*CertificateTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *CertificateTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CertificateTemplate) GetMaximumLifetime() *durationpb.Duration {
	if x != nil {
		return x.MaximumLifetime
	}
	return nil
}

func (x *CertificateTemplate) GetPredefinedValues() *X509Parameters {
	if x != nil {
		return x.PredefinedValues
	}
	return nil
}

func (x *CertificateTemplate) GetIdentityConstraints() *CertificateIdentityConstraints {
	if x != nil {
		return x.IdentityConstraints
	}
	return nil
}

func (x *CertificateTemplate) GetPassthroughExtensions() *CertificateExtensionConstraints {
	if x != nil {
		return x.PassthroughExtensions
	}
	return nil
}

func (x *CertificateTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CertificateTemplate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CertificateTemplate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CertificateTemplate) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// An [X509Parameters][google.cloud.security.privateca.v1.X509Parameters] is
// used to describe certain fields of an X.509 certificate, such as the key
// usage fields, fields specific to CA certificates, certificate policy
// extensions and custom extensions.
type X509Parameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Indicates the intended use for keys that correspond to a
	// certificate.
	KeyUsage *KeyUsage `protobuf:"bytes,1,opt,name=key_usage,json=keyUsage,proto3" json:"key_usage,omitempty"`
	// Optional. Describes options in this
	// [X509Parameters][google.cloud.security.privateca.v1.X509Parameters] that
	// are relevant in a CA certificate.
	CaOptions *X509Parameters_CaOptions `protobuf:"bytes,2,opt,name=ca_options,json=caOptions,proto3" json:"ca_options,omitempty"`
	// Optional. Describes the X.509 certificate policy object identifiers, per
	// https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
	PolicyIds []*ObjectId `protobuf:"bytes,3,rep,name=policy_ids,json=policyIds,proto3" json:"policy_ids,omitempty"`
	// Optional. Describes Online Certificate Status Protocol (OCSP) endpoint
	// addresses that appear in the "Authority Information Access" extension in
	// the certificate.
	AiaOcspServers []string `protobuf:"bytes,4,rep,name=aia_ocsp_servers,json=aiaOcspServers,proto3" json:"aia_ocsp_servers,omitempty"`
	// Optional. Describes the X.509 name constraints extension.
	NameConstraints *X509Parameters_NameConstraints `protobuf:"bytes,6,opt,name=name_constraints,json=nameConstraints,proto3" json:"name_constraints,omitempty"`
	// Optional. Describes custom X.509 extensions.
	AdditionalExtensions []*X509Extension `protobuf:"bytes,5,rep,name=additional_extensions,json=additionalExtensions,proto3" json:"additional_extensions,omitempty"`
}

func (x *X509Parameters) Reset() {
	*x = X509Parameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X509Parameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X509Parameters) ProtoMessage() {}

func (x *X509Parameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X509Parameters.ProtoReflect.Descriptor instead.
func (*X509Parameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *X509Parameters) GetKeyUsage() *KeyUsage {
	if x != nil {
		return x.KeyUsage
	}
	return nil
}

func (x *X509Parameters) GetCaOptions() *X509Parameters_CaOptions {
	if x != nil {
		return x.CaOptions
	}
	return nil
}

func (x *X509Parameters) GetPolicyIds() []*ObjectId {
	if x != nil {
		return x.PolicyIds
	}
	return nil
}

func (x *X509Parameters) GetAiaOcspServers() []string {
	if x != nil {
		return x.AiaOcspServers
	}
	return nil
}

func (x *X509Parameters) GetNameConstraints() *X509Parameters_NameConstraints {
	if x != nil {
		return x.NameConstraints
	}
	return nil
}

func (x *X509Parameters) GetAdditionalExtensions() []*X509Extension {
	if x != nil {
		return x.AdditionalExtensions
	}
	return nil
}

// Describes a subordinate CA's issuers. This is either a resource name to a
// known issuing
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority],
// or a PEM issuer certificate chain.
type SubordinateConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SubordinateConfig:
	//
	//	*SubordinateConfig_CertificateAuthority
	//	*SubordinateConfig_PemIssuerChain
	SubordinateConfig isSubordinateConfig_SubordinateConfig `protobuf_oneof:"subordinate_config"`
}

func (x *SubordinateConfig) Reset() {
	*x = SubordinateConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubordinateConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubordinateConfig) ProtoMessage() {}

func (x *SubordinateConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubordinateConfig.ProtoReflect.Descriptor instead.
func (*SubordinateConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (m *SubordinateConfig) GetSubordinateConfig() isSubordinateConfig_SubordinateConfig {
	if m != nil {
		return m.SubordinateConfig
	}
	return nil
}

func (x *SubordinateConfig) GetCertificateAuthority() string {
	if x, ok := x.GetSubordinateConfig().(*SubordinateConfig_CertificateAuthority); ok {
		return x.CertificateAuthority
	}
	return ""
}

func (x *SubordinateConfig) GetPemIssuerChain() *SubordinateConfig_SubordinateConfigChain {
	if x, ok := x.GetSubordinateConfig().(*SubordinateConfig_PemIssuerChain); ok {
		return x.PemIssuerChain
	}
	return nil
}

type isSubordinateConfig_SubordinateConfig interface {
	isSubordinateConfig_SubordinateConfig()
}

type SubordinateConfig_CertificateAuthority struct {
	// Required. This can refer to a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// that was used to create a subordinate
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	// This field is used for information and usability purposes only. The
	// resource name is in the format
	// `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
	CertificateAuthority string `protobuf:"bytes,1,opt,name=certificate_authority,json=certificateAuthority,proto3,oneof"`
}

type SubordinateConfig_PemIssuerChain struct {
	// Required. Contains the PEM certificate chain for the issuers of this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority],
	// but not pem certificate for this CA itself.
	PemIssuerChain *SubordinateConfig_SubordinateConfigChain `protobuf:"bytes,2,opt,name=pem_issuer_chain,json=pemIssuerChain,proto3,oneof"`
}

func (*SubordinateConfig_CertificateAuthority) isSubordinateConfig_SubordinateConfig() {}

func (*SubordinateConfig_PemIssuerChain) isSubordinateConfig_SubordinateConfig() {}

// A [PublicKey][google.cloud.security.privateca.v1.PublicKey] describes a
// public key.
type PublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A public key. The padding and encoding
	// must match with the `KeyFormat` value specified for the `format` field.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Required. The format of the public key.
	Format PublicKey_KeyFormat `protobuf:"varint,2,opt,name=format,proto3,enum=google.cloud.security.privateca.v1.PublicKey_KeyFormat" json:"format,omitempty"`
}

func (x *PublicKey) Reset() {
	*x = PublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKey) ProtoMessage() {}

func (x *PublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKey.ProtoReflect.Descriptor instead.
func (*PublicKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *PublicKey) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PublicKey) GetFormat() PublicKey_KeyFormat {
	if x != nil {
		return x.Format
	}
	return PublicKey_KEY_FORMAT_UNSPECIFIED
}

// A [CertificateConfig][google.cloud.security.privateca.v1.CertificateConfig]
// describes an X.509 certificate or CSR that is to be created, as an
// alternative to using ASN.1.
type CertificateConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies some of the values in a certificate that are related to
	// the subject.
	SubjectConfig *CertificateConfig_SubjectConfig `protobuf:"bytes,1,opt,name=subject_config,json=subjectConfig,proto3" json:"subject_config,omitempty"`
	// Required. Describes how some of the technical X.509 fields in a certificate
	// should be populated.
	X509Config *X509Parameters `protobuf:"bytes,2,opt,name=x509_config,json=x509Config,proto3" json:"x509_config,omitempty"`
	// Optional. The public key that corresponds to this config. This is, for
	// example, used when issuing
	// [Certificates][google.cloud.security.privateca.v1.Certificate], but not
	// when creating a self-signed
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// or
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// CSR.
	PublicKey *PublicKey `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Optional. When specified this provides a custom SKI to be used in the
	// certificate. This should only be used to maintain a SKI of an existing CA
	// originally created outside CAS, which was not generated using method (1)
	// described in RFC 5280 section 4.2.1.2.
	SubjectKeyId *CertificateConfig_KeyId `protobuf:"bytes,4,opt,name=subject_key_id,json=subjectKeyId,proto3" json:"subject_key_id,omitempty"`
}

func (x *CertificateConfig) Reset() {
	*x = CertificateConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateConfig) ProtoMessage() {}

func (x *CertificateConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateConfig.ProtoReflect.Descriptor instead.
func (*CertificateConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *CertificateConfig) GetSubjectConfig() *CertificateConfig_SubjectConfig {
	if x != nil {
		return x.SubjectConfig
	}
	return nil
}

func (x *CertificateConfig) GetX509Config() *X509Parameters {
	if x != nil {
		return x.X509Config
	}
	return nil
}

func (x *CertificateConfig) GetPublicKey() *PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *CertificateConfig) GetSubjectKeyId() *CertificateConfig_KeyId {
	if x != nil {
		return x.SubjectKeyId
	}
	return nil
}

// A
// [CertificateDescription][google.cloud.security.privateca.v1.CertificateDescription]
// describes an X.509 certificate or CSR that has been issued, as an alternative
// to using ASN.1 / X.509.
type CertificateDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes some of the values in a certificate that are related to the
	// subject and lifetime.
	SubjectDescription *CertificateDescription_SubjectDescription `protobuf:"bytes,1,opt,name=subject_description,json=subjectDescription,proto3" json:"subject_description,omitempty"`
	// Describes some of the technical X.509 fields in a certificate.
	X509Description *X509Parameters `protobuf:"bytes,2,opt,name=x509_description,json=x509Description,proto3" json:"x509_description,omitempty"`
	// The public key that corresponds to an issued certificate.
	PublicKey *PublicKey `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Provides a means of identifiying certificates that contain a particular
	// public key, per https://tools.ietf.org/html/rfc5280#section-4.2.1.2.
	SubjectKeyId *CertificateDescription_KeyId `protobuf:"bytes,4,opt,name=subject_key_id,json=subjectKeyId,proto3" json:"subject_key_id,omitempty"`
	// Identifies the subject_key_id of the parent certificate, per
	// https://tools.ietf.org/html/rfc5280#section-4.2.1.1
	AuthorityKeyId *CertificateDescription_KeyId `protobuf:"bytes,5,opt,name=authority_key_id,json=authorityKeyId,proto3" json:"authority_key_id,omitempty"`
	// Describes a list of locations to obtain CRL information, i.e.
	// the DistributionPoint.fullName described by
	// https://tools.ietf.org/html/rfc5280#section-4.2.1.13
	CrlDistributionPoints []string `protobuf:"bytes,6,rep,name=crl_distribution_points,json=crlDistributionPoints,proto3" json:"crl_distribution_points,omitempty"`
	// Describes lists of issuer CA certificate URLs that appear in the
	// "Authority Information Access" extension in the certificate.
	AiaIssuingCertificateUrls []string `protobuf:"bytes,7,rep,name=aia_issuing_certificate_urls,json=aiaIssuingCertificateUrls,proto3" json:"aia_issuing_certificate_urls,omitempty"`
	// The hash of the x.509 certificate.
	CertFingerprint *CertificateDescription_CertificateFingerprint `protobuf:"bytes,8,opt,name=cert_fingerprint,json=certFingerprint,proto3" json:"cert_fingerprint,omitempty"`
}

func (x *CertificateDescription) Reset() {
	*x = CertificateDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateDescription) ProtoMessage() {}

func (x *CertificateDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateDescription.ProtoReflect.Descriptor instead.
func (*CertificateDescription) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *CertificateDescription) GetSubjectDescription() *CertificateDescription_SubjectDescription {
	if x != nil {
		return x.SubjectDescription
	}
	return nil
}

func (x *CertificateDescription) GetX509Description() *X509Parameters {
	if x != nil {
		return x.X509Description
	}
	return nil
}

func (x *CertificateDescription) GetPublicKey() *PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *CertificateDescription) GetSubjectKeyId() *CertificateDescription_KeyId {
	if x != nil {
		return x.SubjectKeyId
	}
	return nil
}

func (x *CertificateDescription) GetAuthorityKeyId() *CertificateDescription_KeyId {
	if x != nil {
		return x.AuthorityKeyId
	}
	return nil
}

func (x *CertificateDescription) GetCrlDistributionPoints() []string {
	if x != nil {
		return x.CrlDistributionPoints
	}
	return nil
}

func (x *CertificateDescription) GetAiaIssuingCertificateUrls() []string {
	if x != nil {
		return x.AiaIssuingCertificateUrls
	}
	return nil
}

func (x *CertificateDescription) GetCertFingerprint() *CertificateDescription_CertificateFingerprint {
	if x != nil {
		return x.CertFingerprint
	}
	return nil
}

// An [ObjectId][google.cloud.security.privateca.v1.ObjectId] specifies an
// object identifier (OID). These provide context and describe types in ASN.1
// messages.
type ObjectId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parts of an OID path. The most significant parts of the path
	// come first.
	ObjectIdPath []int32 `protobuf:"varint,1,rep,packed,name=object_id_path,json=objectIdPath,proto3" json:"object_id_path,omitempty"`
}

func (x *ObjectId) Reset() {
	*x = ObjectId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectId) ProtoMessage() {}

func (x *ObjectId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectId.ProtoReflect.Descriptor instead.
func (*ObjectId) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{10}
}

func (x *ObjectId) GetObjectIdPath() []int32 {
	if x != nil {
		return x.ObjectIdPath
	}
	return nil
}

// An [X509Extension][google.cloud.security.privateca.v1.X509Extension]
// specifies an X.509 extension, which may be used in different parts of X.509
// objects like certificates, CSRs, and CRLs.
type X509Extension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The OID for this X.509 extension.
	ObjectId *ObjectId `protobuf:"bytes,1,opt,name=object_id,json=objectId,proto3" json:"object_id,omitempty"`
	// Optional. Indicates whether or not this extension is critical (i.e., if the
	// client does not know how to handle this extension, the client should
	// consider this to be an error).
	Critical bool `protobuf:"varint,2,opt,name=critical,proto3" json:"critical,omitempty"`
	// Required. The value of this X.509 extension.
	Value []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *X509Extension) Reset() {
	*x = X509Extension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X509Extension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X509Extension) ProtoMessage() {}

func (x *X509Extension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X509Extension.ProtoReflect.Descriptor instead.
func (*X509Extension) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{11}
}

func (x *X509Extension) GetObjectId() *ObjectId {
	if x != nil {
		return x.ObjectId
	}
	return nil
}

func (x *X509Extension) GetCritical() bool {
	if x != nil {
		return x.Critical
	}
	return false
}

func (x *X509Extension) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// A [KeyUsage][google.cloud.security.privateca.v1.KeyUsage] describes key usage
// values that may appear in an X.509 certificate.
type KeyUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes high-level ways in which a key may be used.
	BaseKeyUsage *KeyUsage_KeyUsageOptions `protobuf:"bytes,1,opt,name=base_key_usage,json=baseKeyUsage,proto3" json:"base_key_usage,omitempty"`
	// Detailed scenarios in which a key may be used.
	ExtendedKeyUsage *KeyUsage_ExtendedKeyUsageOptions `protobuf:"bytes,2,opt,name=extended_key_usage,json=extendedKeyUsage,proto3" json:"extended_key_usage,omitempty"`
	// Used to describe extended key usages that are not listed in the
	// [KeyUsage.ExtendedKeyUsageOptions][google.cloud.security.privateca.v1.KeyUsage.ExtendedKeyUsageOptions]
	// message.
	UnknownExtendedKeyUsages []*ObjectId `protobuf:"bytes,3,rep,name=unknown_extended_key_usages,json=unknownExtendedKeyUsages,proto3" json:"unknown_extended_key_usages,omitempty"`
}

func (x *KeyUsage) Reset() {
	*x = KeyUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyUsage) ProtoMessage() {}

func (x *KeyUsage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyUsage.ProtoReflect.Descriptor instead.
func (*KeyUsage) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{12}
}

func (x *KeyUsage) GetBaseKeyUsage() *KeyUsage_KeyUsageOptions {
	if x != nil {
		return x.BaseKeyUsage
	}
	return nil
}

func (x *KeyUsage) GetExtendedKeyUsage() *KeyUsage_ExtendedKeyUsageOptions {
	if x != nil {
		return x.ExtendedKeyUsage
	}
	return nil
}

func (x *KeyUsage) GetUnknownExtendedKeyUsages() []*ObjectId {
	if x != nil {
		return x.UnknownExtendedKeyUsages
	}
	return nil
}

// [Subject][google.cloud.security.privateca.v1.Subject] describes parts of a
// distinguished name that, in turn, describes the subject of the certificate.
type Subject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The "common name" of the subject.
	CommonName string `protobuf:"bytes,1,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`
	// The country code of the subject.
	CountryCode string `protobuf:"bytes,2,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// The organization of the subject.
	Organization string `protobuf:"bytes,3,opt,name=organization,proto3" json:"organization,omitempty"`
	// The organizational_unit of the subject.
	OrganizationalUnit string `protobuf:"bytes,4,opt,name=organizational_unit,json=organizationalUnit,proto3" json:"organizational_unit,omitempty"`
	// The locality or city of the subject.
	Locality string `protobuf:"bytes,5,opt,name=locality,proto3" json:"locality,omitempty"`
	// The province, territory, or regional state of the subject.
	Province string `protobuf:"bytes,6,opt,name=province,proto3" json:"province,omitempty"`
	// The street address of the subject.
	StreetAddress string `protobuf:"bytes,7,opt,name=street_address,json=streetAddress,proto3" json:"street_address,omitempty"`
	// The postal code of the subject.
	PostalCode string `protobuf:"bytes,8,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
}

func (x *Subject) Reset() {
	*x = Subject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subject) ProtoMessage() {}

func (x *Subject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subject.ProtoReflect.Descriptor instead.
func (*Subject) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{13}
}

func (x *Subject) GetCommonName() string {
	if x != nil {
		return x.CommonName
	}
	return ""
}

func (x *Subject) GetCountryCode() string {
	if x != nil {
		return x.CountryCode
	}
	return ""
}

func (x *Subject) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *Subject) GetOrganizationalUnit() string {
	if x != nil {
		return x.OrganizationalUnit
	}
	return ""
}

func (x *Subject) GetLocality() string {
	if x != nil {
		return x.Locality
	}
	return ""
}

func (x *Subject) GetProvince() string {
	if x != nil {
		return x.Province
	}
	return ""
}

func (x *Subject) GetStreetAddress() string {
	if x != nil {
		return x.StreetAddress
	}
	return ""
}

func (x *Subject) GetPostalCode() string {
	if x != nil {
		return x.PostalCode
	}
	return ""
}

// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames]
// corresponds to a more modern way of listing what the asserted identity is in
// a certificate (i.e., compared to the "common name" in the distinguished
// name).
type SubjectAltNames struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains only valid, fully-qualified host names.
	DnsNames []string `protobuf:"bytes,1,rep,name=dns_names,json=dnsNames,proto3" json:"dns_names,omitempty"`
	// Contains only valid RFC 3986 URIs.
	Uris []string `protobuf:"bytes,2,rep,name=uris,proto3" json:"uris,omitempty"`
	// Contains only valid RFC 2822 E-mail addresses.
	EmailAddresses []string `protobuf:"bytes,3,rep,name=email_addresses,json=emailAddresses,proto3" json:"email_addresses,omitempty"`
	// Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
	IpAddresses []string `protobuf:"bytes,4,rep,name=ip_addresses,json=ipAddresses,proto3" json:"ip_addresses,omitempty"`
	// Contains additional subject alternative name values.
	// For each custom_san, the `value` field must contain an ASN.1 encoded
	// UTF8String.
	CustomSans []*X509Extension `protobuf:"bytes,5,rep,name=custom_sans,json=customSans,proto3" json:"custom_sans,omitempty"`
}

func (x *SubjectAltNames) Reset() {
	*x = SubjectAltNames{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubjectAltNames) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubjectAltNames) ProtoMessage() {}

func (x *SubjectAltNames) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubjectAltNames.ProtoReflect.Descriptor instead.
func (*SubjectAltNames) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{14}
}

func (x *SubjectAltNames) GetDnsNames() []string {
	if x != nil {
		return x.DnsNames
	}
	return nil
}

func (x *SubjectAltNames) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *SubjectAltNames) GetEmailAddresses() []string {
	if x != nil {
		return x.EmailAddresses
	}
	return nil
}

func (x *SubjectAltNames) GetIpAddresses() []string {
	if x != nil {
		return x.IpAddresses
	}
	return nil
}

func (x *SubjectAltNames) GetCustomSans() []*X509Extension {
	if x != nil {
		return x.CustomSans
	}
	return nil
}

// Describes constraints on a
// [Certificate][google.cloud.security.privateca.v1.Certificate]'s
// [Subject][google.cloud.security.privateca.v1.Subject] and
// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames].
type CertificateIdentityConstraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A CEL expression that may be used to validate the resolved X.509
	// Subject and/or Subject Alternative Name before a certificate is signed. To
	// see the full allowed syntax and some examples, see
	// https://cloud.google.com/certificate-authority-service/docs/using-cel
	CelExpression *expr.Expr `protobuf:"bytes,1,opt,name=cel_expression,json=celExpression,proto3" json:"cel_expression,omitempty"`
	// Required. If this is true, the
	// [Subject][google.cloud.security.privateca.v1.Subject] field may be copied
	// from a certificate request into the signed certificate. Otherwise, the
	// requested [Subject][google.cloud.security.privateca.v1.Subject] will be
	// discarded.
	AllowSubjectPassthrough *bool `protobuf:"varint,2,opt,name=allow_subject_passthrough,json=allowSubjectPassthrough,proto3,oneof" json:"allow_subject_passthrough,omitempty"`
	// Required. If this is true, the
	// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames]
	// extension may be copied from a certificate request into the signed
	// certificate. Otherwise, the requested
	// [SubjectAltNames][google.cloud.security.privateca.v1.SubjectAltNames] will
	// be discarded.
	AllowSubjectAltNamesPassthrough *bool `protobuf:"varint,3,opt,name=allow_subject_alt_names_passthrough,json=allowSubjectAltNamesPassthrough,proto3,oneof" json:"allow_subject_alt_names_passthrough,omitempty"`
}

func (x *CertificateIdentityConstraints) Reset() {
	*x = CertificateIdentityConstraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateIdentityConstraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateIdentityConstraints) ProtoMessage() {}

func (x *CertificateIdentityConstraints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateIdentityConstraints.ProtoReflect.Descriptor instead.
func (*CertificateIdentityConstraints) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{15}
}

func (x *CertificateIdentityConstraints) GetCelExpression() *expr.Expr {
	if x != nil {
		return x.CelExpression
	}
	return nil
}

func (x *CertificateIdentityConstraints) GetAllowSubjectPassthrough() bool {
	if x != nil && x.AllowSubjectPassthrough != nil {
		return *x.AllowSubjectPassthrough
	}
	return false
}

func (x *CertificateIdentityConstraints) GetAllowSubjectAltNamesPassthrough() bool {
	if x != nil && x.AllowSubjectAltNamesPassthrough != nil {
		return *x.AllowSubjectAltNamesPassthrough
	}
	return false
}

// Describes a set of X.509 extensions that may be part of some certificate
// issuance controls.
type CertificateExtensionConstraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A set of named X.509 extensions. Will be combined with
	// [additional_extensions][google.cloud.security.privateca.v1.CertificateExtensionConstraints.additional_extensions]
	// to determine the full set of X.509 extensions.
	KnownExtensions []CertificateExtensionConstraints_KnownCertificateExtension `protobuf:"varint,1,rep,packed,name=known_extensions,json=knownExtensions,proto3,enum=google.cloud.security.privateca.v1.CertificateExtensionConstraints_KnownCertificateExtension" json:"known_extensions,omitempty"`
	// Optional. A set of [ObjectIds][google.cloud.security.privateca.v1.ObjectId]
	// identifying custom X.509 extensions. Will be combined with
	// [known_extensions][google.cloud.security.privateca.v1.CertificateExtensionConstraints.known_extensions]
	// to determine the full set of X.509 extensions.
	AdditionalExtensions []*ObjectId `protobuf:"bytes,2,rep,name=additional_extensions,json=additionalExtensions,proto3" json:"additional_extensions,omitempty"`
}

func (x *CertificateExtensionConstraints) Reset() {
	*x = CertificateExtensionConstraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateExtensionConstraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateExtensionConstraints) ProtoMessage() {}

func (x *CertificateExtensionConstraints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateExtensionConstraints.ProtoReflect.Descriptor instead.
func (*CertificateExtensionConstraints) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{16}
}

func (x *CertificateExtensionConstraints) GetKnownExtensions() []CertificateExtensionConstraints_KnownCertificateExtension {
	if x != nil {
		return x.KnownExtensions
	}
	return nil
}

func (x *CertificateExtensionConstraints) GetAdditionalExtensions() []*ObjectId {
	if x != nil {
		return x.AdditionalExtensions
	}
	return nil
}

// URLs where a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// will publish content.
type CertificateAuthority_AccessUrls struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL where this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
	// CA certificate is published. This will only be set for CAs that have been
	// activated.
	CaCertificateAccessUrl string `protobuf:"bytes,1,opt,name=ca_certificate_access_url,json=caCertificateAccessUrl,proto3" json:"ca_certificate_access_url,omitempty"`
	// The URLs where this
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
	// CRLs are published. This will only be set for CAs that have been
	// activated.
	CrlAccessUrls []string `protobuf:"bytes,2,rep,name=crl_access_urls,json=crlAccessUrls,proto3" json:"crl_access_urls,omitempty"`
}

func (x *CertificateAuthority_AccessUrls) Reset() {
	*x = CertificateAuthority_AccessUrls{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_AccessUrls) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_AccessUrls) ProtoMessage() {}

func (x *CertificateAuthority_AccessUrls) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_AccessUrls.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_AccessUrls) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (x *CertificateAuthority_AccessUrls) GetCaCertificateAccessUrl() string {
	if x != nil {
		return x.CaCertificateAccessUrl
	}
	return ""
}

func (x *CertificateAuthority_AccessUrls) GetCrlAccessUrls() []string {
	if x != nil {
		return x.CrlAccessUrls
	}
	return nil
}

// A Cloud KMS key configuration that a
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// will use.
type CertificateAuthority_KeyVersionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to KeyVersion:
	//
	//	*CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion
	//	*CertificateAuthority_KeyVersionSpec_Algorithm
	KeyVersion isCertificateAuthority_KeyVersionSpec_KeyVersion `protobuf_oneof:"KeyVersion"`
}

func (x *CertificateAuthority_KeyVersionSpec) Reset() {
	*x = CertificateAuthority_KeyVersionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_KeyVersionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_KeyVersionSpec) ProtoMessage() {}

func (x *CertificateAuthority_KeyVersionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_KeyVersionSpec.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_KeyVersionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{0, 1}
}

func (m *CertificateAuthority_KeyVersionSpec) GetKeyVersion() isCertificateAuthority_KeyVersionSpec_KeyVersion {
	if m != nil {
		return m.KeyVersion
	}
	return nil
}

func (x *CertificateAuthority_KeyVersionSpec) GetCloudKmsKeyVersion() string {
	if x, ok := x.GetKeyVersion().(*CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion); ok {
		return x.CloudKmsKeyVersion
	}
	return ""
}

func (x *CertificateAuthority_KeyVersionSpec) GetAlgorithm() CertificateAuthority_SignHashAlgorithm {
	if x, ok := x.GetKeyVersion().(*CertificateAuthority_KeyVersionSpec_Algorithm); ok {
		return x.Algorithm
	}
	return CertificateAuthority_SIGN_HASH_ALGORITHM_UNSPECIFIED
}

type isCertificateAuthority_KeyVersionSpec_KeyVersion interface {
	isCertificateAuthority_KeyVersionSpec_KeyVersion()
}

type CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion struct {
	// The resource name for an existing Cloud KMS CryptoKeyVersion in the
	// format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
	// This option enables full flexibility in the key's capabilities and
	// properties.
	CloudKmsKeyVersion string `protobuf:"bytes,1,opt,name=cloud_kms_key_version,json=cloudKmsKeyVersion,proto3,oneof"`
}

type CertificateAuthority_KeyVersionSpec_Algorithm struct {
	// The algorithm to use for creating a managed Cloud KMS key for a for a
	// simplified experience. All managed keys will be have their
	// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] as `HSM`.
	Algorithm CertificateAuthority_SignHashAlgorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.cloud.security.privateca.v1.CertificateAuthority_SignHashAlgorithm,oneof"`
}

func (*CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion) isCertificateAuthority_KeyVersionSpec_KeyVersion() {
}

func (*CertificateAuthority_KeyVersionSpec_Algorithm) isCertificateAuthority_KeyVersionSpec_KeyVersion() {
}

// Options relating to the publication of each
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
// CA certificate and CRLs and their inclusion as extensions in issued
// [Certificates][google.cloud.security.privateca.v1.Certificate]. The options
// set here apply to certificates issued by any
// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
// in the [CaPool][google.cloud.security.privateca.v1.CaPool].
type CaPool_PublishingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. When true, publishes each
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
	// CA certificate and includes its URL in the "Authority Information Access"
	// X.509 extension in all issued
	// [Certificates][google.cloud.security.privateca.v1.Certificate]. If this
	// is false, the CA certificate will not be published and the corresponding
	// X.509 extension will not be written in issued certificates.
	PublishCaCert bool `protobuf:"varint,1,opt,name=publish_ca_cert,json=publishCaCert,proto3" json:"publish_ca_cert,omitempty"`
	// Optional. When true, publishes each
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]'s
	// CRL and includes its URL in the "CRL Distribution Points" X.509 extension
	// in all issued
	// [Certificates][google.cloud.security.privateca.v1.Certificate]. If this
	// is false, CRLs will not be published and the corresponding X.509
	// extension will not be written in issued certificates. CRLs will expire 7
	// days from their creation. However, we will rebuild daily. CRLs are also
	// rebuilt shortly after a certificate is revoked.
	PublishCrl bool `protobuf:"varint,2,opt,name=publish_crl,json=publishCrl,proto3" json:"publish_crl,omitempty"`
}

func (x *CaPool_PublishingOptions) Reset() {
	*x = CaPool_PublishingOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CaPool_PublishingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CaPool_PublishingOptions) ProtoMessage() {}

func (x *CaPool_PublishingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CaPool_PublishingOptions.ProtoReflect.Descriptor instead.
func (*CaPool_PublishingOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

func (x *CaPool_PublishingOptions) GetPublishCaCert() bool {
	if x != nil {
		return x.PublishCaCert
	}
	return false
}

func (x *CaPool_PublishingOptions) GetPublishCrl() bool {
	if x != nil {
		return x.PublishCrl
	}
	return false
}

// Defines controls over all certificate issuance within a
// [CaPool][google.cloud.security.privateca.v1.CaPool].
type CaPool_IssuancePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If any
	// [AllowedKeyType][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType]
	// is specified, then the certificate request's public key must match one of
	// the key types listed here. Otherwise, any key may be used.
	AllowedKeyTypes []*CaPool_IssuancePolicy_AllowedKeyType `protobuf:"bytes,1,rep,name=allowed_key_types,json=allowedKeyTypes,proto3" json:"allowed_key_types,omitempty"`
	// Optional. The maximum lifetime allowed for issued
	// [Certificates][google.cloud.security.privateca.v1.Certificate]. Note that
	// if the issuing
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// expires before a
	// [Certificate][google.cloud.security.privateca.v1.Certificate]'s requested
	// maximum_lifetime, the effective lifetime will be explicitly truncated to
	// match it.
	MaximumLifetime *durationpb.Duration `protobuf:"bytes,2,opt,name=maximum_lifetime,json=maximumLifetime,proto3" json:"maximum_lifetime,omitempty"`
	// Optional. If specified, then only methods allowed in the
	// [IssuanceModes][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.IssuanceModes]
	// may be used to issue
	// [Certificates][google.cloud.security.privateca.v1.Certificate].
	AllowedIssuanceModes *CaPool_IssuancePolicy_IssuanceModes `protobuf:"bytes,3,opt,name=allowed_issuance_modes,json=allowedIssuanceModes,proto3" json:"allowed_issuance_modes,omitempty"`
	// Optional. A set of X.509 values that will be applied to all certificates
	// issued through this [CaPool][google.cloud.security.privateca.v1.CaPool].
	// If a certificate request includes conflicting values for the same
	// properties, they will be overwritten by the values defined here. If a
	// certificate request uses a
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
	// that defines conflicting
	// [predefined_values][google.cloud.security.privateca.v1.CertificateTemplate.predefined_values]
	// for the same properties, the certificate issuance request will fail.
	BaselineValues *X509Parameters `protobuf:"bytes,4,opt,name=baseline_values,json=baselineValues,proto3" json:"baseline_values,omitempty"`
	// Optional. Describes constraints on identities that may appear in
	// [Certificates][google.cloud.security.privateca.v1.Certificate] issued
	// through this [CaPool][google.cloud.security.privateca.v1.CaPool]. If this
	// is omitted, then this [CaPool][google.cloud.security.privateca.v1.CaPool]
	// will not add restrictions on a certificate's identity.
	IdentityConstraints *CertificateIdentityConstraints `protobuf:"bytes,5,opt,name=identity_constraints,json=identityConstraints,proto3" json:"identity_constraints,omitempty"`
	// Optional. Describes the set of X.509 extensions that may appear in a
	// [Certificate][google.cloud.security.privateca.v1.Certificate] issued
	// through this [CaPool][google.cloud.security.privateca.v1.CaPool]. If a
	// certificate request sets extensions that don't appear in the
	// [passthrough_extensions][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.passthrough_extensions],
	// those extensions will be dropped. If a certificate request uses a
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
	// with
	// [predefined_values][google.cloud.security.privateca.v1.CertificateTemplate.predefined_values]
	// that don't appear here, the certificate issuance request will fail. If
	// this is omitted, then this
	// [CaPool][google.cloud.security.privateca.v1.CaPool] will not add
	// restrictions on a certificate's X.509 extensions. These constraints do
	// not apply to X.509 extensions set in this
	// [CaPool][google.cloud.security.privateca.v1.CaPool]'s
	// [baseline_values][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.baseline_values].
	PassthroughExtensions *CertificateExtensionConstraints `protobuf:"bytes,6,opt,name=passthrough_extensions,json=passthroughExtensions,proto3" json:"passthrough_extensions,omitempty"`
}

func (x *CaPool_IssuancePolicy) Reset() {
	*x = CaPool_IssuancePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CaPool_IssuancePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CaPool_IssuancePolicy) ProtoMessage() {}

func (x *CaPool_IssuancePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CaPool_IssuancePolicy.ProtoReflect.Descriptor instead.
func (*CaPool_IssuancePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1, 1}
}

func (x *CaPool_IssuancePolicy) GetAllowedKeyTypes() []*CaPool_IssuancePolicy_AllowedKeyType {
	if x != nil {
		return x.AllowedKeyTypes
	}
	return nil
}

func (x *CaPool_IssuancePolicy) GetMaximumLifetime() *durationpb.Duration {
	if x != nil {
		return x.MaximumLifetime
	}
	return nil
}

func (x *CaPool_IssuancePolicy) GetAllowedIssuanceModes() *CaPool_IssuancePolicy_IssuanceModes {
	if x != nil {
		return x.AllowedIssuanceModes
	}
	return nil
}

func (x *CaPool_IssuancePolicy) GetBaselineValues() *X509Parameters {
	if x != nil {
		return x.BaselineValues
	}
	return nil
}

func (x *CaPool_IssuancePolicy) GetIdentityConstraints() *CertificateIdentityConstraints {
	if x != nil {
		return x.IdentityConstraints
	}
	return nil
}

func (x *CaPool_IssuancePolicy) GetPassthroughExtensions() *CertificateExtensionConstraints {
	if x != nil {
		return x.PassthroughExtensions
	}
	return nil
}

// Describes a "type" of key that may be used in a
// [Certificate][google.cloud.security.privateca.v1.Certificate] issued from
// a [CaPool][google.cloud.security.privateca.v1.CaPool]. Note that a single
// [AllowedKeyType][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType]
// may refer to either a fully-qualified key algorithm, such as RSA 4096, or
// a family of key algorithms, such as any RSA key.
type CaPool_IssuancePolicy_AllowedKeyType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to KeyType:
	//
	//	*CaPool_IssuancePolicy_AllowedKeyType_Rsa
	//	*CaPool_IssuancePolicy_AllowedKeyType_EllipticCurve
	KeyType isCaPool_IssuancePolicy_AllowedKeyType_KeyType `protobuf_oneof:"key_type"`
}

func (x *CaPool_IssuancePolicy_AllowedKeyType) Reset() {
	*x = CaPool_IssuancePolicy_AllowedKeyType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CaPool_IssuancePolicy_AllowedKeyType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CaPool_IssuancePolicy_AllowedKeyType) ProtoMessage() {}

func (x *CaPool_IssuancePolicy_AllowedKeyType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CaPool_IssuancePolicy_AllowedKeyType.ProtoReflect.Descriptor instead.
func (*CaPool_IssuancePolicy_AllowedKeyType) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (m *CaPool_IssuancePolicy_AllowedKeyType) GetKeyType() isCaPool_IssuancePolicy_AllowedKeyType_KeyType {
	if m != nil {
		return m.KeyType
	}
	return nil
}

func (x *CaPool_IssuancePolicy_AllowedKeyType) GetRsa() *CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType {
	if x, ok := x.GetKeyType().(*CaPool_IssuancePolicy_AllowedKeyType_Rsa); ok {
		return x.Rsa
	}
	return nil
}

func (x *CaPool_IssuancePolicy_AllowedKeyType) GetEllipticCurve() *CaPool_IssuancePolicy_AllowedKeyType_EcKeyType {
	if x, ok := x.GetKeyType().(*CaPool_IssuancePolicy_AllowedKeyType_EllipticCurve); ok {
		return x.EllipticCurve
	}
	return nil
}

type isCaPool_IssuancePolicy_AllowedKeyType_KeyType interface {
	isCaPool_IssuancePolicy_AllowedKeyType_KeyType()
}

type CaPool_IssuancePolicy_AllowedKeyType_Rsa struct {
	// Represents an allowed RSA key type.
	Rsa *CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType `protobuf:"bytes,1,opt,name=rsa,proto3,oneof"`
}

type CaPool_IssuancePolicy_AllowedKeyType_EllipticCurve struct {
	// Represents an allowed Elliptic Curve key type.
	EllipticCurve *CaPool_IssuancePolicy_AllowedKeyType_EcKeyType `protobuf:"bytes,2,opt,name=elliptic_curve,json=ellipticCurve,proto3,oneof"`
}

func (*CaPool_IssuancePolicy_AllowedKeyType_Rsa) isCaPool_IssuancePolicy_AllowedKeyType_KeyType() {}

func (*CaPool_IssuancePolicy_AllowedKeyType_EllipticCurve) isCaPool_IssuancePolicy_AllowedKeyType_KeyType() {
}

// [IssuanceModes][google.cloud.security.privateca.v1.CaPool.IssuancePolicy.IssuanceModes]
// specifies the allowed ways in which
// [Certificates][google.cloud.security.privateca.v1.Certificate] may be
// requested from this [CaPool][google.cloud.security.privateca.v1.CaPool].
type CaPool_IssuancePolicy_IssuanceModes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. When true, allows callers to create
	// [Certificates][google.cloud.security.privateca.v1.Certificate] by
	// specifying a CSR.
	AllowCsrBasedIssuance bool `protobuf:"varint,1,opt,name=allow_csr_based_issuance,json=allowCsrBasedIssuance,proto3" json:"allow_csr_based_issuance,omitempty"`
	// Optional. When true, allows callers to create
	// [Certificates][google.cloud.security.privateca.v1.Certificate] by
	// specifying a
	// [CertificateConfig][google.cloud.security.privateca.v1.CertificateConfig].
	AllowConfigBasedIssuance bool `protobuf:"varint,2,opt,name=allow_config_based_issuance,json=allowConfigBasedIssuance,proto3" json:"allow_config_based_issuance,omitempty"`
}

func (x *CaPool_IssuancePolicy_IssuanceModes) Reset() {
	*x = CaPool_IssuancePolicy_IssuanceModes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CaPool_IssuancePolicy_IssuanceModes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CaPool_IssuancePolicy_IssuanceModes) ProtoMessage() {}

func (x *CaPool_IssuancePolicy_IssuanceModes) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CaPool_IssuancePolicy_IssuanceModes.ProtoReflect.Descriptor instead.
func (*CaPool_IssuancePolicy_IssuanceModes) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1, 1, 1}
}

func (x *CaPool_IssuancePolicy_IssuanceModes) GetAllowCsrBasedIssuance() bool {
	if x != nil {
		return x.AllowCsrBasedIssuance
	}
	return false
}

func (x *CaPool_IssuancePolicy_IssuanceModes) GetAllowConfigBasedIssuance() bool {
	if x != nil {
		return x.AllowConfigBasedIssuance
	}
	return false
}

// Describes an RSA key that may be used in a
// [Certificate][google.cloud.security.privateca.v1.Certificate] issued
// from a [CaPool][google.cloud.security.privateca.v1.CaPool].
type CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The minimum allowed RSA modulus size (inclusive), in bits.
	// If this is not set, or if set to zero, the service-level min RSA
	// modulus size will continue to apply.
	MinModulusSize int64 `protobuf:"varint,1,opt,name=min_modulus_size,json=minModulusSize,proto3" json:"min_modulus_size,omitempty"`
	// Optional. The maximum allowed RSA modulus size (inclusive), in bits.
	// If this is not set, or if set to zero, the service will not enforce
	// an explicit upper bound on RSA modulus sizes.
	MaxModulusSize int64 `protobuf:"varint,2,opt,name=max_modulus_size,json=maxModulusSize,proto3" json:"max_modulus_size,omitempty"`
}

func (x *CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType) Reset() {
	*x = CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType) ProtoMessage() {}

func (x *CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType.ProtoReflect.Descriptor instead.
func (*CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1, 1, 0, 0}
}

func (x *CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType) GetMinModulusSize() int64 {
	if x != nil {
		return x.MinModulusSize
	}
	return 0
}

func (x *CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType) GetMaxModulusSize() int64 {
	if x != nil {
		return x.MaxModulusSize
	}
	return 0
}

// Describes an Elliptic Curve key that may be used in a
// [Certificate][google.cloud.security.privateca.v1.Certificate] issued
// from a [CaPool][google.cloud.security.privateca.v1.CaPool].
type CaPool_IssuancePolicy_AllowedKeyType_EcKeyType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A signature algorithm that must be used. If this is
	// omitted, any EC-based signature algorithm will be allowed.
	SignatureAlgorithm CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm `protobuf:"varint,1,opt,name=signature_algorithm,json=signatureAlgorithm,proto3,enum=google.cloud.security.privateca.v1.CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm" json:"signature_algorithm,omitempty"`
}

func (x *CaPool_IssuancePolicy_AllowedKeyType_EcKeyType) Reset() {
	*x = CaPool_IssuancePolicy_AllowedKeyType_EcKeyType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CaPool_IssuancePolicy_AllowedKeyType_EcKeyType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CaPool_IssuancePolicy_AllowedKeyType_EcKeyType) ProtoMessage() {}

func (x *CaPool_IssuancePolicy_AllowedKeyType_EcKeyType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CaPool_IssuancePolicy_AllowedKeyType_EcKeyType.ProtoReflect.Descriptor instead.
func (*CaPool_IssuancePolicy_AllowedKeyType_EcKeyType) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{1, 1, 0, 1}
}

func (x *CaPool_IssuancePolicy_AllowedKeyType_EcKeyType) GetSignatureAlgorithm() CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm {
	if x != nil {
		return x.SignatureAlgorithm
	}
	return CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EC_SIGNATURE_ALGORITHM_UNSPECIFIED
}

// Describes a revoked
// [Certificate][google.cloud.security.privateca.v1.Certificate].
type CertificateRevocationList_RevokedCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for the
	// [Certificate][google.cloud.security.privateca.v1.Certificate] in the
	// format `projects/*/locations/*/caPools/*/certificates/*`.
	Certificate string `protobuf:"bytes,1,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// The serial number of the
	// [Certificate][google.cloud.security.privateca.v1.Certificate].
	HexSerialNumber string `protobuf:"bytes,2,opt,name=hex_serial_number,json=hexSerialNumber,proto3" json:"hex_serial_number,omitempty"`
	// The reason the
	// [Certificate][google.cloud.security.privateca.v1.Certificate] was
	// revoked.
	RevocationReason RevocationReason `protobuf:"varint,3,opt,name=revocation_reason,json=revocationReason,proto3,enum=google.cloud.security.privateca.v1.RevocationReason" json:"revocation_reason,omitempty"`
}

func (x *CertificateRevocationList_RevokedCertificate) Reset() {
	*x = CertificateRevocationList_RevokedCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateRevocationList_RevokedCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateRevocationList_RevokedCertificate) ProtoMessage() {}

func (x *CertificateRevocationList_RevokedCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateRevocationList_RevokedCertificate.ProtoReflect.Descriptor instead.
func (*CertificateRevocationList_RevokedCertificate) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *CertificateRevocationList_RevokedCertificate) GetCertificate() string {
	if x != nil {
		return x.Certificate
	}
	return ""
}

func (x *CertificateRevocationList_RevokedCertificate) GetHexSerialNumber() string {
	if x != nil {
		return x.HexSerialNumber
	}
	return ""
}

func (x *CertificateRevocationList_RevokedCertificate) GetRevocationReason() RevocationReason {
	if x != nil {
		return x.RevocationReason
	}
	return RevocationReason_REVOCATION_REASON_UNSPECIFIED
}

// Describes fields that are relavent to the revocation of a
// [Certificate][google.cloud.security.privateca.v1.Certificate].
type Certificate_RevocationDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates why a
	// [Certificate][google.cloud.security.privateca.v1.Certificate] was
	// revoked.
	RevocationState RevocationReason `protobuf:"varint,1,opt,name=revocation_state,json=revocationState,proto3,enum=google.cloud.security.privateca.v1.RevocationReason" json:"revocation_state,omitempty"`
	// The time at which this
	// [Certificate][google.cloud.security.privateca.v1.Certificate] was
	// revoked.
	RevocationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=revocation_time,json=revocationTime,proto3" json:"revocation_time,omitempty"`
}

func (x *Certificate_RevocationDetails) Reset() {
	*x = Certificate_RevocationDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate_RevocationDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate_RevocationDetails) ProtoMessage() {}

func (x *Certificate_RevocationDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate_RevocationDetails.ProtoReflect.Descriptor instead.
func (*Certificate_RevocationDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Certificate_RevocationDetails) GetRevocationState() RevocationReason {
	if x != nil {
		return x.RevocationState
	}
	return RevocationReason_REVOCATION_REASON_UNSPECIFIED
}

func (x *Certificate_RevocationDetails) GetRevocationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RevocationTime
	}
	return nil
}

// Describes values that are relevant in a CA certificate.
type X509Parameters_CaOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Refers to the "CA" X.509 extension, which is a boolean value.
	// When this value is missing, the extension will be omitted from the CA
	// certificate.
	IsCa *bool `protobuf:"varint,1,opt,name=is_ca,json=isCa,proto3,oneof" json:"is_ca,omitempty"`
	// Optional. Refers to the path length restriction X.509 extension. For a CA
	// certificate, this value describes the depth of subordinate CA
	// certificates that are allowed.
	// If this value is less than 0, the request will fail.
	// If this value is missing, the max path length will be omitted from the
	// CA certificate.
	MaxIssuerPathLength *int32 `protobuf:"varint,2,opt,name=max_issuer_path_length,json=maxIssuerPathLength,proto3,oneof" json:"max_issuer_path_length,omitempty"`
}

func (x *X509Parameters_CaOptions) Reset() {
	*x = X509Parameters_CaOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X509Parameters_CaOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X509Parameters_CaOptions) ProtoMessage() {}

func (x *X509Parameters_CaOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X509Parameters_CaOptions.ProtoReflect.Descriptor instead.
func (*X509Parameters_CaOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{5, 0}
}

func (x *X509Parameters_CaOptions) GetIsCa() bool {
	if x != nil && x.IsCa != nil {
		return *x.IsCa
	}
	return false
}

func (x *X509Parameters_CaOptions) GetMaxIssuerPathLength() int32 {
	if x != nil && x.MaxIssuerPathLength != nil {
		return *x.MaxIssuerPathLength
	}
	return 0
}

// Describes the X.509 name constraints extension, per
// https://tools.ietf.org/html/rfc5280#section-4.2.1.10
type X509Parameters_NameConstraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether or not the name constraints are marked critical.
	Critical bool `protobuf:"varint,1,opt,name=critical,proto3" json:"critical,omitempty"`
	// Contains permitted DNS names. Any DNS name that can be
	// constructed by simply adding zero or more labels to
	// the left-hand side of the name satisfies the name constraint.
	// For example, `example.com`, `www.example.com`, `www.sub.example.com`
	// would satisfy `example.com` while `example1.com` does not.
	PermittedDnsNames []string `protobuf:"bytes,2,rep,name=permitted_dns_names,json=permittedDnsNames,proto3" json:"permitted_dns_names,omitempty"`
	// Contains excluded DNS names. Any DNS name that can be
	// constructed by simply adding zero or more labels to
	// the left-hand side of the name satisfies the name constraint.
	// For example, `example.com`, `www.example.com`, `www.sub.example.com`
	// would satisfy `example.com` while `example1.com` does not.
	ExcludedDnsNames []string `protobuf:"bytes,3,rep,name=excluded_dns_names,json=excludedDnsNames,proto3" json:"excluded_dns_names,omitempty"`
	// Contains the permitted IP ranges. For IPv4 addresses, the ranges
	// are expressed using CIDR notation as specified in RFC 4632.
	// For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
	// addresses.
	PermittedIpRanges []string `protobuf:"bytes,4,rep,name=permitted_ip_ranges,json=permittedIpRanges,proto3" json:"permitted_ip_ranges,omitempty"`
	// Contains the excluded IP ranges. For IPv4 addresses, the ranges
	// are expressed using CIDR notation as specified in RFC 4632.
	// For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
	// addresses.
	ExcludedIpRanges []string `protobuf:"bytes,5,rep,name=excluded_ip_ranges,json=excludedIpRanges,proto3" json:"excluded_ip_ranges,omitempty"`
	// Contains the permitted email addresses. The value can be a particular
	// email address, a hostname to indicate all email addresses on that host or
	// a domain with a leading period (e.g. `.example.com`) to indicate
	// all email addresses in that domain.
	PermittedEmailAddresses []string `protobuf:"bytes,6,rep,name=permitted_email_addresses,json=permittedEmailAddresses,proto3" json:"permitted_email_addresses,omitempty"`
	// Contains the excluded email addresses. The value can be a particular
	// email address, a hostname to indicate all email addresses on that host or
	// a domain with a leading period (e.g. `.example.com`) to indicate
	// all email addresses in that domain.
	ExcludedEmailAddresses []string `protobuf:"bytes,7,rep,name=excluded_email_addresses,json=excludedEmailAddresses,proto3" json:"excluded_email_addresses,omitempty"`
	// Contains the permitted URIs that apply to the host part of the name.
	// The value can be a hostname or a domain with a
	// leading period (like `.example.com`)
	PermittedUris []string `protobuf:"bytes,8,rep,name=permitted_uris,json=permittedUris,proto3" json:"permitted_uris,omitempty"`
	// Contains the excluded URIs that apply to the host part of the name.
	// The value can be a hostname or a domain with a
	// leading period (like `.example.com`)
	ExcludedUris []string `protobuf:"bytes,9,rep,name=excluded_uris,json=excludedUris,proto3" json:"excluded_uris,omitempty"`
}

func (x *X509Parameters_NameConstraints) Reset() {
	*x = X509Parameters_NameConstraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X509Parameters_NameConstraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X509Parameters_NameConstraints) ProtoMessage() {}

func (x *X509Parameters_NameConstraints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X509Parameters_NameConstraints.ProtoReflect.Descriptor instead.
func (*X509Parameters_NameConstraints) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{5, 1}
}

func (x *X509Parameters_NameConstraints) GetCritical() bool {
	if x != nil {
		return x.Critical
	}
	return false
}

func (x *X509Parameters_NameConstraints) GetPermittedDnsNames() []string {
	if x != nil {
		return x.PermittedDnsNames
	}
	return nil
}

func (x *X509Parameters_NameConstraints) GetExcludedDnsNames() []string {
	if x != nil {
		return x.ExcludedDnsNames
	}
	return nil
}

func (x *X509Parameters_NameConstraints) GetPermittedIpRanges() []string {
	if x != nil {
		return x.PermittedIpRanges
	}
	return nil
}

func (x *X509Parameters_NameConstraints) GetExcludedIpRanges() []string {
	if x != nil {
		return x.ExcludedIpRanges
	}
	return nil
}

func (x *X509Parameters_NameConstraints) GetPermittedEmailAddresses() []string {
	if x != nil {
		return x.PermittedEmailAddresses
	}
	return nil
}

func (x *X509Parameters_NameConstraints) GetExcludedEmailAddresses() []string {
	if x != nil {
		return x.ExcludedEmailAddresses
	}
	return nil
}

func (x *X509Parameters_NameConstraints) GetPermittedUris() []string {
	if x != nil {
		return x.PermittedUris
	}
	return nil
}

func (x *X509Parameters_NameConstraints) GetExcludedUris() []string {
	if x != nil {
		return x.ExcludedUris
	}
	return nil
}

// This message describes a subordinate CA's issuer certificate chain. This
// wrapper exists for compatibility reasons.
type SubordinateConfig_SubordinateConfigChain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Expected to be in leaf-to-root order according to RFC 5246.
	PemCertificates []string `protobuf:"bytes,1,rep,name=pem_certificates,json=pemCertificates,proto3" json:"pem_certificates,omitempty"`
}

func (x *SubordinateConfig_SubordinateConfigChain) Reset() {
	*x = SubordinateConfig_SubordinateConfigChain{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubordinateConfig_SubordinateConfigChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubordinateConfig_SubordinateConfigChain) ProtoMessage() {}

func (x *SubordinateConfig_SubordinateConfigChain) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubordinateConfig_SubordinateConfigChain.ProtoReflect.Descriptor instead.
func (*SubordinateConfig_SubordinateConfigChain) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{6, 0}
}

func (x *SubordinateConfig_SubordinateConfigChain) GetPemCertificates() []string {
	if x != nil {
		return x.PemCertificates
	}
	return nil
}

// These values are used to create the distinguished name and subject
// alternative name fields in an X.509 certificate.
type CertificateConfig_SubjectConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Contains distinguished name fields such as the common name,
	// location and organization.
	Subject *Subject `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	// Optional. The subject alternative name fields.
	SubjectAltName *SubjectAltNames `protobuf:"bytes,2,opt,name=subject_alt_name,json=subjectAltName,proto3" json:"subject_alt_name,omitempty"`
}

func (x *CertificateConfig_SubjectConfig) Reset() {
	*x = CertificateConfig_SubjectConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateConfig_SubjectConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateConfig_SubjectConfig) ProtoMessage() {}

func (x *CertificateConfig_SubjectConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateConfig_SubjectConfig.ProtoReflect.Descriptor instead.
func (*CertificateConfig_SubjectConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{8, 0}
}

func (x *CertificateConfig_SubjectConfig) GetSubject() *Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *CertificateConfig_SubjectConfig) GetSubjectAltName() *SubjectAltNames {
	if x != nil {
		return x.SubjectAltName
	}
	return nil
}

// A KeyId identifies a specific public key, usually by hashing the public
// key.
type CertificateConfig_KeyId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The value of this KeyId encoded in lowercase hexadecimal. This
	// is most likely the 160 bit SHA-1 hash of the public key.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
}

func (x *CertificateConfig_KeyId) Reset() {
	*x = CertificateConfig_KeyId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateConfig_KeyId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateConfig_KeyId) ProtoMessage() {}

func (x *CertificateConfig_KeyId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateConfig_KeyId.ProtoReflect.Descriptor instead.
func (*CertificateConfig_KeyId) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{8, 1}
}

func (x *CertificateConfig_KeyId) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

// These values describe fields in an issued X.509 certificate such as the
// distinguished name, subject alternative names, serial number, and lifetime.
type CertificateDescription_SubjectDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains distinguished name fields such as the common name, location and
	// / organization.
	Subject *Subject `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	// The subject alternative name fields.
	SubjectAltName *SubjectAltNames `protobuf:"bytes,2,opt,name=subject_alt_name,json=subjectAltName,proto3" json:"subject_alt_name,omitempty"`
	// The serial number encoded in lowercase hexadecimal.
	HexSerialNumber string `protobuf:"bytes,3,opt,name=hex_serial_number,json=hexSerialNumber,proto3" json:"hex_serial_number,omitempty"`
	// For convenience, the actual lifetime of an issued certificate.
	Lifetime *durationpb.Duration `protobuf:"bytes,4,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// The time at which the certificate becomes valid.
	NotBeforeTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=not_before_time,json=notBeforeTime,proto3" json:"not_before_time,omitempty"`
	// The time after which the certificate is expired.
	// Per RFC 5280, the validity period for a certificate is the period of time
	// from not_before_time through not_after_time, inclusive.
	// Corresponds to 'not_before_time' + 'lifetime' - 1 second.
	NotAfterTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=not_after_time,json=notAfterTime,proto3" json:"not_after_time,omitempty"`
}

func (x *CertificateDescription_SubjectDescription) Reset() {
	*x = CertificateDescription_SubjectDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateDescription_SubjectDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateDescription_SubjectDescription) ProtoMessage() {}

func (x *CertificateDescription_SubjectDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateDescription_SubjectDescription.ProtoReflect.Descriptor instead.
func (*CertificateDescription_SubjectDescription) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{9, 0}
}

func (x *CertificateDescription_SubjectDescription) GetSubject() *Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *CertificateDescription_SubjectDescription) GetSubjectAltName() *SubjectAltNames {
	if x != nil {
		return x.SubjectAltName
	}
	return nil
}

func (x *CertificateDescription_SubjectDescription) GetHexSerialNumber() string {
	if x != nil {
		return x.HexSerialNumber
	}
	return ""
}

func (x *CertificateDescription_SubjectDescription) GetLifetime() *durationpb.Duration {
	if x != nil {
		return x.Lifetime
	}
	return nil
}

func (x *CertificateDescription_SubjectDescription) GetNotBeforeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NotBeforeTime
	}
	return nil
}

func (x *CertificateDescription_SubjectDescription) GetNotAfterTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NotAfterTime
	}
	return nil
}

// A KeyId identifies a specific public key, usually by hashing the public
// key.
type CertificateDescription_KeyId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The value of this KeyId encoded in lowercase hexadecimal. This
	// is most likely the 160 bit SHA-1 hash of the public key.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
}

func (x *CertificateDescription_KeyId) Reset() {
	*x = CertificateDescription_KeyId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateDescription_KeyId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateDescription_KeyId) ProtoMessage() {}

func (x *CertificateDescription_KeyId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateDescription_KeyId.ProtoReflect.Descriptor instead.
func (*CertificateDescription_KeyId) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{9, 1}
}

func (x *CertificateDescription_KeyId) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

// A group of fingerprints for the x509 certificate.
type CertificateDescription_CertificateFingerprint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SHA 256 hash, encoded in hexadecimal, of the DER x509 certificate.
	Sha256Hash string `protobuf:"bytes,1,opt,name=sha256_hash,json=sha256Hash,proto3" json:"sha256_hash,omitempty"`
}

func (x *CertificateDescription_CertificateFingerprint) Reset() {
	*x = CertificateDescription_CertificateFingerprint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateDescription_CertificateFingerprint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateDescription_CertificateFingerprint) ProtoMessage() {}

func (x *CertificateDescription_CertificateFingerprint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateDescription_CertificateFingerprint.ProtoReflect.Descriptor instead.
func (*CertificateDescription_CertificateFingerprint) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{9, 2}
}

func (x *CertificateDescription_CertificateFingerprint) GetSha256Hash() string {
	if x != nil {
		return x.Sha256Hash
	}
	return ""
}

// [KeyUsage.KeyUsageOptions][google.cloud.security.privateca.v1.KeyUsage.KeyUsageOptions]
// corresponds to the key usage values described in
// https://tools.ietf.org/html/rfc5280#section-4.2.1.3.
type KeyUsage_KeyUsageOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key may be used for digital signatures.
	DigitalSignature bool `protobuf:"varint,1,opt,name=digital_signature,json=digitalSignature,proto3" json:"digital_signature,omitempty"`
	// The key may be used for cryptographic commitments. Note that this may
	// also be referred to as "non-repudiation".
	ContentCommitment bool `protobuf:"varint,2,opt,name=content_commitment,json=contentCommitment,proto3" json:"content_commitment,omitempty"`
	// The key may be used to encipher other keys.
	KeyEncipherment bool `protobuf:"varint,3,opt,name=key_encipherment,json=keyEncipherment,proto3" json:"key_encipherment,omitempty"`
	// The key may be used to encipher data.
	DataEncipherment bool `protobuf:"varint,4,opt,name=data_encipherment,json=dataEncipherment,proto3" json:"data_encipherment,omitempty"`
	// The key may be used in a key agreement protocol.
	KeyAgreement bool `protobuf:"varint,5,opt,name=key_agreement,json=keyAgreement,proto3" json:"key_agreement,omitempty"`
	// The key may be used to sign certificates.
	CertSign bool `protobuf:"varint,6,opt,name=cert_sign,json=certSign,proto3" json:"cert_sign,omitempty"`
	// The key may be used sign certificate revocation lists.
	CrlSign bool `protobuf:"varint,7,opt,name=crl_sign,json=crlSign,proto3" json:"crl_sign,omitempty"`
	// The key may be used to encipher only.
	EncipherOnly bool `protobuf:"varint,8,opt,name=encipher_only,json=encipherOnly,proto3" json:"encipher_only,omitempty"`
	// The key may be used to decipher only.
	DecipherOnly bool `protobuf:"varint,9,opt,name=decipher_only,json=decipherOnly,proto3" json:"decipher_only,omitempty"`
}

func (x *KeyUsage_KeyUsageOptions) Reset() {
	*x = KeyUsage_KeyUsageOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyUsage_KeyUsageOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyUsage_KeyUsageOptions) ProtoMessage() {}

func (x *KeyUsage_KeyUsageOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyUsage_KeyUsageOptions.ProtoReflect.Descriptor instead.
func (*KeyUsage_KeyUsageOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{12, 0}
}

func (x *KeyUsage_KeyUsageOptions) GetDigitalSignature() bool {
	if x != nil {
		return x.DigitalSignature
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetContentCommitment() bool {
	if x != nil {
		return x.ContentCommitment
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetKeyEncipherment() bool {
	if x != nil {
		return x.KeyEncipherment
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetDataEncipherment() bool {
	if x != nil {
		return x.DataEncipherment
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetKeyAgreement() bool {
	if x != nil {
		return x.KeyAgreement
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetCertSign() bool {
	if x != nil {
		return x.CertSign
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetCrlSign() bool {
	if x != nil {
		return x.CrlSign
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetEncipherOnly() bool {
	if x != nil {
		return x.EncipherOnly
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetDecipherOnly() bool {
	if x != nil {
		return x.DecipherOnly
	}
	return false
}

// [KeyUsage.ExtendedKeyUsageOptions][google.cloud.security.privateca.v1.KeyUsage.ExtendedKeyUsageOptions]
// has fields that correspond to certain common OIDs that could be specified
// as an extended key usage value.
type KeyUsage_ExtendedKeyUsageOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW
	// server authentication", though regularly used for non-WWW TLS.
	ServerAuth bool `protobuf:"varint,1,opt,name=server_auth,json=serverAuth,proto3" json:"server_auth,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW
	// client authentication", though regularly used for non-WWW TLS.
	ClientAuth bool `protobuf:"varint,2,opt,name=client_auth,json=clientAuth,proto3" json:"client_auth,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of
	// downloadable executable code client authentication".
	CodeSigning bool `protobuf:"varint,3,opt,name=code_signing,json=codeSigning,proto3" json:"code_signing,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email
	// protection".
	EmailProtection bool `protobuf:"varint,4,opt,name=email_protection,json=emailProtection,proto3" json:"email_protection,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding
	// the hash of an object to a time".
	TimeStamping bool `protobuf:"varint,5,opt,name=time_stamping,json=timeStamping,proto3" json:"time_stamping,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing
	// OCSP responses".
	OcspSigning bool `protobuf:"varint,6,opt,name=ocsp_signing,json=ocspSigning,proto3" json:"ocsp_signing,omitempty"`
}

func (x *KeyUsage_ExtendedKeyUsageOptions) Reset() {
	*x = KeyUsage_ExtendedKeyUsageOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyUsage_ExtendedKeyUsageOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyUsage_ExtendedKeyUsageOptions) ProtoMessage() {}

func (x *KeyUsage_ExtendedKeyUsageOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1_resources_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyUsage_ExtendedKeyUsageOptions.ProtoReflect.Descriptor instead.
func (*KeyUsage_ExtendedKeyUsageOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP(), []int{12, 1}
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetServerAuth() bool {
	if x != nil {
		return x.ServerAuth
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetClientAuth() bool {
	if x != nil {
		return x.ClientAuth
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetCodeSigning() bool {
	if x != nil {
		return x.CodeSigning
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetEmailProtection() bool {
	if x != nil {
		return x.EmailProtection
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetTimeStamping() bool {
	if x != nil {
		return x.TimeStamping
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetOcspSigning() bool {
	if x != nil {
		return x.OcspSigning
	}
	return false
}

var File_google_cloud_security_privateca_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_security_privateca_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63,
	0x61, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8b, 0x12,
	0x0a, 0x14, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x59, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x55, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3d, 0x0a, 0x08, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06,
	0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x08, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65,
	0x12, 0x6a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x4b, 0x65, 0x79,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x06, 0xe0, 0x41, 0x02,
	0xe0, 0x41, 0x05, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x69, 0x0a, 0x12,
	0x73, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75,
	0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a, 0x04, 0x74, 0x69, 0x65, 0x72, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x50, 0x6f, 0x6f,
	0x6c, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x69, 0x65,
	0x72, 0x12, 0x59, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x33, 0x0a, 0x13,
	0x70, 0x65, 0x6d, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x70, 0x65, 0x6d, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x73, 0x12, 0x7f, 0x0a, 0x1b, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x67, 0x63, 0x73,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x69, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x6c, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x6c,
	0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x6f, 0x0a, 0x0a,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x39, 0x0a, 0x19, 0x63, 0x61,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x63,
	0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x55, 0x72, 0x6c, 0x12, 0x26, 0x0a, 0x0f, 0x63, 0x72, 0x6c, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d,
	0x63, 0x72, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x6c, 0x73, 0x1a, 0xbf, 0x01,
	0x0a, 0x0e, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x33, 0x0a, 0x15, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x12, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x48, 0x00, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68,
	0x6d, 0x42, 0x0c, 0x0a, 0x0a, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3e, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x45, 0x4c, 0x46,
	0x5f, 0x53, 0x49, 0x47, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x55, 0x42,
	0x4f, 0x52, 0x44, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x10, 0x02, 0x22, 0x70, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x41, 0x47, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x53,
	0x45, 0x52, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x05, 0x22, 0xfc, 0x01, 0x0a,
	0x11, 0x53, 0x69, 0x67, 0x6e, 0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x48, 0x41, 0x53, 0x48, 0x5f,
	0x41, 0x4c, 0x47, 0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x53, 0x41, 0x5f, 0x50,
	0x53, 0x53, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x01,
	0x12, 0x17, 0x0a, 0x13, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x33, 0x30, 0x37, 0x32,
	0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x53, 0x41,
	0x5f, 0x50, 0x53, 0x53, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36,
	0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f,
	0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x06, 0x12, 0x19, 0x0a,
	0x15, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f,
	0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x07, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x53, 0x41, 0x5f,
	0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35,
	0x36, 0x10, 0x08, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x43, 0x5f, 0x50, 0x32, 0x35, 0x36, 0x5f, 0x53,
	0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x43, 0x5f, 0x50, 0x33,
	0x38, 0x34, 0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x05, 0x3a, 0x9d, 0x01, 0xea, 0x41,
	0x99, 0x01, 0x0a, 0x2d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x12, 0x68, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x2f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x7d, 0x22, 0xbd, 0x11, 0x0a, 0x06,
	0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x4b, 0x0a, 0x04, 0x74, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x42, 0x06,
	0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x74, 0x69, 0x65, 0x72, 0x12, 0x67, 0x0a, 0x0f,
	0x69, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x50, 0x6f, 0x6f,
	0x6c, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x69, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x70, 0x0a, 0x12, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x50,
	0x6f, 0x6f, 0x6c, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x66, 0x0a, 0x11,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x63, 0x61, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x12, 0x24,
	0x0a, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x63, 0x72, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x43, 0x72, 0x6c, 0x1a, 0xde, 0x0b, 0x0a, 0x0e, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x79, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x49,
	0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x12, 0x49, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x6c, 0x69,
	0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d, 0x61,
	0x78, 0x69, 0x6d, 0x75, 0x6d, 0x4c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x82, 0x01,
	0x0a, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x73, 0x12, 0x60, 0x0a, 0x0f, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x2e, 0x58, 0x35, 0x30, 0x39, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x12, 0x7a, 0x0a, 0x14, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73,
	0x12, 0x7f, 0x0a, 0x16, 0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x70, 0x61, 0x73, 0x73,
	0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x1a, 0x8d, 0x05, 0x0a, 0x0e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4b, 0x65, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x67, 0x0a, 0x03, 0x72, 0x73, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x49, 0x73,
	0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x6c, 0x6c,
	0x6f, 0x77, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x73, 0x61, 0x4b,
	0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x03, 0x72, 0x73, 0x61, 0x12, 0x7b, 0x0a,
	0x0e, 0x65, 0x6c, 0x6c, 0x69, 0x70, 0x74, 0x69, 0x63, 0x5f, 0x63, 0x75, 0x72, 0x76, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x50, 0x6f, 0x6f,
	0x6c, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x45, 0x63, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x65, 0x6c, 0x6c,
	0x69, 0x70, 0x74, 0x69, 0x63, 0x43, 0x75, 0x72, 0x76, 0x65, 0x1a, 0x6a, 0x0a, 0x0a, 0x52, 0x73,
	0x61, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x75, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x75, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x75, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x75, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x9c, 0x02, 0x0a, 0x09, 0x45, 0x63, 0x4b, 0x65, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x9d, 0x01, 0x0a, 0x13, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x49,
	0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x63, 0x4b,
	0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x63, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x12, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x22, 0x6f, 0x0a, 0x14, 0x45, 0x63, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x26, 0x0a, 0x22,
	0x45, 0x43, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x41, 0x4c, 0x47,
	0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x50, 0x32,
	0x35, 0x36, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x50, 0x33,
	0x38, 0x34, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x45, 0x44, 0x44, 0x53, 0x41, 0x5f, 0x32, 0x35,
	0x35, 0x31, 0x39, 0x10, 0x03, 0x42, 0x0a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x1a, 0x91, 0x01, 0x0a, 0x0d, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x18, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x73, 0x72,
	0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x43, 0x73, 0x72, 0x42, 0x61, 0x73, 0x65, 0x64, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x42, 0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x61, 0x73, 0x65, 0x64, 0x49, 0x73, 0x73,
	0x75, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x38, 0x0a, 0x04, 0x54, 0x69, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x49, 0x45, 0x52,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x44, 0x45, 0x56, 0x4f, 0x50, 0x53, 0x10, 0x02, 0x3a, 0x5f, 0xea, 0x41, 0x5c, 0x0a,
	0x1f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c,
	0x12, 0x39, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x7b, 0x63, 0x61, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x22, 0xea, 0x09, 0x0a, 0x19,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x88, 0x01, 0x0a, 0x14, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x5f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63,
	0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x2e, 0x52,
	0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x07, 0x70,
	0x65, 0x6d, 0x5f, 0x63, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x70, 0x65, 0x6d, 0x43, 0x72, 0x6c, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x6c, 0x12, 0x5e, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x66, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a,
	0xf0, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xfa, 0x41, 0x26,
	0x0a, 0x24, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x68, 0x65, 0x78, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x68, 0x65, 0x78, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x61, 0x0a, 0x11, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x52, 0x10, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3a, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x50,
	0x45, 0x52, 0x53, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x3a, 0xdc, 0x01, 0xea, 0x41, 0xd8, 0x01,
	0x0a, 0x32, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x69, 0x73, 0x74, 0x12, 0xa1, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63,
	0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d,
	0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x7d, 0x2f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x7d, 0x22, 0x8a, 0x0c, 0x0a, 0x0b, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x07, 0x70, 0x65,
	0x6d, 0x5f, 0x63, 0x73, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x48, 0x00, 0x52, 0x06, 0x70, 0x65, 0x6d, 0x43, 0x73, 0x72, 0x12, 0x54, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x77, 0x0a, 0x1c, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2f, 0x0a, 0x2d,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x1a, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x3d, 0x0a, 0x08, 0x6c, 0x69, 0x66,
	0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x08,
	0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x67, 0x0a, 0x14, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x2e, 0x0a, 0x2c,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x13, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x5e, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x75, 0x0a, 0x12, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x52,
	0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x65, 0x6d, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x78, 0x0a, 0x17, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x37, 0x0a, 0x15, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0xb9, 0x01, 0x0a, 0x11, 0x52, 0x65, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x5f, 0x0a,
	0x10, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x0f, 0x72,
	0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x43,
	0x0a, 0x0f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0e, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x7f,
	0xea, 0x41, 0x7c, 0x0a, 0x24, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x54, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x7d, 0x42,
	0x14, 0x0a, 0x12, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xdf, 0x07, 0x0a, 0x13, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x48, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x69, 0x6d,
	0x75, 0x6d, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x4c, 0x69, 0x66, 0x65, 0x74, 0x69,
	0x6d, 0x65, 0x12, 0x64, 0x0a, 0x11, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x58, 0x35, 0x30, 0x39, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e,
	0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x7a, 0x0a, 0x14, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x13, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x7f, 0x0a, 0x16, 0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f,
	0x75, 0x67, 0x68, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15,
	0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x60, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x87, 0x01,
	0xea, 0x41, 0x83, 0x01, 0x0a, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x22, 0xe3, 0x08, 0x0a, 0x0e, 0x58, 0x35, 0x30, 0x39,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4e, 0x0a, 0x09, 0x6b, 0x65,
	0x79, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x6b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x60, 0x0a, 0x0a, 0x63, 0x61,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x58, 0x35, 0x30, 0x39, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x2e, 0x43, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x63, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x50, 0x0a, 0x0a,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x73, 0x12, 0x2d,
	0x0a, 0x10, 0x61, 0x69, 0x61, 0x5f, 0x6f, 0x63, 0x73, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x61,
	0x69, 0x61, 0x4f, 0x63, 0x73, 0x70, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x12, 0x72, 0x0a,
	0x10, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x58, 0x35, 0x30,
	0x39, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x4e, 0x61, 0x6d, 0x65,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x6e, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x73, 0x12, 0x6b, 0x0a, 0x15, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x58, 0x35, 0x30, 0x39, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x8e,
	0x01, 0x0a, 0x09, 0x43, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1d, 0x0a, 0x05,
	0x69, 0x73, 0x5f, 0x63, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x04, 0x69, 0x73, 0x43, 0x61, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x16, 0x6d,
	0x61, 0x78, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x01, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x50, 0x61, 0x74,
	0x68, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x69,
	0x73, 0x5f, 0x63, 0x61, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x1a,
	0xab, 0x03, 0x0a, 0x0f, 0x4e, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x12,
	0x2e, 0x0a, 0x13, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x6e, 0x73,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x70, 0x65,
	0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x44, 0x6e, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12,
	0x2c, 0x0a, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x6e, 0x73, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x64, 0x44, 0x6e, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x2e, 0x0a,
	0x13, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x74, 0x74, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x2c, 0x0a,
	0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x19, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x17,
	0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x75,
	0x72, 0x69, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x74, 0x74, 0x65, 0x64, 0x55, 0x72, 0x69, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0c, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x55, 0x72, 0x69, 0x73, 0x22, 0xe0, 0x02,
	0x0a, 0x11, 0x53, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x6c, 0x0a, 0x15, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x14, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x12, 0x7d, 0x0a, 0x10, 0x70, 0x65, 0x6d, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x5f,
	0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00,
	0x52, 0x0e, 0x70, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e,
	0x1a, 0x48, 0x0a, 0x16, 0x53, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x65,
	0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x65, 0x6d, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x73, 0x75,
	0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xaa, 0x01, 0x0a, 0x09, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x15,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x54, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x2e, 0x4b, 0x65, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x30, 0x0a, 0x09, 0x4b,
	0x65, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1a, 0x0a, 0x16, 0x4b, 0x45, 0x59, 0x5f,
	0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x45, 0x4d, 0x10, 0x01, 0x22, 0x80, 0x05,
	0x0a, 0x11, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x0e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x0b, 0x78, 0x35, 0x30, 0x39, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x58,
	0x35, 0x30, 0x39, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x78, 0x35, 0x30, 0x39, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x51,
	0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x12, 0x66, 0x0a, 0x0e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x75, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x1a, 0xbf, 0x01, 0x0a, 0x0d, 0x53, 0x75,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x07, 0x73,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x62, 0x0a, 0x10, 0x73, 0x75, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x61, 0x6c, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x75, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x23, 0x0a, 0x05, 0x4b,
	0x65, 0x79, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64,
	0x22, 0x96, 0x0a, 0x0a, 0x16, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7e, 0x0a, 0x13, 0x73,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x10, 0x78,
	0x35, 0x30, 0x39, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x58, 0x35, 0x30, 0x39, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0f, 0x78, 0x35, 0x30, 0x39, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x0a, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x66, 0x0a, 0x0e, 0x73, 0x75, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79,
	0x49, 0x64, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x49, 0x64,
	0x12, 0x6a, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x52, 0x0e, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x17,
	0x63, 0x72, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x63,
	0x72, 0x6c, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x1c, 0x61, 0x69, 0x61, 0x5f, 0x69, 0x73, 0x73, 0x75,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f,
	0x75, 0x72, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x19, 0x61, 0x69, 0x61, 0x49,
	0x73, 0x73, 0x75, 0x69, 0x6e, 0x67, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x7c, 0x0a, 0x10, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x66, 0x69,
	0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63,
	0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x52, 0x0f, 0x63, 0x65, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x1a, 0xa3, 0x03, 0x0a, 0x12, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x07, 0x73, 0x75,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x5d, 0x0a, 0x10, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x6c, 0x74,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x52, 0x0e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x2a, 0x0a, 0x11, 0x68, 0x65, 0x78, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x68, 0x65, 0x78,
	0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x35, 0x0a, 0x08,
	0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x69, 0x66, 0x65, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0f, 0x6e, 0x6f, 0x74, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x42, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x5f, 0x61,
	0x66, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x6e, 0x6f, 0x74,
	0x41, 0x66, 0x74, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x23, 0x0a, 0x05, 0x4b, 0x65, 0x79,
	0x49, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x1a, 0x39,
	0x0a, 0x16, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e,
	0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x32,
	0x35, 0x36, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73,
	0x68, 0x61, 0x32, 0x35, 0x36, 0x48, 0x61, 0x73, 0x68, 0x22, 0x35, 0x0a, 0x08, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x0e, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x50, 0x61, 0x74, 0x68,
	0x22, 0x9b, 0x01, 0x0a, 0x0d, 0x58, 0x35, 0x30, 0x39, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x63, 0x72, 0x69, 0x74, 0x69,
	0x63, 0x61, 0x6c, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xb2,
	0x07, 0x0a, 0x08, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x62, 0x0a, 0x0e, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x0c, 0x62, 0x61, 0x73, 0x65, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x72, 0x0a, 0x12, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x2e, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64,
	0x65, 0x64, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x10, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x6b, 0x0a, 0x1b, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x52, 0x18, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x1a, 0xec, 0x02, 0x0a, 0x0f, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x5f,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x29, 0x0a, 0x10, 0x6b, 0x65, 0x79, 0x5f, 0x65, 0x6e, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x6b, 0x65, 0x79, 0x45,
	0x6e, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x65, 0x6e, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x63, 0x69,
	0x70, 0x68, 0x65, 0x72, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f,
	0x61, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x6b, 0x65, 0x79, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x63, 0x65, 0x72, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x72,
	0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x72,
	0x6c, 0x53, 0x69, 0x67, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x69, 0x70, 0x68, 0x65,
	0x72, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x65, 0x6e,
	0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65,
	0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x64, 0x65, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x79, 0x1a,
	0xf1, 0x01, 0x0a, 0x17, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x63, 0x6f, 0x64, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67,
	0x12, 0x29, 0x0a, 0x10, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x6d, 0x70, 0x69, 0x6e, 0x67,
	0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x63, 0x73, 0x70, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6f, 0x63, 0x73, 0x70, 0x53, 0x69, 0x67, 0x6e,
	0x69, 0x6e, 0x67, 0x22, 0xa2, 0x02, 0x0a, 0x07, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6f, 0x73, 0x74, 0x61,
	0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f,
	0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xe2, 0x01, 0x0a, 0x0f, 0x53, 0x75, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09,
	0x64, 0x6e, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x64, 0x6e, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x72, 0x69,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x12, 0x27, 0x0a,
	0x0f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x70,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x73, 0x61, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x58, 0x35, 0x30, 0x39, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x53, 0x61, 0x6e, 0x73, 0x22, 0xc3, 0x02,
	0x0a, 0x1e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73,
	0x12, 0x3d, 0x0a, 0x0e, 0x63, 0x65, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x63, 0x65, 0x6c, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x44, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75,
	0x67, 0x68, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a, 0x23, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x6c, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x5f, 0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x1f, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x50,
	0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x88, 0x01, 0x01, 0x42, 0x1c, 0x0a,
	0x1a, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x42, 0x26, 0x0a, 0x24, 0x5f,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x6c,
	0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f,
	0x75, 0x67, 0x68, 0x22, 0xdc, 0x03, 0x0a, 0x1f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x10, 0x6b, 0x6e, 0x6f, 0x77,
	0x6e, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x66, 0x0a, 0x15, 0x61, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xc0, 0x01, 0x0a, 0x19, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a,
	0x27, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41,
	0x54, 0x45, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x42, 0x41,
	0x53, 0x45, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x45, 0x58, 0x54, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x55,
	0x53, 0x41, 0x47, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x5f, 0x4f, 0x50, 0x54,
	0x49, 0x4f, 0x4e, 0x53, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x49, 0x44, 0x53, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x49, 0x41, 0x5f, 0x4f, 0x43,
	0x53, 0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x53, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10,
	0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x54, 0x53,
	0x10, 0x06, 0x2a, 0x87, 0x02, 0x0a, 0x10, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x45, 0x56, 0x4f, 0x43,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4b, 0x45,
	0x59, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x4f, 0x4d, 0x49, 0x53, 0x45, 0x10, 0x01, 0x12, 0x24,
	0x0a, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x55,
	0x54, 0x48, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x4f, 0x4d, 0x49,
	0x53, 0x45, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x46, 0x46, 0x49, 0x4c, 0x49, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a,
	0x0a, 0x53, 0x55, 0x50, 0x45, 0x52, 0x53, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x1a, 0x0a,
	0x16, 0x43, 0x45, 0x53, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x46, 0x5f, 0x4f, 0x50,
	0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x45, 0x52,
	0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x48, 0x4f, 0x4c, 0x44, 0x10, 0x06, 0x12,
	0x17, 0x0a, 0x13, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x44, 0x52, 0x41, 0x57, 0x4e, 0x10, 0x07, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x54, 0x54, 0x52,
	0x49, 0x42, 0x55, 0x54, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f,
	0x43, 0x4f, 0x4d, 0x50, 0x52, 0x4f, 0x4d, 0x49, 0x53, 0x45, 0x10, 0x08, 0x2a, 0x5d, 0x0a, 0x12,
	0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x55, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41,
	0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x46, 0x4c, 0x45, 0x43, 0x54,
	0x45, 0x44, 0x5f, 0x53, 0x50, 0x49, 0x46, 0x46, 0x45, 0x10, 0x02, 0x42, 0xff, 0x01, 0x0a, 0x26,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x42, 0x17, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x61, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x44, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2f,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x70, 0x62, 0x3b, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x63, 0x61, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x41, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x41, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x3a, 0x3a,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x41, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_security_privateca_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_security_privateca_v1_resources_proto_rawDescData = file_google_cloud_security_privateca_v1_resources_proto_rawDesc
)

func file_google_cloud_security_privateca_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_security_privateca_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_security_privateca_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_security_privateca_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_security_privateca_v1_resources_proto_rawDescData
}

var file_google_cloud_security_privateca_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_google_cloud_security_privateca_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 42)
var file_google_cloud_security_privateca_v1_resources_proto_goTypes = []interface{}{
	(RevocationReason)(0),                       // 0: google.cloud.security.privateca.v1.RevocationReason
	(SubjectRequestMode)(0),                     // 1: google.cloud.security.privateca.v1.SubjectRequestMode
	(CertificateAuthority_Type)(0),              // 2: google.cloud.security.privateca.v1.CertificateAuthority.Type
	(CertificateAuthority_State)(0),             // 3: google.cloud.security.privateca.v1.CertificateAuthority.State
	(CertificateAuthority_SignHashAlgorithm)(0), // 4: google.cloud.security.privateca.v1.CertificateAuthority.SignHashAlgorithm
	(CaPool_Tier)(0),                            // 5: google.cloud.security.privateca.v1.CaPool.Tier
	(CaPool_IssuancePolicy_AllowedKeyType_EcKeyType_EcSignatureAlgorithm)(0), // 6: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType.EcKeyType.EcSignatureAlgorithm
	(CertificateRevocationList_State)(0),                                     // 7: google.cloud.security.privateca.v1.CertificateRevocationList.State
	(PublicKey_KeyFormat)(0),                                                 // 8: google.cloud.security.privateca.v1.PublicKey.KeyFormat
	(CertificateExtensionConstraints_KnownCertificateExtension)(0),           // 9: google.cloud.security.privateca.v1.CertificateExtensionConstraints.KnownCertificateExtension
	(*CertificateAuthority)(nil),                                             // 10: google.cloud.security.privateca.v1.CertificateAuthority
	(*CaPool)(nil),                                                           // 11: google.cloud.security.privateca.v1.CaPool
	(*CertificateRevocationList)(nil),                                        // 12: google.cloud.security.privateca.v1.CertificateRevocationList
	(*Certificate)(nil),                                                      // 13: google.cloud.security.privateca.v1.Certificate
	(*CertificateTemplate)(nil),                                              // 14: google.cloud.security.privateca.v1.CertificateTemplate
	(*X509Parameters)(nil),                                                   // 15: google.cloud.security.privateca.v1.X509Parameters
	(*SubordinateConfig)(nil),                                                // 16: google.cloud.security.privateca.v1.SubordinateConfig
	(*PublicKey)(nil),                                                        // 17: google.cloud.security.privateca.v1.PublicKey
	(*CertificateConfig)(nil),                                                // 18: google.cloud.security.privateca.v1.CertificateConfig
	(*CertificateDescription)(nil),                                           // 19: google.cloud.security.privateca.v1.CertificateDescription
	(*ObjectId)(nil),                                                         // 20: google.cloud.security.privateca.v1.ObjectId
	(*X509Extension)(nil),                                                    // 21: google.cloud.security.privateca.v1.X509Extension
	(*KeyUsage)(nil),                                                         // 22: google.cloud.security.privateca.v1.KeyUsage
	(*Subject)(nil),                                                          // 23: google.cloud.security.privateca.v1.Subject
	(*SubjectAltNames)(nil),                                                  // 24: google.cloud.security.privateca.v1.SubjectAltNames
	(*CertificateIdentityConstraints)(nil),                                   // 25: google.cloud.security.privateca.v1.CertificateIdentityConstraints
	(*CertificateExtensionConstraints)(nil),                                  // 26: google.cloud.security.privateca.v1.CertificateExtensionConstraints
	(*CertificateAuthority_AccessUrls)(nil),                                  // 27: google.cloud.security.privateca.v1.CertificateAuthority.AccessUrls
	(*CertificateAuthority_KeyVersionSpec)(nil),                              // 28: google.cloud.security.privateca.v1.CertificateAuthority.KeyVersionSpec
	nil,                              // 29: google.cloud.security.privateca.v1.CertificateAuthority.LabelsEntry
	(*CaPool_PublishingOptions)(nil), // 30: google.cloud.security.privateca.v1.CaPool.PublishingOptions
	(*CaPool_IssuancePolicy)(nil),    // 31: google.cloud.security.privateca.v1.CaPool.IssuancePolicy
	nil,                              // 32: google.cloud.security.privateca.v1.CaPool.LabelsEntry
	(*CaPool_IssuancePolicy_AllowedKeyType)(nil),            // 33: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType
	(*CaPool_IssuancePolicy_IssuanceModes)(nil),             // 34: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.IssuanceModes
	(*CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType)(nil), // 35: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType.RsaKeyType
	(*CaPool_IssuancePolicy_AllowedKeyType_EcKeyType)(nil),  // 36: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType.EcKeyType
	(*CertificateRevocationList_RevokedCertificate)(nil),    // 37: google.cloud.security.privateca.v1.CertificateRevocationList.RevokedCertificate
	nil,                                    // 38: google.cloud.security.privateca.v1.CertificateRevocationList.LabelsEntry
	(*Certificate_RevocationDetails)(nil),  // 39: google.cloud.security.privateca.v1.Certificate.RevocationDetails
	nil,                                    // 40: google.cloud.security.privateca.v1.Certificate.LabelsEntry
	nil,                                    // 41: google.cloud.security.privateca.v1.CertificateTemplate.LabelsEntry
	(*X509Parameters_CaOptions)(nil),       // 42: google.cloud.security.privateca.v1.X509Parameters.CaOptions
	(*X509Parameters_NameConstraints)(nil), // 43: google.cloud.security.privateca.v1.X509Parameters.NameConstraints
	(*SubordinateConfig_SubordinateConfigChain)(nil),      // 44: google.cloud.security.privateca.v1.SubordinateConfig.SubordinateConfigChain
	(*CertificateConfig_SubjectConfig)(nil),               // 45: google.cloud.security.privateca.v1.CertificateConfig.SubjectConfig
	(*CertificateConfig_KeyId)(nil),                       // 46: google.cloud.security.privateca.v1.CertificateConfig.KeyId
	(*CertificateDescription_SubjectDescription)(nil),     // 47: google.cloud.security.privateca.v1.CertificateDescription.SubjectDescription
	(*CertificateDescription_KeyId)(nil),                  // 48: google.cloud.security.privateca.v1.CertificateDescription.KeyId
	(*CertificateDescription_CertificateFingerprint)(nil), // 49: google.cloud.security.privateca.v1.CertificateDescription.CertificateFingerprint
	(*KeyUsage_KeyUsageOptions)(nil),                      // 50: google.cloud.security.privateca.v1.KeyUsage.KeyUsageOptions
	(*KeyUsage_ExtendedKeyUsageOptions)(nil),              // 51: google.cloud.security.privateca.v1.KeyUsage.ExtendedKeyUsageOptions
	(*durationpb.Duration)(nil),                           // 52: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                         // 53: google.protobuf.Timestamp
	(*expr.Expr)(nil),                                     // 54: google.type.Expr
}
var file_google_cloud_security_privateca_v1_resources_proto_depIdxs = []int32{
	2,  // 0: google.cloud.security.privateca.v1.CertificateAuthority.type:type_name -> google.cloud.security.privateca.v1.CertificateAuthority.Type
	18, // 1: google.cloud.security.privateca.v1.CertificateAuthority.config:type_name -> google.cloud.security.privateca.v1.CertificateConfig
	52, // 2: google.cloud.security.privateca.v1.CertificateAuthority.lifetime:type_name -> google.protobuf.Duration
	28, // 3: google.cloud.security.privateca.v1.CertificateAuthority.key_spec:type_name -> google.cloud.security.privateca.v1.CertificateAuthority.KeyVersionSpec
	16, // 4: google.cloud.security.privateca.v1.CertificateAuthority.subordinate_config:type_name -> google.cloud.security.privateca.v1.SubordinateConfig
	5,  // 5: google.cloud.security.privateca.v1.CertificateAuthority.tier:type_name -> google.cloud.security.privateca.v1.CaPool.Tier
	3,  // 6: google.cloud.security.privateca.v1.CertificateAuthority.state:type_name -> google.cloud.security.privateca.v1.CertificateAuthority.State
	19, // 7: google.cloud.security.privateca.v1.CertificateAuthority.ca_certificate_descriptions:type_name -> google.cloud.security.privateca.v1.CertificateDescription
	27, // 8: google.cloud.security.privateca.v1.CertificateAuthority.access_urls:type_name -> google.cloud.security.privateca.v1.CertificateAuthority.AccessUrls
	53, // 9: google.cloud.security.privateca.v1.CertificateAuthority.create_time:type_name -> google.protobuf.Timestamp
	53, // 10: google.cloud.security.privateca.v1.CertificateAuthority.update_time:type_name -> google.protobuf.Timestamp
	53, // 11: google.cloud.security.privateca.v1.CertificateAuthority.delete_time:type_name -> google.protobuf.Timestamp
	53, // 12: google.cloud.security.privateca.v1.CertificateAuthority.expire_time:type_name -> google.protobuf.Timestamp
	29, // 13: google.cloud.security.privateca.v1.CertificateAuthority.labels:type_name -> google.cloud.security.privateca.v1.CertificateAuthority.LabelsEntry
	5,  // 14: google.cloud.security.privateca.v1.CaPool.tier:type_name -> google.cloud.security.privateca.v1.CaPool.Tier
	31, // 15: google.cloud.security.privateca.v1.CaPool.issuance_policy:type_name -> google.cloud.security.privateca.v1.CaPool.IssuancePolicy
	30, // 16: google.cloud.security.privateca.v1.CaPool.publishing_options:type_name -> google.cloud.security.privateca.v1.CaPool.PublishingOptions
	32, // 17: google.cloud.security.privateca.v1.CaPool.labels:type_name -> google.cloud.security.privateca.v1.CaPool.LabelsEntry
	37, // 18: google.cloud.security.privateca.v1.CertificateRevocationList.revoked_certificates:type_name -> google.cloud.security.privateca.v1.CertificateRevocationList.RevokedCertificate
	7,  // 19: google.cloud.security.privateca.v1.CertificateRevocationList.state:type_name -> google.cloud.security.privateca.v1.CertificateRevocationList.State
	53, // 20: google.cloud.security.privateca.v1.CertificateRevocationList.create_time:type_name -> google.protobuf.Timestamp
	53, // 21: google.cloud.security.privateca.v1.CertificateRevocationList.update_time:type_name -> google.protobuf.Timestamp
	38, // 22: google.cloud.security.privateca.v1.CertificateRevocationList.labels:type_name -> google.cloud.security.privateca.v1.CertificateRevocationList.LabelsEntry
	18, // 23: google.cloud.security.privateca.v1.Certificate.config:type_name -> google.cloud.security.privateca.v1.CertificateConfig
	52, // 24: google.cloud.security.privateca.v1.Certificate.lifetime:type_name -> google.protobuf.Duration
	1,  // 25: google.cloud.security.privateca.v1.Certificate.subject_mode:type_name -> google.cloud.security.privateca.v1.SubjectRequestMode
	39, // 26: google.cloud.security.privateca.v1.Certificate.revocation_details:type_name -> google.cloud.security.privateca.v1.Certificate.RevocationDetails
	19, // 27: google.cloud.security.privateca.v1.Certificate.certificate_description:type_name -> google.cloud.security.privateca.v1.CertificateDescription
	53, // 28: google.cloud.security.privateca.v1.Certificate.create_time:type_name -> google.protobuf.Timestamp
	53, // 29: google.cloud.security.privateca.v1.Certificate.update_time:type_name -> google.protobuf.Timestamp
	40, // 30: google.cloud.security.privateca.v1.Certificate.labels:type_name -> google.cloud.security.privateca.v1.Certificate.LabelsEntry
	52, // 31: google.cloud.security.privateca.v1.CertificateTemplate.maximum_lifetime:type_name -> google.protobuf.Duration
	15, // 32: google.cloud.security.privateca.v1.CertificateTemplate.predefined_values:type_name -> google.cloud.security.privateca.v1.X509Parameters
	25, // 33: google.cloud.security.privateca.v1.CertificateTemplate.identity_constraints:type_name -> google.cloud.security.privateca.v1.CertificateIdentityConstraints
	26, // 34: google.cloud.security.privateca.v1.CertificateTemplate.passthrough_extensions:type_name -> google.cloud.security.privateca.v1.CertificateExtensionConstraints
	53, // 35: google.cloud.security.privateca.v1.CertificateTemplate.create_time:type_name -> google.protobuf.Timestamp
	53, // 36: google.cloud.security.privateca.v1.CertificateTemplate.update_time:type_name -> google.protobuf.Timestamp
	41, // 37: google.cloud.security.privateca.v1.CertificateTemplate.labels:type_name -> google.cloud.security.privateca.v1.CertificateTemplate.LabelsEntry
	22, // 38: google.cloud.security.privateca.v1.X509Parameters.key_usage:type_name -> google.cloud.security.privateca.v1.KeyUsage
	42, // 39: google.cloud.security.privateca.v1.X509Parameters.ca_options:type_name -> google.cloud.security.privateca.v1.X509Parameters.CaOptions
	20, // 40: google.cloud.security.privateca.v1.X509Parameters.policy_ids:type_name -> google.cloud.security.privateca.v1.ObjectId
	43, // 41: google.cloud.security.privateca.v1.X509Parameters.name_constraints:type_name -> google.cloud.security.privateca.v1.X509Parameters.NameConstraints
	21, // 42: google.cloud.security.privateca.v1.X509Parameters.additional_extensions:type_name -> google.cloud.security.privateca.v1.X509Extension
	44, // 43: google.cloud.security.privateca.v1.SubordinateConfig.pem_issuer_chain:type_name -> google.cloud.security.privateca.v1.SubordinateConfig.SubordinateConfigChain
	8,  // 44: google.cloud.security.privateca.v1.PublicKey.format:type_name -> google.cloud.security.privateca.v1.PublicKey.KeyFormat
	45, // 45: google.cloud.security.privateca.v1.CertificateConfig.subject_config:type_name -> google.cloud.security.privateca.v1.CertificateConfig.SubjectConfig
	15, // 46: google.cloud.security.privateca.v1.CertificateConfig.x509_config:type_name -> google.cloud.security.privateca.v1.X509Parameters
	17, // 47: google.cloud.security.privateca.v1.CertificateConfig.public_key:type_name -> google.cloud.security.privateca.v1.PublicKey
	46, // 48: google.cloud.security.privateca.v1.CertificateConfig.subject_key_id:type_name -> google.cloud.security.privateca.v1.CertificateConfig.KeyId
	47, // 49: google.cloud.security.privateca.v1.CertificateDescription.subject_description:type_name -> google.cloud.security.privateca.v1.CertificateDescription.SubjectDescription
	15, // 50: google.cloud.security.privateca.v1.CertificateDescription.x509_description:type_name -> google.cloud.security.privateca.v1.X509Parameters
	17, // 51: google.cloud.security.privateca.v1.CertificateDescription.public_key:type_name -> google.cloud.security.privateca.v1.PublicKey
	48, // 52: google.cloud.security.privateca.v1.CertificateDescription.subject_key_id:type_name -> google.cloud.security.privateca.v1.CertificateDescription.KeyId
	48, // 53: google.cloud.security.privateca.v1.CertificateDescription.authority_key_id:type_name -> google.cloud.security.privateca.v1.CertificateDescription.KeyId
	49, // 54: google.cloud.security.privateca.v1.CertificateDescription.cert_fingerprint:type_name -> google.cloud.security.privateca.v1.CertificateDescription.CertificateFingerprint
	20, // 55: google.cloud.security.privateca.v1.X509Extension.object_id:type_name -> google.cloud.security.privateca.v1.ObjectId
	50, // 56: google.cloud.security.privateca.v1.KeyUsage.base_key_usage:type_name -> google.cloud.security.privateca.v1.KeyUsage.KeyUsageOptions
	51, // 57: google.cloud.security.privateca.v1.KeyUsage.extended_key_usage:type_name -> google.cloud.security.privateca.v1.KeyUsage.ExtendedKeyUsageOptions
	20, // 58: google.cloud.security.privateca.v1.KeyUsage.unknown_extended_key_usages:type_name -> google.cloud.security.privateca.v1.ObjectId
	21, // 59: google.cloud.security.privateca.v1.SubjectAltNames.custom_sans:type_name -> google.cloud.security.privateca.v1.X509Extension
	54, // 60: google.cloud.security.privateca.v1.CertificateIdentityConstraints.cel_expression:type_name -> google.type.Expr
	9,  // 61: google.cloud.security.privateca.v1.CertificateExtensionConstraints.known_extensions:type_name -> google.cloud.security.privateca.v1.CertificateExtensionConstraints.KnownCertificateExtension
	20, // 62: google.cloud.security.privateca.v1.CertificateExtensionConstraints.additional_extensions:type_name -> google.cloud.security.privateca.v1.ObjectId
	4,  // 63: google.cloud.security.privateca.v1.CertificateAuthority.KeyVersionSpec.algorithm:type_name -> google.cloud.security.privateca.v1.CertificateAuthority.SignHashAlgorithm
	33, // 64: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.allowed_key_types:type_name -> google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType
	52, // 65: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.maximum_lifetime:type_name -> google.protobuf.Duration
	34, // 66: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.allowed_issuance_modes:type_name -> google.cloud.security.privateca.v1.CaPool.IssuancePolicy.IssuanceModes
	15, // 67: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.baseline_values:type_name -> google.cloud.security.privateca.v1.X509Parameters
	25, // 68: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.identity_constraints:type_name -> google.cloud.security.privateca.v1.CertificateIdentityConstraints
	26, // 69: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.passthrough_extensions:type_name -> google.cloud.security.privateca.v1.CertificateExtensionConstraints
	35, // 70: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType.rsa:type_name -> google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType.RsaKeyType
	36, // 71: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType.elliptic_curve:type_name -> google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType.EcKeyType
	6,  // 72: google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType.EcKeyType.signature_algorithm:type_name -> google.cloud.security.privateca.v1.CaPool.IssuancePolicy.AllowedKeyType.EcKeyType.EcSignatureAlgorithm
	0,  // 73: google.cloud.security.privateca.v1.CertificateRevocationList.RevokedCertificate.revocation_reason:type_name -> google.cloud.security.privateca.v1.RevocationReason
	0,  // 74: google.cloud.security.privateca.v1.Certificate.RevocationDetails.revocation_state:type_name -> google.cloud.security.privateca.v1.RevocationReason
	53, // 75: google.cloud.security.privateca.v1.Certificate.RevocationDetails.revocation_time:type_name -> google.protobuf.Timestamp
	23, // 76: google.cloud.security.privateca.v1.CertificateConfig.SubjectConfig.subject:type_name -> google.cloud.security.privateca.v1.Subject
	24, // 77: google.cloud.security.privateca.v1.CertificateConfig.SubjectConfig.subject_alt_name:type_name -> google.cloud.security.privateca.v1.SubjectAltNames
	23, // 78: google.cloud.security.privateca.v1.CertificateDescription.SubjectDescription.subject:type_name -> google.cloud.security.privateca.v1.Subject
	24, // 79: google.cloud.security.privateca.v1.CertificateDescription.SubjectDescription.subject_alt_name:type_name -> google.cloud.security.privateca.v1.SubjectAltNames
	52, // 80: google.cloud.security.privateca.v1.CertificateDescription.SubjectDescription.lifetime:type_name -> google.protobuf.Duration
	53, // 81: google.cloud.security.privateca.v1.CertificateDescription.SubjectDescription.not_before_time:type_name -> google.protobuf.Timestamp
	53, // 82: google.cloud.security.privateca.v1.CertificateDescription.SubjectDescription.not_after_time:type_name -> google.protobuf.Timestamp
	83, // [83:83] is the sub-list for method output_type
	83, // [83:83] is the sub-list for method input_type
	83, // [83:83] is the sub-list for extension type_name
	83, // [83:83] is the sub-list for extension extendee
	0,  // [0:83] is the sub-list for field type_name
}

func init() { file_google_cloud_security_privateca_v1_resources_proto_init() }
func file_google_cloud_security_privateca_v1_resources_proto_init() {
	if File_google_cloud_security_privateca_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CaPool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateRevocationList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*X509Parameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubordinateConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*X509Extension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubjectAltNames); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateIdentityConstraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateExtensionConstraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority_AccessUrls); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority_KeyVersionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CaPool_PublishingOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CaPool_IssuancePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CaPool_IssuancePolicy_AllowedKeyType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CaPool_IssuancePolicy_IssuanceModes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CaPool_IssuancePolicy_AllowedKeyType_RsaKeyType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CaPool_IssuancePolicy_AllowedKeyType_EcKeyType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateRevocationList_RevokedCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate_RevocationDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*X509Parameters_CaOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*X509Parameters_NameConstraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubordinateConfig_SubordinateConfigChain); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateConfig_SubjectConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateConfig_KeyId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateDescription_SubjectDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateDescription_KeyId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateDescription_CertificateFingerprint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyUsage_KeyUsageOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1_resources_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyUsage_ExtendedKeyUsageOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_security_privateca_v1_resources_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Certificate_PemCsr)(nil),
		(*Certificate_Config)(nil),
	}
	file_google_cloud_security_privateca_v1_resources_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*SubordinateConfig_CertificateAuthority)(nil),
		(*SubordinateConfig_PemIssuerChain)(nil),
	}
	file_google_cloud_security_privateca_v1_resources_proto_msgTypes[15].OneofWrappers = []interface{}{}
	file_google_cloud_security_privateca_v1_resources_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion)(nil),
		(*CertificateAuthority_KeyVersionSpec_Algorithm)(nil),
	}
	file_google_cloud_security_privateca_v1_resources_proto_msgTypes[23].OneofWrappers = []interface{}{
		(*CaPool_IssuancePolicy_AllowedKeyType_Rsa)(nil),
		(*CaPool_IssuancePolicy_AllowedKeyType_EllipticCurve)(nil),
	}
	file_google_cloud_security_privateca_v1_resources_proto_msgTypes[32].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_security_privateca_v1_resources_proto_rawDesc,
			NumEnums:      10,
			NumMessages:   42,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_security_privateca_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_security_privateca_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_security_privateca_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_security_privateca_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_security_privateca_v1_resources_proto = out.File
	file_google_cloud_security_privateca_v1_resources_proto_rawDesc = nil
	file_google_cloud_security_privateca_v1_resources_proto_goTypes = nil
	file_google_cloud_security_privateca_v1_resources_proto_depIdxs = nil
}
