// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/retail/v2/common.proto

package retailpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// At which level we offer configuration for attributes.
type AttributeConfigLevel int32

const (
	// Value used when unset. In this case, server behavior defaults to
	// [CATALOG_LEVEL_ATTRIBUTE_CONFIG][google.cloud.retail.v2.AttributeConfigLevel.CATALOG_LEVEL_ATTRIBUTE_CONFIG].
	AttributeConfigLevel_ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED AttributeConfigLevel = 0
	// At this level, we honor the attribute configurations set in
	// [Product.attributes][google.cloud.retail.v2.Product.attributes].
	AttributeConfigLevel_PRODUCT_LEVEL_ATTRIBUTE_CONFIG AttributeConfigLevel = 1
	// At this level, we honor the attribute configurations set in
	// [CatalogConfig.attribute_configs][].
	AttributeConfigLevel_CATALOG_LEVEL_ATTRIBUTE_CONFIG AttributeConfigLevel = 2
)

// Enum value maps for AttributeConfigLevel.
var (
	AttributeConfigLevel_name = map[int32]string{
		0: "ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED",
		1: "PRODUCT_LEVEL_ATTRIBUTE_CONFIG",
		2: "CATALOG_LEVEL_ATTRIBUTE_CONFIG",
	}
	AttributeConfigLevel_value = map[string]int32{
		"ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED": 0,
		"PRODUCT_LEVEL_ATTRIBUTE_CONFIG":     1,
		"CATALOG_LEVEL_ATTRIBUTE_CONFIG":     2,
	}
)

func (x AttributeConfigLevel) Enum() *AttributeConfigLevel {
	p := new(AttributeConfigLevel)
	*p = x
	return p
}

func (x AttributeConfigLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttributeConfigLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2_common_proto_enumTypes[0].Descriptor()
}

func (AttributeConfigLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2_common_proto_enumTypes[0]
}

func (x AttributeConfigLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttributeConfigLevel.Descriptor instead.
func (AttributeConfigLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{0}
}

// The type of solution.
type SolutionType int32

const (
	// Default value.
	SolutionType_SOLUTION_TYPE_UNSPECIFIED SolutionType = 0
	// Used for Recommendations AI.
	SolutionType_SOLUTION_TYPE_RECOMMENDATION SolutionType = 1
	// Used for Retail Search.
	SolutionType_SOLUTION_TYPE_SEARCH SolutionType = 2
)

// Enum value maps for SolutionType.
var (
	SolutionType_name = map[int32]string{
		0: "SOLUTION_TYPE_UNSPECIFIED",
		1: "SOLUTION_TYPE_RECOMMENDATION",
		2: "SOLUTION_TYPE_SEARCH",
	}
	SolutionType_value = map[string]int32{
		"SOLUTION_TYPE_UNSPECIFIED":    0,
		"SOLUTION_TYPE_RECOMMENDATION": 1,
		"SOLUTION_TYPE_SEARCH":         2,
	}
)

func (x SolutionType) Enum() *SolutionType {
	p := new(SolutionType)
	*p = x
	return p
}

func (x SolutionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SolutionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2_common_proto_enumTypes[1].Descriptor()
}

func (SolutionType) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2_common_proto_enumTypes[1]
}

func (x SolutionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SolutionType.Descriptor instead.
func (SolutionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1}
}

// If filtering for recommendations is enabled.
type RecommendationsFilteringOption int32

const (
	// Value used when unset.
	// In this case, server behavior defaults to
	// [RECOMMENDATIONS_FILTERING_DISABLED][google.cloud.retail.v2.RecommendationsFilteringOption.RECOMMENDATIONS_FILTERING_DISABLED].
	RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED RecommendationsFilteringOption = 0
	// Recommendation filtering is disabled.
	RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_DISABLED RecommendationsFilteringOption = 1
	// Recommendation filtering is enabled.
	RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_ENABLED RecommendationsFilteringOption = 3
)

// Enum value maps for RecommendationsFilteringOption.
var (
	RecommendationsFilteringOption_name = map[int32]string{
		0: "RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED",
		1: "RECOMMENDATIONS_FILTERING_DISABLED",
		3: "RECOMMENDATIONS_FILTERING_ENABLED",
	}
	RecommendationsFilteringOption_value = map[string]int32{
		"RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED": 0,
		"RECOMMENDATIONS_FILTERING_DISABLED":           1,
		"RECOMMENDATIONS_FILTERING_ENABLED":            3,
	}
)

func (x RecommendationsFilteringOption) Enum() *RecommendationsFilteringOption {
	p := new(RecommendationsFilteringOption)
	*p = x
	return p
}

func (x RecommendationsFilteringOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecommendationsFilteringOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2_common_proto_enumTypes[2].Descriptor()
}

func (RecommendationsFilteringOption) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2_common_proto_enumTypes[2]
}

func (x RecommendationsFilteringOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecommendationsFilteringOption.Descriptor instead.
func (RecommendationsFilteringOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{2}
}

// The use case of Cloud Retail Search.
type SearchSolutionUseCase int32

const (
	// The value when it's unspecified. In this case, server behavior defaults to
	// [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH].
	SearchSolutionUseCase_SEARCH_SOLUTION_USE_CASE_UNSPECIFIED SearchSolutionUseCase = 0
	// Search use case. Expects the traffic has a non-empty
	// [query][google.cloud.retail.v2.SearchRequest.query].
	SearchSolutionUseCase_SEARCH_SOLUTION_USE_CASE_SEARCH SearchSolutionUseCase = 1
	// Browse use case. Expects the traffic has an empty
	// [query][google.cloud.retail.v2.SearchRequest.query].
	SearchSolutionUseCase_SEARCH_SOLUTION_USE_CASE_BROWSE SearchSolutionUseCase = 2
)

// Enum value maps for SearchSolutionUseCase.
var (
	SearchSolutionUseCase_name = map[int32]string{
		0: "SEARCH_SOLUTION_USE_CASE_UNSPECIFIED",
		1: "SEARCH_SOLUTION_USE_CASE_SEARCH",
		2: "SEARCH_SOLUTION_USE_CASE_BROWSE",
	}
	SearchSolutionUseCase_value = map[string]int32{
		"SEARCH_SOLUTION_USE_CASE_UNSPECIFIED": 0,
		"SEARCH_SOLUTION_USE_CASE_SEARCH":      1,
		"SEARCH_SOLUTION_USE_CASE_BROWSE":      2,
	}
)

func (x SearchSolutionUseCase) Enum() *SearchSolutionUseCase {
	p := new(SearchSolutionUseCase)
	*p = x
	return p
}

func (x SearchSolutionUseCase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchSolutionUseCase) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2_common_proto_enumTypes[3].Descriptor()
}

func (SearchSolutionUseCase) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2_common_proto_enumTypes[3]
}

func (x SearchSolutionUseCase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchSolutionUseCase.Descriptor instead.
func (SearchSolutionUseCase) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{3}
}

// Metadata that is used to define a condition that triggers an action.
// A valid condition must specify at least one of 'query_terms' or
// 'products_filter'. If multiple fields are specified, the condition is met if
// all the fields are satisfied e.g. if a set of query terms and product_filter
// are set, then only items matching the product_filter for requests with a
// query matching the query terms wil get boosted.
type Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list (up to 10 entries) of terms to match the query on. If not
	// specified, match all queries.
	// If many query terms are specified, the condition
	// is matched if any of the terms is a match (i.e. using the OR operator).
	QueryTerms []*Condition_QueryTerm `protobuf:"bytes,1,rep,name=query_terms,json=queryTerms,proto3" json:"query_terms,omitempty"`
	// Range of time(s) specifying when Condition is active.
	// Condition true if any time range matches.
	ActiveTimeRange []*Condition_TimeRange `protobuf:"bytes,3,rep,name=active_time_range,json=activeTimeRange,proto3" json:"active_time_range,omitempty"`
}

func (x *Condition) Reset() {
	*x = Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition) ProtoMessage() {}

func (x *Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition.ProtoReflect.Descriptor instead.
func (*Condition) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{0}
}

func (x *Condition) GetQueryTerms() []*Condition_QueryTerm {
	if x != nil {
		return x.QueryTerms
	}
	return nil
}

func (x *Condition) GetActiveTimeRange() []*Condition_TimeRange {
	if x != nil {
		return x.ActiveTimeRange
	}
	return nil
}

// A rule is a condition-action pair
//
// * A condition defines when a rule is to be triggered.
// * An action specifies what occurs on that trigger.
// Currently rules only work for [controls][google.cloud.retail.v2.Control] with
// [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
type Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An action must be provided.
	//
	// Types that are assignable to Action:
	//
	//	*Rule_BoostAction_
	//	*Rule_RedirectAction_
	//	*Rule_OnewaySynonymsAction_
	//	*Rule_DoNotAssociateAction_
	//	*Rule_ReplacementAction_
	//	*Rule_IgnoreAction_
	//	*Rule_FilterAction_
	//	*Rule_TwowaySynonymsAction_
	Action isRule_Action `protobuf_oneof:"action"`
	// Required. The condition that triggers the rule.
	// If the condition is empty, the rule will always apply.
	Condition *Condition `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
}

func (x *Rule) Reset() {
	*x = Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule.ProtoReflect.Descriptor instead.
func (*Rule) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1}
}

func (m *Rule) GetAction() isRule_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *Rule) GetBoostAction() *Rule_BoostAction {
	if x, ok := x.GetAction().(*Rule_BoostAction_); ok {
		return x.BoostAction
	}
	return nil
}

func (x *Rule) GetRedirectAction() *Rule_RedirectAction {
	if x, ok := x.GetAction().(*Rule_RedirectAction_); ok {
		return x.RedirectAction
	}
	return nil
}

func (x *Rule) GetOnewaySynonymsAction() *Rule_OnewaySynonymsAction {
	if x, ok := x.GetAction().(*Rule_OnewaySynonymsAction_); ok {
		return x.OnewaySynonymsAction
	}
	return nil
}

func (x *Rule) GetDoNotAssociateAction() *Rule_DoNotAssociateAction {
	if x, ok := x.GetAction().(*Rule_DoNotAssociateAction_); ok {
		return x.DoNotAssociateAction
	}
	return nil
}

func (x *Rule) GetReplacementAction() *Rule_ReplacementAction {
	if x, ok := x.GetAction().(*Rule_ReplacementAction_); ok {
		return x.ReplacementAction
	}
	return nil
}

func (x *Rule) GetIgnoreAction() *Rule_IgnoreAction {
	if x, ok := x.GetAction().(*Rule_IgnoreAction_); ok {
		return x.IgnoreAction
	}
	return nil
}

func (x *Rule) GetFilterAction() *Rule_FilterAction {
	if x, ok := x.GetAction().(*Rule_FilterAction_); ok {
		return x.FilterAction
	}
	return nil
}

func (x *Rule) GetTwowaySynonymsAction() *Rule_TwowaySynonymsAction {
	if x, ok := x.GetAction().(*Rule_TwowaySynonymsAction_); ok {
		return x.TwowaySynonymsAction
	}
	return nil
}

func (x *Rule) GetCondition() *Condition {
	if x != nil {
		return x.Condition
	}
	return nil
}

type isRule_Action interface {
	isRule_Action()
}

type Rule_BoostAction_ struct {
	// A boost action.
	BoostAction *Rule_BoostAction `protobuf:"bytes,2,opt,name=boost_action,json=boostAction,proto3,oneof"`
}

type Rule_RedirectAction_ struct {
	// Redirects a shopper to a specific page.
	RedirectAction *Rule_RedirectAction `protobuf:"bytes,3,opt,name=redirect_action,json=redirectAction,proto3,oneof"`
}

type Rule_OnewaySynonymsAction_ struct {
	// Treats specific term as a synonym with a group of terms.
	// Group of terms will not be treated as synonyms with the specific term.
	OnewaySynonymsAction *Rule_OnewaySynonymsAction `protobuf:"bytes,6,opt,name=oneway_synonyms_action,json=onewaySynonymsAction,proto3,oneof"`
}

type Rule_DoNotAssociateAction_ struct {
	// Prevents term from being associated with other terms.
	DoNotAssociateAction *Rule_DoNotAssociateAction `protobuf:"bytes,7,opt,name=do_not_associate_action,json=doNotAssociateAction,proto3,oneof"`
}

type Rule_ReplacementAction_ struct {
	// Replaces specific terms in the query.
	ReplacementAction *Rule_ReplacementAction `protobuf:"bytes,8,opt,name=replacement_action,json=replacementAction,proto3,oneof"`
}

type Rule_IgnoreAction_ struct {
	// Ignores specific terms from query during search.
	IgnoreAction *Rule_IgnoreAction `protobuf:"bytes,9,opt,name=ignore_action,json=ignoreAction,proto3,oneof"`
}

type Rule_FilterAction_ struct {
	// Filters results.
	FilterAction *Rule_FilterAction `protobuf:"bytes,10,opt,name=filter_action,json=filterAction,proto3,oneof"`
}

type Rule_TwowaySynonymsAction_ struct {
	// Treats a set of terms as synonyms of one another.
	TwowaySynonymsAction *Rule_TwowaySynonymsAction `protobuf:"bytes,11,opt,name=twoway_synonyms_action,json=twowaySynonymsAction,proto3,oneof"`
}

func (*Rule_BoostAction_) isRule_Action() {}

func (*Rule_RedirectAction_) isRule_Action() {}

func (*Rule_OnewaySynonymsAction_) isRule_Action() {}

func (*Rule_DoNotAssociateAction_) isRule_Action() {}

func (*Rule_ReplacementAction_) isRule_Action() {}

func (*Rule_IgnoreAction_) isRule_Action() {}

func (*Rule_FilterAction_) isRule_Action() {}

func (*Rule_TwowaySynonymsAction_) isRule_Action() {}

// An intended audience of the [Product][google.cloud.retail.v2.Product] for
// whom it's sold.
type Audience struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The genders of the audience. Strongly encouraged to use the standard
	// values: "male", "female", "unisex".
	//
	// At most 5 values are allowed. Each value must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
	// is returned.
	//
	// Google Merchant Center property
	// [gender](https://support.google.com/merchants/answer/6324479). Schema.org
	// property
	// [Product.audience.suggestedGender](https://schema.org/suggestedGender).
	Genders []string `protobuf:"bytes,1,rep,name=genders,proto3" json:"genders,omitempty"`
	// The age groups of the audience. Strongly encouraged to use the standard
	// values: "newborn" (up to 3 months old), "infant" (3–12 months old),
	// "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
	// teens or older).
	//
	// At most 5 values are allowed. Each value must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
	// is returned.
	//
	// Google Merchant Center property
	// [age_group](https://support.google.com/merchants/answer/6324463).
	// Schema.org property
	// [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
	// [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
	AgeGroups []string `protobuf:"bytes,2,rep,name=age_groups,json=ageGroups,proto3" json:"age_groups,omitempty"`
}

func (x *Audience) Reset() {
	*x = Audience{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Audience) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Audience) ProtoMessage() {}

func (x *Audience) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Audience.ProtoReflect.Descriptor instead.
func (*Audience) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{2}
}

func (x *Audience) GetGenders() []string {
	if x != nil {
		return x.Genders
	}
	return nil
}

func (x *Audience) GetAgeGroups() []string {
	if x != nil {
		return x.AgeGroups
	}
	return nil
}

// The color information of a [Product][google.cloud.retail.v2.Product].
type ColorInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The standard color families. Strongly recommended to use the following
	// standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
	// "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
	// "Mixed". Normally it is expected to have only 1 color family. May consider
	// using single "Mixed" instead of multiple values.
	//
	// A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
	// string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// Google Merchant Center property
	// [color](https://support.google.com/merchants/answer/6324487). Schema.org
	// property [Product.color](https://schema.org/color).
	ColorFamilies []string `protobuf:"bytes,1,rep,name=color_families,json=colorFamilies,proto3" json:"color_families,omitempty"`
	// The color display names, which may be different from standard color family
	// names, such as the color aliases used in the website frontend. Normally
	// it is expected to have only 1 color. May consider using single "Mixed"
	// instead of multiple values.
	//
	// A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
	// string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// Google Merchant Center property
	// [color](https://support.google.com/merchants/answer/6324487). Schema.org
	// property [Product.color](https://schema.org/color).
	Colors []string `protobuf:"bytes,2,rep,name=colors,proto3" json:"colors,omitempty"`
}

func (x *ColorInfo) Reset() {
	*x = ColorInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColorInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColorInfo) ProtoMessage() {}

func (x *ColorInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColorInfo.ProtoReflect.Descriptor instead.
func (*ColorInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{3}
}

func (x *ColorInfo) GetColorFamilies() []string {
	if x != nil {
		return x.ColorFamilies
	}
	return nil
}

func (x *ColorInfo) GetColors() []string {
	if x != nil {
		return x.Colors
	}
	return nil
}

// A custom attribute that is not explicitly modeled in
// [Product][google.cloud.retail.v2.Product].
type CustomAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The textual values of this custom attribute. For example, `["yellow",
	// "green"]` when the key is "color".
	//
	// Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	//
	// Exactly one of [text][google.cloud.retail.v2.CustomAttribute.text] or
	// [numbers][google.cloud.retail.v2.CustomAttribute.numbers] should be set.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	Text []string `protobuf:"bytes,1,rep,name=text,proto3" json:"text,omitempty"`
	// The numerical values of this custom attribute. For example, `[2.3, 15.4]`
	// when the key is "lengths_cm".
	//
	// Exactly one of [text][google.cloud.retail.v2.CustomAttribute.text] or
	// [numbers][google.cloud.retail.v2.CustomAttribute.numbers] should be set.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	Numbers []float64 `protobuf:"fixed64,2,rep,packed,name=numbers,proto3" json:"numbers,omitempty"`
	// This field is normally ignored unless
	// [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
	// of the [Catalog][google.cloud.retail.v2.Catalog] is set to the deprecated
	// 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about product-level
	// attribute configuration, see [Configuration
	// modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
	// If true, custom attribute values are searchable by text queries in
	// [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
	//
	// This field is ignored in a [UserEvent][google.cloud.retail.v2.UserEvent].
	//
	// Only set if type [text][google.cloud.retail.v2.CustomAttribute.text] is
	// set. Otherwise, a INVALID_ARGUMENT error is returned.
	//
	// Deprecated: Marked as deprecated in google/cloud/retail/v2/common.proto.
	Searchable *bool `protobuf:"varint,3,opt,name=searchable,proto3,oneof" json:"searchable,omitempty"`
	// This field is normally ignored unless
	// [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
	// of the [Catalog][google.cloud.retail.v2.Catalog] is set to the deprecated
	// 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about product-level
	// attribute configuration, see [Configuration
	// modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
	// If true, custom attribute values are indexed, so that they can be filtered,
	// faceted or boosted in
	// [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
	//
	// This field is ignored in a [UserEvent][google.cloud.retail.v2.UserEvent].
	//
	// See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],
	// [SearchRequest.facet_specs][google.cloud.retail.v2.SearchRequest.facet_specs]
	// and
	// [SearchRequest.boost_spec][google.cloud.retail.v2.SearchRequest.boost_spec]
	// for more details.
	//
	// Deprecated: Marked as deprecated in google/cloud/retail/v2/common.proto.
	Indexable *bool `protobuf:"varint,4,opt,name=indexable,proto3,oneof" json:"indexable,omitempty"`
}

func (x *CustomAttribute) Reset() {
	*x = CustomAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomAttribute) ProtoMessage() {}

func (x *CustomAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomAttribute.ProtoReflect.Descriptor instead.
func (*CustomAttribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{4}
}

func (x *CustomAttribute) GetText() []string {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *CustomAttribute) GetNumbers() []float64 {
	if x != nil {
		return x.Numbers
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/retail/v2/common.proto.
func (x *CustomAttribute) GetSearchable() bool {
	if x != nil && x.Searchable != nil {
		return *x.Searchable
	}
	return false
}

// Deprecated: Marked as deprecated in google/cloud/retail/v2/common.proto.
func (x *CustomAttribute) GetIndexable() bool {
	if x != nil && x.Indexable != nil {
		return *x.Indexable
	}
	return false
}

// Fulfillment information, such as the store IDs for in-store pickup or region
// IDs for different shipping methods.
type FulfillmentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fulfillment type, including commonly used types (such as pickup in
	// store and same day delivery), and custom types. Customers have to map
	// custom types to their display names before rendering UI.
	//
	// Supported values:
	//
	// * "pickup-in-store"
	// * "ship-to-store"
	// * "same-day-delivery"
	// * "next-day-delivery"
	// * "custom-type-1"
	// * "custom-type-2"
	// * "custom-type-3"
	// * "custom-type-4"
	// * "custom-type-5"
	//
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The IDs for this [type][google.cloud.retail.v2.FulfillmentInfo.type], such
	// as the store IDs for
	// [FulfillmentInfo.type.pickup-in-store][google.cloud.retail.v2.FulfillmentInfo.type]
	// or the region IDs for
	// [FulfillmentInfo.type.same-day-delivery][google.cloud.retail.v2.FulfillmentInfo.type].
	//
	// A maximum of 3000 values are allowed. Each value must be a string with a
	// length limit of 30 characters, matching the pattern `[a-zA-Z0-9_-]+`, such
	// as "store1" or "REGION-2". Otherwise, an INVALID_ARGUMENT error is
	// returned.
	PlaceIds []string `protobuf:"bytes,2,rep,name=place_ids,json=placeIds,proto3" json:"place_ids,omitempty"`
}

func (x *FulfillmentInfo) Reset() {
	*x = FulfillmentInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FulfillmentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FulfillmentInfo) ProtoMessage() {}

func (x *FulfillmentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FulfillmentInfo.ProtoReflect.Descriptor instead.
func (*FulfillmentInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{5}
}

func (x *FulfillmentInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *FulfillmentInfo) GetPlaceIds() []string {
	if x != nil {
		return x.PlaceIds
	}
	return nil
}

// [Product][google.cloud.retail.v2.Product] image. Recommendations AI and
// Retail Search do not use product images to improve prediction and search
// results. However, product images can be returned in results, and are shown in
// prediction or search previews in the console.
type Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. URI of the image.
	//
	// This field must be a valid UTF-8 encoded URI with a length limit of 5,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Google Merchant Center property
	// [image_link](https://support.google.com/merchants/answer/6324350).
	// Schema.org property [Product.image](https://schema.org/image).
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Height of the image in number of pixels.
	//
	// This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	Height int32 `protobuf:"varint,2,opt,name=height,proto3" json:"height,omitempty"`
	// Width of the image in number of pixels.
	//
	// This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	Width int32 `protobuf:"varint,3,opt,name=width,proto3" json:"width,omitempty"`
}

func (x *Image) Reset() {
	*x = Image{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Image) ProtoMessage() {}

func (x *Image) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Image.ProtoReflect.Descriptor instead.
func (*Image) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{6}
}

func (x *Image) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Image) GetHeight() int32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *Image) GetWidth() int32 {
	if x != nil {
		return x.Width
	}
	return 0
}

// A floating point interval.
type Interval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The lower bound of the interval. If neither of the min fields are set, then
	// the lower bound is negative infinity.
	//
	// This field must not be larger than max.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Types that are assignable to Min:
	//
	//	*Interval_Minimum
	//	*Interval_ExclusiveMinimum
	Min isInterval_Min `protobuf_oneof:"min"`
	// The upper bound of the interval. If neither of the max fields are set, then
	// the upper bound is positive infinity.
	//
	// This field must be not smaller than min.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Types that are assignable to Max:
	//
	//	*Interval_Maximum
	//	*Interval_ExclusiveMaximum
	Max isInterval_Max `protobuf_oneof:"max"`
}

func (x *Interval) Reset() {
	*x = Interval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Interval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Interval) ProtoMessage() {}

func (x *Interval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Interval.ProtoReflect.Descriptor instead.
func (*Interval) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{7}
}

func (m *Interval) GetMin() isInterval_Min {
	if m != nil {
		return m.Min
	}
	return nil
}

func (x *Interval) GetMinimum() float64 {
	if x, ok := x.GetMin().(*Interval_Minimum); ok {
		return x.Minimum
	}
	return 0
}

func (x *Interval) GetExclusiveMinimum() float64 {
	if x, ok := x.GetMin().(*Interval_ExclusiveMinimum); ok {
		return x.ExclusiveMinimum
	}
	return 0
}

func (m *Interval) GetMax() isInterval_Max {
	if m != nil {
		return m.Max
	}
	return nil
}

func (x *Interval) GetMaximum() float64 {
	if x, ok := x.GetMax().(*Interval_Maximum); ok {
		return x.Maximum
	}
	return 0
}

func (x *Interval) GetExclusiveMaximum() float64 {
	if x, ok := x.GetMax().(*Interval_ExclusiveMaximum); ok {
		return x.ExclusiveMaximum
	}
	return 0
}

type isInterval_Min interface {
	isInterval_Min()
}

type Interval_Minimum struct {
	// Inclusive lower bound.
	Minimum float64 `protobuf:"fixed64,1,opt,name=minimum,proto3,oneof"`
}

type Interval_ExclusiveMinimum struct {
	// Exclusive lower bound.
	ExclusiveMinimum float64 `protobuf:"fixed64,2,opt,name=exclusive_minimum,json=exclusiveMinimum,proto3,oneof"`
}

func (*Interval_Minimum) isInterval_Min() {}

func (*Interval_ExclusiveMinimum) isInterval_Min() {}

type isInterval_Max interface {
	isInterval_Max()
}

type Interval_Maximum struct {
	// Inclusive upper bound.
	Maximum float64 `protobuf:"fixed64,3,opt,name=maximum,proto3,oneof"`
}

type Interval_ExclusiveMaximum struct {
	// Exclusive upper bound.
	ExclusiveMaximum float64 `protobuf:"fixed64,4,opt,name=exclusive_maximum,json=exclusiveMaximum,proto3,oneof"`
}

func (*Interval_Maximum) isInterval_Max() {}

func (*Interval_ExclusiveMaximum) isInterval_Max() {}

// The price information of a [Product][google.cloud.retail.v2.Product].
type PriceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The 3-letter currency code defined in [ISO
	// 4217](https://www.iso.org/iso-4217-currency-codes.html).
	//
	// If this field is an unrecognizable currency code, an INVALID_ARGUMENT
	// error is returned.
	//
	// The [Product.Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product]s with the same
	// [Product.primary_product_id][google.cloud.retail.v2.Product.primary_product_id]
	// must share the same
	// [currency_code][google.cloud.retail.v2.PriceInfo.currency_code]. Otherwise,
	// a FAILED_PRECONDITION error is returned.
	CurrencyCode string `protobuf:"bytes,1,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Price of the product.
	//
	// Google Merchant Center property
	// [price](https://support.google.com/merchants/answer/6324371). Schema.org
	// property [Offer.price](https://schema.org/price).
	Price float32 `protobuf:"fixed32,2,opt,name=price,proto3" json:"price,omitempty"`
	// Price of the product without any discount. If zero, by default set to be
	// the [price][google.cloud.retail.v2.PriceInfo.price]. If set,
	// [original_price][google.cloud.retail.v2.PriceInfo.original_price] should be
	// greater than or equal to [price][google.cloud.retail.v2.PriceInfo.price],
	// otherwise an INVALID_ARGUMENT error is thrown.
	OriginalPrice float32 `protobuf:"fixed32,3,opt,name=original_price,json=originalPrice,proto3" json:"original_price,omitempty"`
	// The costs associated with the sale of a particular product. Used for gross
	// profit reporting.
	//
	// * Profit = [price][google.cloud.retail.v2.PriceInfo.price] -
	// [cost][google.cloud.retail.v2.PriceInfo.cost]
	//
	// Google Merchant Center property
	// [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
	Cost float32 `protobuf:"fixed32,4,opt,name=cost,proto3" json:"cost,omitempty"`
	// The timestamp when the [price][google.cloud.retail.v2.PriceInfo.price]
	// starts to be effective. This can be set as a future timestamp, and the
	// [price][google.cloud.retail.v2.PriceInfo.price] is only used for search
	// after
	// [price_effective_time][google.cloud.retail.v2.PriceInfo.price_effective_time].
	// If so, the
	// [original_price][google.cloud.retail.v2.PriceInfo.original_price] must be
	// set and [original_price][google.cloud.retail.v2.PriceInfo.original_price]
	// is used before
	// [price_effective_time][google.cloud.retail.v2.PriceInfo.price_effective_time].
	//
	// Do not set if [price][google.cloud.retail.v2.PriceInfo.price] is always
	// effective because it will cause additional latency during search.
	PriceEffectiveTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=price_effective_time,json=priceEffectiveTime,proto3" json:"price_effective_time,omitempty"`
	// The timestamp when the [price][google.cloud.retail.v2.PriceInfo.price]
	// stops to be effective. The [price][google.cloud.retail.v2.PriceInfo.price]
	// is used for search before
	// [price_expire_time][google.cloud.retail.v2.PriceInfo.price_expire_time]. If
	// this field is set, the
	// [original_price][google.cloud.retail.v2.PriceInfo.original_price] must be
	// set and [original_price][google.cloud.retail.v2.PriceInfo.original_price]
	// is used after
	// [price_expire_time][google.cloud.retail.v2.PriceInfo.price_expire_time].
	//
	// Do not set if [price][google.cloud.retail.v2.PriceInfo.price] is always
	// effective because it will cause additional latency during search.
	PriceExpireTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=price_expire_time,json=priceExpireTime,proto3" json:"price_expire_time,omitempty"`
	// Output only. The price range of all the child
	// [Product.Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product]s grouped together on the
	// [Product.Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2.Product]. Only populated for
	// [Product.Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2.Product]s.
	//
	// Note: This field is OUTPUT_ONLY for
	// [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
	// Do not set this field in API requests.
	PriceRange *PriceInfo_PriceRange `protobuf:"bytes,7,opt,name=price_range,json=priceRange,proto3" json:"price_range,omitempty"`
}

func (x *PriceInfo) Reset() {
	*x = PriceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriceInfo) ProtoMessage() {}

func (x *PriceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriceInfo.ProtoReflect.Descriptor instead.
func (*PriceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{8}
}

func (x *PriceInfo) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *PriceInfo) GetPrice() float32 {
	if x != nil {
		return x.Price
	}
	return 0
}

func (x *PriceInfo) GetOriginalPrice() float32 {
	if x != nil {
		return x.OriginalPrice
	}
	return 0
}

func (x *PriceInfo) GetCost() float32 {
	if x != nil {
		return x.Cost
	}
	return 0
}

func (x *PriceInfo) GetPriceEffectiveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PriceEffectiveTime
	}
	return nil
}

func (x *PriceInfo) GetPriceExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PriceExpireTime
	}
	return nil
}

func (x *PriceInfo) GetPriceRange() *PriceInfo_PriceRange {
	if x != nil {
		return x.PriceRange
	}
	return nil
}

// The rating of a [Product][google.cloud.retail.v2.Product].
type Rating struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of ratings. This value is independent of the value of
	// [rating_histogram][google.cloud.retail.v2.Rating.rating_histogram].
	//
	// This value must be nonnegative. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	RatingCount int32 `protobuf:"varint,1,opt,name=rating_count,json=ratingCount,proto3" json:"rating_count,omitempty"`
	// The average rating of the [Product][google.cloud.retail.v2.Product].
	//
	// The rating is scaled at 1-5. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	AverageRating float32 `protobuf:"fixed32,2,opt,name=average_rating,json=averageRating,proto3" json:"average_rating,omitempty"`
	// List of rating counts per rating value (index = rating - 1). The list is
	// empty if there is no rating. If the list is non-empty, its size is
	// always 5. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// For example, [41, 14, 13, 47, 303]. It means that the
	// [Product][google.cloud.retail.v2.Product] got 41 ratings with 1 star, 14
	// ratings with 2 star, and so on.
	RatingHistogram []int32 `protobuf:"varint,3,rep,packed,name=rating_histogram,json=ratingHistogram,proto3" json:"rating_histogram,omitempty"`
}

func (x *Rating) Reset() {
	*x = Rating{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rating) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rating) ProtoMessage() {}

func (x *Rating) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rating.ProtoReflect.Descriptor instead.
func (*Rating) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{9}
}

func (x *Rating) GetRatingCount() int32 {
	if x != nil {
		return x.RatingCount
	}
	return 0
}

func (x *Rating) GetAverageRating() float32 {
	if x != nil {
		return x.AverageRating
	}
	return 0
}

func (x *Rating) GetRatingHistogram() []int32 {
	if x != nil {
		return x.RatingHistogram
	}
	return nil
}

// Information of an end user.
type UserInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Highly recommended for logged-in users. Unique identifier for logged-in
	// user, such as a user name. Don't set for anonymous users.
	//
	// Always use a hashed value for this ID.
	//
	// Don't set the field to the same fixed ID for different users. This mixes
	// the event history of those users together, which results in degraded
	// model quality.
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The end user's IP address. This field is used to extract location
	// information for personalization.
	//
	// This field must be either an IPv4 address (e.g. "104.133.9.80") or an IPv6
	// address (e.g. "2001:0db8:85a3:0000:0000:8a2e:0370:7334"). Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// This should not be set when:
	//
	// * setting
	// [SearchRequest.user_info][google.cloud.retail.v2.SearchRequest.user_info].
	// * using the JavaScript tag in
	// [UserEventService.CollectUserEvent][google.cloud.retail.v2.UserEventService.CollectUserEvent]
	// or if
	// [direct_user_request][google.cloud.retail.v2.UserInfo.direct_user_request]
	// is set.
	IpAddress string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// User agent as included in the HTTP header. Required for getting
	// [SearchResponse.sponsored_results][google.cloud.retail.v2.SearchResponse.sponsored_results].
	//
	// The field must be a UTF-8 encoded string with a length limit of 1,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// This should not be set when using the client side event reporting with
	// GTM or JavaScript tag in
	// [UserEventService.CollectUserEvent][google.cloud.retail.v2.UserEventService.CollectUserEvent]
	// or if
	// [direct_user_request][google.cloud.retail.v2.UserInfo.direct_user_request]
	// is set.
	UserAgent string `protobuf:"bytes,3,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// True if the request is made directly from the end user, in which case the
	// [ip_address][google.cloud.retail.v2.UserInfo.ip_address] and
	// [user_agent][google.cloud.retail.v2.UserInfo.user_agent] can be populated
	// from the HTTP request. This flag should be set only if the API request is
	// made directly from the end user such as a mobile app (and not if a gateway
	// or a server is processing and pushing the user events).
	//
	// This should not be set when using the JavaScript tag in
	// [UserEventService.CollectUserEvent][google.cloud.retail.v2.UserEventService.CollectUserEvent].
	DirectUserRequest bool `protobuf:"varint,4,opt,name=direct_user_request,json=directUserRequest,proto3" json:"direct_user_request,omitempty"`
}

func (x *UserInfo) Reset() {
	*x = UserInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInfo) ProtoMessage() {}

func (x *UserInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInfo.ProtoReflect.Descriptor instead.
func (*UserInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{10}
}

func (x *UserInfo) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *UserInfo) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *UserInfo) GetUserAgent() string {
	if x != nil {
		return x.UserAgent
	}
	return ""
}

func (x *UserInfo) GetDirectUserRequest() bool {
	if x != nil {
		return x.DirectUserRequest
	}
	return false
}

// The inventory information at a place (e.g. a store) identified
// by a place ID.
type LocalInventory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The place ID for the current set of inventory information.
	PlaceId string `protobuf:"bytes,1,opt,name=place_id,json=placeId,proto3" json:"place_id,omitempty"`
	// Product price and cost information.
	//
	// Google Merchant Center property
	// [price](https://support.google.com/merchants/answer/6324371).
	PriceInfo *PriceInfo `protobuf:"bytes,2,opt,name=price_info,json=priceInfo,proto3" json:"price_info,omitempty"`
	// Additional local inventory attributes, for example, store name, promotion
	// tags, etc.
	//
	// This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
	// error is returned:
	//
	//   - At most 30 attributes are allowed.
	//   - The key must be a UTF-8 encoded string with a length limit of 32
	//     characters.
	//   - The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
	//     key0LikeThis or KEY_1_LIKE_THIS.
	//   - The attribute values must be of the same type (text or number).
	//   - Only 1 value is allowed for each attribute.
	//   - For text values, the length limit is 256 UTF-8 characters.
	//   - The attribute does not support search. The `searchable` field should be
	//     unset or set to false.
	//   - The max summed total bytes of custom attribute keys and values per
	//     product is 5MiB.
	Attributes map[string]*CustomAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Input only. Supported fulfillment types. Valid fulfillment type values
	// include commonly used types (such as pickup in store and same day
	// delivery), and custom types. Customers have to map custom types to their
	// display names before rendering UI.
	//
	// Supported values:
	//
	// * "pickup-in-store"
	// * "ship-to-store"
	// * "same-day-delivery"
	// * "next-day-delivery"
	// * "custom-type-1"
	// * "custom-type-2"
	// * "custom-type-3"
	// * "custom-type-4"
	// * "custom-type-5"
	//
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned.
	//
	// All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	FulfillmentTypes []string `protobuf:"bytes,4,rep,name=fulfillment_types,json=fulfillmentTypes,proto3" json:"fulfillment_types,omitempty"`
}

func (x *LocalInventory) Reset() {
	*x = LocalInventory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocalInventory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalInventory) ProtoMessage() {}

func (x *LocalInventory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalInventory.ProtoReflect.Descriptor instead.
func (*LocalInventory) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{11}
}

func (x *LocalInventory) GetPlaceId() string {
	if x != nil {
		return x.PlaceId
	}
	return ""
}

func (x *LocalInventory) GetPriceInfo() *PriceInfo {
	if x != nil {
		return x.PriceInfo
	}
	return nil
}

func (x *LocalInventory) GetAttributes() map[string]*CustomAttribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *LocalInventory) GetFulfillmentTypes() []string {
	if x != nil {
		return x.FulfillmentTypes
	}
	return nil
}

// Query terms that we want to match on.
type Condition_QueryTerm struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of the term to match on.
	// Value cannot be empty.
	// Value can have at most 3 terms if specified as a partial match. Each
	// space separated string is considered as one term.
	// For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
	// and not allowed for a partial match.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Whether this is supposed to be a full or partial match.
	FullMatch bool `protobuf:"varint,2,opt,name=full_match,json=fullMatch,proto3" json:"full_match,omitempty"`
}

func (x *Condition_QueryTerm) Reset() {
	*x = Condition_QueryTerm{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition_QueryTerm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition_QueryTerm) ProtoMessage() {}

func (x *Condition_QueryTerm) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition_QueryTerm.ProtoReflect.Descriptor instead.
func (*Condition_QueryTerm) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Condition_QueryTerm) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Condition_QueryTerm) GetFullMatch() bool {
	if x != nil {
		return x.FullMatch
	}
	return false
}

// Used for time-dependent conditions.
// Example: Want to have rule applied for week long sale.
type Condition_TimeRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of time range. Range is inclusive.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of time range. Range is inclusive.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *Condition_TimeRange) Reset() {
	*x = Condition_TimeRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition_TimeRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition_TimeRange) ProtoMessage() {}

func (x *Condition_TimeRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition_TimeRange.ProtoReflect.Descriptor instead.
func (*Condition_TimeRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Condition_TimeRange) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Condition_TimeRange) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// A boost action to apply to results matching condition specified above.
type Rule_BoostAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Strength of the condition boost, which must be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0.
	//
	// Setting to 1.0 gives the item a big promotion. However, it does not
	// necessarily mean that the boosted item will be the top result at all
	// times, nor that other items will be excluded. Results could still be
	// shown even when none of them matches the condition. And results that
	// are significantly more relevant to the search query can still trump
	// your heavily favored but irrelevant items.
	//
	// Setting to -1.0 gives the item a big demotion. However, results that
	// are deeply relevant might still be shown. The item will have an
	// upstream battle to get a fairly high ranking, but it is not blocked out
	// completely.
	//
	// Setting to 0.0 means no boost applied. The boosting condition is
	// ignored.
	Boost float32 `protobuf:"fixed32,1,opt,name=boost,proto3" json:"boost,omitempty"`
	// The filter can have a max size of 5000 characters.
	// An expression which specifies which products to apply an action to.
	// The syntax and supported fields are the same as a filter expression. See
	// [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
	// detail syntax and limitations.
	//
	// Examples:
	//
	// * To boost products with product ID "product_1" or "product_2", and
	// color
	//
	//	"Red" or "Blue":<br>
	//	*(id: ANY("product_1", "product_2"))<br>*
	//	*AND<br>*
	//	*(colorFamilies: ANY("Red", "Blue"))<br>*
	ProductsFilter string `protobuf:"bytes,2,opt,name=products_filter,json=productsFilter,proto3" json:"products_filter,omitempty"`
}

func (x *Rule_BoostAction) Reset() {
	*x = Rule_BoostAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule_BoostAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_BoostAction) ProtoMessage() {}

func (x *Rule_BoostAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_BoostAction.ProtoReflect.Descriptor instead.
func (*Rule_BoostAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Rule_BoostAction) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

func (x *Rule_BoostAction) GetProductsFilter() string {
	if x != nil {
		return x.ProductsFilter
	}
	return ""
}

// * Rule Condition:
//   - No
//     [Condition.query_terms][google.cloud.retail.v2.Condition.query_terms]
//     provided is a global match.
//   - 1 or more
//     [Condition.query_terms][google.cloud.retail.v2.Condition.query_terms]
//     provided are combined with OR operator.
//
// * Action Input: The request query and filter that are applied to the
// retrieved products, in addition to any filters already provided with the
// SearchRequest. The AND operator is used to combine the query's existing
// filters with the filter rule(s). NOTE: May result in 0 results when
// filters conflict.
// * Action Result: Filters the returned objects to be ONLY those that passed
// the filter.
type Rule_FilterAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter to apply on the matching condition results. Supported features:
	//
	// * [filter][google.cloud.retail.v2.Rule.FilterAction.filter] must be set.
	// * Filter syntax is identical to
	// [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter]. See
	// more
	//
	//	details at the Retail Search
	//	[user guide](/retail/search/docs/filter-and-order#filter).
	//
	// * To filter products with product ID "product_1" or "product_2", and
	// color
	//
	//	"Red" or "Blue":<br>
	//	*(id: ANY("product_1", "product_2"))<br>*
	//	*AND<br>*
	//	*(colorFamilies: ANY("Red", "Blue"))<br>*
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *Rule_FilterAction) Reset() {
	*x = Rule_FilterAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule_FilterAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_FilterAction) ProtoMessage() {}

func (x *Rule_FilterAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_FilterAction.ProtoReflect.Descriptor instead.
func (*Rule_FilterAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1, 1}
}

func (x *Rule_FilterAction) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Redirects a shopper to a specific page.
//
// * Rule Condition:
//   - Must specify
//     [Condition.query_terms][google.cloud.retail.v2.Condition.query_terms].
//
// * Action Input: Request Query
// * Action Result: Redirects shopper to provided uri.
type Rule_RedirectAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL must have length equal or less than 2000 characters.
	RedirectUri string `protobuf:"bytes,1,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
}

func (x *Rule_RedirectAction) Reset() {
	*x = Rule_RedirectAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule_RedirectAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_RedirectAction) ProtoMessage() {}

func (x *Rule_RedirectAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_RedirectAction.ProtoReflect.Descriptor instead.
func (*Rule_RedirectAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1, 2}
}

func (x *Rule_RedirectAction) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

// Creates a set of terms that will be treated as synonyms of each other.
// Example: synonyms of "sneakers" and "shoes":
//
//   - "sneakers" will use a synonym of "shoes".
//   - "shoes" will use a synonym of "sneakers".
type Rule_TwowaySynonymsAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines a set of synonyms.
	// Can specify up to 100 synonyms.
	// Must specify at least 2 synonyms.
	Synonyms []string `protobuf:"bytes,1,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
}

func (x *Rule_TwowaySynonymsAction) Reset() {
	*x = Rule_TwowaySynonymsAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule_TwowaySynonymsAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_TwowaySynonymsAction) ProtoMessage() {}

func (x *Rule_TwowaySynonymsAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_TwowaySynonymsAction.ProtoReflect.Descriptor instead.
func (*Rule_TwowaySynonymsAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1, 3}
}

func (x *Rule_TwowaySynonymsAction) GetSynonyms() []string {
	if x != nil {
		return x.Synonyms
	}
	return nil
}

// Maps a set of terms to a set of synonyms.
// Set of synonyms will be treated as synonyms of each query term only.
// `query_terms` will not be treated as synonyms of each other.
// Example: "sneakers" will use a synonym of "shoes".
// "shoes" will not use a synonym of "sneakers".
type Rule_OnewaySynonymsAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Terms from the search query.
	// Will treat synonyms as their synonyms.
	// Not themselves synonyms of the synonyms.
	// Can specify up to 100 terms.
	QueryTerms []string `protobuf:"bytes,3,rep,name=query_terms,json=queryTerms,proto3" json:"query_terms,omitempty"`
	// Defines a set of synonyms.
	// Cannot contain duplicates.
	// Can specify up to 100 synonyms.
	Synonyms []string `protobuf:"bytes,4,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
	// Will be [deprecated = true] post migration;
	OnewayTerms []string `protobuf:"bytes,2,rep,name=oneway_terms,json=onewayTerms,proto3" json:"oneway_terms,omitempty"`
}

func (x *Rule_OnewaySynonymsAction) Reset() {
	*x = Rule_OnewaySynonymsAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule_OnewaySynonymsAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_OnewaySynonymsAction) ProtoMessage() {}

func (x *Rule_OnewaySynonymsAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_OnewaySynonymsAction.ProtoReflect.Descriptor instead.
func (*Rule_OnewaySynonymsAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1, 4}
}

func (x *Rule_OnewaySynonymsAction) GetQueryTerms() []string {
	if x != nil {
		return x.QueryTerms
	}
	return nil
}

func (x *Rule_OnewaySynonymsAction) GetSynonyms() []string {
	if x != nil {
		return x.Synonyms
	}
	return nil
}

func (x *Rule_OnewaySynonymsAction) GetOnewayTerms() []string {
	if x != nil {
		return x.OnewayTerms
	}
	return nil
}

// Prevents `query_term` from being associated with specified terms during
// search.
// Example: Don't associate "gShoe" and "cheap".
type Rule_DoNotAssociateAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Terms from the search query.
	// Will not consider do_not_associate_terms for search if in search query.
	// Can specify up to 100 terms.
	QueryTerms []string `protobuf:"bytes,2,rep,name=query_terms,json=queryTerms,proto3" json:"query_terms,omitempty"`
	// Cannot contain duplicates or the query term.
	// Can specify up to 100 terms.
	DoNotAssociateTerms []string `protobuf:"bytes,3,rep,name=do_not_associate_terms,json=doNotAssociateTerms,proto3" json:"do_not_associate_terms,omitempty"`
	// Will be [deprecated = true] post migration;
	Terms []string `protobuf:"bytes,1,rep,name=terms,proto3" json:"terms,omitempty"`
}

func (x *Rule_DoNotAssociateAction) Reset() {
	*x = Rule_DoNotAssociateAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule_DoNotAssociateAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_DoNotAssociateAction) ProtoMessage() {}

func (x *Rule_DoNotAssociateAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_DoNotAssociateAction.ProtoReflect.Descriptor instead.
func (*Rule_DoNotAssociateAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1, 5}
}

func (x *Rule_DoNotAssociateAction) GetQueryTerms() []string {
	if x != nil {
		return x.QueryTerms
	}
	return nil
}

func (x *Rule_DoNotAssociateAction) GetDoNotAssociateTerms() []string {
	if x != nil {
		return x.DoNotAssociateTerms
	}
	return nil
}

func (x *Rule_DoNotAssociateAction) GetTerms() []string {
	if x != nil {
		return x.Terms
	}
	return nil
}

// Replaces a term in the query. Multiple replacement candidates can be
// specified. All `query_terms` will be replaced with the replacement term.
// Example: Replace "gShoe" with "google shoe".
type Rule_ReplacementAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Terms from the search query.
	// Will be replaced by replacement term.
	// Can specify up to 100 terms.
	QueryTerms []string `protobuf:"bytes,2,rep,name=query_terms,json=queryTerms,proto3" json:"query_terms,omitempty"`
	// Term that will be used for replacement.
	ReplacementTerm string `protobuf:"bytes,3,opt,name=replacement_term,json=replacementTerm,proto3" json:"replacement_term,omitempty"`
	// Will be [deprecated = true] post migration;
	Term string `protobuf:"bytes,1,opt,name=term,proto3" json:"term,omitempty"`
}

func (x *Rule_ReplacementAction) Reset() {
	*x = Rule_ReplacementAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule_ReplacementAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_ReplacementAction) ProtoMessage() {}

func (x *Rule_ReplacementAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_ReplacementAction.ProtoReflect.Descriptor instead.
func (*Rule_ReplacementAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1, 6}
}

func (x *Rule_ReplacementAction) GetQueryTerms() []string {
	if x != nil {
		return x.QueryTerms
	}
	return nil
}

func (x *Rule_ReplacementAction) GetReplacementTerm() string {
	if x != nil {
		return x.ReplacementTerm
	}
	return ""
}

func (x *Rule_ReplacementAction) GetTerm() string {
	if x != nil {
		return x.Term
	}
	return ""
}

// Prevents a term in the query from being used in search.
// Example: Don't search for "shoddy".
type Rule_IgnoreAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Terms to ignore in the search query.
	IgnoreTerms []string `protobuf:"bytes,1,rep,name=ignore_terms,json=ignoreTerms,proto3" json:"ignore_terms,omitempty"`
}

func (x *Rule_IgnoreAction) Reset() {
	*x = Rule_IgnoreAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule_IgnoreAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_IgnoreAction) ProtoMessage() {}

func (x *Rule_IgnoreAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_IgnoreAction.ProtoReflect.Descriptor instead.
func (*Rule_IgnoreAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{1, 7}
}

func (x *Rule_IgnoreAction) GetIgnoreTerms() []string {
	if x != nil {
		return x.IgnoreTerms
	}
	return nil
}

// The price range of all
// [variant][google.cloud.retail.v2.Product.Type.VARIANT]
// [Product][google.cloud.retail.v2.Product] having the same
// [Product.primary_product_id][google.cloud.retail.v2.Product.primary_product_id].
type PriceInfo_PriceRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The inclusive
	// [Product.pricing_info.price][google.cloud.retail.v2.PriceInfo.price]
	// interval of all [variant][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product] having the same
	// [Product.primary_product_id][google.cloud.retail.v2.Product.primary_product_id].
	Price *Interval `protobuf:"bytes,1,opt,name=price,proto3" json:"price,omitempty"`
	// The inclusive
	// [Product.pricing_info.original_price][google.cloud.retail.v2.PriceInfo.original_price]
	// internal of all [variant][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product] having the same
	// [Product.primary_product_id][google.cloud.retail.v2.Product.primary_product_id].
	OriginalPrice *Interval `protobuf:"bytes,2,opt,name=original_price,json=originalPrice,proto3" json:"original_price,omitempty"`
}

func (x *PriceInfo_PriceRange) Reset() {
	*x = PriceInfo_PriceRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_common_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriceInfo_PriceRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriceInfo_PriceRange) ProtoMessage() {}

func (x *PriceInfo_PriceRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_common_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriceInfo_PriceRange.ProtoReflect.Descriptor instead.
func (*PriceInfo_PriceRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_common_proto_rawDescGZIP(), []int{8, 0}
}

func (x *PriceInfo_PriceRange) GetPrice() *Interval {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *PriceInfo_PriceRange) GetOriginalPrice() *Interval {
	if x != nil {
		return x.OriginalPrice
	}
	return nil
}

var File_google_cloud_retail_v2_common_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2_common_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xf3, 0x02, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a,
	0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x72, 0x6d, 0x52,
	0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x12, 0x57, 0x0a, 0x11, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x1a, 0x40, 0x0a, 0x09, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x72,
	0x6d, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x75, 0x6c, 0x6c, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x66, 0x75, 0x6c,
	0x6c, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x1a, 0x7d, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xc8, 0x0b, 0x0a, 0x04, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x4d,
	0x0a, 0x0c, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x75,
	0x6c, 0x65, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0b, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a,
	0x0f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x16, 0x6f, 0x6e, 0x65, 0x77, 0x61, 0x79, 0x5f,
	0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x75, 0x6c, 0x65, 0x2e, 0x4f, 0x6e, 0x65, 0x77, 0x61, 0x79, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79,
	0x6d, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x6f, 0x6e, 0x65, 0x77,
	0x61, 0x79, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x6a, 0x0a, 0x17, 0x64, 0x6f, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x61, 0x73, 0x73, 0x6f, 0x63,
	0x69, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e,
	0x44, 0x6f, 0x4e, 0x6f, 0x74, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x64, 0x6f, 0x4e, 0x6f, 0x74, 0x41, 0x73, 0x73,
	0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x12,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a,
	0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x75,
	0x6c, 0x65, 0x2e, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x50, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x75, 0x6c, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x69, 0x0a, 0x16, 0x74, 0x77, 0x6f, 0x77, 0x61, 0x79, 0x5f, 0x73, 0x79, 0x6e, 0x6f,
	0x6e, 0x79, 0x6d, 0x73, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e,
	0x54, 0x77, 0x6f, 0x77, 0x61, 0x79, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x74, 0x77, 0x6f, 0x77, 0x61, 0x79, 0x53, 0x79,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0x4c, 0x0a, 0x0b, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x1a, 0x26, 0x0a, 0x0c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x1a, 0x33, 0x0a, 0x0e, 0x52, 0x65, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x1a, 0x32, 0x0a,
	0x14, 0x54, 0x77, 0x6f, 0x77, 0x61, 0x79, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d,
	0x73, 0x1a, 0x76, 0x0a, 0x14, 0x4f, 0x6e, 0x65, 0x77, 0x61, 0x79, 0x53, 0x79, 0x6e, 0x6f, 0x6e,
	0x79, 0x6d, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x79,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x73, 0x79,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x6e, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x6e,
	0x65, 0x77, 0x61, 0x79, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x1a, 0x82, 0x01, 0x0a, 0x14, 0x44, 0x6f,
	0x4e, 0x6f, 0x74, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x72, 0x6d,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65,
	0x72, 0x6d, 0x73, 0x12, 0x33, 0x0a, 0x16, 0x64, 0x6f, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x61, 0x73,
	0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x13, 0x64, 0x6f, 0x4e, 0x6f, 0x74, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x65, 0x72, 0x6d,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x1a, 0x73,
	0x0a, 0x11, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x72,
	0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54,
	0x65, 0x72, 0x6d, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x65, 0x72, 0x6d, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x65, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x65, 0x72, 0x6d, 0x1a, 0x31, 0x0a, 0x0c, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x65,
	0x72, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x67, 0x6e, 0x6f, 0x72,
	0x65, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x43, 0x0a, 0x08, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x67,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x67, 0x65, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x67, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x22, 0x4a, 0x0a, 0x09, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x5f, 0x66, 0x61, 0x6d, 0x69,
	0x6c, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6c, 0x6f,
	0x72, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c,
	0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x6f, 0x72,
	0x73, 0x22, 0xac, 0x01, 0x0a, 0x0f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x01, 0x52, 0x07, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x12, 0x27, 0x0a, 0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x09,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x02, 0x18, 0x01, 0x48, 0x01, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x42, 0x0a, 0x0f, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x49, 0x64, 0x73, 0x22, 0x4c, 0x0a, 0x05, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x14, 0x0a, 0x05,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x22, 0xae, 0x01, 0x0a, 0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12,
	0x1a, 0x0a, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x00, 0x52, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x2d, 0x0a, 0x11, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x76, 0x65, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x1a, 0x0a, 0x07, 0x6d, 0x61,
	0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x07, 0x6d,
	0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x2d, 0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x76, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x01, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x4d, 0x61,
	0x78, 0x69, 0x6d, 0x75, 0x6d, 0x42, 0x05, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x42, 0x05, 0x0a, 0x03,
	0x6d, 0x61, 0x78, 0x22, 0xfb, 0x03, 0x0a, 0x09, 0x50, 0x72, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x14, 0x70, 0x72, 0x69, 0x63, 0x65,
	0x5f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x12, 0x70, 0x72, 0x69, 0x63, 0x65, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x70, 0x72,
	0x69, 0x63, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a,
	0x0b, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x63, 0x65, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x1a, 0x8d, 0x01, 0x0a, 0x0a, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x36, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x47, 0x0a, 0x0e, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x52, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x22, 0x7d, 0x0a, 0x06, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0b, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25,
	0x0a, 0x0e, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0d, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x52,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x03, 0x20, 0x03, 0x28, 0x05, 0x52,
	0x0f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x22, 0x91, 0x01, 0x0a, 0x08, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x17, 0x0a,
	0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x22, 0xdf, 0x02, 0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x49, 0x64, 0x12, 0x40, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x72, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x70, 0x72, 0x69, 0x63, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x56, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x11,
	0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x10, 0x66, 0x75,
	0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0x66,
	0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x2a, 0x86, 0x01, 0x0a, 0x14, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12,
	0x26, 0x0a, 0x22, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x52, 0x4f, 0x44, 0x55,
	0x43, 0x54, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55,
	0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x43,
	0x41, 0x54, 0x41, 0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x41, 0x54, 0x54,
	0x52, 0x49, 0x42, 0x55, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x02, 0x2a,
	0x69, 0x0a, 0x0c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20,
	0x0a, 0x1c, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x52, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x4e, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x18, 0x0a, 0x14, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x02, 0x2a, 0xa1, 0x01, 0x0a, 0x1e, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a,
	0x2c, 0x52, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x4e, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53,
	0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x26, 0x0a, 0x22, 0x52, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x4e, 0x44, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x53, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x25, 0x0a, 0x21, 0x52, 0x45, 0x43, 0x4f, 0x4d,
	0x4d, 0x45, 0x4e, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45,
	0x52, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x8b,
	0x01, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x55, 0x73, 0x65, 0x43, 0x61, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x45, 0x41, 0x52,
	0x43, 0x48, 0x5f, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x53, 0x45, 0x5f,
	0x43, 0x41, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x53, 0x4f, 0x4c,
	0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x53, 0x45, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x53,
	0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x45, 0x41, 0x52, 0x43,
	0x48, 0x5f, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x53, 0x45, 0x5f, 0x43,
	0x41, 0x53, 0x45, 0x5f, 0x42, 0x52, 0x4f, 0x57, 0x53, 0x45, 0x10, 0x02, 0x42, 0xb6, 0x01, 0x0a,
	0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x42, 0x0b, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2, 0x02,
	0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56, 0x32,
	0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2_common_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2_common_proto_rawDescData = file_google_cloud_retail_v2_common_proto_rawDesc
)

func file_google_cloud_retail_v2_common_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2_common_proto_rawDescData)
	})
	return file_google_cloud_retail_v2_common_proto_rawDescData
}

var file_google_cloud_retail_v2_common_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_retail_v2_common_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_google_cloud_retail_v2_common_proto_goTypes = []interface{}{
	(AttributeConfigLevel)(0),           // 0: google.cloud.retail.v2.AttributeConfigLevel
	(SolutionType)(0),                   // 1: google.cloud.retail.v2.SolutionType
	(RecommendationsFilteringOption)(0), // 2: google.cloud.retail.v2.RecommendationsFilteringOption
	(SearchSolutionUseCase)(0),          // 3: google.cloud.retail.v2.SearchSolutionUseCase
	(*Condition)(nil),                   // 4: google.cloud.retail.v2.Condition
	(*Rule)(nil),                        // 5: google.cloud.retail.v2.Rule
	(*Audience)(nil),                    // 6: google.cloud.retail.v2.Audience
	(*ColorInfo)(nil),                   // 7: google.cloud.retail.v2.ColorInfo
	(*CustomAttribute)(nil),             // 8: google.cloud.retail.v2.CustomAttribute
	(*FulfillmentInfo)(nil),             // 9: google.cloud.retail.v2.FulfillmentInfo
	(*Image)(nil),                       // 10: google.cloud.retail.v2.Image
	(*Interval)(nil),                    // 11: google.cloud.retail.v2.Interval
	(*PriceInfo)(nil),                   // 12: google.cloud.retail.v2.PriceInfo
	(*Rating)(nil),                      // 13: google.cloud.retail.v2.Rating
	(*UserInfo)(nil),                    // 14: google.cloud.retail.v2.UserInfo
	(*LocalInventory)(nil),              // 15: google.cloud.retail.v2.LocalInventory
	(*Condition_QueryTerm)(nil),         // 16: google.cloud.retail.v2.Condition.QueryTerm
	(*Condition_TimeRange)(nil),         // 17: google.cloud.retail.v2.Condition.TimeRange
	(*Rule_BoostAction)(nil),            // 18: google.cloud.retail.v2.Rule.BoostAction
	(*Rule_FilterAction)(nil),           // 19: google.cloud.retail.v2.Rule.FilterAction
	(*Rule_RedirectAction)(nil),         // 20: google.cloud.retail.v2.Rule.RedirectAction
	(*Rule_TwowaySynonymsAction)(nil),   // 21: google.cloud.retail.v2.Rule.TwowaySynonymsAction
	(*Rule_OnewaySynonymsAction)(nil),   // 22: google.cloud.retail.v2.Rule.OnewaySynonymsAction
	(*Rule_DoNotAssociateAction)(nil),   // 23: google.cloud.retail.v2.Rule.DoNotAssociateAction
	(*Rule_ReplacementAction)(nil),      // 24: google.cloud.retail.v2.Rule.ReplacementAction
	(*Rule_IgnoreAction)(nil),           // 25: google.cloud.retail.v2.Rule.IgnoreAction
	(*PriceInfo_PriceRange)(nil),        // 26: google.cloud.retail.v2.PriceInfo.PriceRange
	nil,                                 // 27: google.cloud.retail.v2.LocalInventory.AttributesEntry
	(*timestamppb.Timestamp)(nil),       // 28: google.protobuf.Timestamp
}
var file_google_cloud_retail_v2_common_proto_depIdxs = []int32{
	16, // 0: google.cloud.retail.v2.Condition.query_terms:type_name -> google.cloud.retail.v2.Condition.QueryTerm
	17, // 1: google.cloud.retail.v2.Condition.active_time_range:type_name -> google.cloud.retail.v2.Condition.TimeRange
	18, // 2: google.cloud.retail.v2.Rule.boost_action:type_name -> google.cloud.retail.v2.Rule.BoostAction
	20, // 3: google.cloud.retail.v2.Rule.redirect_action:type_name -> google.cloud.retail.v2.Rule.RedirectAction
	22, // 4: google.cloud.retail.v2.Rule.oneway_synonyms_action:type_name -> google.cloud.retail.v2.Rule.OnewaySynonymsAction
	23, // 5: google.cloud.retail.v2.Rule.do_not_associate_action:type_name -> google.cloud.retail.v2.Rule.DoNotAssociateAction
	24, // 6: google.cloud.retail.v2.Rule.replacement_action:type_name -> google.cloud.retail.v2.Rule.ReplacementAction
	25, // 7: google.cloud.retail.v2.Rule.ignore_action:type_name -> google.cloud.retail.v2.Rule.IgnoreAction
	19, // 8: google.cloud.retail.v2.Rule.filter_action:type_name -> google.cloud.retail.v2.Rule.FilterAction
	21, // 9: google.cloud.retail.v2.Rule.twoway_synonyms_action:type_name -> google.cloud.retail.v2.Rule.TwowaySynonymsAction
	4,  // 10: google.cloud.retail.v2.Rule.condition:type_name -> google.cloud.retail.v2.Condition
	28, // 11: google.cloud.retail.v2.PriceInfo.price_effective_time:type_name -> google.protobuf.Timestamp
	28, // 12: google.cloud.retail.v2.PriceInfo.price_expire_time:type_name -> google.protobuf.Timestamp
	26, // 13: google.cloud.retail.v2.PriceInfo.price_range:type_name -> google.cloud.retail.v2.PriceInfo.PriceRange
	12, // 14: google.cloud.retail.v2.LocalInventory.price_info:type_name -> google.cloud.retail.v2.PriceInfo
	27, // 15: google.cloud.retail.v2.LocalInventory.attributes:type_name -> google.cloud.retail.v2.LocalInventory.AttributesEntry
	28, // 16: google.cloud.retail.v2.Condition.TimeRange.start_time:type_name -> google.protobuf.Timestamp
	28, // 17: google.cloud.retail.v2.Condition.TimeRange.end_time:type_name -> google.protobuf.Timestamp
	11, // 18: google.cloud.retail.v2.PriceInfo.PriceRange.price:type_name -> google.cloud.retail.v2.Interval
	11, // 19: google.cloud.retail.v2.PriceInfo.PriceRange.original_price:type_name -> google.cloud.retail.v2.Interval
	8,  // 20: google.cloud.retail.v2.LocalInventory.AttributesEntry.value:type_name -> google.cloud.retail.v2.CustomAttribute
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2_common_proto_init() }
func file_google_cloud_retail_v2_common_proto_init() {
	if File_google_cloud_retail_v2_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_retail_v2_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Audience); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColorInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FulfillmentInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Image); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Interval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rating); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocalInventory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Condition_QueryTerm); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Condition_TimeRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule_BoostAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule_FilterAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule_RedirectAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule_TwowaySynonymsAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule_OnewaySynonymsAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule_DoNotAssociateAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule_ReplacementAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule_IgnoreAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_common_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriceInfo_PriceRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_retail_v2_common_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Rule_BoostAction_)(nil),
		(*Rule_RedirectAction_)(nil),
		(*Rule_OnewaySynonymsAction_)(nil),
		(*Rule_DoNotAssociateAction_)(nil),
		(*Rule_ReplacementAction_)(nil),
		(*Rule_IgnoreAction_)(nil),
		(*Rule_FilterAction_)(nil),
		(*Rule_TwowaySynonymsAction_)(nil),
	}
	file_google_cloud_retail_v2_common_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_google_cloud_retail_v2_common_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Interval_Minimum)(nil),
		(*Interval_ExclusiveMinimum)(nil),
		(*Interval_Maximum)(nil),
		(*Interval_ExclusiveMaximum)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2_common_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_retail_v2_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_retail_v2_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_retail_v2_common_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2_common_proto = out.File
	file_google_cloud_retail_v2_common_proto_rawDesc = nil
	file_google_cloud_retail_v2_common_proto_goTypes = nil
	file_google_cloud_retail_v2_common_proto_depIdxs = nil
}
