// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file primitivesCdrAux.hpp
 * This source file contains some definitions of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__PRIMITIVESCDRAUX_HPP
#define FAST_DDS_GENERATED__PRIMITIVESCDRAUX_HPP

#include "primitives.hpp"
constexpr uint32_t ULongStruct_max_cdr_typesize {8UL};
constexpr uint32_t ULongStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t FloatStruct_max_cdr_typesize {8UL};
constexpr uint32_t FloatStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t LongDoubleStruct_max_cdr_typesize {24UL};
constexpr uint32_t LongDoubleStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t OctetStruct_max_cdr_typesize {5UL};
constexpr uint32_t OctetStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t Uint8Struct_max_cdr_typesize {5UL};
constexpr uint32_t Uint8Struct_max_key_cdr_typesize {0UL};

constexpr uint32_t Int16Struct_max_cdr_typesize {6UL};
constexpr uint32_t Int16Struct_max_key_cdr_typesize {0UL};

constexpr uint32_t LongStruct_max_cdr_typesize {8UL};
constexpr uint32_t LongStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t Int8Struct_max_cdr_typesize {5UL};
constexpr uint32_t Int8Struct_max_key_cdr_typesize {0UL};

constexpr uint32_t Uint32Struct_max_cdr_typesize {8UL};
constexpr uint32_t Uint32Struct_max_key_cdr_typesize {0UL};

constexpr uint32_t Int64Struct_max_cdr_typesize {16UL};
constexpr uint32_t Int64Struct_max_key_cdr_typesize {0UL};

constexpr uint32_t ShortStruct_max_cdr_typesize {6UL};
constexpr uint32_t ShortStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t Uint16Struct_max_cdr_typesize {6UL};
constexpr uint32_t Uint16Struct_max_key_cdr_typesize {0UL};

constexpr uint32_t UShortStruct_max_cdr_typesize {6UL};
constexpr uint32_t UShortStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t DoubleStruct_max_cdr_typesize {16UL};
constexpr uint32_t DoubleStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t ULongLongStruct_max_cdr_typesize {16UL};
constexpr uint32_t ULongLongStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t BooleanStruct_max_cdr_typesize {5UL};
constexpr uint32_t BooleanStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t CharStruct_max_cdr_typesize {5UL};
constexpr uint32_t CharStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t WCharStruct_max_cdr_typesize {6UL};
constexpr uint32_t WCharStruct_max_key_cdr_typesize {0UL};

constexpr uint32_t Uint64Struct_max_cdr_typesize {16UL};
constexpr uint32_t Uint64Struct_max_key_cdr_typesize {0UL};

constexpr uint32_t Int32Struct_max_cdr_typesize {8UL};
constexpr uint32_t Int32Struct_max_key_cdr_typesize {0UL};

constexpr uint32_t LongLongStruct_max_cdr_typesize {16UL};
constexpr uint32_t LongLongStruct_max_key_cdr_typesize {0UL};


namespace eprosima {
namespace fastcdr {

class Cdr;
class CdrSizeCalculator;

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ShortStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const UShortStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const LongStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ULongStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const LongLongStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ULongLongStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FloatStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const DoubleStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const LongDoubleStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const BooleanStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const OctetStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const CharStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const WCharStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const Int8Struct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const Uint8Struct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const Int16Struct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const Uint16Struct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const Int32Struct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const Uint32Struct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const Int64Struct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const Uint64Struct& data);


} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__PRIMITIVESCDRAUX_HPP

