{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetColor: TAbstractColorNode;
    procedure SetColor(const Value: TAbstractColorNode);
    function GetNormal: TAbstractNormalNode;
    procedure SetNormal(const Value: TAbstractNormalNode);
    function GetTexCoord: TAbstractTextureCoordinateNode;
    procedure SetTexCoord(const Value: TAbstractTextureCoordinateNode);
    function GetYScale: Single;
    procedure SetYScale(const Value: Single);
    function GetCcw: Boolean;
    procedure SetCcw(const Value: Boolean);
    function GetColorPerVertex: Boolean;
    procedure SetColorPerVertex(const Value: Boolean);
    function GetCreaseAngle: Double;
    procedure SetCreaseAngle(const Value: Double);
    function GetGeoGridOrigin: TVector3Double;
    procedure SetGeoGridOrigin(const Value: TVector3Double);
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
    function GetNormalPerVertex: Boolean;
    procedure SetNormalPerVertex(const Value: Boolean);
    function GetXDimension: Integer;
    procedure SetXDimension(const Value: Integer);
    function GetXSpacing: Double;
    procedure SetXSpacing(const Value: Double);
    function GetZDimension: Integer;
    procedure SetZDimension(const Value: Integer);
    function GetZSpacing: Double;
    procedure SetZSpacing(const Value: Double);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_height: TMFDoubleEvent;
    {  }
    public property EventSet_height: TMFDoubleEvent read FEventSet_height;

    strict private FFdColor: TSFNode;
    { Internal wrapper for property @code(Color). This wrapper API may change, we advise to access simpler @code(Color) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdColor: TSFNode read FFdColor;
    {  }
    property Color: TAbstractColorNode read GetColor write SetColor;

    strict private FFdNormal: TSFNode;
    { Internal wrapper for property @code(Normal). This wrapper API may change, we advise to access simpler @code(Normal) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormal: TSFNode read FFdNormal;
    {  }
    property Normal: TAbstractNormalNode read GetNormal write SetNormal;

    strict private FFdTexCoord: TSFNode;
    { Internal wrapper for property @code(TexCoord). This wrapper API may change, we advise to access simpler @code(TexCoord) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTexCoord: TSFNode read FFdTexCoord;
    {  }
    property TexCoord: TAbstractTextureCoordinateNode read GetTexCoord write SetTexCoord;

    strict private FFdYScale: TSFFloat;
    { Internal wrapper for property @code(YScale). This wrapper API may change, we advise to access simpler @code(YScale) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdYScale: TSFFloat read FFdYScale;
    {  }
    property YScale: Single read GetYScale write SetYScale;

    strict private FFdCcw: TSFBool;
    { Internal wrapper for property @code(Ccw). This wrapper API may change, we advise to access simpler @code(Ccw) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCcw: TSFBool read FFdCcw;
    {  }
    property Ccw: Boolean read GetCcw write SetCcw;

    strict private FFdColorPerVertex: TSFBool;
    { Internal wrapper for property @code(ColorPerVertex). This wrapper API may change, we advise to access simpler @code(ColorPerVertex) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdColorPerVertex: TSFBool read FFdColorPerVertex;
    {  }
    property ColorPerVertex: Boolean read GetColorPerVertex write SetColorPerVertex;

    strict private FFdCreaseAngle: TSFDouble;
    { Internal wrapper for property @code(CreaseAngle). This wrapper API may change, we advise to access simpler @code(CreaseAngle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCreaseAngle: TSFDouble read FFdCreaseAngle;
    {  }
    property CreaseAngle: Double read GetCreaseAngle write SetCreaseAngle;

    strict private FFdGeoGridOrigin: TSFVec3d;
    { Internal wrapper for property @code(GeoGridOrigin). This wrapper API may change, we advise to access simpler @code(GeoGridOrigin) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoGridOrigin: TSFVec3d read FFdGeoGridOrigin;
    {  }
    property GeoGridOrigin: TVector3Double read GetGeoGridOrigin write SetGeoGridOrigin;

    strict private FFdGeoOrigin: TSFNode;
    { Internal wrapper for property @code(GeoOrigin). This wrapper API may change, we advise to access simpler @code(GeoOrigin) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoOrigin: TSFNode read FFdGeoOrigin;
    {  }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;

    strict private FFdGeoSystem: TMFString;
    { Internal wrapper for property @code(GeoSystem). This wrapper API may change, we advise to access simpler @code(GeoSystem) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoSystem: TMFString read FFdGeoSystem;
    {  }
    procedure SetGeoSystem(const Value: array of string); overload;
    {  }
    procedure SetGeoSystem(const Value: TCastleStringList); overload;

    strict private FFdHeight: TMFDouble;
    { Internal wrapper for property @code(Height). This wrapper API may change, we advise to access simpler @code(Height) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeight: TMFDouble read FFdHeight;
    {  }
    procedure SetHeight(const Value: array of Double); overload;
    {  }
    procedure SetHeight(const Value: TDoubleList); overload;

    strict private FFdNormalPerVertex: TSFBool;
    { Internal wrapper for property @code(NormalPerVertex). This wrapper API may change, we advise to access simpler @code(NormalPerVertex) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalPerVertex: TSFBool read FFdNormalPerVertex;
    {  }
    property NormalPerVertex: Boolean read GetNormalPerVertex write SetNormalPerVertex;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @code(Solid). This wrapper API may change, we advise to access simpler @code(Solid) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdXDimension: TSFInt32;
    { Internal wrapper for property @code(XDimension). This wrapper API may change, we advise to access simpler @code(XDimension) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdXDimension: TSFInt32 read FFdXDimension;
    {  }
    property XDimension: Integer read GetXDimension write SetXDimension;

    strict private FFdXSpacing: TSFDouble;
    { Internal wrapper for property @code(XSpacing). This wrapper API may change, we advise to access simpler @code(XSpacing) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdXSpacing: TSFDouble read FFdXSpacing;
    {  }
    property XSpacing: Double read GetXSpacing write SetXSpacing;

    strict private FFdZDimension: TSFInt32;
    { Internal wrapper for property @code(ZDimension). This wrapper API may change, we advise to access simpler @code(ZDimension) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdZDimension: TSFInt32 read FFdZDimension;
    {  }
    property ZDimension: Integer read GetZDimension write SetZDimension;

    strict private FFdZSpacing: TSFDouble;
    { Internal wrapper for property @code(ZSpacing). This wrapper API may change, we advise to access simpler @code(ZSpacing) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdZSpacing: TSFDouble read FFdZSpacing;
    {  }
    property ZSpacing: Double read GetZSpacing write SetZSpacing;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoElevationGridNode ----------------------------------------------- }

function TGeoElevationGridNode.GetColor: TAbstractColorNode;
begin
  if FdColor.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColor.Value)
  else
    Result := nil;
end;

procedure TGeoElevationGridNode.SetColor(const Value: TAbstractColorNode);
begin
  FdColor.Send(Value);
end;

function TGeoElevationGridNode.GetNormal: TAbstractNormalNode;
begin
  if FdNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdNormal.Value)
  else
    Result := nil;
end;

procedure TGeoElevationGridNode.SetNormal(const Value: TAbstractNormalNode);
begin
  FdNormal.Send(Value);
end;

function TGeoElevationGridNode.GetTexCoord: TAbstractTextureCoordinateNode;
begin
  if FdTexCoord.Value is TAbstractTextureCoordinateNode then
    Result := TAbstractTextureCoordinateNode(FdTexCoord.Value)
  else
    Result := nil;
end;

procedure TGeoElevationGridNode.SetTexCoord(const Value: TAbstractTextureCoordinateNode);
begin
  FdTexCoord.Send(Value);
end;

function TGeoElevationGridNode.GetYScale: Single;
begin
  Result := FdYScale.Value;
end;

procedure TGeoElevationGridNode.SetYScale(const Value: Single);
begin
  FdYScale.Send(Value);
end;

function TGeoElevationGridNode.GetCcw: Boolean;
begin
  Result := FdCcw.Value;
end;

procedure TGeoElevationGridNode.SetCcw(const Value: Boolean);
begin
  FdCcw.Send(Value);
end;

function TGeoElevationGridNode.GetColorPerVertex: Boolean;
begin
  Result := FdColorPerVertex.Value;
end;

procedure TGeoElevationGridNode.SetColorPerVertex(const Value: Boolean);
begin
  FdColorPerVertex.Send(Value);
end;

function TGeoElevationGridNode.GetCreaseAngle: Double;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TGeoElevationGridNode.SetCreaseAngle(const Value: Double);
begin
  FdCreaseAngle.Send(Value);
end;

function TGeoElevationGridNode.GetGeoGridOrigin: TVector3Double;
begin
  Result := FdGeoGridOrigin.Value;
end;

procedure TGeoElevationGridNode.SetGeoGridOrigin(const Value: TVector3Double);
begin
  FdGeoGridOrigin.Send(Value);
end;

function TGeoElevationGridNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoElevationGridNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoElevationGridNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoElevationGridNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoElevationGridNode.SetHeight(const Value: array of Double);
begin
  FdHeight.Send(Value);
end;

procedure TGeoElevationGridNode.SetHeight(const Value: TDoubleList);
begin
  FdHeight.Send(Value);
end;

function TGeoElevationGridNode.GetNormalPerVertex: Boolean;
begin
  Result := FdNormalPerVertex.Value;
end;

procedure TGeoElevationGridNode.SetNormalPerVertex(const Value: Boolean);
begin
  FdNormalPerVertex.Send(Value);
end;

function TGeoElevationGridNode.GetXDimension: Integer;
begin
  Result := FdXDimension.Value;
end;

procedure TGeoElevationGridNode.SetXDimension(const Value: Integer);
begin
  FdXDimension.Send(Value);
end;

function TGeoElevationGridNode.GetXSpacing: Double;
begin
  Result := FdXSpacing.Value;
end;

procedure TGeoElevationGridNode.SetXSpacing(const Value: Double);
begin
  FdXSpacing.Send(Value);
end;

function TGeoElevationGridNode.GetZDimension: Integer;
begin
  Result := FdZDimension.Value;
end;

procedure TGeoElevationGridNode.SetZDimension(const Value: Integer);
begin
  FdZDimension.Send(Value);
end;

function TGeoElevationGridNode.GetZSpacing: Double;
begin
  Result := FdZSpacing.Value;
end;

procedure TGeoElevationGridNode.SetZSpacing(const Value: Double);
begin
  FdZSpacing.Send(Value);
end;

class function TGeoElevationGridNode.ClassX3DType: String;
begin
  Result := 'GeoElevationGrid';
end;

procedure TGeoElevationGridNode.CreateNode;
begin
  inherited;

  FEventSet_height := TMFDoubleEvent.Create(Self, 'set_height', true);
  AddEvent(FEventSet_height);

  FFdColor := TSFNode.Create(Self, True, 'color', [TAbstractColorNode]);
   FdColor.ChangeAlways := chGeometry;
  AddField(FFdColor);

  FFdNormal := TSFNode.Create(Self, True, 'normal', [TAbstractNormalNode]);
   FdNormal.ChangeAlways := chGeometry;
  AddField(FFdNormal);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TAbstractTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chGeometry;
  AddField(FFdTexCoord);

  FFdYScale := TSFFloat.Create(Self, True, 'yScale', 1.0);
   FdYScale.ChangeAlways := chGeometry;
   FdYScale.MustBeNonnegative := true;
  AddField(FFdYScale);

  FFdCcw := TSFBool.Create(Self, False, 'ccw', true);
   FdCcw.ChangeAlways := chGeometry;
  AddField(FFdCcw);

  FFdColorPerVertex := TSFBool.Create(Self, False, 'colorPerVertex', true);
   FdColorPerVertex.ChangeAlways := chGeometry;
  AddField(FFdColorPerVertex);

  FFdCreaseAngle := TSFDouble.Create(Self, False, 'creaseAngle', 0);
   FdCreaseAngle.ChangeAlways := chGeometry;
   FdCreaseAngle.Angle := true;
  AddField(FFdCreaseAngle);

  FFdGeoGridOrigin := TSFVec3d.Create(Self, False, 'geoGridOrigin', Vector3Double(0, 0, 0));
   FdGeoGridOrigin.ChangeAlways := chGeometry;
  AddField(FFdGeoGridOrigin);

  FFdGeoOrigin := TSFNode.Create(Self, False, 'geoOrigin', [TGeoOriginNode]);
   FdGeoOrigin.ChangeAlways := chGeometry;
  AddField(FFdGeoOrigin);

  FFdGeoSystem := TMFString.Create(Self, False, 'geoSystem', ['GD','WE']);
   FdGeoSystem.ChangeAlways := chGeometry;
  AddField(FFdGeoSystem);

  FFdHeight := TMFDouble.Create(Self, False, 'height', [0, 0]);
   FdHeight.ChangeAlways := chGeometry;
  AddField(FFdHeight);

  FFdNormalPerVertex := TSFBool.Create(Self, False, 'normalPerVertex', true);
   FdNormalPerVertex.ChangeAlways := chGeometry;
  AddField(FFdNormalPerVertex);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);

  FFdXDimension := TSFInt32.Create(Self, False, 'xDimension', 0);
   FdXDimension.ChangeAlways := chGeometry;
   FdXDimension.MustBeNonnegative := true;
  AddField(FFdXDimension);

  FFdXSpacing := TSFDouble.Create(Self, False, 'xSpacing', 1.0);
   FdXSpacing.ChangeAlways := chGeometry;
  AddField(FFdXSpacing);

  FFdZDimension := TSFInt32.Create(Self, False, 'zDimension', 0);
   FdZDimension.ChangeAlways := chGeometry;
   FdZDimension.MustBeNonnegative := true;
  AddField(FFdZDimension);

  FFdZSpacing := TSFDouble.Create(Self, False, 'zSpacing', 1.0);
   FdZSpacing.ChangeAlways := chGeometry;
  AddField(FFdZSpacing);
end;

{$endif read_implementation}
