/*
 Original methods of Ruby-DCL
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_uemrkz(obj, n, upx, upy, z, itype, index, rsize)
    VALUE obj, n, upx, upy, z, itype, index, rsize;
{
    integer i_n;
    real *i_upx;
    real *i_upy;
    real *i_z;
    integer i_itype;
    integer i_index;
    real i_rsize;

    integer idx,one,k;
    logical lmiss;
    real rmiss;
    char *str;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    if (TYPE(z) == T_FLOAT) {
      z = rb_Array(z);
    }
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);
    i_z = dcl_obj2crealary(z);

    one = 1;
    str = "LMISS";
    gllget_(str, &lmiss, (ftnlen)strlen(str));
    str = "RMISS";
    glrget_(str, &rmiss, (ftnlen)strlen(str));
    for(k=0 ; k<i_n; k++){
	if( !lmiss || i_z[k] != rmiss ){
	    idx = (iueton_(i_z+k)/1000)*10 + i_index ;
	    uumrkz_(&one, i_upx+k, i_upy+k, &i_itype, &idx, &i_rsize);
        }
    }

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;
}

void
init_rubydcloriginal(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "uemrkz", dcl_uemrkz, 7);
}
