# -*- C -*-
# USAGE: ruby dcl_narray_funcs.rb
# --> creates ../dcl_narray_funcs.c

require "erb"

erbsrc = <<EOS
<% rr2rr_funcs = %w[ stftrf stitrf stfpr2 stipr2 mpfcyl mpicyl mpfmer mpimer mpfmwd mpimwd mpfmwl mpimwl mpfhmr mpihmr mpfek6 mpiek6 mpfktd mpiktd mpfcon mpicon mpfcoa mpicoa mpfcoc mpicoc mpfbon mpibon mpfotg mpiotg mpfpst mpipst mpfazm mpiazm mpfaza mpiaza ct2pc ct2cp ct2ec ct2bc ct2hc ct2ch ]
%>
/*
 * Original methods of Ruby-DCL
 *
 * Alert: DO NOT EDIT THIS FILE!!!
 *   This file was automatically generated by GenWrapper/dcl_narray_funcs.rb 
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

/* for compatibility with ruby 1.6 */
#ifndef RARRAY_LEN
#define RARRAY_LEN(a) (RARRAY(a)->len)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);

<% rr2rr_funcs.each do |func| %>
extern int <%= func%>_(real*,real*,real*,real*);
<% end %>

extern VALUE mDCL;

/* driver of real*2->real*2 functions such as STFTRF
 */
static VALUE
dcl_rr2rr_num(obj, ux, uy, func)
    VALUE obj, ux, uy;
    int (*func)(real*,real*,real*,real*);
{
    real i_ux;
    real i_uy;
    real o_vx;
    real o_vy;
    VALUE vx;
    VALUE vy;

    if (TYPE(ux) != T_FLOAT) {
      ux = rb_funcall(ux, rb_intern("to_f"), 0);
    }
    if (TYPE(uy) != T_FLOAT) {
      uy = rb_funcall(uy, rb_intern("to_f"), 0);
    }

    i_ux = (real)NUM2DBL(ux);
    i_uy = (real)NUM2DBL(uy);


    (*func)(&i_ux, &i_uy, &o_vx, &o_vy);

    vx = rb_float_new((double)o_vx);
    vy = rb_float_new((double)o_vy);


    return rb_ary_new3(2, vx, vy);

}

/* driver of real*2->real*2 functions such as STFTRF
 */
static VALUE
dcl_rr2rr_na(obj, p, q, func)
    VALUE obj, p, q;
    int (*func)(real*,real*,real*,real*);
{
    VALUE r, s;  // return value
    real *i_p, *i_q;
    real *i_r, *i_s;
    size_t len,j,lenq;

    i_p = dcl_obj2crealary(p);
    i_q = dcl_obj2crealary(q);
    len  = (TYPE(p)==T_ARRAY) ? RARRAY_LEN(p) : NA_TOTAL(p) ;
    lenq = (TYPE(q)==T_ARRAY) ? RARRAY_LEN(q) : NA_TOTAL(q) ;
    if (len != lenq) {
         rb_raise(rb_eArgError, "lengths of the 1st & 2nd args do not agree");
    }

    r = na_make_object(NA_SFLOAT, 1, &len, cNArray);
    s = na_make_object(NA_SFLOAT, 1, &len, cNArray);
    i_r = NA_PTR_TYPE(r,real*);
    i_s = NA_PTR_TYPE(s,real*);

    for(j=0; j<len; j++){
	(*func)(i_p+j, i_q+j, i_r+j, i_s+j);
    }

    return rb_ary_new3(2, r, s);
}

static VALUE
dcl_rr2rr(obj, p, q, func)
    VALUE obj, p, q;
    int (*func)(real*,real*,real*,real*);
{
    switch (TYPE(p)){
    case T_DATA:
    case T_ARRAY:
	return( dcl_rr2rr_na(obj, p, q, func) );
    default:
	return( dcl_rr2rr_num(obj, p, q, func) );
    }
}


<% rr2rr_funcs.each do |func| %>
static VALUE
dcl_<%= func%>(obj, p, q)
    VALUE obj, p, q;
{   return( dcl_rr2rr(obj, p, q, &<%= func%>_) );  }
<% end %>

void
init_narrayed_funcs(mDCL)
VALUE mDCL;
{
<% rr2rr_funcs.each do |func| %>
    rb_define_module_function(mDCL, "<%= func%>", dcl_<%= func%>, 2);
<% end %>
}

EOS

File.open('../dcl_narrayed_funcs.c','w'){|f| f.print(ERB.new(erbsrc).result)}


