!------------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wt_module ƥȥץ
!
!   wt_KxRGrad_wt, xyr_KGrad_wt, wt_QOperator_wt Υƥ
!
!  2008/01/02  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_derivative4

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=3.0d0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Data
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Psi
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_KxRGrad
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_KGrad
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_QOperator

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -10

  integer, parameter :: n=3

  call MessageNotify('M','wu_test_derivative4', &
       'wu_module derivative function test #4')

  call wu_initial(im,jm,km,nm,lm,ra)

  ! -----------------  1 --------------------
  ! r**2 Y_1^1
  xyr_Psi = xyr_rad**n * cos(xyr_lat)*sin(xyr_lon)
  xyr_KxRGrad = xyr_Rad**n * cos(xyr_lat)*cos(xyr_lon)
  ! k  r**n Y_1^1 = (n-1)*r**(n-1)* Y_2^1
  xyr_KGrad = (n-1)*xyr_rad**(n-1)* cos(xyr_lat)*sin(xyr_lat)*sin(xyr_lon)
  ! Q r**n Y_1^1 = -3*(n-1)*r**(n-1)* Y_2^1
  xyr_QOperator = &
        - 3.0d0*(n-1)*xyr_rad**(n-1)* cos(xyr_lat)*sin(xyr_lat)*sin(xyr_lon)

  call MessageNotify('M','wu_test_derivative4', 'Y_1^1 field')
  call checkresult

  ! -----------------  2 --------------------
  ! Y_2^1
  xyr_Psi = 3.0d0*cos(xyr_lat)*sin(xyr_lat) * sin(xyr_lon) * xyr_Rad**2
  ! Y_2^1
  xyr_KxRGrad = &
      3.0d0*cos(xyr_lat)*sin(xyr_lat) * cos(xyr_lon) * xyr_Rad**2
  ! kr^2 Y_2^1 = 3r Y_1^1
  xyr_KGrad = 3.0d0*xyr_Rad*cos(2.0d0*xyr_Lat)*cos(xyr_Lat)*sin(xyr_Lon) &
             +3.0d0*xyr_Rad*sin(2.0d0*xyr_Lat)*sin(xyr_Lat)*sin(xyr_Lon)
  xyr_QOperator = - 9.0d0*cos(xyr_lat)*sin(xyr_lon)*xyr_rad
!!$  xyr_QOperator = (12*sin(xyr_lat)**2 - 69.0/10.0)*cos(xyr_lat)*sin(xyr_lon)*xyr_rad

  call MessageNotify('M','wu_test_derivative4', 'Y_2^1 field')
  call checkresult


  call MessageNotify('M','wu_test_derivative4', &
       'wu_module derivative function test #4 succeeded!')

contains

  subroutine checkresult
    xyr_Data = xyr_wu(wu_KxRGrad_wu(wu_xyr(xyr_Psi)))
    call check3d(xyr_KxRGrad, xyr_Data, 'Checking k x r grad ')

    xyr_Data = xyr_KGrad_wu(wu_xyr(xyr_Psi))
    call check3d(xyr_KGrad, xyr_Data, 'Checking k grad ')

    xyr_Data = xyr_wu(wu_QOperator_wu(wu_xyr(xyr_Psi)))
    call check3d(xyr_QOperator, xyr_Data, 'Checking Q operator ')
  end subroutine checkresult

  subroutine check3d(sol, ans, mess)
    real(8) :: sol(:,:,:)
    real(8) :: ans(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d


end program wu_test_derivative4

