#
# jump2.rb
#   $Id$
#

require "numru/dcl"

include NumRu
include Math

nmax = 100

x = NArray.sfloat(nmax)
y = NArray.sfloat(nmax)

#-- data ----
r  = 0.2
r0 = 0.0
for i in 0..nmax-1
  r = 3.6*r*(1-r)
  r0 += r*4 - 2.58
  x2 = (i-49.0)**2
  rexp = 4.0*(i+1)/nmax
  x[i] = 10**rexp
  y[i] = 1.0e5*exp(-x2) + 10.0**r0
end

y[19] = 1.0e4
y[39] = 2.0e3
y[64] = 3.0e4
y[69] = 5.0e2

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

DCL::grswnd(1.0e0, 1.0e4, 1.0e-1, 1.0e6)
DCL::grsvpt(0.2,  0.8,   0.2,  0.8)
DCL::grstrn(4)
DCL::grstrf

DCL::ussttl('FREQUENCY', '/s', 'POWER', 'm\^2/s\^2')
DCL::usdaxs

DCL::uulin(x, y)

DCL::grcls

